<?php
/**
 * Side Area Mini-cart
 *
 * Contains the markup for the mini-cart, used by the sidearea cart
 *
 * @author 	Greatives Team
 * @version     1.0.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

$cart_default_classes = array( 'grve-woo-btn', 'grve-view-cart-btn', 'grve-link-text' );
$cart_btn_classes = impeka_grve_woo_mini_cart_button_colors(
	array(
		'type' => impeka_grve_option( 'mini_cart_view_button_type' ),
		'shape' => impeka_grve_option( 'mini_cart_view_button_shape' ),
		'color' => impeka_grve_option( 'mini_cart_view_button_color' ),
		'hover_color' => impeka_grve_option( 'mini_cart_view_button_hover_color' ),
	)
);
$cart_btn_class_string = implode( ' ', array_merge( $cart_default_classes, $cart_btn_classes ) );

$checkout_default_classes = array( 'grve-woo-btn', 'grve-checkout-btn', 'grve-link-text' );
$checkout_btn_classes = impeka_grve_woo_mini_cart_button_colors(
	array(
		'type' => impeka_grve_option( 'mini_cart_checkout_button_type' ),
		'shape' => impeka_grve_option( 'mini_cart_checkout_button_shape' ),
		'color' => impeka_grve_option( 'mini_cart_checkout_button_color' ),
		'hover_color' => impeka_grve_option( 'mini_cart_checkout_button_hover_color' ),
	)
);
$checkout_btn_class_string = implode( ' ', array_merge( $checkout_default_classes, $checkout_btn_classes ) );

?>

<?php do_action( 'woocommerce_before_mini_cart' ); ?>


<ul class="grve-mini-cart <?php echo esc_attr( $args['list_class'] ); ?>">

	<?php if ( ! WC()->cart->is_empty() ) : ?>

		<?php
			foreach ( WC()->cart->get_cart() as $cart_item_key => $cart_item ) {
				$_product     = apply_filters( 'woocommerce_cart_item_product', $cart_item['data'], $cart_item, $cart_item_key );
				$product_id   = apply_filters( 'woocommerce_cart_item_product_id', $cart_item['product_id'], $cart_item, $cart_item_key );

				if ( $_product && $_product->exists() && $cart_item['quantity'] > 0 && apply_filters( 'woocommerce_widget_cart_item_visible', true, $cart_item, $cart_item_key ) ) {

					$product_name      = apply_filters( 'woocommerce_cart_item_name', $_product->get_name(), $cart_item, $cart_item_key );
					$thumbnail         = apply_filters( 'woocommerce_cart_item_thumbnail', $_product->get_image(), $cart_item, $cart_item_key );
					$product_price     = apply_filters( 'woocommerce_cart_item_price', WC()->cart->get_product_price( $_product ), $cart_item, $cart_item_key );
					$product_permalink = apply_filters( 'woocommerce_cart_item_permalink', $_product->is_visible() ? $_product->get_permalink( $cart_item ) : '', $cart_item, $cart_item_key );
					?>
					<li class="grve-cart-item grve-border">
						<?php
						echo apply_filters(
							'woocommerce_cart_item_remove_link',
							sprintf(
								'<a href="%s" class="remove remove_from_cart_button" aria-label="%s" data-product_id="%s" data-cart_item_key="%s" data-product_sku="%s">&times;</a>',
								esc_url( wc_get_cart_remove_url( $cart_item_key ) ),
								esc_attr__( 'Remove this item', 'impeka' ),
								esc_attr( $product_id ),
								esc_attr( $cart_item_key ),
								esc_attr( $_product->get_sku() )
							),
							$cart_item_key
						);
						?>
						<a class="grve-product-thumb" href="<?php echo esc_url( $product_permalink ); ?>">
							<?php echo str_replace( array( 'http:', 'https:' ), '', $thumbnail ); ?>
						</a>
						<div class="cart-item-content">
							<a class="grve-link-text" href="<?php echo esc_url( $product_permalink ); ?>"><?php echo wp_kses_post( $product_name ); ?></a>
							<?php echo wc_get_formatted_cart_item_data( $cart_item ); ?>
							<?php echo apply_filters( 'woocommerce_widget_cart_item_quantity', '<span>' . sprintf( '%s &times; %s', $cart_item['quantity'], $product_price ) . '</span>', $cart_item, $cart_item_key ); ?>
						</div>
					</li>
					<?php
				}
			}
		?>

	<?php else : ?>

		<li class="grve-empty-cart">
			<div class="grve-h6"><?php esc_html_e( 'No products in the cart.', 'impeka' ); ?></div>
			<a class="grve-link-text" href="<?php echo esc_url( apply_filters( 'woocommerce_return_to_shop_redirect', wc_get_page_permalink( 'shop' ) ) ); ?>"><?php esc_html_e( 'Return to shop', 'impeka' ) ?></a>
		</li>

	<?php endif; ?>

</ul><!-- end product list -->


<?php if ( ! WC()->cart->is_empty() ) : ?>
<div class="grve-buttons-wrapper">
	<div class="grve-cart-total grve-h6"><?php esc_html_e( 'Subtotal', 'impeka' ); ?> : <?php echo WC()->cart->get_cart_subtotal(); ?></div>

	<?php do_action( 'woocommerce_widget_shopping_cart_before_buttons' ); ?>

	<div class="grve-total-btn">
		<a class="<?php echo esc_attr( $cart_btn_class_string ); ?>" href="<?php echo esc_url( wc_get_cart_url() ); ?>"><span><?php esc_html_e( 'View cart', 'impeka' ); ?></span></a>
		<a class="<?php echo esc_attr( $checkout_btn_class_string ); ?>" href="<?php echo esc_url( wc_get_checkout_url() ); ?>"><span><?php esc_html_e( 'Checkout', 'impeka' ); ?></span></a>
	</div>
</div>
<?php endif; ?>

<?php do_action( 'woocommerce_after_mini_cart' );

//Omit closing PHP tag to avoid accidental whitespace output errors.
