<?php
/*
*	Template Loop Search Content Small
*
* 	@version	1.0
* 	@author		Greatives Team
* 	@URI		https://greatives.eu
*/

$search_params = isset( $args ) ? $args : array();

$heading = impeka_grve_array_value( $search_params, 'heading' );
$heading_tag = impeka_grve_array_value( $search_params, 'heading_tag', 'h4' );
$excerpt_length = impeka_grve_array_value( $search_params, 'excerpt_length' );
$excerpt_more = impeka_grve_array_value( $search_params, 'excerpt_more' );
$excerpt_more_text = impeka_grve_array_value( $search_params, 'excerpt_more_text' );
$show_image = impeka_grve_array_value( $search_params, 'show_image' );
$image_size = impeka_grve_array_value( $search_params, 'image_size' );
$shadow = impeka_grve_array_value( $search_params, 'shadow', 'none' );
$radius = impeka_grve_array_value( $search_params, 'radius', 'none' );


?>
<div class="grve-post-item grve-small-style-1 grve-format-standard">
	<div class="grve-post-item-inner">
		<?php if ( 'yes' == $show_image && has_post_thumbnail() ) { ?>
		<div class="grve-post-media grve-radius-<?php echo esc_attr( $radius ); ?> grve-shadow-<?php echo esc_attr( $shadow ); ?>">
			<a href="<?php echo esc_url( get_permalink() ); ?>">
			<?php impeka_grve_the_post_thumbnail( $image_size, array( 'data-column-space' => '100' ) ); ?>
			</a>
		</div>
		<?php }?>
		<div class="grve-post-content">
			<?php the_title( '<a href="' . esc_url( get_permalink() ) . '" rel="bookmark"><' . tag_escape( $heading_tag ) . ' class="grve-post-title grve-text-hover-primary-1 grve-' . esc_attr( $heading ) . '">', '</' . tag_escape( $heading_tag ) . '></a>' ); ?>
			<div class="grve-post-exerpt">
				<?php echo impeka_grve_excerpt( $excerpt_length, $excerpt_more, $excerpt_more_text ); ?>
			</div>
		</div>
	</div>
</div>