<?php
/*
*	Social Bar Layout 1
*
* 	@version	1.0
* 	@author		Greatives Team
* 	@URI		https://greatives.eu
*/

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

$social_params = isset( $args ) ? $args : array();

$post_type = impeka_grve_array_value( $social_params, 'post_type', 'post' );
$social_email = impeka_grve_array_value( $social_params, 'social_email' );
$social_facebook = impeka_grve_array_value( $social_params, 'social_facebook' );
$social_twitter = impeka_grve_array_value( $social_params, 'social_twitter' );
$social_linkedin = impeka_grve_array_value( $social_params, 'social_linkedin' );
$social_pinterest = impeka_grve_array_value( $social_params, 'social_pinterest' );
$social_reddit = impeka_grve_array_value( $social_params, 'social_reddit' );
$social_tumblr = impeka_grve_array_value( $social_params, 'social_tumblr' );
$social_likes = impeka_grve_array_value( $social_params, 'social_likes' );
$social_title = impeka_grve_array_value( $social_params, 'social_title' );

$post_id = get_the_ID();
$post_permalink = get_permalink();
$post_title = get_the_title();
$social_email_string = 'mailto:?subject=' . $post_title . '&body=' . $post_title . ': ' . $post_permalink;

$header_skin = impeka_grve_global_param( 'header_skin' );

?>
<div id="grve-<?php echo esc_attr( $post_type ); ?>-social-bar" class="grve-social-bar grve-layout-1">
	<?php if ( !empty( $social_title ) ) { ?>
	<div class="grve-socials-bar-title grve-link-text grve-skin-scroll grve-skin-<?php echo esc_attr( $header_skin ); ?>" data-skin="<?php echo esc_attr( $header_skin ); ?>"><?php echo wp_kses_post( $social_title ); ?></div>
	<div class="grve-line grve-skin-scroll grve-skin-<?php echo esc_attr( $header_skin ); ?>" data-skin="<?php echo esc_attr( $header_skin ); ?>"></div>
	<?php } ?>
	<div class="grve-socials-wrapper grve-link-text">
		<?php if ( !empty( $social_email  ) ) { ?>
		<a href="<?php echo esc_url( $social_email_string ); ?>" data-skin="<?php echo esc_attr( $header_skin ); ?>" title="<?php echo esc_attr( $post_title ); ?>" class="grve-social-share-email grve-skin-scroll grve-skin-<?php echo esc_attr( $header_skin ); ?>">Em</a>
		<?php } ?>
		<?php if ( !empty( $social_facebook  ) ) { ?>
		<a href="<?php echo esc_url( $post_permalink ); ?>" data-skin="<?php echo esc_attr( $header_skin ); ?>" title="<?php echo esc_attr( $post_title ); ?>" class="grve-social-share-facebook grve-skin-scroll grve-skin-<?php echo esc_attr( $header_skin ); ?>">Fb</a>
		<?php } ?>
		<?php if ( !empty( $social_twitter  ) ) { ?>
		<a href="<?php echo esc_url( $post_permalink ); ?>" data-skin="<?php echo esc_attr( $header_skin ); ?>" title="<?php echo esc_attr( $post_title ); ?>" class="grve-social-share-twitter grve-skin-scroll grve-skin-<?php echo esc_attr( $header_skin ); ?>">Tw</a>
		<?php } ?>
		<?php if ( !empty( $social_linkedin  ) ) { ?>
		<a href="<?php echo esc_url( $post_permalink ); ?>" data-skin="<?php echo esc_attr( $header_skin ); ?>" title="<?php echo esc_attr( $post_title ); ?>" class="grve-social-share-linkedin grve-skin-scroll grve-skin-<?php echo esc_attr( $header_skin ); ?>">Li</a>
		<?php } ?>
		<?php if ( !empty( $social_pinterest  ) ) { ?>
		<a href="<?php echo esc_url( $post_permalink ); ?>" data-skin="<?php echo esc_attr( $header_skin ); ?>" title="<?php echo esc_attr( $post_title ); ?>" data-pin-img="<?php echo esc_url( impeka_grve_get_thumbnail_url() ); ?>" class="grve-social-share-pinterest grve-skin-scroll grve-skin-<?php echo esc_attr( $header_skin ); ?>">Pn</a>
		<?php } ?>
		<?php if ( !empty( $social_reddit ) ) { ?>
		<a href="<?php echo esc_url( $post_permalink ); ?>" data-skin="<?php echo esc_attr( $header_skin ); ?>" title="<?php echo esc_attr( $post_title ); ?>" class="grve-social-share-reddit grve-skin-scroll grve-skin-<?php echo esc_attr( $header_skin ); ?>">Rb</a>
		<?php } ?>
		<?php if ( !empty( $social_tumblr ) ) { ?>
		<a href="<?php echo esc_url( $post_permalink ); ?>" data-skin="<?php echo esc_attr( $header_skin ); ?>" title="<?php echo esc_attr( $post_title ); ?>" class="grve-social-share-tumblr grve-skin-scroll grve-skin-<?php echo esc_attr( $header_skin ); ?>">Tm</a>
		<?php } ?>
		<?php if ( !empty( $social_likes  ) ) { ?>
		<a href="#" data-skin="<?php echo esc_attr( $header_skin ); ?>" class="grve-like-counter-link <?php echo impeka_grve_likes( $post_id, 'status' ); ?> grve-skin-scroll grve-skin-<?php echo esc_attr( $header_skin ); ?>" data-post-id="<?php echo esc_attr( $post_id ); ?>"><?php echo impeka_grve_get_svg_icon('heart'); ?><span class="grve-like-counter"><?php echo impeka_grve_likes( $post_id, 'number' ); ?></span></a>
		<?php } ?>
	</div>
</div>