<?php
/*
*	Modal Search Form
*
* 	@version	1.0
* 	@author		Greatives Team
* 	@URI		https://greatives.eu
*/

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

$search_modal_text = impeka_grve_option( 'search_modal_text' );
$search_modal_results_mode = impeka_grve_option( 'search_modal_results_mode' );
?>
<div id="grve-search-modal" class="grve-sliding-item">
	<form class="grve-search-item" method="get" action="<?php echo esc_url( home_url( '/' ) ); ?>" >
		<?php if( !empty( $search_modal_text ) ) { ?>
		<div class="grve-search-title grve-heading-color grve-leader-text"><?php echo wp_kses( $search_modal_text , array( 'br' => array() ) ); ?></div>
		<?php } ?>
		<button type="submit" class="grve-search-btn grve-custom-btn"><?php echo impeka_grve_get_icon( 'search' ); ?></button>
		<label class="grve-hidden" for="grve-search-modal-textfield-input"><?php echo esc_html__( 'Search for ...', 'impeka' ); ?></label>
		<input id="grve-search-modal-textfield-input" type="text" class="grve-search-textfield grve-leader-text grve-border" value="" name="s" autocomplete="off"/>
		<?php if( 'product' == $search_modal_results_mode ) { ?>
		<input type="hidden" name="post_type" value="product" />
		<?php } ?>
		<?php if( defined( 'ICL_SITEPRESS_VERSION' ) && defined( 'ICL_LANGUAGE_CODE' ) ) { ?>
		<input type="hidden" name="lang" value="<?php echo esc_attr( ICL_LANGUAGE_CODE ); ?>"/>
		<?php } ?>
	</form>
</div>