<?php
/**
 * Content Slider Template
 */

extract( $atts );

//Post Type
$post_type_class = '';
$post_cat_slug = '';
if ( 'portfolio' == $post_type ) {
	$post_type_class = 'grve-portfolio-slider';
	$post_cat_slug = 'portfolio_category';
} elseif ( 'product' == $post_type ) {
	$post_type_class = 'grve-product-slider';
	$post_cat_slug = 'product_cat';
} else {
	$post_type_class = 'grve-blog-slider';
	$post_cat_slug = 'category';
}

//Element Wrapper
$wrapper_attributes = array();
$element_classes = array( 'grve-element', 'grve-slider', 'grve-content-slider', $post_type_class );
if ( !empty( $shadow ) ) {
	$element_classes[] = 'grve-' . $shadow;
}
if ( 'none' != $radius ) {
	$element_classes[] = 'grve-radius-' . $radius;
}
if ( !empty( $el_class ) ) {
	$element_classes[] = $el_class;
}
$element_class_string = implode( ' ', $element_classes );
$wrapper_attributes[] = 'class="' . esc_attr( $element_class_string ) . '"';

$css_style = impeka_elementor_ext_build_margin_bottom_style( $margin_bottom );
if ( !empty( $css_style ) ) {
	$wrapper_attributes[] = 'style="' . esc_attr( $css_style ) . '"';
}

//Query
$exclude_ids = array();
if( !empty( $exclude_posts ) ){
	$exclude_ids = explode( ',', $exclude_posts );
}
$include_ids = array();
if( !empty( $include_posts ) ){
	$include_ids = explode( ',', $include_posts );
}

if ( 'portfolio' == $post_type ) {

	$portfolio_cat = "";
	$portfolio_category_ids = array();

	if( ! empty( $portfolio_categories ) ) {

		if( is_array( $portfolio_categories ) ) {
			$portfolio_category_ids = $portfolio_categories;
		} else {
			$portfolio_category_ids = explode( ",", $portfolio_categories );
		}
		foreach ( $portfolio_category_ids as $category_id ) {
			$category_term = get_term( $category_id, 'portfolio_category' );
			if ( isset( $category_term) ) {
				$portfolio_cat = $portfolio_cat.$category_term->slug . ', ';
			}
		}
	}

	if( !empty( $include_posts ) ){
		$args = array(
			'post_type' => 'portfolio',
			'post_status'=>'publish',
			'paged' => 1,
			'post__in' => $include_ids,
			'posts_per_page' => $posts_per_page,
			'orderby' => $order_by,
			'order' => $order,
		);
	} else {
		$args = array(
			'post_type' => 'portfolio',
			'post_status'=>'publish',
			'paged' => 1,
			'portfolio_category' => $portfolio_cat,
			'posts_per_page' => $posts_per_page,
			'post__not_in' => $exclude_ids,
			'orderby' => $order_by,
			'order' => $order,
		);
	}

} elseif ( 'product' == $post_type ) {
	$product_cat = "";
	$product_category_ids = array();

	if( ! empty( $product_categories ) ) {
		if( is_array( $product_category_ids ) ) {
			$product_category_ids = $product_categories;
		} else {
			$product_category_ids = explode( ",", $product_categories );
		}
		foreach ( $product_category_ids as $category_id ) {
			$category_term = get_term( $category_id, 'product_cat' );
			if ( isset( $category_term) ) {
				$product_cat = $product_cat.$category_term->slug . ', ';
			}
		}
	}

	if( !empty( $include_posts ) ){
		$args = array(
			'post_type' => 'product',
			'post_status'=>'publish',
			'posts_per_page' => $posts_per_page,
			'post__in' => $include_ids,
			'paged' => 1,
			'orderby' => $order_by,
			'order' => $order,
		);
	} else {
		$args = array(
			'post_type' => 'product',
			'post_status'=>'publish',
			'posts_per_page' => $posts_per_page,
			'post__not_in' => $exclude_ids,
			'product_cat' => $product_cat,
			'paged' => 1,
			'orderby' => $order_by,
			'order' => $order,
		);
	}
} else {
	if( !empty( $include_posts ) ){
		$args = array(
			'post_type' => 'post',
			'post_status'=>'publish',
			'posts_per_page' => $posts_per_page,
			'post__in' => $include_ids,
			'paged' => 1,
			'ignore_sticky_posts' => 1,
			'orderby' => $order_by,
			'order' => $order,
		);
	} else {
		$args = array(
			'post_type' => 'post',
			'post_status'=>'publish',
			'posts_per_page' => $posts_per_page,
			'cat' => $categories,
			'post__not_in' => $exclude_ids,
			'paged' => 1,
			'ignore_sticky_posts' => 1,
			'orderby' => $order_by,
			'order' => $order,
		);
	}
}

$pause_hover = impeka_elementor_ext_get_switcher_value( $pause_hover );
$auto_play = impeka_elementor_ext_get_switcher_value( $auto_play );

$inner_wrapper_attributes = array();
$inner_wrapper_attributes[] = 'class="grve-slider-element"';
$inner_wrapper_attributes[] = 'data-slider-speed="' . esc_attr( $slideshow_speed ) . '"';
$inner_wrapper_attributes[] = 'data-slider-pause="' . esc_attr( $pause_hover ) . '"';
$inner_wrapper_attributes[] = 'data-slider-autoplay="' . esc_attr( $auto_play ) . '"';
$inner_wrapper_attributes[] = 'data-slider-autoheight="yes"';

//Title
$title_classes = array( 'grve-title' );
$title_classes[]  = 'grve-' . $heading;
if ( !empty( $custom_font_family ) ) {
	$title_classes[]  = 'grve-' . $custom_font_family;
}
$title_classes[]  = 'grve-text-' . $title_color;
$title_class_string = implode( ' ', $title_classes );

//Text
$text_classes = array( 'grve-description' );
$text_classes[]  = 'grve-text-' . $text_color;
$text_class_string = implode( ' ', $text_classes );

$query = new WP_Query( $args );

if ( $query->have_posts() ) :

//OUTPUT
?>
<div <?php echo implode( ' ', $wrapper_attributes ); ?>>
	<div class="grve-element grve-carousel-wrapper">
		<div <?php echo implode( ' ', $inner_wrapper_attributes ); ?>>

<?php
while ( $query->have_posts() ) : $query->the_post();
	$post_id = get_the_ID();
?>
			<div class="grve-slider-item">
				<?php
					$bg_options = array(
						'bg_color' => $overlay_color,
						'overlay_opacity' => $overlay_opacity,
					);
					impeka_elementor_ext_post_bg_image_container( $bg_options );
				?>
				<div class="grve-slider-content">
					<div class="grve-slider-content-inner">
						<?php the_title( '<' . tag_escape( $heading_tag ) . ' class="' . esc_attr( $title_class_string ) . '">', '</' . tag_escape( $heading_tag ) . '>' ); ?>
						<div class="<?php echo esc_attr( $text_class_string ); ?>">
						<?php
							if ( function_exists('impeka_grve_post_slider_excerpt') ) {
								echo impeka_grve_post_slider_excerpt( $post_id , $excerpt_length, $excerpt_more, $excerpt_more_text );
							}
						?>
						</div>
					</div>
				</div>
			</div>
<?php
endwhile;
?>
		</div>
	</div>
</div>
<?php
else :
endif;

wp_reset_postdata();

//Omit closing PHP tag to avoid accidental whitespace output errors.
