<?php
/**
 * Custom Contact Form Template
 */

extract( $atts );

if ( empty( $contact_form ) ) {
	return;
}

// Form Classes
$form_classes = array( 'grve-element', 'grve-contact-form' );
if ( !empty( $text_style ) ) {
	$form_classes[] = 'grve-' . $text_style;
}
$form_classes[] = 'grve-form-btn-' . $button_type;
$form_classes[] = 'grve-form-btn-' . $button_shape;
$form_classes[] = 'grve-form-btn-bg-' . $button_color;
$form_classes[] = 'grve-form-btn-bg-hover-' . $button_hover_color;
$form_classes[] = 'grve-form-btn-' . $button_size;
if ( !empty( $inputs_shape ) ) {
	$form_classes[] = 'grve-form-' . $inputs_shape;
}
if ( !empty( $inputs_borders ) ) {
	$form_classes[] = 'grve-form-input-border-type-' . $inputs_borders;
	$form_classes[] = 'grve-form-input-border-' . $input_border_color;
	if ( 'inherit' != $input_focus_border_color ) {
		$form_classes[] = 'grve-form-input-focus-border-' . $input_focus_border_color;
	}
}
$form_classes[] = 'grve-form-input-text-' . $input_text_color;
$form_classes[] = 'grve-form-input-placeholder-' . $input_placeholder_color;
$form_classes[] = 'grve-form-input-bg-' . $input_bg_color;

if ( 'inherit' != $input_focus_text_color ) {
	$form_classes[] = 'grve-form-input-focus-text-' . $input_focus_text_color;
}
if ( 'inherit' != $input_focus_placeholder_color ) {
	$form_classes[] = 'grve-form-input-focus-placeholder-' . $input_focus_placeholder_color;
}
if ( 'inherit' != $input_focus_bg_color ) {
	$form_classes[] = 'grve-form-input-focus-bg-' . $input_focus_bg_color;
}
if ( !empty( $inputs_shape ) ) {
	$form_classes[] = 'grve-form-' . $inputs_shape;
}
$form_class_string = implode( ' ', $form_classes );

//OUTPUT

echo '<div class="' . esc_attr( $form_class_string ) . '">' . do_shortcode('[contact-form-7 id="' . esc_attr( $contact_form ) . '"]') . '</div>';

//Omit closing PHP tag to avoid accidental whitespace output errors.
