<?php
/**
 * Fancy Box Template
 */

extract( $atts );

//Element Wrapper
$wrapper_attributes = array();
$element_classes = array( 'grve-element', 'grve-fancy-box' );
if ( !empty( $grve_animation ) ) {
	$element_classes[] = 'grve-animated-item';
	$wrapper_attributes[] = 'data-animation="' . esc_attr( $grve_animation ) . '"';
	$wrapper_attributes[] = 'data-delay="' . esc_attr( $grve_animation_delay ) . '"';
	$wrapper_attributes[] = 'data-duration="' . esc_attr( $grve_animation_duration ) . '"';
}
if ( 'transparent' != $content_bg ) {
	$element_classes[]  = 'grve-bg-' . $content_bg;
}
if ( 'none' != $radius ) {
	$element_classes[] = 'grve-radius-' . $radius;
}
if ( !empty( $shadow ) && 'none' != $shadow ) {
	$element_classes[] = 'grve-' . $shadow;
}
if( 'inherit' != $text_color && 'custom' != $text_color ){
	$element_classes[]  = 'grve-text-' . $text_color;
}
if ( 'white' == $content_bg_hover || 'light-grey' == $content_bg_hover || 'grey' == $content_bg_hover ) {
	$element_classes[]  = 'grve-fancy-box-text-black';
}
if ( !empty( $el_class ) ) {
	$element_classes[] = $el_class;
}
$element_class_string = implode( ' ', $element_classes );
$wrapper_attributes[] = 'class="' . esc_attr( $element_class_string ) . '"';
$css_style = impeka_elementor_ext_build_margin_bottom_style( $margin_bottom );
if( 'custom' == $text_color ){
	$css_style .= ' color: ' . esc_attr( $text_color_custom ) . ';';
}
if ( !empty( $css_style ) ) {
	$wrapper_attributes[] = 'style="' . esc_attr( $css_style ) . '"';
}

//BG Classes
$fancy_box_bg_classes = array( 'grve-fancy-box-bg', 'grve-bg-' . $content_bg_hover );
if ( !empty( $radius ) ) {
	$fancy_box_bg_classes[]  = 'grve-radius-' . $radius;
}
$fancy_box_bg_class_string = implode( ' ', $fancy_box_bg_classes );

//Title Classes
$title_classes = array( 'grve-title', 'grve-heading-color', 'grve-disable-color-change' );
$title_classes[]  = 'grve-' . $heading;
if ( !empty( $custom_font_family ) ) {
	$title_classes[]  = 'grve-' . $custom_font_family;
}
if( 'inherit' != $title_color && 'custom' != $title_color ){
	$title_classes[]  = 'grve-text-' . $title_color;
}
$title_class_string = implode( ' ', $title_classes );
$title_style = '';
if( 'custom' == $title_color ){
	$title_style = ' color: ' . esc_attr( $title_color_custom ) . ';';
}

//OUTPUT

echo '<div ' . implode( ' ', $wrapper_attributes ) . '>';
echo '<div class="grve-fancy-box-inner">';

if ( 'icon' == $icon_type ) {
	$icon_classes = array( 'grve-text-' . $icon_color , 'grve-' . $icon_size );
	$icon_class_string = implode( ' ', $icon_classes );
	echo '<div class="grve-fancy-box-icon">';
	if ( 'svg' === $icon['library'] ) {
		echo ' <div class="' . esc_attr( $icon_class_string ) . '">';
		\Elementor\Icons_Manager::render_icon( $icon , [ 'aria-hidden' => 'true' ] );
		echo '</div>';
	} else {
		\Elementor\Icons_Manager::render_icon( $icon , [ 'aria-hidden' => 'true', 'class' => $icon_class_string ] );
	}
	echo '</div>';
}

if ( !empty( $title ) ) {
	echo '<' . tag_escape( $heading_tag ) . ' class="' . esc_attr( $title_class_string ) . '" style="' . $title_style . '">' . wp_kses_post( $title ) . '</' . tag_escape( $heading_tag ) . '>';
}
if ( !empty( $content ) ) {
	echo '<p class="grve-description">' . do_shortcode( $content ) . '</p>';
}
if ( !empty( $read_more_title ) && impeka_elementor_ext_has_link( $read_more_link ) ) {
	echo '<div class="grve-link-text grve-fancy-box-read-more">';
	echo esc_html( $read_more_title ) ;
	echo '</div>';
}
echo '  </div>';
if ( impeka_elementor_ext_has_link( $read_more_link ) ) {
	$link_class_string = 'grve-item-url ' . esc_attr( $read_more_class );
	$link_attributes = impeka_elementor_ext_get_link_attributes( $read_more_link, $link_class_string );
	echo '<a ' . implode( ' ', $link_attributes ) . '></a>';
}
echo '<div class="' . esc_attr( $fancy_box_bg_class_string ) . '"></div>';
echo '</div>';

//Omit closing PHP tag to avoid accidental whitespace output errors.
