<?php
/**
 * Icon Template
 */

extract( $atts );

//Element Wrapper
$wrapper_attributes = array();
$element_classes = array( 'grve-element', 'grve-single-icon', 'grve-' . $icon_size );
if ( !empty( $animation ) ) {
	$element_classes[] = 'grve-animated-item';
	$wrapper_attributes[] = 'data-animation="' . esc_attr( $animation ) . '"';
	$wrapper_attributes[] = 'data-delay="' . esc_attr( $animation_delay ) . '"';
	$wrapper_attributes[] = 'data-duration="' . esc_attr( $animation_duration ) . '"';
}

if ( !empty( $el_class ) ) {
	$element_classes[] = $el_class;
}
$element_class_string = implode( ' ', $element_classes );
$wrapper_attributes[] = 'class="' . esc_attr( $element_class_string ) . '"';
$css_style = impeka_elementor_ext_build_margin_bottom_style( $margin_bottom );
if ( !empty( $css_style ) ) {
	$wrapper_attributes[] = 'style="' . esc_attr( $css_style ) . '"';
}

//Icon Wrapper
$icon_wrapper_attributes = array();
$icon_wrapper_classes = array( 'grve-wrapper-icon' );
if ( !empty( $icon_shape ) ) {
	$icon_wrapper_classes[] = 'grve-' . $icon_shape;
	$icon_wrapper_classes[] = 'grve-' . $shape_type;
	$icon_wrapper_classes[] = 'grve-with-shape';
	if ( 'outline' != $shape_type ) {
		$icon_wrapper_classes[] = 'grve-bg-' . $icon_shape_color;
	} else {
		$icon_wrapper_classes[] = 'grve-border-' . $icon_shape_color;
	}
	if ( !empty( $loop_animation ) ) {
		$icon_wrapper_classes[] = 'grve-loop-' . $loop_animation;
	}
}
$icon_wrapper_classes[] = 'grve-text-' . $icon_color;
$icon_wrapper_class_string = implode( ' ', $icon_wrapper_classes );
$icon_wrapper_attributes[] = 'class="' . esc_attr( $icon_wrapper_class_string ) . '"';

//Icon Wrapper Style
$icon_wrapper_style = '';
if( 'custom' == $icon_color ) {
	$icon_wrapper_style .= ' color: ' . esc_attr( $icon_color_custom ) . ';';
}
if( 'custom' == $icon_shape_color ) {
	if ( 'outline' != $shape_type ) {
		$icon_wrapper_style .= ' background-color: ' . esc_attr( $icon_shape_color_custom ) . ';';
	} else {
		$icon_wrapper_style .= ' border-color: ' . esc_attr( $icon_shape_color_custom ) . ';';
	}
}
if ( !empty( $icon_wrapper_style ) ) {
	$icon_wrapper_attributes[] = 'style="' . esc_attr( $icon_wrapper_style ) . '"';
}

//OUTPUT

echo '<div ' . implode( ' ', $wrapper_attributes ) . '>';
echo '<div ' . implode( ' ', $icon_wrapper_attributes ) . '>';

if ( impeka_elementor_ext_has_link( $link ) ) {
	$link_attributes = impeka_elementor_ext_get_link_attributes( $link, $link_class );
	echo '<a ' . implode( ' ', $link_attributes ) . '>';
}

if( 'theme-icon-svg' == $icon_type ) {
	echo impeka_elementor_ext_get_svg_icon( $theme_icon );
} else {
	\Elementor\Icons_Manager::render_icon( $icon , [ 'aria-hidden' => 'true' ] );
}

if ( impeka_elementor_ext_has_link( $link ) ) {
echo '</a>';
}
if ( 'animation-1' == $loop_animation ) {
	echo '<div class="grve-pulse-bg"></div>';
}
echo '</div>';
echo '</div>';

//Omit closing PHP tag to avoid accidental whitespace output errors.
