<?php
/**
 * Image Text Template
 */

extract( $atts );

//Element Wrapper
$wrapper_attributes = array();
$element_classes = array( 'grve-element', 'grve-image-text' );
if ( !empty( $grve_animation ) ) {
	$element_classes[] = 'grve-animated-item';
	$wrapper_attributes[] = 'data-animation="' . esc_attr( $grve_animation ) . '"';
	$wrapper_attributes[] = 'data-delay="' . esc_attr( $grve_animation_delay ) . '"';
	$wrapper_attributes[] = 'data-duration="' . esc_attr( $grve_animation_duration ) . '"';
}
if ( !empty( $el_class ) ) {
	$element_classes[] = $el_class;
}
$element_classes[] = 'grve-' . esc_attr( $image_text_style );
$element_classes[] = 'grve-position-' . esc_attr( $image_text_align );
$element_class_string = implode( ' ', $element_classes );
$wrapper_attributes[] = 'class="' . esc_attr( $element_class_string ) . '"';
$css_style = impeka_elementor_ext_build_margin_bottom_style( $margin_bottom );
if ( !empty( $css_style ) ) {
	$wrapper_attributes[] = 'style="' . esc_attr( $css_style ) . '"';
}

$image_mode_size = impeka_elementor_ext_get_image_size( $image_mode );
$image_popup_size_mode = impeka_elementor_ext_get_image_size( $image_popup_size );

$image_item_atts = array(
	'image' => $image,
	'retina_image' => $retina_image,
	'image_mode_size' => $image_mode_size,
	'image_popup_size_mode' => $image_popup_size_mode,
	'image_load_mode' => $image_load_mode,
	'column_space' => '100',
	'wrapper' => 'yes',
);

$full_url = impeka_elementor_ext_get_image_popup_url( $image_item_atts );

//Image Classes
$image_classes = array( 'grve-image' );
	if ( 'none' != $radius ) {
	$image_classes[] = 'grve-radius-' . $radius;
}
$image_class_string = implode( ' ', $image_classes );

//Title Classes
$title_classes = array( 'grve-title' );
$title_classes[]  = 'grve-' . $heading;
if ( !empty( $custom_font_family ) ) {
	$title_classes[]  = 'grve-' . $custom_font_family;
}
if( 'inherit' != $title_color ){
	$title_classes[] = 'grve-text-' . $title_color;
}
$title_class_string = implode( ' ', $title_classes );

//Text Classes
$text_classes = array( 'grve-description' );
if ( !empty( $text_style ) && $text_style != 'none' ) {
	$text_classes[] = ' grve-' .$text_style;
}
if( 'inherit' != $title_color ){
	$text_classes[] = 'grve-text-' . $text_color;
}
$text_class_string = implode( ' ', $text_classes );

//OUTPUT

echo '<div ' . implode( ' ', $wrapper_attributes ) . '>';
	echo '<div class="' . esc_attr( $image_class_string ) . '">';
	if ( 'video' == $popup_mode && !empty( $video_link ) ) {
		echo '<a class="grve-video-popup" href="' . esc_url( $video_link ) . '">' . impeka_elementor_ext_get_video_icon( $video_icon_color ) . '</a>';
		echo impeka_elementor_ext_get_image_html( $image_item_atts );
	} else if ( 'image' == $popup_mode ) {
		echo '<a class="grve-image-popup grve-item-url" href="' . esc_url( $full_url ) . '"></a>';
		echo impeka_elementor_ext_get_image_html( $image_item_atts );
	} else {
		echo impeka_elementor_ext_get_image_html( $image_item_atts );
	}
	echo '</div>';
	echo '<div class="grve-content grve-align-' . esc_attr( $content_align ) . '">';
		echo '<div class="grve-content-inner">';
		if ( !empty( $title ) ) {
			echo '<' . tag_escape( $heading_tag ) . ' class="' . esc_attr( $title_class_string ) . '">' . $title. '</' . tag_escape( $heading_tag ) . '>';
		}
		if ( !empty( $content ) ) {
			echo '<p class="' . esc_attr( $text_class_string ) . '">' . do_shortcode( $content ) . '</p>';
		}
		echo impeka_elementor_ext_get_button( $atts );
		echo '</div>';
	echo '</div>';
echo '</div>';

//Omit closing PHP tag to avoid accidental whitespace output errors.
