<?php
/**
 * Broken Portfolio Template
 */

extract( $atts );

$el_id = 'el-' . $el_id;

//Element Wrapper
$element_classes = array( 'grve-element', 'grve-broken-portfolio' );
$element_classes[] = 'grve-' . $layout;
if ( !empty ( $el_class ) ) {
	$element_classes[] = $el_class;
}
$element_class_string = implode( ' ', $element_classes );

$wrapper_attributes[] = 'class="' . esc_attr( $element_class_string ) . '"';
$wrapper_attributes[] = 'id="' . esc_attr( $el_id ) . '"';
$css_style = impeka_elementor_ext_build_margin_bottom_style( $margin_bottom );
if ( !empty( $css_style ) ) {
	$wrapper_attributes[] = 'style="' . esc_attr( $css_style ) . '"';
}

//Image Popup Size
$image_popup_size_mode = 'extra-extra-large';
if ( 'popup' == $link_type ) {
	$image_popup_size_mode = impeka_elementor_ext_get_image_size( $image_popup_size );
}

$portfolio_cat = "";
$category_ids = array();

if( ! empty( $categories ) ) {
	if( is_array( $categories ) ) {
		$category_ids = $categories;
	} else {
		$category_ids = explode( ",", $categories );
	}	
	foreach ( $category_ids as $category_id ) {
		$category_term = get_term( $category_id, 'portfolio_category' );
		if ( isset( $category_term) ) {
			$portfolio_cat = $portfolio_cat.$category_term->slug . ', ';
		}
	}
}

$paged = 1;

if ( ! empty( $display_style ) ) {
	if ( get_query_var( 'paged' ) ) {
		$paged = get_query_var( 'paged' );
	} elseif ( get_query_var( 'page' ) ) {
		$paged = get_query_var( 'page' );
	}
}

$exclude_ids = array();
if( !empty( $exclude_posts ) ){
	$exclude_ids = explode( ',', $exclude_posts );
}

$include_ids = array();
if( !empty( $include_posts ) ){
	$include_ids = explode( ',', $include_posts );
	$args = array(
		'post_type' => 'portfolio',
		'post_status'=>'publish',
		'paged' => $paged,
		'post__in' => $include_ids,
		'posts_per_page' => $items_per_page,
		'orderby' => $order_by,
		'order' => $order,
	);
} else {
	$args = array(
		'post_type' => 'portfolio',
		'post_status'=>'publish',
		'paged' => $paged,
		'portfolio_category' => $portfolio_cat,
		'post__not_in' => $exclude_ids,
		'posts_per_page' => $items_per_page,
		'orderby' => $order_by,
		'order' => $order,
	);
}

$query = new WP_Query( $args );
if ( $query->have_posts() ) :

//OUTPUT

?>
<div <?php echo implode( ' ', $wrapper_attributes ); ?>>
<?php

$container_class = 'grve-broken-container';
if ( 'popup' == $link_type ) {
	$container_class .= ' grve-gallery-popup';
}
?>
	<div class="<?php echo esc_attr( $container_class ); ?>">
<?php


// Item Class
$item_classes = array( 'grve-broken-item' );
if ( !empty( $grve_animation ) ) {
	$item_classes[] = 'grve-animated-item';
	$item_attributes[] = 'data-animation="' . esc_attr( $grve_animation ) . '"';
}
$item_class_string = implode( ' ', $item_classes );
$item_attributes[] = 'class="' . esc_attr( $item_class_string ) . '"';

$portfolio_index = 0;

while ( $query->have_posts() ) : $query->the_post();

	$portfolio_index++;
	$broken_grid_data = impeka_elementor_ext_get_broken_grid_data( $portfolio_index, $layout );
	$image_size = $broken_grid_data['image_size'];

	//Link Attributes
	if ( function_exists('impeka_grve_get_portfolio_link_atts') ) {
		$link_atts = impeka_grve_get_portfolio_link_atts( $link_type, $image_popup_size_mode );
	} else {
		$link_atts = array();
		$link_atts[] = 'class="grve-item-url"';
		$link_atts[] = 'href="' . esc_url( get_permalink() ) . '"';
	}

	//Title and Caption
	$caption = $title = '';
	if ( 'none' != $title_caption && 'caption-only' != $title_caption ) {
		$title = get_the_title();
	}
	if ( 'none' != $title_caption && 'title-only' != $title_caption ) {
		$caption = get_post_meta( get_the_ID(), '_impeka_grve_description', true );
	}

	//Portfolio Custom Overview
	$current_title_color = $title_color;
	$current_title_bg_color = $title_bg_color;
	$current_overlay_color = $overlay_color;
	$current_overlay_opacity = $overlay_opacity;
	$current_title_heading = $title_heading;
	if ( 'custom-overview' == $overview_type ) {
		$overview_mode = get_post_meta( get_the_ID(), '_impeka_grve_portfolio_overview_mode', true );
		if ( 'color' == $overview_mode ) {
			$overview_text = get_post_meta( get_the_ID(), '_impeka_grve_portfolio_overview_text', true );
			$overview_text_heading = get_post_meta( get_the_ID(), '_impeka_grve_portfolio_overview_text_heading', true );

			$overview_color = get_post_meta( get_the_ID(), '_impeka_grve_portfolio_overview_color', true );
			$overview_overlay_color = get_post_meta( get_the_ID(), '_impeka_grve_portfolio_overview_overlay_color', true );
			$overview_overlay_opacity = get_post_meta( get_the_ID(), '_impeka_grve_portfolio_overview_overlay_opacity', true );

			$current_title_color = !empty( $overview_color ) ? $overview_color : 'black';
			$current_title_bg_color = "transparent";
			$current_overlay_color = !empty( $overview_overlay_color ) ? $overview_overlay_color : 'primary-1';
			$current_overlay_opacity = !empty( $overview_overlay_opacity ) ? $overview_overlay_opacity : '90';
			$current_title_heading = !empty( $overview_text_heading ) ? $overview_text_heading  : $title_heading;

			$title = !empty( $overview_text ) ? $overview_text : $title;
			if ( !empty( $overview_text ) ) {
				$caption = '';
			}
		}
	}
	$current_overlay_opacity = ( '0' == $current_overlay_opacity ) ? 'none' : $current_overlay_opacity;


	$portfolio_params = array(
		'element' => 'portfolio',
		'link_atts' => $link_atts,
		'style' => $style,
		'overlay_color' => $current_overlay_color,
		'overlay_opacity' => $current_overlay_opacity,
		'title' => $title,
		'title_heading_tag' => $title_heading_tag,
		'title_heading' => $current_title_heading,
		'title_color' => $current_title_color,
		'title_bg_color' => $current_title_bg_color,
		'caption' => $caption,
		'text_color' => $text_color,
		'text_bg_color' => $text_bg_color,
		'radius' => $radius,
		'shadow' => $shadow,
		'image_effect' => $image_effect,
		'image_size' => $image_size,
		'image_atts' => array( 'data-column-space' => '100', 'data-lazyload' => $image_load_mode ),
		'indicator' => $indicator,
		'indicator_text' => $indicator_text,
		'indicator_color' => $indicator_color,
	);
?>

		<div <?php echo implode( ' ', $item_attributes ); ?>>
			<div class="grve-portfolio-item-inner">
				<?php get_template_part( 'templates/hover-item/hover-' . $style, '', $portfolio_params ); ?>
			</div>
		</div>
<?php
endwhile;
?>
	</div>
<?php
	if ( ! empty( $display_style ) ) {
		impeka_elementor_print_pagination( array(
			'total' => $query->max_num_pages,
			'paged' => $paged,
			'display_style' => $display_style,
		));
	}
?>
</div>
<?php

else :
	get_template_part( 'templates/portfolio/portfolio', 'none' );
endif;
wp_reset_postdata();

//Omit closing PHP tag to avoid accidental whitespace output errors.
