<?php
/**
 * Impeka Elementor Animated Text Widget.
 *
 * Elementor widget that inserts a area item grid into the page.
 *
 * @since 1.0.0
 */
class Impeka_Elementor_Animated_Text_Widget extends \Elementor\Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'impeka_animated_text';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Impeka Animated Text', 'impeka-elementor-extension' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'impeka-animated-text';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'impeka' ];
	}

	/**
	 * Register widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function register_controls() {

		$this->start_controls_section(
			'general_section',
			[
				'label' => esc_html__( 'General', 'impeka-elementor-extension' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'animated_text',
			[
				'label' => esc_html__( 'Animated Text', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::TEXTAREA,
				'default' => '|Sample Text;Use your own values!|',
				'description' => "Text within <b>|</b> will be animated, for example: <strong>|Sample text|</strong>. <br />Text separator is <b>;</b> for example: <strong>|Sample text; new line|</strong> which will create new lines at ;",
			]
		);
		$this->add_control(
			'text_color',
			[
				'label' => esc_html__( 'Text Color', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => impeka_elementor_ext_get_color_array( ['inherit', 'primary', 'standard', 'custom'] ),
				'default' => 'inherit',
				'description' => esc_html__( 'Choose the title color.', 'impeka-elementor-extension' ),
			]
		);
		$this->add_control(
			'text_color_custom',
			[
				'label' => esc_html__( 'Custom Text Color', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'scheme' => [
					'type' => \Elementor\Core\Schemes\Color::get_type(),
					'value' => \Elementor\Core\Schemes\Color::COLOR_1,
				],
				'default' => '#e1e1e1',
				'description' => esc_html__( "Select a custom color for your text", 'impeka-elementor-extension' ),
				'condition' => [
					'text_color' => [ 'custom' ],
				],
			]
		);		
		$this->add_control( 'heading_tag', impeka_elementor_ext_add_heading_tag( 'h3' ) );
		$this->add_control( 'heading', impeka_elementor_ext_add_heading( 'h3' ) );
		$this->add_control( 'increase_heading', impeka_elementor_ext_add_increase_heading() );
		$this->add_control( 'increase_heading_reset', impeka_elementor_ext_add_increase_heading_reset() );
		$this->add_control( 'custom_font_family', impeka_elementor_ext_add_custom_font_family() );
		$this->add_responsive_control( 'align', impeka_elementor_ext_add_responsive_align() );
		$this->add_control( 'margin_bottom', impeka_elementor_ext_add_margin_bottom() );
		$this->add_control( 'el_class', impeka_elementor_ext_add_el_class() );
		$this->end_controls_section();

		//Animation Section
		$this->start_controls_section(
			'animation_section',
			[
				'label' => esc_html__( 'Animation', 'impeka-elementor-extension' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'style',
			[
				'label' => esc_html__( 'Style', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'style-1' => esc_html__( 'Lines' , 'impeka-elementor-extension' ),
					'style-2' => esc_html__( 'Words' , 'impeka-elementor-extension' ),
					'style-3' => esc_html__( 'Characters' , 'impeka-elementor-extension' ),
				],
				'description' => esc_html__( 'Select your style', 'impeka-elementor-extension' ),
				'default' => 'style-1',
			]
		);
		$this->add_control(
			'grve_animation_delay',
			[
				'label' => esc_html__( 'CSS Animation Delay', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => '0',
				'description' => esc_html__( 'Add delay in milliseconds.', 'impeka-elementor-extension' ),
			]
		);
		$this->add_control(
			'grve_animation_duration',
			[
				'label' => esc_html__( 'CSS Animation Duration', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'very-fast'  => esc_html__( 'Very Fast', 'impeka-elementor-extension' ),
					'fast'  => esc_html__( 'Fast', 'impeka-elementor-extension' ),
					'normal' => esc_html__( 'Normal', 'impeka-elementor-extension' ),
					'slow' => esc_html__( 'Slow', 'impeka-elementor-extension' ),
					'very-slow' => esc_html__( 'Very Slow', 'impeka-elementor-extension' ),
				],
				'default' => 'normal',
				'description' => esc_html__( "Select the duration for your animated element.", 'impeka-elementor-extension' ),
			]
		);


		$this->end_controls_section();


	}

	/**
	 * Render widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function render() {
		$atts = $this->get_settings_for_display();


		echo impeka_elementor_ext_locate_template( 'animated-text.php', array( 'atts' => $atts ) );
	}

}