<?php
/**
 * Impeka Elementor Button Widget.
 *
 * Elementor widget that inserts a button grid into the page.
 *
 * @since 1.0.0
 */
class Impeka_Elementor_Button_Widget extends \Elementor\Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'impeka_button';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Impeka Button', 'impeka-elementor-extension' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'impeka-button';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'impeka' ];
	}

	/**
	 * Register widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function register_controls() {

		$this->start_controls_section(
			'general_section',
			[
				'label' => esc_html__( 'General', 'impeka-elementor-extension' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'btn_fluid',
			[
				'label' => esc_html__( 'Button Dimensions', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => '',
				'options' => [
					''  => esc_html__( 'Auto', 'impeka-elementor-extension' ),
					'yes'  => esc_html__( 'Fluid ( Full Width )', 'impeka-elementor-extension' ),
					'custom' => esc_html__( 'Custom', 'impeka-elementor-extension' ),
				],
				'description' => esc_html__( "Select dimensions for your button.", 'impeka-elementor-extension' ),
			]
		);
		$this->add_control(
			'btn_fluid_height',
			[
				'label' => esc_html__( 'Button Height', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => 'medium',
				'options' => [
					'short'  => esc_html__( 'Short', 'impeka-elementor-extension' ),
					'medium'  => esc_html__( 'Medium', 'impeka-elementor-extension' ),
					'tall' => esc_html__( 'Tall', 'impeka-elementor-extension' ),
				],
				'description' => esc_html__( "Select height for your fluid button.", 'impeka-elementor-extension' ),
				'condition' => [
					'btn_fluid' => [ 'yes' ],
				],
			]
		);
		$this->add_control(
			'btn_custom_width',
			[
				'label' => esc_html__( 'Button Width', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => '250',
				'description' => esc_html__( "Enter the width for your button (Note: CSS measurement units allowed).", 'impeka-elementor-extension' ),
				'condition' => [
					'btn_fluid' => [ 'custom' ],
				],
			]
		);

		$this->add_responsive_control(
			'align',
			[
				'label' => esc_html__( 'Alignment', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'impeka-elementor-extension' ),
						'icon' => 'eicon-text-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'impeka-elementor-extension' ),
						'icon' => 'eicon-text-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'impeka-elementor-extension' ),
						'icon' => 'eicon-text-align-right',
					],
				],
				'default' => 'left',
				//'toggle' => false,
				'devices' => [ 'desktop', 'tablet', 'mobile' ],
				'prefix_class' => 'grve-elementor-align-%s',
				'conditions' => [
					'terms' => [
						[ 'name' => 'btn_fluid', 'operator' => '!in', 'value' => [ 'yes' ] ],
					],
				],
			]
		);

		$this->add_control( 'margin_bottom', impeka_elementor_ext_add_margin_bottom() );
		$this->add_control( 'el_class', impeka_elementor_ext_add_el_class() );
		$this->end_controls_section();

		//Button Section
		$this->start_controls_section(
			'button_section',
			[
				'label' => esc_html__( 'Button', 'impeka-elementor-extension' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		impeka_elementor_ext_get_button_params( $this );
		$this->end_controls_section();

		//Animation Section
		$this->start_controls_section(
			'animation_section',
			[
				'label' => esc_html__( 'Animation', 'impeka-elementor-extension' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control( 'grve_animation', impeka_elementor_ext_add_animation() );
		$this->add_control( 'grve_animation_delay', impeka_elementor_ext_add_animation_delay() );
		$this->add_control( 'grve_animation_duration', impeka_elementor_ext_add_animation_duration() );

		$this->end_controls_section();

	}

	/**
	 * Render widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function render() {
		$atts = $this->get_settings_for_display();
		//$this->add_link_attributes( 'link-wrapper', $atts['link'] );
		//$atts['link_atts'] = $this->get_render_attribute_string( 'link-wrapper' );


		echo impeka_elementor_ext_locate_template( 'button.php', array( 'atts' => $atts ) );
	}

}