<?php
/**
 * Impeka Elementor Counter Widget.
 *
 * Elementor widget that inserts a counter element into the page.
 *
 * @since 1.0.0
 */
class Impeka_Elementor_Counter_Widget extends \Elementor\Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'impeka_counter';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Impeka Counter', 'impeka-elementor-extension' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'impeka-counter';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'impeka' ];
	}

	/**
	 * Register widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function register_controls() {

		$this->start_controls_section(
			'general_section',
			[
				'label' => esc_html__( 'General', 'impeka-elementor-extension' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'counter_start_val',
			[
				'label' => esc_html__( 'Counter Start Number', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => '0',
				'description' => esc_html__( 'Enter counter start number.', 'impeka-elementor-extension' ),
			]
		);
		$this->add_control(
			'counter_end_val',
			[
				'label' => esc_html__( 'Counter End Number', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => '100',
				'description' => esc_html__( 'Enter counter end number.', 'impeka-elementor-extension' ),
			]
		);
		$this->add_control(
			'counter_thousands_separator_vis',
			[
				'label' => esc_html__( 'Counter Thousands Separator Visiblility', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Yes', 'impeka-elementor-extension' ),
				'label_off' => esc_html__( 'No', 'impeka-elementor-extension' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);
		$this->add_control(
			'counter_thousands_separator',
			[
				'label' => esc_html__( 'Counter Thousands Separator', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => ',',
				'description' => esc_html__( 'Enter thousands separator.', 'impeka-elementor-extension' ),
			]
		);
		$this->add_control(
			'counter_decimal_points',
			[
				'label' => esc_html__( 'Counter Decimal Points', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => '0',
				'description' => esc_html__( 'Number of decimal points.', 'impeka-elementor-extension' ),
			]
		);
		$this->add_control(
			'counter_decimal_separator',
			[
				'label' => esc_html__( 'Counter Decimal Separator', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => '.',
				'description' => esc_html__( 'Enter decimal separator.', 'impeka-elementor-extension' ),
			]
		);
		$this->add_control(
			'counter_prefix',
			[
				'label' => esc_html__( 'Counter Prefix', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => '',
				'description' => esc_html__( 'Enter counter prefix.', 'impeka-elementor-extension' ),
			]
		);
		$this->add_control(
			'counter_prefix_space',
			[
				'label' => esc_html__( 'Prefix space', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Yes', 'impeka-elementor-extension' ),
				'label_off' => esc_html__( 'No', 'impeka-elementor-extension' ),
				'return_value' => 'yes',
				'default' => 'no',
				'description' => esc_html__( 'Add space after prefix', 'impeka-elementor-extension' ),
			]
		);
		$this->add_control(
			'counter_suffix',
			[
				'label' => esc_html__( 'Counter Suffix', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => '',
				'description' => esc_html__( 'Enter counter suffix.', 'impeka-elementor-extension' ),
			]
		);
		$this->add_control(
			'counter_suffix_space',
			[
				'label' => esc_html__( 'suffix space', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Yes', 'impeka-elementor-extension' ),
				'label_off' => esc_html__( 'No', 'impeka-elementor-extension' ),
				'return_value' => 'yes',
				'default' => 'no',
				'description' => esc_html__( 'Add space before suffix', 'impeka-elementor-extension' ),
			]
		);
		$this->add_control(
			'counter_color',
			[
				'label' => esc_html__( 'Counter Color', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => impeka_elementor_ext_get_color_array(),
				'default' => 'primary-1',
				'description' => esc_html__( 'Color of the counter.', 'impeka-elementor-extension' ),
			]
		);
		$this->add_control(
			'counter_heading',
			[
				'label' => esc_html__( 'Counter Size/Typography', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'h1' => 'h1',
					'h2' => 'h2',
					'h3' => 'h3',
					'h4' => 'h4',
					'h5' => 'h5',
					'h6' => 'h6',
					'leader-text' => esc_html__( 'Leader Text', 'impeka-elementor-extension' ),
					'subtitle-text' => esc_html__( 'Subtitle Text', 'impeka-elementor-extension' ),
					'small-text' => esc_html__( 'Small Text', 'impeka-elementor-extension' ),
					'link-text' => esc_html__( 'Link Text', 'impeka-elementor-extension' ),
				],
				'default' => 'h2',
				'description' => esc_html__( 'Title size and typography, defined in Theme Options - Typography Options', 'impeka-elementor-extension' ),
			]
		);
		$this->add_control(
			'increase_counter_heading',
			[
				'label' => esc_html__( 'Increase Heading Size', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'100' => esc_html__( '100%', 'impeka-elementor-extension' ),
					'120' => esc_html__( '120%', 'impeka-elementor-extension' ),
					'140' => esc_html__( '140%', 'impeka-elementor-extension' ),
					'160' => esc_html__( '160%', 'impeka-elementor-extension' ),
					'180' => esc_html__( '180%', 'impeka-elementor-extension' ),
					'200' => esc_html__( '200%', 'impeka-elementor-extension' ),
					'250' => esc_html__( '250%', 'impeka-elementor-extension' ),
					'300' => esc_html__( '300%', 'impeka-elementor-extension' ),

				],
				'default' => '100',
				'description' => esc_html__( 'Set the percentage you want to increase your Headings size.', 'impeka-elementor-extension' ),
			]
		);
		$this->add_control(
			'counter_custom_font_family',
			[
				'label' => esc_html__( 'Counter Custom Font Family', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'' => esc_html__( 'Same as Typography', 'impeka-elementor-extension' ),
					'custom-font-1' => esc_html__( 'Custom Font Family 1', 'impeka-elementor-extension' ),
					'custom-font-2' => esc_html__( 'Custom Font Family 2', 'impeka-elementor-extension' ),
					'custom-font-3' => esc_html__( 'Custom Font Family 3', 'impeka-elementor-extension' ),
					'custom-font-4' => esc_html__( 'Custom Font Family 4', 'impeka-elementor-extension' ),


				],
				'default' => '',
				'description' => esc_html__( 'Select a different font family, defined in Theme Options - Typography Options - Extras - Custom Font Family', 'impeka-elementor-extension' ),
			]
		);
		$this->add_control(
			'title',
			[
				'label' => esc_html__( 'Title', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => 'Sample Title',
				'description' => esc_html__( "Enter counter title.", 'impeka-elementor-extension' ),
			]
		);
		$this->add_control(
			'title_color',
			[
				'label' => esc_html__( 'Title Color', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => impeka_elementor_ext_get_color_array( ['inherit', 'primary', 'standard'] ),
				'default' => 'inherit',
				'description' => esc_html__( 'Choose the title color.', 'impeka-elementor-extension' ),
			]
		);
		$this->add_control( 'heading_tag', impeka_elementor_ext_add_heading_tag( 'h3' ) );
		$this->add_control( 'heading', impeka_elementor_ext_add_heading( 'h3' ) );
		$this->add_control( 'custom_font_family', impeka_elementor_ext_add_custom_font_family() );
		$this->add_responsive_control( 'align', impeka_elementor_ext_add_responsive_align() );
		$this->add_control( 'margin_bottom', impeka_elementor_ext_add_margin_bottom() );
		$this->add_control( 'el_class', impeka_elementor_ext_add_el_class() );
		$this->end_controls_section();

		//Animation Section
		$this->start_controls_section(
			'animation_section',
			[
				'label' => esc_html__( 'Animation', 'impeka-elementor-extension' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control( 'grve_animation', impeka_elementor_ext_add_animation() );
		$this->add_control( 'grve_animation_delay', impeka_elementor_ext_add_animation_delay() );
		$this->add_control( 'grve_animation_duration', impeka_elementor_ext_add_animation_duration() );
		$this->end_controls_section();

	}

	/**
	 * Render widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function render() {
		$atts = $this->get_settings_for_display();

		echo impeka_elementor_ext_locate_template( 'counter.php', array( 'atts' => $atts ) );
	}

}