<?php
/**
 * Impeka Elementor Fancy Box Widget.
 *
 * Elementor widget that inserts a fancy box element into the page.
 *
 * @since 1.0.0
 */
class Impeka_Elementor_Fancy_Box_Widget extends \Elementor\Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'impeka_fancy_box';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Impeka Fancy Box', 'impeka-elementor-extension' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'impeka-fancy-box';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'impeka' ];
	}

	/**
	 * Register widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function register_controls() {

		$this->start_controls_section(
			'general_section',
			[
				'label' => esc_html__( 'General', 'impeka-elementor-extension' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'title',
			[
				'label' => esc_html__( 'Title', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => '',
				'description' => esc_html__( "Enter your title.", 'impeka-elementor-extension' ),
			]
		);
		$this->add_control( 'heading_tag', impeka_elementor_ext_add_heading_tag( 'h3' ) );
		$this->add_control( 'heading', impeka_elementor_ext_add_heading( 'h3' ) );
		$this->add_control( 'custom_font_family', impeka_elementor_ext_add_custom_font_family() );
		$this->add_control(
			'title_color',
			[
				'label' => esc_html__( 'Title Color', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => impeka_elementor_ext_get_color_array( ['inherit', 'primary', 'standard', 'custom'] ),
				'default' => 'inherit',
				'description' => esc_html__( 'Select the color of your title.', 'impeka-elementor-extension' ),
			]
		);
		$this->add_control(
			'title_color_custom',
			[
				'label' => esc_html__( 'Custom Title Color', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'scheme' => [
					'type' => \Elementor\Core\Schemes\Color::get_type(),
					'value' => \Elementor\Core\Schemes\Color::COLOR_1,
				],
				'default' => '#e1e1e1',
				'description' => esc_html__( "Select a custom color for your title", 'impeka-elementor-extension' ),
				'condition' => [
					'title_color' => [ 'custom' ],
				],
			]
		);
		$this->add_control(
			'content',
			[
				'label' => esc_html__( 'Text', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::TEXTAREA,
				'default' => '',
				'description' => esc_html__( "Enter your text", 'impeka-elementor-extension' ),
			]
		);
		$this->add_control(
			'text_color',
			[
				'label' => esc_html__( 'Text Color', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => impeka_elementor_ext_get_color_array( ['inherit', 'primary', 'standard', 'custom'] ),
				'default' => 'inherit',
				'description' => esc_html__( 'Select the color of your title.', 'impeka-elementor-extension' ),
			]
		);
		$this->add_control(
			'text_color_custom',
			[
				'label' => esc_html__( 'Custom Text Color', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'scheme' => [
					'type' => \Elementor\Core\Schemes\Color::get_type(),
					'value' => \Elementor\Core\Schemes\Color::COLOR_1,
				],
				'default' => '#e1e1e1',
				'description' => esc_html__( "Select a custom color for your title", 'impeka-elementor-extension' ),
				'condition' => [
					'text_color' => [ 'custom' ],
				],
			]
		);
		$this->add_control(
			'content_bg',
			[
				'label' => esc_html__( 'Background Color', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => impeka_elementor_ext_get_color_array( ['transparent', 'primary', 'gradient', 'standard'] ),
				'default' => 'transparent',
				'description' => esc_html__( 'Background color of the fancy box.', 'impeka-elementor-extension' ),
			]
		);
		$this->add_control(
			'content_bg_hover',
			[
				'label' => esc_html__( 'Hover Background Color', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => impeka_elementor_ext_get_color_array( ['primary', 'gradient', 'standard'] ),
				'default' => 'primary-1',
				'description' => esc_html__( 'Background hover color of the fancy box.', 'impeka-elementor-extension' ),
			]
		);
		$this->add_control( 'shadow', impeka_elementor_ext_add_shadow_alt() );
		$this->add_control( 'radius', impeka_elementor_ext_add_radius() );

		$this->add_control(
			'read_more_title',
			[
				'label' => esc_html__( 'Read More Title', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => '',
				'description' => esc_html__( "Enter your title for your link.", 'impeka-elementor-extension' ),
			]
		);
		$this->add_control(
			'read_more_link',
			[
				'label' => esc_html__( 'Read More Link', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::URL,
				'dynamic' => [
					'active' => false,
				],
				'placeholder' => 'https://your-link.com',
			]
		);
		$this->add_control(
			'read_more_class',
			[
				'label' => esc_html__( 'Read More Class', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => '',
				'description' => esc_html__( "Enter a class for your link.", 'impeka-elementor-extension' ),
			]
		);
		$this->add_responsive_control( 'align', impeka_elementor_ext_add_responsive_align() );
		$this->add_control( 'margin_bottom', impeka_elementor_ext_add_margin_bottom() );
		$this->add_control( 'el_class', impeka_elementor_ext_add_el_class() );
		$this->end_controls_section();

		//Icon Section
		$this->start_controls_section(
			'icon_section',
			[
				'label' => esc_html__( 'Icon', 'impeka-elementor-extension' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'icon_type',
			[
				'label' => esc_html__( 'Icon type', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					''  => esc_html__( 'No Icon', 'impeka-elementor-extension' ),
					'icon'  => esc_html__( 'Icon', 'impeka-elementor-extension' ),
				),
				'default' => '',
			]
		);
		$this->add_control(
			'icon_size',
			[
				'label' => esc_html__( 'Icon Size', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,

				'options' => [
					'small' => esc_html__( 'Small', 'impeka-elementor-extension' ),
					'medium' => esc_html__( 'Medium', 'impeka-elementor-extension' ),
					'large' => esc_html__( 'Large', 'impeka-elementor-extension' ),
					'extra-large' => esc_html__( 'Extra Large', 'impeka-elementor-extension' ),
				],
				'default' => 'medium',
				'description' => esc_html__( "Select icon size.", 'impeka-elementor-extension' ),
				'condition' => [
					'icon_type' => [ 'icon' ],
				],
			]
		);
		$this->add_control(
			'icon',
			[
				'label' => esc_html__( 'Icon', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::ICONS,
				'default' => [
					'value' => 'fas fa-star',
					'library' => 'fa-solid',
				],
				'condition' => [
					'icon_type' => [ 'icon' ],
				],
			]
		);
		$this->add_control(
			'icon_color',
			[
				'label' => esc_html__( 'Icon Color', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => impeka_elementor_ext_get_color_array(),
				'default' => 'primary-1',
				'description' => esc_html__( 'Select the color of your icon.', 'impeka-elementor-extension' ),
				'condition' => [
					'icon_type' => [ 'icon' ],
				],
			]
		);
		$this->end_controls_section();

		//Animation Section
		$this->start_controls_section(
			'animation_section',
			[
				'label' => esc_html__( 'Animation', 'impeka-elementor-extension' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control( 'grve_animation', impeka_elementor_ext_add_animation() );
		$this->add_control( 'grve_animation_delay', impeka_elementor_ext_add_animation_delay() );
		$this->add_control( 'grve_animation_duration', impeka_elementor_ext_add_animation_duration() );
		$this->end_controls_section();


	}

	/**
	 * Render widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function render() {
		$atts = $this->get_settings_for_display();


		echo impeka_elementor_ext_locate_template( 'fancy-box.php', array( 'atts' => $atts ) );
	}

}