<?php
/**
 * Impeka Elementor Map Widget.
 *
 * Elementor widget that inserts a divider element into the page.
 *
 * @since 1.0.0
 */
class Impeka_Elementor_Map_Widget extends \Elementor\Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'impeka_map';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Impeka Map', 'impeka-elementor-extension' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'impeka-map';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'impeka' ];
	}

	/**
	 * Register widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function register_controls() {

		$this->start_controls_section(
			'general_section',
			[
				'label' => esc_html__( 'General', 'impeka-elementor-extension' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		
		$this->add_control(
			'map_zoom',
			[
				'label' => esc_html__( 'Map Zoom', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [ '1', '2', '3', '4' , '5', '6', '7', '8', '9' , '10', '11', '12', '13', '14' , '15', '16', '17', '18', '19' ],
				'default' => '14',
				'description' => esc_html__( 'Zoom of the map.', 'impeka-elementor-extension' ),
			]
		);
		
		$this->add_control(
			'map_height',
			[
				'label' => esc_html__( 'Map Height', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => '280',
				'description' => esc_html__( "Type map height.", 'impeka-elementor-extension' ),
			]
		);

		$this->add_control(
			'map_disable_style',
			[
				'label' => esc_html__( 'Disable Custom Style', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'no' => esc_html__( 'No', 'impeka-elementor-extension' ),
					'yes' => esc_html__( 'Yes ( Disable )', 'impeka-elementor-extension' ),
				],
				'default' => 'no',
				'description' => esc_html__( 'Select if you want to disable custom map style."', 'impeka-elementor-extension' ),
			]
		);
		$this->add_control( 'margin_bottom', impeka_elementor_ext_add_margin_bottom() );
		$this->add_control( 'el_class', impeka_elementor_ext_add_el_class() );
		$this->end_controls_section();	

		$this->start_controls_section(
			'map_points_section',
			[
				'label' => esc_html__( 'Map Points', 'impeka-elementor-extension' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);		

		$this->add_control(
			'map_mode',
			[
				'label' => esc_html__( 'Map Mode', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'' => esc_html__( 'Single Marker', 'impeka-elementor-extension' ),
					'multiple' => esc_html__( 'Multiple Markers', 'impeka-elementor-extension' ),
				],
				'default' => '',
				'description' => esc_html__( 'Select if you want to disable custom map style.', 'impeka-elementor-extension' ),
			]
		);
		
		$this->add_control(
			'map_marker_type',
			[
				'label' => esc_html__( 'Global Marker Type', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'' => esc_html__( 'Image', 'impeka-elementor-extension' ),
					'pulse-dot' => esc_html__( 'Pulse Dot Icon', 'impeka-elementor-extension' ),
					'dot' => esc_html__( 'Dot Icon', 'impeka-elementor-extension' ),
				],
				'default' => '',
				'description' => esc_html__( 'Select the type of your marker.', 'impeka-elementor-extension' ),
			]
		);
		
		$this->add_control(
			'map_marker',
			[
				'label' => esc_html__( 'Global Custom marker"', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'dynamic' => [
					'active' => false,
				],
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
				'description' => esc_html__( "Select an icon for the custom marker.", 'impeka-elementor-extension' ),
				'condition' => [
					'map_marker_type' => [ '' ],
				],
			]
		);
		
		$this->add_control(
			'map_marker_bg_color',
			[
				'label' => esc_html__( 'Background Color"', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => impeka_elementor_ext_get_color_array(),
				'default' => 'primary-1',
				'description' => esc_html__( 'Select the color of your icon.', 'impeka-elementor-extension' ),
				'condition' => [
					'map_marker_type' => [ 'pulse-dot', 'dot' ],
				],
			]
		);

		$this->add_control(
			'map_lat',
			[
				'label' => esc_html__( 'Map Latitude', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => '51.516221',
				'description' => esc_html__( 'Type map Latitude.', 'impeka-elementor-extension' ),
				'condition' => [
					'map_mode' => [ '' ],
				],
			]
		);

		$this->add_control(
			'map_lng',
			[
				'label' => esc_html__( 'Map Longtitude', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => '-0.136986',
				'description' => esc_html__( 'Type map Longtitude.', 'impeka-elementor-extension' ),
				'condition' => [
					'map_mode' => [ '' ],
				],
			]
		);

		$repeater = new \Elementor\Repeater();

		$repeater->add_control(
			'title',
			[
				'label' => esc_html__( 'Title', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => '',
				'description' => esc_html__( 'Enter your point title.', 'impeka-elementor-extension' ),
			]
		);
		
		$repeater->add_control(
			'marker',
			[
				'label' => esc_html__( 'Marker"', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'dynamic' => [
					'active' => false,
				],
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
				'description' => esc_html__( "Select an icon for your point marker. Note: if empty global marker will be used instead.", 'impeka-elementor-extension' ),
			]
		);
		
		$repeater->add_control(
			'lat',
			[
				'label' => esc_html__( 'Latitude', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => '51.516221',
				'description' => esc_html__( 'Type map point Latitude.', 'impeka-elementor-extension' ),
			]
		);

		$repeater->add_control(
			'lng',
			[
				'label' => esc_html__( 'Longtitude', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => '-0.136986',
				'description' => esc_html__( 'Type map point Longtitude.', 'impeka-elementor-extension' ),
			]
		);

		$repeater->add_control(
			'infotext',
			[
				'label' => esc_html__( 'Info Text', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::TEXTAREA,
				'default' => '',
				'description' => esc_html__( 'Enter your info text.', 'impeka-elementor-extension' ),
			]
		);
		
		$repeater->add_control(
			'infotext_open',
			[
				'label' => esc_html__( 'Open Info Text Onload', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'no' => esc_html__( 'No', 'impeka-elementor-extension' ),
					'yes' => esc_html__( 'Yes', 'impeka-elementor-extension' ),
				],
				'default' => 'no',
				'description' => esc_html__( 'Select if you want to open info text on load.', 'impeka-elementor-extension' ),
			]
		);
		
		$repeater->add_control(
			'link_text',
			[
				'label' => esc_html__( 'Link Text', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => '',
				'description' => esc_html__( "Enter your link text.", 'impeka-elementor-extension' ),
			]
		);
		$repeater->add_control(
			'link',
			[
				'label' => esc_html__( 'Link', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::URL,
				'dynamic' => [
					'active' => false,
				],
				'placeholder' => 'https://your-link.com',
			]
		);
		$repeater->add_control(
			'link_class',
			[
				'label' => esc_html__( 'Link Class', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => '',
				'description' => esc_html__( "Enter a class for your link.", 'impeka-elementor-extension' ),
			]
		);

		$this->add_control(
			'map_points',
			[
				'label' => esc_html__( 'Map Points', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'default' => [
					[
						'title' => 'Point 1',
						'lat' => '51.516221',
						'lng' => '-0.136986',
					],

				],
				'description' => esc_html__( "Configure your map points.", 'impeka-elementor-extension' ),
				'condition' => [
					'map_mode' => [ 'multiple' ],
				],
			]
		);
		
		$this->end_controls_section();

	}

	/**
	 * Render widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function render() {
		$atts = $this->get_settings_for_display();

		echo impeka_elementor_ext_locate_template( 'gmap.php', array( 'atts' => $atts ) );
	}

}