<?php
/**
 * Impeka Elementor Media Box Widget.
 *
 * Elementor widget that inserts an media box into the page.
 *
 * @since 1.0.0
 */
class Impeka_Elementor_Media_Box_Widget extends \Elementor\Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'impeka_media_box';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Impeka Media Box', 'impeka-elementor-extension' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'impeka-media-box';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'impeka' ];
	}

	/**
	 * Register widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function register_controls() {

		$this->start_controls_section(
			'general_section',
			[
				'label' => esc_html__( 'General', 'impeka-elementor-extension' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'media_type',
			[
				'label' => esc_html__( 'Media type', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'image' => esc_html__( 'Image', 'impeka-elementor-extension' ),
					'image-video-popup' => esc_html__( 'Image - Video Popup', 'impeka-elementor-extension' ),
					'video' => esc_html__( 'Video', 'impeka-elementor-extension' ),
					'map' => esc_html__( 'Map', 'impeka-elementor-extension' ),
				],
				'default' => 'image',
				'description' => esc_html__( 'Select your media type.', 'impeka-elementor-extension' ),
			]
		);

		$this->add_control(
			'media_style',
			[
				'label' => esc_html__( 'Style', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'style-1' => esc_html__( 'Classic', 'impeka-elementor-extension' ),
					'style-2' => esc_html__( 'Background Image', 'impeka-elementor-extension' ),
				],
				'default' => 'style-1',
				'description' => esc_html__( 'Select your media box style.', 'impeka-elementor-extension' ),
				'condition' => [
					'media_type' => [ 'image', 'image-video-popup' ],
				],
			]
		);

		$this->add_control(
			'image_mode',
			[
				'label' => esc_html__( 'Image Size', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => apply_filters( 'impeka_elementor_ext_image_options', array(
					''  => esc_html__( 'Full', 'impeka-elementor-extension' ),
					'square'  => esc_html__( 'Square Small Crop', 'impeka-elementor-extension' ),
					'landscape'  => esc_html__( 'Landscape Small Crop', 'impeka-elementor-extension' ),
					'landscape-medium'  => esc_html__( 'Landscape Medium Crop', 'impeka-elementor-extension' ),
					'portrait'  => esc_html__( 'Portrait Small Crop', 'impeka-elementor-extension' ),
					'portrait-medium'  => esc_html__( 'Portrait Medium Crop', 'impeka-elementor-extension' ),
					'extra-extra-large' => esc_html__( 'Resize ( Extra Extra Large )', 'impeka-elementor-extension' ),
					'large' => esc_html__( 'Resize ( Large )', 'impeka-elementor-extension' ),
					'medium_large' => esc_html__( 'Resize ( Medium Large )', 'impeka-elementor-extension' ),
					'medium' => esc_html__( 'Resize ( Medium )', 'impeka-elementor-extension' ),
					'thumbnail' => esc_html__( 'Thumbnail', 'impeka-elementor-extension' ),
				) ),
				'default' => '',
				'description' => esc_html__( "Select your Image Size.", 'impeka-elementor-extension' ),
				'condition' => [
					'media_type' => [ 'image', 'image-video-popup' ],
					'media_style' => [ 'style-1' ],
				],
			]
		);
		$this->add_control(
			'bg_image_size',
			[
				'label' => esc_html__( 'Image Size', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => apply_filters( 'impeka_elementor_ext_image_options', array(
					''  => esc_html__( 'Full', 'impeka-elementor-extension' ),
					'extra-extra-large' => esc_html__( 'Resize ( Extra Extra Large )', 'impeka-elementor-extension' ),
					'large' => esc_html__( 'Resize ( Large )', 'impeka-elementor-extension' ),
					'medium_large' => esc_html__( 'Resize ( Medium Large )', 'impeka-elementor-extension' ),
					'medium' => esc_html__( 'Resize ( Medium )', 'impeka-elementor-extension' ),
					'thumbnail' => esc_html__( 'Thumbnail', 'impeka-elementor-extension' ),
				) ),
				'default' => '',
				'description' => esc_html__( "Select your Image Size.", 'impeka-elementor-extension' ),
				'condition' => [
					'media_type' => [ 'image', 'image-video-popup' ],
					'media_style' => [ 'style-2' ],
				],
			]
		);

		$this->add_control(
			'image',
			[
				'label' => esc_html__( 'Image', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'dynamic' => [
					'active' => false,
				],
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
				'description' => esc_html__( "Select your image.", 'impeka-elementor-extension' ),
				'condition' => [
					'media_type' => [ 'image', 'image-video-popup' ],
				],
			]
		);

		$this->add_control(
			'retina_image',
			[
				'label' => esc_html__( 'Retina Image', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'dynamic' => [
					'active' => true,
				],
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
				'description' => esc_html__( "Select a 2x image.", 'impeka-elementor-extension' ),
				'condition' => [
					'media_type' => [ 'image', 'image-video-popup' ],
					'media_style' => [ 'style-1' ],
					'image_mode' => [ '' ],
				],
			]
		);
		$this->add_control(
			'image_load_mode',
			[
				'label' => esc_html__( 'Image Load Mode', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'' => esc_html__( 'Inherit', 'impeka-elementor-extension' ),
					'off' => esc_html__( 'Off', 'impeka-elementor-extension' ),
					'native-lazyload' => esc_html__( 'Native Lazyload', 'impeka-elementor-extension' ),
					'lazyload' => esc_html__( 'Theme Lazyload', 'impeka-elementor-extension' ),
				),
				'default' => '',
				'description' => esc_html__( "Enable Lazy load.", 'impeka-elementor-extension' ),
				'condition' => [
					'media_type' => [ 'image', 'image-video-popup' ],
				],
			]
		);
		$this->add_control(
			'overlay_color',
			[
				'label' => esc_html__( 'Overlay Color', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => impeka_elementor_ext_get_color_array( ['primary', 'gradient', 'standard'] ),
				'description' => esc_html__( 'Choose the image color overlay.', 'impeka-elementor-extension' ),
				'default' => 'black',
				'condition' => [
					'media_type' => [ 'image', 'image-video-popup' ],
				],
			]
		);

		$this->add_control(
			'overlay_opacity',
			[
				'label' => esc_html__( 'Overlay Opacity', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'0' => esc_html__( '0%', 'impeka-elementor-extension' ),
					'10' => esc_html__( '10%', 'impeka-elementor-extension' ),
					'20' => esc_html__( '20%', 'impeka-elementor-extension' ),
					'30' => esc_html__( '30%', 'impeka-elementor-extension' ),
					'40' => esc_html__( '40%', 'impeka-elementor-extension' ),
					'50' => esc_html__( '50%', 'impeka-elementor-extension' ),
					'60' => esc_html__( '60%', 'impeka-elementor-extension' ),
					'70' => esc_html__( '70%', 'impeka-elementor-extension' ),
					'80' => esc_html__( '80%', 'impeka-elementor-extension' ),
					'90' => esc_html__( '90%', 'impeka-elementor-extension' ),
					'100' => esc_html__( '100%', 'impeka-elementor-extension' ),
				],
				'description' => esc_html__( 'Choose the opacity for the overlay.', 'impeka-elementor-extension' ),
				'default' => '10',
				'condition' => [
					'media_type' => [ 'image', 'image-video-popup' ],
				],
			]
		);
		$this->add_control( 'shadow',
			[
				'label' => esc_html__( 'Shadow', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'' => esc_html__( 'None' , 'impeka-elementor-extension' ),
					'small-shadow' => esc_html__( 'Small' , 'impeka-elementor-extension' ),
					'medium-shadow' => esc_html__( 'Medium' , 'impeka-elementor-extension' ),
					'large-shadow' => esc_html__( 'Large' , 'impeka-elementor-extension' ),
				],
				'description' => esc_html__( 'Select your shadow', 'impeka-elementor-extension' ),
				'default' => '',
				'condition' => [
					'media_type' => [ 'image', 'image-video-popup' ],
				],
			]
		);
		$this->add_control(
			'image_shape',
			[
				'label' => esc_html__( 'Media shape', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'square' => esc_html__( 'Square' , 'impeka-elementor-extension' ),
					'3' => esc_html__( 'Radius 3px' , 'impeka-elementor-extension' ),
					'5' => esc_html__( 'Radius 5px' , 'impeka-elementor-extension' ),
					'10' => esc_html__( 'Radius 10px' , 'impeka-elementor-extension' ),
					'15' => esc_html__( 'Radius 15px' , 'impeka-elementor-extension' ),
					'20' => esc_html__( 'Radius 20px' , 'impeka-elementor-extension' ),
					'25' => esc_html__( 'Radius 25px' , 'impeka-elementor-extension' ),
					'30' => esc_html__( 'Radius 30px' , 'impeka-elementor-extension' ),
					'35' => esc_html__( 'Radius 35px' , 'impeka-elementor-extension' ),
				],
				'description' => esc_html__( 'Select your border radius', 'impeka-elementor-extension' ),
				'default' => 'square',
				'condition' => [
					'media_type' => [ 'image', 'image-video-popup' ],
				],
			]
		);
		$this->add_control(
			'video_link',
			[
				'label' => esc_html__( 'Video Link', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => '',
				'description' => esc_html__( "Type a YouTube/Vimeo URL.", 'impeka-elementor-extension' ),
				'condition' => [
					'media_type' => [ 'image-video-popup', 'video' ],
				],
			]
		);
		$this->add_control(
			'video_icon_color',
			[
				'label' => esc_html__( 'Video Icon Color', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => impeka_elementor_ext_get_color_array(),
				'default' => 'primary-1',
				'description' => esc_html__( 'Color of the video icon.', 'impeka-elementor-extension' ),
				'condition' => [
					'media_type' => [ 'image-video-popup', 'video' ],
				],
			]
		);

		$this->add_control(
			'map_lat',
			[
				'label' => esc_html__( 'Map Latitude', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => '51.516221',
				'description' => esc_html__( 'Type map Latitude.', 'impeka-elementor-extension' ),
				'condition' => [
					'media_type' => [ 'map' ],
				],
			]
		);

		$this->add_control(
			'map_lng',
			[
				'label' => esc_html__( 'Map Longtitude', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => '-0.136986',
				'description' => esc_html__( 'Type map Longtitude.', 'impeka-elementor-extension' ),
				'condition' => [
					'media_type' => [ 'map' ],
				],
			]
		);
		$this->add_control(
			'map_zoom',
			[
				'label' => esc_html__( 'Map Zoom', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [ '1', '2', '3', '4' , '5', '6', '7', '8', '9' , '10', '11', '12', '13', '14' , '15', '16', '17', '18', '19' ],
				'default' => '14',
				'description' => esc_html__( 'Zoom of the map.', 'impeka-elementor-extension' ),
				'condition' => [
					'media_type' => [ 'map' ],
				],
			]
		);

		$this->add_control(
			'map_height',
			[
				'label' => esc_html__( 'Map Height', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => '280',
				'description' => esc_html__( "Type map height.", 'impeka-elementor-extension' ),
				'condition' => [
					'media_type' => [ 'map' ],
				],
			]
		);
		$this->add_control(
			'map_disable_style',
			[
				'label' => esc_html__( 'Disable Custom Style', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'no' => esc_html__( 'No', 'impeka-elementor-extension' ),
					'yes' => esc_html__( 'Yes ( Disable )', 'impeka-elementor-extension' ),
				],
				'default' => 'no',
				'description' => esc_html__( 'Select if you want to disable custom map style."', 'impeka-elementor-extension' ),
				'condition' => [
					'media_type' => [ 'map' ],
				],
			]
		);
		$this->add_control(
			'map_marker',
			[
				'label' => esc_html__( 'Custom marker"', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'dynamic' => [
					'active' => false,
				],
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
				'description' => esc_html__( "Select an icon for the custom marker.", 'impeka-elementor-extension' ),
				'condition' => [
					'media_type' => [ 'map' ],
				],
			]
		);

		$this->add_control(
			'title',
			[
				'label' => esc_html__( 'Title', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => 'Title',
				'description' => esc_html__( "Enter your title here.", 'impeka-elementor-extension' ),
			]
		);
		$this->add_control( 'heading_tag', impeka_elementor_ext_add_heading_tag( 'h3' ) );
		$this->add_control( 'heading', impeka_elementor_ext_add_heading( 'h3' ) );
		$this->add_control( 'custom_font_family', impeka_elementor_ext_add_custom_font_family() );
		$this->add_control(
			'content',
			[
				'label' => esc_html__( 'Text', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::TEXTAREA,
				'default' => 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut viverra iaculis purus non bibendum. Vestibulum sit amet risus sit amet elit elementum convallis. Phasellus varius leo at mi accumsan aliquam.',
				'description' => esc_html__( "Enter your text", 'impeka-elementor-extension' ),
			]
		);
		$this->add_control(
			'text_style',
			[
				'label' => esc_html__( 'Text Style', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'' => esc_html__( 'None', 'impeka-elementor-extension' ),
					'leader-text' => esc_html__( 'Leader Text', 'impeka-elementor-extension' ),
					'subtitle-text' => esc_html__( 'Subtitle Text', 'impeka-elementor-extension' ),
					'page-description' => esc_html__( 'Page Description', 'impeka-elementor-extension' ),
				],
				'default' => '',
				'description' => esc_html__( 'Text size and typography, defined in Theme Options - Typography Options', 'impeka-elementor-extension' ),
			]
		);
		$this->add_control(
			'read_more_title',
			[
				'label' => esc_html__( 'Read More Title', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => '',
				'description' => esc_html__( "Enter your title for your link.", 'impeka-elementor-extension' ),
			]
		);
		$this->add_control(
			'title_link',
			[
				'label' => esc_html__( 'Title Link', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::URL,
				'dynamic' => [
					'active' => false,
				],
				'placeholder' => 'https://your-link.com',
			]
		);
		$this->add_control(
			'link_class',
			[
				'label' => esc_html__( 'Link Class', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => '',
				'description' => esc_html__( "Enter a class for your link.", 'impeka-elementor-extension' ),
			]
		);
		$this->add_control(
			'min_height',
			[
				'label' => esc_html__( 'Min Height', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => '400',
				'description' => esc_html__( "Enter min height for your media box (Note: CSS measurement units allowed).", 'impeka-elementor-extension' ),
				'condition' => [
					'media_type' => [ 'image', 'image-video-popup' ],
					'media_style' => [ 'style-2' ],
				],
			]
		);

		$this->add_responsive_control( 'align', impeka_elementor_ext_add_responsive_align() );
		$this->add_control( 'margin_bottom', impeka_elementor_ext_add_margin_bottom() );
		$this->add_control( 'el_class', impeka_elementor_ext_add_el_class() );
		$this->end_controls_section();

		//Animation Section
		$this->start_controls_section(
			'animation_section',
			[
				'label' => esc_html__( 'Animation', 'impeka-elementor-extension' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control( 'grve_animation', impeka_elementor_ext_add_animation_all() );
		$this->add_control( 'grve_animation_delay', impeka_elementor_ext_add_animation_delay() );
		$this->add_control( 'grve_animation_duration', impeka_elementor_ext_add_animation_duration() );
		$this->end_controls_section();
	}

	/**
	 * Render widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function render() {
		$atts = $this->get_settings_for_display();


		echo impeka_elementor_ext_locate_template( 'media-box.php', array( 'atts' => $atts ) );
	}

}