<?php
/**
 * Impeka Elementor Pie Chart Widget.
 *
 * Elementor widget that inserts a pie chart element into the page.
 *
 * @since 1.0.0
 */
class Impeka_Elementor_Pie_Chart_Widget extends \Elementor\Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'impeka_pie_chart';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Impeka Pie Chart', 'impeka-elementor-extension' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'impeka-pie-charts';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'impeka' ];
	}

	/**
	 * Register widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function register_controls() {

		$this->start_controls_section(
			'general_section',
			[
				'label' => esc_html__( 'General', 'impeka-elementor-extension' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'pie_chart_val',
			[
				'label' => esc_html__( 'Pie Chart Value', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => '50',
				'description' => esc_html__( 'Enter the pie chart value number.', 'impeka-elementor-extension' ),
			]
		);
		$this->add_control(
			'pie_chart_prefix',
			[
				'label' => esc_html__( 'Value Prefix', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => '',
				'description' => esc_html__( 'Enter pie chart value prefix.', 'impeka-elementor-extension' ),
			]
		);

		$this->add_control(
			'pie_chart_suffix',
			[
				'label' => esc_html__( 'Value Suffix', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => '',
				'description' => esc_html__( 'Enter pie chart value suffix.', 'impeka-elementor-extension' ),
			]
		);

		$this->add_control(
			'pie_chart_size',
			[
				'label' => esc_html__( 'Pie Chart Size', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'small' => esc_html__( 'Small', 'impeka-elementor-extension' ),
					'medium' => esc_html__( 'Medium', 'impeka-elementor-extension' ),
					'large' => esc_html__( 'Large', 'impeka-elementor-extension' ),
				],
				'default' => 'medium',
				'description' => esc_html__( 'Select pie chart size.', 'impeka-elementor-extension' ),
			]
		);

		$this->add_control(
			'pie_chart_line_size',
			[
				'label' => esc_html__( 'Pie Chart Line Size', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => '6',
				'description' => esc_html__( 'Enter pie chart line size.', 'impeka-elementor-extension' ),
			]
		);

		$this->add_control(
			'pie_line_style',
			[
				'label' => esc_html__( 'Pie Chart Style', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'square' => esc_html__( 'Square', 'impeka-elementor-extension' ),
					'round' => esc_html__( 'Round', 'impeka-elementor-extension' ),
				],
				'default' => 'square',
				'description' => esc_html__( 'Set the pie chart shape style.', 'impeka-elementor-extension' ),
			]
		);

		$this->add_control(
			'pie_chart_val_color',
			[
				'label' => esc_html__( 'Pie Chart Value Color', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'scheme' => [
					'type' => \Elementor\Core\Schemes\Color::get_type(),
					'value' => \Elementor\Core\Schemes\Color::COLOR_1,
				],
				'description' => esc_html__( "Select the value color for your pie.", 'impeka-elementor-extension' ),
			]
		);
		$this->add_control(
			'pie_active_color',
			[
				'label' => esc_html__( 'Pie Chart Active Color', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'scheme' => [
					'type' => \Elementor\Core\Schemes\Color::get_type(),
					'value' => \Elementor\Core\Schemes\Color::COLOR_1,
				],
				'description' => esc_html__( "Select the active color for your pie.", 'impeka-elementor-extension' ),
			]
		);
		$this->add_control(
			'pie_chart_color',
			[
				'label' => esc_html__( 'Pie Chart Base Color', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'scheme' => [
					'type' => \Elementor\Core\Schemes\Color::get_type(),
					'value' => \Elementor\Core\Schemes\Color::COLOR_1,
				],
				'description' => esc_html__( "Select the value color for your pie.", 'impeka-elementor-extension' ),
			]
		);

		$this->add_control(
			'title',
			[
				'label' => esc_html__( 'Title', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => '',
				'description' => esc_html__( "Enter pie chart title", 'impeka-elementor-extension' ),
			]
		);
		$this->add_control(
			'title_color',
			[
				'label' => esc_html__( 'Title Color', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => impeka_elementor_ext_get_color_array( ['inherit', 'primary', 'standard'] ),
				'default' => 'inherit',
				'description' => esc_html__( 'Choose the title color.', 'impeka-elementor-extension' ),
			]
		);
		$this->add_control( 'heading_tag', impeka_elementor_ext_add_heading_tag( 'h3' ) );
		$this->add_control( 'heading', impeka_elementor_ext_add_heading( 'h3' ) );
		$this->add_control( 'custom_font_family', impeka_elementor_ext_add_custom_font_family() );

		$this->add_control(
			'pie_chart_text',
			[
				'label' => esc_html__( 'Text', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::TEXTAREA,
				'default' => '',
				'description' => esc_html__( 'Type your text', 'impeka-elementor-extension' ),
			]
		);
		$this->add_control(
			'text_color',
			[
				'label' => esc_html__( 'Text Color', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => impeka_elementor_ext_get_color_array( ['inherit', 'primary', 'standard'] ),
				'default' => 'inherit',
				'description' => esc_html__( 'Choose the text color.', 'impeka-elementor-extension' ),
			]
		);
		$this->add_control( 'margin_bottom', impeka_elementor_ext_add_margin_bottom() );
		$this->add_control( 'el_class', impeka_elementor_ext_add_el_class() );
		$this->end_controls_section();


		//Animation Section
		$this->start_controls_section(
			'animation_section',
			[
				'label' => esc_html__( 'Animation', 'impeka-elementor-extension' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control( 'grve_animation', impeka_elementor_ext_add_animation() );
		$this->add_control( 'grve_animation_delay', impeka_elementor_ext_add_animation_delay() );
		$this->add_control( 'grve_animation_duration', impeka_elementor_ext_add_animation_duration() );
		$this->end_controls_section();

	}

	/**
	 * Render widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function render() {
		$atts = $this->get_settings_for_display();

		echo impeka_elementor_ext_locate_template( 'pie-chart.php', array( 'atts' => $atts ) );
	}

}