<?php
/**
 * Impeka Elementor Products Carousel Widget.
 *
 * Elementor widget that inserts a products grid into the page.
 *
 * @since 1.0.0
 */
class Impeka_Elementor_Products_Carousel_Widget extends \Elementor\Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'impeka_products_carousel';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Impeka Products Carousel', 'impeka-elementor-extension' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'impeka-product';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'impeka' ];
	}

	/**
	 * Register widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function register_controls() {

		$this->start_controls_section(
			'general_section',
			[
				'label' => esc_html__( 'General', 'impeka-elementor-extension' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'type',
			[
				'label' => esc_html__( 'Carousel Type', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'classic'  => esc_html__( 'Classic', 'impeka-elementor-extension' ),
					'advanced'  => esc_html__( 'Advanced', 'impeka-elementor-extension' ),
				],
				'default' => 'classic',
				'description' => esc_html__( "Select your Carousel Type.", 'impeka-elementor-extension' ),
			]
		);
		$this->add_control(
			'image_mode',
			[
				'label' => esc_html__( 'Image Size', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => apply_filters( 'impeka_elementor_ext_image_options', array(
					'square' => esc_html__( 'Square Small Crop', 'impeka-elementor-extension' ),
					'landscape' => esc_html__( 'Landscape Small Crop', 'impeka-elementor-extension' ),
					'landscape-medium' => esc_html__( 'Landscape Medium Crop', 'impeka-elementor-extension' ),
					'portrait' => esc_html__( 'Portrait Small Crop', 'impeka-elementor-extension' ),
					'portrait-medium' => esc_html__( 'Portrait Medium Crop', 'impeka-elementor-extension' ),
					'large' => esc_html__( 'Resize ( Large )', 'impeka-elementor-extension' ),
					'medium_large' => esc_html__( 'Resize ( Medium Large )', 'impeka-elementor-extension' ),
					'medium' => esc_html__( 'Resize ( Medium )', 'impeka-elementor-extension' ),
				) ),
				'default' => 'landscape',
				'description' => esc_html__( "Select your Image Size.", 'impeka-elementor-extension' ),
			]
		);

		$this->add_control(
			'items_per_page',
			[
				'label' => esc_html__( 'Items per page', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'1' => '1',
					'2' => '2',
					'3' => '3',
					'4' => '4',
					'5' => '5',
					'6' => '6',
				],
				'default' => '4',
				'description' => esc_html__( "Number of items per page", 'impeka-elementor-extension' ),
			]
		);
		$this->add_control(
			'items_tablet_landscape',
			[
				'label' => esc_html__( 'Items Tablet Landscape', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'1' => '1',
					'2' => '2',
					'3' => '3',
					'4' => '4',
				],
				'default' => '3',
				'description' => esc_html__( "Select number of items on tablet devices, landscape orientation.", 'impeka-elementor-extension' ),
			]
		);
		$this->add_control(
			'items_tablet_portrait',
			[
				'label' => esc_html__( 'Items Tablet Portrait', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'1' => '1',
					'2' => '2',
					'3' => '3',
					'4' => '4',
				],
				'default' => '3',
				'description' => esc_html__( "Select number of items on tablet devices, portrait orientation.", 'impeka-elementor-extension' ),
			]
		);
		$this->add_control(
			'items_mobile',
			[
				'label' => esc_html__( 'Items Mobile', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'1' => '1',
					'2' => '2',
					'3' => '3',
				],
				'default' => '1',
				'description' => esc_html__( "Select number of items on mobile devices.", 'impeka-elementor-extension' ),
			]
		);
		$this->add_control(
			'item_gutter',
			[
				'label' => esc_html__( 'Gutter between items', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Yes', 'impeka-elementor-extension' ),
				'label_off' => esc_html__( 'No', 'impeka-elementor-extension' ),
				'return_value' => 'yes',
				'default' => 'yes',
				'condition' => [
					'type' => [ 'classic' ],
				],
			]
		);
		$this->add_control(
			'gutter_size',
			[
				'label' => esc_html__( 'Gutter Size', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => '30',
				'condition' => [
					'item_gutter' => [ 'yes' ],
				],
			]
		);
		$this->add_control(
			'items_to_show',
			[
				'label' => esc_html__( 'Items to show', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => '12',
				'description' => esc_html__( "Maximum Items to Show", 'impeka-elementor-extension' ),
			]
		);
		$this->add_control( 'order_by', impeka_elementor_ext_add_order_by() );
		$this->add_control( 'order', impeka_elementor_ext_add_order() );
		$this->add_control( 'margin_bottom', impeka_elementor_ext_add_margin_bottom() );
		$this->add_control( 'el_class', impeka_elementor_ext_add_el_class() );
		$this->end_controls_section();

		//Styles Section
		$this->start_controls_section(
			'styles_section',
			[
				'label' => esc_html__( 'Styles & Titles', 'impeka-elementor-extension' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'title_heading_tag',
			[
				'label' => esc_html__( 'Title Tag', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'h1' => 'h1',
					'h2' => 'h2',
					'h3' => 'h3',
					'h4' => 'h4',
					'h5' => 'h5',
					'h6' => 'h6',
					'div' => 'div',
				],
				'description' => esc_html__( 'Title Tag for SEO', 'impeka-elementor-extension' ),
				'default' => 'h3',
			]
		);

		$this->add_control(
			'title_heading',
			[
				'label' => esc_html__( 'Title Size/Typography', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'h1' => 'h1',
					'h2' => 'h2',
					'h3' => 'h3',
					'h4' => 'h4',
					'h5' => 'h5',
					'h6' => 'h6',
					'leader-text' => esc_html__( 'Leader Text', 'impeka-elementor-extension' ),
					'subtitle-text' => esc_html__( 'Subtitle Text', 'impeka-elementor-extension' ),
					'small-text' => esc_html__( 'Small Text', 'impeka-elementor-extension' ),
					'link-text' => esc_html__( 'Link Text', 'impeka-elementor-extension' ),
				],
				'default' => 'h6',
				'description' => esc_html__( 'Title size and typography, defined in Theme Options - Typography Options', 'impeka-elementor-extension' ),
			]
		);		
		$this->add_control(
			'hover_style',
			[
				'label' => esc_html__( 'Product Style - Hovers', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'hover-style-1' => esc_html__( 'Content Below Image' , 'impeka-elementor-extension' ),
					'hover-style-2' => esc_html__( 'Top Down Animated Content' , 'impeka-elementor-extension' ),
				],
				'description' => esc_html__( 'Select the hover style for the products overview.', 'impeka-elementor-extension' ),
				'default' => 'hover-style-1',
			]
		);
		$this->add_control(
			'second_image_effect',
			[
				'label' => esc_html__( 'Second Image Effect', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Yes', 'impeka-elementor-extension' ),
				'label_off' => esc_html__( 'No', 'impeka-elementor-extension' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);
		$this->add_control(
			'text_color',
			[
				'label' => esc_html__( 'Text Color', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => impeka_elementor_ext_get_color_array( ['default', 'primary', 'standard'] ),
				'description' => esc_html__( 'Choose the text color.', 'impeka-elementor-extension' ),
				'default' => 'default',
			]
		);		
		$this->add_control(
			'overlay_color',
			[
				'label' => esc_html__( 'Overlay Color', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => impeka_elementor_ext_get_color_array( ['primary', 'gradient', 'standard'] ),
				'description' => esc_html__( 'Choose the image color overlay.', 'impeka-elementor-extension' ),
				'default' => 'white',
			]
		);
		$this->add_control(
			'overlay_opacity',
			[
				'label' => esc_html__( 'Overlay Opacity', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'0' => esc_html__( '0%', 'impeka-elementor-extension' ),
					'10' => esc_html__( '10%', 'impeka-elementor-extension' ),
					'20' => esc_html__( '20%', 'impeka-elementor-extension' ),
					'30' => esc_html__( '30%', 'impeka-elementor-extension' ),
					'40' => esc_html__( '40%', 'impeka-elementor-extension' ),
					'50' => esc_html__( '50%', 'impeka-elementor-extension' ),
					'60' => esc_html__( '60%', 'impeka-elementor-extension' ),
					'70' => esc_html__( '70%', 'impeka-elementor-extension' ),
					'80' => esc_html__( '80%', 'impeka-elementor-extension' ),
					'90' => esc_html__( '90%', 'impeka-elementor-extension' ),
					'100' => esc_html__( '100%', 'impeka-elementor-extension' ),
				],
				'description' => esc_html__( 'Choose the overlay opacity ', 'impeka-elementor-extension' ),
				'default' => '90',
			]
		);
		$this->end_controls_section();

		//Navigation
		$this->start_controls_section(
			'navigation_pagination_section',
			[
				'label' => esc_html__( 'Navigation & Pagination', 'impeka-elementor-extension' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'label_behavior',
			[
				'label' => esc_html__( 'Behavior', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);
		$this->add_control( 'loop', impeka_elementor_ext_add_loop() );
		$this->add_control( 'auto_play', impeka_elementor_ext_add_auto_play() );
		$this->add_control( 'slideshow_speed', impeka_elementor_ext_add_slideshow_speed() );
		$this->add_control( 'pause_hover', impeka_elementor_ext_add_pause_hover() );

		$this->add_control(
			'label_navigation',
			[
				'label' => esc_html__( 'Navigation', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);
		$this->add_control( 'nav_visibility', impeka_elementor_ext_add_nav_visibility() );
		$this->add_control( 'nav_icon', impeka_elementor_ext_add_nav_icon() );
		$this->add_control( 'nav_icon_color', impeka_elementor_ext_add_nav_icon_color() );
		$this->add_control( 'nav_shape', impeka_elementor_ext_add_nav_shape() );
		$this->add_control( 'nav_shape_type', impeka_elementor_ext_add_nav_shape_type() );
		$this->add_control( 'nav_shape_color', impeka_elementor_ext_add_nav_shape_color() );

		$this->add_control(
			'label_pagination',
			[
				'label' => esc_html__( 'Pagination', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);
		$this->add_control( 'pagination', impeka_elementor_ext_add_pagination() );
		$this->add_control( 'pagination_speed', impeka_elementor_ext_add_pagination_speed() );

		$this->end_controls_section();
		
		//Extras
		$this->start_controls_section(
			'extras_section',
			[
				'label' => esc_html__( 'Extras', 'impeka-elementor-extension' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'link_type',
			[
				'label' => esc_html__( 'Link Type', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'item' => esc_html__( 'Classic Portfolio', 'impeka-elementor-extension' ),
					'quick-view' => esc_html__( 'Quick View', 'impeka-elementor-extension' ),
				),
				'default' => 'item',
				'description' => esc_html__( "Select the link type of your product items.", 'impeka-elementor-extension' ),
			]
		);
		$this->add_control(
			'quick_view_title',
			[
				'label' => esc_html__( 'Quick View Title', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'description' => esc_html__( 'Title for quick view.', 'impeka-elementor-extension' ),
				'default' => 'Quick View',
				'condition' => [
					'link_type' => [ 'quick-view' ],
				],
			]
		);
		$this->end_controls_section();

		//Categories
		$this->start_controls_section(
			'categories_section',
			[
				'label' => esc_html__( 'Categories', 'impeka-elementor-extension' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'exclude_posts',
			[
				'label' => esc_html__( 'Exclude Posts', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'description' => esc_html__( 'Type the post ids you want to exclude separated by comma ( , ).', 'impeka-elementor-extension' ),
				'default' => '',
			]
		);
		$this->add_control(
			'categories',
			[
				'label' => esc_html__( 'Products Categories', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT2,
				'multiple' => true,
				'options' => impeka_elementor_ext_get_post_categories( 'product_cat' ),
				"description" => esc_html__( 'Select all or multiple categories, leave empty for all.', 'impeka-elementor-extension' ),
				'default' => '',
			]
		);
		$this->add_control(
			'include_posts',
			[
				'label' => esc_html__( 'Include Specific Posts', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'description' => esc_html__( 'Type the specific post ids you want to include separated by comma ( , ). Note: If you define specific post ids, Exclude Posts and Categories will have no effect.', 'impeka-elementor-extension' ),
				'default' => '',
			]
		);
		$this->end_controls_section();

	}

	/**
	 * Render widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function render() {
		$atts = $this->get_settings_for_display();
		echo impeka_elementor_ext_locate_template( 'products-carousel.php', array( 'atts' => $atts ) );
	}

}