<?php
/*
*	Admin Custom Fonts
*
* 	@author		Greatives Team
* 	@URI		http://greatives.eu
*/

	function impeka_ext_add_font_settings() {

		if ( isset( $_POST['_impeka_ext_nonce_font_save'] ) && wp_verify_nonce( $_POST['_impeka_ext_nonce_font_save'], 'impeka_ext_nonce_font_save' ) ) {

			$font_settings = array();
			$disable_gfonts = $typekit_id = $css_code = '';
			if( isset( $_POST['_impeka_ext_custom_font_setting_disable_gfonts'] ) ) {
				$disable_gfonts = sanitize_text_field( $_POST['_impeka_ext_custom_font_setting_disable_gfonts'] );
			}
			if( isset( $_POST['_impeka_ext_custom_font_setting_typekit_id'] ) ) {
				$typekit_id = sanitize_text_field( $_POST['_impeka_ext_custom_font_setting_typekit_id'] );
			}
			if( isset( $_POST['_impeka_ext_custom_font_setting_typekit_api_key'] ) ) {
				$typekit_api_key = sanitize_text_field( $_POST['_impeka_ext_custom_font_setting_typekit_api_key'] );
			}
			if( isset( $_POST['_impeka_ext_custom_font_setting_css_code'] ) ) {
				$css_code = $_POST['_impeka_ext_custom_font_setting_css_code'];
			}
			if ( !empty( $disable_gfonts ) || !empty( $typekit_id ) || !empty( $typekit_api_key ) || !empty( $css_code ) ) {
				$font_settings = array (
					'disable_gfonts' => $disable_gfonts,
					'typekit_id' => $typekit_id,
					'typekit_api_key' => $typekit_api_key,
					'css_code' => $css_code,
					'font_version' => time(),
				);
			}

			if ( empty( $font_settings ) ) {
				delete_option( 'impeka_ext_custom_font_settings' );
			} else {
				update_option( 'impeka_ext_custom_font_settings', $font_settings );
			}

			$is_custom_font = false;

			//Custom Fonts
			$fonts_items = array();
			if( isset( $_POST['_impeka_ext_custom_font_item_id'] ) ) {
				$num_of_fonts = sizeof( $_POST['_impeka_ext_custom_font_item_id'] );
				for ( $i=0; $i < $num_of_fonts; $i++ ) {

					$this_font = array (
						'id' => sanitize_text_field( $_POST['_impeka_ext_custom_font_item_id'][ $i ] ),
						'name' => sanitize_text_field( $_POST['_impeka_ext_custom_font_item_name'][ $i ] ),
						'files' => array(
							'eot' => sanitize_text_field( $_POST['_impeka_ext_custom_font_file_eot'][ $i ] ),
							'woff2' => sanitize_text_field( $_POST['_impeka_ext_custom_font_file_woff2'][ $i ] ),
							'woff' => sanitize_text_field( $_POST['_impeka_ext_custom_font_file_woff'][ $i ] ),
							'ttf' => sanitize_text_field( $_POST['_impeka_ext_custom_font_file_ttf'][ $i ] ),
						)
					);
					array_push( $fonts_items, $this_font );
				}
			}
			if ( empty( $fonts_items ) ) {
				delete_option( 'impeka_ext_custom_fonts' );

			} else {
				update_option( 'impeka_ext_custom_fonts', $fonts_items );
			}

			if ( !empty( $fonts_items ) || !empty( $css_code ) ) {
				impeka_ext_generate_custom_fonts_css_file( $css_code );
			} else {
				impeka_ext_delete_custom_fonts_css_file();
			}

			//User Defined Fonts
			$userdefined_items = array();
			if( isset( $_POST['_impeka_ext_userdefined_font_item_id'] ) ) {
				$num_of_fonts = sizeof( $_POST['_impeka_ext_userdefined_font_item_id'] );
				for ( $i=0; $i < $num_of_fonts; $i++ ) {

					$this_font = array (
						'id' => sanitize_text_field( $_POST['_impeka_ext_userdefined_font_item_id'][ $i ] ),
						'name' => sanitize_text_field( $_POST['_impeka_ext_userdefined_font_item_name'][ $i ] ),
					);
					array_push( $userdefined_items, $this_font );
				}
			}
			if ( empty( $userdefined_items ) ) {
				delete_option( 'impeka_ext_userdefined_fonts' );

			} else {
				update_option( 'impeka_ext_userdefined_fonts', $userdefined_items );
			}

			//Typekit Fonts
			if ( empty( $typekit_id ) ) {
				delete_option( 'impeka_ext_typekit_fonts' );

			}

			wp_safe_redirect( 'admin.php?page=impeka-fonts&font-settings=saved' );

		}
	}

	add_action( 'admin_menu', 'impeka_ext_add_font_settings' );

	function impeka_ext_print_available_fonts() {
		$available_fonts = false;
		$custom_fonts = get_option( 'impeka_ext_custom_fonts' );
		if ( ! empty( $custom_fonts ) ) {
			foreach ( $custom_fonts as $custom_font ) {
?>
		<tr class="grve-available-font-item">
			<td>
				<h4 class="grve-custom-font-title">
					<span><?php echo esc_html( $custom_font['name'] ); ?></span>
				</h4>
			</td>
			<td><?php esc_html_e('Uploaded Font', 'impeka-extension' ); ?></td>
		</tr>
<?php
			}
			$available_fonts = true;
		}

		$userdefined_fonts = get_option( 'impeka_ext_userdefined_fonts' );
		if ( ! empty( $userdefined_fonts ) ) {
			foreach ( $userdefined_fonts as $userdefined_font ) {
?>
		<tr class="grve-available-font-item">
			<td>
				<h4 class="grve-custom-font-title">
					<span><?php echo esc_html( $userdefined_font['name'] ); ?></span>
				</h4>
			</td>
			<td><?php esc_html_e('User Defined Font', 'impeka-extension' ); ?></td>
		</tr>
<?php
			}
			$available_fonts = true;
		}

		$typekit_fonts = get_option( 'impeka_ext_typekit_fonts' );
		if ( ! empty( $typekit_fonts ) ) {
			foreach ( $typekit_fonts as $typekit_font ) {
?>
		<tr class="grve-available-font-item">
			<td>
				<h4 class="grve-custom-font-title">
					<span><?php echo esc_html( $typekit_font['slug'] ); ?></span>
				</h4>
			</td>
			<td><?php esc_html_e('Typekit Font', 'impeka-extension' ); ?></td>
		</tr>
<?php
			}
			$available_fonts = true;
		}


		if ( !$available_fonts ) {
?>
		<tr class="grve-available-font-item grve-available-font-empty">
			<td>
				<h4 class="grve-custom-font-title">
					<span><?php esc_html_e('No fonts found, insert custom font using one of the available font types!', 'impeka-extension' ); ?></span>
				</h4>
			</td>
			<td>&nbsp;</td>
		</tr>
<?php
		}
	}

	function impeka_ext_print_admin_custom_fonts() {

		$fonts = get_option( 'impeka_ext_custom_fonts' );
		if ( ! empty( $fonts ) ) {
			foreach ( $fonts as $font ) {
				impeka_ext_print_admin_single_custom_font( $font );
			}
		}
	}

	function impeka_ext_print_admin_userdefined_fonts() {

		$fonts = get_option( 'impeka_ext_userdefined_fonts' );
		if ( ! empty( $fonts ) ) {
			foreach ( $fonts as $font ) {
				impeka_ext_print_admin_single_userdefined_font( $font );
			}
		}
	}

	function  impeka_ext_print_admin_empty_userdefined_font() {
?>
		<tr class="grve-userdefined-font-item grve-userdefined-font-empty">
			<td>
				<h4 class="grve-userdefined-font-title">
					<span><?php esc_html_e('No fonts added yet!', 'impeka-extension' ); ?></span>
				</h4>
			</td>
			<td>&nbsp;</td>
		</tr>
<?php

	}

	function  impeka_ext_print_admin_single_custom_font( $font_item, $mode = '' ) {

		$font_item_id = uniqid('impeka_grve_font_');
		$font_files = impeka_ext_array_value( $font_item, 'files', array() );
?>

	<tr class="grve-custom-font-item grve-custom-font-normal">
		<td>
			<h4 class="grve-custom-font-title">
				<?php echo impeka_ext_array_value( $font_item, 'name' ); ?>
				<input type="hidden" class="grve-custom-font-item-name" value="<?php echo impeka_grve_array_value( $font_item, 'name' ); ?>"/>
			</h4>
		</td>
		<td>
			<div class="grve-font-file-display-wrapper">
		<?php
			if ( !empty( $font_files ) ) {
				foreach ( $font_files as $key => $value ) {
					if ( !empty( $value ) ) {
		?>
			<div class="grve-font-file-container">
				<span class="grve-display-font">.<?php echo esc_html( $key ); ?></span>
			</div>
		<?php
					}
				}
			}
		?>
			</div>
		</td>
		<td style="text-align: right;">
			<input class="grve-custom-font-item-delete-button grve-delete-btn button" type="button" value="<?php esc_attr_e('Delete', 'impeka-extension' ); ?>">
			<input type="hidden" name="_impeka_ext_custom_font_item_id[]" value="<?php echo impeka_ext_array_value( $font_item, 'id', $font_item_id ); ?>">
			<input type="hidden" name="_impeka_ext_custom_font_item_name[]" value="<?php echo impeka_ext_array_value( $font_item, 'name' ); ?>"/>
			<input type="hidden" name="_impeka_ext_custom_font_file_eot[]" value="<?php echo impeka_ext_array_value( $font_files, 'eot' ); ?>"/>
			<input type="hidden" name="_impeka_ext_custom_font_file_woff2[]" value="<?php echo impeka_ext_array_value( $font_files, 'woff2' ); ?>"/>
			<input type="hidden" name="_impeka_ext_custom_font_file_woff[]" value="<?php echo impeka_ext_array_value( $font_files, 'woff' ); ?>"/>
			<input type="hidden" name="_impeka_ext_custom_font_file_ttf[]" value="<?php echo impeka_ext_array_value( $font_files, 'ttf' ); ?>"/>
		</td>
	</tr>

<?php

	}

	function  impeka_ext_print_admin_single_userdefined_font( $font_item, $mode = '' ) {
		$font_item_id = uniqid('impeka_grve_font_');
?>

	<tr class="grve-userdefined-font-item grve-userdefined-font-normal">
		<td>
			<h4 class="grve-userdefined-font-title">
				<span><?php echo impeka_ext_array_value( $font_item, 'name' ); ?></span>

			</h4>
		</td>
		<td style="text-align: right;">
			<input class="grve-userdefined-font-item-delete-button grve-delete-btn button" type="button" value="<?php esc_attr_e('Delete', 'impeka-extension' ); ?>">
			<input type="hidden" name="_impeka_ext_userdefined_font_item_id[]" value="<?php echo impeka_ext_array_value( $font_item, 'id', $font_item_id ); ?>">
			<input type="hidden" class="grve-userdefined-font-item-name" name="_impeka_ext_userdefined_font_item_name[]" value="<?php echo impeka_ext_array_value( $font_item, 'name' ); ?>"/>
		</td>
	</tr>

<?php

	}

	function impeka_ext_get_custom_font() {

		check_ajax_referer( 'impeka-ext-get-custom-font', '_grve_nonce' );

		if( isset( $_POST['font_name'] ) ) {

			$font_item_name = isset( $_POST['font_name'] ) ? sanitize_text_field( $_POST['font_name'] ) : '';

			$font_files = array();
			$font_files['eot'] = isset( $_POST['font_file_eot'] ) ? sanitize_text_field( $_POST['font_file_eot'] ) : '';
			$font_files['woff2'] = isset( $_POST['font_file_woff2'] ) ? sanitize_text_field( $_POST['font_file_woff2'] ) : '';
			$font_files['woff'] = isset( $_POST['font_file_woff'] ) ? sanitize_text_field( $_POST['font_file_woff'] ) : '';
			$font_files['ttf'] = isset( $_POST['font_file_ttf'] ) ? sanitize_text_field( $_POST['font_file_ttf'] ) : '';


			$font_item_id = uniqid('impeka_grve_font_');
			if( empty( $font_item_name ) ) {
				$font_item_name = $font_item_id;
			}

			$this_font = array (
				'id' => $font_item_id,
				'name' => $font_item_name,
				'files' => $font_files,
			);

			impeka_ext_print_admin_single_custom_font( $this_font, 'new' );
		}
		die();

	}
	add_action( 'wp_ajax_impeka_ext_get_custom_font', 'impeka_ext_get_custom_font' );

	function impeka_ext_get_userdefined_font() {

		check_ajax_referer( 'impeka-ext-get-userdefined-font', '_grve_nonce' );

		if( isset( $_POST['font_name'] ) ) {

			$font_item_name = isset( $_POST['font_name'] ) ? sanitize_text_field( $_POST['font_name'] ) : '';

			$font_item_id = uniqid('impeka_grve_font_');
			if( empty( $font_item_name ) ) {
				$font_item_name = $font_item_id;
			}

			$this_font = array (
				'id' => $font_item_id,
				'name' => $font_item_name,
			);

			impeka_ext_print_admin_single_userdefined_font( $this_font, 'new' );
		}
		die();

	}
	add_action( 'wp_ajax_impeka_ext_get_userdefined_font', 'impeka_ext_get_userdefined_font' );

	function impeka_ext_custom_font_selection( $std_fonts = array() ) {

		$my_custom_fonts = array();

		$custom_fonts = get_option( 'impeka_ext_custom_fonts' );
		if ( ! empty( $custom_fonts ) ) {
			foreach ( $custom_fonts as $custom_font ) {
				$my_custom_fonts[  esc_html__('Custom Fonts', 'impeka-extension' ) ][ $custom_font['name'] ] = $custom_font['name'];
			}
		}

		$userdefined_fonts = get_option( 'impeka_ext_userdefined_fonts' );
		if ( ! empty( $userdefined_fonts ) ) {
			foreach ( $userdefined_fonts as $userdefined_font ) {
				$my_custom_fonts[  esc_html__('Custom Fonts', 'impeka-extension' ) ][ $userdefined_font['name'] ] = $userdefined_font['name'];
			}
		}

		$typekit_fonts = get_option( 'impeka_ext_typekit_fonts' );
		if ( ! empty( $typekit_fonts ) ) {
			foreach ( $typekit_fonts as $typekit_font ) {
				$my_custom_fonts[  esc_html__('Custom Fonts', 'impeka-extension' ) ][ $typekit_font['slug'] ] = $typekit_font['slug'];
			}
		}

		$std_fonts = array_merge($std_fonts, $my_custom_fonts);
		return $std_fonts;

	}
	add_filter( "redux/impeka_grve_options/field/typography/custom_fonts", 'impeka_ext_custom_font_selection' );

	function impeka_ext_custom_font_gfonts_visibility( $visibility ) {
		$impeka_grve_custom_settings = get_option( 'impeka_ext_custom_font_settings' );
		$disable_gfonts = ( isset($impeka_grve_custom_settings['disable_gfonts'] ) ) ? $impeka_grve_custom_settings['disable_gfonts'] : '';
		if ( !empty( $disable_gfonts ) ) {
			$visibility = false;
		}
		return $visibility;
	}
	add_filter( 'impeka_grve_gfonts_visibility', 'impeka_ext_custom_font_gfonts_visibility' );

	function impeka_ext_custom_font_unload_gfonts( $args ) {
		$impeka_grve_custom_settings = get_option( 'impeka_ext_custom_font_settings' );
		$disable_gfonts = ( isset($impeka_grve_custom_settings['disable_gfonts'] ) ) ? $impeka_grve_custom_settings['disable_gfonts'] : '';
		if ( !empty( $disable_gfonts ) ) {
			$args['disable_google_fonts_link'] = true;
		}
		return $args;
	}
	add_filter("redux/options/impeka_grve_options/args", 'impeka_ext_custom_font_unload_gfonts', 12 );



	function impeka_ext_compress_css( $css ) {
		$css_trim =  preg_replace( '/\s+/', ' ', $css );
		return $css_trim;
	}

	function impeka_ext_check_css_folder() {
		$wp_upload_dir = wp_upload_dir();
		if ( wp_mkdir_p( $wp_upload_dir['basedir'] . '/grve-css' ) ) {
			return true;
		}
		return false;
	}

	function impeka_ext_get_custom_font_css_file_path() {
		$wp_upload_dir = wp_upload_dir();
		return sprintf( '%s/grve-css/%s.%s', $wp_upload_dir['basedir'], 'grve-custom-fonts', 'css' );
	}

	function impeka_ext_get_custom_font_css_file_url() {
		$wp_upload_dir = wp_upload_dir();
		return sprintf( '%s/grve-css/%s.%s', $wp_upload_dir['baseurl'], 'grve-custom-fonts', 'css' );
	}

	function impeka_ext_get_custom_fonts_css_code() {

		$css = '';

		$custom_fonts = get_option( 'impeka_ext_custom_fonts' );
		if ( !empty( $custom_fonts ) ) {
			foreach ( $custom_fonts as $custom_font ) {

				$wp_upload_dir = wp_upload_dir();
				$font_files = $custom_font['files'];
				$font_file_eot_id = impeka_ext_array_value( $font_files, 'eot' );
				$font_file_woff2_id = impeka_ext_array_value( $font_files, 'woff2' );
				$font_file_woff_id = impeka_ext_array_value( $font_files, 'woff' );
				$font_file_ttf_id = impeka_ext_array_value( $font_files, 'ttf' );

				$css .= "@font-face {\r\n";

				$css .= "  font-family:'{$custom_font['name']}';\r\n";
				$css .= "  font-display: swap;\r\n";
				$src = array();

				if ( !empty( $font_file_eot_id ) ) {
					$font_file_eot = wp_get_attachment_url( $font_file_eot_id );
					$font_file_eot = str_replace( $wp_upload_dir['baseurl'], '..', $font_file_eot );
					if ( !empty( $font_file_eot ) ) {
						$css .= "  src:  url('{$font_file_eot}');\r\n";
						$src[] = "  url('{$font_file_eot}?#iefix') format('embedded-opentype')";
					}
				}

				if ( !empty( $font_file_woff2_id ) ) {
					$font_file_woff2 = wp_get_attachment_url( $font_file_woff2_id );
					$font_file_woff2 = str_replace( $wp_upload_dir['baseurl'], '..', $font_file_woff2 );
					if ( !empty( $font_file_woff2 ) ) {
						$src[] = "  url('{$font_file_woff2}') format('woff2')";
					}
				}

				if ( !empty( $font_file_woff_id ) ) {
					$font_file_woff = wp_get_attachment_url( $font_file_woff_id );
					$font_file_woff = str_replace( $wp_upload_dir['baseurl'], '..', $font_file_woff );
					if ( !empty( $font_file_woff ) ) {
						$src[] = "  url('{$font_file_woff}') format('woff')";
					}
				}

				if ( !empty( $font_file_ttf_id ) ) {
					$font_file_ttf = wp_get_attachment_url( $font_file_ttf_id );
					$font_file_ttf = str_replace( $wp_upload_dir['baseurl'], '..', $font_file_ttf );
					if ( !empty( $font_file_ttf ) ) {
						$src[] = "  url('{$font_file_ttf}') format('truetype')";
					}
				}

				if ( ! empty( $src ) ) {
					$css .= "  src:" . implode( ",\r\n", $src ) . ";\r\n";
				}
				$css .= apply_filters('impeka_ext_custom_font_extra_attributes', '', $custom_font['name'] );
				$css .= "}\r\n";
			}
		}
		return $css;
	}

	if ( ! function_exists( 'impeka_ext_generate_custom_fonts_css_file' ) ) {
		function impeka_ext_generate_custom_fonts_css_file( $css_code = ""){

			$css = impeka_ext_get_custom_fonts_css_code();
			$css .= wp_unslash( $css_code );
			$css = impeka_ext_compress_css( $css );
			global $wp_filesystem;
			if ( empty( $wp_filesystem ) ) {
				require_once (ABSPATH . '/wp-admin/includes/file.php');
				WP_Filesystem();
			}
			$file_path = impeka_ext_get_custom_font_css_file_path();
			if( impeka_ext_check_css_folder() ) {
				if( $wp_filesystem->put_contents( $file_path, $css, 0777 ) ){
					return true;
				}
			}
		}
	}


	if ( ! function_exists( 'impeka_ext_delete_custom_fonts_css_file' ) ) {
		function impeka_ext_delete_custom_fonts_css_file(){
			global $wp_filesystem;
			if ( empty( $wp_filesystem ) ) {
				require_once (ABSPATH . '/wp-admin/includes/file.php');
				WP_Filesystem();
			}
			$file_path = impeka_ext_get_custom_font_css_file_path();
			if( impeka_ext_check_css_folder() ) {
				$wp_filesystem->delete( $file_path );
			}
		}
	}


	function impeka_ext_custom_font_enqueue_styles() {
		$setting = get_option( 'impeka_ext_custom_font_settings' );
		$font_version = ( isset($setting['font_version'] ) ) ? $setting['font_version'] : time();
		$typekit_id = ( isset($setting['typekit_id'] ) ) ? $setting['typekit_id'] : '';
		$typekit_id = str_replace(' ', '', $typekit_id);

		if( !empty( $typekit_id ) ) {
			wp_enqueue_style( 'typekit', 'https://use.typekit.net/'. esc_attr( $typekit_id ) . '.css', array(), $font_version );
		}

		if ( file_exists( impeka_ext_get_custom_font_css_file_path() ) ) {
			wp_enqueue_style( 'impeka-ext-css-custom-fonts', impeka_ext_get_custom_font_css_file_url(), array(), $font_version );
		}
	}

	add_action( 'wp_enqueue_scripts', 'impeka_ext_custom_font_enqueue_styles' );
	add_action( 'admin_enqueue_scripts', 'impeka_ext_custom_font_enqueue_styles' );

	function impeka_ext_add_mime_types( $mimes ) {
		$mimes['eot']  = 'application/vnd.ms-fontobject';
		$mimes['ttf']  = 'font/ttf';
		$mimes['woff']  = 'font/woff';
		$mimes['woff2'] = 'font/woff2';

		return $mimes;
	}
	add_filter( 'upload_mimes', 'impeka_ext_add_mime_types' );

	function impeka_ext_update_mime_types( $defaults, $file, $filename ) {
		if ( 'eot' === pathinfo( $filename, PATHINFO_EXTENSION ) ) {
			$defaults['type'] = 'application/vnd.ms-fontobject';
			$defaults['ext']  = 'eot';
		}
		if ( 'ttf' === pathinfo( $filename, PATHINFO_EXTENSION ) ) {
			$defaults['type'] = 'font/ttf';
			$defaults['ext']  = 'ttf';
		}
		if ( 'woff' === pathinfo( $filename, PATHINFO_EXTENSION ) ) {
			$defaults['type'] = 'font/woff';
			$defaults['ext']  = 'woff';
		}
		if ( 'woff2' === pathinfo( $filename, PATHINFO_EXTENSION ) ) {
			$defaults['type'] = 'font/woff2';
			$defaults['ext']  = 'woff2';
		}
		return $defaults;
	}
	add_filter( 'wp_check_filetype_and_ext', 'impeka_ext_update_mime_types', 10, 3 );


	function  impeka_ext_print_admin_empty_typekit_font() {
?>
		<tr class="grve-typekit-font-item">
			<td>
				<h4 class="grve-custom-font-title">
					<span><?php esc_html_e('No fonts added yet!', 'impeka-extension' ); ?></span>
				</h4>
			</td>
			<td>&nbsp;</td>
			<td>&nbsp;</td>
		</tr>
<?php

	}

	function impeka_ext_print_admin_typekit_fonts() {
		$typekit_fonts = get_option( 'impeka_ext_typekit_fonts' );
		if ( !empty( $typekit_fonts ) ) {
			foreach ( $typekit_fonts as $typekit_font ) {
				impeka_ext_print_admin_single_typekit_font( $typekit_font );
			}
		} else {
			impeka_ext_print_admin_empty_typekit_font();
		}
	}

	function impeka_ext_print_admin_single_typekit_font( $typekit_font ) {


		$variants = impeka_ext_array_value( $typekit_font, 'variants' );
		$variants_string = '';
		if( !empty( $variants ) && is_array($variants ) ) {
			foreach ( $variants as $variant ) {
				$variants_string .= $variant['name'] . ', ';
			}
		}
		$variants_string = rtrim( $variants_string, ', ');

?>
		<tr class="grve-typekit-font-item grve-typekit-font-normal">
			<td>
				<h4 class="grve-typekit-font-title">
					<?php echo esc_html( $typekit_font['name'] ); ?>
				</h4>
			</td>
			<td>
				<h4 class="grve-typekit-font-slug">
					<?php echo esc_html( $typekit_font['slug'] ); ?>
				</h4>
			</td>
			<td>
				<?php echo esc_html( $variants_string ); ?>
			</td>
		</tr>
<?php
	}

	function impeka_ext_scan_typekit_fonts() {

		check_ajax_referer( 'impeka-ext-scan-typekit-font', '_grve_nonce' );

		if( isset( $_POST['typekitID'] ) ) {

			$typekit_id = isset( $_POST['typekitID'] ) ? sanitize_text_field( $_POST['typekitID'] ) : '';
			$typekit_api_key = isset( $_POST['typekitAPIKey'] ) ? sanitize_text_field( $_POST['typekitAPIKey'] ) : '';

			if ( !empty( $typekit_api_key ) && !empty( $typekit_id ) ) {
				$url = "https://typekit.com/api/v1/json/kits/" . $typekit_id;
				$response = wp_remote_request( $url . "?token=" . $typekit_api_key, array( 'sslverify' => false ) );
				if ( !is_wp_error( $response ) ) {
					$response = wp_remote_retrieve_body( $response );
					impeka_ext_generate_typekit_fonts( $response );
				}
			}
		}
		die();

	}
	add_action( 'wp_ajax_impeka_ext_scan_typekit_fonts', 'impeka_ext_scan_typekit_fonts' );



	 /**
	 * Generate Typekit Font Array
	 */
	function impeka_ext_generate_typekit_fonts( $response ) {

		$typekit_fonts = array();

		$data = json_decode( $response, true );

		if ( isset( $data['kit'] ) ) {
			if ( isset( $data['kit']['families'] ) ) {
				$families = $data['kit']['families'];
				if ( is_array( $families ) && count( $families ) > 0 ) {
					foreach ( $families as $family ) {
						$variants = array();
						if ( is_array( $family['variations'] ) ) {
							$variants = impeka_ext_get_typekit_variants( $family['variations'] );
						}
						$font_slug = isset( $family->slug ) ? $family['slug'] : '';
						$font_css = isset( $family['css_names'][0] ) ? $family['css_names'][0] : $font_slug;

						$typekit_fonts[] = array(
							'slug' => $font_css,
							'name' => $family['name'],
							'id' => $family['id'],
							'variants' => $variants,
						);
					}
					if ( empty( $typekit_fonts ) ) {
						delete_option( 'impeka_ext_typekit_fonts' );
					} else {
						update_option( 'impeka_ext_typekit_fonts', $typekit_fonts );
					}
				}
			}
			impeka_ext_print_admin_typekit_fonts();
		} else {
			throw new Exception( 'Synchronizing Error' );
		}

	}

	 /**
	 * Get Typekit Variants
	 */
	function impeka_ext_get_typekit_variants( $var ) {
		$result = array();

		foreach ( $var as $v ) {
			$name = "Normal";
			$id = "400";
			if ( $v[1] == 1 ) {
				$name = 'Ultra-Light 100';
				$id = '100';
			} else if ( $v[1] == 2 ) {
				$name = 'Light 200';
				$id = '200';
			} else if ( $v[1] == 3 ) {
				$name = 'Book 300';
				$id = '300';
			} else if ( $v[1] == 4 ) {
				$name = 'Normal 400';
				$id = '400';
			} else if ( $v[1] == 5 ) {
				$name = 'Medium 500';
				$id = '500';
			} else if ( $v[1] == 6 ) {
				$name = 'Semi-Bold 600';
				$id = '600';
			} else if ( $v[1] == 7 ) {
				$name = 'Bold 700';
				$id = '700';
			} else if ( $v[1] == 8 ) {
				$name = 'Extra-Bold 800';
				$id = '800';
			} else if ( $v[1] == 9 ) {
				$name = 'Ultra-Bold 900';
				$id = '900';
			}

			if ( $v[0] == 'i' ) {
				$name .= " Italic";
				$name = trim( $name );
				$id = $id . "italic";
			}

			$result[] = array(
				'id'   => $id,
				'name' => $name
			);
		}

		return array_filter( $result );
	}

//Omit closing PHP tag to avoid accidental whitespace output errors.
