<?php
/*
*	Admin Page Codes
*
* 	@author		Greatives Team
* 	@URI		http://greatives.eu
*/

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

?>
	<div id="grve-admin-pannel-wrapper" class="grve-codes-wrap">
		<div id="grve-admin-nav-wrapper">
		<?php
			if ( function_exists( 'impeka_grve_print_admin_links') ) {
				impeka_grve_print_admin_links('codes');
			}
		?>
		</div>
		<div class="grve-admin-title">
			<h2 class="grve-title"><?php esc_html_e( "Custom Codes", 'impeka' ); ?></h2>
			<p class="grve-description"><?php esc_html_e( "In this area, you can paste your tracking codes. Don’t miss to place your code inside <script> tags.", 'impeka' ); ?></p>
		</div>

		<div id="grve-codes-panel" class="grve-admin-panel">

			<form method="post" action="admin.php?page=impeka-codes">
				<?php
					settings_fields('impeka_grve_ext_options');
					$options = get_option('impeka_grve_ext_options');
					$head_code = ( isset( $options['head_code'] ) ? $options['head_code'] : '' );
					$body_code = ( isset( $options['body_code'] ) ? $options['body_code'] : '' );
					$footer_code = ( isset( $options['footer_code'] ) ? $options['footer_code'] : '' );
				?>

				<table class="grve-table grve-custom-code-table" cellspacing="0">
					<tr>
						<td>
							<h3><?php esc_html_e( 'Code ( Head )', 'impeka-extension'); ?></h3>
							<p><?php esc_html_e( 'Code will be placed after the opening &lt;head&gt; tag. ', 'impeka-extension' ); ?></p>
							<textarea id="grve-head-code-area" name="impeka_grve_ext_options[head_code]" class="widefat" rows="8"><?php echo wp_unslash( $head_code ); ?></textarea>
						</td>
					</tr>
					<tr>
						<td>
							<h3><?php esc_html_e( 'Code ( Body )', 'impeka-extension'); ?></h3>
							<p><?php esc_html_e( 'Code will be placed after the opening &lt;body&gt; tag. ', 'impeka-extension' ); ?></p>
							<textarea id="grve-body-code-area" name="impeka_grve_ext_options[body_code]" class="widefat" rows="8"><?php echo wp_unslash( $body_code ); ?></textarea>
						</td>
					</tr>
					<tr>
						<td>
							<h3><?php esc_html_e( 'Code ( Footer )', 'impeka-extension'); ?></h3>
							<p><?php esc_html_e( 'Code will be placed before the closing &lt;/body&gt; tag.', 'impeka-extension' ); ?></p>
							<textarea id="grve-footer-code-area" name="impeka_grve_ext_options[footer_code]" class="widefat" rows="8"><?php echo wp_unslash( $footer_code ); ?></textarea>
						</td>
					</tr>
				</table>
				<?php wp_nonce_field( 'impeka_ext_options_nonce_save', '_impeka_ext_options_nonce_save' ); ?>
				<p class="submit">
					<input type="submit" class="button-primary" value="<?php esc_html_e('Save Changes', 'impeka-extension') ?>" />
				</p>
			</form>

		</div>
	</div>
<?php

//Omit closing PHP tag to avoid accidental whitespace output errors.
