<?php
/*
*	Portfolio Post Type Registration
*
* 	@author		Greatives Team
* 	@URI		http://greatives.eu
*/

if ( ! class_exists( 'Impeka_Portfolio_Post_Type' ) ) {
	class Impeka_Portfolio_Post_Type {

		function __construct() {

			// Adds the portfolio post type and taxonomies
			$this->impeka_ext_portfolio_init();

			// Manage Columns for portfolio overview
			add_filter( 'manage_edit-portfolio_columns',  array( &$this, 'impeka_ext_portfolio_edit_columns' ) );
			add_action( 'manage_posts_custom_column', array( &$this, 'impeka_ext_portfolio_custom_columns' ), 10, 2 );

		}

		function impeka_ext_portfolio_init() {

			$portfolio_base_slug = 'portfolio-item';
			$portfolio_category_slug = 'portfolio-category';
			$portfolio_fields_slug = 'portfolio-fields';
			if ( function_exists( 'impeka_grve_option' ) ) {
				$portfolio_base_slug = impeka_grve_option( 'portfolio_slug', 'portfolio-item' );
				$portfolio_category_slug = impeka_grve_option( 'portfolio_category_slug', 'portfolio-category' );
				$portfolio_fields_slug = impeka_grve_option( 'portfolio_fields_slug', 'portfolio-fields' );
			}


			$labels = array(
				'name' => esc_html_x( 'Portfolio Items', 'Portfolio General Name', 'impeka-extension' ),
				'singular_name' => esc_html_x( 'Portfolio Item', 'Portfolio Singular Name', 'impeka-extension' ),
				'add_new' => esc_html__( 'Add New', 'impeka-extension' ),
				'add_new_item' => esc_html__( 'Add New Portfolio Item', 'impeka-extension' ),
				'edit_item' => esc_html__( 'Edit Portfolio Item', 'impeka-extension' ),
				'new_item' => esc_html__( 'New Portfolio Item', 'impeka-extension' ),
				'view_item' => esc_html__( 'View Portfolio Item', 'impeka-extension' ),
				'search_items' => esc_html__( 'Search Portfolio Items', 'impeka-extension' ),
				'not_found' =>  esc_html__( 'No Portfolio Items found', 'impeka-extension' ),
				'not_found_in_trash' => esc_html__( 'No Portfolio Items found in Trash', 'impeka-extension' ),
				'parent_item_colon' => '',
			);

			$category_labels = array(
				'name' => esc_html__( 'Portfolio Categories', 'impeka-extension' ),
				'singular_name' => esc_html__( 'Portfolio Category', 'impeka-extension' ),
				'search_items' => esc_html__( 'Search Portfolio Categories', 'impeka-extension' ),
				'all_items' => esc_html__( 'All Portfolio Categories', 'impeka-extension' ),
				'parent_item' => esc_html__( 'Parent Portfolio Category', 'impeka-extension' ),
				'parent_item_colon' => esc_html__( 'Parent Portfolio Category:', 'impeka-extension' ),
				'edit_item' => esc_html__( 'Edit Portfolio Category', 'impeka-extension' ),
				'update_item' => esc_html__( 'Update Portfolio Category', 'impeka-extension' ),
				'add_new_item' => esc_html__( 'Add New Portfolio Category', 'impeka-extension' ),
				'new_item_name' => esc_html__( 'New Portfolio Category Name', 'impeka-extension' ),
			);

			$field_labels = array(
				'name' => esc_html__( 'Portfolio Fields', 'impeka-extension' ),
				'singular_name' => esc_html__( 'Portfolio Field', 'impeka-extension' ),
				'search_items' => esc_html__( 'Search Portfolio Fields', 'impeka-extension' ),
				'all_items' => esc_html__( 'All Portfolio Fields', 'impeka-extension' ),
				'parent_item' => esc_html__( 'Parent Portfolio Field', 'impeka-extension' ),
				'parent_item_colon' => esc_html__( 'Parent Portfolio Field:', 'impeka-extension' ),
				'edit_item' => esc_html__( 'Edit Portfolio Field', 'impeka-extension' ),
				'update_item' => esc_html__( 'Update Portfolio Field', 'impeka-extension' ),
				'add_new_item' => esc_html__( 'Add New Portfolio Field', 'impeka-extension' ),
				'new_item_name' => esc_html__( 'New Portfolio Field Name', 'impeka-extension' ),
			);

			$args = array(
				'labels' => $labels,
				'public' => true,
				'publicly_queryable' => true,
				'show_ui' => true,
				'query_var' => true,
				'has_archive' => true,
				'capability_type' => 'post',
				'hierarchical' => false,
				'menu_position' => 5,
				'menu_icon' => 'dashicons-format-gallery',
				'show_in_rest' => true,
				'supports' => array( 'title', 'editor', 'author', 'excerpt', 'thumbnail', 'custom-fields', 'comments', 'page-attributes' ),
				'rewrite' => array( 'slug' => $portfolio_base_slug, 'with_front' => false ),
			);

			register_post_type(
				'portfolio' ,
				apply_filters( "impeka_ext_register_post_type_portfolio_args", $args )
			);

			register_taxonomy(
				'portfolio_category',
				apply_filters( 'impeka_ext_register_taxonomy_portfolio_category_object_type',
					array( 'portfolio' )
				),
				apply_filters( 'impeka_ext_register_taxonomy_portfolio_category_args',
					array(
						'hierarchical' => true,
						'label' => esc_html__( 'Portfolio Categories', 'impeka-extension' ),
						'labels' => $category_labels,
						'show_in_nav_menus' => true,
						'show_tagcloud' => false,
						'show_in_rest' => true,
						'rewrite' => array( 'slug' => $portfolio_category_slug ),
					)
				)
			);

			register_taxonomy(
				'portfolio_field',
				apply_filters( 'impeka_ext_register_taxonomy_portfolio_field_object_type',
					array( 'portfolio' )
				),
				apply_filters( 'impeka_ext_register_taxonomy_portfolio_field_args',
					array(
						'hierarchical' => true,
						'label' => esc_html__( 'Portfolio Fields', 'impeka-extension' ),
						'labels' => $field_labels,
						'show_in_nav_menus' => true,
						'show_tagcloud' => false,
						'show_in_rest' => true,
						'rewrite' => array( 'slug' => $portfolio_fields_slug ),
					)
				)
			);

		}

		function impeka_ext_portfolio_edit_columns( $columns ) {
			$columns['cb'] = "<input type=\"checkbox\" />";
			$columns['title'] = esc_html__( 'Title', 'impeka-extension' );
			$columns['portfolio_thumbnail'] = esc_html__( 'Featured Image', 'impeka-extension' );
			$columns['author'] = esc_html__( 'Author', 'impeka-extension' );
			$columns['portfolio_category'] = esc_html__( 'Portfolio Categories', 'impeka-extension' );
			$columns['portfolio_field'] = esc_html__( 'Portfolio Fields', 'impeka-extension' );
			$columns['date'] = esc_html__( 'Date', 'impeka-extension' );
			return $columns;
		}

		function impeka_ext_portfolio_custom_columns( $column, $post_id ) {

			switch ( $column ) {
				case "portfolio_thumbnail":
					if ( has_post_thumbnail( $post_id ) ) {
						$thumbnail_id = get_post_thumbnail_id( $post_id );
						$attachment_src = wp_get_attachment_image_src( $thumbnail_id, array( 80, 80 ) );
						if ( $attachment_src ) {
							$thumb = $attachment_src[0];
						} else {
							$thumb = get_template_directory_uri() . '/includes/images/not-found.jpg';
						}
					} else {
						$thumb = get_template_directory_uri() . '/includes/images/no-image.jpg';
					}
					echo '<img class="attachment-80x80" width="80" height="80" alt="portfolio image" src="' . esc_url( $thumb ) . '">';
					break;
				case 'portfolio_category':
					echo get_the_term_list( $post_id, 'portfolio_category', '', ', ','' );
				break;
				case 'portfolio_field':
					echo get_the_term_list( $post_id, 'portfolio_field', '', ', ','' );
				break;
			}
		}

	}
	new Impeka_Portfolio_Post_Type;
}

//Omit closing PHP tag to avoid accidental whitespace output errors.
