<?php
/*
*	Comments Template
*
* 	@version	1.0
* 	@author		Greatives Team
* 	@URI		https://greatives.eu
*/

	if ( post_password_required() ) {
?>
		<div class="help">
			<p class="no-comments"><?php esc_html_e( 'This post is password protected. Enter the password to view comments.', 'impeka' ); ?></p>
		</div>
<?php
		return;
	}
?>

<?php if ( have_comments() ) : ?>

	<!-- Comments -->
	<div id="grve-comments">
		<div class="grve-comments-header">
			<div class="grve-comments-number grve-h5">
			<?php comments_number(); ?>
			</div>
			<nav class="grve-comment-nav" aria-label="<?php esc_attr_e( 'Comments', 'impeka' ); ?>">
				<?php previous_comments_link(); ?>
				<?php next_comments_link(); ?>
			</nav>
		</div>
		<ul class="grve-comments-list">
		<?php
			wp_list_comments( array(
				'callback'       => 'impeka_grve_comments',
				'short_ping'  => true,
			) );
		?>
		</ul>
	</div>
	<!-- End Comments -->

<?php endif; ?>

<?php if ( ! comments_open() && get_comments_number() && post_type_supports( get_post_type(), 'comments' ) ) : ?>
	<div id="grve-comments">
		<p class="no-comments"><?php esc_html_e( 'Comments are closed.', 'impeka' ); ?></p>
	</div>
<?php endif; ?>

<?php if ( comments_open() ) : ?>
<?php
		$commenter = wp_get_current_commenter();
		$req = get_option( 'require_name_email' );

		$args = array(
			'id_form'           => 'commentform',
			'id_submit'         => 'grve-comment-submit-button',
			'title_reply'       => esc_html__( 'Leave a Reply', 'impeka' ),
			'title_reply_to'    => esc_html__( 'Leave a Reply to', 'impeka' ) . ' %s',
			'cancel_reply_link' => esc_html__( 'Cancel Reply', 'impeka' ),
			'label_submit'      => esc_html__( 'Submit Comment', 'impeka' ),
			'submit_button'     => '<input name="%1$s" type="submit" id="%2$s" class="%3$s" value="%4$s" />',

			'comment_field' =>
				'<div class="grve-form-textarea grve-border">'.
				'<div class="grve-form-inner">' .
				'<label>' . esc_attr__( 'Your Comment Here...', 'impeka' ) . '</label>' .
				'<textarea class="grve-form-input-item" id="comment" name="comment" cols="45" rows="10" aria-required="true">' .
				'</textarea></div></div>',

			'must_log_in' =>
				'<p class="must-log-in">' . esc_html__( 'You must be', 'impeka' ) .
				'<a href="' .  wp_login_url( get_permalink() ) . '">' . esc_html__( 'logged in', 'impeka' ) . '</a> ' . esc_html__( 'to post a comment.', 'impeka' ) . '</p>',

			'logged_in_as' =>
				'<div class="logged-in-as">' .  esc_html__('Logged in as','impeka') .
				'<a class="grve-text-content grve-text-hover-primary-1" href="' . esc_url( admin_url( 'profile.php' ) ) . '"> ' . $user_identity . '</a>. ' .
				'<a class="grve-text-content grve-text-hover-primary-1" href="' . wp_logout_url( get_permalink() ) . '" title="' . esc_attr__( 'Log out of this account', 'impeka' ) . '"> ' . esc_html__( 'Log out', 'impeka' ) . '</a></div>',

			'comment_notes_before' => '',
			'comment_notes_after' => '' ,

			'fields' => apply_filters(
				'comment_form_default_fields',
				array(
					'author' =>
						'<div class="grve-form-input grve-half-size grve-border">' .
						'<div class="grve-form-inner">' .
						'<label>' . esc_attr__( 'Name', 'impeka' ) . ' ' . ( $req ? esc_attr__( '*', 'impeka' ) : '' ) . '</label>' .
						'<input id="author" class="grve-form-input-item" name="author" type="text" value="' . esc_attr( $commenter['comment_author'] ) . '"' .
						' />' .
						'</div>' .
						'</div>',

					'email' =>
						'<div class="grve-form-input grve-half-size grve-border">' .
						'<div class="grve-form-inner">' .
						'<label>' . esc_attr__( 'E-mail', 'impeka' ) . ' ' . ( $req ? esc_attr__( '*', 'impeka' ) : '' ) . '</label>' .
						'<input id="email" class="grve-form-input-item" name="email" type="text" value="' . esc_attr(  $commenter['comment_author_email'] ) . '"' .
						' />' .
						'</div>' .
						'</div>',

					'url' =>
						'<div class="grve-form-input grve-border">' .
						'<div class="grve-form-inner">' .
						'<label>' . esc_attr__( 'Website', 'impeka' )  . '</label>' .
						'<input id="url" class="grve-form-input-item" name="url" type="text" value="' . esc_attr( $commenter['comment_author_url'] ) . '"' .
						' />' .
						'</div>' .
						'</div>',
					)
				),
		);
?>
		<div id="grve-comment-form">
			<?php
				//Use comment_form() with no parameters if you want the default form instead.
				comment_form( $args );
			?>
		</div>
<?php endif;

//Omit closing PHP tag to avoid accidental whitespace output errors.