<?php
/*
*	Post Content Gallery Template
*
* 	@version	1.0
* 	@author		Greatives Team
* 	@URI		https://greatives.eu
*/

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

$disable_media = impeka_grve_post_meta( '_impeka_grve_disable_media' );
$slider_items = impeka_grve_post_meta( '_impeka_grve_post_slider_items' );
$gallery_mode = impeka_grve_post_meta( '_impeka_grve_post_type_gallery_mode', 'gallery' );
$gallery_image_mode = impeka_grve_post_meta( '_impeka_grve_post_type_gallery_image_mode' );
$image_size_slider = 'impeka-grve-large-rect-horizontal';
if ( 'resize' == $gallery_image_mode ) {
	$image_size_slider = "large";
}

$media_type = impeka_grve_option( 'post_feature_media_type' );
$media_type = impeka_grve_post_meta( '_impeka_grve_feature_media_type', $media_type );

$wide_class = '';
if( 'wide' == $media_type ) {
	$wide_class = 'grve-wide';
}
?>
<article id="post-<?php the_ID(); ?>" <?php post_class(); ?> itemscope itemType="http://schema.org/BlogPosting">
<?php
	if ( !empty( $slider_items ) && 'yes' != $disable_media ) {
?>
	<div id="grve-single-media">
		<div class="grve-container">
			<?php impeka_grve_print_gallery_slider( $gallery_mode, $slider_items, $image_size_slider, $wide_class ); ?>
		</div>
	</div>
<?php
	}
?>
	<?php do_action( 'impeka_grve_single_content_before' ); ?>
	<div id="grve-single-content">
		<?php impeka_grve_print_post_simple_title(); ?>
		<div itemprop="articleBody">
			<?php the_content(); ?>
		</div>
		<?php impeka_grve_print_post_structured_data(); ?>
	</div>
	<?php do_action( 'impeka_grve_single_content_after' ); ?>
</article>
