<?php
/*
*	Post Content Video Template
*
* 	@version	1.0
* 	@author		Greatives Team
* 	@URI		https://greatives.eu
*/

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

$disable_media = impeka_grve_post_meta( '_impeka_grve_disable_media' );
$media_type = impeka_grve_option( 'post_feature_media_type' );
$media_type = impeka_grve_post_meta( '_impeka_grve_feature_media_type', $media_type );
$media_classes = array('grve-media');
if( 'wide' == $media_type ) {
	$media_classes[] = 'grve-wide';
}
$media_class_string = implode( ' ', $media_classes );
?>
<article id="post-<?php the_ID(); ?>" <?php post_class(); ?> itemscope itemType="http://schema.org/BlogPosting">
	<?php
		if ( 'yes' != $disable_media ) {
	?>
	<div id="grve-single-media">
		<div class="grve-container">
			<div class="<?php echo esc_attr( $media_class_string ); ?>">
				<?php impeka_grve_print_post_video(); ?>
			</div>
		</div>
	</div>
	<?php
		}
	?>
	<?php do_action( 'impeka_grve_single_content_before' ); ?>
	<div id="grve-single-content">
		<?php impeka_grve_print_post_simple_title(); ?>
		<div itemprop="articleBody">
			<?php the_content(); ?>
		</div>
		<?php impeka_grve_print_post_structured_data(); ?>
	</div>
	<?php do_action( 'impeka_grve_single_content_after' ); ?>
</article>