<?php
/*
*	Main theme functions and definitions
*
* 	@version	1.0
* 	@author		Greatives Team
* 	@URI		https://greatives.eu
*/

/**
 * Theme Definitions
 * Please leave these settings unchanged
 */
define( 'IMPEKA_GRVE_THEME_VERSION', '1.3.6' );
define( 'IMPEKA_GRVE_THEME_REDUX_CUSTOM_PANEL', false );

/**
 * Set up the content width value based on the theme's design.
 */
if ( ! isset( $content_width ) ) {
	$content_width = 1080;
}

/**
 * Theme textdomain - must be loaded before redux
 */
load_theme_textdomain( 'impeka', get_template_directory() . '/languages' );

/**
 * Include Global helper files
 */
require_once get_template_directory() . '/includes/admin/grve-admin-global.php';
require_once get_template_directory() . '/includes/grve-global.php';
require_once get_template_directory() . '/includes/grve-gutenberg.php';
require_once get_template_directory() . '/includes/grve-meta-tags.php';
require_once get_template_directory() . '/includes/grve-privacy-functions.php';
require_once get_template_directory() . '/includes/grve-woocommerce-functions.php';
require_once get_template_directory() . '/includes/grve-woocommerce-hooks.php';
require_once get_template_directory() . '/includes/grve-bbpress-functions.php';
require_once get_template_directory() . '/includes/grve-events-calendar-functions.php';

/**
 * Register Plugins Libraries
 */
if ( is_admin() ) {
	require_once get_template_directory() . '/includes/plugins/tgm-plugin-activation/register-plugins.php';
}
require_once get_template_directory() . '/includes/admin/grve-admin-check.php';
require_once get_template_directory() . '/includes/admin/grve-admin-wizard.php';
require_once get_template_directory() . '/includes/admin/grve-admin-custom-sidebars.php';
require_once get_template_directory() . '/includes/admin/grve-admin-screens.php';
/**
 * ReduxFramework
 */
require_once get_template_directory() . '/includes/admin/grve-redux-extension-loader.php';

if ( !class_exists( 'ReduxFramework' ) && file_exists( get_template_directory() . '/includes/framework/framework.php' ) ) {
   require_once get_template_directory() . '/includes/framework/framework.php';
}

if ( !isset( $redux_demo ) ) {
	require_once get_template_directory() . '/includes/admin/grve-redux-framework-config.php';
}

function impeka_grve_remove_redux_demo_link() {
    if ( class_exists('Redux_Framework_Plugin') ) {
		call_user_func( 'remove' . '_filter', 'plugin_row_meta', array( Redux_Framework_Plugin::instance(), 'plugin_metalinks' ), null, 2 );
        remove_action('admin_notices', array( Redux_Framework_Plugin::get_instance(), 'admin_notices' ) );
    }
	if ( class_exists('ReduxFrameworkPlugin') ) {
		call_user_func( 'remove' . '_filter', 'plugin_row_meta', array( ReduxFrameworkPlugin::instance(), 'plugin_metalinks' ), null, 2 );
        remove_action('admin_notices', array( ReduxFrameworkPlugin::get_instance(), 'admin_notices' ) );
    }
}
add_action('init', 'impeka_grve_remove_redux_demo_link');

/**
 * Custom Nav Menus
 */
require_once get_template_directory() . '/includes/custom-menu/grve-custom-nav-menu.php';

/**
 * Include admin helper files
 */
require_once get_template_directory() . '/includes/admin/grve-admin-functions.php';
require_once get_template_directory() . '/includes/admin/grve-admin-option-functions.php';
require_once get_template_directory() . '/includes/admin/grve-admin-feature-functions.php';
require_once get_template_directory() . '/includes/admin/grve-admin-modal-functions.php';

require_once get_template_directory() . '/includes/admin/grve-meta-functions.php';
require_once get_template_directory() . '/includes/admin/grve-category-meta.php';
require_once get_template_directory() . '/includes/admin/grve-post-meta.php';

require_once get_template_directory() . '/includes/admin/grve-portfolio-meta.php';
require_once get_template_directory() . '/includes/admin/grve-testimonial-meta.php';
require_once get_template_directory() . '/includes/grve-wp-gallery.php';
require_once get_template_directory() . '/includes/grve-media-functions.php';

/**
 * Include Dynamic css
 */
require_once get_template_directory() . '/includes/grve-typography-functions.php';
require_once get_template_directory() . '/includes/grve-dynamic-css-generator.php';
require_once get_template_directory() . '/includes/grve-dynamic-css-loader.php';

/**
 * Include helper files
 */
require_once get_template_directory() . '/includes/grve-breadcrumbs.php';
require_once get_template_directory() . '/includes/grve-excerpt.php';
require_once get_template_directory() . '/includes/grve-header-functions.php';
require_once get_template_directory() . '/includes/grve-header-layout-functions.php';
require_once get_template_directory() . '/includes/grve-feature-functions.php';
require_once get_template_directory() . '/includes/grve-layout-functions.php';
require_once get_template_directory() . '/includes/grve-navigation-functions.php';
require_once get_template_directory() . '/includes/grve-blog-functions.php';
require_once get_template_directory() . '/includes/grve-portfolio-functions.php';
require_once get_template_directory() . '/includes/grve-singular-functions.php';
require_once get_template_directory() . '/includes/grve-footer-functions.php';

/**
 * Theme activation function
 * Used whe activating the theme
 */
function impeka_grve_theme_activate() {

	update_option( 'impeka_grve_theme_version', IMPEKA_GRVE_THEME_VERSION );

	flush_rewrite_rules();
}
add_action( 'after_switch_theme', 'impeka_grve_theme_activate' );

/**
 * Theme setup function
 * Theme support
 */
function impeka_grve_theme_setup() {

	add_theme_support( 'automatic-feed-links' );
	add_theme_support( 'post-thumbnails' );
	add_theme_support( 'post-formats', array( 'gallery', 'link', 'quote', 'video', 'audio' ) );
	add_theme_support( 'title-tag' );
	add_theme_support( 'customize-selective-refresh-widgets' );
	add_theme_support( 'align-wide' );
	add_theme_support( 'editor-styles' );
	add_theme_support( 'custom-line-height' );
	add_theme_support( 'custom-spacing' );
	add_theme_support( 'responsive-embeds' );
	add_theme_support( 'html5', array( 'style', 'script' ) );
	add_editor_style( 'css/style-editor.css' );
	add_theme_support( 'yoast-seo-breadcrumbs' );

    add_theme_support(
		'editor-color-palette',
		array(
			array(
				'name' => esc_html__( 'Primary 1', 'impeka' ),
				'slug' => 'primary-1',
				'color' => impeka_grve_option( 'body_primary_1_color' ),
			),
			array(
				'name' => esc_html__( 'Primary 2', 'impeka' ),
				'slug' => 'primary-2',
				'color' => impeka_grve_option( 'body_primary_2_color' ),
			),
			array(
				'name' => esc_html__( 'Primary 3', 'impeka' ),
				'slug' => 'primary-3',
				'color' => impeka_grve_option( 'body_primary_3_color' ),
			),
			array(
				'name' => esc_html__( 'Primary 4', 'impeka' ),
				'slug' => 'primary-4',
				'color' => impeka_grve_option( 'body_primary_4_color' ),
			),
			array(
				'name' => esc_html__( 'Primary 5', 'impeka' ),
				'slug' => 'primary-5',
				'color' => impeka_grve_option( 'body_primary_5_color' ),
			),
			array(
				'name' => esc_html__( 'Primary 6', 'impeka' ),
				'slug' => 'primary-6',
				'color' => impeka_grve_option( 'body_primary_6_color' ),
			),
			array(
				'name' => esc_html__( 'Green', 'impeka' ),
				'slug' => 'green',
				'color' => '#6ECA09',
			),
			array(
				'name' => esc_html__( 'Red', 'impeka' ),
				'slug' => 'red',
				'color' => '#D0021B',
			),
			array(
				'name' => esc_html__( 'Orange', 'impeka' ),
				'slug' => 'orange',
				'color' => '#FAB901',
			),
			array(
				'name' => esc_html__( 'Aqua', 'impeka' ),
				'slug' => 'aqua',
				'color' => '#28d2dc',
			),
			array(
				'name' => esc_html__( 'Blue', 'impeka' ),
				'slug' => 'blue',
				'color' => '#71CCF6',
			),
			array(
				'name' => esc_html__( 'Purple', 'impeka' ),
				'slug' => 'purple',
				'color' => '#7639e2',
			),
			array(
				'name' => esc_html__( 'Grey', 'impeka' ),
				'slug' => 'grey',
				'color' => '#ECEFF4',
			),
			array(
				'name' => esc_html__( 'Dark Grey', 'impeka' ),
				'slug' => 'dark-grey',
				'color' => '#1D2024',
			),
			array(
				'name' => esc_html__( 'Light Grey', 'impeka' ),
				'slug' => 'light-grey',
				'color' => '#F6F7FA',
			),
			array(
				'name' => esc_html__( 'Black', 'impeka' ),
				'slug' => 'black',
				'color' => '#000000',
			),
			array(
				'name' => esc_html__( 'White', 'impeka' ),
				'slug' => 'white',
				'color' => '#ffffff',
			),
		)
	);

	$size_large_landscape_wide = impeka_grve_option( 'size_large_landscape_wide', array( 'width'   => '1390', 'height'  => '782') );
	$size_small_square = impeka_grve_option( 'size_small_square', array( 'width'   => '560', 'height'  => '560') );
	$size_small_landscape = impeka_grve_option( 'size_small_landscape', array( 'width'   => '560', 'height'  => '420') );
	$size_small_portrait = impeka_grve_option( 'size_small_portrait', array( 'width'   => '560', 'height'  => '747') );
	$size_medium_square = impeka_grve_option( 'size_medium_square', array( 'width'   => '900', 'height'  => '900') );
	$size_medium_landscape = impeka_grve_option( 'size_medium_landscape', array( 'width'   => '900', 'height'  => '675') );
	$size_medium_portrait = impeka_grve_option( 'size_medium_portrait', array( 'width'   => '840', 'height'  => '1120') );
	$size_fullscreen = impeka_grve_option( 'size_fullscreen', array( 'width'   => '1920', 'height'  => '1920') );

	add_image_size( 'impeka-grve-large-rect-horizontal', $size_large_landscape_wide['width'], $size_large_landscape_wide['height'], true );
	add_image_size( 'impeka-grve-small-square', $size_small_square['width'], $size_small_square['height'], true );
	add_image_size( 'impeka-grve-small-rect-horizontal', $size_small_landscape['width'], $size_small_landscape['height'], true );
	add_image_size( 'impeka-grve-small-rect-vertical', $size_small_portrait['width'], $size_small_portrait['height'], true );
	add_image_size( 'impeka-grve-medium-square', $size_medium_square['width'], $size_medium_square['height'], true );
	add_image_size( 'impeka-grve-medium-rect-horizontal', $size_medium_landscape['width'], $size_medium_landscape['height'], true );
	add_image_size( 'impeka-grve-medium-rect-vertical', $size_medium_portrait['width'], $size_medium_portrait['height'], true );
	add_image_size( 'impeka-grve-fullscreen', $size_fullscreen['width'], $size_fullscreen['height'], false );


	register_nav_menus(
		array(
			'impeka_header_nav' => esc_html__( 'Header Menu', 'impeka' ),
			'impeka_header_second_nav' => esc_html__( 'Second Header Menu', 'impeka' ),
			'impeka_responsive_nav' => esc_html__( 'Responsive Menu', 'impeka' ),
			'impeka_top_left_nav' => esc_html__( 'Top Left Menu', 'impeka' ),
			'impeka_top_right_nav' => esc_html__( 'Top Right Menu', 'impeka' ),
			'impeka_footer_nav' => esc_html__( 'Footer Menu', 'impeka' ),
		)
	);

}
add_action( 'after_setup_theme', 'impeka_grve_theme_setup' );

function impeka_grve_add_excerpt_support_for_pages() {
    add_post_type_support( 'page', 'excerpt' );
}
add_action( 'init', 'impeka_grve_add_excerpt_support_for_pages' );

/**
 * Navigation Menus
 */
if ( ! function_exists( 'impeka_grve_get_header_nav' ) ) {
	function impeka_grve_get_header_nav() {
		$menu = '';
		if ( 'yes' == impeka_grve_global_param( 'header_menu_visibility' ) ) {
			$menu = impeka_grve_global_param( 'header_main_navigation_menu' );
			if ( !empty( $menu ) ) {
				$menu = apply_filters( 'wpml_object_id', $menu, 'nav_menu', TRUE  );
			}
		} else {
			$menu = 'disabled';
		}
		return $menu;
	}
}

if ( ! function_exists( 'impeka_grve_get_header_second_nav' ) ) {
	function impeka_grve_get_header_second_nav() {
		$menu = '';
		if ( 'yes' == impeka_grve_global_param( 'header_second_menu_visibility' ) ) {
			$menu = impeka_grve_global_param( 'header_second_navigation_menu' );
			if ( !empty( $menu ) ) {
				$menu = apply_filters( 'wpml_object_id', $menu, 'nav_menu', TRUE  );
			}
		} else {
			$menu = 'disabled';
		}
		return $menu;
	}
}

if ( ! function_exists( 'impeka_grve_get_responsive_nav' ) ) {
	function impeka_grve_get_responsive_nav() {
		$menu = '';
		if ( 'yes' == impeka_grve_global_param( 'header_responsive_menu_visibility' ) ) {
			$menu = impeka_grve_global_param( 'header_responsive_navigation_menu' );
			if ( !empty( $menu ) ) {
				$menu = apply_filters( 'wpml_object_id', $menu, 'nav_menu', TRUE  );
			}
		} else {
			$menu = 'disabled';
		}
		return $menu;
	}
}

if ( ! function_exists( 'impeka_grve_header_nav' ) ) {
	function impeka_grve_header_nav( $menu = '', $grve_walker = 'main' ) {

		if ( 'disabled' == $menu ) {
			return;
		}

		if( 'responsive' == $grve_walker ) {
			$walker = new Impeka_Grve_Responsive_Navigation_Walker();
		} else {
			$walker = new Impeka_Grve_Main_Navigation_Walker();
		}

		if ( empty( $menu ) ) {
			wp_nav_menu(
				array(
					'menu_class' => 'grve-menu',
					'theme_location' => 'impeka_header_nav',
					'container' => false,
					'fallback_cb' => 'impeka_grve_fallback_menu',
					'link_before' => '<span class="grve-item">',
					'link_after' => '</span>',
					'walker' => $walker,
					'grve_walker' => $grve_walker,
				)
			);
		} else {
			//Custom Alternative Menu
			wp_nav_menu(
				array(
					'menu_class' => 'grve-menu',
					'menu' => $menu,
					'container' => false,
					'fallback_cb' => 'impeka_grve_fallback_menu',
					'link_before' => '<span class="grve-item">',
					'link_after' => '</span>',
					'walker' => $walker,
					'grve_walker' => $grve_walker,
				)
			);
		}
	}
}

if ( ! function_exists( 'impeka_grve_header_second_nav' ) ) {
	function impeka_grve_header_second_nav( $menu = '', $grve_walker = 'main' ) {

		if ( 'disabled' == $menu ) {
			return;
		}

		if( 'responsive' == $grve_walker ) {
			$walker = new Impeka_Grve_Responsive_Navigation_Walker();
		} else {
			$walker = new Impeka_Grve_Main_Navigation_Walker();
		}

		if ( empty( $menu ) ) {
			wp_nav_menu(
				array(
					'menu_class' => 'grve-menu',
					'theme_location' => 'impeka_header_second_nav',
					'container' => false,
					'fallback_cb' => false,
					'link_before' => '<span class="grve-item">',
					'link_after' => '</span>',
					'walker' => $walker,
					'grve_walker' => 'main',
				)
			);
		} else {
			//Custom Alternative Menu
			wp_nav_menu(
				array(
					'menu_class' => 'grve-menu',
					'menu' => $menu,
					'container' => false,
					'fallback_cb' => false,
					'link_before' => '<span class="grve-item">',
					'link_after' => '</span>',
					'walker' => $walker,
					'grve_walker' => 'main',
				)
			);
		}
	}
}

if ( ! function_exists( 'impeka_grve_responsive_nav' ) ) {
	function impeka_grve_responsive_nav( $menu = '' ) {

		if ( 'disabled' == $menu ) {
			return;
		}
		$walker = new Impeka_Grve_Responsive_Navigation_Walker();

		if ( empty( $menu ) ) {
			wp_nav_menu(
				array(
					'menu_class' => 'grve-menu',
					'theme_location' => 'impeka_responsive_nav',
					'container' => false,
					'fallback_cb' => 'impeka_grve_fallback_menu',
					'link_before' => '<span class="grve-item">',
					'link_after' => '</span>',
					'walker' => $walker,
				)
			);
		} else {
			//Custom Alternative Menu
			wp_nav_menu(
				array(
					'menu_class' => 'grve-menu',
					'menu' => $menu,
					'container' => false,
					'fallback_cb' => 'impeka_grve_fallback_menu',
					'link_before' => '<span class="grve-item">',
					'link_after' => '</span>',
					'walker' => $walker,
				)
			);
		}
	}
}

if ( ! function_exists( 'impeka_grve_header_combine_nav' ) ) {
	function impeka_grve_header_combine_nav( $custom_menu = '', $custom_second_menu = '' ) {

		if ( 'disabled' == $custom_menu && 'disabled' == $custom_second_menu ) {
			return;
		}
		$walker = new Impeka_Grve_Responsive_Navigation_Walker();
?>
		<ul id="grve-combined-responsive-menu" class="grve-menu">
<?php
		//Main Menu
		if ( 'disabled' != $custom_menu ) {
			if ( empty( $custom_menu ) ) {
				wp_nav_menu(
					array(
						'theme_location' => 'impeka_header_nav',
						'container' => false,
						'fallback_cb' => 'impeka_grve_fallback_menu',
						'link_before' => '<span class="grve-item">',
						'link_after' => '</span>',
						'items_wrap' => '%3$s',
						'walker' => $walker,
					)
				);
			} else {
				wp_nav_menu(
					array(
						'menu' => $custom_menu,
						'container' => false,
						'fallback_cb' => 'impeka_grve_fallback_menu',
						'link_before' => '<span class="grve-item">',
						'link_after' => '</span>',
						'items_wrap' => '%3$s',
						'walker' => $walker,
					)
				);
			}
		}
		//Second Menu
		if ( 'disabled' != $custom_second_menu ) {
			if ( empty( $custom_second_menu ) ) {
				wp_nav_menu(
					array(
						'theme_location' => 'impeka_header_second_nav',
						'container' => false,
						'fallback_cb' => false,
						'link_before' => '<span class="grve-item">',
						'link_after' => '</span>',
						'items_wrap' => '%3$s',
						'walker' => $walker,
					)
				);
			} else {
				wp_nav_menu(
					array(
						'menu' => $custom_second_menu,
						'container' => false,
						'fallback_cb' => false,
						'link_before' => '<span class="grve-item">',
						'link_after' => '</span>',
						'items_wrap' => '%3$s',
						'walker' => $walker,
					)
				);
			}
		}
?>
		</ul>
<?php
	}
}

/**
 * Main Navigation FallBack Menu
 */
if ( ! function_exists( 'impeka_grve_fallback_menu' ) ) {
	function impeka_grve_fallback_menu(){
		if( current_user_can( 'administrator' ) ) {
			echo '<span class="grve-no-assigned-menu grve-small-text">';
			echo esc_html__( 'Header Menu is not assigned!', 'impeka'  );
			echo ' ';
			echo '<a href="' . esc_url( admin_url(  'nav-menus.php?action=locations' ) ) . '">' . esc_html__( "Manage Locations", 'impeka' ) . '</a>';
			echo '</span>';
		}
	}
}

if ( ! function_exists( 'impeka_grve_footer_nav' ) ) {
	function impeka_grve_footer_nav() {

		$walker = new Impeka_Grve_Simple_Navigation_Walker();

		wp_nav_menu(
			array(
				'theme_location' => 'impeka_footer_nav',
				'container' => false,
				'depth' => '1',
				'fallback_cb' => false,
				'menu_class' => 'grve-margin-list-left-2x',
				'walker' => $walker,
			)
		);

	}
}

if ( ! function_exists( 'impeka_grve_top_left_nav' ) ) {
	function impeka_grve_top_left_nav() {

		$walker = new Impeka_Grve_Simple_Navigation_Walker();

		wp_nav_menu(
			array(
				'theme_location' => 'impeka_top_left_nav',
				'container' => false,
				'depth' => '1',
				'fallback_cb' => false,
				'walker' => $walker,
			)
		);

	}
}

if ( ! function_exists( 'impeka_grve_top_right_nav' ) ) {
	function impeka_grve_top_right_nav() {

		$walker = new Impeka_Grve_Simple_Navigation_Walker();

		wp_nav_menu(
			array(
				'theme_location' => 'impeka_top_right_nav',
				'container' => false,
				'depth' => '1',
				'fallback_cb' => false,
				'walker' => $walker,
			)
		);

	}
}

/**
 * Sidebars & Widgetized Areas
 */
if ( ! function_exists( 'impeka_grve_register_sidebars' ) ) {
	function impeka_grve_register_sidebars() {

		$sidebar_heading_tag = impeka_grve_option( 'sidebar_heading_tag', 'div' );
		$footer_heading_tag = impeka_grve_option( 'footer_heading_tag', 'div' );

		register_sidebar( array(
			'id' => 'grve-default-sidebar',
			'name' => esc_html__( 'Main Sidebar', 'impeka' ),
			'description' => esc_html__( 'Main Sidebar Widget Area', 'impeka' ),
			'before_widget' => '<div id="%1$s" class="grve-widget widget %2$s">',
			'after_widget' => '</div>',
			'before_title' => '<' . tag_escape( $sidebar_heading_tag ) . ' class="grve-widget-title">',
			'after_title' => '</' . tag_escape( $sidebar_heading_tag ) . '>',
		));

		register_sidebar( array(
			'id' => 'grve-single-portfolio-sidebar',
			'name' => esc_html__( 'Single Portfolio', 'impeka' ),
			'description' => esc_html__( 'Single Portfolio Sidebar Widget Area', 'impeka' ),
			'before_widget' => '<div id="%1$s" class="grve-widget widget %2$s">',
			'after_widget' => '</div>',
			'before_title' => '<' . tag_escape( $sidebar_heading_tag ) . ' class="grve-widget-title">',
			'after_title' => '</' . tag_escape( $sidebar_heading_tag ) . '>',
		));

		register_sidebar( array(
			'id' => 'grve-footer-1-sidebar',
			'name' => esc_html__( 'Footer 1', 'impeka' ),
			'description' => esc_html__( 'Footer 1 Widget Area', 'impeka' ),
			'before_widget' => '<div id="%1$s" class="grve-widget widget %2$s">',
			'after_widget' => '</div>',
			'before_title' => '<' . tag_escape( $footer_heading_tag ) . ' class="grve-widget-title">',
			'after_title' => '</' . tag_escape( $footer_heading_tag ) . '>',
		));
		register_sidebar( array(
			'id' => 'grve-footer-2-sidebar',
			'name' => esc_html__( 'Footer 2', 'impeka' ),
			'description' => esc_html__( 'Footer 2 Widget Area', 'impeka' ),
			'before_widget' => '<div id="%1$s" class="grve-widget widget %2$s">',
			'after_widget' => '</div>',
			'before_title' => '<' . tag_escape( $footer_heading_tag ) . ' class="grve-widget-title">',
			'after_title' => '</' . tag_escape( $footer_heading_tag ) . '>',
		));
		register_sidebar( array(
			'id' => 'grve-footer-3-sidebar',
			'name' => esc_html__( 'Footer 3', 'impeka' ),
			'description' => esc_html__( 'Footer 3 Widget Area', 'impeka' ),
			'before_widget' => '<div id="%1$s" class="grve-widget widget %2$s">',
			'after_widget' => '</div>',
			'before_title' => '<' . tag_escape( $footer_heading_tag ) . ' class="grve-widget-title">',
			'after_title' => '</' . tag_escape( $footer_heading_tag ) . '>',
		));
		register_sidebar( array(
			'id' => 'grve-footer-4-sidebar',
			'name' => esc_html__( 'Footer 4', 'impeka' ),
			'description' => esc_html__( 'Footer 4 Widget Area', 'impeka' ),
			'before_widget' => '<div id="%1$s" class="grve-widget widget %2$s">',
			'after_widget' => '</div>',
			'before_title' => '<' . tag_escape( $footer_heading_tag ) . ' class="grve-widget-title">',
			'after_title' => '</' . tag_escape( $footer_heading_tag ) . '>',
		));

		$custom_sidebars = get_option( '_impeka_grve_custom_sidebars' );
		if ( ! empty( $custom_sidebars ) ) {
			foreach ( $custom_sidebars as $custom_sidebar ) {
				register_sidebar( array(
					'id' => $custom_sidebar['id'],
					'name' => esc_html__( 'Custom Sidebar', 'impeka' ) . ': ' . esc_html( $custom_sidebar['name'] ),
					'description' => '',
					'before_widget' => '<div id="%1$s" class="grve-widget widget %2$s">',
					'after_widget' => '</div>',
					'before_title' => '<' . tag_escape( $sidebar_heading_tag ) . ' class="grve-widget-title">',
					'after_title' => '</' . tag_escape( $sidebar_heading_tag ) . '>',
				));
			}
		}

	}
}
add_action( 'widgets_init', 'impeka_grve_register_sidebars' );

/**
 * Enqueue scripts and styles for the front end.
 */
function impeka_grve_frontend_scripts() {

	$min = '';
	if ( impeka_grve_visibility( 'minify_assets', '1' ) ) {
		$min = '.min';
	}

	$impeka_version = trim ( IMPEKA_GRVE_THEME_VERSION );

	wp_register_style( 'impeka-style', get_stylesheet_directory_uri().'/style.css', array(), esc_attr( $impeka_version ), 'all' );

	wp_enqueue_style( 'font-awesome', get_template_directory_uri() . '/css/font-awesome.min.css', array(), '5.15.3' );
	wp_enqueue_style( 'font-awesome-v4-shims', get_template_directory_uri() . '/css/font-awesome-v4-shims.min.css', array( 'font-awesome' ), '5.15.3' );

	if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
		wp_enqueue_script( 'comment-reply' );
	}

	wp_enqueue_style( 'impeka-theme-style', get_template_directory_uri() . '/css/theme-style' . $min . '.css', array(), esc_attr( $impeka_version ) );

	if ( impeka_grve_woocommerce_enabled() ) {
		wp_enqueue_style( 'impeka-woocommerce-custom', get_template_directory_uri() . '/css/woocommerce-custom' . $min . '.css', array(), esc_attr( $impeka_version ), 'all' );
	}

	if ( 'openstreetmap' == impeka_grve_option( 'map_api_mode', 'google-maps' ) ) {
		wp_enqueue_style(  'leaflet', get_template_directory_uri() . '/css/leaflet' . $min . '.css', array(), '1.7.1', 'all' );
	}

	impeka_grve_load_dynamic_css();

	if ( get_stylesheet_directory_uri() !=  get_template_directory_uri() ) {
		wp_enqueue_style( 'impeka-style');
	}

	wp_register_script( 'youtube-iframe-api', '//www.youtube.com/iframe_api', array(), esc_attr( $impeka_version ), true );
	wp_register_script( 'vimeo-api', '//player.vimeo.com/api/player.js', array(), esc_attr( $impeka_version ), true );

	if ( impeka_grve_is_privacy_key_enabled( 'gmaps' ) ) {
		$gmap_api_key = impeka_grve_option( 'gmap_api_key' );
		wp_register_script( 'google-maps-api', '//maps.googleapis.com/maps/api/js?key=' . esc_attr( $gmap_api_key ), NULL, NULL, true );
		wp_register_script( 'leaflet', '//unpkg.com/leaflet@1.7.1/dist/leaflet.js', array(), '1.7.1', true );

		if ( 'openstreetmap' == impeka_grve_option( 'map_api_mode', 'google-maps' ) ) {
			wp_register_script( 'impeka-openstreetmap-maps', get_template_directory_uri() . '/js/openstreetmap-maps' . $min . '.js', array( 'jquery', 'leaflet' ), esc_attr( $impeka_version ), true );
			$maps_data = array(
				'map_tile_url' => impeka_grve_option( 'map_tile_url', 'https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png' ),
				'map_tile_url_subdomains' => impeka_grve_option( 'map_tile_url_subdomains', 'abc' ),
				'map_tile_attribution' => impeka_grve_option( 'map_tile_attribution' ),
			);
			wp_localize_script( 'impeka-openstreetmap-maps', 'impeka_grve_maps_data', $maps_data );
		} else {
			$map_lib = 'google-';
			wp_register_script( 'impeka-google-maps', get_template_directory_uri() . '/js/google-maps' . $min . '.js', array( 'jquery', 'google-maps-api' ), esc_attr( $impeka_version ), true );
			$maps_data = array(
				'custom_enabled' => impeka_grve_option( 'gmap_custom_enabled', '0' ),
				'water_color' => impeka_grve_option( 'gmap_water_color', '#424242' ),
				'lanscape_color' => impeka_grve_option( 'gmap_landscape_color', '#232323' ),
				'poi_color' => impeka_grve_option( 'gmap_poi_color', '#232323' ),
				'road_color' => impeka_grve_option( 'gmap_road_color', '#1a1a1a' ),
				'label_color' => impeka_grve_option( 'gmap_label_color', '#777777' ),
				'label_stroke_color' => impeka_grve_option( 'gmap_label_stroke_color', '#1a1a1a' ),
				'label_enabled' => impeka_grve_option( 'gmap_label_enabled', '0' ),
				'country_color' => impeka_grve_option( 'gmap_country_color', '#000000' ),
				'zoom_enabled' => impeka_grve_option( 'gmap_zoom_enabled', '0' ),
				'custom_code' => impeka_grve_option( 'gmap_custom_code', '[]' ),
				'gesture_handling' => impeka_grve_option( 'gmap_gesture_handling', 'auto' ),
				'type_control' => impeka_grve_option( 'gmap_type_control', '0' ),
			);
			wp_localize_script( 'impeka-google-maps', 'impeka_grve_maps_data', $maps_data );
		}
	}

	if ( '1' == impeka_grve_option( 'combine_js', '1' ) ) {
		wp_enqueue_script( 'impeka-extras', get_template_directory_uri() . '/js/extras.min.js', array( 'jquery' ), esc_attr( $impeka_version ), true );
	} else {
		wp_enqueue_script( 'gsap', get_template_directory_uri() . '/js/plugins/gsap.min.js', array( 'jquery' ), '3.5.1', true );
		wp_enqueue_script( 'sticky-kit', get_template_directory_uri() . '/js/plugins/sticky-kit.min.js', array( 'jquery' ), '1.1.3', true );
		wp_enqueue_script( 'lazysizes-bgset', get_template_directory_uri() . '/js/plugins/lazysizes.bgset.min.js', array( 'jquery' ), '5.3.0', true );
		wp_enqueue_script( 'lazysizes', get_template_directory_uri() . '/js/plugins/lazysizes.min.js', array( 'jquery' ), '5.3.0', true );
		wp_enqueue_script( 'jquery-smoothscroll', get_template_directory_uri() . '/js/plugins/jquery.smoothscroll.min.js', array( 'jquery' ), '1.4.10', true );
		wp_enqueue_script( 'impeka-grve', get_template_directory_uri() . '/js/plugins/grve.min.js', array( 'jquery' ), '1.0.0', true );
		wp_enqueue_script( 'raf', get_template_directory_uri() . '/js/plugins/raf.min.js', array( 'jquery' ), '1.0.0', true );
		wp_enqueue_script( 'jquery-superfish', get_template_directory_uri() . '/js/plugins/jquery.superfish.min.js', array( 'jquery' ), '1.7.9', true );
		wp_enqueue_script( 'debounce', get_template_directory_uri() . '/js/plugins/debounce.min.js', array( 'jquery' ), '1.0', true );
		wp_enqueue_script( 'jquery-appear', get_template_directory_uri() . '/js/plugins/jquery.appear.min.js', array( 'jquery' ), '1.0', true );
		wp_enqueue_script( 'owl-carousel', get_template_directory_uri() . '/js/plugins/owl.carousel.min.js', array( 'jquery' ), '2.3.4', true );
		wp_enqueue_script( 'flickity', get_template_directory_uri() . '/js/plugins/flickity.min.js', array( 'jquery' ), '2.2.2', true );
		wp_enqueue_script( 'flickity-fade', get_template_directory_uri() . '/js/plugins/flickity-fade.min.js', array( 'jquery' ), '1.0.0', true );
		wp_enqueue_script( 'flickity-lazyload', get_template_directory_uri() . '/js/plugins/flickity-lazyload.min.js', array( 'jquery' ), '1.0.1', true );
		wp_enqueue_script( 'imagesloaded' );
		wp_enqueue_script( 'isotope', get_template_directory_uri() . '/js/plugins/isotope.min.js', array( 'jquery' ), '3.0.6', true );
		wp_enqueue_script( 'infinite-scroll', get_template_directory_uri() . '/js/plugins/infinite-scroll.min.js', array( 'jquery' ), '3.0.6', true );
		wp_enqueue_script( 'jquery-magnific-popup', get_template_directory_uri() . '/js/plugins/jquery.magnific-popup.min.js', array( 'jquery' ), '1.1.0', true );
		wp_enqueue_script( 'jquery-fitvids', get_template_directory_uri() . '/js/plugins/jquery.fitvids.min.js', array( 'jquery' ), '1.1.0', true );
		wp_enqueue_script( 'jquery-easing', get_template_directory_uri() . '/js/plugins/jquery.easing.min.js', array( 'jquery' ), '1.4.2', true );
		wp_enqueue_script( 'vivus', get_template_directory_uri() . '/js/plugins/vivus.min.js', array( 'jquery' ), '0.4.4', true );
		wp_enqueue_script( 'jquery-iscroll', get_template_directory_uri() . '/js/plugins/jquery.iscroll.min.js', array( 'jquery' ), '5.2.0', true );
		wp_enqueue_script( 'jquery-fullpage', get_template_directory_uri() . '/js/plugins/jquery.fullpage.min.js', array( 'jquery' ), '2.9.7', true );
		wp_enqueue_script( 'lightgallery', get_template_directory_uri() . '/js/plugins/lightgallery.min.js', array( 'jquery' ), '1.7.3', true );
		wp_enqueue_script( 'color-thief', get_template_directory_uri() . '/js/plugins/color-thief.min.js', array( 'jquery' ), '2.3.2', true );
	}
	wp_enqueue_script( 'impeka-main', get_template_directory_uri() . '/js/main' . $min . '.js', array( 'jquery' ), esc_attr( $impeka_version ), true );

	$impeka_grve_fullpage = 0;
	if ( is_page_template( 'page-templates/template-full-page.php' ) ) {
		$scrolling_page = impeka_grve_post_meta( '_impeka_grve_scrolling_page' );
		$impeka_grve_fullpage = 1;
	}

	$scrolling_speed = impeka_grve_option( 'scrolling_speed', 'normal' );
	if( 'fast' == $scrolling_speed ) {
		$smoothframerate = '60';
		$smoothanimationtime = '700';
		$smoothstepsize = '120';
	} elseif( 'slow' == $scrolling_speed ) {
		$smoothframerate = '100';
		$smoothanimationtime = '1200';
		$smoothstepsize = '85';
	} else {
		$smoothframerate = '80';
		$smoothanimationtime = '1000';
		$smoothstepsize = '100';
	}

	$smoothscroll_data = array(
		'smoothscrolling' => impeka_grve_browser_webkit_check(),
		'smoothframerate' => $smoothframerate,
		'smoothanimationtime' => $smoothanimationtime,
		'smoothstepsize' => $smoothstepsize,
	);
	$fullpage_data = array(
		'fullpage' => $impeka_grve_fullpage,
	);

	$impeka_grve_data = array(
		'quantity_buttons' => impeka_grve_option( 'product_woo_quantity_buttons', '1' ),
	);


	$impeka_grve_main_data = array(
		'siteurl' => get_template_directory_uri() ,
		'ajaxurl' => esc_url( admin_url( 'admin-ajax.php' ) ),
		'wp_gallery_popup' => impeka_grve_option( 'wp_gallery_popup', '0' ),
		'woo_popup_thumbs' => impeka_grve_option( 'product_gallery_woo_popup_thumbs', '1' ),
		'device_animations' => impeka_grve_option( 'device_animations', '0' ),
		'device_hover_single_tap' => impeka_grve_option( 'device_hover_single_tap', '0' ),
		'back_top_top' => impeka_grve_option( 'back_to_top_enabled', '1' ),
		'string_weeks' => esc_html__( 'Weeks', 'impeka' ),
		'string_days' => esc_html__( 'Days', 'impeka' ),
		'string_hours' => esc_html__( 'Hours', 'impeka' ),
		'string_minutes' => esc_html__( 'Min', 'impeka' ),
		'string_seconds' => esc_html__( 'Sec', 'impeka' ),
		'nonce_likes' => wp_create_nonce( 'impeka-grve-likes' ),
		'nonce_quick_view' => wp_create_nonce( 'impeka-grve-quick-view' ),
		'nonce_area_item' => wp_create_nonce( 'impeka-grve-area-item' ),
		'intro_appearance' => impeka_grve_option( 'intro_appearance', 'always' ),
		'intro_reset_duration' => impeka_grve_option( 'intro_reset_duration', '' ),

		'header_sticky_shrink_spacing' => impeka_grve_option( 'header_sticky_shrink_spacing', '' ),
		'header_sticky_shrink_logo_height' => impeka_grve_option( 'header_sticky_shrink_logo_height', '' ),

	);

	$resolution_code = "var screen_width = Math.max( screen.width, screen.height );var devicePixelRatio = window.devicePixelRatio ? window.devicePixelRatio : 1;document.cookie = 'resolution=' + screen_width + ',' + devicePixelRatio + '; SameSite=Lax; path=/';";
	$custom_js_code = impeka_grve_option( 'custom_js' );

	if ( '1' == impeka_grve_option( 'combine_js', '1' ) ) {
		wp_localize_script( 'impeka-extras', 'impeka_grve_smoothscroll_data', $smoothscroll_data );
		wp_localize_script( 'impeka-extras', 'impeka_grve_fullpage_data', $fullpage_data );
		wp_localize_script( 'impeka-extras', 'impeka_grve_data', $impeka_grve_data );
		wp_localize_script( 'impeka-main', 'impeka_grve_main_data', $impeka_grve_main_data );
		if ( function_exists( 'wp_add_inline_script' ) ) {
			wp_add_inline_script( 'impeka-main', $resolution_code );
			wp_add_inline_script( 'impeka-main', impeka_grve_get_privacy_cookie_script() );
			if ( !empty( $custom_js_code ) ) {
				wp_add_inline_script( 'impeka-main', $custom_js_code );
			}
		}
	} else {
		wp_localize_script( 'jquery-smoothscroll', 'impeka_grve_smoothscroll_data', $smoothscroll_data );
		wp_localize_script( 'jquery-fullpage', 'impeka_grve_fullpage_data', $fullpage_data );
		wp_localize_script( 'impeka-grve', 'impeka_grve_data', $impeka_grve_data );
		wp_localize_script( 'impeka-main', 'impeka_grve_main_data', $impeka_grve_main_data );
		if ( function_exists( 'wp_add_inline_script' ) ) {
			wp_add_inline_script( 'impeka-main', $resolution_code );
			wp_add_inline_script( 'impeka-main', impeka_grve_get_privacy_cookie_script() );
			if ( !empty( $custom_js_code ) ) {
				wp_add_inline_script( 'impeka-main', $custom_js_code );
			}
		}
	}

}
add_action( 'wp_enqueue_scripts', 'impeka_grve_frontend_scripts' );

/**
 * Font Awesome fix
 */
function impeka_grve_wpb_frontend_css() {
	if ( wp_style_is( 'font-awesome', 'registered' ) ) {
		wp_deregister_style( 'font-awesome' );
		wp_register_style( 'font-awesome', get_template_directory_uri() . '/css/font-awesome.min.css', array(), '5.15.3' );
	}
}
add_action( 'vc_base_register_front_css', 'impeka_grve_wpb_frontend_css' );
add_action( 'elementor/frontend/after_register_styles', 'impeka_grve_wpb_frontend_css' );

/**
 * Comments
 */
function impeka_grve_comments( $comment, $args, $depth ) {
	$GLOBALS['comment'] = $comment;
	?>
	<li class="grve-comment-item">
		<!-- Comment -->
		<div id="comment-<?php comment_ID(); ?>"  <?php comment_class(); ?>>
			<div class="grve-comment-inner">
				<div class="grve-author-image">
					<?php echo get_avatar( $comment, 50 ); ?>
				</div>
				<div class="grve-comment-content">
					<div class="grve-title-wrapper">
						<span class="grve-title grve-text-heading grve-h6"><?php comment_author(); ?></span>
						<div class="grve-comment-meta grve-small-text">
							<a href="<?php echo esc_url( get_comment_link( $comment->comment_ID ) ) ?>" class="grve-comment-date"><?php printf( ' %1$s ' . esc_html__( 'at', 'impeka' ) . ' %2$s', get_comment_date(),  get_comment_time() ); ?></a>
							<?php comment_reply_link( array_merge( $args, array('depth' => $depth, 'max_depth' => $args['max_depth'], 'reply_text' => esc_html__( 'Reply', 'impeka' ) ) ) ); ?>
							<?php edit_comment_link( esc_html__( 'Edit', 'impeka' ), '  ', '' ); ?>
						</div>
					</div>
					<?php if ( $comment->comment_approved == '0' ) : ?>
					<p><?php esc_html_e( 'Your comment is awaiting moderation.', 'impeka' ); ?></p>
					<?php endif; ?>
					<div class="grve-comment-text"><?php comment_text(); ?></div>
				</div>
			</div>
		</div>

	<!-- </li> is added by WordPress automatically -->
<?php
}

/**
 * Navigation links for prev/next in comments
 */
function impeka_grve_replace_reply_link_class( $output ) {
	$class = 'grve-comment-reply';
	return preg_replace( '/comment-reply-link/', 'comment-reply-link ' . $class, $output, 1 );
}
add_filter('comment_reply_link', 'impeka_grve_replace_reply_link_class');

function impeka_grve_replace_edit_link_class( $output ) {
	$class = 'grve-comment-edit';
	return preg_replace( '/comment-edit-link/', 'comment-edit-link ' . $class, $output, 1 );
}
add_filter('edit_comment_link', 'impeka_grve_replace_edit_link_class');

/**
 * Add a pingback url auto-discovery header for single posts, pages, or attachments.
 *
 */
function impeka_grve_pingback_header() {
	if ( is_singular() && pings_open() ) {
		echo '<link rel="pingback" href="', esc_url( get_bloginfo( 'pingback_url' ) ), '">';
	}
}
add_action( 'wp_head', 'impeka_grve_pingback_header' );

/**
 * Theme identifier function
 * Used to get theme information
 */
function impeka_grve_info() {

	$theme_info = array (
		"version" => IMPEKA_GRVE_THEME_VERSION,
		"short_name" => 'impeka',
	);

	return $theme_info;
}

/**
 * Add Container
 */
add_action('the_content','impeka_grve_container_div');

if ( ! function_exists( 'impeka_grve_container_div' ) ) {
	function impeka_grve_container_div( $content ){
		if( is_singular() && !is_singular( 'tribe_events' ) ) {
			if ( class_exists( 'Impeka_WPBakery_Extension_Plugin' ) && ( has_shortcode( $content, 'vc_row') ||  has_shortcode( $content, 'vc_section' ) ) ) {
				//container already added
			} elseif ( class_exists( 'Elementor\Widget_Base' ) && 'builder' == impeka_grve_post_meta( '_elementor_edit_mode' ) ) {
				//container handling from elementor
			} else {
				$content = '<div class="grve-container">' . $content . '</div>';
			}
		}
		return $content;
	}
}

/**
 * Add wp_body_open function
 */
if ( ! function_exists( 'wp_body_open' ) ) {
    function wp_body_open() {
        do_action( 'wp_body_open' );
    }
}

/**
 * Add max srcset
 */
if ( ! function_exists( 'impeka_grve_max_srcset_image_width' ) ) {
	function impeka_grve_max_srcset_image_width( $max_image_width, $size_array ) {
		return 1920;
	}
}
add_filter( 'max_srcset_image_width', 'impeka_grve_max_srcset_image_width', 10 , 2 );

/**
 * Theme Migration
 */
if ( ! function_exists( 'impeka_grve_theme_migration' ) ) {
	function impeka_grve_theme_migration() {
		$theme_migration = get_option( 'impeka_grve_theme_migration' );

		if ( empty( $theme_migration ) || version_compare( $theme_migration, '1.0', '<' ) ) {
			//Migration code
		}
	}
}
add_action( 'after_setup_theme', 'impeka_grve_theme_migration' );

//Omit closing PHP tag to avoid accidental whitespace output errors.
