<?php

/*
*	Admin screen functions
*
* 	@version	1.0
* 	@author		Greatives Team
* 	@URI		https://greatives.eu
*/


$impeka_grve_admin_screens = array(
	'impeka' => array(
		'id' => 'impeka',
		'title' => esc_html__('Welcome','impeka'),
		'tab' => 'welcome',
		'admin_url' => '?page=impeka',
		'function' => 'impeka_grve_admin_page_welcome',
	),
	'impeka-status' => array(
		'id' => 'impeka-status',
		'title' => esc_html__('Status','impeka'),
		'tab' => 'status',
		'admin_url' => '?page=impeka-status',
		'function' => 'impeka_grve_admin_page_status',
	),
	'impeka-sidebars' => array(
		'id' => 'impeka-sidebars',
		'title' => esc_html__('Custom Sidebars','impeka'),
		'tab' => 'sidebars',
		'admin_url' => '?page=impeka-sidebars',
		'function' => 'impeka_grve_admin_page_sidebars',
	),
	'impeka-import' => array(
		'id' => 'impeka-import',
		'title' => esc_html__('Import Demos','impeka'),
		'tab' => 'import',
		'admin_url' => '?page=impeka-import',
		'function' => 'impeka_grve_admin_page_import',
	),
	'impeka-wizard' => array(
		'id' => 'impeka-wizard',
		'title' => esc_html__('Startup Wizard','impeka'),
		'tab' => 'wizard',
		'admin_url' => '?page=impeka-wizard',
		'function' => 'impeka_grve_admin_page_wizard',
	),
);
$impeka_grve_admin_screens = apply_filters( 'impeka_grve_admin_screens', $impeka_grve_admin_screens );

function impeka_grve_admin_screens_body_class( $string ){
	global $impeka_grve_admin_screens;
	if ( isset( $_GET['page'] ) ) {
		$current_page = $_GET['page'];
		if ( 'impeka-tgmpa-install-plugins' == $current_page ) {
			$string .= " grve-admin-screen";
		} else {
			foreach ( $impeka_grve_admin_screens as $screen ) {
				if (  $screen['id'] == $current_page ) {
					$string .= " grve-admin-screen";
				}
			}
		}
	}
	return $string;
}
add_filter( 'admin_body_class', 'impeka_grve_admin_screens_body_class' );

function impeka_grve_admin_menu(){
	global $impeka_grve_admin_screens;

	$admin_menu_page = array (
		'title' => esc_html__('Impeka','impeka'),
		'menu_title' => esc_html__('Impeka','impeka'),
		'capability' => 'edit_theme_options',
		'menu_slug' => 'impeka',
		'function' => 'impeka_grve_admin_page_welcome',
		'icon_url' => get_template_directory_uri() .'/includes/images/adminmenu/theme.svg',
		'position' => '4',
	);
	$menu_page = apply_filters( 'impeka_grve_admin_menu_page', $admin_menu_page );


	if ( current_user_can( 'edit_theme_options' ) ) {
		add_menu_page( $menu_page['title'], $menu_page['menu_title'], $menu_page['capability'], $menu_page['menu_slug'], $menu_page['function'], $menu_page['icon_url'],  $menu_page['position'] );
		foreach ( $impeka_grve_admin_screens as $screen ) {
			add_submenu_page( 'impeka', $screen['title'], $screen['title'], 'edit_theme_options', $screen['id'], $screen['function'] );
		}
	}
}

add_action( 'admin_menu', 'impeka_grve_admin_menu' );


function impeka_grve_tgmpa_plugins_links(){
	echo '<div id="grve-admin-nav-wrapper">';
	impeka_grve_print_admin_links('plugins');
	echo '</div>';
}
add_action( 'impeka_grve_before_tgmpa_plugins', 'impeka_grve_tgmpa_plugins_links' );

function impeka_grve_admin_page_welcome(){
	require_once get_template_directory() . '/includes/admin/pages/grve-admin-page-welcome.php';
}
function impeka_grve_admin_page_register(){
	require_once get_template_directory() . '/includes/admin/pages/grve-admin-page-register.php';
}
function impeka_grve_admin_page_status(){
	require_once get_template_directory() . '/includes/admin/pages/grve-admin-page-status.php';
}
function impeka_grve_admin_page_sidebars(){
	require_once get_template_directory() . '/includes/admin/pages/grve-admin-page-sidebars.php';
}
function impeka_grve_admin_page_import(){
	require_once get_template_directory() . '/includes/admin/pages/grve-admin-page-import.php';
}
function impeka_grve_admin_page_wizard(){
	require_once get_template_directory() . '/includes/admin/pages/grve-admin-page-wizard.php';
}

function impeka_grve_print_admin_links( $active_tab = 'status', $skip = '' ) {
	global $impeka_grve_admin_screens;
?>
<ul class="grve-admin-nav">
<?php
	foreach ( $impeka_grve_admin_screens as $screen ) {
		$active_class = '';
		if( $screen['tab'] == $active_tab ) {
			if ( !empty( $skip ) ) {
				continue;
			}
			$active_class = 'grve-nav-active';
		}
?>
	<li><a href="<?php echo esc_url( $screen['admin_url'] ); ?>" class="<?php echo esc_attr( $active_class ); ?>"><?php echo esc_html( $screen['title'] ) ?></a></li>
<?php
	}
?>
	<li><a href="?page=impeka-tgmpa-install-plugins" class="<?php echo 'plugins' == $active_tab ? 'grve-nav-active' : ''; ?>"><?php echo esc_html__('Theme Plugins','impeka'); ?></a></li>
	<?php do_action( 'impeka_grve_admin_links', $active_tab ); ?>
</ul>
<?php
}

function impeka_grve_tgmpa_form_start() {
	ob_start();
?>
	<div id="grve-admin-pannel-wrapper" class="grve-plugins-wrap tgmpa">
		<?php do_action( 'impeka_grve_before_tgmpa_plugins' ); ?>
		<div class="grve-admin-title">
			<h2 class="grve-title"><?php esc_html_e( "Theme Plugins", 'impeka' ); ?></h2>
			<p class="grve-description"><?php esc_html_e( "Check the status of required and recommended theme plugins. Always make sure you are fully updated to avoid compatibility issues and receive new features. You can even control these on Plugins screen with any other 3rd party plugins you use.", 'impeka' ); ?></p>
		</div>
<?php
	echo ob_get_clean();
}
add_action( 'impeka_grve_before_tgmpa_form', 'impeka_grve_tgmpa_form_start' );

function impeka_grve_tgmpa_form_end() {
	ob_start();
	?>
	</div>
	<?php
	echo ob_get_clean();
}
add_action( 'impeka_grve_after_tgmpa_form', 'impeka_grve_tgmpa_form_end' );

function impeka_grve_upgrader_pre_download( $reply, $package, $upgrader ) {

	$is_premium = false;

	$plugins = array(
		'impeka-wpb-extension',
		'impeka-elementor-extension',
		'impeka-gutenberg-extension',
 		'impeka-dummy-importer',
		'js_composer',
 		'revslider',
	);
	foreach ( $plugins as $slug ) {
		if ( strpos( $package, $slug ) !== false ) {
			$is_premium = true;
			break;
		}
	}
	if ( $is_premium  && !impeka_grve_check_theme_status('plugin') ) {
		return new WP_Error(
			'impeka_grve_premium_plugin_activation_error',
			'<br>' . sprintf( esc_html__( "You need to %s in order to install/update this plugin.", 'impeka' ), '<a href="' . esc_url( admin_url()  . 'admin.php?page=impeka' ) . '" >' . esc_html__( 'register your product', 'impeka' ) . '</a>' ) . '<br><br>'
		);
	}

	return $reply;
}
add_filter( 'upgrader_pre_download', 'impeka_grve_upgrader_pre_download', 10, 3 );


function impeka_grve_theme_version(){

	$theme = wp_get_theme();
	$theme_version = $theme->get('Version');
	if( is_child_theme() ) {
		$parent_theme = wp_get_theme( get_template() );
		$theme_version = $parent_theme->get('Version');
	}

	return $theme_version;
}

//Omit closing PHP tag to avoid accidental whitespace output errors.