<?php
/*
*	'impeka' Category Meta
*
* 	@author		Greatives Team
* 	@URI		https://greatives.eu
*/

	//Categories
	add_action('category_edit_form_fields','impeka_grve_category_edit_form_fields', 10);
	add_action('post_tag_edit_form_fields','impeka_grve_category_edit_form_fields', 10);
	add_action('product_cat_edit_form_fields','impeka_grve_category_edit_form_fields', 10);
	add_action('product_tag_edit_form_fields','impeka_grve_category_edit_form_fields', 10);
	add_action('portfolio_category_edit_form_fields','impeka_grve_category_edit_form_fields', 10);
	add_action('portfolio_field_edit_form_fields','impeka_grve_category_edit_form_fields', 10);
	add_action('edit_term','impeka_grve_save_category_fields', 10, 3);

	function impeka_grve_category_edit_form_fields( $term ) {
		$term_meta = impeka_grve_get_term_meta( $term->term_id, '_impeka_grve_custom_title_options' );
		impeka_grve_print_category_fields( $term_meta );
	}

	function impeka_grve_print_category_fields( $custom_title_options = array() ) {

		$area_height = impeka_grve_global_admin_param( 'area_height' );
		$bg_position_selection = impeka_grve_global_admin_param( 'bg_position_selection' );

?>
		<tr class="form-field">
			<td colspan="2">
				<div id="grve-category-title" class="postbox">
<?php

			//Custom Title Option
			impeka_grve_print_admin_option(
				array(
					'type' => 'select',
					'name' => 'impeka_grve_term_meta[custom]',
					'id' => 'grve-category-title-custom',
					'value' => impeka_grve_array_value( $custom_title_options, 'custom' ),
					'options' => array(
						'' => esc_html__( '-- Inherit --', 'impeka' ),
						'custom' => esc_html__( 'Custom', 'impeka' ),

					),
					'label' => array(
						"title" => esc_html__( 'Title Options', 'impeka' ),
					),
					'group_id' => 'grve-category-title',
					'highlight' => 'highlight',
				)
			);


			impeka_grve_print_admin_option(
				array(
					'type' => 'select',
					'options' => $area_height,
					'name' => 'impeka_grve_term_meta[height]',
					'id' => 'grve-category-title-height',
					'value' => impeka_grve_array_value( $custom_title_options, 'height', '40' ),
					'label' => array(
						"title" => esc_html__( 'Title Area Height', 'impeka' ),
					),
					'dependency' =>
					'[
						{ "id" : "grve-category-title-custom", "values" : ["custom"] }
					]',
				)
			);
			impeka_grve_print_admin_option(
				array(
					'type' => 'textfield',
					'name' => 'impeka_grve_term_meta[min_height]',
					'id' => 'grve-category-title-min-height',
					'value' => impeka_grve_array_value( $custom_title_options, 'min_height', '200' ),
					'label' => array(
						"title" => esc_html__( 'Title Area Minimum Height in px', 'impeka' ),
					),
					'dependency' =>
					'[
						{ "id" : "grve-category-title-custom", "values" : ["custom"] }
					]',
				)
			);

			impeka_grve_print_admin_option(
				array(
					'type' => 'select',
					'name' => 'impeka_grve_term_meta[container_size]',
					'id' => 'grve-category-title-container-size',
					'options' => array(
						'' => esc_html__( 'Default', 'impeka' ),
						'large' => esc_html__( 'Large', 'impeka' ),
					),
					'value' => impeka_grve_array_value( $custom_title_options, 'container_size' ),
					'label' => array(
						"title" => esc_html__( 'Container Size', 'impeka' ),
					),
					'dependency' =>
					'[
						{ "id" : "grve-category-title-custom", "values" : ["custom"] }
					]',
				)
			);

			impeka_grve_print_admin_option(
				array(
					'type' => 'select-colorpicker',
					'name' => 'impeka_grve_term_meta[bg_color]',
					'id' => 'grve-category-title-bg-color',
					'value' => impeka_grve_array_value( $custom_title_options, 'bg_color', 'black' ),
					'value2' => impeka_grve_array_value( $custom_title_options, 'bg_color_custom', '#000000' ),
					'default_value2' => '#000000',
					'label' => array(
						"title" => esc_html__( 'Background Color', 'impeka' ),
					),
					'dependency' =>
					'[
						{ "id" : "grve-category-title-custom", "values" : ["custom"] }
					]',
					'multiple' => 'multi',
					'type_usage' => 'section-bg',
				)
			);
			impeka_grve_print_admin_option(
				array(
					'type' => 'select-colorpicker',
					'name' => 'impeka_grve_term_meta[content_bg_color]',
					'id' => 'grve-category-title-content-bg-color',
					'value' => impeka_grve_array_value( $custom_title_options, 'content_bg_color', 'none' ),
					'value2' => impeka_grve_array_value( $custom_title_options, 'content_bg_color_custom', '#ffffff' ),
					'default_value2' => '#ffffff',
					'label' => array(
						"title" => esc_html__( 'Content Background Color', 'impeka' ),
					),
					'dependency' =>
					'[
						{ "id" : "grve-category-title-custom", "values" : ["custom"] }
					]',
					'multiple' => 'multi',
					'type_usage' => 'title-content-bg',
				)
			);
			impeka_grve_print_admin_option(
				array(
					'type' => 'select-colorpicker',
					'name' => 'impeka_grve_term_meta[title_color]',
					'id' => 'grve-category-title-title-color',
					'value' => impeka_grve_array_value( $custom_title_options, 'title_color', 'white' ),
					'value2' => impeka_grve_array_value( $custom_title_options, 'title_color_custom', '#ffffff' ),
					'default_value2' => '#ffffff',
					'label' => array(
						"title" => esc_html__( 'Title Color', 'impeka' ),
					),
					'dependency' =>
					'[
						{ "id" : "grve-category-title-custom", "values" : ["custom"] }
					]',
					'multiple' => 'multi',
				)
			);

			impeka_grve_print_admin_option(
				array(
					'type' => 'select-colorpicker',
					'name' => 'impeka_grve_term_meta[caption_color]',
					'id' => 'grve-category-title-caption_color',
					'value' => impeka_grve_array_value( $custom_title_options, 'caption_color', 'white' ),
					'value2' => impeka_grve_array_value( $custom_title_options, 'caption_color_custom', '#ffffff' ),
					'default_value2' => '#ffffff',
					'label' => array(
						"title" => esc_html__( 'Description Color', 'impeka' ),
					),
					'dependency' =>
					'[
						{ "id" : "grve-category-title-custom", "values" : ["custom"] }
					]',
					'multiple' => 'multi',
				)
			);

			impeka_grve_print_admin_option(
				array(
					'type' => 'select',
					'name' => 'impeka_grve_term_meta[content_size]',
					'id' => 'grve-category-title-content-size',
					'options' => array(
						'container' => esc_html__( 'Container Size', 'impeka' ),
						'large' => esc_html__( 'Large', 'impeka' ),
						'medium' => esc_html__( 'Medium', 'impeka' ),
						'small' => esc_html__( 'Small', 'impeka' ),
					),
					'value' => impeka_grve_array_value( $custom_title_options, 'content_size', 'container' ),
					'label' => array(
						"title" => esc_html__( 'Content Size', 'impeka' ),
					),
					'dependency' =>
					'[
						{ "id" : "grve-category-title-custom", "values" : ["custom"] }
					]',
				)
			);

			impeka_grve_print_admin_option(
				array(
					'type' => 'select-align',
					'name' => 'impeka_grve_term_meta[content_alignment]',
					'id' => 'grve-category-title-content-alignment',
					'value' => impeka_grve_array_value( $custom_title_options, 'content_alignment', 'center' ),
					'label' => array(
						"title" => esc_html__( 'Content Alignment', 'impeka' ),
					),
					'dependency' =>
					'[
						{ "id" : "grve-category-title-custom", "values" : ["custom"] }
					]',
				)
			);

			impeka_grve_print_admin_option(
				array(
					'type' => 'select',
					'name' => 'impeka_grve_term_meta[content_position]',
					'id' => 'grve-category-title-content_position',
					'value' => impeka_grve_array_value( $custom_title_options, 'content_position', 'center-center' ),
					'options' => $bg_position_selection,
					'label' => array(
						"title" => esc_html__( 'Content Position', 'impeka' ),
					),
					'dependency' =>
					'[
						{ "id" : "grve-category-title-custom", "values" : ["custom"] }
					]',
				)
			);

			impeka_grve_print_admin_option(
				array(
					'type' => 'select-text-animation',
					'name' => 'impeka_grve_term_meta[content_animation]',
					'value' => impeka_grve_array_value( $custom_title_options, 'content_animation', 'none' ),
					'label' => esc_html__( 'Content Animation', 'impeka' ),
					'dependency' =>
					'[
						{ "id" : "grve-category-title-custom", "values" : ["custom"] }
					]',
				)
			);


			impeka_grve_print_admin_option(
				array(
					'type' => 'select',
					'name' => 'impeka_grve_term_meta[bg_mode]',
					'id' => 'grve-category-title-bg-mode',
					'value' => impeka_grve_array_value( $custom_title_options, 'bg_mode'),
					'options' => array(
						'' => esc_html__( 'Color Only', 'impeka' ),
						'custom' => esc_html__( 'Custom Image', 'impeka' ),

					),
					'label' => array(
						"title" => esc_html__( 'Background Mode', 'impeka' ),
					),
					'group_id' => 'grve-category-title',
					'dependency' =>
					'[
						{ "id" : "grve-category-title-custom", "values" : ["custom"] }

					]',
				)
			);
			impeka_grve_print_admin_option(
				array(
					'type' => 'select-image',
					'name' => 'impeka_grve_term_meta[bg_image_id]',
					'id' => 'grve-category-title-bg-image-id',
					'value' => impeka_grve_array_value( $custom_title_options, 'bg_image_id'),
					'label' => array(
						"title" => esc_html__( 'Background Image', 'impeka' ),
					),
					'width' => 'fullwidth',
					'dependency' =>
					'[
						{ "id" : "grve-category-title-custom", "values" : ["custom"] },
						{ "id" : "grve-category-title-bg-mode", "values" : ["custom"] }

					]',
				)
			);
			impeka_grve_print_admin_option(
				array(
					'type' => 'select-bg-position',
					'name' => 'impeka_grve_term_meta[bg_position]',
					'id' => 'grve-category-title-bg-position',
					'value' => impeka_grve_array_value( $custom_title_options, 'bg_position', 'center-center'),
					'label' => array(
						"title" => esc_html__( 'Background Position', 'impeka' ),
					),
					'dependency' =>
					'[
						{ "id" : "grve-category-title-custom", "values" : ["custom"] },
						{ "id" : "grve-category-title-bg-mode", "values" : ["custom"] }
					]',
				)
			);

			impeka_grve_print_admin_option(
				array(
					'type' => 'select-pattern-overlay',
					'name' => 'impeka_grve_term_meta[pattern_overlay]',
					'value' => impeka_grve_array_value( $custom_title_options, 'pattern_overlay'),
					'label' => esc_html__( 'Pattern Overlay', 'impeka' ),
					'dependency' =>
					'[
						{ "id" : "grve-category-title-custom", "values" : ["custom"] },
						{ "id" : "grve-category-title-bg-mode", "values" : ["custom"] }
					]',
				)
			);
			impeka_grve_print_admin_option(
				array(
					'type' => 'select-colorpicker',
					'name' => 'impeka_grve_term_meta[color_overlay]',
					'value' => impeka_grve_array_value( $custom_title_options, 'color_overlay', 'black' ),
					'value2' => impeka_grve_array_value( $custom_title_options, 'color_overlay_custom', '#000000' ),
					'default_value2' => '#000000',
					'label' => esc_html__( 'Color Overlay', 'impeka' ),
					'multiple' => 'multi',
					'dependency' =>
					'[
						{ "id" : "grve-category-title-custom", "values" : ["custom"] },
						{ "id" : "grve-category-title-bg-mode", "values" : ["custom"] }
					]',
				)
			);
			impeka_grve_print_admin_option(
				array(
					'type' => 'select-opacity',
					'name' => 'impeka_grve_term_meta[opacity_overlay]',
					'value' => impeka_grve_array_value( $custom_title_options, 'opacity_overlay', '0' ),
					'label' => esc_html__( 'Opacity Overlay', 'impeka' ),
					'dependency' =>
					'[
						{ "id" : "grve-category-title-custom", "values" : ["custom"] },
						{ "id" : "grve-category-title-bg-mode", "values" : ["custom"] }
					]',
				)
			);
?>
			</div>
		</td>
	</tr>
<?php
	}

	//Save Category Meta
	function impeka_grve_save_category_fields( $term_id, $tt_id = '', $taxonomy = '' ) {

		if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) {
			return;
		}

		$custom_meta_tax = array ( 'category', 'post_tag', 'product_cat', 'product_tag', 'portfolio_category', 'portfolio_field' );

		if ( isset( $_POST['impeka_grve_term_meta'] ) && in_array( $taxonomy, $custom_meta_tax ) ) {
			$term_meta = impeka_grve_get_term_meta( $term_id, '_impeka_grve_custom_title_options' );
			$cat_keys = array_keys( $_POST['impeka_grve_term_meta'] );
			foreach ( $cat_keys as $key ) {
				if ( isset( $_POST['impeka_grve_term_meta'][$key] ) ) {
					$term_meta[$key] = sanitize_text_field( $_POST['impeka_grve_term_meta'][$key] );
				}
			}
			impeka_grve_update_term_meta( $term_id , '_impeka_grve_custom_title_options', $term_meta );
		}
	}

//Omit closing PHP tag to avoid accidental whitespace output errors.
