<?php
/*
*	Helper Functions for meta options ( Post / Page / Portfolio / Product )
*
* 	@author		Greatives Team
* 	@URI		https://greatives.eu
*/


/**
 * Functions to print global metaboxes
 */

add_action( 'save_post', 'impeka_grve_generic_options_save_postdata', 10, 2 );

/**
 * Page Options Metabox
 */
function impeka_grve_page_options_box( $post ) {

	$color_selection = impeka_grve_global_admin_param( 'button_color_selection' );
	$area_height = impeka_grve_global_admin_param( 'area_height' );
	$bg_position_selection = impeka_grve_global_admin_param( 'bg_position_selection' );


	$post_type = get_post_type( $post->ID );
	$post_id = $post->ID;

	$page_title_selection = array(
		'' => esc_html__( '-- Inherit --', 'impeka' ),
		'custom' => esc_html__( 'Custom Advanced Title', 'impeka' ),
	);
	$area_colors_info = esc_html__( 'Inherit : Appearance - Customize', 'impeka' );
	$theme_options_info_text_empty = $desc_info = "";

	switch( $post_type ) {
		case 'tribe_events':
			$theme_options_info = esc_html__( 'Inherit : Theme Options - Events Calendar Options - Single Event Settings.', 'impeka' );
		break;
		case 'portfolio':
			$theme_options_info = esc_html__( 'Inherit : Theme Options - Portfolio Options- Single Portfolio Settings.', 'impeka' );
			$theme_options_info_text_empty =  esc_html__('If empty, text is configured from: Theme Options - Portfolio Options.', 'impeka' );
			$desc_info = esc_html__( 'Enter your portfolio description.', 'impeka' );
		break;
		case 'post':
			$theme_options_info = esc_html__( 'Inherit : Theme Options - Blog Options - Single Post Settings.', 'impeka' );
			$theme_options_info_text_empty =  esc_html__('If empty, text is configured from: Theme Options - Blog Options - Single Post Settings.', 'impeka' );
			$desc_info = esc_html__( 'Enter your post description( Not available in Simple Title ).', 'impeka' );
			$page_title_selection = array(
				'' => esc_html__( '-- Inherit --', 'impeka' ),
				'custom' => esc_html__( 'Custom Advanced Title', 'impeka' ),
				'simple' => esc_html__( 'Simple Title', 'impeka' ),
			);
		break;
		case 'product':
			$area_colors_info = esc_html__( 'Inherit : Appearance - Customize - Colors - Shop/Product - Colors - Product Area.', 'impeka' );
			$theme_options_info = esc_html__( 'Inherit : Theme Options - WooCommerce Options - Single Product.', 'impeka' );
			$theme_options_info_text_empty =  esc_html__('If empty, text is configured from: Theme Options - WooCommerce Options - Single Product.', 'impeka' );
			$desc_info = esc_html__( 'Enter your product description( Not available in Simple Title ).', 'impeka' );
			$page_title_selection = array(
				'' => esc_html__( '-- Inherit --', 'impeka' ),
				'custom' => esc_html__( 'Custom Advanced Title', 'impeka' ),
				'simple' => esc_html__( 'Simple Title', 'impeka' ),
			);
		break;
		case 'page':
		default:
			$theme_options_info = esc_html__( 'Inherit : Theme Options - Page Options.', 'impeka' );
			$theme_options_info_text_empty =  esc_html__('If empty, text is configured from: Theme Options - Page Options.', 'impeka' );
			$desc_info = esc_html__( 'Enter your page description.', 'impeka' );
		break;
	}

	$page_padding_selection = array(
		'' => esc_html__( '-- Inherit --', 'impeka' ),
		'none' => esc_html__( 'None', 'impeka' ),
		'1x' => esc_html__( '1x', 'impeka' ),
		'2x' => esc_html__( '2x', 'impeka' ),
		'3x' => esc_html__( '3x', 'impeka' ),
		'4x' => esc_html__( '4x', 'impeka' ),
		'5x' => esc_html__( '5x', 'impeka' ),
		'6x' => esc_html__( '6x', 'impeka' ),
	);

	$page_padding_selection_extra = array(
		'' => esc_html__( '-- Inherit --', 'impeka' ),
		'none' => esc_html__( 'None', 'impeka' ),
		'1x' => esc_html__( '1x', 'impeka' ),
		'2x' => esc_html__( '2x', 'impeka' ),
		'3x' => esc_html__( '3x', 'impeka' ),
		'4x' => esc_html__( '4x', 'impeka' ),
		'5x' => esc_html__( '5x', 'impeka' ),
		'6x' => esc_html__( '6x', 'impeka' ),
		'custom' => esc_html__( 'Custom', 'impeka' ),
	);

	wp_nonce_field( 'impeka_grve_nonce_page_save', '_impeka_grve_nonce_page_save' );


	$custom_title_options = get_post_meta( $post->ID, '_impeka_grve_custom_title_options', true );
	$content_skin_options = get_post_meta( $post->ID, '_impeka_grve_content_skin_options', true );

	$title = get_post_meta( $post->ID, '_impeka_grve_title', true );
	$description = get_post_meta( $post->ID, '_impeka_grve_description', true );

	//Product Area
	$area_colors = get_post_meta( $post->ID, '_impeka_grve_area_colors', true );
	$area_padding_top_multiplier = get_post_meta( $post->ID, '_impeka_grve_area_padding_top_multiplier', true );
	$area_padding_bottom_multiplier = get_post_meta( $post->ID, '_impeka_grve_area_padding_bottom_multiplier', true );

	//Layout Fields
	$padding_top_multiplier = get_post_meta( $post->ID, '_impeka_grve_padding_top_multiplier', true );
	$padding_bottom_multiplier = get_post_meta( $post->ID, '_impeka_grve_padding_bottom_multiplier', true );
	$padding_top = get_post_meta( $post->ID, '_impeka_grve_padding_top', true );
	$padding_bottom = get_post_meta( $post->ID, '_impeka_grve_padding_bottom', true );
	$layout = get_post_meta( $post->ID, '_impeka_grve_layout', true );
	$sidebar = get_post_meta( $post->ID, '_impeka_grve_sidebar', true );
	$fixed_sidebar = get_post_meta( $post->ID, '_impeka_grve_fixed_sidebar', true );
	$post_content_width = get_post_meta( $post->ID, '_impeka_grve_post_content_width', true ); //Post/Product/Event Only
	$content_skin = get_post_meta( $post->ID, '_impeka_grve_content_skin', true );

	//Side Area
	$sidearea_visibility = get_post_meta( $post->ID, '_impeka_grve_sidearea_visibility', true );
	$sidearea_sidebar = get_post_meta( $post->ID, '_impeka_grve_sidearea_sidebar', true );

	//Scrolling Page
	$scrolling_page = get_post_meta( $post->ID, '_impeka_grve_scrolling_page', true );
	$responsive_scrolling = get_post_meta( $post->ID, '_impeka_grve_responsive_scrolling', true );
	$scrolling_lock_anchors = get_post_meta( $post->ID, '_impeka_grve_scrolling_lock_anchors', true );
	$scrolling_direction = get_post_meta( $post->ID, '_impeka_grve_scrolling_direction', true );
	$scrolling_loop = get_post_meta( $post->ID, '_impeka_grve_scrolling_loop', true );
	$scrolling_speed = get_post_meta( $post->ID, '_impeka_grve_scrolling_speed', true );

	//Header - Main Menu Fields
	$header_overlapping = get_post_meta( $post->ID, '_impeka_grve_header_overlapping', true );
	$header_skin = get_post_meta( $post->ID, '_impeka_grve_header_skin', true );
	$main_navigation_menu = get_post_meta( $post->ID, '_impeka_grve_main_navigation_menu', true );
	$second_navigation_menu = get_post_meta( $post->ID, '_impeka_grve_second_navigation_menu', true );
	$responsive_navigation_menu = get_post_meta( $post->ID, '_impeka_grve_responsive_navigation_menu', true );
	$sticky_header_type = get_post_meta( $post->ID, '_impeka_grve_sticky_header_type', true );
	$safe_button_area = get_post_meta( $post->ID, '_impeka_grve_safe_button_area', true );
	$responsive_header_overlapping = get_post_meta( $post->ID, '_impeka_grve_responsive_header_overlapping', true );

	//Quick  View
	$quickview_title = get_post_meta( $post->ID, '_impeka_grve_quickview_title', true );
	$quickview_text = get_post_meta( $post->ID, '_impeka_grve_quickview_text', true );
	$quickview_link_text = get_post_meta( $post->ID, '_impeka_grve_quickview_link_text', true );

	//Details Area
	$details_mode = get_post_meta( $post->ID, '_impeka_grve_details_mode', true ); //Portfolio Only
	$details_title = get_post_meta( $post->ID, '_impeka_grve_details_title', true ); //Portfolio Only
	$details = get_post_meta( $post->ID, '_impeka_grve_details', true ); //Portfolio Only

	$details_link_text = get_post_meta( $post->ID, '_impeka_grve_details_link_text', true ); //Portfolio Only
	$details_link_url = get_post_meta( $post->ID, '_impeka_grve_details_link_url', true ); //Portfolio Only
	$details_link_new_window = get_post_meta( $post->ID, '_impeka_grve_details_link_new_window', true ); //Portfolio Only
	$details_link_extra_class = get_post_meta( $post->ID, '_impeka_grve_details_link_extra_class', true ); //Portfolio Only

	//Extras
	$social_bar_layout = get_post_meta( $post->ID, '_impeka_grve_social_bar_layout', true ); //Portfolio Only
	$nav_id = get_post_meta( $post->ID, '_impeka_grve_nav_id', true ); //Page Only
	$nav_text = get_post_meta( $post->ID, '_impeka_grve_nav_text', true ); //Page Only
	$backlink_id = get_post_meta( $post->ID, '_impeka_grve_backlink_id', true ); //Portfolio. Post,
	$feature_media_type = get_post_meta( $post->ID, '_impeka_grve_feature_media_type', true ); //Post Only

	$anchor_navigation_menu = get_post_meta( $post->ID, '_impeka_grve_anchor_navigation_menu', true );
	$anchor_device_layout = get_post_meta( $post->ID, '_impeka_grve_anchor_device_layout', true );
	$theme_loader = get_post_meta( $post->ID, '_impeka_grve_theme_loader', true );
	$section_nav_hide = get_post_meta( $post->ID, '_impeka_grve_section_nav_hide', true );

	//Visibility Fields
	$disable_top_bar = get_post_meta( $post->ID, '_impeka_grve_disable_top_bar', true );
	$disable_logo = get_post_meta( $post->ID, '_impeka_grve_disable_logo', true );
	$disable_menu = get_post_meta( $post->ID, '_impeka_grve_disable_menu', true );
	$disable_second_menu = get_post_meta( $post->ID, '_impeka_grve_disable_second_menu', true );
	$disable_responsive_menu = get_post_meta( $post->ID, '_impeka_grve_disable_responsive_menu', true );
	$disable_menu_items = get_post_meta( $post->ID, '_impeka_grve_disable_menu_items', true );
	$disable_breadcrumbs = get_post_meta( $post->ID, '_impeka_grve_disable_breadcrumbs', true );
	$disable_title = get_post_meta( $post->ID, '_impeka_grve_disable_title', true );
	$disable_media = get_post_meta( $post->ID, '_impeka_grve_disable_media', true ); //Post Only
	$disable_content = get_post_meta( $post->ID, '_impeka_grve_disable_content', true ); //Page Only
	$disable_related_entries = get_post_meta( $post->ID, '_impeka_grve_disable_related_entries', true );//Portfolio Only
	$disable_back_to_top = get_post_meta( $post->ID, '_impeka_grve_disable_back_to_top', true );

	$footer_sticky = get_post_meta( $post->ID, '_impeka_grve_footer_sticky', true );
	$bottom_bar_area = get_post_meta( $post->ID, '_impeka_grve_bottom_bar_area', true );
	$footer_widgets_visibility = get_post_meta( $post->ID, '_impeka_grve_footer_widgets_visibility', true );
	$footer_bar_visibility = get_post_meta( $post->ID, '_impeka_grve_footer_bar_visibility', true );

?>

	<!--  METABOXES -->
	<div class="grve-metabox-content">

		<!-- TABS -->
		<div class="grve-tabs">

			<ul class="grve-tab-links">
				<li class="active"><a href="#grve-page-option-tab-header"><?php esc_html_e( 'Header / Main Menu', 'impeka' ); ?></a></li>
				<li><a href="#grve-page-option-tab-title"><?php esc_html_e( 'Title / Description', 'impeka' ); ?></a></li>
				<?php if( 'product' == $post_type ) { ?>
				<li><a href="#grve-page-option-tab-section-area"><?php esc_html_e( 'Product Area', 'impeka' ); ?></a></li>
				<?php } ?>
				<?php if( 'portfolio' == $post_type || 'post' == $post_type || 'product' == $post_type ) { ?>
				<li><a href="#grve-page-option-tab-quick-view"><?php esc_html_e( 'Quick View', 'impeka' ); ?></a></li>
				<?php } ?>
				<?php if( 'portfolio' == $post_type ) { ?>
				<li><a href="#grve-page-option-tab-details-area"><?php esc_html_e( 'Details Area', 'impeka' ); ?></a></li>
				<?php } ?>
				<li><a href="#grve-page-option-tab-layout"><?php esc_html_e( 'Content / Sidebars', 'impeka' ); ?></a></li>
				<li><a href="#grve-page-option-tab-side-area"><?php esc_html_e( 'Side Area', 'impeka' ); ?></a></li>
				<?php if( 'page' == $post_type ) { ?>
				<li><a href="#grve-page-option-tab-scrolling-sections"><?php esc_html_e( 'Scrolling Sections', 'impeka' ); ?></a></li>
				<?php } ?>
				<li><a href="#grve-page-option-tab-modals"><?php esc_html_e( 'Modals', 'impeka' ); ?></a></li>
				<li><a href="#grve-page-option-tab-bottom-footer-areas"><?php esc_html_e( 'Bottom / Footer Areas', 'impeka' ); ?></a></li>
				<li><a href="#grve-page-option-tab-extras"><?php esc_html_e( 'Extras', 'impeka' ); ?></a></li>
				<li><a href="#grve-page-option-tab-visibility"><?php esc_html_e( 'Visibility', 'impeka' ); ?></a></li>
			</ul>
			<div class="grve-tab-content">

				<div id="grve-page-option-tab-header" class="grve-tab-item active">
					<?php

						//Header Overlapping Option
						impeka_grve_print_admin_option(
							array(
								'type' => 'select',
								'name' => '_impeka_grve_header_overlapping',
								'id' => '_impeka_grve_header_overlapping',
								'value' => $header_overlapping,
								'options' => array(
									'' => esc_html__( '-- Inherit --', 'impeka' ),
									'yes' => esc_html__( 'Yes', 'impeka' ),
									'no' => esc_html__( 'No', 'impeka' ),
								),
								'label' => array(
									"title" => esc_html__( 'Header Overlapping', 'impeka' ),
									"desc" => esc_html__( 'Select if you want to overlap your page header', 'impeka' ),
									"info" => $theme_options_info,
								),
							)
						);

						//Header skin Option
						impeka_grve_print_admin_option(
							array(
								'type' => 'select',
								'name' => '_impeka_grve_header_skin',
								'id' => '_impeka_grve_header_skin',
								'value' => $header_skin,
								'options' => array(
									'' => esc_html__( '-- Inherit --', 'impeka' ),
									'default' => esc_html__( 'Default', 'impeka' ),
									'dark' => esc_html__( 'Dark', 'impeka' ),
									'light' => esc_html__( 'Light', 'impeka' ),
								),
								'label' => array(
									"title" => esc_html__( 'Header Skin', 'impeka' ),
									"desc" => esc_html__( 'With this option you can change the coloring of your header. In case that you use Slider in Feature Section, select the header skin per slide/image.', 'impeka' ),
									"info" => $theme_options_info,
								),
							)
						);

						//Main Navigation Menu Option
						impeka_grve_print_admin_option_wrapper_start(
							array(
								'type' => 'select',
								'label' => array(
									"title" => esc_html__( 'Main Navigation Menu', 'impeka' ),
									"desc" => esc_html__( 'Select alternative main navigation menu.', 'impeka' ),
									"info" => esc_html__( 'Inherit : Menus - Theme Locations - Header Menu.', 'impeka' ),
								),
							)
						);
						impeka_grve_print_menu_selection( $main_navigation_menu, 'grve-main-navigation-menu', '_impeka_grve_main_navigation_menu', 'default' );
						impeka_grve_print_admin_option_wrapper_end();

						//Second Navigation Menu Option
						impeka_grve_print_admin_option_wrapper_start(
							array(
								'type' => 'select',
								'label' => array(
									"title" => esc_html__( 'Second Navigation Menu', 'impeka' ),
									"desc" => esc_html__( 'Select alternative second navigation menu.', 'impeka' ),
									"info" => esc_html__( 'Inherit : Menus - Theme Locations - Second Menu.', 'impeka' ),
								),
							)
						);
						impeka_grve_print_menu_selection( $second_navigation_menu, 'grve-second-navigation-menu', '_impeka_grve_second_navigation_menu', 'default' );
						impeka_grve_print_admin_option_wrapper_end();

						//Responsive Navigation Menu Option
						impeka_grve_print_admin_option_wrapper_start(
							array(
								'type' => 'select',
								'label' => array(
									"title" => esc_html__( 'Responsive Navigation Menu', 'impeka' ),
									"desc" => esc_html__( 'Select alternative responsive navigation menu.', 'impeka' ),
									"info" => esc_html__( 'Inherit : Menus - Theme Locations - Responsive Menu.', 'impeka' ),
								),
							)
						);
						impeka_grve_print_menu_selection( $responsive_navigation_menu, 'grve-responsive-navigation-menu', '_impeka_grve_responsive_navigation_menu', 'default' );
						impeka_grve_print_admin_option_wrapper_end();

						//Sticky Header Type
						impeka_grve_print_admin_option(
							array(
								'type' => 'select',
								'name' => '_impeka_grve_sticky_header_type',
								'id' => '_impeka_grve_sticky_header_type',
								'value' => $sticky_header_type,
								'options' => array(
									'' => esc_html__( '-- Inherit --', 'impeka' ),
									'none' => esc_html__( '-- None --', 'impeka' ),
								),
								'label' => array(
									"title" => esc_html__( 'Sticky Header Type', 'impeka' ),
									"desc" => esc_html__( 'With this option you can select the type of sticky header.', 'impeka' ),
									"info" => esc_html__( 'Inherit : Theme Options - Header Options - Sticky Header Options.', 'impeka' ),
								),
							)
						);

						//Safe Button Area
						impeka_grve_print_admin_option_wrapper_start(
							array(
								'type' => 'select',
								'label' => array(
									"title" => esc_html__( 'Safe Button Area', 'impeka' ),
									"desc" => esc_html__( 'Select an area item for your Safe Button Area.', 'impeka' ),
									"info" => esc_html__( 'Inherit : Theme Options - Header Options - Safe Button Area.', 'impeka' ),
								),
							)
						);
						impeka_grve_print_area_selection( $safe_button_area, 'grve-safe-button-area', '_impeka_grve_safe_button_area' );
						impeka_grve_print_admin_option_wrapper_end();

						//Responsive Header Overlapping Option
						impeka_grve_print_admin_option(
							array(
								'type' => 'select',
								'name' => '_impeka_grve_responsive_header_overlapping',
								'id' => '_impeka_grve_responsive_header_overlapping',
								'value' => $responsive_header_overlapping,
								'options' => array(
									'' => esc_html__( '-- Inherit --', 'impeka' ),
									'yes' => esc_html__( 'Yes', 'impeka' ),
									'no' => esc_html__( 'No', 'impeka' ),
								),
								'label' => array(
									"title" => esc_html__( 'Responsive Header Overlapping', 'impeka' ),
									"desc" => esc_html__( 'Select if you want to overlap your responsive header', 'impeka' ),
									"info" => esc_html__( 'Inherit : Theme Options - Header Options - Responsive Header Options.', 'impeka' ),
								),
							)
						);
					?>
				</div>
				<div id="grve-page-option-tab-title" class="grve-tab-item">
					<?php

						echo '<div id="_impeka_grve_page_title">';

						impeka_grve_print_admin_option(
							array(
								'type' => 'select',
								'name' => '_impeka_grve_disable_title',
								'id' => '_impeka_grve_disable_title',
								'value' => $disable_title,
								'options' => array(
									'' => esc_html__( 'Visible', 'impeka' ),
									'yes' => esc_html__( 'Hidden', 'impeka' ),

								),
								'label' => array(
									"title" => esc_html__( 'Title/Description Visibility', 'impeka' ),
									"desc" => esc_html__( 'Select if you want to hide your title and description .', 'impeka' ),
								),
								'group_id' => '_impeka_grve_page_title',
							)
						);
						if( 'tribe_events' != $post_type ) {
							//Description Option
							impeka_grve_print_admin_option(
								array(
									'type' => 'textarea',
									'name' => '_impeka_grve_title',
									'id' => '_impeka_grve_title',
									'value' => $title,
									'label' => array(
										'title' => esc_html__( 'Alternative Title', 'impeka' ),
										'desc' => esc_html__( 'Enter an alternative title ( leave empty for the default title ).', 'impeka' ),
									),
									'width' => 'fullwidth',
									'rows' => 2,
								)
							);
							impeka_grve_print_admin_option(
								array(
									'type' => 'textarea',
									'name' => '_impeka_grve_description',
									'id' => '_impeka_grve_description',
									'value' => $description,
									'label' => array(
										'title' => esc_html__( 'Description', 'impeka' ),
										'desc' => $desc_info,
									),
									'width' => 'fullwidth',
									'rows' => 2,
								)
							);
						}

						//Custom Title Option

						impeka_grve_print_admin_option(
							array(
								'type' => 'select',
								'name' => '_impeka_grve_page_title_custom',
								'id' => '_impeka_grve_page_title_custom',
								'value' => impeka_grve_array_value( $custom_title_options, 'custom' ),
								'options' => $page_title_selection,
								'label' => array(
									"title" => esc_html__( 'Title Options', 'impeka' ),
									"info" => $theme_options_info,
								),
								'group_id' => '_impeka_grve_page_title',
								'highlight' => 'highlight',
								'dependency' =>
								'[
									{ "id" : "_impeka_grve_disable_title", "values" : [""] }
								]',
							)
						);

						impeka_grve_print_admin_option(
							array(
								'type' => 'select',
								'options' => $area_height,
								'name' => '_impeka_grve_page_title_height',
								'id' => '_impeka_grve_page_title_height',
								'value' => impeka_grve_array_value( $custom_title_options, 'height', '40' ),
								'label' => array(
									"title" => esc_html__( 'Title Area Height', 'impeka' ),
								),
								'dependency' =>
								'[
									{ "id" : "_impeka_grve_page_title_custom", "values" : ["custom"] },
									{ "id" : "_impeka_grve_disable_title", "values" : [""] }
								]',
							)
						);
						impeka_grve_print_admin_option(
							array(
								'type' => 'textfield',
								'name' => '_impeka_grve_page_title_min_height',
								'id' => '_impeka_grve_page_title_min_height',
								'value' => impeka_grve_array_value( $custom_title_options, 'min_height', '200' ),
								'label' => array(
									"title" => esc_html__( 'Title Area Minimum Height in px', 'impeka' ),
								),
								'dependency' =>
								'[
									{ "id" : "_impeka_grve_page_title_custom", "values" : ["custom"] },
									{ "id" : "_impeka_grve_disable_title", "values" : [""] }
								]',
							)
						);

						impeka_grve_print_admin_option(
							array(
								'type' => 'select',
								'name' => '_impeka_grve_page_title_container_size',
								'id' => '_impeka_grve_page_title_container_size',
								'options' => array(
									'' => esc_html__( 'Default', 'impeka' ),
									'large' => esc_html__( 'Large', 'impeka' ),
								),
								'value' => impeka_grve_array_value( $custom_title_options, 'container_size' ),
								'label' => array(
									"title" => esc_html__( 'Container Size', 'impeka' ),
								),
								'dependency' =>
								'[
									{ "id" : "_impeka_grve_page_title_custom", "values" : ["custom"] },
									{ "id" : "_impeka_grve_disable_title", "values" : [""] }
								]',
							)
						);

						impeka_grve_print_admin_option(
							array(
								'type' => 'select-colorpicker',
								'name' => '_impeka_grve_page_title_bg_color',
								'id' => '_impeka_grve_page_title_bg_color',
								'value' => impeka_grve_array_value( $custom_title_options, 'bg_color', 'black' ),
								'value2' => impeka_grve_array_value( $custom_title_options, 'bg_color_custom', '#000000' ),
								'default_value2' => '#000000',
								'label' => array(
									"title" => esc_html__( 'Background Color', 'impeka' ),
								),
								'dependency' =>
								'[
									{ "id" : "_impeka_grve_page_title_custom", "values" : ["custom"] },
									{ "id" : "_impeka_grve_disable_title", "values" : [""] }
								]',
								'multiple' => 'multi',
								'type_usage' => 'section-bg',
							)
						);

						impeka_grve_print_admin_option(
							array(
								'type' => 'select-colorpicker',
								'name' => '_impeka_grve_page_title_content_bg_color',
								'id' => '_impeka_grve_page_title_content_bg_color',
								'value' => impeka_grve_array_value( $custom_title_options, 'content_bg_color', 'none' ),
								'value2' => impeka_grve_array_value( $custom_title_options, 'content_bg_color_custom', '#ffffff' ),
								'default_value2' => '#ffffff',
								'label' => array(
									"title" => esc_html__( 'Content Background Color', 'impeka' ),
								),
								'dependency' =>
								'[
									{ "id" : "_impeka_grve_page_title_custom", "values" : ["custom"] },
									{ "id" : "_impeka_grve_disable_title", "values" : [""] }
								]',
								'multiple' => 'multi',
								'type_usage' => 'title-content-bg',
							)
						);

						if( 'post' == $post_type ) {
							impeka_grve_print_admin_option(
								array(
									'type' => 'select-colorpicker',
									'name' => '_impeka_grve_page_title_subheading_color',
									'id' => '_impeka_grve_page_title_subheading_color',
									'value' => impeka_grve_array_value( $custom_title_options, 'subheading_color', 'white' ),
									'value2' => impeka_grve_array_value( $custom_title_options, 'subheading_color_custom', '#ffffff' ),
									'default_value2' => '#ffffff',
									'label' => array(
										"title" => esc_html__( 'Categories/Meta Color', 'impeka' ),
									),
									'dependency' =>
									'[
										{ "id" : "_impeka_grve_page_title_custom", "values" : ["custom"] },
										{ "id" : "_impeka_grve_disable_title", "values" : [""] }
									]',
									'multiple' => 'multi',
								)
							);
						}

						impeka_grve_print_admin_option(
							array(
								'type' => 'select-colorpicker',
								'name' => '_impeka_grve_page_title_title_color',
								'id' => '_impeka_grve_page_title_title_color',
								'value' => impeka_grve_array_value( $custom_title_options, 'title_color', 'white' ),
								'value2' => impeka_grve_array_value( $custom_title_options, 'title_color_custom', '#ffffff' ),
								'default_value2' => '#ffffff',
								'label' => array(
									"title" => esc_html__( 'Title Color', 'impeka' ),
								),
								'dependency' =>
								'[
									{ "id" : "_impeka_grve_page_title_custom", "values" : ["custom"] },
									{ "id" : "_impeka_grve_disable_title", "values" : [""] }
								]',
								'multiple' => 'multi',
							)
						);

						impeka_grve_print_admin_option(
							array(
								'type' => 'select-colorpicker',
								'name' => '_impeka_grve_page_title_caption_color',
								'id' => '_impeka_grve_page_title_caption_color',
								'value' => impeka_grve_array_value( $custom_title_options, 'caption_color', 'white' ),
								'value2' => impeka_grve_array_value( $custom_title_options, 'caption_color_custom', '#ffffff' ),
								'default_value2' => '#ffffff',
								'label' => array(
									"title" => esc_html__( 'Description Color', 'impeka' ),
								),
								'dependency' =>
								'[
									{ "id" : "_impeka_grve_page_title_custom", "values" : ["custom"] },
									{ "id" : "_impeka_grve_disable_title", "values" : [""] }
								]',
								'multiple' => 'multi',
							)
						);

						impeka_grve_print_admin_option(
							array(
								'type' => 'select',
								'name' => '_impeka_grve_page_title_content_size',
								'id' => '_impeka_grve_page_title_content_size',
								'value' => impeka_grve_array_value( $custom_title_options, 'content_size', 'container' ),
								'options' => array(
									'container' => esc_html__( 'Container Size', 'impeka' ),
									'large' => esc_html__( 'Large', 'impeka' ),
									'medium' => esc_html__( 'Medium', 'impeka' ),
									'small' => esc_html__( 'Small', 'impeka' ),
								),
								'label' => esc_html__( 'Content Size', 'impeka' ),
								'dependency' =>
								'[
									{ "id" : "_impeka_grve_page_title_custom", "values" : ["custom"] },
									{ "id" : "_impeka_grve_disable_title", "values" : [""] }
								]',
							)
						);

						impeka_grve_print_admin_option(
							array(
								'type' => 'select-align',
								'name' => '_impeka_grve_page_title_content_alignment',
								'id' => '_impeka_grve_page_title_content_alignment',
								'value' => impeka_grve_array_value( $custom_title_options, 'content_alignment', 'center' ),
								'label' => esc_html__( 'Content Alignment', 'impeka' ),
								'dependency' =>
								'[
									{ "id" : "_impeka_grve_page_title_custom", "values" : ["custom"] },
									{ "id" : "_impeka_grve_disable_title", "values" : [""] }
								]',
							)
						);

						impeka_grve_print_admin_option(
							array(
								'type' => 'select',
								'name' => '_impeka_grve_page_title_content_position',
								'id' => '_impeka_grve_page_title_content_position',
								'value' => impeka_grve_array_value( $custom_title_options, 'content_position', 'center-center' ),
								'options' => $bg_position_selection,
								'label' => array(
									"title" => esc_html__( 'Content Position', 'impeka' ),
								),
								'dependency' =>
								'[
									{ "id" : "_impeka_grve_page_title_custom", "values" : ["custom"] },
									{ "id" : "_impeka_grve_disable_title", "values" : [""] }
								]',
							)
						);

						impeka_grve_print_admin_option(
							array(
								'type' => 'select-text-animation',
								'name' => '_impeka_grve_page_title_content_animation',
								'value' => impeka_grve_array_value( $custom_title_options, 'content_animation', 'none' ),
								'label' => esc_html__( 'Content Animation', 'impeka' ),
								'dependency' =>
								'[
									{ "id" : "_impeka_grve_page_title_custom", "values" : ["custom"] },
									{ "id" : "_impeka_grve_disable_title", "values" : [""] }
								]',
							)
						);


						impeka_grve_print_admin_option(
							array(
								'type' => 'select',
								'name' => '_impeka_grve_page_title_bg_mode',
								'id' => '_impeka_grve_page_title_bg_mode',
								'value' => impeka_grve_array_value( $custom_title_options, 'bg_mode'),
								'options' => array(
									'' => esc_html__( 'Color Only', 'impeka' ),
									'featured' => esc_html__( 'Featured Image', 'impeka' ),
									'custom' => esc_html__( 'Custom Image', 'impeka' ),

								),
								'label' => array(
									"title" => esc_html__( 'Background Mode', 'impeka' ),
								),
								'group_id' => '_impeka_grve_page_title',
								'dependency' =>
								'[
									{ "id" : "_impeka_grve_page_title_custom", "values" : ["custom"] },
									{ "id" : "_impeka_grve_disable_title", "values" : [""] }

								]',
							)
						);
						impeka_grve_print_admin_option(
							array(
								'type' => 'select-image',
								'name' => '_impeka_grve_page_title_bg_image_id',
								'id' => '_impeka_grve_page_title_bg_image_id',
								'value' => impeka_grve_array_value( $custom_title_options, 'bg_image_id'),
								'label' => array(
									"title" => esc_html__( 'Background Image', 'impeka' ),
								),
								'width' => 'fullwidth',
								'dependency' =>
								'[
									{ "id" : "_impeka_grve_page_title_custom", "values" : ["custom"] },
									{ "id" : "_impeka_grve_page_title_bg_mode", "values" : ["custom"] },
									{ "id" : "_impeka_grve_disable_title", "values" : [""] }

								]',
							)
						);
						impeka_grve_print_admin_option(
							array(
								'type' => 'select-bg-position',
								'name' => '_impeka_grve_page_title_bg_position',
								'id' => '_impeka_grve_page_title_bg_position',
								'value' => impeka_grve_array_value( $custom_title_options, 'bg_position', 'center-center'),
								'label' => array(
									"title" => esc_html__( 'Background Position', 'impeka' ),
								),
								'dependency' =>
								'[
									{ "id" : "_impeka_grve_page_title_custom", "values" : ["custom"] },
									{ "id" : "_impeka_grve_page_title_bg_mode", "values" : ["featured","custom"] },
									{ "id" : "_impeka_grve_disable_title", "values" : [""] }
								]',
							)
						);

						impeka_grve_print_admin_option(
							array(
								'type' => 'select-pattern-overlay',
								'name' => '_impeka_grve_page_title_pattern_overlay',
								'value' => impeka_grve_array_value( $custom_title_options, 'pattern_overlay'),
								'label' => esc_html__( 'Pattern Overlay', 'impeka' ),
								'dependency' =>
								'[
									{ "id" : "_impeka_grve_page_title_custom", "values" : ["custom"] },
									{ "id" : "_impeka_grve_page_title_bg_mode", "values" : ["featured","custom"] },
									{ "id" : "_impeka_grve_disable_title", "values" : [""] }
								]',
							)
						);
						impeka_grve_print_admin_option(
							array(
								'type' => 'select-colorpicker',
								'name' => '_impeka_grve_page_title_color_overlay',
								'value' => impeka_grve_array_value( $custom_title_options, 'color_overlay', 'black' ),
								'value2' => impeka_grve_array_value( $custom_title_options, 'color_overlay_custom', '#000000' ),
								'default_value2' => '#000000',
								'label' => esc_html__( 'Color Overlay', 'impeka' ),
								'multiple' => 'multi',
								'dependency' =>
								'[
									{ "id" : "_impeka_grve_page_title_custom", "values" : ["custom"] },
									{ "id" : "_impeka_grve_page_title_bg_mode", "values" : ["featured","custom"] },
									{ "id" : "_impeka_grve_disable_title", "values" : [""] }
								]',
							)
						);
						impeka_grve_print_admin_option(
							array(
								'type' => 'select-opacity',
								'name' => '_impeka_grve_page_title_opacity_overlay',
								'value' => impeka_grve_array_value( $custom_title_options, 'opacity_overlay', '0' ),
								'label' => esc_html__( 'Opacity Overlay', 'impeka' ),
								'dependency' =>
								'[
									{ "id" : "_impeka_grve_page_title_custom", "values" : ["custom"] },
									{ "id" : "_impeka_grve_page_title_bg_mode", "values" : ["featured","custom"] },
									{ "id" : "_impeka_grve_disable_title", "values" : [""] }
								]',
							)
						);

						echo '</div>';
					?>
				</div>

				<?php if( 'product' == $post_type ) { ?>
				<div id="grve-page-option-tab-section-area" class="grve-tab-item">
					<?php

						echo '<div id="_impeka_grve_page_section_area">';

						impeka_grve_print_admin_option(
							array(
								'type' => 'select',
								'name' => '_impeka_grve_area_padding_top_multiplier',
								'id' => '_impeka_grve_area_padding_top_multiplier',
								'value' => $area_padding_top_multiplier,
								'options' => $page_padding_selection,
								'label' => array(
									'title' => esc_html__( 'Top Padding', 'impeka' ),
									'desc' => esc_html__( "Select the space above the area.", 'impeka' ),
									"info" => $theme_options_info,
								),
							)
						);
						impeka_grve_print_admin_option(
							array(
								'type' => 'select',
								'name' => '_impeka_grve_area_padding_bottom_multiplier',
								'id' => '_impeka_grve_area_padding_bottom_multiplier',
								'value' => $area_padding_bottom_multiplier,
								'options' => $page_padding_selection,
								'label' => array(
									'title' => esc_html__( 'Bottom Padding', 'impeka' ),
									'desc' => esc_html__( "Select the space below the area.", 'impeka' ),
									"info" => $theme_options_info,
								),
							)
						);

						//Custom colors

						impeka_grve_print_admin_option(
							array(
								'type' => 'select',
								'name' => '_impeka_grve_area_colors_custom',
								'id' => '_impeka_grve_area_colors_custom',
								'value' => impeka_grve_array_value( $area_colors, 'custom' ),
								'options' => array(
									'' => esc_html__( '-- Inherit --', 'impeka' ),
									'custom' => esc_html__( 'Custom', 'impeka' ),
								),
								'label' => array(
									"title" => esc_html__( 'Area Color Options', 'impeka' ),
									"info" => $area_colors_info,
								),
								'group_id' => '_impeka_grve_page_section_area',
								'highlight' => 'highlight',
							)
						);

						impeka_grve_print_admin_option(
							array(
								'type' => 'colorpicker',
								'name' => '_impeka_grve_area_bg_color',
								'id' => '_impeka_grve_area_bg_color',
								'value' => impeka_grve_array_value( $area_colors, 'bg_color', '#eeeeee' ),
								'default_value' => '#eeeeee',
								'label' => array(
									"title" => esc_html__( 'Background Color', 'impeka' ),
								),
								'dependency' =>
								'[
									{ "id" : "_impeka_grve_area_colors_custom", "values" : ["custom"] }
								]',
							)
						);
						impeka_grve_print_admin_option(
							array(
								'type' => 'colorpicker',
								'name' => '_impeka_grve_area_headings_color',
								'id' => '_impeka_grve_area_headings_color',
								'value' => impeka_grve_array_value( $area_colors, 'headings_color', '#000000' ),
								'default_value' => '#000000',
								'label' => array(
									"title" => esc_html__( 'Headings Color', 'impeka' ),
								),
								'dependency' =>
								'[
									{ "id" : "_impeka_grve_area_colors_custom", "values" : ["custom"] }
								]',
							)
						);
						impeka_grve_print_admin_option(
							array(
								'type' => 'colorpicker',
								'name' => '_impeka_grve_area_font_color',
								'id' => '_impeka_grve_area_font_color',
								'value' => impeka_grve_array_value( $area_colors, 'font_color', '#999999' ),
								'default_value' => '#999999',
								'label' => array(
									"title" => esc_html__( 'Font Color', 'impeka' ),
								),
								'dependency' =>
								'[
									{ "id" : "_impeka_grve_area_colors_custom", "values" : ["custom"] }
								]',
							)
						);
						impeka_grve_print_admin_option(
							array(
								'type' => 'colorpicker',
								'name' => '_impeka_grve_area_link_color',
								'id' => '_impeka_grve_area_link_color',
								'value' => impeka_grve_array_value( $area_colors, 'link_color', '#FF7D88' ),
								'default_value' => '#FF7D88',
								'label' => array(
									"title" => esc_html__( 'Link Color', 'impeka' ),
								),
								'dependency' =>
								'[
									{ "id" : "_impeka_grve_area_colors_custom", "values" : ["custom"] }
								]',
							)
						);
						impeka_grve_print_admin_option(
							array(
								'type' => 'colorpicker',
								'name' => '_impeka_grve_area_hover_color',
								'id' => '_impeka_grve_area_hover_color',
								'value' => impeka_grve_array_value( $area_colors, 'hover_color', '#000000' ),
								'default_value' => '#000000',
								'label' => array(
									"title" => esc_html__( 'Hover Color', 'impeka' ),
								),
								'dependency' =>
								'[
									{ "id" : "_impeka_grve_area_colors_custom", "values" : ["custom"] }
								]',
							)
						);
						impeka_grve_print_admin_option(
							array(
								'type' => 'colorpicker',
								'name' => '_impeka_grve_area_border_color',
								'id' => '_impeka_grve_area_border_color',
								'value' => impeka_grve_array_value( $area_colors, 'border_color', '#e0e0e0' ),
								'default_value' => '#e0e0e0',
								'label' => array(
									"title" => esc_html__( 'Border Color', 'impeka' ),
								),
								'dependency' =>
								'[
									{ "id" : "_impeka_grve_area_colors_custom", "values" : ["custom"] }
								]',
							)
						);
						impeka_grve_print_admin_option(
							array(
								'type' => 'select',
								'name' => '_impeka_grve_area_button_color',
								'id' => '_impeka_grve_area_button_color',
								'value' => impeka_grve_array_value( $area_colors, 'button_color', 'primary-1' ),
								'options' => $color_selection,
								'label' => array(
									"title" => esc_html__( 'Button Color', 'impeka' ),
								),
								'dependency' =>
								'[
									{ "id" : "_impeka_grve_area_colors_custom", "values" : ["custom"] }
								]',
							)
						);
						impeka_grve_print_admin_option(
							array(
								'type' => 'select',
								'name' => '_impeka_grve_button_hover_color',
								'id' => '_impeka_grve_button_hover_color',
								'value' => impeka_grve_array_value( $area_colors, 'button_hover_color', 'black' ),
								'options' => $color_selection,
								'label' => array(
									"title" => esc_html__( 'Button HoverColor', 'impeka' ),
								),
								'dependency' =>
								'[
									{ "id" : "_impeka_grve_area_colors_custom", "values" : ["custom"] }
								]',
							)
						);

						echo '</div>';
					?>
				</div>
				<?php } ?>


				<?php if( 'portfolio' == $post_type || 'post' == $post_type || 'product' == $post_type ) { ?>
				<div id="grve-page-option-tab-quick-view" class="grve-tab-item">
				<?php
					echo '<div id="_impeka_grve_quickview_options">';
					impeka_grve_print_admin_option(
						array(
							'type' => 'textfield',
							'name' => '_impeka_grve_quickview_title',
							'id' => '_impeka_grve_quickview_title',
							'value' => $quickview_title,
							'label' => array(
								'title' => esc_html__( 'Quick View Title', 'impeka' ),
								'desc' => esc_html__( 'Enter your quick view title.', 'impeka' ),
								'info' => esc_html__('If empty, post title will be shown.', 'impeka' ),
							),
							'width' => 'fullwidth',
						)
					);
					if( 'portfolio' == $post_type ) {
						$quickview_text_info = esc_html__('If empty text will be inherited from details text otherwise post excerpt will be shown if set.', 'impeka' );
					} elseif( 'product' == $post_type ) {
						$quickview_text_info = esc_html__('If empty, manual post excerpt will be shown if set.', 'impeka' );
					} else {
						$quickview_text_info = esc_html__('If empty, manual post excerpt will be shown if set.', 'impeka' );
					}

					impeka_grve_print_admin_option(
						array(
							'type' => 'textarea',
							'name' => '_impeka_grve_quickview_text',
							'id' => '_impeka_grve_details',
							'value' => $quickview_text,
							'label' => array(
								'title' => esc_html__( 'Quick View Text', 'impeka' ),
								'desc' => esc_html__( 'Enter your quick view text.', 'impeka' ),
								'info' => $quickview_text_info,
							),
							'width' => 'fullwidth',
						)
					);

					impeka_grve_print_admin_option(
						array(
							'type' => 'textfield',
							'name' => '_impeka_grve_quickview_link_text',
							'id' => '_impeka_grve_quickview_link_text',
							'value' => $quickview_link_text,
							'label' => array(
								'title' => esc_html__( 'Quick View Link Text', 'impeka' ),
								'desc' => esc_html__( 'Enter your quick view link text.', 'impeka' ),
								"info" => $theme_options_info,
							),
							'width' => 'fullwidth',
						)
					);
					echo '</div>';

				?>
				</div>
				<?php } ?>



				<?php if( 'portfolio' == $post_type ) { ?>
				<div id="grve-page-option-tab-details-area" class="grve-tab-item">
				<?php

					echo '<div id="_impeka_grve_details_area_options">';

					impeka_grve_print_admin_option(
						array(
							'type' => 'select',
							'name' => '_impeka_grve_details_mode',
							'id' => '_impeka_grve_details_mode',
							'value' => $details_mode,
							'options' => array(
								'' => esc_html__( '-- Inherit --', 'impeka' ),
								'no' => esc_html__( 'No' , 'impeka' ),
								'yes' => esc_html__( 'Yes' , 'impeka' ),
							),
							'label' => array(
								"title" => esc_html__( 'Details Area', 'impeka' ),
								"info" => esc_html__( 'Inherit : Theme Options - Portfolio Options - Single Portfolio Settings.', 'impeka' ),
							),
							'group_id' => '_impeka_grve_details_area_options',
							'highlight' => 'highlight',
						)
					);
					impeka_grve_print_admin_option(
						array(
							'type' => 'textfield',
							'name' => '_impeka_grve_details_title',
							'id' => '_impeka_grve_details_title',
							'value' => $details_title,
							'label' => array(
								'title' => esc_html__( 'Details Title', 'impeka' ),
								'desc' => esc_html__( 'Enter your details title.', 'impeka' ),
								'info' => $theme_options_info_text_empty,
							),
							'width' => 'fullwidth',
							'dependency' =>
							'[
								{ "id" : "_impeka_grve_details_mode", "value_not_equal_to" : ["no"] }
							]',
						)
					);
					impeka_grve_print_admin_option(
						array(
							'type' => 'textarea',
							'name' => '_impeka_grve_details',
							'id' => '_impeka_grve_details',
							'value' => $details,
							'label' => array(
								'title' => esc_html__( 'Details Area', 'impeka' ),
								'desc' => esc_html__( 'Enter your details area.', 'impeka' ),
							),
							'width' => 'fullwidth',
							'dependency' =>
							'[
								{ "id" : "_impeka_grve_details_mode", "value_not_equal_to" : ["no"] }
							]',
						)
					);

					impeka_grve_print_admin_option(
						array(
							'type' => 'textfield',
							'name' => '_impeka_grve_details_link_text',
							'id' => '_impeka_grve_details_link_text',
							'value' => $details_link_text,
							'label' => array(
								'title' => esc_html__( 'Link Text', 'impeka' ),
								'desc' => esc_html__( 'Enter your details link text.', 'impeka' ),
								'info' => $theme_options_info_text_empty,
							),
							'width' => 'fullwidth',
							'dependency' =>
							'[
								{ "id" : "_impeka_grve_details_mode", "value_not_equal_to" : ["no"] }
							]',
						)
					);
					impeka_grve_print_admin_option(
						array(
							'type' => 'textfield',
							'name' => '_impeka_grve_details_link_url',
							'value' => $details_link_url,
							'label' => array(
								'title' => esc_html__( 'Link URL', 'impeka' ),
								'desc' => esc_html__( 'Enter the full URL of your link.', 'impeka' ),
							),
							'width' => 'fullwidth',
							'dependency' =>
							'[
								{ "id" : "_impeka_grve_details_mode", "value_not_equal_to" : ["no"] }
							]',
						)
					);
					impeka_grve_print_admin_option(
						array(
							'type' => 'checkbox',
							'name' => '_impeka_grve_details_link_new_window',
							'value' => $details_link_new_window,
							'label' => array(
								'title' => esc_html__( 'Open Link in new window', 'impeka' ),
								'desc' => esc_html__( 'If selected, link will open in a new window.', 'impeka' ),
							),
							'dependency' =>
							'[
								{ "id" : "_impeka_grve_details_mode", "value_not_equal_to" : ["no"] }
							]',
						)
					);
					impeka_grve_print_admin_option(
						array(
							'type' => 'textfield',
							'name' => '_impeka_grve_details_link_extra_class',
							'value' => $details_link_extra_class,
							'label' => array(
								'title' => esc_html__( 'Link extra class name', 'impeka' ),
							),
							'dependency' =>
							'[
								{ "id" : "_impeka_grve_details_mode", "value_not_equal_to" : ["no"] }
							]',
						)
					);
					echo '</div>';
				?>
				</div>
				<?php } ?>
				<div id="grve-page-option-tab-layout" class="grve-tab-item">
					<?php

						echo '<div id="_impeka_grve_page_padding">';

						impeka_grve_print_admin_option(
							array(
								'type' => 'select',
								'name' => '_impeka_grve_padding_top_multiplier',
								'id' => '_impeka_grve_padding_top_multiplier',
								'value' => $padding_top_multiplier,
								'options' => $page_padding_selection_extra,
								'label' => array(
									'title' => esc_html__( 'Top Padding', 'impeka' ),
									'desc' => esc_html__( "Select the space above the content area.", 'impeka' ),
									"info" => $theme_options_info,
								),
								'group_id' => '_impeka_grve_page_padding',
							)
						);
						impeka_grve_print_admin_option(
							array(
								'type' => 'textfield',
								'name' => '_impeka_grve_padding_top',
								'id' => '_impeka_grve_padding_top',
								'value' => $padding_top,
								'label' => array(
									'title' => esc_html__( 'Custom Top Padding', 'impeka' ),
									'desc' => esc_html__( "You can use px, em, %, etc. or enter just number and it will use pixels.", 'impeka' ),
								),
								'dependency' =>
								'[
									{ "id" : "_impeka_grve_padding_top_multiplier", "values" : ["custom"] }
								]',
							)
						);
						impeka_grve_print_admin_option(
							array(
								'type' => 'select',
								'name' => '_impeka_grve_padding_bottom_multiplier',
								'id' => '_impeka_grve_padding_bottom_multiplier',
								'value' => $padding_bottom_multiplier,
								'options' => $page_padding_selection_extra,
								'label' => array(
									'title' => esc_html__( 'Bottom Padding', 'impeka' ),
									'desc' => esc_html__( "Select the space below the content area.", 'impeka' ),
									"info" => $theme_options_info,
								),
								'group_id' => '_impeka_grve_page_padding',
							)
						);
						impeka_grve_print_admin_option(
							array(
								'type' => 'textfield',
								'name' => '_impeka_grve_padding_bottom',
								'id' => '_impeka_grve_padding_bottom',
								'value' => $padding_bottom,
								'label' => array(
									'title' => esc_html__( 'Custom Bottom Padding', 'impeka' ),
									'desc' => esc_html__( "You can use px, em, %, etc. or enter just number and it will use pixels.", 'impeka' ),
								),
								'dependency' =>
								'[
									{ "id" : "_impeka_grve_padding_bottom_multiplier", "values" : ["custom"] }
								]',
							)
						);

						echo '</div>';


						//Layout Option
						impeka_grve_print_admin_option(
							array(
								'type' => 'select',
								'name' => '_impeka_grve_layout',
								'id' => '_impeka_grve_layout',
								'value' => $layout,
								'options' => array(
									'' => esc_html__( '-- Inherit --', 'impeka' ),
									'none' => esc_html__( 'Full Width', 'impeka' ),
									'left' => esc_html__( 'Left Sidebar', 'impeka' ),
									'right' => esc_html__( 'Right Sidebar', 'impeka' ),
								),
								'label' => array(
									"title" => esc_html__( 'Layout', 'impeka' ),
									"desc" => esc_html__( 'Select page content and sidebar alignment.', 'impeka' ),
									"info" => $theme_options_info,
								),
							)
						);

						//Sidebar Option
						impeka_grve_print_admin_option_wrapper_start(
							array(
								'type' => 'select',
								'label' => array(
									"title" => esc_html__( 'Sidebar', 'impeka' ),
									"desc" => esc_html__( 'Select page sidebar.', 'impeka' ),
									"info" => $theme_options_info,
								),
							)
						);
						impeka_grve_print_sidebar_selection( $sidebar, '_impeka_grve_sidebar', '_impeka_grve_sidebar' );
						impeka_grve_print_admin_option_wrapper_end();

						//Fixed Sidebar Option
						impeka_grve_print_admin_option(
							array(
								'type' => 'select',
								'name' => '_impeka_grve_fixed_sidebar',
								'id' => '_impeka_grve_fixed_sidebar',
								'value' => $fixed_sidebar,
								'options' => array(
									'' => esc_html__( '-- Inherit --', 'impeka' ),
									'no' => esc_html__( 'No', 'impeka' ),
									'yes' => esc_html__( 'Yes', 'impeka' ),
								),
								'label' => array(
									"title" => esc_html__( 'Fixed Sidebar', 'impeka' ),
									"desc" => esc_html__( 'If selected, sidebar will be fixed.', 'impeka' ),
								),
							)
						);



						//Posts Content Width
						if ( 'post' == $post_type || 'product' == $post_type || 'tribe_events' == $post_type  ) {

							impeka_grve_print_admin_option(
								array(
									'type' => 'select',
									'name' => '_impeka_grve_post_content_width',
									'id' => '_impeka_grve_post_content_width',
									'value' => $post_content_width,
									'options' => array(
										'' => esc_html__( '-- Inherit --', 'impeka' ),
										'container' => esc_html__( 'Container Size' , 'impeka' ),
										'large' => esc_html__( 'Large' , 'impeka' ),
										'medium' => esc_html__( 'Medium' , 'impeka' ),
										'small' => esc_html__( 'Small' , 'impeka' ),
									),
									'label' => array(
										"title" => esc_html__( 'Content Width', 'impeka' ),
										"desc" => esc_html__( 'Select the Content Width (only for Full Width Layout)', 'impeka' ),
										"info" => $theme_options_info,
									),
								)
							);
						}

						//Background Options
						echo '<div id="_impeka_grve_content_skin_options">';

						impeka_grve_print_admin_option(
							array(
								'type' => 'select',
								'name' => '_impeka_grve_content_skin',
								'id' => '_impeka_grve_content_skin',
								'value' => impeka_grve_array_value( $content_skin_options, 'skin' ),
								'options' => array(
									'' => esc_html__( '-- Inherit --', 'impeka' ),
									'dark' => esc_html__( 'Dark' , 'impeka' ),
									'light' => esc_html__( 'Light' , 'impeka' ),
									'custom' => esc_html__( 'Custom', 'impeka' ),
								),
								'label' => array(
									"title" => esc_html__( 'Content Skin', 'impeka' ),
									"info" => esc_html__( 'Inherit :Background from Theme Options - General Settings, Colors from Appearance > Customize > Colors - Main Content.', 'impeka' ),
								),
								'group_id' => '_impeka_grve_content_skin_options',
								'highlight' => 'highlight',
							)
						);

						impeka_grve_print_admin_option(
							array(
								'type' => 'colorpicker',
								'name' => '_impeka_grve_content_text_color',
								'id' => '_impeka_grve_content_text_color',
								'value' => impeka_grve_array_value( $content_skin_options, 'text_color', "#000000" ),
								'label' => array(
									"title" => esc_html__( 'Color', 'impeka' ),
								),
								'default_value' => '#000000',
								'dependency' =>
								'[
									{ "id" : "_impeka_grve_content_skin", "values" : ["custom"] }
								]',
							)
						);
						impeka_grve_print_admin_option(
							array(
								'type' => 'colorpicker',
								'name' => '_impeka_grve_content_heading_color',
								'id' => '_impeka_grve_content_heading_color',
								'value' => impeka_grve_array_value( $content_skin_options, 'heading_color','#000000' ),
								'label' => array(
									"title" => esc_html__( 'Heading Color', 'impeka' ),
								),
								'default_value' => '#000000',
								'dependency' =>
								'[
									{ "id" : "_impeka_grve_content_skin", "values" : ["custom"] }
								]',
							)
						);

						impeka_grve_print_admin_option(
							array(
								'type' => 'colorpicker',
								'name' => '_impeka_grve_content_link_color',
								'id' => '_impeka_grve_content_link_color',
								'value' => impeka_grve_array_value( $content_skin_options, 'link_color', "#000000" ),
								'label' => array(
									"title" => esc_html__( 'Link Color', 'impeka' ),
								),
								'default_value' => '#000000',
								'dependency' =>
								'[
									{ "id" : "_impeka_grve_content_skin", "values" : ["custom"] }
								]',
							)
						);

						impeka_grve_print_admin_option(
							array(
								'type' => 'colorpicker',
								'name' => '_impeka_grve_content_link_hover_color',
								'id' => '_impeka_grve_content_link_hover_color',
								'value' => impeka_grve_array_value( $content_skin_options, 'link_hover_color', "#FF4433" ),
								'label' => array(
									"title" => esc_html__( 'Link Hover Color', 'impeka' ),
								),
								'default_value' => '#FF4433',
								'dependency' =>
								'[
									{ "id" : "_impeka_grve_content_skin", "values" : ["custom"] }
								]',
							)
						);

						impeka_grve_print_admin_option(
							array(
								'type' => 'colorpicker',
								'name' => '_impeka_grve_content_bg_color',
								'id' => '_impeka_grve_content_bg_color',
								'value' => impeka_grve_array_value( $content_skin_options, 'background-color', '#fafafa' ),
								'label' => array(
									"title" => esc_html__( 'Background Color', 'impeka' ),
								),
								'default_value' => '#fafafa',
								'dependency' =>
								'[
									{ "id" : "_impeka_grve_content_skin", "values" : ["custom"] }
								]',
							)
						);

						impeka_grve_print_admin_option(
							array(
								'type' => 'select',
								'name' => '_impeka_grve_content_bg_repeat',
								'id' => '_impeka_grve_content_bg_repeat',
								'value' => impeka_grve_array_value( $content_skin_options, 'background-repeat' ),
								'options' => array(
									'' => esc_html__( '-- Not selected --', 'impeka' ),
									'no-repeat' => 'No Repeat',
									'repeat'    => 'Repeat All',
									'repeat-x'  => 'Repeat Horizontally',
									'repeat-y'  => 'Repeat Vertically',
									'inherit'   => 'Inherit',
								),
								'label' => esc_html__( 'Background Repeat', 'impeka' ),
								'dependency' =>
								'[
									{ "id" : "_impeka_grve_content_skin", "values" : ["custom"] }
								]',
							)
						);

						impeka_grve_print_admin_option(
							array(
								'type' => 'select',
								'name' => '_impeka_grve_content_bg_size',
								'id' => '_impeka_grve_content_bg_size',
								'value' => impeka_grve_array_value( $content_skin_options, 'background-size' ),
								'options' => array(
									'' => esc_html__( '-- Not selected --', 'impeka' ),
									'inherit' => 'Inherit',
									'cover'   => 'Cover',
									'contain' => 'Contain',
								),
								'label' => esc_html__( 'Background Size', 'impeka' ),
								'dependency' =>
								'[
									{ "id" : "_impeka_grve_content_skin", "values" : ["custom"] }
								]',
							)
						);

						impeka_grve_print_admin_option(
							array(
								'type' => 'select',
								'name' => '_impeka_grve_content_bg_attachment',
								'id' => '_impeka_grve_content_bg_attachment',
								'value' => impeka_grve_array_value( $content_skin_options, 'background-attachment' ),
								'options' => array(
									'' => esc_html__( '-- Not selected --', 'impeka' ),
									'fixed'   => 'Fixed',
									'scroll'  => 'Scroll',
									'inherit' => 'Inherit',
								),
								'label' => esc_html__( 'Background Attachment', 'impeka' ),
								'dependency' =>
								'[
									{ "id" : "_impeka_grve_content_skin", "values" : ["custom"] }
								]',
							)
						);

						impeka_grve_print_admin_option(
							array(
								'type' => 'select',
								'name' => '_impeka_grve_content_bg_position',
								'id' => '_impeka_grve_content_bg_position',
								'value' => impeka_grve_array_value( $content_skin_options, 'background-position' ),
								'options' => array(
									'' => esc_html__( '-- Not selected --', 'impeka' ),
									'left top'      => 'Left Top',
									'left center'   => 'Left center',
									'left bottom'   => 'Left Bottom',
									'center top'    => 'Center Top',
									'center center' => 'Center Center',
									'center bottom' => 'Center Bottom',
									'right top'     => 'Right Top',
									'right center'  => 'Right center',
									'right bottom'  => 'Right Bottom',
								),
								'label' => esc_html__( 'Background Position', 'impeka' ),
								'dependency' =>
								'[
									{ "id" : "_impeka_grve_content_skin", "values" : ["custom"] }
								]',
							)
						);

						impeka_grve_print_admin_option(
							array(
								'type' => 'select-bg-image',
								'name' => '_impeka_grve_content_bg_image',
								'id' => '_impeka_grve_content_bg_image',
								'value' => impeka_grve_array_value( $content_skin_options, 'background-image' ),
								'label' => esc_html__( 'Background Image', 'impeka' ),
								'width' => 'fullwidth',
								'dependency' =>
								'[
									{ "id" : "_impeka_grve_content_skin", "values" : ["custom"] }
								]',
							)
						);

						echo '</div>';



					?>
				</div>
				<div id="grve-page-option-tab-side-area" class="grve-tab-item">
					<?php
						//Sidearea Visibility
						impeka_grve_print_admin_option(
							array(
								'type' => 'select',
								'name' => '_impeka_grve_sidearea_visibility',
								'id' => '_impeka_grve_sidearea_visibility',
								'value' => $sidearea_visibility,
								'options' => array(
									'' => esc_html__( '-- Inherit --', 'impeka' ),
									'no' => esc_html__( 'No', 'impeka' ),
									'yes' => esc_html__( 'Yes', 'impeka' ),
								),
								'label' => array(
									"title" => esc_html__( 'Side Area Visibility', 'impeka' ),
									"info" => $theme_options_info,
								),
							)
						);

						//Sidearea Sidebar Option
						impeka_grve_print_admin_option_wrapper_start(
							array(
								'type' => 'select',
								'label' => array(
									"title" => esc_html__( 'Side Area Sidebar', 'impeka' ),
									"desc" => esc_html__( 'Select side area sidebar.', 'impeka' ),
									"info" => $theme_options_info,
								),
							)
						);
						impeka_grve_print_sidebar_selection( $sidearea_sidebar, '_impeka_grve_sidearea_sidebar', '_impeka_grve_sidearea_sidebar' );
						impeka_grve_print_admin_option_wrapper_end();
					?>
				</div>
				<div id="grve-page-option-tab-bottom-footer-areas" class="grve-tab-item">
					<?php
						//Bottom / Footer Areas

						impeka_grve_print_admin_option(
							array(
								'type' => 'select',
								'name' => '_impeka_grve_footer_sticky',
								'value' => $footer_sticky,
								'options' => array(
									'' => esc_html__( '-- Inherit --', 'impeka' ),
									'no' => esc_html__( 'No', 'impeka' ),
									'yes' => esc_html__( 'Yes', 'impeka' ),
								),
								'label' => array(
									"title" => esc_html__( 'Sticky Areas', 'impeka' ),
									"desc" => esc_html__( 'If selected, Bottom / Footer Areas will be sticky.', 'impeka' ),
								),
							)
						);

						impeka_grve_print_admin_option_wrapper_start(
							array(
								'type' => 'select',
								'label' => array(
									"title" => esc_html__( 'Bottom Bar Area', 'impeka' ),
									"desc" => esc_html__( 'Select an area item for your Bottom Bar Area.', 'impeka' ),
									"info" => esc_html__( 'Inherit : Theme Options - Bottom / Footer Areas - Bottom Bar Area Item.', 'impeka' ),
								),
							)
						);
						impeka_grve_print_area_selection( $bottom_bar_area, 'grve-bottom-bar-area-item', '_impeka_grve_bottom_bar_area' );
						impeka_grve_print_admin_option_wrapper_end();

						impeka_grve_print_admin_option(
							array(
								'type' => 'select',
								'name' => '_impeka_grve_footer_widgets_visibility',
								'id' => '_impeka_grve_footer_widgets_visibility',
								'value' => $footer_widgets_visibility,
								'options' => array(
									'' => esc_html__( '-- Inherit --', 'impeka' ),
									'no' => esc_html__( 'No', 'impeka' ),
									'yes' => esc_html__( 'Yes', 'impeka' ),
								),
								'label' => array(
									"title" => esc_html__( 'Footer Widgets Visibility', 'impeka' ),
									"desc" => esc_html__( 'Inherit : Theme Options - Bottom / Footer Areas - Footer Widgets Settings.', 'impeka' ),
								),
							)
						);

						impeka_grve_print_admin_option(
							array(
								'type' => 'select',
								'name' => '_impeka_grve_footer_bar_visibility',
								'id' => '_impeka_grve_footer_bar_visibility',
								'value' => $footer_bar_visibility,
								'options' => array(
									'' => esc_html__( '-- Inherit --', 'impeka' ),
									'no' => esc_html__( 'No', 'impeka' ),
									'yes' => esc_html__( 'Yes', 'impeka' ),
								),
								'label' => array(
									"title" => esc_html__( 'Footer Bar Visibility', 'impeka' ),
									"desc" => esc_html__( 'Inherit : Theme Options - Bottom / Footer Areas - Footer Bar Settings.', 'impeka' ),
								),
							)
						);
					?>
				</div>
				<div id="grve-page-option-tab-extras" class="grve-tab-item">
					<?php
						if ( 'portfolio' == $post_type  ) {
							impeka_grve_print_admin_option(
								array(
									'type' => 'select',
									'name' => '_impeka_grve_social_bar_layout',
									'id' => '_impeka_grve_social_bar_layout',
									'value' => $social_bar_layout,
									'options' => array(
										'' => esc_html__( '-- Inherit --', 'impeka' ),
										'layout-1' => esc_html__( 'Bottom Layout', 'impeka' ),
										'layout-2' => esc_html__( 'Side Layout', 'impeka' ),
									),
									'label' => array(
										"title" => esc_html__( 'Social Layout', 'impeka' ),
										"desc" => esc_html__( 'Select your social layout.', 'impeka' ),
										"info" => $theme_options_info,
									),
								)
							);
						}
						if ( 'post' == $post_type || 'portfolio' == $post_type || 'product' == $post_type ) {
							//Backlink page
							impeka_grve_print_admin_option_wrapper_start(
								array(
									'type' => 'select',
									'label' => array(
										"title" => esc_html__( 'Backlink', 'impeka' ),
										"desc" => esc_html__( 'Select your backlink page.', 'impeka' ),
										"info" => $theme_options_info,
									),
								)
							);
							impeka_grve_print_page_selection( $backlink_id, 'grve-backlink-id', '_impeka_grve_backlink_id' );
							impeka_grve_print_admin_option_wrapper_end();
						}

						if ( 'page' == $post_type  ) {
							impeka_grve_print_admin_option_wrapper_start(
								array(
									'type' => 'select',
									'label' => array(
										"title" => esc_html__( 'Navigation Page', 'impeka' ),
										"desc" => esc_html__( 'Select your navigation page.', 'impeka' ),
										"info" => $theme_options_info,
									),
								)
							);
							impeka_grve_print_page_selection( $nav_id, 'grve-nav-id', '_impeka_grve_nav_id' );
							impeka_grve_print_admin_option_wrapper_end();
							impeka_grve_print_admin_option(
								array(
									'type' => 'textfield',
									'name' => '_impeka_grve_nav_text',
									'value' => $nav_text,
									'label' => array(
										'title' => esc_html__( 'Navigation Text', 'impeka' ),
										'desc' => esc_html__( 'Enter your navigation text.', 'impeka' ),
										'info' => $theme_options_info_text_empty,
									),
									'width' => 'fullwidth',
								)
							);
						}

						//Feature Media Yype
						if ( 'post' == $post_type  ) {
							impeka_grve_print_admin_option(
								array(
									'type' => 'select',
									'name' => '_impeka_grve_feature_media_type',
									'value' => $feature_media_type,
									'options' => array(
										'' => esc_html__( '-- Inherit --', 'impeka' ),
										'normal' => esc_html__( "Normal", "impeka" ),
										'wide' => esc_html__( "Wide", "impeka" ),
									),
									'label' => array(
										"title" => esc_html__( 'Feature Media Type', 'impeka' ),
										'desc' => esc_html__( 'Select the feature media type ( not applicable when sidebar is used ).', 'impeka' ),
										"info" => $theme_options_info,
									),
								)
							);
						}

						//Anchor Navigation Menu Option
						impeka_grve_print_admin_option_wrapper_start(
							array(
								'type' => 'select',
								'label' => array(
									"title" => esc_html__( 'Anchor Navigation Menu', 'impeka' ),
									"desc" => esc_html__( 'Select page anchor navigation menu.', 'impeka' ),
								),
							)
						);
						impeka_grve_print_menu_selection( $anchor_navigation_menu, 'grve-page-navigation-menu', '_impeka_grve_anchor_navigation_menu' );
						impeka_grve_print_admin_option_wrapper_end();

						impeka_grve_print_admin_option(
							array(
								'type' => 'select',
								'name' => '_impeka_grve_anchor_device_layout',
								'value' => $anchor_device_layout,
								'options' => array(
									'' => esc_html__( 'Convert to Dropdown', 'impeka' ),
									'none' => esc_html__( 'Same as Desktop', 'impeka' ),
								),
								'label' => array(
									"title" => esc_html__( 'Anchor Responsive Layout', 'impeka' ),
									"desc" => esc_html__( 'Select anchor responsive layout ( on 1024px and below ).', 'impeka' ),
								),
							)
						);
						//Theme Loader
						impeka_grve_print_admin_option(
							array(
								'type' => 'select',
								'name' => '_impeka_grve_theme_loader',
								'id' => '_impeka_grve_theme_loader',
								'value' => $theme_loader,
								'options' => array(
									'' => esc_html__( '-- Inherit --', 'impeka' ),
									'no' => esc_html__( 'No', 'impeka' ),
									'yes' => esc_html__( 'Yes', 'impeka' ),
								),
								'label' => array(
									"title" => esc_html__( 'Theme Loader Visibility', 'impeka' ),
									"info" => esc_html__( 'Inherit : Theme Options - General Settings.', 'impeka' ),
								),
							)
						);

						if ( 'page' == $post_type) {
							impeka_grve_print_admin_option(
								array(
									'type' => 'select',
									'name' => '_impeka_grve_section_nav_hide',
									'id' => '_impeka_grve_section_nav_hide',
									'value' => $section_nav_hide,
									'options' => array(
										'never' => esc_html__( "Always Visible", "impeka" ),
										'tablet' => esc_html__( "Hide on Tablet Landscape and below", "impeka" ),
										'tablet-sm' => esc_html__( "Hide on Tablet Portrait and below", "impeka" ),
										'mobile' => esc_html__( "Hide on Mobile Landscape and below", "impeka" ),
									),
									'label' => array(
										"title" => esc_html__( 'Section Navigation Visibility', 'impeka' ),
										"desc" => esc_html__( 'Select if you want to hide section navigation in some devices.', 'impeka' ),
										"info" => esc_html__( 'Note: This option is available only for Section Navigation and Skin on Scroll Effect Template.', 'impeka' ),
									),
									'width' => 'fullwidth',
								)
							);
						}
					?>
				</div>
				<div id="grve-page-option-tab-scrolling-sections" class="grve-tab-item">
					<?php

						//Responsive Scrolling Option
						if ( 'page' == $post_type) {

							echo '<div id="_impeka_grve_page_scrolling_section">';

							impeka_grve_print_admin_option(
								array(
									'type' => 'label',
									'label' => array(
										'title' => esc_html__( 'Scrolling Sections Options', 'impeka' ),
										'info' => esc_html__( 'Note: The following options are available only for Scrolling Full Screen Sections Template.', 'impeka' ),
									),

								)
							);
							impeka_grve_print_admin_option(
								array(
									'type' => 'select',
									'name' => '_impeka_grve_scrolling_lock_anchors',
									'id' => '_impeka_grve_scrolling_lock_anchors',
									'value' => $scrolling_lock_anchors,
									'options' => array(
										'' => esc_html__( 'URL without /#', 'impeka' ),
										'no' => esc_html__( 'Allow Anchor Links in URL', 'impeka' ),
									),
									'label' => array(
										'title' => esc_html__( 'Anchor Links', 'impeka' ),
										'desc' => esc_html__( 'Select if you want to allow anchor links.', 'impeka' ),
									),
								)
							);
							impeka_grve_print_admin_option(
								array(
									'type' => 'select',
									'name' => '_impeka_grve_scrolling_loop',
									'id' => '_impeka_grve_scrolling_loop',
									'value' => $scrolling_loop,
									'options' => array(
										'' => esc_html__( 'None', 'impeka' ),
										'top' => esc_html__( 'Loop Top', 'impeka' ),
										'bottom' => esc_html__( 'Loop Bottom', 'impeka' ),
										'both' => esc_html__( 'Loop Top/Bottom', 'impeka' ),
									),
									'label' => array(
										'title' => esc_html__( 'Loop', 'impeka' ),
										'desc' => esc_html__( 'Select if you want to loop.', 'impeka' ),
									),
								)
							);
							impeka_grve_print_admin_option(
								array(
									'type' => 'textfield',
									'name' => '_impeka_grve_scrolling_speed',
									'id' => '_impeka_grve_scrolling_speed',
									'value' => $scrolling_speed,
									'label' => array(
										'title' => esc_html__( 'Speed (ms)', 'impeka' ),
										'desc' => esc_html__( 'Enter scrolling speed.', 'impeka' ),
									),
									'default_value' => '1000',

								)
							);
							impeka_grve_print_admin_option(
								array(
									'type' => 'select',
									'name' => '_impeka_grve_responsive_scrolling',
									'id' => '_impeka_grve_responsive_scrolling',
									'value' => $responsive_scrolling,
									'options' => array(
										'' => esc_html__( 'Yes', 'impeka' ),
										'no' => esc_html__( 'No', 'impeka' ),
									),
									'label' => array(
										'title' => esc_html__( 'Responsive Scrolling Full Sections', 'impeka' ),
										'desc' => esc_html__( 'Select if you want to maintain the scrolling feature on devices.', 'impeka' ),
									),
								)
							);

							echo '</div>';
						}

					?>
				</div>
				<div id="grve-page-option-tab-modals" class="grve-tab-item">
					<div>
						<input type="button" id="grve-add-modal-button" class="grve-add-modal-button button-primary" value="<?php esc_attr_e( 'Add modal', 'impeka' ); ?>"/>
						<span id="grve-add-modal-button-spinner" class="grve-action-spinner"></span>
					</div>
					<div id="grve-modal-item-container">
						<?php
							$modal_items = get_post_meta( $post_id, '_impeka_grve_modals', true );
							impeka_grve_print_admin_modal_items( $modal_items );
						?>
					</div>
				</div>
				<div id="grve-page-option-tab-visibility" class="grve-tab-item">
					<?php

						impeka_grve_print_admin_option(
							array(
								'type' => 'checkbox',
								'name' => '_impeka_grve_disable_top_bar',
								'id' => '_impeka_grve_disable_top_bar',
								'value' => $disable_top_bar,
								'label' => array(
									"title" => esc_html__( 'Disable Top Bar', 'impeka' ),
									"desc" => esc_html__( 'If selected, top bar will be hidden.', 'impeka' ),
								),
							)
						);

						impeka_grve_print_admin_option(
							array(
								'type' => 'checkbox',
								'name' => '_impeka_grve_disable_logo',
								'id' => '_impeka_grve_disable_logo',
								'value' => $disable_logo,
								'label' => array(
									"title" => esc_html__( 'Disable Logo', 'impeka' ),
									"desc" => esc_html__( 'If selected, logo will be disabled.', 'impeka' ),
								),
							)
						);
						impeka_grve_print_admin_option(
							array(
								'type' => 'checkbox',
								'name' => '_impeka_grve_disable_menu',
								'id' => '_impeka_grve_disable_menu',
								'value' => $disable_menu,
								'label' => array(
									"title" => esc_html__( 'Disable Main Menu', 'impeka' ),
									"desc" => esc_html__( 'If selected, main menu will be hidden.', 'impeka' ),
								),
							)
						);
						impeka_grve_print_admin_option(
							array(
								'type' => 'checkbox',
								'name' => '_impeka_grve_disable_second_menu',
								'id' => '_impeka_grve_disable_second_menu',
								'value' => $disable_second_menu,
								'label' => array(
									"title" => esc_html__( 'Disable Second Menu', 'impeka' ),
									"desc" => esc_html__( 'If selected, second menu will be hidden.', 'impeka' ),
								),
							)
						);
						impeka_grve_print_admin_option(
							array(
								'type' => 'checkbox',
								'name' => '_impeka_grve_disable_responsive_menu',
								'id' => '_impeka_grve_disable_responsive_menu',
								'value' => $disable_responsive_menu,
								'label' => array(
									"title" => esc_html__( 'Disable Responsive Menu', 'impeka' ),
									"desc" => esc_html__( 'If selected, responsive menu will be hidden.', 'impeka' ),
								),
							)
						);
						impeka_grve_print_admin_option(
							array(
								'type' => 'checkbox',
								'name' => '_impeka_grve_disable_menu_item_text',
								'id' => '_impeka_grve_disable_menu_item_text',
								'value' => impeka_grve_array_value( $disable_menu_items, 'text'),
								'label' => array(
									"title" => esc_html__( 'Disable Main Menu Item Text', 'impeka' ),
									"desc" => esc_html__( 'If selected, menu text element will be hidden.', 'impeka' ),
								),
							)
						);
						impeka_grve_print_admin_option(
							array(
								'type' => 'checkbox',
								'name' => '_impeka_grve_disable_menu_item_search',
								'id' => '_impeka_grve_disable_menu_item_search',
								'value' => impeka_grve_array_value( $disable_menu_items, 'search'),
								'label' => array(
									"title" => esc_html__( 'Disable Main Menu Item Search', 'impeka' ),
									"desc" => esc_html__( 'If selected, main menu item will be hidden.', 'impeka' ),
								),
							)
						);
						impeka_grve_print_admin_option(
							array(
								'type' => 'checkbox',
								'name' => '_impeka_grve_disable_menu_item_form',
								'id' => '_impeka_grve_disable_menu_item_form',
								'value' => impeka_grve_array_value( $disable_menu_items, 'form'),
								'label' => array(
									"title" => esc_html__( 'Disable Main Menu Item Contact Form', 'impeka' ),
									"desc" => esc_html__( 'If selected, main menu item will be hidden.', 'impeka' ),
								),
							)
						);
						impeka_grve_print_admin_option(
							array(
								'type' => 'checkbox',
								'name' => '_impeka_grve_disable_menu_item_language',
								'id' => '_impeka_grve_disable_menu_item_language',
								'value' => impeka_grve_array_value( $disable_menu_items, 'language'),
								'label' => array(
									"title" => esc_html__( 'Disable Main Menu Item Language Selector', 'impeka' ),
									"desc" => esc_html__( 'If selected, main menu item will be hidden.', 'impeka' ),
								),
							)
						);
						impeka_grve_print_admin_option(
							array(
								'type' => 'checkbox',
								'name' => '_impeka_grve_disable_menu_item_cart',
								'id' => '_impeka_grve_disable_menu_item_cart',
								'value' => impeka_grve_array_value( $disable_menu_items, 'cart'),
								'label' => array(
									"title" => esc_html__( 'Disable Main Menu Item Shopping Cart', 'impeka' ),
									"desc" => esc_html__( 'If selected, main menu item will be hidden.', 'impeka' ),
								),
							)
						);
						impeka_grve_print_admin_option(
							array(
								'type' => 'checkbox',
								'name' => '_impeka_grve_disable_menu_item_social',
								'id' => '_impeka_grve_disable_menu_item_social',
								'value' => impeka_grve_array_value( $disable_menu_items, 'social'),
								'label' => array(
									"title" => esc_html__( 'Disable Main Menu Item Social Icons', 'impeka' ),
									"desc" => esc_html__( 'If selected, main menu item will be hidden.', 'impeka' ),
								),
							)
						);

						impeka_grve_print_admin_option(
							array(
								'type' => 'checkbox',
								'name' => '_impeka_grve_disable_breadcrumbs',
								'id' => '_impeka_grve_disable_breadcrumbs',
								'value' => $disable_breadcrumbs,
								'label' => array(
									"title" => esc_html__( 'Disable Breadcrumbs', 'impeka' ),
									"desc" => esc_html__( 'If selected, breadcrumbs items will be hidden.', 'impeka' ),
								),
							)
						);

						if ( 'page' == $post_type ) {
							if ( impeka_grve_woocommerce_enabled() && $post->ID == wc_get_page_id( 'shop' ) ) {
								//Skip
							} else {
								impeka_grve_print_admin_option(
									array(
										'type' => 'checkbox',
										'name' => '_impeka_grve_disable_content',
										'id' => '_impeka_grve_disable_content',
										'value' => $disable_content,
										'label' => array(
											"title" => esc_html__( 'Disable Content Area', 'impeka' ),
											"desc" => esc_html__( 'If selected, content area will be hidden (including sidebar and comments).', 'impeka' ),
										),
									)
								);
							}
						}

						if ( 'post' == $post_type ) {
							impeka_grve_print_admin_option(
								array(
									'type' => 'checkbox',
									'name' => '_impeka_grve_disable_media',
									'id' => '_impeka_grve_disable_media',
									'value' => $disable_media,
									'label' => array(
										"title" => esc_html__( 'Disable Media Area', 'impeka' ),
										"desc" => esc_html__( 'If selected, media area will be hidden.', 'impeka' ),
									),
								)
							);
						}
						if ( 'portfolio' == $post_type ) {
							impeka_grve_print_admin_option(
								array(
									'type' => 'checkbox',
									'name' => '_impeka_grve_disable_related_entries',
									'id' => '_impeka_grve_disable_related_entries',
									'value' => $disable_related_entries,
									'label' => array(
										"title" => esc_html__( 'Disable Related Entries', 'impeka' ),
										"desc" => esc_html__( 'If selected, related entries area will be hidden.', 'impeka' ),
									),
								)
							);
						}

						impeka_grve_print_admin_option(
							array(
								'type' => 'checkbox',
								'name' => '_impeka_grve_disable_back_to_top',
								'id' => '_impeka_grve_disable_back_to_top',
								'value' => $disable_back_to_top,
								'label' => array(
									"title" => esc_html__( 'Disable Back to Top', 'impeka' ),
									"desc" => esc_html__( 'If selected, Back to Top button will be hidden.', 'impeka' ),
								),
							)
						);

					?>
				</div>
			</div>
		</div>
	</div>

<?php
}

function impeka_grve_page_feature_section_box( $post ) {

	wp_nonce_field( 'impeka_grve_nonce_feature_save', '_impeka_grve_nonce_feature_save' );

	$post_id = $post->ID;
	impeka_grve_admin_get_feature_section( $post_id );

}

function impeka_grve_generic_options_save_postdata( $post_id , $post ) {

	if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) {
		return $post_id;
	}

	if ( wp_is_post_revision( $post_id ) || wp_is_post_autosave( $post_id ) ) {
		return $post_id;
	}

	if ( isset( $_POST['_impeka_grve_nonce_feature_save'] ) && wp_verify_nonce( $_POST['_impeka_grve_nonce_feature_save'], 'impeka_grve_nonce_feature_save' ) ) {

		if ( impeka_grve_check_permissions( $post_id ) ) {
			impeka_grve_admin_save_feature_section( $post_id );
		}

	}

	if ( isset( $_POST['_impeka_grve_nonce_page_save'] ) && wp_verify_nonce( $_POST['_impeka_grve_nonce_page_save'], 'impeka_grve_nonce_page_save' ) ) {

		if ( impeka_grve_check_permissions( $post_id ) ) {

			$page_options = array (
				array(
					'id' => '_impeka_grve_title',
					'html' => true,
				),
				array(
					'id' => '_impeka_grve_description',
					'html' => true,
				),
				array(
					'id' => '_impeka_grve_quickview_title',
					'html' => true,
				),
				array(
					'id' => '_impeka_grve_quickview_text',
					'html' => true,
				),
				array(
					'id' => '_impeka_grve_quickview_link_text',
					'html' => true,
				),
				array(
					'id' => '_impeka_grve_details_mode',
				),
				array(
					'id' => '_impeka_grve_details_title',
					'html' => true,
				),
				array(
					'id' => '_impeka_grve_details',
					'html' => true,
				),
				array(
					'id' => '_impeka_grve_details_link_text',
					'html' => true,
				),
				array(
					'id' => '_impeka_grve_details_link_url',
				),
				array(
					'id' => '_impeka_grve_details_link_new_window',
				),
				array(
					'id' => '_impeka_grve_details_link_extra_class',
				),
				array(
					'id' => '_impeka_grve_social_bar_layout',
				),
				array(
					'id' => '_impeka_grve_nav_id',
				),
				array(
					'id' => '_impeka_grve_nav_text',
				),
				array(
					'id' => '_impeka_grve_backlink_id',
				),
				array(
					'id' => '_impeka_grve_area_padding_top_multiplier',
				),
				array(
					'id' => '_impeka_grve_area_padding_bottom_multiplier',
				),
				array(
					'id' => '_impeka_grve_padding_top_multiplier',
				),
				array(
					'id' => '_impeka_grve_padding_bottom_multiplier',
				),
				array(
					'id' => '_impeka_grve_padding_top',
				),
				array(
					'id' => '_impeka_grve_padding_bottom',
				),
				array(
					'id' => '_impeka_grve_layout',
				),
				array(
					'id' => '_impeka_grve_sidebar',
				),
				array(
					'id' => '_impeka_grve_post_content_width',
				),
				array(
					'id' => '_impeka_grve_content_skin',
				),
				array(
					'id' => '_impeka_grve_sidearea_visibility',
				),
				array(
					'id' => '_impeka_grve_sidearea_sidebar',
				),
				array(
					'id' => '_impeka_grve_fixed_sidebar',
				),
				array(
					'id' => '_impeka_grve_header_overlapping',
				),
				array(
					'id' => '_impeka_grve_header_skin',
				),
				array(
					'id' => '_impeka_grve_anchor_navigation_menu',
				),
				array(
					'id' => '_impeka_grve_anchor_device_layout',
				),
				array(
					'id' => '_impeka_grve_feature_media_type',
				),
				array(
					'id' => '_impeka_grve_theme_loader',
				),
				array(
					'id' => '_impeka_grve_section_nav_hide',
				),
				array(
					'id' => '_impeka_grve_responsive_scrolling',
				),
				array(
					'id' => '_impeka_grve_scrolling_lock_anchors',
				),
				array(
					'id' => '_impeka_grve_scrolling_direction',
				),
				array(
					'id' => '_impeka_grve_scrolling_loop',
				),
				array(
					'id' => '_impeka_grve_scrolling_speed',
				),
				array(
					'id' => '_impeka_grve_main_navigation_menu',
				),
				array(
					'id' => '_impeka_grve_second_navigation_menu',
				),
				array(
					'id' => '_impeka_grve_responsive_navigation_menu',
				),
				array(
					'id' => '_impeka_grve_safe_button_area',
				),
				array(
					'id' => '_impeka_grve_responsive_header_overlapping',
				),
				array(
					'id' => '_impeka_grve_sticky_header_type',
				),
				array(
					'id' => '_impeka_grve_footer_sticky',
				),
				array(
					'id' => '_impeka_grve_bottom_bar_area',
				),
				array(
					'id' => '_impeka_grve_footer_widgets_visibility',
				),
				array(
					'id' => '_impeka_grve_footer_bar_visibility',
				),
				array(
					'id' => '_impeka_grve_disable_top_bar',
				),
				array(
					'id' => '_impeka_grve_disable_logo',
				),
				array(
					'id' => '_impeka_grve_disable_menu',
				),
				array(
					'id' => '_impeka_grve_disable_second_menu',
				),
				array(
					'id' => '_impeka_grve_disable_responsive_menu',
				),
				array(
					'id' => '_impeka_grve_disable_menu_items',
				),
				array(
					'id' => '_impeka_grve_disable_breadcrumbs',
				),
				array(
					'id' => '_impeka_grve_disable_title',
				),
				array(
					'id' => '_impeka_grve_disable_media',
				),
				array(
					'id' => '_impeka_grve_disable_content',
				),
				array(
					'id' => '_impeka_grve_disable_related_entries',
				),
				array(
					'id' => '_impeka_grve_disable_back_to_top',
				),
			);

			$disable_menu_items_options = array (
				array(
					'param_id' => 'text',
					'id' => '_impeka_grve_disable_menu_item_text',
					'default' => '',
				),
				array(
					'param_id' => 'search',
					'id' => '_impeka_grve_disable_menu_item_search',
					'default' => '',
				),
				array(
					'param_id' => 'form',
					'id' => '_impeka_grve_disable_menu_item_form',
					'default' => '',
				),
				array(
					'param_id' => 'language',
					'id' => '_impeka_grve_disable_menu_item_language',
					'default' => '',
				),
				array(
					'param_id' => 'cart',
					'id' => '_impeka_grve_disable_menu_item_cart',
					'default' => '',
				),
				array(
					'param_id' => 'social',
					'id' => '_impeka_grve_disable_menu_item_social',
					'default' => '',
				),
			);

			//Title Options
			$page_title_options = array (
				array(
					'param_id' => 'custom',
					'id' => '_impeka_grve_page_title_custom',
					'default' => '',
				),
				array(
					'param_id' => 'height',
					'id' => '_impeka_grve_page_title_height',
					'default' => '40',
				),
				array(
					'param_id' => 'min_height',
					'id' => '_impeka_grve_page_title_min_height',
					'default' => '200',
				),
				array(
					'param_id' => 'bg_color',
					'id' => '_impeka_grve_page_title_bg_color',
					'default' => 'white',
				),
				array(
					'param_id' => 'bg_color_custom',
					'id' => '_impeka_grve_page_title_bg_color_custom',
					'default' => '#ffffff',
				),
				array(
					'param_id' => 'subheading_color',
					'id' => '_impeka_grve_page_title_subheading_color',
					'default' => 'white',
				),
				array(
					'param_id' => 'subheading_color_custom',
					'id' => '_impeka_grve_page_title_subheading_color_custom',
					'default' => '#ffffff',
				),
				array(
					'param_id' => 'title_color',
					'id' => '_impeka_grve_page_title_title_color',
					'default' => 'black',
				),
				array(
					'param_id' => 'title_color_custom',
					'id' => '_impeka_grve_page_title_title_color_custom',
					'default' => '#000000',
				),
				array(
					'param_id' => 'caption_color',
					'id' => '_impeka_grve_page_title_caption_color',
					'default' => 'black',
				),
				array(
					'param_id' => 'caption_color_custom',
					'id' => '_impeka_grve_page_title_caption_color_custom',
					'default' => '#000000',
				),
				array(
					'param_id' => 'content_bg_color',
					'id' => '_impeka_grve_page_title_content_bg_color',
					'default' => 'none',
				),
				array(
					'param_id' => 'content_bg_color_custom',
					'id' => '_impeka_grve_page_title_content_bg_color_custom',
					'default' => '#000000',
				),
				array(
					'param_id' => 'container_size',
					'id' => '_impeka_grve_page_title_container_size',
					'default' => '',
				),
				array(
					'param_id' => 'content_size',
					'id' => '_impeka_grve_page_title_content_size',
					'default' => 'container',
				),
				array(
					'param_id' => 'content_alignment',
					'id' => '_impeka_grve_page_title_content_alignment',
					'default' => 'center',
				),
				array(
					'param_id' => 'content_position',
					'id' => '_impeka_grve_page_title_content_position',
					'default' => 'center-center',
				),
				array(
					'param_id' => 'content_animation',
					'id' => '_impeka_grve_page_title_content_animation',
					'default' => 'none',
				),
				array(
					'param_id' => 'bg_mode',
					'id' => '_impeka_grve_page_title_bg_mode',
					'default' => '',
				),
				array(
					'param_id' => 'bg_image_id',
					'id' => '_impeka_grve_page_title_bg_image_id',
					'default' => '0',
				),
				array(
					'param_id' => 'bg_position',
					'id' => '_impeka_grve_page_title_bg_position',
					'default' => 'center-center',
				),
				array(
					'param_id' => 'pattern_overlay',
					'id' => '_impeka_grve_page_title_pattern_overlay',
					'default' => '',
				),
				array(
					'param_id' => 'color_overlay',
					'id' => '_impeka_grve_page_title_color_overlay',
					'default' => 'black',
				),
				array(
					'param_id' => 'color_overlay_custom',
					'id' => '_impeka_grve_page_title_color_overlay_custom',
					'default' => '#000000',
				),
				array(
					'param_id' => 'opacity_overlay',
					'id' => '_impeka_grve_page_title_opacity_overlay',
					'default' => '0',
				),
			);

			//Content Background Options
			$content_skin_options = array (
				array(
					'param_id' => 'skin',
					'id' => '_impeka_grve_content_skin',
					'default' => '',
				),
				array(
					'param_id' => 'text_color',
					'id' => '_impeka_grve_content_text_color',
					'default' => '#888888',
				),
				array(
					'param_id' => 'heading_color',
					'id' => '_impeka_grve_content_heading_color',
					'default' => '#000000',
				),
				array(
					'param_id' => 'link_color',
					'id' => '_impeka_grve_content_link_color',
					'default' => '#000000',
				),
				array(
					'param_id' => 'link_hover_color',
					'id' => '_impeka_grve_content_link_hover_color',
					'default' => '#01B5ED',
				),
				array(
					'param_id' => 'background-color',
					'id' => '_impeka_grve_content_bg_color',
					'default' => '#ffffff',
				),
				array(
					'param_id' => 'background-repeat',
					'id' => '_impeka_grve_content_bg_repeat',
					'default' => '',
				),
				array(
					'param_id' => 'background-size',
					'id' => '_impeka_grve_content_bg_size',
					'default' => '',
				),
				array(
					'param_id' => 'background-attachment',
					'id' => '_impeka_grve_content_bg_attachment',
					'default' => '',
				),
				array(
					'param_id' => 'background-position',
					'id' => '_impeka_grve_content_bg_position',
					'default' => '',
				),
				array(
					'param_id' => 'background-image',
					'id' => '_impeka_grve_content_bg_image',
					'default' => '',
				),
			);

			//Area Colors
			$area_colors = array (
				array(
					'param_id' => 'custom',
					'id' => '_impeka_grve_area_colors_custom',
					'default' => '',
				),
				array(
					'param_id'    => 'bg_color',
					'id'          => '_impeka_grve_area_bg_color',
					'default'     => '#eeeeee',
				),
				array(
					'param_id'    => 'headings_color',
					'id'          => '_impeka_grve_area_headings_color',
					'default'     => '#000000',
				),
				array(
					'param_id'    => 'font_color',
					'id'          => '_impeka_grve_area_font_color',
					'default'     => '#999999',
				),
				array(
					'param_id'    => 'link_color',
					'id'          => '_impeka_grve_area_link_color',
					'default'     => '#FF7D88',
				),
				array(
					'param_id'    => 'hover_color',
					'id'          => '_impeka_grve_area_hover_color',
					'default'     => '#000000',
				),
				array(
					'param_id'    => 'border_color',
					'id'          => '_impeka_grve_area_border_color',
					'default'     => '#e0e0e0',
				),
				array(
					'param_id'    => 'button_color',
					'id'          =>'_impeka_grve_area_button_color',
					'default'     => 'primary-1',
				),
				array(
					'param_id'    => 'button_hover_color',
					'id'          =>'_impeka_grve_button_hover_color',
					'default'     => 'black',
				),
			);

			//Update Single custom fields
			foreach ( $page_options as $value ) {
				$allow_html = ( isset( $value['html'] ) ? $value['html'] : false );
				if( $allow_html ) {
					$new_meta_value = ( isset( $_POST[$value['id']] ) ? wp_filter_post_kses( $_POST[$value['id']] ) : '' );
				} else {
					$new_meta_value = ( isset( $_POST[$value['id']] ) ? sanitize_text_field( $_POST[$value['id']] ) : '' );
				}
				$meta_key = $value['id'];

				$meta_value = get_post_meta( $post_id, $meta_key, true );

				if ( '' != $new_meta_value  && '' == $meta_value ) {
					if ( !add_post_meta( $post_id, $meta_key, $new_meta_value, true ) ) {
						update_post_meta( $post_id, $meta_key, $new_meta_value );
					}
				} elseif ( '' != $new_meta_value && $new_meta_value != $meta_value ) {
					update_post_meta( $post_id, $meta_key, $new_meta_value );
				} elseif ( '' == $new_meta_value && '' != $meta_value ) {
					delete_post_meta( $post_id, $meta_key );
				}
			}

			//Update Menu Items Visibility array
			impeka_grve_update_meta_array( $post_id, '_impeka_grve_disable_menu_items', $disable_menu_items_options );
			//Update Title Options array
			impeka_grve_update_meta_array( $post_id, '_impeka_grve_custom_title_options', $page_title_options );
			//Update Content Background array
			impeka_grve_update_meta_array( $post_id, '_impeka_grve_content_skin_options', $content_skin_options );
			//Update Area Colors array
			impeka_grve_update_meta_array( $post_id, '_impeka_grve_area_colors', $area_colors );

			//Update Modals
			impeka_grve_admin_save_modal_section( $post_id );
		}
	}

}

/**
 * Function update meta array
 */
function impeka_grve_update_meta_array( $post_id, $param_id, $param_array_options ) {

	$array_options = array();

	if( !empty( $param_array_options ) ) {

		foreach ( $param_array_options as $value ) {

			$meta_key = $value['param_id'];
			$meta_default = $value['default'];

			$allow_html = ( isset( $value['html'] ) ? $value['html'] : false );
			if( $allow_html ) {
				$new_meta_value = ( isset( $_POST[$value['id']] ) ? wp_filter_post_kses( $_POST[$value['id']] ) : $meta_default );
			} else {
				$new_meta_value = ( isset( $_POST[$value['id']] ) ? sanitize_text_field( $_POST[$value['id']] ) : $meta_default );
			}

			if( !empty( $new_meta_value ) ) {
				$array_options[$meta_key] = $new_meta_value;
			}
		}

	}

	if( !empty( $array_options ) ) {
		update_post_meta( $post_id, $param_id, $array_options );
	} else {
		delete_post_meta( $post_id, $param_id );
	}
}

/**
 * Function to check post type permissions
 */

function impeka_grve_check_permissions( $post_id ) {

	if ( 'post' == $_POST['post_type'] ) {
		if ( !current_user_can( 'edit_post', $post_id ) ) {
			return false;
		}
	} else {
		if ( !current_user_can( 'edit_page', $post_id ) ) {
			return false;
		}
	}
	return true;
}

/**
 * Function to print menu selector
 */
function impeka_grve_print_menu_selection( $menu_id, $id, $name, $default = 'none' ) {

	?>
	<select id="<?php echo esc_attr( $id ); ?>" name="<?php echo esc_attr( $name ); ?>">
		<option value="" <?php selected( '', $menu_id ); ?>>
			<?php
				if ( 'none' == $default ){
					esc_html_e( 'None', 'impeka' );
				} else {
					esc_html_e( '-- Inherit --', 'impeka' );
				}
			?>
		</option>
	<?php
		$menus = wp_get_nav_menus();
		if ( ! empty( $menus ) ) {
			foreach ( $menus as $item ) {
	?>
				<option value="<?php echo esc_attr( $item->term_id ); ?>" <?php selected( $item->term_id, $menu_id ); ?>>
					<?php echo esc_html( $item->name ); ?>
				</option>
	<?php
			}
		}
	?>
	</select>
	<?php
}

/**
 * Function to print layout selector
 */
function impeka_grve_print_layout_selection( $layout, $id, $name ) {

	$layouts = array(
		'' => esc_html__( '-- Inherit --', 'impeka' ),
		'none' => esc_html__( 'Full Width', 'impeka' ),
		'left' => esc_html__( 'Left Sidebar', 'impeka' ),
		'right' => esc_html__( 'Right Sidebar', 'impeka' ),
	);

	?>
	<select id="<?php echo esc_attr( $id ); ?>" name="<?php echo esc_attr( $name ); ?>">
	<?php
		foreach ( $layouts as $key => $value ) {
			if ( $value ) {
	?>
				<option value="<?php echo esc_attr( $key ); ?>" <?php selected( $key, $layout ); ?>><?php echo esc_html( $value ); ?></option>
	<?php
			}
		}
	?>
	</select>
	<?php
}

/**
 * Function to print sidebar selector
 */
function impeka_grve_print_sidebar_selection( $sidebar, $id, $name ) {
	global $wp_registered_sidebars;

	?>
	<select id="<?php echo esc_attr( $id ); ?>" name="<?php echo esc_attr( $name ); ?>">
		<option value="" <?php selected( '', $sidebar ); ?>><?php echo esc_html__( '-- Inherit --', 'impeka' ); ?></option>
	<?php
	foreach ( $wp_registered_sidebars as $key => $value ) {
		?>
		<option value="<?php echo esc_attr( $key ); ?>" <?php selected( $key, $sidebar ); ?>><?php echo esc_html( $value['name'] ); ?></option>
		<?php
	}
	?>
	</select>
	<?php
}

/**
 * Function to print page selector
 */
function impeka_grve_print_page_selection( $page_id, $id, $name ) {

?>
	<select id="<?php echo esc_attr( $id ); ?>" name="<?php echo esc_attr( $name ); ?>">
		<option value="" <?php selected( '', $page_id ); ?>>
			<?php esc_html_e( '-- Inherit --', 'impeka' ); ?>
		</option>
		<option value="none" <?php selected( 'none', $page_id ); ?>>
			<?php esc_html_e( 'None', 'impeka' ); ?>
		</option>
<?php
		$pages = get_pages();
		foreach ( $pages as $page ) {
?>
			<option value="<?php echo esc_attr( $page->ID ); ?>" <?php selected( $page->ID, $page_id ); ?>>
				<?php echo esc_html( $page->post_title ); ?>
			</option>
<?php
		}
?>
	</select>
<?php

}


/**
 * Function to print page selector
 */
function impeka_grve_print_area_selection( $area_id, $id, $name ) {

?>
	<select id="<?php echo esc_attr( $id ); ?>" name="<?php echo esc_attr( $name ); ?>">
		<option value="" <?php selected( '', $area_id ); ?>>
			<?php esc_html_e( '-- Inherit --', 'impeka' ); ?>
		</option>
		<option value="none" <?php selected( 'none', $area_id ); ?>>
			<?php esc_html_e( '-- None --', 'impeka' ); ?>
		</option>
<?php
		$args = array( 'post_type' => 'area-item', 'numberposts' => -1 );
		$posts = get_posts( $args );
		if ( ! empty ( $posts ) ) {
			foreach ( $posts as $post ) {
?>
			<option value="<?php echo esc_attr( $post->ID ); ?>" <?php selected( $post->ID, $area_id ); ?>>
				<?php echo esc_html( $post->post_title ); ?>
			</option>
<?php
			}
		}
		wp_reset_postdata();
?>
	</select>
<?php

}

//Omit closing PHP tag to avoid accidental whitespace output errors.
