<?php
/**
*	Theme Options Config File
*	@version	1.0
*
* 	@author		Greatives Team
* 	@URI		https://greatives.eu
*/

if ( !class_exists( "ReduxFramework" ) ) {
	return;
}

function impeka_grve_redux_dimensions_validation( $field, $value, $existing_value ) {
	$error = false;

	if ( empty( $value['width'] ) || !is_numeric( $value['width'] ) ) {
		$error = true;
	}
	if ( empty( $value['height'] ) || !is_numeric( $value['height'] ) ) {
		$error = true;
	}

	if ( $error == true ) {
		$value = $existing_value;
		$field['msg'] = esc_html__( 'You must provide a numerical value for both options.', 'impeka' );
	}

	$return['value'] = $value;
	if ( $error == true ) {
		$return['error'] = $field;
	}
	return $return;

}

if (!class_exists("Impeka_Grve_Redux_Framework_config")) {

	class Impeka_Grve_Redux_Framework_config {

		public $args = array();
		public $sections = array();
		public $theme;
		public $ReduxFramework;

		public function __construct() {
			// Set the default arguments
			$this->setArguments();

			// Create the sections and fields
			$this->setSections();

			// No errors please
			if ( !isset( $this->args['opt_name'] ) ) {
				return;
			}
			$this->ReduxFramework = new ReduxFramework($this->sections, $this->args);
		}

		public function impeka_grve_redux_customizer_visibility() {
			$visibility = apply_filters( 'impeka_grve_redux_customizer_visibility', false );
			return $visibility;
		}

		public function setSections() {

			/**
			 * Used within different fields. Simply examples. Search for ACTUAL DECLARATION for field examples
			 * */
			global $impeka_grve_social_list;

			//Gravity Forms
			$gravity_form_options = array();
			if ( class_exists( 'RGFormsModel' ) ) {
				$gravity_forms = RGFormsModel::get_forms( 1, 'title' );
				if ( $gravity_forms ) {
					foreach ( $gravity_forms as $gravity_form ) {
						$gravity_form_options[ $gravity_form->id ] = $gravity_form->title;
					}
				}
			}

			//Fluent Forms
			$fluent_form_options = array();
			if ( function_exists( 'wpFluent' ) ) {
				$ff_list = wpFluent()->table('fluentform_forms')->select(['id', 'title'])->orderBy('id', 'DESC')->get();
				if ($ff_list) {
					foreach ($ff_list as $form) {
						$fluent_form_options[$form->id] = $form->title .' ('.$form->id.')';
					}
				}
			}

			//Assign global variables to local
			$social_options = $impeka_grve_social_list;
			$button_type_selection = impeka_grve_global_admin_param( 'button_type_selection' );
			$button_shape_selection = impeka_grve_global_admin_param( 'button_shape_selection' );
			$button_color_selection = impeka_grve_global_admin_param( 'button_color_selection' );
			$area_height = impeka_grve_global_admin_param( 'area_height' );

			//Portfolio
			$portfolio_social_options = array(
				'email' => esc_html__( 'E-mail', 'impeka' ),
				'twitter' => 'Twitter',
				'facebook' => 'Facebook',
				'linkedin' => 'LinkedIn',
				'pinterest' => 'Pinterest',
				'reddit' => 'reddit',
				'tumblr' => 'Tumblr',
				'grve-likes' => '(Greatives) Likes',
			);
			$portfolio_term_selection = array(
				'none' => esc_html__( 'None', 'impeka' ),
				'portfolio_category' => esc_html__( 'Portfolio Category', 'impeka' ),
				'portfolio_field' => esc_html__( 'Portfolio Field', 'impeka' ),
			);

			//Post
			$post_social_options = array(
				'email' => esc_html__( 'E-mail', 'impeka' ),
				'twitter' => 'Twitter',
				'facebook' => 'Facebook',
				'linkedin' => 'LinkedIn',
				'reddit' => 'reddit',
				'tumblr' => 'Tumblr',
				'grve-likes' => '(Greatives) Likes',
			);

			//Product
			$product_social_options = array(
				'email' => esc_html__( 'E-mail', 'impeka' ),
				'twitter' => 'Twitter',
				'facebook' => 'Facebook',
				'linkedin' => 'LinkedIn',
				'reddit' => 'reddit',
				'tumblr' => 'Tumblr',
				'grve-likes' => '(Greatives) Likes',
			);

			//Event

			$event_social_options = array(
				'email' => esc_html__( 'E-mail', 'impeka' ),
				'twitter' => 'Twitter',
				'facebook' => 'Facebook',
				'linkedin' => 'LinkedIn',
				'reddit' => 'reddit',
				'tumblr' => 'Tumblr',
				'grve-likes' => '(Greatives) Likes',
			);

			//Image Selections
			$grid_image_mode_selection = array(
				'full' => esc_html__( 'Full', 'impeka' ),
				'square' => esc_html__( 'Square Small Crop', 'impeka' ),
				'landscape' => esc_html__( 'Landscape Small Crop', 'impeka' ),
				'landscape-medium' => esc_html__( 'Landscape Medium Crop', 'impeka' ),
				'portrait' => esc_html__( 'Portrait Small Crop', 'impeka' ),
				'portrait-medium' => esc_html__( 'Portrait Medium Crop', 'impeka' ),
				'extra-extra-large' => esc_html__( 'Resize ( Extra Extra Large )', 'impeka' ),
				'large' => esc_html__( 'Resize ( Large )', 'impeka' ),
				'medium_large' => esc_html__( 'Resize ( Medium Large )', 'impeka' ),
				'medium' => esc_html__( 'Resize ( Medium )', 'impeka' ),
			);
			$masonry_image_mode_selection = array(
				'full' => esc_html__( 'Full', 'impeka' ),
				'extra-extra-large' => esc_html__( 'Resize ( Extra Extra Large )', 'impeka' ),
				'large' => esc_html__( 'Resize ( Large )', 'impeka' ),
				'medium_large' => esc_html__( 'Resize ( Medium Large )', 'impeka' ),
				'medium' => esc_html__( 'Resize ( Medium )', 'impeka' ),
			);

			//Columns
			$grid_columns_selection = array(
				'1' => '1',
				'2' => '2',
				'3' => '3',
				'4' => '4',
				'5' => '5',
				'6' => '6',
			);
			$grid_columns_selection_tablet = array(
				'1' => '1',
				'2' => '2',
				'3' => '3',
				'4' => '4',
				'5' => '5',
				'6' => '6',
			);
			$grid_columns_selection_mobile = array(
				'1' => '1',
				'2' => '2',
				'3' => '3',
			);

			//Portfolio
			$portfolio_tax_mode_selection = array(
				'grid' => array('title' => esc_html__( 'Grid', 'impeka' ), 'alt' => esc_html__( 'Grid', 'impeka' ), 'img' => get_template_directory_uri() . '/includes/images/redux-panel/blog/grid.png'),
				'masonry' => array('title' => esc_html__( 'Masonry', 'impeka' ), 'alt' => esc_html__( 'Masonry', 'impeka' ), 'img' => get_template_directory_uri() . '/includes/images/redux-panel/blog/masonry.png'),
			);
			//Search
			$search_page_mode_selection = array(
				'small' => array('title' => esc_html__( 'Small Media', 'impeka' ), 'alt' => esc_html__( 'Small Media', 'impeka' ), 'img' => get_template_directory_uri() . '/includes/images/redux-panel/blog/small-media.png'),
				'grid' => array('title' => esc_html__( 'Grid', 'impeka' ), 'alt' => esc_html__( 'Grid', 'impeka' ), 'img' => get_template_directory_uri() . '/includes/images/redux-panel/blog/grid.png'),
				'masonry' => array('title' => esc_html__( 'Masonry', 'impeka' ), 'alt' => esc_html__( 'Masonry', 'impeka' ), 'img' => get_template_directory_uri() . '/includes/images/redux-panel/blog/masonry.png'),
			);
			//Blog
			$blog_mode_selection = array(
				'large' => array('title' => esc_html__( 'Large Media', 'impeka' ), 'alt' => esc_html__( 'Large Media', 'impeka' ), 'img' => get_template_directory_uri() . '/includes/images/redux-panel/blog/large-media.png'),
				'small' => array('title' => esc_html__( 'Small Media', 'impeka' ), 'alt' => esc_html__( 'Small Media', 'impeka' ), 'img' => get_template_directory_uri() . '/includes/images/redux-panel/blog/small-media.png'),
				'grid' => array('title' => esc_html__( 'Grid', 'impeka' ), 'alt' => esc_html__( 'Grid', 'impeka' ), 'img' => get_template_directory_uri() . '/includes/images/redux-panel/blog/grid.png'),
				'masonry' => array('title' => esc_html__( 'Masonry', 'impeka' ), 'alt' => esc_html__( 'Masonry', 'impeka' ), 'img' => get_template_directory_uri() . '/includes/images/redux-panel/blog/masonry.png'),
			);
			$blog_image_mode_selection = array(
				'landscape-large-wide' => esc_html__( 'Landscape Large Wide Crop', 'impeka' ),
				'landscape-medium' => esc_html__( 'Landscape Medium Crop', 'impeka' ),
				'large' => esc_html__( 'Resize ( Large )', 'impeka' ),
				'medium_large' => esc_html__( 'Resize ( Medium Large )', 'impeka' ),
				'medium' => esc_html__( 'Resize ( Medium )', 'impeka' ),
			);
			$blog_headings_tag_selection = array(
				'auto' => esc_html__( 'Auto', 'impeka' ),
				'h2'  => 'h2',
				'h3'  => 'h3',
				'h4'  => 'h4',
				'h5'  => 'h5',
				'h6'  => 'h6',
				'div'  => 'div',
			);
			$blog_headings_selection = array(
				'auto' => esc_html__( 'Auto', 'impeka' ),
				'h1'  => 'h1',
				'h2'  => 'h2',
				'h3'  => 'h3',
				'h4'  => 'h4',
				'h5'  => 'h5',
				'h6'  => 'h6',
				'leader-text' => esc_html__( 'Leader Text', 'impeka' ),
				'subtitle-text' => esc_html__( 'Subtitle Text', 'impeka' ),
				'small-text' => esc_html__( 'Small Text', 'impeka' ),
				'link-text' => esc_html__( 'Link Text', 'impeka' ),
			);

			//Event
			$event_headings_selection = array(
				'h2'  => 'h2',
				'h3'  => 'h3',
				'h4'  => 'h4',
				'h5'  => 'h5',
				'h6'  => 'h6',
			);

			$layout_selection = array(
				'left' => array('title' => esc_html__( 'Left Sidebar', 'impeka' ), 'alt' => esc_html__( 'Left Sidebar', 'impeka' ), 'img' => get_template_directory_uri() . '/includes/images/redux-panel/sidebars/sidebar-left.png'),
				'none' => array('title' => esc_html__( 'Full Width', 'impeka' ), 'alt' => esc_html__( 'Full Width', 'impeka' ), 'img' => get_template_directory_uri() . '/includes/images/redux-panel/sidebars/sidebar-none.png'),
				'right' => array('title' => esc_html__( 'Right Sidebar', 'impeka' ), 'alt' => esc_html__( 'Right Sidebar', 'impeka' ), 'img' => get_template_directory_uri() . '/includes/images/redux-panel/sidebars/sidebar-right.png'),
			);
			$align_selection = array(
				'left' => esc_html__( 'Left', 'impeka' ),
				'right' => esc_html__( 'Right', 'impeka' ),
			);
			$align_selection_extra = array(
				'left' => esc_html__( 'Left', 'impeka' ),
				'center' => esc_html__( 'Center', 'impeka' ),
				'right' => esc_html__( 'Right', 'impeka' ),
			);
			$align_title = array(
				'left' => array('title' => esc_html__( 'Align Left', 'impeka' ), 'alt' => esc_html__( 'Left', 'impeka' ), 'img' => get_template_directory_uri() . '/includes/images/redux-panel/title-align/title-align-left.png'),
				'center' => array('title' => esc_html__( 'Align Center', 'impeka' ), 'alt' => esc_html__( 'Center', 'impeka' ), 'img' => get_template_directory_uri() . '/includes/images/redux-panel/title-align/title-align-center.png'),
				'right' => array('title' => esc_html__( 'Align Right', 'impeka' ), 'alt' => esc_html__( 'Right', 'impeka' ), 'img' => get_template_directory_uri() . '/includes/images/redux-panel/title-align/title-align-right.png'),
			);
			$align_position = array(
				'left-top' => array('alt' => esc_html__( 'Left Top', 'impeka' ), 'img' => get_template_directory_uri() . '/includes/images/redux-panel/content-positon/left-top.png'),
				'center-top' => array('alt' => esc_html__( 'Center Top', 'impeka' ), 'img' => get_template_directory_uri() . '/includes/images/redux-panel/content-positon/center-top.png'),
				'right-top' => array('alt' => esc_html__( 'Right Top', 'impeka' ), 'img' => get_template_directory_uri() . '/includes/images/redux-panel/content-positon/right-top.png'),
				'left-center' => array('alt' => esc_html__( 'Left Center', 'impeka' ), 'img' => get_template_directory_uri() . '/includes/images/redux-panel/content-positon/left-center.png'),
				'center-center' => array('alt' => esc_html__( 'Center Center', 'impeka' ), 'img' => get_template_directory_uri() . '/includes/images/redux-panel/content-positon/center-center.png'),
				'right-center' => array('alt' => esc_html__( 'Right Center', 'impeka' ), 'img' => get_template_directory_uri() . '/includes/images/redux-panel/content-positon/right-center.png'),
				'left-bottom' => array('alt' => esc_html__( 'Left Bottom', 'impeka' ), 'img' => get_template_directory_uri() . '/includes/images/redux-panel/content-positon/left-bottom.png'),
				'center-bottom' => array('alt' => esc_html__( 'Center Bottom', 'impeka' ), 'img' => get_template_directory_uri() . '/includes/images/redux-panel/content-positon/center-bottom.png'),
				'right-bottom' => array('alt' => esc_html__( 'Right Bottom', 'impeka' ), 'img' => get_template_directory_uri() . '/includes/images/redux-panel/content-positon/right-bottom.png'),
			);
			$align_selection_full = array(
				'left-top' => esc_html__( 'Left Top', 'impeka' ),
				'left-center' => esc_html__( 'Left Center', 'impeka' ),
				'left-bottom' => esc_html__( 'Left Bottom', 'impeka' ),
				'center-top' => esc_html__( 'Center Top', 'impeka' ),
				'center-center' => esc_html__( 'Center Center', 'impeka' ),
				'center-bottom' => esc_html__( 'Center Bottom', 'impeka' ),
				'right-top' => esc_html__( 'Right Top', 'impeka' ),
				'right-center' => esc_html__( 'Right Center', 'impeka' ),
				'right-bottom' => esc_html__( 'Right Bottom', 'impeka' ),
			);
			$animation_selection = array(
				'none' => esc_html__( 'None', 'impeka' ),
				'fade-in' => esc_html__( 'Fade In', 'impeka' ),
				'fade-in-up' => esc_html__( 'Fade In Up', 'impeka' ),
				'fade-in-down' => esc_html__( 'Fade In Down', 'impeka' ),
				'fade-in-left' => esc_html__( 'Fade In Left', 'impeka' ),
				'fade-in-right' => esc_html__( 'Fade In Right', 'impeka' ),
				'zoom-in' => esc_html__( 'Zoom In', 'impeka' ),
				'zoom-out' => esc_html__( 'Zoom Out', 'impeka' ),
				'appear-up' => esc_html__( 'Appear Up', 'impeka' ),
				'appear-down' => esc_html__( 'Appear Down', 'impeka' ),
				'appear-left' => esc_html__( 'Appear Left', 'impeka' ),
				'appear-right' => esc_html__( 'Appear Right', 'impeka' ),
			);
			$title_bg_mode = array(
				'color' => esc_html__( 'Color Only', 'impeka' ),
				'featured' => esc_html__( 'Featured Image', 'impeka' ),
				'custom' => esc_html__( 'Custom Image', 'impeka' ),
			);
			$title_bg_mode_limited = array(
				'color' => esc_html__( 'Color Only', 'impeka' ),
				'custom' => esc_html__( 'Custom Image', 'impeka' ),

			);
			$background_type = array(
				'transparent' => esc_html__( 'None', 'impeka' ),
				'colored' => esc_html__( 'Background', 'impeka' ),
				'advanced' => esc_html__( 'Stretched Background', 'impeka' ),
			);
			$header_menu_options = array(
				'search' => esc_html__( 'Search', 'impeka' ),
				'form' => esc_html__( 'Contact Form (Contact Form 7, Fluent Form or Gravity Forms Required)', 'impeka' ),
				'language' => esc_html__( 'Language selector (WPML or Polylang Required)', 'impeka' ),
				'cart' => esc_html__( 'Shopping Cart (WooCommerce Required)', 'impeka' ),
				'social' => esc_html__( 'Social Icons', 'impeka' ),
				'text' => esc_html__( 'Text Element', 'impeka' ),
			);
			$header_menu_options_default = array(
				'search' => false,
				'form' => false,
				'language' => false,
				'cart' => false,
				'social' => false,
				'text' => false,
			);
			$responsive_menu_options = array(
				'search' => esc_html__( 'Search', 'impeka' ),
				'form' => esc_html__( 'Contact Form (Contact Form 7, Fluent Form or Gravity Forms Required)', 'impeka' ),
				'language' => esc_html__( 'Language selector (WPML or Polylang Required)', 'impeka' ),
				'social' => esc_html__( 'Social Icons', 'impeka' ),
				'text' => esc_html__( 'Text Element', 'impeka' ),
			);
			$responsive_menu_options_default = array(
				'search' => false,
				'form' => false,
				'language' => false,
				'social' => false,
				'text' => false,
			);
			$top_bar_options = array(
				'menu' => esc_html__( 'Menu (Assigned: Menus - Manage Locations)', 'impeka' ),
				'text' => esc_html__( 'Text', 'impeka' ),
				'search' => esc_html__( 'Search', 'impeka' ),
				'language' => esc_html__( 'Language selector (WPML or Polylang Required)', 'impeka' ),
				'form' => esc_html__( 'Contact Form (Contact Form 7, Fluent Form or Gravity Forms Required)', 'impeka' ),
				'social' => esc_html__( 'Social Icons', 'impeka' ),
			);
			$top_bar_options_default = array(
				'menu' => false,
				'text' => false,
				'search' => false,
				'language' => false,
				'form' => false,
				'social' => false,
			);
			$menu_animations = array(
				'none' => esc_html__( 'None', 'impeka' ),
				'fade-in' => esc_html__( 'Fade in', 'impeka' ),
				'fade-in-up' => esc_html__( 'Fade in Up', 'impeka' ),
				'fade-in-down' => esc_html__( 'Fade in Down', 'impeka' ),
				'fade-in-left' => esc_html__( 'Fade in Left', 'impeka' ),
				'fade-in-right' => esc_html__( 'Fade in Right', 'impeka' ),
			);
			$menu_pointers = array(
				'none' => esc_html__( 'None', 'impeka' ),
				'with-arrow' => esc_html__( 'Arrow', 'impeka' ),
				'arrow-not-first-level' => esc_html__( 'Arrow (exclude first level items)', 'impeka' ),
			);

			$color_selection = array(
				'black' => esc_html__( 'Black', 'impeka' ),
				'white' => esc_html__( 'White', 'impeka' ),
				'primary-1' => esc_html__( 'Primary 1', 'impeka' ),
				'primary-2' => esc_html__( 'Primary 2', 'impeka' ),
				'primary-3' => esc_html__( 'Primary 3', 'impeka' ),
				'primary-4' => esc_html__( 'Primary 4', 'impeka' ),
				'primary-5' => esc_html__( 'Primary 5', 'impeka' ),
				'primary-6' => esc_html__( 'Primary 6', 'impeka' ),
			);

			$color_selection_extra = array(
				'black' => esc_html__( 'Black', 'impeka' ),
				'white' => esc_html__( 'White', 'impeka' ),
				'primary-1' => esc_html__( 'Primary 1', 'impeka' ),
				'primary-2' => esc_html__( 'Primary 2', 'impeka' ),
				'primary-3' => esc_html__( 'Primary 3', 'impeka' ),
				'primary-4' => esc_html__( 'Primary 4', 'impeka' ),
				'primary-5' => esc_html__( 'Primary 5', 'impeka' ),
				'primary-6' => esc_html__( 'Primary 6', 'impeka' ),
				'custom' => esc_html__( 'Custom', 'impeka' ),
			);

			$bg_color_selection = array(
				'none' => esc_html__( 'None', 'impeka' ),
				'black' => esc_html__( 'Black', 'impeka' ),
				'white' => esc_html__( 'White', 'impeka' ),
				'primary-1' => esc_html__( 'Primary 1', 'impeka' ),
				'primary-2' => esc_html__( 'Primary 2', 'impeka' ),
				'primary-3' => esc_html__( 'Primary 3', 'impeka' ),
				'primary-4' => esc_html__( 'Primary 4', 'impeka' ),
				'primary-5' => esc_html__( 'Primary 5', 'impeka' ),
				'primary-6' => esc_html__( 'Primary 6', 'impeka' ),
			);

			$bg_color_selection_extra = array(
				'transparent' => esc_html__( 'Transparent', 'impeka' ),
				'black' => esc_html__( 'Black', 'impeka' ),
				'white' => esc_html__( 'White', 'impeka' ),
				'primary-1' => esc_html__( 'Primary 1', 'impeka' ),
				'primary-2' => esc_html__( 'Primary 2', 'impeka' ),
				'primary-3' => esc_html__( 'Primary 3', 'impeka' ),
				'primary-4' => esc_html__( 'Primary 4', 'impeka' ),
				'primary-5' => esc_html__( 'Primary 5', 'impeka' ),
				'primary-6' => esc_html__( 'Primary 6', 'impeka' ),
				'custom' => esc_html__( 'Custom', 'impeka' ),
			);
			$content_bg_color_selection_extra = array(
				'none' => esc_html__( 'None', 'impeka' ),
				'black' => esc_html__( 'Black', 'impeka' ),
				'white' => esc_html__( 'White', 'impeka' ),
				'primary-1' => esc_html__( 'Primary 1', 'impeka' ),
				'primary-2' => esc_html__( 'Primary 2', 'impeka' ),
				'primary-3' => esc_html__( 'Primary 3', 'impeka' ),
				'primary-4' => esc_html__( 'Primary 4', 'impeka' ),
				'primary-5' => esc_html__( 'Primary 5', 'impeka' ),
				'primary-6' => esc_html__( 'Primary 6', 'impeka' ),
				'custom' => esc_html__( 'Custom', 'impeka' ),
			);

			$header_skin = array(
				'default' => esc_html__( 'Default', 'impeka' ),
				'dark' => esc_html__( 'Dark', 'impeka' ),
				'light' => esc_html__( 'Light', 'impeka' ),
			);

			$title_style = array(
				'advanced' => esc_html__( 'Advanced Title', 'impeka' ),
				'simple' => esc_html__( 'Simple Title', 'impeka' ),
			);

			$enable_selection = array(
				'no' => esc_html__( 'No', 'impeka' ),
				'yes' => esc_html__( 'Yes', 'impeka' ),
			);

			$menu_responsibe_style_selection = array(
				'1' => esc_html__( 'Style 1', 'impeka' ),
				'2' => esc_html__( 'Style 2', 'impeka' ),
			);

			$menu_responsibe_toggle_selection = array(
				'icon' => esc_html__( 'Icon', 'impeka' ),
				'text' => esc_html__( 'Text', 'impeka' ),
			);

			$theme_layouts_selection = array(
				'stretched' => array('alt' => esc_html__( 'Stretched', 'impeka' ), 'img' => get_template_directory_uri() . '/includes/images/redux-panel/theme-layouts/stretched.png' ),
				'boxed' => array('alt' => esc_html__( 'Boxed', 'impeka' ), 'img' => get_template_directory_uri() . '/includes/images/redux-panel/theme-layouts/boxed.png' ),
				'framed' => array('alt' => esc_html__( 'Framed', 'impeka' ), 'img' => get_template_directory_uri() . '/includes/images/redux-panel/theme-layouts/framed.png' ),
			);

			$header_layouts_selection = array(
				'layout-default-style-1' => array( 'alt' => esc_html__( 'Default Style 1', 'impeka' ), 'img' => get_template_directory_uri() . '/includes/images/redux-panel/header/layout-default-style-1.png', 'class' => 'grve-redux-stretched grve-redux-boxed grve-redux-framed' ),
				'layout-default-style-2' => array( 'alt' => esc_html__( 'Default Style 2', 'impeka' ), 'img' => get_template_directory_uri() . '/includes/images/redux-panel/header/layout-default-style-2.png', 'class' => 'grve-redux-stretched grve-redux-boxed grve-redux-framed' ),
				'layout-default-style-4' => array( 'alt' => esc_html__( 'Split Menu', 'impeka' ), 'img' => get_template_directory_uri() . '/includes/images/redux-panel/header/layout-default-style-4.png', 'class' => 'grve-redux-stretched grve-redux-boxed grve-redux-framed' ),
				'layout-top-bottom-style-1' => array( 'alt' => esc_html__( 'Logo on Top', 'impeka' ), 'img' => get_template_directory_uri() . '/includes/images/redux-panel/header/layout-top-bottom-style-1.png', 'class' => 'grve-redux-stretched grve-redux-boxed' ),
				'layout-side-style-1' => array( 'alt' => esc_html__( 'Side', 'impeka' ), 'img' => get_template_directory_uri() . '/includes/images/redux-panel/header/layout-side-style-1.png', 'class' => 'grve-redux-stretched' ),
				'layout-offcanvas-style-1' => array( 'alt' => esc_html__( 'Off Canvas Top', 'impeka' ), 'img' => get_template_directory_uri() . '/includes/images/redux-panel/header/layout-offcanvas-style-1.png', 'class' => 'grve-redux-stretched grve-redux-boxed grve-redux-framed' ),
				'layout-offcanvas-style-2' => array( 'alt' => esc_html__( 'Off Canvas Size', 'impeka' ), 'img' => get_template_directory_uri() . '/includes/images/redux-panel/header/layout-offcanvas-style-2.png', 'class' => 'grve-redux-stretched' ),
				'layout-offcanvas-style-3' => array( 'alt' => esc_html__( 'Off Canvas Side', 'impeka' ), 'img' => get_template_directory_uri() . '/includes/images/redux-panel/header/layout-offcanvas-style-3.png', 'class' => 'grve-redux-stretched grve-redux-boxed grve-redux-framed' ),
			);
			$responsive_header_layouts_selection = array(
				'layout-1' => array( 'alt' => esc_html__( 'Style 1', 'impeka' ), 'img' => get_template_directory_uri() . '/includes/images/redux-panel/responsive-header/layout-style-1.png' ),
				'layout-2' => array( 'alt' => esc_html__( 'Style 2', 'impeka' ), 'img' => get_template_directory_uri() . '/includes/images/redux-panel/responsive-header/layout-style-2.png' ),
			);
			$default_header_menu_align_selection = array(
				'left' => array( 'alt' => esc_html__( 'Left', 'impeka' ), 'img' => get_template_directory_uri() . '/includes/images/redux-panel/header-default/menu-align-left.png' ),
				'center' => array( 'alt' => esc_html__( 'Center', 'impeka' ), 'img' => get_template_directory_uri() . '/includes/images/redux-panel/header-default/menu-align-center.png' ),
				'right' => array( 'alt' => esc_html__( 'Right', 'impeka' ), 'img' => get_template_directory_uri() . '/includes/images/redux-panel/header-default/menu-align-right.png' ),
			);
			$top_bottom_header_align_selection = array(
				'left' => array( 'alt' => esc_html__( 'Left', 'impeka' ), 'img' => get_template_directory_uri() . '/includes/images/redux-panel/header-top-bottom/bottom-top-align-left.png' ),
				'center' => array( 'alt' => esc_html__( 'Center', 'impeka' ), 'img' => get_template_directory_uri() . '/includes/images/redux-panel/header-top-bottom/bottom-top-align-center.png' ),
			);
			$header_sticky_selection = array(
				'none' => array('title' => esc_html__( 'None', 'impeka' ), 'alt' => esc_html__( 'None', 'impeka' ), 'img' => get_template_directory_uri() . '/includes/images/redux-panel/header-sticky/none.gif', 'class' => 'layout-default-style-1 layout-default-style-2 layout-default-style-4 layout-top-bottom-style-1 layout-offcanvas-style-1 layout-offcanvas-style-3' ),
				'simple' => array('title' => esc_html__( 'Simple', 'impeka' ), 'alt' => esc_html__( 'Simple', 'impeka' ), 'img' => get_template_directory_uri() . '/includes/images/redux-panel/header-sticky/simple.gif', 'class' => 'layout-default-style-1 layout-default-style-2 layout-default-style-4 layout-top-bottom-style-1 layout-offcanvas-style-1 layout-offcanvas-style-3' ),
				'shrink' => array('title' => esc_html__( 'Shrink', 'impeka' ), 'alt' => esc_html__( 'Shrink', 'impeka' ), 'img' => get_template_directory_uri() . '/includes/images/redux-panel/header-sticky/shrink.gif', 'class' => 'layout-default-style-1 layout-default-style-2 layout-default-style-4 layout-offcanvas-style-1 layout-offcanvas-style-3' ),
				'scrollup' => array('title' => esc_html__( 'Scroll Up', 'impeka' ), 'alt' => esc_html__( 'Scroll Up', 'impeka' ), 'img' => get_template_directory_uri() . '/includes/images/redux-panel/header-sticky/scrollup.gif', 'class' => 'layout-default-style-1 layout-default-style-2 layout-default-style-4 layout-top-bottom-style-1 layout-offcanvas-style-1 layout-offcanvas-style-3' ),
				'vertical-animation' => array('title' => esc_html__( 'Animated', 'impeka' ), 'alt' => esc_html__( 'Animated', 'impeka' ), 'img' => get_template_directory_uri() . '/includes/images/redux-panel/header-sticky/animated.gif', 'class' => 'layout-default-style-1 layout-offcanvas-style-1 layout-offcanvas-style-3' ),
			);

			$side_header_alignments_selection = array(
				'left' => array('alt' => esc_html__( 'Align Left', 'impeka' ), 'img' => get_template_directory_uri() . '/includes/images/redux-panel/header-side/side-header-align-left.png' ),
				'center' => array('alt' => esc_html__( 'Align Left', 'impeka' ), 'img' => get_template_directory_uri() . '/includes/images/redux-panel/header-side/side-header-align-center.png' ),
				'right' => array('alt' => esc_html__( 'Align Left', 'impeka' ), 'img' => get_template_directory_uri() . '/includes/images/redux-panel/header-side/side-header-align-right.png' ),
			);

			$offcanvas_width_selection = array(
				'offcanvas-custom-width' => array('alt' => esc_html__( 'Offcanvas Custom Width', 'impeka' ), 'img' => get_template_directory_uri() . '/includes/images/redux-panel/header-offcanvas/offcanvas-custom-width.png' ),
				'offcanvas-half-width' => array('alt' => esc_html__( 'Offcanvas Half Width', 'impeka' ), 'img' => get_template_directory_uri() . '/includes/images/redux-panel/header-offcanvas/offcanvas-half-width.png' ),
				'offcanvas-full-width' => array('alt' => esc_html__( 'Offcanvas Full Width', 'impeka' ), 'img' => get_template_directory_uri() . '/includes/images/redux-panel/header-offcanvas/offcanvas-full-width.png' ),
			);

			$safebutton_icon_selection = array(
				'style-1' => array('alt' => esc_html__( 'Icon 1', 'impeka' ), 'img' => get_template_directory_uri() . '/includes/images/redux-panel/burger-icons/burger-icon-1.png' ),
				'style-2' => array('alt' => esc_html__( 'Icon 2', 'impeka' ), 'img' => get_template_directory_uri() . '/includes/images/redux-panel/burger-icons/burger-icon-2.png' ),
				'style-3' => array('alt' => esc_html__( 'Icon 3', 'impeka' ), 'img' => get_template_directory_uri() . '/includes/images/redux-panel/burger-icons/burger-icon-3.png' ),
				'style-4' => array('alt' => esc_html__( 'Icon 4', 'impeka' ), 'img' => get_template_directory_uri() . '/includes/images/redux-panel/burger-icons/burger-icon-4.png' ),
				'style-5' => array('alt' => esc_html__( 'Icon 5', 'impeka' ), 'img' => get_template_directory_uri() . '/includes/images/redux-panel/burger-icons/burger-icon-5.png' ),
				'style-6' => array('alt' => esc_html__( 'Icon 6', 'impeka' ), 'img' => get_template_directory_uri() . '/includes/images/redux-panel/burger-icons/burger-icon-6.png' ),
				'style-7' => array('alt' => esc_html__( 'Icon 7', 'impeka' ), 'img' => get_template_directory_uri() . '/includes/images/redux-panel/burger-icons/burger-icon-7.png' ),
				'style-8' => array('alt' => esc_html__( 'Icon 8', 'impeka' ), 'img' => get_template_directory_uri() . '/includes/images/redux-panel/burger-icons/burger-icon-8.png' ),
				'style-9' => array('alt' => esc_html__( 'Icon 9', 'impeka' ), 'img' => get_template_directory_uri() . '/includes/images/redux-panel/burger-icons/burger-icon-9.png' ),
				'custom' => array('alt' => esc_html__( 'Icon Custom', 'impeka' ), 'img' => get_template_directory_uri() . '/includes/images/redux-panel/burger-icons/burger-icon-custom.png' ),
			);

			$burger_icon_selection = array(
				'style-1' => array('alt' => esc_html__( 'Icon 1', 'impeka' ), 'img' => get_template_directory_uri() . '/includes/images/redux-panel/burger-icons/burger-icon-1.png' ),
				'style-2' => array('alt' => esc_html__( 'Icon 2', 'impeka' ), 'img' => get_template_directory_uri() . '/includes/images/redux-panel/burger-icons/burger-icon-2.png' ),
				'style-3' => array('alt' => esc_html__( 'Icon 3', 'impeka' ), 'img' => get_template_directory_uri() . '/includes/images/redux-panel/burger-icons/burger-icon-3.png' ),
				'style-4' => array('alt' => esc_html__( 'Icon 4', 'impeka' ), 'img' => get_template_directory_uri() . '/includes/images/redux-panel/burger-icons/burger-icon-4.png' ),
				'style-5' => array('alt' => esc_html__( 'Icon 5', 'impeka' ), 'img' => get_template_directory_uri() . '/includes/images/redux-panel/burger-icons/burger-icon-5.png' ),
			);

			$burger_icon_custom_selection = array(
				'style-1' => array('alt' => esc_html__( 'Icon 1', 'impeka' ), 'img' => get_template_directory_uri() . '/includes/images/redux-panel/burger-icons/burger-icon-1.png' ),
				'style-2' => array('alt' => esc_html__( 'Icon 2', 'impeka' ), 'img' => get_template_directory_uri() . '/includes/images/redux-panel/burger-icons/burger-icon-2.png' ),
				'style-3' => array('alt' => esc_html__( 'Icon 3', 'impeka' ), 'img' => get_template_directory_uri() . '/includes/images/redux-panel/burger-icons/burger-icon-3.png' ),
				'style-4' => array('alt' => esc_html__( 'Icon 4', 'impeka' ), 'img' => get_template_directory_uri() . '/includes/images/redux-panel/burger-icons/burger-icon-4.png' ),
				'style-5' => array('alt' => esc_html__( 'Icon 5', 'impeka' ), 'img' => get_template_directory_uri() . '/includes/images/redux-panel/burger-icons/burger-icon-5.png' ),
				'custom' => array('alt' => esc_html__( 'Icon Custom', 'impeka' ), 'img' => get_template_directory_uri() . '/includes/images/redux-panel/burger-icons/burger-icon-custom.png' ),
			);

			$spinner_icon_selection = array(
				'spinner-1' => array('alt' => esc_html__( 'Icon 1', 'impeka' ), 'img' => get_template_directory_uri() . '/includes/images/redux-panel/spinners/spinner-1.gif' ),
				'spinner-2' => array('alt' => esc_html__( 'Icon 2', 'impeka' ), 'img' => get_template_directory_uri() . '/includes/images/redux-panel/spinners/spinner-2.gif' ),
				'spinner-custom' => array('alt' => esc_html__( 'Icon Custom', 'impeka' ), 'img' => get_template_directory_uri() . '/includes/images/redux-panel/spinners/spinner-custom.png' ),
			);

			$footer_column_selection = array(
				'footer-1' => array('alt' => esc_html__( 'Footer 1', 'impeka' ), 'img' => get_template_directory_uri() . '/includes/images/redux-panel/footer/footer-1.png' ),
				'footer-2' => array('alt' => esc_html__( 'Footer 2', 'impeka' ), 'img' => get_template_directory_uri() . '/includes/images/redux-panel/footer/footer-2.png' ),
				'footer-3' => array('alt' => esc_html__( 'Footer 3', 'impeka' ), 'img' => get_template_directory_uri() . '/includes/images/redux-panel/footer/footer-3.png' ),
				'footer-4' => array('alt' => esc_html__( 'Footer 4', 'impeka' ), 'img' => get_template_directory_uri() . '/includes/images/redux-panel/footer/footer-4.png' ),
				'footer-5' => array('alt' => esc_html__( 'Footer 5', 'impeka' ), 'img' => get_template_directory_uri() . '/includes/images/redux-panel/footer/footer-5.png' ),
				'footer-6' => array('alt' => esc_html__( 'Footer 6', 'impeka' ), 'img' => get_template_directory_uri() . '/includes/images/redux-panel/footer/footer-6.png' ),
				'footer-7' => array('alt' => esc_html__( 'Footer 7', 'impeka' ), 'img' => get_template_directory_uri() . '/includes/images/redux-panel/footer/footer-7.png' ),
				'footer-8' => array('alt' => esc_html__( 'Footer 8', 'impeka' ), 'img' => get_template_directory_uri() . '/includes/images/redux-panel/footer/footer-8.png' ),
				'footer-9' => array('alt' => esc_html__( 'Footer 9', 'impeka' ), 'img' => get_template_directory_uri() . '/includes/images/redux-panel/footer/footer-9.png' ),
			);


			$text_color_selection = impeka_grve_admin_get_color_array( ['default', 'primary', 'standard'] );
			$transparent_text_color_selection = impeka_grve_admin_get_color_array( ['transparent', 'primary', 'standard'] );
			$overlay_color_selection = impeka_grve_admin_get_color_array( ['default', 'primary', 'gradient', 'standard'] );
			$dominant_overlay_color_selection = impeka_grve_admin_get_color_array( ['default', 'primary', 'gradient', 'standard', 'dominant'] );

			$overlay_opacity_selection = array(
				'default'  => 'Default',
				'0'  => '0%',
				'10' => '10%',
				'20' => '20%',
				'30' => '30%',
				'40' => '40%',
				'50' => '50%',
				'60' => '60%',
				'70' => '70%',
				'80' => '80%',
				'90' => '90%',
				'100'=> '100%',
			);
			$opacity_selection = array(
				'0'    => '0%',
				'0.05' => '5%',
				'0.10' => '10%',
				'0.15' => '15%',
				'0.20' => '20%',
				'0.25' => '25%',
				'0.30' => '30%',
				'0.35' => '35%',
				'0.40' => '40%',
				'0.45' => '45%',
				'0.50' => '50%',
				'0.55' => '55%',
				'0.60' => '60%',
				'0.65' => '65%',
				'0.70' => '70%',
				'0.75' => '75%',
				'0.80' => '80%',
				'0.85' => '85%',
				'0.90' => '90%',
				'0.95' => '95%',
				'1'    => '100%',
			);
			$ratio_selection = array(
				'0'    => '0%',
				'0.05' => '5%',
				'0.1'  => '10%',
				'0.15' => '15%',
				'0.2'  => '20%',
				'0.25' => '25%',
				'0.3'  => '30%',
				'0.35' => '35%',
				'0.4'  => '40%',
				'0.45' => '45%',
				'0.5'  => '50%',
				'0.55' => '55%',
				'0.6'  => '60%',
				'0.65' => '65%',
				'0.7'  => '70%',
				'0.75' => '75%',
				'0.8'  => '80%',
				'0.85'  => '85%',
				'0.9'  => '90%',
				'0.95' => '95%',
				'1'    => '100%',
			);

			$headings_tag_selection = array(
				'div' => 'div',
				'h2'  => 'h2',
				'h3'  => 'h3',
				'h4'  => 'h4',
				'h5'  => 'h5',
				'h6'  => 'h6',
			);

			$headings_selection = array(
				'h1'  => 'h1',
				'h2'  => 'h2',
				'h3'  => 'h3',
				'h4'  => 'h4',
				'h5'  => 'h5',
				'h6'  => 'h6',
				'leader-text' => esc_html__( 'Leader Text', 'impeka' ),
				'subtitle-text' => esc_html__( 'Subtitle Text', 'impeka' ),
				'small-text' => esc_html__( 'Small Text', 'impeka' ),
				'link-text' => esc_html__( 'Link Text', 'impeka' ),
			);

			$pattern_selection = array(
				'none' => esc_html__( 'No', 'impeka' ),
				'default' => esc_html__( 'Yes', 'impeka' ),
			);

			$padding_selection = array(
				'none' => esc_html__( 'None', 'impeka' ),
				'1x' => esc_html__( '1x', 'impeka' ),
				'2x' => esc_html__( '2x', 'impeka' ),
				'3x' => esc_html__( '3x', 'impeka' ),
				'4x' => esc_html__( '4x', 'impeka' ),
				'5x' => esc_html__( '5x', 'impeka' ),
				'6x' => esc_html__( '6x', 'impeka' ),
			);
			$padding_selection_extra = array(
				'none' => esc_html__( 'None', 'impeka' ),
				'1x' => esc_html__( '1x', 'impeka' ),
				'2x' => esc_html__( '2x', 'impeka' ),
				'3x' => esc_html__( '3x', 'impeka' ),
				'4x' => esc_html__( '4x', 'impeka' ),
				'5x' => esc_html__( '5x', 'impeka' ),
				'6x' => esc_html__( '6x', 'impeka' ),
				'custom' => esc_html__( 'Custom', 'impeka' ),
			);

			$content_size_selection = array(
				'container' => esc_html__( 'Container Size', 'impeka' ),
				'large' => esc_html__( 'Large', 'impeka' ),
				'medium' => esc_html__( 'Medium', 'impeka' ),
				'small' => esc_html__( 'Small', 'impeka' ),
			);

			$container_size_selection = array(
				'default' => esc_html__( 'Default', 'impeka' ),
				'large' => esc_html__( 'Large', 'impeka' ),
			);


			$border_radius_selection = array(
				'none' => esc_html__( 'None' , 'impeka' ),
				'3' => esc_html__( 'Radius 3px' , 'impeka' ),
				'5' => esc_html__( 'Radius 5px' , 'impeka' ),
				'10' => esc_html__( 'Radius 10px' , 'impeka' ),
				'15' => esc_html__( 'Radius 15px' , 'impeka' ),
				'20' => esc_html__( 'Radius 20px' , 'impeka' ),
				'25' => esc_html__( 'Radius 25px' , 'impeka' ),
				'30' => esc_html__( 'Radius 30px' , 'impeka' ),
				'35' => esc_html__( 'Radius 35px' , 'impeka' ),
			);

			$shadow_selection = array(
				'none' => esc_html__( 'None' , 'impeka' ),
				'small' => esc_html__( 'Small' , 'impeka' ),
				'medium' => esc_html__( 'Medium' , 'impeka' ),
				'large' => esc_html__( 'Large' , 'impeka' ),
			);

			$indicator_selection = array(
				'none' => esc_html__( 'None' , 'impeka' ),
				'arrow' => esc_html__( 'Arrow' , 'impeka' ),
				'plus' => esc_html__( 'Plus' , 'impeka' ),
				'text' => esc_html__( 'Text' , 'impeka' ),
			);

			//Standard Fonts
			$std_fonts = array(
				"Arial, Helvetica, sans-serif"                         => "Arial, Helvetica, sans-serif",
				"'Arial Black', Gadget, sans-serif"                    => "'Arial Black', Gadget, sans-serif",
				"'Bookman Old Style', serif"                           => "'Bookman Old Style', serif",
				"'Comic Sans MS', cursive"                             => "'Comic Sans MS', cursive",
				"Courier, monospace"                                   => "Courier, monospace",
				"Garamond, serif"                                      => "Garamond, serif",
				"Georgia, serif"                                       => "Georgia, serif",
				"Impact, Charcoal, sans-serif"                         => "Impact, Charcoal, sans-serif",
				"'Lucida Console', Monaco, monospace"                  => "'Lucida Console', Monaco, monospace",
				"'Lucida Sans Unicode', 'Lucida Grande', sans-serif"   => "'Lucida Sans Unicode', 'Lucida Grande', sans-serif",
				"'MS Sans Serif', Geneva, sans-serif"                  => "'MS Sans Serif', Geneva, sans-serif",
				"'MS Serif', 'New York', sans-serif"                   => "'MS Serif', 'New York', sans-serif",
				"'Palatino Linotype', 'Book Antiqua', Palatino, serif" => "'Palatino Linotype', 'Book Antiqua', Palatino, serif",
				"Tahoma,Geneva, sans-serif"                            => "Tahoma, Geneva, sans-serif",
				"'Times New Roman', Times,serif"                       => "'Times New Roman', Times, serif",
				"'Trebuchet MS', Helvetica, sans-serif"                => "'Trebuchet MS', Helvetica, sans-serif",
				"Verdana, Geneva, sans-serif"                          => "Verdana, Geneva, sans-serif",
			);
			$std_fonts = apply_filters( 'impeka_grve_std_fonts', $std_fonts );

			$feature_section_post_types_selection = array(
				'page'   => esc_html__( 'Pages', 'impeka' ),
				'portfolio'   => esc_html__( 'Portfolio Items', 'impeka' ),
				'post'   => esc_html__( 'Posts', 'impeka' ),
				'product'   => esc_html__( 'Products', 'impeka' ),
				'tribe_events'   => esc_html__( 'Events', 'impeka' ),
			);

			$container_size_selector = array(
				'container' => esc_html__( 'Container Size' , 'impeka' ),
				'large' => esc_html__( 'Large' , 'impeka' ),
				'medium' => esc_html__( 'Medium' , 'impeka' ),
				'small' => esc_html__( 'Small' , 'impeka' ),
			);

			$regenerate_link = '<a href="//wordpress.org/plugins/regenerate-thumbnails/" target="_blank" rel="noopener noreferrer">' . esc_html__( 'regenerate your thumbnails', 'impeka' ) . '</a>';
			$gmap_api_key_link = '<a href="//developers.google.com/maps/documentation/javascript/get-api-key" target="_blank" rel="noopener noreferrer">' . esc_html__( 'Generate Google Map API Key', 'impeka' ) . '</a>';
			$gmap_style_link = '<a href="//mapstyle.withgoogle.com/" target="_blank" rel="noopener noreferrer">' . esc_html__( 'Styling Wizard Google Maps API.', 'impeka' ) . '</a>';

			$is_google = apply_filters( 'impeka_grve_gfonts_visibility', true );
			// ACTUAL DECLARATION OF SECTIONS
			$this->sections[] = array(
				'title' => esc_html__( 'Theme & Header Options', 'impeka' ),
				'id' => 'grve_redux_section_theme_builder',
				'header' => '',
				'desc' => esc_html__( 'Here you can define your preferences for Theme and Header Layout (Header, Menu and Menu Elements). Notice that most of the options below depend on the specific Theme and Header layout you will select.', 'impeka' ),
				'icon_class' => 'el-icon-large',
				'icon' => 'el-icon-screen',
				'submenu' => true,
				'customizer' => false,
				'fields' => array(
					array(
						'id' => 'theme_layout',
						'type' => 'image_select',
						'compiler' => true,
						'title' => esc_html__( 'Theme Layout', 'impeka' ),
						'subtitle'=> esc_html__( 'Select among Streched, Boxed ot Framed for the theme basic Layout.', 'impeka' ),
						'options' => $theme_layouts_selection,
						'default' => 'stretched',
					),
					array(
						'id' => 'boxed_size',
						'type' => 'text',
						'default' => '1440',
						'title' => esc_html__( 'Theme Wrapper Size', 'impeka' ),
						'subtitle' => esc_html__( 'Enter the Theme Wrapper width in px (Default is 1440).', 'impeka' ),
						'validate' => 'numeric',
						'required' => array( 'theme_layout', 'equals', 'boxed' ),
					),
					array(
						'id' => 'frame_size',
						'type' => 'slider',
						'default' => 30,
						"min"       => 10,
						"step"      => 5,
						"max"       => 200,
						'display_value' => 'text',
						'title' => esc_html__( 'Frame Size', 'impeka' ),
						'subtitle' => esc_html__( 'Enter frame size in px (Default is 30).', 'impeka' ),
						'required' => array( 'theme_layout', 'equals', 'framed' ),
					),
					array(
						'id'          => 'frame_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Frame Color', 'impeka' ),
						'subtitle'    => esc_html__( 'Select a color for the framed layout.', 'impeka' ),
						'default'     => '#ffffff',
						'required' => array( 'theme_layout', 'equals', 'framed' ),
						'transparent' => false,
					),
					array(
						'id' => 'container_size',
						'type' => 'slider',
						'default' => 1170,
						"min"       => 900,
						"step"      => 10,
						"max"       => 2500,
						'display_value' => 'text',
						'title' => esc_html__( 'Container Size', 'impeka' ),
						'subtitle' => esc_html__( 'Enter the Container width in px (Default is 1170).', 'impeka' ),
					),
					array(
						'id' => 'sidebar_size',
						'type' => 'slider',
						'class' => 'grve-redux-group grve-redux-first',
						'default' => 25,
						"min"       => 10,
						"step"      => 5,
						"max"       => 50,
						'display_value' => 'text',
						'title' => esc_html__( 'Sidebar Size', 'impeka' ),
						'subtitle' => esc_html__( 'Enter the Sidebar width in % (Default is 25%).', 'impeka' ),
					),
					array(
						'id' => 'content_sidebar_space',
						'type' => 'slider',
						'class' => 'grve-redux-group grve-redux-last',
						'default' => 60,
						"min"       => 0,
						"step"      => 5,
						"max"       => 120,
						'display_value' => 'text',
						'title' => esc_html__( 'Content Sidebar Space', 'impeka' ),
						'subtitle' => esc_html__( 'Enter the Space between Content and Sibar in px (Default is 60).', 'impeka' ),
					),
					array(
						'id' => 'header_layout',
						'type' => 'image_select',
						'compiler' => true,
						'title' => esc_html__( 'Header Layout', 'impeka' ),
						'subtitle'=> esc_html__( 'Select your Header Layout. Keep in mind that this is one of the most important options for the appearance of your site. Your selection here will determine the following section options.', 'impeka' ),
						'options' => $header_layouts_selection,
						'default' => 'layout-default-style-1',
					),
					array(
						'id'             => 'header_spacing',
						'type'           => 'spacing',
						'mode'           => 'padding',
						'units'          => 'px',
						'units_extended' => 'false',
						'left'           => 'false',
						'right'          => 'false',
						'title'          => esc_html__( 'Header Spacing', 'impeka' ),
						'subtitle'       => esc_html__( 'Set the spacing, Top and Bottom, of the Header.', 'impeka' ),
						'desc'           => esc_html__( 'Set spacing Top, Bottom in px.', 'impeka'),
						'default'        => array(
							'padding-top'     => '30px',
							'padding-bottom'  => '30px',
							'units'           => 'px',
						),
						'required' => array(
							'header_layout', 'equals', array(
								'layout-default-style-1',
								'layout-default-style-2',
								'layout-default-style-4',
								'layout-offcanvas-style-1',
								'layout-offcanvas-style-3',
							)
						)
					),
					array(
						'id' => 'header_side_width',
						'type' => 'slider',
						'default' => 300,
						"min"       => 50,
						"step"      => 1,
						"max"       => 600,
						'display_value' => 'text',
						'title' => esc_html__( 'Header Width', 'impeka' ),
						'subtitle' => esc_html__( 'Enter the Header Width in px (Default is 300).', 'impeka' ),
						'required' => array(
							'header_layout', 'equals', array(
								'layout-side-style-1',
								'layout-offcanvas-style-2',
							)
						)
					),
					array(
						'id' => 'header_top_bottom_align',
						'type' => 'image_select',
						'compiler' => true,
						'title' => esc_html__( 'Header Alignment', 'impeka' ),
						'subtitle'=> esc_html__( 'Align your header.', 'impeka' ),
						'options' => $top_bottom_header_align_selection,
						'default' => 'center',
						'required' => array(
							'header_layout', 'equals', array(
								'layout-top-bottom-style-1',
							)
						)
					),
					array(
						'id' => 'header_text_1', //translatable
						'type' => 'editor',
						'args' => array ( 'wpautop' => false ),
						'title' => esc_html__( 'Header Text 1', 'impeka' ),
						'subtitle' => esc_html__( 'Type your text or anything else you want.', 'impeka' ),
						'default' => '',
						'required' => array( 'header_top_bottom_align', 'equals', 'left' ),
					),
					array(
						'id' => 'header_text_2', //translatable
						'type' => 'editor',
						'args' => array ( 'wpautop' => false ),
						'title' => esc_html__( 'Header Text 2', 'impeka' ),
						'subtitle' => esc_html__( 'Type your text or anything else you want.', 'impeka' ),
						'default' => '',
						'required' => array( 'header_top_bottom_align', 'equals', 'left' ),
					),
					array(
						'id'             => 'header_top_spacing',
						'type'           => 'spacing',
						'mode'           => 'padding',
						'units'          => 'px',
						'units_extended' => 'false',
						'left'           => 'false',
						'right'          => 'false',
						'title'          => esc_html__( 'Header Top Area Spacing', 'impeka' ),
						'subtitle'       => esc_html__( 'Set the spacing, Top and Bottom, of the Top Area.', 'impeka' ),
						'desc'           => esc_html__( 'Set spacing Top, Bottom in px.', 'impeka'),
						'default'        => array(
							'padding-top'     => '30px',
							'padding-bottom'  => '30px',
							'units'           => 'px',
						),
						'required' => array(
							'header_layout', 'equals', array(
								'layout-top-bottom-style-1',
							)
						)
					),
					array(
						'id'             => 'header_bottom_spacing',
						'type'           => 'spacing',
						'mode'           => 'padding',
						'units'          => 'px',
						'units_extended' => 'false',
						'left'           => 'false',
						'right'          => 'false',
						'title'          => esc_html__( 'Header Bottom Area Spacing', 'impeka' ),
						'subtitle'       => esc_html__( 'Set the spacing, Top and Bottom, of the Bottom Area.', 'impeka' ),
						'desc'           => esc_html__( 'Set spacing Top, Bottom in px.', 'impeka'),
						'default'        => array(
							'padding-top'     => '10px',
							'padding-bottom'  => '10px',
							'units'           => 'px',
						),
						'required' => array(
							'header_layout', 'equals', array(
								'layout-top-bottom-style-1',
							)
						)
					),
					array(
						'id' => 'logo_height',
						'type' => 'slider',
						'default' => 30,
						"min"       => 1,
						"step"      => 1,
						"max"       => 250,
						'display_value' => 'text',
						'title' => esc_html__( 'Logo Height', 'impeka' ),
						'subtitle' => esc_html__( 'Enter the Logo height in px.', 'impeka' ),
					),
					array(
						'id' => 'logo_small_screens_height',
						'type' => 'slider',
						'default' => 30,
						"min"       => 1,
						"step"      => 1,
						"max"       => 250,
						'display_value' => 'text',
						'title' => esc_html__( 'Logo Smaller Screens Height', 'impeka' ),
						'subtitle' => esc_html__( 'Enter the Logo height in px for screens (1024 - 1200).', 'impeka' ),
					),
					array(
						'id'             => 'header_side_logo_spacing',
						'type'           => 'spacing',
						'mode'           => 'padding',
						'units'          => array('em', 'px', '%'),
						'units_extended' => 'false',
						'left'           => 'false',
						'right'          => 'false',
						'title'          => esc_html__( 'Logo Spacing', 'impeka' ),
						'subtitle'       => esc_html__( 'Set the spacings of the Logo.', 'impeka' ),
						'desc'           => esc_html__( 'Set spacing Top, Bottom in px.', 'impeka'),
						'default'        => array(
							'padding-top'     => '100px',
							'padding-bottom'  => '100px',
							'units'           => 'px',
						),
						'required' => array(
							'header_layout', 'equals', array(
								'layout-side-style-1',
								'layout-offcanvas-style-2',
							)
						)
					),
					array(
						'id' => 'header_side_align',
						'type' => 'image_select',
						'compiler' => true,
						'title' => esc_html__( 'Header Content Alignment', 'impeka' ),
						'subtitle'=> esc_html__( 'Align your Header Content as you wish.', 'impeka' ),
						'options' => $side_header_alignments_selection,
						'default' => 'center',
						'required' => array( 'header_layout', 'equals', 'layout-side-style-1' ),
					),
					array(
						'id'             => 'header_side_spacing',
						'type'           => 'spacing',
						'mode'           => 'padding',
						'units'          => 'px',
						'units_extended' => 'false',
						'top'            => 'false',
						'bottom'         => 'false',
						'title'          => esc_html__( 'Header Content Spacing', 'impeka' ),
						'subtitle'       => esc_html__( 'Set the spacings for the content of the Header.', 'impeka' ),
						'desc'           => esc_html__( 'Set spacing Right, Left in px.', 'impeka'),
						'default'        => array(
							'padding-left'     => '36px',
							'padding-right'  => '36px',
							'units'           => 'px',
						),
						'required' => array( 'header_layout', 'equals', 'layout-side-style-1' ),
					),
					array(
						'id'       => 'header_side_bg_mode',
						'type'     => 'select',
						'title' => esc_html__( 'Background Mode', 'impeka' ),
						'subtitle'=> esc_html__( 'Select the Header Background, Color or Image.', 'impeka' ),
						'options' => $title_bg_mode_limited,
						'default'  => 'color',
						'required' => array( 'header_layout', 'equals', 'layout-side-style-1' ),
					),
					array(
						'id'       => 'header_side_bg_image',
						'type'     => 'media',
						'title' => esc_html__( 'Background Image', 'impeka' ),
						'subtitle' => esc_html__( 'Select a background image for the header.', 'impeka' ),
						'required' => array(
							array( 'header_layout', 'equals', 'layout-side-style-1' ),
							array( 'header_side_bg_mode', 'equals', 'custom' ),
						),
					),
					array(
						'id' => 'header_side_bg_position',
						'type' => 'select',
						'title' => esc_html__( 'Background Position', 'impeka' ),
						'options' => $align_selection_full,
						'default' => 'center-center',
						'validate' => 'not_empty',
						'required' => array(
							array( 'header_layout', 'equals', 'layout-side-style-1' ),
							array( 'header_side_bg_mode', 'equals', 'custom' ),
						),
					),
					array(
						'id' => 'header_side_pattern_overlay',
						'type' => 'select',
						'title' => esc_html__( 'Pattern Overlay', 'impeka' ),
						'options' => $pattern_selection,
						'default' => 'none',
						'required' => array(
							array( 'header_layout', 'equals', 'layout-side-style-1' ),
							array( 'header_side_bg_mode', 'equals', 'custom' ),
						),
					),
					array(
						'id' => 'header_side_color_overlay',
						'type' => 'select',
						'title' => esc_html__( 'Color Overlay', 'impeka' ),
						'options' => $color_selection,
						'default' => 'black',
						'required' => array(
							array( 'header_layout', 'equals', 'layout-side-style-1' ),
							array( 'header_side_bg_mode', 'equals', 'custom' ),
						),
					),
					array(
						'id' => 'header_side_opacity_overlay',
						'type' => 'slider',
						'default' => .50,
						"min"       => .05,
						"step"      => .05,
						"max"       => .95,
						'resolution' => 0.01,
						'display_value' => 'text',
						'title' => esc_html__( 'Opacity Overlay', 'impeka' ),
						'required' => array(
							array( 'header_layout', 'equals', 'layout-side-style-1' ),
							array( 'header_side_bg_mode', 'equals', 'custom' ),
						),
					),
					array(
						'id' => 'header_sticky_type',
						'type' => 'image_select',
						'title' => esc_html__( 'Sticky Header Type', 'impeka' ),
						'subtitle'=> esc_html__( 'Select the type of the Sticky Header.', 'impeka' ),
						'options' => $header_sticky_selection,
						'default' => 'none',
						'validate' => 'not_empty',
						'required' => array(
							array( 'header_layout','!=', 'layout-side-style-1' ),
							array( 'header_layout','!=', 'layout-offcanvas-style-2' ),
						),
					),
					array(
						'id'             => 'header_sticky_shrink_spacing',
						'type'           => 'spacing',
						'mode'           => 'padding',
						'units'          => 'px',
						'units_extended' => 'false',
						'left'           => 'false',
						'right'          => 'false',
						'title'          => esc_html__( 'Header Shrink Spacing', 'impeka' ),
						'subtitle'       => esc_html__( 'Set the spacing, Top and Bottom, of the Header Shrink.', 'impeka' ),
						'desc'           => esc_html__( 'Set spacing Top, Bottom in px.', 'impeka'),
						'default'        => array(
							'padding-top'     => '15px',
							'padding-bottom'  => '15px',
							'units'           => 'px',
						),
						'required' => array(
							'header_sticky_type', 'equals', array(
								'shrink',
								'scrollup',
							)
						)
					),
					array(
						'id' => 'header_sticky_shrink_logo_height',
						'type' => 'slider',
						'default' => 18,
						"min"       => 1,
						"step"      => 1,
						"max"       => 250,
						'display_value' => 'text',
						'title' => esc_html__( 'Logo Shrink Height', 'impeka' ),
						'subtitle' => esc_html__( 'Enter the shrink height for the Logo in px.', 'impeka' ),
						'required' => array(
							'header_sticky_type', 'equals', array(
								'shrink',
								'scrollup',
							)
						)
					),
					array(
						'id'=>'header_sticky_mode',
						'type' => 'select',
						'title' => esc_html__( 'Header Sticky Mode', 'impeka' ),
						'subtitle'=> esc_html__( 'Select the mode of the Sticky Header.', 'impeka' ),
						'options' => array(
							'custom' => esc_html__( 'Use Custom Header Sticky', 'impeka' ),
							'main-header' => esc_html__( 'Use Main Header as Sticky', 'impeka' ),
						),
						"default" => 'custom',
						'required' => array(
							array( 'header_sticky_type','!=', 'none' ),
						),
					),
					array(
						'id'=>'header_fullwidth',
						'type' => 'switch',
						'title' => esc_html__( 'Full Width', 'impeka' ),
						'subtitle'=> esc_html__( 'Enable if you want to have full width Header.', 'impeka' ),
						"default" => '0',
						'0' => esc_html__( 'On', 'impeka' ),
						'1' => esc_html__( 'Off', 'impeka' ),
						'required' => array(
							array( 'header_layout','!=', 'layout-default-style-2' ),
							array( 'header_layout','!=', 'layout-side-style-1' ),
							array( 'header_layout','!=', 'layout-offcanvas-style-2' ),
							array( 'header_sticky_type','!=', 'vertical-animation' ),
						),
					),
					array(
						'id'=>'header_borders',
						'type' => 'switch',
						'title' => esc_html__( 'Add Header Borders', 'impeka' ),
						'subtitle'=> esc_html__( 'Enable if you want to have borders to your Header.', 'impeka' ),
						"default" => '0',
						'0' => esc_html__( 'On', 'impeka' ),
						'1' => esc_html__( 'Off', 'impeka' ),
					),
					array(
						'id'   => 'info_menu_options',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Menu Options', 'impeka' ),
					),
					array(
						'id'=>'header_menu_enabled',
						'type' => 'switch',
						'title' => esc_html__( 'Header Menu Visibility', 'impeka' ),
						'subtitle'=> esc_html__( 'Enable or disable the main menu.', 'impeka' ),
						"default" => '1',
					),
					array(
						'id' => 'header_menu_align',
						'type' => 'image_select',
						'compiler' => true,
						'title' => esc_html__( 'Menu Alignment', 'impeka' ),
						'subtitle'=> esc_html__( 'Align your menu.', 'impeka' ),
						'options' => $default_header_menu_align_selection,
						'default' => 'right',
						'required' => array(
							array('header_menu_enabled', '!=', '0'),
							array('header_layout', 'equals', 'layout-default-style-1'),
						),
					),
					array(
						'id' => 'menu_item_style',
						'type' => 'select',
						'title' => esc_html__( 'Menu Item Style', 'impeka' ),
						'subtitle'=> esc_html__( 'Select the style of the Main Menu Items.', 'impeka' ),
						'options' => array(
							'classic' => esc_html__( 'Classic', 'impeka' ),
							'underline' => esc_html__( 'Underline', 'impeka' ),
							'underline-first-level' => esc_html__( 'Underline First level Current Included', 'impeka' ),
							'line-through' => esc_html__( 'Line Through', 'impeka' ),
						),
						'default' => 'classic',
						'validate' => 'not_empty',
						'required' => array(
							array('header_menu_enabled', '!=', '0'),
							array('header_layout', '!=', 'layout-offcanvas-style-2'),
							array('header_layout', '!=', 'layout-offcanvas-style-1'),
							array('header_layout', '!=', 'layout-offcanvas-style-3'),
						),
					),
					array(
						'id' => 'submenu_pointer',
						'type' => 'select',
						'class' => 'grve-redux-group grve-redux-first',
						'title' => esc_html__( 'Sub Menu Pointer', 'impeka' ),
						'subtitle'=> esc_html__( 'Choose pointer for the submenu.', 'impeka' ),
						'options' => $menu_pointers,
						'default' => 'none',
						'validate' => 'not_empty',
						'required' => array(
							array('header_menu_enabled', '!=', '0'),
							array('header_layout', '!=', 'layout-side-style-1'),
							array('header_layout', '!=', 'layout-offcanvas-style-2'),
							array('header_layout', '!=', 'layout-offcanvas-style-1'),
							array('header_layout', '!=', 'layout-offcanvas-style-3'),
						),
					),
					array(
						'id' => 'submenu_top_position',
						'type' => 'text',
						'class' => 'grve-redux-group grve-redux-last',
						'default' => '0',
						'title' => esc_html__( 'Sub Menu Position', 'impeka' ),
						'subtitle' => esc_html__( 'Define the distance between the top position of the Submenu and the bottom of the Header in px. (Default is 0 - Submenu starts at the bottom of the Header).', 'impeka' ),
						'validate' => 'numeric',
						'required' => array(
							array('header_menu_enabled', '!=', '0'),
							array('header_layout', '!=', 'layout-side-style-1'),
							array('header_layout', '!=', 'layout-offcanvas-style-2'),
							array('header_layout', '!=', 'layout-offcanvas-style-1'),
							array('header_layout', '!=', 'layout-offcanvas-style-3'),
						),
					),
					array(
						'id' => 'menu_item_space',
						'type' => 'slider',
						'default' => 36,
						"min"       => 5,
						"step"      => 1,
						"max"       => 100,
						'display_value' => 'text',
						'title' => esc_html__( 'Menu Item Spacing', 'impeka' ),
						'subtitle' => esc_html__( 'Set the space that will display on each side of your header menu items - space will be set in pixels.', 'impeka' ),
						'required' => array(
							array('header_menu_enabled', '!=', '0'),
						),
					),
					array(
						'id'=>'submenu_animation',
						'type' => 'switch',
						'title' => esc_html__( 'Sub Menu Animation', 'impeka' ),
						'subtitle'=> esc_html__( 'Enable or Disable the animation of the sub menu.', 'impeka' ),
						"default" => '0',
						'required' => array(
							array('header_menu_enabled', '!=', '0'),
							array('header_layout', '!=', 'layout-side-style-1'),
							array('header_layout', '!=', 'layout-offcanvas-style-2'),
							array('header_layout', '!=', 'layout-offcanvas-style-1'),
							array('header_layout', '!=', 'layout-offcanvas-style-3'),
						),
					),
					array(
						'id'=>'megamenu_change_header_skin',
						'type' => 'select',
						'title' => esc_html__( 'Header Skin on hover', 'impeka' ),
						'subtitle'=> esc_html__( 'Select your header skin on hover when your megamenu is open.', 'impeka' ),
						'options' => array(
							'none' => esc_html__( 'None', 'impeka' ),
							'default' => esc_html__( 'Default', 'impeka' ),
							'dark' => esc_html__( 'Dark', 'impeka' ),
							'light' => esc_html__( 'Light', 'impeka' ),
							'sticky' => esc_html__( 'Sticky', 'impeka' ),
						),
						"default" => 'none',
						'required' => array(
							array('header_menu_enabled', '!=', '0'),
							array('header_layout', '!=', 'layout-side-style-1'),
							array('header_layout', '!=', 'layout-offcanvas-style-2'),
							array('header_layout', '!=', 'layout-offcanvas-style-1'),
							array('header_layout', '!=', 'layout-offcanvas-style-3'),
						),
					),
					array(
						'id' => 'offcanvas_width',
						'type' => 'image_select',
						'compiler' => true,
						'title' => esc_html__( 'Offcanvas Menu Width', 'impeka' ),
						'subtitle'=> esc_html__( 'Select the width for your off canvas menu.', 'impeka' ),
						'options' => $offcanvas_width_selection,
						'default' => 'offcanvas-custom-width',
						'required' => array(
							array('header_menu_enabled', '!=', '0'),
							array(
								'header_layout', 'equals', array(
									'layout-offcanvas-style-1',
									'layout-offcanvas-style-2',
								),
							),
						),
					),
					array(
						'id' => 'offcanvas_custom_width',
						'type' => 'slider',
						'default' => 350,
						"min"       => 100,
						"step"      => 5,
						"max"       => 1024,
						'display_value' => 'text',
						'title' => esc_html__( 'Offcanvas Menu Custom Width', 'impeka' ),
						'subtitle' => esc_html__( 'Enter the offcanvas menu width in px.', 'impeka' ),
						'required' => array( 'offcanvas_width', 'equals', 'offcanvas-custom-width' ),
					),
					array(
						'id' => 'offcanvas_content_width',
						'type' => 'slider',
						'default' => 500,
						"min"       => 100,
						"step"      => 1,
						"max"       => 2048,
						'display_value' => 'text',
						'title' => esc_html__( 'Offcanvas Content Width', 'impeka' ),
						'subtitle' => esc_html__( 'Enter the offcanvas content width in px.', 'impeka' ),
						'required' => array(
							array('header_menu_enabled', '!=', '0'),
							array(
								'header_layout', 'equals', array(
									'layout-offcanvas-style-1',
									'layout-offcanvas-style-2',
									'layout-offcanvas-style-3',
								),
							),
						),
					),
					array(
						'id' => 'offcanvas_position',
						'type' => 'select',
						'compiler' => true,
						'title' => esc_html__( 'Offcanvas Position', 'impeka' ),
						'subtitle' => esc_html__( 'Select your offcanvas position.', 'impeka' ),
						'options' => array(
							'left' => esc_html__( 'Left', 'impeka' ),
							'right' => esc_html__( 'Right', 'impeka' ),
						),
						'default' => 'left',
						'validate' => 'not_empty',
						'required' => array( 'offcanvas_width', '!=', 'offcanvas-full-width' ),
					),
					array(
						'id' => 'offcanvas_content_position',
						'type' => 'select',
						'compiler' => true,
						'title' => esc_html__( 'Offcanvas Content Position', 'impeka' ),
						'subtitle' => esc_html__( 'Select your offcanvas content position.', 'impeka' ),
						'options' => array(
							'left' => esc_html__( 'Left', 'impeka' ),
							'center' => esc_html__( 'Center', 'impeka' ),
							'right' => esc_html__( 'Right', 'impeka' ),
						),
						'default' => 'left',
						'validate' => 'not_empty',
						'required' => array(
							array('header_menu_enabled', '!=', '0'),
							array(
								'header_layout', 'equals', array(
									'layout-offcanvas-style-1',
									'layout-offcanvas-style-2',
									'layout-offcanvas-style-3',
								),
							),
						),
					),
					array(
						'id' => 'offcanvas_content_alignment',
						'type' => 'select',
						'compiler' => true,
						'title' => esc_html__( 'Offcanvas Content Alignment', 'impeka' ),
						'subtitle' => esc_html__( 'Select your offcanvas content alignment.', 'impeka' ),
						'options' => array(
							'left' => esc_html__( 'Left', 'impeka' ),
							'center' => esc_html__( 'Center', 'impeka' ),
							'right' => esc_html__( 'Right', 'impeka' ),
						),
						'default' => 'left',
						'validate' => 'not_empty',
						'required' => array(
							array('header_menu_enabled', '!=', '0'),
							array(
								'header_layout', 'equals', array(
									'layout-offcanvas-style-1',
									'layout-offcanvas-style-2',
									'layout-offcanvas-style-3',
								),
							),
						),
					),
					array(
						'id' => 'offcanvas_button_type',
						'type' => 'select',
						'compiler' => true,
						'title' => esc_html__( 'Offcanvas Button', 'impeka' ),
						'subtitle' => esc_html__( 'Select your offcanvas button type.', 'impeka' ),
						'options' => array(
							'icon' => esc_html__( 'Icon Only', 'impeka' ),
							'label' => esc_html__( 'Label Only', 'impeka' ),
							'icon-label' => esc_html__( 'Icon & Label', 'impeka' ),
						),
						'default' => 'icon',
						'validate' => 'not_empty',
						'required' => array(
							array('header_menu_enabled', '!=', '0'),
							array(
								'header_layout', 'equals', array(
									'layout-offcanvas-style-1',
									'layout-offcanvas-style-2',
									'layout-offcanvas-style-3',
								),
							),
						),
					),
					array(
						'id' => 'offcanvas_button_label',
						'type' => 'text',
						'title' => esc_html__( 'Offcanvas Button Label', 'impeka' ),
						'subtitle' => esc_html__( 'Enter the label for your offcanvas menu button.', 'impeka' ),
						'default' => 'Menu',
						'validate' => 'not_empty',
						'required' => array(
							'offcanvas_button_type', 'equals', array(
								'label',
								'icon-label',
							)
						)
					),
					array(
						'id' => 'offcanvas_icon_style',
						'type' => 'image_select',
						'compiler' => true,
						'title' => esc_html__( 'Offcanvas Icon', 'impeka' ),
						'subtitle'=> esc_html__( 'Select the icon for your off canvas menu.', 'impeka' ),
						'options' => $burger_icon_selection,
						'default' => 'style-1',
						'class' => 'small-image-selector',
						'required' => array(
							array( 'header_icon_library', 'equals', 'theme-icons' ),
							array( 'offcanvas_button_type', 'equals', array( 'icon', 'icon-label' ) ),
						),
					),
					array(
						'id' => 'offcanvas_animation',
						'type' => 'select',
						'compiler' => true,
						'title' => esc_html__( 'Offcanvas Animation', 'impeka' ),
						'subtitle' => esc_html__( 'Select your offcanvas animation.', 'impeka' ),
						'options' => array(
							'left-to-right' => esc_html__( 'Left to Right', 'impeka' ),
							'right-to-left' => esc_html__( 'Right to Left', 'impeka' ),
							'top-to-bottom' => esc_html__( 'Top to Bottom', 'impeka' ),
							'bottom-to-top' => esc_html__( 'Bottom to Top', 'impeka' ),
							'fade-in' => esc_html__( 'Fade In', 'impeka' ),
						),
						'default' => 'left-to-right',
						'validate' => 'not_empty',
						'required' => array(
							array('header_menu_enabled', '!=', '0'),
							array(
								'header_layout', 'equals', array(
									'layout-offcanvas-style-1',
									'layout-offcanvas-style-2',
								),
							),
						),
					),
					array(
						'id' => 'offcanvas_menu_items_animation',
						'type' => 'select',
						'compiler' => true,
						'title' => esc_html__( 'Offcanvas Menu Items Animation', 'impeka' ),
						'subtitle' => esc_html__( 'Select your offcanvas menu items animation.', 'impeka' ),
						'options' => array(
							'none' => esc_html__( 'None', 'impeka' ),
							'left-to-right' => esc_html__( 'Left to Right', 'impeka' ),
							'right-to-left' => esc_html__( 'Right to Left', 'impeka' ),
							'top-to-bottom' => esc_html__( 'Top to Bottom', 'impeka' ),
							'bottom-to-top' => esc_html__( 'Bottom to Top', 'impeka' ),
							'fade-in' => esc_html__( 'Fade In', 'impeka' ),
						),
						'default' => 'fade-in',
						'validate' => 'not_empty',
						'required' => array(
							array('header_menu_enabled', '!=', '0'),
							array(
								'header_layout', 'equals', array(
									'layout-offcanvas-style-1',
									'layout-offcanvas-style-2',
									'layout-offcanvas-style-3',
								),
							),
						),
					),
					array(
						'id'       => 'offcanvas_menu_bg_mode',
						'type'     => 'select',
						'title' => esc_html__( 'Offcanvas Menu Background Mode', 'impeka' ),
						'subtitle'=> esc_html__( 'Select the Offcanvas Menu Background, Color or Image.', 'impeka' ),
						'options' => $title_bg_mode_limited,
						'default'  => 'color',
						'required' => array(
							array('header_menu_enabled', '!=', '0'),
							array(
								'header_layout', 'equals', array(
									'layout-offcanvas-style-1',
									'layout-offcanvas-style-2',
									'layout-offcanvas-style-3',
								),
							),
						),
					),
					array(
						'id' => 'offcanvas_menu_background_image',
						'type' => 'background',
						'title' => esc_html__( 'Offcanvas Menu Image', 'impeka' ),
						'subtitle' => esc_html__( 'Select a background image or color for your offcanvas menu.', 'impeka' ),
						'background-color' => false,
						'transparent' => false,
						'background-repeat' => true,
						'background-attachment' => true,
						'background-clip' => false,
						'background-size' => true,
						'required' => array( 'offcanvas_menu_bg_mode', 'equals', 'custom' ),
					),
					array(
						'id' => 'header_menu_open_type',
						'type' => 'select',
						'compiler' => true,
						'title' => esc_html__( 'Menu Animation Type', 'impeka' ),
						'subtitle' => esc_html__( 'Select your menu animation type.', 'impeka' ),
						'options' => array(
							'toggle' => esc_html__( 'Toggle', 'impeka' ),
							'accordion' => esc_html__( 'Accordion', 'impeka' ),
							'slide' => esc_html__( 'Slide', 'impeka' ),
						),
						'default' => 'toggle',
						'validate' => 'not_empty',
						'required' => array(
							array('header_menu_enabled', '!=', '0'),
							array(
								'header_layout', 'equals', array(
									'layout-side-style-1',
									'layout-offcanvas-style-1',
									'layout-offcanvas-style-2',
									'layout-offcanvas-style-3',
								),
							),
						),
					),
					array(
						'id' => 'offcanvas_menu_item_style',
						'type' => 'select',
						'title' => esc_html__( 'Menu Item Style', 'impeka' ),
						'subtitle'=> esc_html__( 'Select the style of the Offcanvas Menu Items.', 'impeka' ),
						'options' => array(
							'classic' => esc_html__( 'Classic', 'impeka' ),
							'underline' => esc_html__( 'Underline', 'impeka' ),
							'line-through' => esc_html__( 'Line Through', 'impeka' ),
						),
						'default' => 'classic',
						'validate' => 'not_empty',
						'required' => array(
							array('header_menu_enabled', '!=', '0'),
							array(
								'header_layout', 'equals', array(
									'layout-offcanvas-style-1',
									'layout-offcanvas-style-2',
									'layout-offcanvas-style-3',
								),
							),
						),
					),
					array(
						'id' => 'offcanvas_text', //translatable
						'type' => 'editor',
						'args' => array ( 'wpautop' => false ),
						'title' => esc_html__( 'Offcanvas Menu Text', 'impeka' ),
						'subtitle' => esc_html__( 'Type your text or anything else you want.', 'impeka' ),
						'default' => '',
						'required' => array(
							array('header_menu_enabled', '!=', '0'),
							array(
								'header_layout', 'equals', array(
									'layout-offcanvas-style-1',
									'layout-offcanvas-style-2',
									'layout-offcanvas-style-3',
								),
							),
						),
					),
					array(
						'id'   => 'info_menu_elements',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Menu Elements Options', 'impeka' ),
					),
					array(
						'id'=>'header_menu_options_enabled',
						'type' => 'switch',
						'title' => esc_html__( 'Menu Elements', 'impeka' ),
						'subtitle'=> esc_html__( 'Enable or disable the use of various elements in your header like socials, search, language selector and Contact Form.', 'impeka' ),
						"default" => '0',
					),
					array(
						'id' => 'header_menu_options',
						'type' => 'sortable',
						'mode' => 'checkbox',
						'title' => esc_html__( 'Menu Elements Options', 'impeka' ),
						'subtitle' => esc_html__( 'Enable / Disable various menu elements. Additional options for each menu element can be configured below.', 'impeka' ),
						'options' => $header_menu_options,
						'default' => $header_menu_options_default,
						'required' => array( 'header_menu_options_enabled', 'equals', '1' ),
					),
					array(
						'id'=>'header_menu_search_mode',
						'type' => 'select',
						'title' => esc_html__( 'Menu Search Mode', 'impeka' ),
						'subtitle'=> esc_html__( 'Select how you want to display your search, box or modal.', 'impeka' ),
						'options' => array(
							'modal' => esc_html__( 'Sliding Modal', 'impeka' ),
							'box' => esc_html__( 'Search Box', 'impeka' ),
						),
						"default" => 'modal',
						'required' => array( 'header_menu_options_enabled', 'equals', '1' ),
					),
					array(
						'id'=>'header_menu_language_style',
						'type' => 'select',
						'title' => esc_html__( 'Language Style', 'impeka' ),
						'subtitle'=> esc_html__( 'Select how you want to display your language switcher.', 'impeka' ),
						'options' => array(
							'modal' => esc_html__( 'Sliding Modal', 'impeka' ),
							'dropdown' => esc_html__( 'Dropdown', 'impeka' ),
							'list' => esc_html__( 'List', 'impeka' ),
						),
						"default" => 'modal',
						'required' => array( 'header_menu_options_enabled', 'equals', '1' ),
					),
					array(
						'id'=>'header_menu_type_form',
						'type' => 'button_set',
						'title' => esc_html__( 'Menu Form Type', 'impeka' ),
						'subtitle'=> esc_html__( 'Select the type of your form.', 'impeka' ),
						'options' => array(
							'contact-form' => esc_html__( 'Contact Form 7', 'impeka' ),
							'gravity-form' => esc_html__( 'Gravity Form', 'impeka' ),
							'fluent-form' => esc_html__( 'Fluent Form', 'impeka' ),
						),
						'default' => 'contact-form',
						'required' => array( 'header_menu_options_enabled', 'equals', '1' ),
					),
					array(
						'id' => 'header_menu_form', //translatable
						'type' => 'select',
						'title' => esc_html__( 'Menu Form', 'impeka' ),
						'subtitle' => esc_html__( 'Select the form for your Contact Form.', 'impeka' ),
						'data' => 'posts',
						'args' => array( 'post_type' => 'wpcf7_contact_form', 'numberposts' => -1 ),
						'default' => '',
						'required' => array(
							array( 'header_menu_options_enabled', 'equals', '1' ),
							array( 'header_menu_type_form', 'equals', 'contact-form' ),
						),
					),
					array(
						'id' => 'header_menu_gravity_form', //translatable
						'type' => 'select',
						'title' => esc_html__( 'Menu Form', 'impeka' ),
						'subtitle' => esc_html__( 'Select the form for your Gravity Form.', 'impeka' ),
						'options' => $gravity_form_options,
						'default' => '',
						'required' => array(
							array( 'header_menu_options_enabled', 'equals', '1' ),
							array( 'header_menu_type_form', 'equals', 'gravity-form' ),
						),
					),
					array(
						'id' => 'header_menu_fluent_form', //translatable
						'type' => 'select',
						'title' => esc_html__( 'Menu Form', 'impeka' ),
						'subtitle' => esc_html__( 'Select the form for your Fluent Form.', 'impeka' ),
						'options' => $fluent_form_options,
						'default' => '',
						'required' => array(
							array( 'header_menu_options_enabled', 'equals', '1' ),
							array( 'header_menu_type_form', 'equals', 'fluent-form' ),
						),
					),
					array(
						'id'=>'header_menu_social_mode',
						'type' => 'select',
						'title' => esc_html__( 'Menu Social Icons Mode', 'impeka' ),
						'subtitle'=> esc_html__( 'Select how you want to display your social icons single or modal.', 'impeka' ),
						'options' => array(
							'modal' => esc_html__( 'Sliding Modal', 'impeka' ),
							'single' => esc_html__( 'Single Social Icons', 'impeka' ),
						),
						"default" => 'modal',
						'required' => array( 'header_menu_options_enabled', 'equals', '1' ),
					),
					array(
						'id' => 'header_menu_social_options',
						'type' => 'checkbox',
						'title' => esc_html__( 'Menu Social Icons', 'impeka' ),
						'subtitle' => esc_html__( 'Select the social icons.', 'impeka' ),
						'desc' => '',
						'label' => true,
						'options' => $social_options,
						'class' => 'grve-redux-columns',
						'required' => array( 'header_menu_options_enabled', 'equals', '1' ),
					),
					array(
						'id' => 'header_menu_text_element', //translatable
						'type' => 'editor',
						'args' => array ( 'wpautop' => false ),
						'title' => esc_html__( 'Menu Text Element', 'impeka' ),
						'subtitle' => esc_html__( 'Type your text or anything else you want.', 'impeka' ),
						'default' => '',
						'required' => array( 'header_menu_options_enabled', 'equals', '1' ),
					),
				)
			);

			$this->sections[] = array(
				'title' => esc_html__( 'Background Options', 'impeka' ),
				'id' => 'grve_redux_section_backgrounds',
				'header' => '',
				'desc' => '',
				'icon_class' => 'el-icon-large',
				'icon' => 'el-icon-screen',
				'submenu' => true,
				'subsection' => true,
				'customizer' => false,
				'fields' => array(
					array(
						'id'       => 'body_background',
						'type'     => 'background',
						'title'    => esc_html__( 'Theme Background Image / Color', 'impeka' ),
						'subtitle' => esc_html__( 'Select a background image or color for the theme.', 'impeka' ),
						'background-color' => true,
						'transparent' => false,
						'background-repeat' => true,
						'background-attachment' => true,
						'background-clip' => false,
						'background-size' => true,
						'default' => array (
							'background-color' => '#171A1D',
						),
					),
					array(
						'id'       => 'content_background',
						'type'     => 'background',
						'title'    => esc_html__( 'Content Background Image / Color', 'impeka' ),
						'subtitle' => esc_html__( 'Select a background image or color for the content.', 'impeka' ),
						'background-color' => true,
						'transparent' => true,
						'background-repeat' => true,
						'background-attachment' => true,
						'background-clip' => false,
						'background-size' => true,
						'default' => array (
							'background-color' => '#ffffff',
						),
					),
				)
			);

			$this->sections[] = array(
				'title' => esc_html__( 'Logos', 'impeka' ),
				'id' => 'grve_redux_section_logos',
				'header' => '',
				'desc' => '',
				'icon_class' => 'el-icon-large',
				'icon' => 'el-icon-photo',
				'submenu' => true,
				'subsection' => true,
				'customizer' => false,
				'fields' => array(
					array(
						'id' => 'logo',
						'url' => true,
						'type' => 'media',
						'title' => esc_html__( 'Logo Default Header', 'impeka' ),
						'read-only' => false,
						'default' => array( 'url' => get_template_directory_uri() .'/images/logos/logo-dark.png', 'width' => '198', 'height' => '60' ),
						'subtitle' => esc_html__( 'Upload the logo for the Default Header.', 'impeka' ),
					),
					array(
						'id' => 'logo_light',
						'url'=> true,
						'type' => 'media',
						'title' => esc_html__( 'Logo Light Header', 'impeka' ),
						'read-only' => false,
						'default' => array( 'url' => get_template_directory_uri() .'/images/logos/logo-light.png', 'width' => '198', 'height' => '60' ),
						'subtitle' => esc_html__( 'Upload the logo for the Light Header.', 'impeka' ),
					),
					array(
						'id' => 'logo_dark',
						'url' => true,
						'type' => 'media',
						'title' => esc_html__( 'Logo Dark Header', 'impeka' ),
						'read-only' => false,
						'default' => array( 'url' => get_template_directory_uri() .'/images/logos/logo-dark.png', 'width' => '198', 'height' => '60' ),
						'subtitle' => esc_html__( 'Upload the logo for the Dark Header.', 'impeka' ),
					),
					array(
						'id' => 'logo_sticky',
						'url'=> true,
						'type' => 'media',
						'title' => esc_html__( 'Logo Sticky Header', 'impeka' ),
						'read-only' => false,
						'default' => array( 'url' => get_template_directory_uri() .'/images/logos/logo-dark.png', 'width' => '198', 'height' => '60' ),
						'subtitle' => esc_html__( 'Upload the logo for the Sticky Header.', 'impeka' ),
					),
					array(
						'id' => 'logo_responsive',
						'url' => true,
						'type' => 'media',
						'title' => esc_html__( 'Logo Responsive Header', 'impeka' ),
						'read-only' => false,
						'default' => array( 'url' => get_template_directory_uri() .'/images/logos/logo-dark.png', 'width' => '198', 'height' => '60' ),
						'subtitle' => esc_html__( 'Upload the logo for the Responsive Header.', 'impeka' ),
					),
					array(
						'id'=>'logo_as_text_enabled',
						'type' => 'switch',
						'title' => esc_html__( 'Logo as text', 'impeka' ),
						'subtitle'=> esc_html__( 'Toggle logo as text on or off. When on, all logo images will be replaced with site name.', 'impeka' ),
						"default" => '0',
						'on' => esc_html__('On', 'impeka' ),
						'off' => esc_html__('Off', 'impeka' ),
					),
					array(
						'id' => 'logo_custom_link_url', //translatable
						'type' => 'text',
						'title' => esc_html__( 'Logo Custom Link URL', 'impeka' ),
						'subtitle'=> esc_html__( 'Define a custom URL link for your logo. If empty homepage will be used instead.', 'impeka' ),
						"default" => '',
					),
					array(
						'id'=>'replace_admin_logo',
						'type' => 'switch',
						'title' => esc_html__( 'Replace Admin Logo', 'impeka' ),
						'subtitle'=> esc_html__( 'Check the box beside to replace the backend admin logo with your company logo.', 'impeka' ),
						'default' => 0,
					),
					array(
						'id'       => 'admin_logo',
						'type'     => 'media',
						'title' => esc_html__( 'Admin Logo', 'impeka' ),
						'subtitle' => esc_html__( 'Select the image for your company logo. ( If empty Logo Default will be used instead )', 'impeka' ),
						'required' => array( 'replace_admin_logo', 'equals', '1' ),
					),
					array(
						'id' => 'admin_logo_height',
						'type' => 'slider',
						'default' => 30,
						"min"       => 5,
						"step"      => 1,
						"max"       => 350,
						'display_value' => 'text',
						'title' => esc_html__( 'Admin Logo Height', 'impeka' ),
						'subtitle' => esc_html__( 'Enter the company logo height in px (Default is 30).', 'impeka' ),
						'required' => array( 'replace_admin_logo', 'equals', '1' ),
					),

				)
			);
			$this->sections[] = array(
				'title' => esc_html__( 'Top Bar Options', 'impeka' ),
				'id' => 'grve_redux_section_top_bar_options',
				'header' => '',
				'desc' => esc_html__( 'You can enable the TopBar area, just above the Header, in order to add various elements in two different positions, left and right.', 'impeka' ),
				'icon_class' => 'el-icon-large',
				'icon' => 'el-icon-arrow-up',
				'submenu' => true,
				'subsection' => true,
				'customizer' => false,
				'fields' => array(
					array(
						'id'=>'top_bar_enabled',
						'type' => 'switch',
						'title' => esc_html__( 'Top Bar Area', 'impeka' ),
						'subtitle'=> esc_html__( 'Enable or Disable the TopBar Area, the area just above your header.', 'impeka' ),
						"default" => '0',
					),
					array(
						'id'             => 'top_bar_spacing',
						'type'           => 'spacing',
						'mode'           => 'padding',
						'units'          => 'px',
						'units_extended' => 'false',
						'left'           => 'false',
						'right'          => 'false',
						'title'          => esc_html__( 'Top Bar Spacing', 'impeka' ),
						'subtitle'       => esc_html__( 'Set the spacing, Top and Bottom, of the TopBar Area.', 'impeka' ),
						'desc'           => esc_html__( 'Set spacing Top, Bottom in px.', 'impeka'),
						'default'        => array(
							'padding-top'     => '15px',
							'padding-bottom'  => '15px',
							'units'           => 'px',
						),
						'required' => array( 'top_bar_enabled', 'equals', '1' ),
					),
					array(
						'id' => 'top_bar_fullwidth',
						'type' => 'switch',
						'title' => esc_html__( 'Top Bar Full Width', 'impeka' ),
						'subtitle'=> esc_html__( 'Select if you prefer a full-width Top Bar Area.', 'impeka' ),
						'default' => '0',
						'required' => array( 'top_bar_enabled', 'equals', '1' ),
					),
					array(
						'id'   => 'info_top_bar_left',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Left Top Bar Area', 'impeka' ),
						'desc' => esc_html__( 'Left Top Bar Area settings.', 'impeka' ),
						'required' => array( 'top_bar_enabled', 'equals', '1' ),
					),
					array(
						'id'=>'top_bar_left_enabled',
						'type' => 'switch',
						'title' => esc_html__( 'Left Area', 'impeka' ),
						'subtitle'=> esc_html__( 'Enable or Disable the Left TopBar Area.', 'impeka' ),
						"default" => '0',
						'required' => array( 'top_bar_enabled', 'equals', '1' ),
					),
					array(
						'id' => 'top_bar_left_options',
						'type' => 'sortable',
						'mode' => 'checkbox',
						'title' => esc_html__( 'Left Area Elements', 'impeka' ),
						'subtitle' => esc_html__( 'Enable or Disable the elements you like to show in the Left TopBar Area.', 'impeka' ),
						'options' => $top_bar_options,
						'default' => $top_bar_options_default,
						'required' => array(
							array( 'top_bar_enabled', 'equals', '1' ),
							array( 'top_bar_left_enabled', 'equals', '1' ),
						),
					),
					array(
						'id' => 'top_bar_left_text', //translatable
						'type' => 'editor',
						'args' => array ( 'wpautop' => false ),
						'title' => esc_html__( 'Left Area Text', 'impeka' ),
						'subtitle' => esc_html__( 'Place the text you wish for your Left TopBar Area.', 'impeka' ),
						'default' => '',
						'required' => array(
							array( 'top_bar_enabled', 'equals', '1' ),
							array( 'top_bar_left_enabled', 'equals', '1' ),
						),
					),
					array(
						'id'=>'top_bar_left_search_mode',
						'type' => 'select',
						'title' => esc_html__( 'Left Area Search Mode', 'impeka' ),
						'subtitle'=> esc_html__( 'Select how you want to display your search, box or modal.', 'impeka' ),
						'options' => array(
							'modal' => esc_html__( 'Sliding Modal', 'impeka' ),
							'box' => esc_html__( 'Search Box', 'impeka' ),
						),
						"default" => 'modal',
						'required' => array(
							array( 'top_bar_enabled', 'equals', '1' ),
							array( 'top_bar_left_enabled', 'equals', '1' ),
						),
					),
					array(
						'id'=>'top_bar_left_language_style',
						'type' => 'select',
						'title' => esc_html__( 'Language Style', 'impeka' ),
						'subtitle'=> esc_html__( 'Select how you want to display your language switcher.', 'impeka' ),
						'options' => array(
							'dropdown' => esc_html__( 'Dropdown', 'impeka' ),
							'list' => esc_html__( 'List', 'impeka' ),
							'modal' => esc_html__( 'Sliding Modal', 'impeka' ),
						),
						"default" => 'dropdown',
						'required' => array(
							array( 'top_bar_enabled', 'equals', '1' ),
							array( 'top_bar_left_enabled', 'equals', '1' ),
						),
					),
					array(
						'id'=>'top_bar_left_type_form',
						'type' => 'button_set',
						'title' => esc_html__( 'Left Form Type', 'impeka' ),
						'subtitle'=> esc_html__( 'Select the type of your form.', 'impeka' ),
						'options' => array(
							'contact-form' => esc_html__( 'Contact Form 7', 'impeka' ),
							'gravity-form' => esc_html__( 'Gravity Form', 'impeka' ),
							'fluent-form' => esc_html__( 'Fluent Form', 'impeka' ),
						),
						'default' => 'contact-form',
						'required' => array(
							array( 'top_bar_enabled', 'equals', '1' ),
							array( 'top_bar_left_enabled', 'equals', '1' ),
						),
					),
					array(
						'id' => 'top_bar_left_form', //translatable
						'type' => 'select',
						'title' => esc_html__( 'Left Area Form', 'impeka' ),
						'subtitle' => esc_html__( 'Select the form for your Contact Form.', 'impeka' ),
						'data' => 'posts',
						'args' => array( 'post_type' => 'wpcf7_contact_form', 'numberposts' => -1 ),
						'default' => '',
						'required' => array(
							array( 'top_bar_enabled', 'equals', '1' ),
							array( 'top_bar_left_enabled', 'equals', '1' ),
							array( 'top_bar_left_type_form', 'equals', 'contact-form' ),
						),
					),
					array(
						'id' => 'top_bar_left_gravity_form', //translatable
						'type' => 'select',
						'title' => esc_html__( 'Left Area Form', 'impeka' ),
						'subtitle' => esc_html__( 'Select the form for your Gravity Form.', 'impeka' ),
						'options' => $gravity_form_options,
						'default' => '',
						'required' => array(
							array( 'top_bar_enabled', 'equals', '1' ),
							array( 'top_bar_left_enabled', 'equals', '1' ),
							array( 'top_bar_left_type_form', 'equals', 'gravity-form' ),
						),
					),
					array(
						'id' => 'top_bar_left_fluent_form', //translatable
						'type' => 'select',
						'title' => esc_html__( 'Left Area Form', 'impeka' ),
						'subtitle' => esc_html__( 'Select the form for your Fluent Form.', 'impeka' ),
						'options' => $fluent_form_options,
						'default' => '',
						'required' => array(
							array( 'top_bar_enabled', 'equals', '1' ),
							array( 'top_bar_left_enabled', 'equals', '1' ),
							array( 'top_bar_left_type_form', 'equals', 'fluent-form' ),
						),
					),
					array(
						'id' => 'top_bar_left_social_options',
						'type' => 'checkbox',
						'title' => esc_html__( 'Left Area Social Icons', 'impeka' ),
						'subtitle' => esc_html__( 'Select your social icons. Social URLs are configured from Theme Options - Social Media', 'impeka' ),
						'desc' => '',
						'label' => true,
						'options' => $social_options,
						'class' => 'grve-redux-columns',
						'required' => array(
							array( 'top_bar_enabled', 'equals', '1' ),
							array( 'top_bar_left_enabled', 'equals', '1' ),
						),
					),
					array(
						'id'   => 'info_top_bar_right',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Right Top Bar Area', 'impeka' ),
						'desc' => esc_html__( 'Right Top Bar Area settings.', 'impeka' ),
						'required' => array( 'top_bar_enabled', 'equals', '1' ),
					),
					array(
						'id'=>'top_bar_right_enabled',
						'type' => 'switch',
						'title' => esc_html__( 'Right Area', 'impeka' ),
						'subtitle'=> esc_html__( 'Enable or Disable the Right TopBar Area.', 'impeka' ),
						"default" => '0',
						'required' => array( 'top_bar_enabled', 'equals', '1' ),
					),
					array(
						'id' => 'top_bar_right_options',
						'type' => 'sortable',
						'mode' => 'checkbox',
						'title' => esc_html__( 'Right Area Elements', 'impeka' ),
						'subtitle' => esc_html__( 'Enable or Disable the elements you like to show in the Right TopBar Area.', 'impeka' ),
						'options' => $top_bar_options,
						'default' => $top_bar_options_default,
						'required' => array(
							array( 'top_bar_enabled', 'equals', '1' ),
							array( 'top_bar_right_enabled', 'equals', '1' ),
						),
					),
					array(
						'id' => 'top_bar_right_text', //translatable
						'type' => 'editor',
						'args' => array ( 'wpautop' => false ),
						'title' => esc_html__( 'Right Area Text', 'impeka' ),
						'subtitle' => esc_html__( 'Place the text you wish for your Right TopBar Area.', 'impeka' ),
						'default' => '',
						'required' => array(
							array( 'top_bar_enabled', 'equals', '1' ),
							array( 'top_bar_right_enabled', 'equals', '1' ),
						),
					),
					array(
						'id'=>'top_bar_right_search_mode',
						'type' => 'select',
						'title' => esc_html__( 'Right Area Search Mode', 'impeka' ),
						'subtitle'=> esc_html__( 'Select how you want to display your search, box or modal.', 'impeka' ),
						'options' => array(
							'modal' => esc_html__( 'Sliding Modal', 'impeka' ),
							'box' => esc_html__( 'Search Box', 'impeka' ),
						),
						"default" => 'modal',
						'required' => array(
							array( 'top_bar_enabled', 'equals', '1' ),
							array( 'top_bar_right_enabled', 'equals', '1' ),
						),
					),
					array(
						'id'=>'top_bar_right_language_style',
						'type' => 'select',
						'title' => esc_html__( 'Language Style', 'impeka' ),
						'subtitle'=> esc_html__( 'Select how you want to display your language switcher.', 'impeka' ),
						'options' => array(
							'dropdown' => esc_html__( 'Dropdown', 'impeka' ),
							'list' => esc_html__( 'List', 'impeka' ),
							'modal' => esc_html__( 'Sliding Modal', 'impeka' ),
						),
						"default" => 'dropdown',
						'required' => array(
							array( 'top_bar_enabled', 'equals', '1' ),
							array( 'top_bar_right_enabled', 'equals', '1' ),
						),
					),
					array(
						'id'=>'top_bar_right_type_form',
						'type' => 'button_set',
						'title' => esc_html__( 'Right Form Type', 'impeka' ),
						'subtitle'=> esc_html__( 'Select the type of your form.', 'impeka' ),
						'options' => array(
							'contact-form' => esc_html__( 'Contact Form 7', 'impeka' ),
							'gravity-form' => esc_html__( 'Gravity Form', 'impeka' ),
							'fluent-form' => esc_html__( 'Fluent Form', 'impeka' ),
						),
						'default' => 'contact-form',
						'required' => array(
							array( 'top_bar_enabled', 'equals', '1' ),
							array( 'top_bar_right_enabled', 'equals', '1' ),
						),
					),
					array(
						'id' => 'top_bar_right_form', //translatable
						'type' => 'select',
						'title' => esc_html__( 'Right Area Form', 'impeka' ),
						'subtitle' => esc_html__( 'Select the form for your Contact Form.', 'impeka' ),
						'data' => 'posts',
						'args' => array( 'post_type' => 'wpcf7_contact_form', 'numberposts' => -1 ),
						'default' => '',
						'required' => array(
							array( 'top_bar_enabled', 'equals', '1' ),
							array( 'top_bar_right_enabled', 'equals', '1' ),
							array( 'top_bar_right_type_form', 'equals', 'contact-form' ),
						),
					),
					array(
						'id' => 'top_bar_right_gravity_form', //translatable
						'type' => 'select',
						'title' => esc_html__( 'Right Area Form', 'impeka' ),
						'subtitle' => esc_html__( 'Select the form for your Gravity Form.', 'impeka' ),
						'options' => $gravity_form_options,
						'default' => '',
						'required' => array(
							array( 'top_bar_enabled', 'equals', '1' ),
							array( 'top_bar_right_enabled', 'equals', '1' ),
							array( 'top_bar_right_type_form', 'equals', 'gravity-form' ),
						),
					),
					array(
						'id' => 'top_bar_right_fluent_form', //translatable
						'type' => 'select',
						'title' => esc_html__( 'Right Area Form', 'impeka' ),
						'subtitle' => esc_html__( 'Select the form for your Fluent Form.', 'impeka' ),
						'options' => $fluent_form_options,
						'default' => '',
						'required' => array(
							array( 'top_bar_enabled', 'equals', '1' ),
							array( 'top_bar_right_enabled', 'equals', '1' ),
							array( 'top_bar_right_type_form', 'equals', 'fluent-form' ),
						),
					),
					array(
						'id' => 'top_bar_right_social_options',
						'type' => 'checkbox',
						'title' => esc_html__( 'Right Area Social Icons', 'impeka' ),
						'subtitle' => esc_html__( 'Select your social icons. Social URLs are configured from Theme Options - Social Media', 'impeka' ),
						'label' => true,
						'options' => $social_options,
						'class' => 'grve-redux-columns',
						'required' => array(
							array( 'top_bar_enabled', 'equals', '1' ),
							array( 'top_bar_right_enabled', 'equals', '1' ),
						),
					),
				)
			);

			$this->sections[] = array(
				'title' => esc_html__( 'Responsive Options', 'impeka' ),
				'id' => 'grve_redux_section_responsive_options',
				'header' => '',
				'desc' => esc_html__( 'Define your preferences for the responsive header.', 'impeka' ),
				'submenu' => true,
				'icon_class' => 'el-icon-large',
				'icon' => 'el-icon-screen',
				'customizer' => false,
				'subsection' => true,
				'fields' => array(
					array(
						'id' => 'responsive_header_threshold',
						'type' => 'text',
						'default' => '1024',
						'title' => esc_html__( 'Responsive Header Threshold', 'impeka' ),
						'subtitle' => esc_html__( 'Specify the screensize you want to activate the responsive header in px, based on the menu items you have (Default is 1024).', 'impeka' ),
						'validate' => 'numeric',
					),
					array(
						'id'             => 'responsive_header_spacing',
						'type'           => 'spacing',
						'mode'           => 'padding',
						'units'          => 'px',
						'units_extended' => 'false',
						'left'           => 'false',
						'right'          => 'false',
						'title'          => esc_html__( 'Responsive Header Spacing', 'impeka' ),
						'subtitle'       => esc_html__( 'Set the spacing, Top and Bottom, of the Responsive Header.', 'impeka' ),
						'desc'           => esc_html__( 'Set spacing Top, Bottom in px.', 'impeka'),
						'default'        => array(
							'padding-top'     => '15px',
							'padding-bottom'  => '15px',
							'units'           => 'px',
						)
					),
					array(
						'id' => 'mobile_container_space',
						'type' => 'slider',
						'default' => 28,
						"min"       => 5,
						"step"      => 1,
						"max"       => 80,
						'display_value' => 'text',
						'title' => esc_html__( 'Mobile Container Spacing', 'impeka' ),
						'subtitle' => esc_html__( 'Set the space that will display on each side of your container on mobile - space will be set in pixels.', 'impeka' ),
					),
					array(
						'id' => 'responsive_header_overlapping',
						'type' => 'select',
						'title' => esc_html__( 'Responsive Header Overlapping', 'impeka' ),
						'subtitle'=> esc_html__( 'Select if you want the Responsive Header overlaps the content.', 'impeka' ),
						'options' => $enable_selection,
						'default' => 'no',
					),
					array(
						'id'   => 'info_responsive_header_layouts',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Responsive Header Layout', 'impeka' ),
					),
					array(
						'id' => 'responsive_header_layout',
						'type' => 'image_select',
						'compiler' => true,
						'title' => esc_html__( 'Responsive Header Layout', 'impeka' ),
						'subtitle'=> esc_html__( 'Select your Responsive Header Layout.', 'impeka' ),
						'options' => $responsive_header_layouts_selection,
						'default' => 'layout-1',
					),
					array(
						'id'   => 'info_responsive_logo_options',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Logo Options for the Responsive Header', 'impeka' ),
					),
					array(
						'id' => 'responsive_logo_height',
						'type' => 'text',
						'default' => '30',
						'title' => esc_html__( 'Responsive Logo Height', 'impeka' ),
						'subtitle' => esc_html__( 'Enter the Logo height in px (Default is 30).', 'impeka' ),
						'validate' => 'numeric',
					),
					array(
						'id'=>'responsive_sticky_type',
						'type' => 'select',
						'title' => esc_html__( 'Devices Sticky Header', 'impeka' ),
						'subtitle'=> esc_html__( 'Enable the Sticky Header when responsive header is enabled.', 'impeka' ),
						"default" => 'none',
						'options' => array(
							'none' => esc_html__( 'No', 'impeka' ),
							'simple' => esc_html__( 'Yes', 'impeka' ),
						),
					),
					array(
						'id'   => 'info_responsive_menu_options',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Responsive Menu Options', 'impeka' ),
					),
					array(
						'id' => 'responsive_menu_button_type',
						'type' => 'select',
						'compiler' => true,
						'title' => esc_html__( 'Responsive Menu Button', 'impeka' ),
						'subtitle' => esc_html__( 'Select your responsive menu button type.', 'impeka' ),
						'options' => array(
							'icon' => esc_html__( 'Icon Only', 'impeka' ),
							'label' => esc_html__( 'Label Only', 'impeka' ),
							'icon-label' => esc_html__( 'Icon & Label', 'impeka' ),
						),
						'default' => 'icon',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'responsive_menu_button_label',
						'type' => 'text',
						'title' => esc_html__( 'Responsive Menu Button Label', 'impeka' ),
						'subtitle' => esc_html__( 'Enter the label for your responsive menu button.', 'impeka' ),
						'default' => 'Menu',
						'validate' => 'not_empty',
						'required' => array(
							'responsive_menu_button_type', 'equals', array(
								'label',
								'icon-label',
							)
						)
					),
					array(
						'id' => 'responsive_menu_icon_style',
						'type' => 'image_select',
						'compiler' => true,
						'title' => esc_html__( 'Responsive Menu Icon', 'impeka' ),
						'subtitle'=> esc_html__( 'Select the icon for your responsive menu.', 'impeka' ),
						'options' => $burger_icon_selection,
						'default' => 'style-1',
						'class' => 'small-image-selector',
						'required' => array(
							array( 'header_icon_library', 'equals', 'theme-icons' ),
							array( 'responsive_menu_button_type', 'equals', array( 'icon', 'icon-label' ) ),
						),
					),
					array(
						'id' => 'responsive_header_visibility',
						'type' => 'select',
						'compiler' => true,
						'title' => esc_html__( 'Responsive Header Visibility', 'impeka' ),
						'subtitle' => esc_html__( 'Select if you want to maintain the responsive header visible when the responsive menu opens.', 'impeka' ),
						'options' => array(
							'true' => esc_html__( 'Yes', 'impeka' ),
							'false' => esc_html__( 'No', 'impeka' ),
						),
						'default' => 'false',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'responsive_menu_item_space',
						'type' => 'slider',
						'default' => 18,
						"min"       => 5,
						"step"      => 1,
						"max"       => 100,
						'display_value' => 'text',
						'title' => esc_html__( 'Menu Item Spacing', 'impeka' ),
						'subtitle' => esc_html__( 'Set the space that will display on each side of your menu items - space will be set in pixels.', 'impeka' ),
					),
					array(
						'id' => 'responsive_menu_animation',
						'type' => 'select',
						'compiler' => true,
						'title' => esc_html__( 'Responsive Menu Animation', 'impeka' ),
						'subtitle' => esc_html__( 'Select your responsive menu animation.', 'impeka' ),
						'options' => array(
							'left-to-right' => esc_html__( 'Left to Right', 'impeka' ),
							'right-to-left' => esc_html__( 'Right to Left', 'impeka' ),
							'top-to-bottom' => esc_html__( 'Top to Bottom', 'impeka' ),
							'bottom-to-top' => esc_html__( 'Bottom to Top', 'impeka' ),
							'fade-in' => esc_html__( 'Fade In', 'impeka' ),
						),
						'default' => 'left-to-right',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'responsive_menu_items_animation',
						'type' => 'select',
						'compiler' => true,
						'title' => esc_html__( 'Responsive Menu Items Animation', 'impeka' ),
						'subtitle' => esc_html__( 'Select your responsive menu items animation.', 'impeka' ),
						'options' => array(
							'none' => esc_html__( 'None', 'impeka' ),
							'left-to-right' => esc_html__( 'Left to Right', 'impeka' ),
							'right-to-left' => esc_html__( 'Right to Left', 'impeka' ),
							'top-to-bottom' => esc_html__( 'Top to Bottom', 'impeka' ),
							'bottom-to-top' => esc_html__( 'Bottom to Top', 'impeka' ),
							'fade-in' => esc_html__( 'Fade In', 'impeka' ),
						),
						'default' => 'fade-in',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'menu_responsive_open_type',
						'type' => 'select',
						'compiler' => true,
						'title' => esc_html__( 'Responsive Menu Type', 'impeka' ),
						'subtitle' => esc_html__( 'Select your responsive menu type.', 'impeka' ),
						'options' => array(
							'toggle' => esc_html__( 'Toggle', 'impeka' ),
							'accordion' => esc_html__( 'Accordion', 'impeka' ),
							'slide' => esc_html__( 'Slide', 'impeka' ),
						),
						'default' => 'slide',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'menu_responsive_align',
						'type' => 'select',
						'title' => esc_html__( 'Responsive Menu Align', 'impeka' ),
						'subtitle' => esc_html__( 'Select your responsive menu align.', 'impeka' ),
						'options' => array(
							'left' => esc_html__( 'Left', 'impeka' ),
							'center' => esc_html__( 'Center', 'impeka' ),
						),
						'default' => 'left',
						'validate' => 'not_empty',
						'required' => array( 'menu_responsive_open_type', 'equals', 'slide' ),
					),
					array(
						'id' => 'menu_responsive_width',
						'type' => 'select',
						'compiler' => true,
						'title' => esc_html__( 'Responsive Menu Width', 'impeka' ),
						'subtitle' => esc_html__( 'Select the width for your responsive menu.', 'impeka' ),
						'options' => array(
							'small' => esc_html__( 'Small', 'impeka' ),
							'medium' => esc_html__( 'Medium', 'impeka' ),
							'large' => esc_html__( 'Large', 'impeka' ),
						),
						'default' => 'small',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'menu_responsive_text', //translatable
						'type' => 'editor',
						'args' => array ( 'wpautop' => false ),
						'title' => esc_html__( 'Responsive Menu Text', 'impeka' ),
						'subtitle' => esc_html__( 'Type your text or anything else you want.', 'impeka' ),
						'default' => '',
					),

					array(
						'id'       => 'menu_responsive_bg_mode',
						'type'     => 'select',
						'title' => esc_html__( 'Responsive Menu Background Mode', 'impeka' ),
						'subtitle'=> esc_html__( 'Select the Responsive Menu Background, Color or Image.', 'impeka' ),
						'options' => $title_bg_mode_limited,
						'default'  => 'color',
					),


					array(
						'id' => 'menu_responsive_background',
						'type' => 'background',
						'title' => esc_html__( 'Responsive Menu Image', 'impeka' ),
						'subtitle' => esc_html__( 'Select a background image or color for your responsive menu.', 'impeka' ),
						'background-color' => false,
						'transparent' => false,
						'background-repeat' => true,
						'background-attachment' => true,
						'background-clip' => false,
						'background-size' => true,
						'required' => array( 'menu_responsive_bg_mode', 'equals', 'custom' ),
					),
					array(
						'id'   => 'info_responsive_menu_elements',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Responsive Menu Elements Options', 'impeka' ),
					),
					array(
						'id'=>'responsive_menu_options_enabled',
						'type' => 'switch',
						'title' => esc_html__( 'Responsive Menu Elements', 'impeka' ),
						'subtitle'=> esc_html__( 'Enable or disable the use of various elements in your header like socials, search, language selector and Contact Form.', 'impeka' ),
						"default" => '0',
					),
					array(
						'id' => 'responsive_menu_options',
						'type' => 'sortable',
						'mode' => 'checkbox',
						'title' => esc_html__( 'Responsive Menu Elements Options', 'impeka' ),
						'subtitle' => esc_html__( 'Enable / Disable various menu elements. Additional options for each menu element can be configured below.', 'impeka' ),
						'options' => $responsive_menu_options,
						'default' => $responsive_menu_options_default,
						'required' => array( 'responsive_menu_options_enabled', 'equals', '1' ),
					),
					array(
						'id'=>'responsive_menu_type_form',
						'type' => 'button_set',
						'title' => esc_html__( 'Responsive Menu Form Type', 'impeka' ),
						'subtitle'=> esc_html__( 'Select the type of your form.', 'impeka' ),
						'options' => array(
							'contact-form' => esc_html__( 'Contact Form 7', 'impeka' ),
							'gravity-form' => esc_html__( 'Gravity Form', 'impeka' ),
							'fluent-form' => esc_html__( 'Fluent Form', 'impeka' ),
						),
						'default' => 'contact-form',
						'required' => array( 'responsive_menu_options_enabled', 'equals', '1' ),
					),
					array(
						'id' => 'responsive_menu_form',  //translatable
						'type' => 'select',
						'title' => esc_html__( 'Responsive Menu Form', 'impeka' ),
						'subtitle' => esc_html__( 'Select the form for your Contact Form.', 'impeka' ),
						'data' => 'posts',
						'args' => array( 'post_type' => 'wpcf7_contact_form', 'numberposts' => -1 ),
						'default' => '',
						'required' => array(
							array( 'responsive_menu_options_enabled', 'equals', '1' ),
							array( 'responsive_menu_type_form', 'equals', 'contact-form' ),
						),
					),
					array(
						'id' => 'responsive_menu_gravity_form',  //translatable
						'type' => 'select',
						'title' => esc_html__( 'Responsive Menu Form', 'impeka' ),
						'subtitle' => esc_html__( 'Select the form for your Gravity Form.', 'impeka' ),
						'options' => $gravity_form_options,
						'default' => '',
						'required' => array(
							array( 'responsive_menu_options_enabled', 'equals', '1' ),
							array( 'responsive_menu_type_form', 'equals', 'gravity-form' ),
						),
					),
					array(
						'id' => 'responsive_menu_fluent_form',  //translatable
						'type' => 'select',
						'title' => esc_html__( 'Responsive Menu Form', 'impeka' ),
						'subtitle' => esc_html__( 'Select the form for your Fluent Form.', 'impeka' ),
						'options' => $fluent_form_options,
						'default' => '',
						'required' => array(
							array( 'responsive_menu_options_enabled', 'equals', '1' ),
							array( 'responsive_menu_type_form', 'equals', 'fluent-form' ),
						),
					),
					array(
						'id' => 'responsive_menu_social_options',
						'type' => 'checkbox',
						'title' => esc_html__( 'Responsive Menu Social Icons', 'impeka' ),
						'subtitle' => esc_html__( 'Select the social icons.', 'impeka' ),
						'desc' => '',
						'label' => true,
						'options' => $social_options,
						'class' => 'grve-redux-columns',
						'required' => array( 'responsive_menu_options_enabled', 'equals', '1' ),
					),
					array(
						'id' => 'responsive_menu_text_element',  //translatable
						'type' => 'editor',
						'args' => array ( 'wpautop' => false ),
						'title' => esc_html__( 'Responsive Menu Element Text', 'impeka' ),
						'subtitle' => esc_html__( 'Type your text or anything else you want.', 'impeka' ),
						'default' => '',
						'required' => array( 'responsive_menu_options_enabled', 'equals', '1' ),
					),
				)
			);

			$this->sections[] = array(
				'icon' => 'el-icon-arrow-down',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( 'Bottom / Footer Areas', 'impeka' ),
				'id' => 'grve_redux_section_footer_options',
				'desc' => esc_html__( 'These areas appear at the bottom of your pages. Define your preferences.', 'impeka' ),
				'submenu' => true,
				'subsection' => true,
				'customizer' => false,
				'fields' => array(
					array(
						'id'=>'sticky_footer',
						'type' => 'switch',
						'title' => esc_html__( 'Sticky Areas', 'impeka' ),
						'subtitle'=> esc_html__( 'Select if you want to make sticky these areas.', 'impeka' ),
						"default" => '0',
					),
					array(
						'id'=>'footer_shadow',
						'type' => 'switch',
						'title' => esc_html__( 'Add Shadow', 'impeka' ),
						'subtitle'=> esc_html__( 'Select if you want your footer to have inner shadow.', 'impeka' ),
						"default" => '0',
					),
					array(
						'id' => 'bottom_bar_area', //translatable
						'type' => 'select',
						'title' => esc_html__( 'Bottom Bar Area Item', 'impeka' ),
						'subtitle' => esc_html__( 'Select an area item for your Bottom Bar Area.', 'impeka' ),
						'data' => 'posts',
						'args' => array( 'post_type' => 'area-item', 'numberposts' => -1 ),
						'default' => '',
					),
					array(
						'id'   => 'info_footer_widgets',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Footer Widgets Settings', 'impeka' ),
					),
					array(
						'id'       => 'footer_bg_mode',
						'type'     => 'select',
						'title' => esc_html__( 'Background Mode', 'impeka' ),
						'subtitle'=> esc_html__( 'Select the Footer Background, Color or Image.', 'impeka' ),
						'options' => $title_bg_mode_limited,
						'default'  => 'color',
					),
					array(
						'id'       => 'footer_bg_image',
						'type'     => 'media',
						'title' => esc_html__( 'Background Image', 'impeka' ),
						'subtitle' => esc_html__( 'Select a background image for the footer.', 'impeka' ),
						'required' => array( 'footer_bg_mode', 'equals', 'custom' ),
					),
					array(
						'id' => 'footer_bg_position',
						'type' => 'select',
						'title' => esc_html__( 'Background Position', 'impeka' ),
						'options' => $align_selection_full,
						'default' => 'center-center',
						'validate' => 'not_empty',
						'required' => array( 'footer_bg_mode', 'equals', 'custom' ),
					),
					array(
						'id' => 'footer_pattern_overlay',
						'type' => 'select',
						'title' => esc_html__( 'Pattern Overlay', 'impeka' ),
						'options' => $pattern_selection,
						'default' => 'none',
						'required' => array( 'footer_bg_mode', 'equals', 'custom' ),
					),
					array(
						'id' => 'footer_color_overlay',
						'type' => 'select',
						'title' => esc_html__( 'Color Overlay', 'impeka' ),
						'options' => $color_selection,
						'default' => 'black',
						'required' => array( 'footer_bg_mode', 'equals', 'custom' ),
					),
					array(
						'id' => 'footer_opacity_overlay',
						'type' => 'select',
						'title' => esc_html__( 'Opacity Overlay', 'impeka' ),
						'options' => $opacity_selection,
						'default' => '0',
						'required' => array( 'footer_bg_mode', 'equals', 'custom' ),
					),
					array(
						'id'=>'footer_widgets_visibility',
						'type' => 'switch',
						'title' => esc_html__( 'Footer Widgets Visibility', 'impeka' ),
						'subtitle'=> esc_html__( 'Enable the Footer Area to show the widget areas of the footer.', 'impeka' ),
						"default" => '1',
					),
					array(
						'id' => 'footer_widgets_layout',
						'type' => 'image_select',
						'compiler' => true,
						'title' => esc_html__( 'Footer Column Layout', 'impeka' ),
						'subtitle' => esc_html__( 'Select the Footer column layout.', 'impeka' ),
						'options' => $footer_column_selection,
						'default' => 'footer-1',
						'required' => array( 'footer_widgets_visibility', 'equals', '1' ),
					),
					array(
						'id' => 'footer_section_type',
						'type' => 'select',
						'title' => esc_html__( 'Footer Full Width', 'impeka' ),
						'subtitle'=> esc_html__( 'Select if you prefer a full-width Footer Area.', 'impeka' ),
						'options' => array(
							'fullwidth-background' => esc_html__( 'No', 'impeka' ),
							'fullwidth-element' => esc_html__( 'Yes', 'impeka' ),
						),
						'default' => 'fullwidth-background',
						'validate' => 'not_empty',
						'required' => array( 'footer_widgets_visibility', 'equals', '1' ),
					),
					array(
						'id' => 'footer_padding_top_multiplier',
						'type' => 'select',
						'title' => esc_html__( 'Footer Top Padding', 'impeka' ),
						'subtitle'=> esc_html__( 'Select the space above the footer area.', 'impeka' ),
						'options' => $padding_selection,
						'default' => '3x',
						'validate' => 'not_empty',
						'required' => array( 'footer_widgets_visibility', 'equals', '1' ),
					),
					array(
						'id' => 'footer_padding_bottom_multiplier',
						'type' => 'select',
						'title' => esc_html__( 'Footer Bottom Padding', 'impeka' ),
						'subtitle'=> esc_html__( 'Select the space below the footer area.', 'impeka' ),
						'options' => $padding_selection,
						'default' => '3x',
						'validate' => 'not_empty',
						'required' => array( 'footer_widgets_visibility', 'equals', '1' ),
					),
					array(
						'id'   => 'info_footer_bar',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Footer Bar Settings', 'impeka' ),
					),
					array(
						'id'=>'footer_bar_visibility',
						'type' => 'switch',
						'title' => esc_html__( 'Footer Bar Visibility', 'impeka' ),
						'subtitle'=> esc_html__( 'Enable the Footer Bar Area to add text (copyright), bottom menu and socials.', 'impeka' ),
						"default" => '1',
					),
					array(
						'id' => 'footer_bar_section_type',
						'type' => 'select',
						'title' => esc_html__( 'Footer Bar Full Width', 'impeka' ),
						'subtitle'=> esc_html__( 'Select if you prefer a full-width Footer Bar Area.', 'impeka' ),
						'options' => array(
							'fullwidth-background' => esc_html__( 'No', 'impeka' ),
							'fullwidth-element' => esc_html__( 'Yes', 'impeka' ),
						),
						'default' => 'fullwidth-background',
						'validate' => 'not_empty',
						'required' => array( 'footer_bar_visibility', 'equals', '1' ),
					),
					array(
						'id' => 'footer_bar_align_center',
						'type' => 'select',
						'title' => esc_html__( 'Footer Bar Center', 'impeka' ),
						'subtitle'=> esc_html__( 'Select if the Footer Bar elements will be centered.', 'impeka' ),
						'options' => array(
							'no' => esc_html__( 'No', 'impeka' ),
							'yes' => esc_html__( 'Yes', 'impeka' ),
						),
						'default' => 'yes',
						'validate' => 'not_empty',
						'required' => array( 'footer_bar_visibility', 'equals', '1' ),
					),
					array(
						'id'=>'footer_copyright_visibility',
						'type' => 'switch',
						'title' => esc_html__( 'Footer Copyright Visibility', 'impeka' ),
						'subtitle'=> esc_html__( 'Enable the Footer Copyright Area. Edit it as you wish.', 'impeka' ),
						"default" => '1',
						'required' => array( 'footer_bar_visibility', 'equals', '1' ),
					),
					array(
						'id' => 'footer_copyright_text', //translatable
						'type' => 'editor',
						'args' => array ( 'wpautop' => false ),
						'title' => esc_html__( 'Copyright Text', 'impeka' ),
						'subtitle' => esc_html__( 'Type your copyright text or anything else you want.', 'impeka' ),
						'default' => '<p>With <span class="grve-text-primary-1 fas fa-heart"></span> by <a href="//greatives.eu" target="_blank" rel="noopener noreferrer">Greatives</a> - Premium Themes</p>',
						'required' => array(
							array( 'footer_bar_visibility', 'equals', '1' ),
							array( 'footer_copyright_visibility', 'equals', '1' ),
						),
					),
					array(
						'id'=>'second_area_visibility',
						'type' => 'button_set',
						'title' => esc_html__( 'Second Footer Area', 'impeka' ),
						'subtitle'=> esc_html__( 'This is the second position in the Footer Bar Area. You can easily add the Bottom Menu (assigned in Appearance > Menus) or socials.', 'impeka' ),
						'options' => array(
							'1' => esc_html__( 'Hide', 'impeka' ),
							'2' => esc_html__( 'Menu', 'impeka' ),
							'3' => esc_html__( 'Socials', 'impeka' ),
							'4' => esc_html__( 'Text', 'impeka' ),
						),
						'default' => '2',
						'required' => array( 'footer_bar_visibility', 'equals', '1' ),
					),
					array(
						'id' => 'footer_second_copyright_text', //translatable
						'type' => 'editor',
						'args' => array ( 'wpautop' => false ),
						'title' => esc_html__( 'Text', 'impeka' ),
						'subtitle' => esc_html__( 'Type your text or anything else you want.', 'impeka' ),
						'default' => '',
						'required' => array(
							array( 'footer_bar_visibility', 'equals', '1' ),
							array( 'second_area_visibility', 'equals', '4' ),
						),
					),
					array(
						'id' => 'footer_social_display',
						'type' => 'select',
						'title' => esc_html__( 'Footer Social Display', 'impeka' ),
						'subtitle'=> esc_html__( 'Select how you want to display your social items.', 'impeka' ),
						'options' => array(
							'text' => esc_html__( 'Text', 'impeka' ),
							'icon' => esc_html__( 'Icons', 'impeka' ),
						),
						'default' => 'text',
						'validate' => 'not_empty',
						'required' => array(
							array( 'footer_bar_visibility', 'equals', '1' ),
							array( 'second_area_visibility', 'equals', '3' ),
						),
					),
					array(
						'id' => 'footer_social_options',
						'type' => 'checkbox',
						'title' => esc_html__( 'Footer Social items', 'impeka' ),
						'subtitle' => esc_html__( 'Select your social icons.', 'impeka' ),
						'desc' => '',
						'label' => true,
						'options' => $social_options,
						'class' => 'grve-redux-columns',
						'required' => array(
							array( 'footer_bar_visibility', 'equals', '1' ),
							array( 'second_area_visibility', 'equals', '3' ),
						),
					),
				)
			);

			$this->sections[] = array(
				'icon' => 'el-icon-arrow-down',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( 'Safe Button Area', 'impeka' ),
				'id' => 'grve_redux_section_safebutton_area',
				'desc' => esc_html__( 'Define your preferences for the safe button area.', 'impeka' ),
				'submenu' => true,
				'subsection' => true,
				'customizer' => false,
				'fields' => array(
					array(
						'id' => 'header_safebutton_area', //translatable
						'type' => 'select',
						'title' => esc_html__( 'Safe Button Area Item', 'impeka' ),
						'subtitle' => esc_html__( 'Select an area item for your Safe Button Area.', 'impeka' ),
						'data' => 'posts',
						'args' => array( 'post_type' => 'area-item', 'numberposts' => -1 ),
						'default' => '',
					),
					array(
						'id' => 'safebutton_icon_style',
						'type' => 'image_select',
						'compiler' => true,
						'title' => esc_html__( 'Safe Button Icon', 'impeka' ),
						'subtitle'=> esc_html__( 'Select the icon for your safe button.', 'impeka' ),
						'options' => $safebutton_icon_selection,
						'default' => 'style-4',
						'class' => 'small-image-selector',
						'required' => array(
							array( 'header_icon_library', 'equals', 'theme-icons' ),
						),
					),
					array(
						'id' => 'safebutton_custom_icon_svg',
						'url' => true,
						'type' => 'media',
						'title' => esc_html__( 'Safe Button Custom SVG Icon', 'impeka' ),
						'subtitle' => esc_html__( 'Upload a custom svg if you want to replace the default icon.', 'impeka' ),
						'required' => array( 'safebutton_icon_style', 'equals', 'custom' ),
					),
					array(
						'id'=>'safebutton_close_position',
						'type' => 'select',
						'title' => esc_html__( 'Safe Button Close Position', 'impeka' ),
						'options' => array(
							'left' => esc_html__( 'Left', 'impeka' ),
							'right' => esc_html__( 'Right', 'impeka' ),
						),
						'default' => 'right',
						'required' => array( 'header_layout','!=', 'layout-default-style-2' ),
					),
					array(
						'id' => 'safebutton_aria_label', //translatable
						'type' => 'text',
						'title' => esc_html__( 'Safe Button Aria Label', 'impeka' ),
						'subtitle'=> esc_html__( 'Define an aria label for the Safe Button.', 'impeka' ),
						"default" => 'More details',
					),
				)
			);

			$this->sections[] = array(
				'title' => esc_html__( 'Theme Intro', 'impeka' ),
				'desc' => esc_html__( 'Select a theme intro loader for your homepage.', 'impeka' ),
				'id' => 'grve_redux_section_page_transitions',
				'icon_class' => 'el-icon-large',
				'icon' => 'el-icon-photo',
				'submenu' => true,
				'subsection' => true,
				'customizer' => false,
				'fields' => array(
					array(
						'id'=>'theme_intro',
						'type' => 'switch',
						'title' => esc_html__( 'Theme Intro', 'impeka' ),
						'subtitle'=> esc_html__( 'Enable or Disable Theme Intro.', 'impeka' ),
						'default' => '0',
					),
					array(
						'id' => 'intro_image',
						'url' => true,
						'type' => 'media',
						'title' => esc_html__( 'Intro Image', 'impeka' ),
						'subtitle' => esc_html__( 'Upload a custom image for your theme intro.', 'impeka' ),
						'required' => array( 'theme_intro', 'equals', '1' ),
					),
					array(
						'id' => 'intro_image_height',
						'type' => 'slider',
						'default' => 30,
						"min"       => 1,
						"step"      => 1,
						"max"       => 1250,
						'display_value' => 'text',
						'title' => esc_html__( 'Intro Image Height', 'impeka' ),
						'subtitle' => esc_html__( 'Enter the Intro Image height in px.', 'impeka' ),
						'required' => array( 'theme_intro', 'equals', '1' ),
					),
					array(
						'id' => 'intro_first_title_text', //translatable
						'type' => 'text',
						'title' => esc_html__( 'First Title', 'impeka' ),
						'subtitle' => esc_html__( 'Enter the first title for your theme intro.', 'impeka' ),
						'default' => '',
						'required' => array( 'theme_intro', 'equals', '1' ),
					),
					array(
						'id' => 'intro_second_title_text', //translatable
						'type' => 'text',
						'title' => esc_html__( 'Second Title', 'impeka' ),
						'subtitle' => esc_html__( 'Enter the second title for your theme intro.', 'impeka' ),
						'default' => '',
						'required' => array( 'theme_intro', 'equals', '1' ),
					),
					array(
						'id' => 'intro_appearance',
						'type' => 'select',
						'title' => esc_html__( 'Intro Appearance', 'impeka' ),
						'subtitle'=> esc_html__( 'Select when you want the intro to appear', 'impeka' ),
						'options' => array(
							'always' => esc_html__( 'Always', 'impeka' ),
							'once' => esc_html__( 'First Visit', 'impeka' ),
						),
						'default' => 'always',
						'required' => array( 'theme_intro', 'equals', '1' ),
					),
					array(
						'id' => 'intro_reset_duration',
						'type' => 'text',
						'title' => esc_html__( 'Duration', 'impeka' ),
						'subtitle' => esc_html__( 'Enter the number of days to appear after first visit.', 'impeka' ),
						'default' => '7',
						'required' => array(
							array( 'theme_intro', 'equals', '1' ),
							array( 'intro_appearance', 'equals', 'once' ),
						),
					),
				)
			);

			$this->sections[] = array(
				'title' => esc_html__( 'Page Transitions', 'impeka' ),
				'desc' => esc_html__( 'Select the page transition and/or the loader spinner when navigating from one page to another.', 'impeka' ),
				'id' => 'grve_redux_section_page_transitions',
				'icon_class' => 'el-icon-large',
				'icon' => 'el-icon-photo',
				'submenu' => true,
				'subsection' => true,
				'customizer' => false,
				'fields' => array(
					array(
						'id'=>'theme_loader',
						'type' => 'switch',
						'title' => esc_html__( 'Theme Loader', 'impeka' ),
						'subtitle'=> esc_html__( 'Enable or Disable Theme Loader.', 'impeka' ),
						'default' => '0',
					),
					array(
						'id' => 'page_transition',
						'type' => 'select',
						'title' => esc_html__( 'Page Transition', 'impeka' ),
						'subtitle'=> esc_html__( 'Select the page transition when navigating from one page to another. It is worth noting that it maybe causes problems with plugins which use ajax requests.', 'impeka' ),
						'options' => array(
							'none' => esc_html__( 'None', 'impeka' ),
							'fade-in' => esc_html__( 'Fade In', 'impeka' ),
							'left-to-right' => esc_html__( 'Left to Right', 'impeka' ),
							'right-to-left' => esc_html__( 'Right to Left', 'impeka' ),
							'top-to-bottom' => esc_html__( 'Top to Bottom', 'impeka' ),
							'bottom-to-top' => esc_html__( 'Bottom to Top', 'impeka' ),
							'zoom-out' => esc_html__( 'Zoom Out', 'impeka' ),
						),
						'default' => 'none',
						'validate' => 'not_empty',
						'required' => array( 'theme_loader', 'equals', '1' ),
					),
					array(
						'id'=>'show_spinner',
						'type' => 'switch',
						'title' => esc_html__( 'Enable Spinner', 'impeka' ),
						'subtitle'=> esc_html__( 'Enable or Disable Theme Loader Spinner.', 'impeka' ),
						'default' => '0',
						'1' => esc_html__( 'On', 'impeka' ),
						'0' => esc_html__( 'Off', 'impeka' ),
						'required' => array( 'theme_loader', 'equals', '1' ),
					),
					array(
						'id' => 'spinner_icon',
						'type' => 'image_select',
						'compiler' => true,
						'title' => esc_html__( 'Spinner', 'impeka' ),
						'subtitle'=> esc_html__( 'Select the icon for your spinner.', 'impeka' ),
						'options' => $spinner_icon_selection,
						'default' => 'spinner-1',
						'class' => 'small-image-selector',
						'required' => array( 'show_spinner', 'equals', '1' ),
					),
					array(
						'id' => 'spinner_image',
						'url' => true,
						'type' => 'media',
						'title' => esc_html__( 'Spinner Image', 'impeka' ),
						'subtitle' => esc_html__( 'Upload a custom image if you want to replace the default graphic spinner.', 'impeka' ),
						'required' => array( 'spinner_icon', 'equals', 'spinner-custom' ),
					),
				)
			);

			$this->sections[] = array(
				'icon' => 'el-icon-brush',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( 'Style Options', 'impeka' ),
				'id' => 'grve_redux_section_style_options',
				'desc' => sprintf(
					esc_html__( 'To customize the color scheme, please use the %s.', 'impeka' ),
					sprintf(
						'<a href="%s">%s</a>',
						esc_url( admin_url('/customize.php') ),
						esc_html__( 'Live Color Customizer', 'impeka' )
					)
				),
				'customizer' => false,
				'submenu' => true,
				'subsection' => true,
				'fields' => array(
				)
			);

			$this->sections[] = array(
				'icon' => 'el-icon-edit',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( 'Blog Options', 'impeka' ),
				'id' => 'grve_redux_section_blog_options',
				'desc' => esc_html__( 'Changes here will affect the assigned blog page in case you have set a Static Page as blog page in Settings > Reading > Front Page Displays and not when you use the shortcodes to create a blog page. Also these settings will also affect on Archives / Categories / Tags overview pages.', 'impeka' ),
				'submenu' => true,
				'customizer' => false,
				'fields' => array(
					array(
						'id' => 'blog_layout',
						'type' => 'image_select',
						'compiler' => true,
						'title' => esc_html__( 'Blog Layout', 'impeka' ),
						'subtitle' => esc_html__( 'Select the layout for the assigned blog page. Choose among Full Width, Left Sidebar or Right Sidebar.', 'impeka' ),
						'options' => $layout_selection,
						'default' => 'right',
					),
					array(
						'id' => 'blog_sidebar',
						'type' => 'select',
						'class' => 'grve-redux-group grve-redux-first',
						'title' => esc_html__( 'Blog Sidebar', 'impeka' ),
						'subtitle' => esc_html__( 'Select the sidebar for the assigned blog page.', 'impeka' ),
						'data' => 'sidebar',
						'default' => 'grve-default-sidebar',
					),
					array(
						'id' => 'blog_fixed_sidebar',
						'type' => 'select',
						'class' => 'grve-redux-group grve-redux-last',
						'title' => esc_html__( 'Blog Fixed Sidebar', 'impeka' ),
						'subtitle'=> esc_html__( 'Select if you want a fixed sidebar.', 'impeka' ),
						'options' => $enable_selection,
						'default' => 'no',
					),
					array(
						'id' => 'blog_sidearea_visibility',
						'type' => 'select',
						'class' => 'grve-redux-group grve-redux-first',
						'title' => esc_html__( 'Blog Side Area Visibility', 'impeka' ),
						'subtitle' => esc_html__( 'Enable the Blog Side Area for the assigned blog page.', 'impeka' ),
						'options' => $enable_selection,
						'default' => 'no',
					),
					array(
						'id' => 'blog_sidearea_sidebar',
						'type' => 'select',
						'class' => 'grve-redux-group',
						'title' => esc_html__( 'Blog Side Area Sidebar', 'impeka' ),
						'subtitle' => esc_html__( 'Select the sidebar widget area for the side area.', 'impeka' ),
						'data' => 'sidebar',
						'default' => 'grve-default-sidebar',
						'required' => array( 'blog_sidearea_visibility', 'equals', 'yes' ),
					),
					array(
						'id' => 'blog_sidearea_icon_style',
						'type' => 'image_select',
						'class' => 'small-image-selector grve-redux-group grve-redux-last',
						'compiler' => true,
						'title' => esc_html__( 'Blog Side Area Icon', 'impeka' ),
						'subtitle'=> esc_html__( 'Select the icon for your side area.', 'impeka' ),
						'options' => $burger_icon_selection,
						'default' => 'style-5',
						'required' => array(
							array( 'header_icon_library', 'equals', 'theme-icons' ),
							array( 'blog_sidearea_visibility', 'equals', 'yes' ),
						),
					),
					array(
						'id'   => 'info_style_blog_settings',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Blog Style and Basic Blog Settings', 'impeka' ),
						'subtitle'=> esc_html__( 'Set the style and basic settings for the default blog.', 'impeka' ),
					),
					array(
						'id' => 'blog_mode',
						'type' => 'image_select',
						'title' => esc_html__( 'Blog Mode', 'impeka' ),
						'subtitle' => esc_html__( 'Select the blog mode', 'impeka' ),
						'options' => $blog_mode_selection,
						'default' => 'large',
					),
					array(
						'id' => 'blog_custom_overview',
						'type' => 'select',
						'title' => esc_html__( 'Blog Custom Overview', 'impeka' ),
						'subtitle' => esc_html__( 'Select if you want to overwrite the style from each post', 'impeka' ),
						'options' => $enable_selection,
						'default' => 'no',
						'required' => array(
							'blog_mode', 'equals', array(
								'small',
								'grid',
								'masonry',
							)
						)
					),
					array(
						'id' => 'blog_small_style',
						'type' => 'select',
						'class' => 'grve-redux-group grve-redux-first',
						'title' => esc_html__( 'Blog Style', 'impeka' ),
						'subtitle' => esc_html__( 'Select the blog style', 'impeka' ),
						'options' =>array(
							'style-small-1' => esc_html__( 'Style 1', 'impeka' ),
							'style-small-2' => esc_html__( 'Style 2', 'impeka' ),
						),
						'default' => 'style-small-1',
						'required' => array( 'blog_mode', 'equals', array( 'small', )
						)
					),
					array(
						'id' => 'blog_style',
						'type' => 'select',
						'class' => 'grve-redux-group grve-redux-first',
						'title' => esc_html__( 'Blog Style', 'impeka' ),
						'subtitle' => esc_html__( 'Select the blog style', 'impeka' ),
						'options' =>array(
							'style-1' => esc_html__( 'Style 1', 'impeka' ),
							'style-2' => esc_html__( 'Style 2', 'impeka' ),
							'style-3' => esc_html__( 'Style 3', 'impeka' ),
						),
						'default' => 'style-1',
						'required' => array(
							'blog_mode', 'equals', array( 'grid', 'masonry', )
						)
					),
					array(
						'id' => 'blog_heading_color',
						'type' => 'select',
						'class' => 'grve-redux-group',
						'title' => esc_html__( 'Blog Heading Color', 'impeka' ),
						'options' => $text_color_selection,
						'default' => 'default',
						'required' => array( 'blog_style', 'equals', array( 'style-2', 'style-3', ))
					),
					array(
						'id' => 'blog_text_color',
						'type' => 'select',
						'class' => 'grve-redux-group',
						'title' => esc_html__( 'Blog Text Color', 'impeka' ),
						'options' => $text_color_selection,
						'default' => 'default',
						'required' => array( 'blog_style', 'equals', array( 'style-2', 'style-3', ))
					),
					array(
						'id' => 'blog_meta_color',
						'type' => 'select',
						'class' => 'grve-redux-group',
						'title' => esc_html__( 'Blog Meta Color', 'impeka' ),
						'options' => $text_color_selection,
						'default' => 'default',
						'required' => array( 'blog_style', 'equals', array( 'style-2', 'style-3', ))
					),
					array(
						'id' => 'blog_bg_color',
						'type' => 'select',
						'class' => 'grve-redux-group',
						'title' => esc_html__( 'Blog Background Color', 'impeka' ),
						'options' => $overlay_color_selection,
						'default' => 'default',
						'required' => array( 'blog_style', 'equals', array( 'style-2', 'style-3', ))
					),
					array(
						'id' => 'blog_border_color',
						'type' => 'select',
						'class' => 'grve-redux-group',
						'title' => esc_html__( 'Blog Border Color', 'impeka' ),
						'options' => $text_color_selection,
						'default' => 'default',
						'required' => array( 'blog_style', 'equals', array( 'style-2' ))
					),
					array(
						'id' => 'blog_overlay_color',
						'type' => 'select',
						'class' => 'grve-redux-group',
						'title' => esc_html__( 'Blog Overlay Color', 'impeka' ),
						'options' => $overlay_color_selection,
						'default' => 'default',
						'required' => array(
							array( 'blog_style', 'equals', 'style-3' ),
						)
					),
					array(
						'id' => 'blog_overlay_opacity',
						'type' => 'select',
						'class' => 'grve-redux-group',
						'title' => esc_html__( 'Blog Overlay Opacity', 'impeka' ),
						'options' => $overlay_opacity_selection,
						'default' => 'default',
						'required' => array(
							array( 'blog_style', 'equals', 'style-3' ),
						)
					),
					array(
						'id' => 'blog_shadow',
						'type' => 'select',
						'class' => 'grve-redux-group',
						'title' => esc_html__( 'Blog Shadow', 'impeka' ),
						'options' => $shadow_selection,
						'default' => 'none',
					),
					array(
						'id' => 'blog_radius',
						'type' => 'select',
						'class' => 'grve-redux-group grve-redux-last',
						'title' => esc_html__( 'Blog Border Radius', 'impeka' ),
						'options' => $border_radius_selection,
						'default' => 'none',
					),
					array(
						'id' => 'blog_indicator',
						'type' => 'select',
						'title' => esc_html__( 'Blog Indicator', 'impeka' ),
						'subtitle' => esc_html__( 'Select the blog indicator.', 'impeka' ),
						'options' => $indicator_selection,
						"default" => 'none',
						'required' => array( 'blog_style', 'equals', array( 'style-2', 'style-3', ))
					),
					array(
						'id' => 'blog_indicator_text', //translatable
						'type' => 'text',
						'title' => esc_html__( 'Blog Indicator Text', 'impeka' ),
						'subtitle' => esc_html__( 'Type the text for the blog indicator text.', 'impeka' ),
						"default" => 'More',
						'required' => array( 'blog_indicator', 'equals', 'text' ),
					),
					array(
						'id' => 'blog_indicator_color',
						'type' => 'select',
						'options' => $color_selection,
						'title' => esc_html__( 'Blog Indicator Color', 'impeka' ),
						'subtitle' => esc_html__( 'Select the color for the blog indicator.', 'impeka' ),
						"default" => 'primary-1',
						'required' => array( 'blog_indicator', '!=', 'none' ),
					),
					array(
						'id' => 'blog_media_area',
						'type' => 'switch',
						'title' => esc_html__( 'Blog Media Area visibility', 'impeka' ),
						'subtitle' => esc_html__( 'Select if you want to enable media area', 'impeka' ),
						"default" => '1',
					),
					array(
						'id' => 'blog_image_width',
						'type' => 'select',
						'title' => esc_html__( 'Blog Image Width', 'impeka' ),
						'subtitle' => esc_html__( 'Select the feature image width.', 'impeka' ),
						'options' => array(
							'normal' => esc_html__( "Normal", "impeka" ),
							'wide' => esc_html__( "Wide", "impeka" ),
						),
						'default' => 'normal',
						'required' => array(
							array( 'blog_mode','equals', 'large' ),
							array( 'blog_media_area', 'equals', '1' ),
						),
					),
					array(
						'id' => 'blog_image_mode',
						'type' => 'select',
						'title' => esc_html__( 'Blog Image Size', 'impeka' ),
						'subtitle' => esc_html__( 'Select your Blog Image Size', 'impeka' ),
						'options' => $blog_image_mode_selection,
						'default' => 'landscape-large-wide',
						'required' => array(
							array( 'blog_mode','equals', 'large' ),
							array( 'blog_media_area', 'equals', '1' ),
						),
					),
					array(
						'id' => 'blog_grid_image_mode',
						'type' => 'select',
						'title' => esc_html__( 'Blog Grid Image Size', 'impeka' ),
						'subtitle' => esc_html__( 'Select your Blog Image Size', 'impeka' ),
						'options' => $grid_image_mode_selection,
						'default' => 'landscape',
						'required' => array(
							array( 'blog_mode','!=', 'large' ),
							array( 'blog_mode','!=', 'masonry' ),
							array( 'blog_media_area', 'equals', '1' ),
						),
					),
					array(
						'id' => 'blog_masonry_image_mode',
						'type' => 'select',
						'title' => esc_html__( 'Blog Masonry_Image Size', 'impeka' ),
						'subtitle' => esc_html__( 'Select your Blog Masonry Image Size', 'impeka' ),
						'options' => $masonry_image_mode_selection,
						'default' => 'medium',
						'required' => array(
							array( 'blog_mode','equals', 'masonry' ),
							array( 'blog_media_area', 'equals', '1' ),
						),
					),
					array(
						'id' => 'blog_image_prio',
						'type' => 'select',
						'title' => esc_html__( 'Blog Featured Image Priority', 'impeka' ),
						'subtitle' => esc_html__( 'If enabled, Featured image is displayed instead of media element', 'impeka' ),
						'options' => $enable_selection,
						'default' => 'no',
						'required' => array( 'blog_media_area', 'equals', '1' ),
					),
					array(
						'id' => 'blog_columns_large_screen',
						'type' => 'select',
						'class' => 'grve-redux-group grve-redux-first',
						'title' => esc_html__( 'Blog Columns Large Screens', 'impeka' ),
						'subtitle' => esc_html__( 'Select the Blog Columns for large screens', 'impeka' ),
						'options' => $grid_columns_selection,
						'default' => '3',
						'required' => array(
							array( 'blog_mode','!=', 'large' ),
							array( 'blog_mode','!=', 'small' ),
						),
					),
					array(
						'id' => 'blog_columns',
						'type' => 'select',
						'class' => 'grve-redux-group',
						'title' => esc_html__( 'Blog Columns', 'impeka' ),
						'subtitle' => esc_html__( 'Select the Blog Columns', 'impeka' ),
						'options' => $grid_columns_selection,
						'default' => '3',
						'required' => array(
							array( 'blog_mode','!=', 'large' ),
							array( 'blog_mode','!=', 'small' ),
						),
					),
					array(
						'id' => 'blog_columns_tablet_landscape',
						'type' => 'select',
						'class' => 'grve-redux-group',
						'title' => esc_html__( 'Blog Tablet Landscape Columns', 'impeka' ),
						'subtitle' => esc_html__( 'Select responsive column on tablet devices, landscape orientation.', 'impeka' ),
						'options' => $grid_columns_selection_tablet,
						'default' => '2',
						'required' => array(
							array( 'blog_mode','!=', 'large' ),
							array( 'blog_mode','!=', 'small' ),
						),
					),
					array(
						'id' => 'blog_columns_tablet_portrait',
						'type' => 'select',
						'class' => 'grve-redux-group',
						'title' => esc_html__( 'Blog Tablet Portrait Columns', 'impeka' ),
						'subtitle' => esc_html__( 'Select responsive column on tablet devices, portrait orientation.', 'impeka' ),
						'options' => $grid_columns_selection_tablet,
						'default' => '2',
						'required' => array(
							array( 'blog_mode','!=', 'large' ),
							array( 'blog_mode','!=', 'small' ),
						),
					),
					array(
						'id' => 'blog_columns_mobile',
						'type' => 'select',
						'class' => 'grve-redux-group grve-redux-last',
						'title' => esc_html__( 'Blog Mobile Columns', 'impeka' ),
						'subtitle' => esc_html__( 'Select responsive column on mobile devices.', 'impeka' ),
						'options' => $grid_columns_selection_mobile,
						'default' => '1',
						'required' => array(
							array( 'blog_mode','!=', 'large' ),
							array( 'blog_mode','!=', 'small' ),
						),
					),
					array(
						'id' => 'blog_gutter',
						"type" => "select",
						'class' => 'grve-redux-group grve-redux-first',
						"title" => esc_html__( "Gutter between items", "impeka" ),
						'subtitle' => esc_html__( 'Add gutter among items.', 'impeka' ),
						"options" => array(
							'yes' => esc_html__( "Yes", "impeka" ),
							'no' => esc_html__( "No", "impeka" ),
						),
						'default' => 'yes',
						'required' => array(
							array( 'blog_mode','!=', 'large' ),
							array( 'blog_mode','!=', 'small' ),
						),
					),
					array(
						'id'=>'blog_gutter_size',
						'type' => 'text',
						'class' => 'grve-redux-group grve-redux-last',
						'default' => '30',
						'title' => esc_html__( 'Gutter Size', 'impeka' ),
						'subtitle' => esc_html__( 'Define the gutter size.', 'impeka' ),
						'required' => array(
							array( 'blog_mode','!=', 'large' ),
							array( 'blog_mode','!=', 'small' ),
							array( 'blog_gutter','equals', 'yes' ),
						),
					),
					array(
						"id" => "blog_display_style",
						"type" => "select",
						"title" => esc_html__( "Display Style", "impeka"),
						"subtitle" => esc_html__("Define your pagination style.", "impeka" ),
						"options" => array(
							'pagination' => esc_html__( "Pagination", "impeka" ),
							"load-more" => esc_html__( "Load More", "impeka" ),
							"infinite-scroll" => esc_html__( "Infinite Scroll", "impeka" ),
						),
						'default' => 'pagination',
						'required' => array( 'blog_mode', '!=', 'large' ),
					),
					array(
						'id' => 'blog_load_more_title', //translatable
						'type' => 'text',
						'default' => 'Load More',
						'title' => esc_html__( 'Load More Title', 'impeka' ),
						'subtitle' => esc_html__( 'Title for load more.', 'impeka' ),
						'required' => array( 'blog_display_style', 'equals', 'load-more' ),
					),
					array(
						"id" => "blog_animation",
						"type" => "select",
						"title" => esc_html__( "Blog CSS Animation", "impeka"),
						"subtitle" => esc_html__("Select type of animation if you want this element to be animated when it enters into the browsers viewport. Note: Works only in modern browsers.", "impeka" ),
						"options" => array(
							'none' => esc_html__( "No", "impeka" ),
							"fade-in" => esc_html__( "Fade In", "impeka" ),
							"fade-in-up" => esc_html__( "Fade In Up", "impeka" ),
							"fade-in-down" => esc_html__( "Fade In Down", "impeka" ),
							"fade-in-left" => esc_html__( "Fade In Left", "impeka" ),
							"fade-in-right" => esc_html__( "Fade In Right", "impeka" ),
							"zoom-in" => esc_html__( "Zoom In", "impeka" ),
						),
						'default' => 'none',
					),
					array(
						'id' => 'blog_heading_tag',
						'type' => 'select',
						'class' => 'grve-redux-group grve-redux-first',
						'title' => esc_html__( 'Blog Title Tag', 'impeka' ),
						'subtitle' => esc_html__( 'Select tag for your blog title.', 'impeka' ),
						'options' => $blog_headings_tag_selection,
						'default' => 'auto',
					),
					array(
						'id' => 'blog_heading',
						'type' => 'select',
						'class' => 'grve-redux-group grve-redux-last',
						'title' => esc_html__( 'Blog Title Size', 'impeka' ),
						'subtitle' => esc_html__( 'Select size and typography for your blog title.', 'impeka' ),
						'options' => $blog_headings_selection,
						'default' => 'auto',
					),
					array(
						'id'=>'blog_excerpt_length',
						'type' => 'text',
						'default' => '30',
						'title' => esc_html__( 'Excerpt Length', 'impeka' ),
						'subtitle' => esc_html__( 'Type how many words you want to display in your post excerpts (Default is 30).', 'impeka' ),
						'validate' => 'numeric',
						'required' => array( 'blog_mode', '!=', 'large' ),
					),
					array(
						'id' => 'blog_auto_excerpt',
						'type' => 'switch',
						'title' => esc_html__( 'Auto Excerpt', 'impeka' ),
						'subtitle'=> esc_html__( "Adds automatic excerpt to all posts. If auto excerpt is off, blog will show all content, a desired 'cut-off' can be inserted in each post with more quicktag.", 'impeka' ),
						"default" => '1',
						'required' => array( 'blog_mode', 'equals', 'large' ),
					),

					array(
						'id'=>'blog_excerpt_length_large',
						'type' => 'text',
						'default' => '55',
						'title' => esc_html__( 'Excerpt Length', 'impeka' ),
						'subtitle' => esc_html__( 'Type how many words you want to display in your post excerpts (Default is 55).', 'impeka' ),
						'validate' => 'numeric',
						'required' => array(
							array( 'blog_auto_excerpt', 'equals', '1' ),
							array( 'blog_mode', 'equals', 'large' ),
						),
					),
					array(
						'id' => 'blog_excerpt_more',
						'type' => 'switch',
						'title' => esc_html__( 'Read More', 'impeka' ),
						'subtitle'=> esc_html__( "Adds a read more button after the excerpt or more quicktag.", 'impeka' ),
						"default" => '1',
					),
					array(
						'id' => 'blog_excerpt_more_text', //translatable
						'type' => 'text',
						'title' => esc_html__( 'Read More Text', 'impeka' ),
						"default" => 'read more',
						'required' => array(
							array( 'blog_excerpt_more', 'equals', '1' ),

						),
					),
					array(
						'id'=>'blog_comments_visibility',
						'type' => 'switch',
						'class' => 'grve-redux-group grve-redux-first',
						'title' => esc_html__( 'Comments Field Visibility', 'impeka' ),
						'subtitle'=> esc_html__( 'Enable or Disable the comments field of your blog overview.', 'impeka' ),
						"default" => '1',
					),
					array(
						'id'=>'blog_author_visibility',
						'type' => 'switch',
						'class' => 'grve-redux-group',
						'title' => esc_html__( 'Author Field Visibility', 'impeka' ),
						'subtitle'=> esc_html__( 'Enable or Disable the author field of your blog overview.', 'impeka' ),
						"default" => '1',
					),
					array(
						'id'=>'blog_date_visibility',
						'type' => 'switch',
						'class' => 'grve-redux-group',
						'title' => esc_html__( 'Date Field Visibility', 'impeka' ),
						'subtitle'=> esc_html__( 'Enable or Disable the date field of your blog overview.', 'impeka' ),
						"default" => '1',
					),
					array(
						'id'=>'blog_like_visibility',
						'type' => 'switch',
						'class' => 'grve-redux-group',
						'title' => esc_html__( 'Like Field Visibility', 'impeka' ),
						'subtitle'=> esc_html__( 'Enable or Disable the like field of your blog overview.', 'impeka' ),
						"default" => '0',
					),
					array(
						'id'=>'blog_categories_visibility',
						'type' => 'switch',
						'class' => 'grve-redux-group grve-redux-last',
						'title' => esc_html__( 'Categories Field Visibility', 'impeka' ),
						'subtitle'=> esc_html__( 'Enable or Disable the categories field of your blog overview.', 'impeka' ),
						"default" => '1',
					),
					array(
						'id' => 'blog_categories_mode',
						'type' => 'select',
						'compiler' => true,
						'title' => esc_html__( 'Categories Mode', 'impeka' ),
						'subtitle' => esc_html__( 'Select your categories mode.', 'impeka' ),
						'options' => array(
							'all' => esc_html__( 'All', 'impeka' ),
							'one' => esc_html__( 'First / Primary', 'impeka' ),
						),
						'default' => 'all',
						'required' => array( 'blog_categories_visibility', '=', '1' ),
					),
					array(
						'id'   => 'info_style_blog_header',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Blog Header Settings', 'impeka' ),
						'subtitle'=> esc_html__( 'Set the style for the default blog header.', 'impeka' ),
					),
					array(
						'id' => 'blog_header_skin',
						'type' => 'select',
						'title' => esc_html__( 'Blog Header Skin', 'impeka' ),
						'subtitle'=> esc_html__( 'Select your blog header skin.', 'impeka' ),
						'options' => $header_skin,
						'default' => 'default',
					),
					array(
						'id' => 'blog_header_overlapping',
						'type' => 'select',
						'title' => esc_html__( 'Blog Header Overlapping', 'impeka' ),
						'subtitle'=> esc_html__( 'Select if you want the Blog Header overlaps the content. Combine this option with the Light or Dark Header.', 'impeka' ),
						'options' => $enable_selection,
						'default' => 'no',
					),
					array(
						'id'=>'blog_title',
						'type' => 'select',
						'title' => esc_html__( 'Main Blog Title', 'impeka' ),
						'subtitle'=> esc_html__( 'Select if you want to use the site name and tagline as the main blog title or hide it.', 'impeka' ),
						'options' => array(
							'sitetitle' => esc_html__( 'Site Title / Tagline', 'impeka' ),
							'custom' => esc_html__( 'Custom Title / Description', 'impeka' ),
							'none' => esc_html__( 'None', 'impeka' ),
						),
						'default' => 'sitetitle',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'blog_custom_title', //translatable
						'type' => 'text',
						'default' => '',
						'title' => esc_html__( 'Custom Title', 'impeka' ),
						'subtitle' => esc_html__( 'Enter blog custom title.', 'impeka' ),
						'required' => array( 'blog_title', 'equals', 'custom' ),
					),
					array(
						'id' => 'blog_custom_description', //translatable
						'type' => 'text',
						'default' => '',
						'title' => esc_html__( 'Custom Description', 'impeka' ),
						'subtitle' => esc_html__( 'Enter blog custom description.', 'impeka' ),
						'required' => array( 'blog_title', 'equals', 'custom' ),
					),
					array(
						'id' => 'blog_title_height',
						'type' => 'select',
						'default' => 'small',
						'title' => esc_html__( 'Height', 'impeka' ),
						'subtitle' => esc_html__( 'Enter blog title height.', 'impeka' ),
						'options' => $area_height,
						'validate' => 'not_empty',
					),
					array(
						'id' => 'blog_title_min_height',
						'type' => 'text',
						'default' => '200',
						'title' => esc_html__( 'Minimum Height', 'impeka' ),
						'subtitle' => esc_html__( 'Enter blog title minimum height in px (Default is 200).', 'impeka' ),
						'validate' => 'numeric',
					),
					array(
						'id' => 'blog_title_container_size',
						'type' => 'select',
						'title' => esc_html__( 'Container Size', 'impeka' ),
						'subtitle'=> esc_html__( 'Select the size of the container.', 'impeka' ),
						'options' => $container_size_selection,
						'default' => 'default',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'blog_title_content_size',
						'type' => 'select',
						'title' => esc_html__( 'Content Size', 'impeka' ),
						'subtitle'=> esc_html__( 'Select the size of the content.', 'impeka' ),
						'options' => $content_size_selection,
						'default' => 'container',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'blog_title_content_alignment',
						'type' => 'image_select',
						'title' => esc_html__( 'Content Alignment', 'impeka' ),
						'subtitle'=> esc_html__( 'Select the alignment of the content.', 'impeka' ),
						'options' => $align_title,
						'default' => 'center',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'blog_title_content_position',
						'type' => 'image_select',
						'title' => esc_html__( 'Content Position', 'impeka' ),
						'subtitle'=> esc_html__( 'Select your position for the default blog title/description.', 'impeka' ),
						'options' => $align_position,
						'class' => 'small-image-selector',
						'default' => 'center-center',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'blog_title_content_animation',
						'type' => 'select',
						'title' => esc_html__( 'Content Animation', 'impeka' ),
						'subtitle'=> esc_html__( 'Select your animation for the default blog title/description.', 'impeka' ),
						'options' => $animation_selection,
						'default' => 'none',
						'validate' => 'not_empty',
					),
					array(
						'id'       => 'blog_title_bg_mode',
						'type'     => 'select',
						'title' => esc_html__( 'Background Mode', 'impeka' ),
						'subtitle'=> esc_html__( 'Select the Background for the blog page, Color or Image.', 'impeka' ),
						'options' => $title_bg_mode_limited,
						'default'  => 'color',
					),
					array(
						'id'       => 'blog_title_bg_image',
						'type'     => 'media',
						'title' => esc_html__( 'Background Image', 'impeka' ),
						'subtitle' => esc_html__( 'Select a background image for the default blog title.', 'impeka' ),
						'required' => array( 'blog_title_bg_mode', 'equals', 'custom' ),
					),
					array(
						'id' => 'blog_title_bg_position',
						'type' => 'select',
						'title' => esc_html__( 'Background Position', 'impeka' ),
						'options' => $align_selection_full,
						'default' => 'center-center',
						'validate' => 'not_empty',
						'required' => array( 'blog_title_bg_mode', '!=', 'color' ),
					),
					array(
						'id' => 'blog_title_pattern_overlay',
						'type' => 'select',
						'title' => esc_html__( 'Pattern Overlay', 'impeka' ),
						'options' => $pattern_selection,
						'default' => 'none',
						'required' => array( 'blog_title_bg_mode', '!=', 'color' ),
					),
					array(
						'id' => 'blog_title_color_overlay',
						'type' => 'select',
						'title' => esc_html__( 'Color Overlay', 'impeka' ),
						'options' => $color_selection,
						'default' => 'black',
						'required' => array( 'blog_title_bg_mode', '!=', 'color' ),
					),
					array(
						'id' => 'blog_title_opacity_overlay',
						'type' => 'select',
						'title' => esc_html__( 'Opacity Overlay', 'impeka' ),
						'options' => $opacity_selection,
						'default' => '0',
						'required' => array( 'blog_title_bg_mode', '!=', 'color' ),
					),
				)
			);

			$this->sections[] = array(
				'title' => esc_html__( 'Single Post Settings', 'impeka' ),
				'id' => 'grve_redux_section_single_post_settings',
				'header' => '',
				'desc' => esc_html__( 'Define your preferences for the Single Posts. Notice that most of them can be overridden when you create a single post.', 'impeka' ),
				'submenu' => true,
				'icon' => 'el-icon-edit',
				'icon_class' => 'el-icon-large',
				'customizer' => false,
				'subsection' => true,
				'fields' => array(
					array(
						'id' => 'post_padding_top_multiplier',
						'type' => 'select',
						'title' => esc_html__( 'Post Top Padding', 'impeka' ),
						'subtitle'=> esc_html__( 'Select the space above the content area.', 'impeka' ),
						'options' => $padding_selection_extra,
						'default' => '3x',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'post_padding_top',
						'type' => 'text',
						'title' => esc_html__( 'Post Custom Top Padding', 'impeka' ),
						'subtitle'=> esc_html__( 'You can use px, em, %, etc. or enter just number and it will use pixels.', 'impeka' ),
						'required' => array( 'post_padding_top_multiplier', 'equals', 'custom' ),
					),
					array(
						'id' => 'post_padding_bottom_multiplier',
						'type' => 'select',
						'title' => esc_html__( 'Post Bottom Padding', 'impeka' ),
						'subtitle'=> esc_html__( 'Select the space below the content area.', 'impeka' ),
						'options' => $padding_selection_extra,
						'default' => '3x',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'post_padding_bottom',
						'type' => 'text',
						'title' => esc_html__( 'Post Custom Bottom Padding', 'impeka' ),
						'subtitle'=> esc_html__( 'You can use px, em, %, etc. or enter just number and it will use pixels.', 'impeka' ),
						'required' => array( 'post_padding_bottom_multiplier', 'equals', 'custom' ),
					),
					array(
						'id' => 'post_layout',
						'type' => 'image_select',
						'compiler' => true,
						'title' => esc_html__( 'Post Layout', 'impeka' ),
						'subtitle' => esc_html__( 'Select the layout for the Single Posts. Choose among Full Width, Left Sidebar or Right Sidebar.', 'impeka' ),
						'options' => $layout_selection,
						'default' => 'none',
					),
					array(
						'id' => 'post_sidebar',
						'type' => 'select',
						'title' => esc_html__( 'Post Sidebar', 'impeka' ),
						'subtitle' => esc_html__( 'Select the sidebar for the Single Posts.', 'impeka' ),
						'data' => 'sidebar',
						'default' => 'grve-default-sidebar',
					),
					array(
						'id' => 'post_fixed_sidebar',
						'type' => 'select',
						'title' => esc_html__( 'Post Fixed Sidebar', 'impeka' ),
						'subtitle'=> esc_html__( 'Select if you want a fixed sidebar.', 'impeka' ),
						'options' => $enable_selection,
						'default' => 'no',
					),
					array(
						'id' => 'post_content_width',
						'type' => 'select',
						'title' => esc_html__( 'Post Content Width', 'impeka' ),
						'subtitle' => esc_html__( 'Select the Single Post Content width (only for Full Width Post Layout)', 'impeka' ),
						'options' => $container_size_selector,
						'default' => 'small',
					),
					array(
						'id' => 'post_sidearea_visibility',
						'type' => 'select',
						'title' => esc_html__( 'Post Side Area Visibility', 'impeka' ),
						'subtitle' => esc_html__( 'Enable the Post Side Area if you want.', 'impeka' ),
						'options' => $enable_selection,
						'default' => 'no',
					),
					array(
						'id' => 'post_sidearea_sidebar',
						'type' => 'select',
						'title' => esc_html__( 'Post Side Area Sidebar', 'impeka' ),
						'subtitle' => esc_html__( 'Select the sidebar widget area for the side area.', 'impeka' ),
						'data' => 'sidebar',
						'default' => 'grve-default-sidebar',
					),
					array(
						'id' => 'post_sidearea_icon_style',
						'type' => 'image_select',
						'compiler' => true,
						'title' => esc_html__( 'Post Side Area Icon', 'impeka' ),
						'subtitle'=> esc_html__( 'Select the icon for your side area.', 'impeka' ),
						'options' => $burger_icon_selection,
						'default' => 'style-5',
						'class' => 'small-image-selector',
						'required' => array(
							array( 'header_icon_library', 'equals', 'theme-icons' ),
							array( 'post_sidearea_visibility', 'equals', 'yes' ),
						),
					),
					array(
						'id' => 'post_feature_media_type',
						'type' => 'select',
						'title' => esc_html__( 'Post Feature Media Type', 'impeka' ),
						'subtitle' => esc_html__( 'Select the feature media type ( not applicable when sidebar is used ).', 'impeka' ),
						'options' => array(
							'normal' => esc_html__( "Normal", "impeka" ),
							'wide' => esc_html__( "Wide", "impeka" ),
						),
						'default' => 'normal',
					),
					array(
						'id' => 'post_feature_image_visibility',
						'type' => 'switch',
						'title' => esc_html__( 'Featured Image Visibility (Standard Post)', 'impeka' ),
						'subtitle'=> esc_html__( 'Toggle Featured Image on or off.', 'impeka' ),
						"default" => '1',
					),
					array(
						'id' => 'post_tag_visibility',
						'type' => 'switch',
						'title' => esc_html__( 'Post Tags Visibility', 'impeka' ),
						'subtitle'=> esc_html__( 'Enable or Disable the post tags.', 'impeka' ),
						"default" => '1',
					),
					array(
						'id' => 'post_category_visibility',
						'type' => 'switch',
						'title' => esc_html__( 'Post Categories Visibility', 'impeka' ),
						'subtitle'=> esc_html__( 'Enable or Disable the post categories.', 'impeka' ),
						"default" => '1',
					),
					array(
						'id' => 'post_author_visibility',
						'type' => 'switch',
						'title' => esc_html__( 'Author Info Visibility', 'impeka' ),
						'subtitle'=> esc_html__( 'Enable or Disable the Author Info field.', 'impeka' ),
						"default" => '1',
					),
					array(
						'id' => 'post_author_info_link_text',
						'type' => 'text',
						'title' => esc_html__( 'Author Info Link Text', 'impeka' ),
						'subtitle' => esc_html__( 'Type the text for the author info link.', 'impeka' ),
						"default" => 'All stories by :',
						'required' => array( 'post_author_visibility', 'equals', '1' ),
					),
					array(
						'id'=>'post_comments_visibility',
						'type' => 'switch',
						'title' => esc_html__( 'Comments Visibility', 'impeka' ),
						'subtitle'=> esc_html__( 'Enable or Disable the comments of your single posts.', 'impeka' ),
						"default" => '1',
					),
					array(
						'id' => 'post_comments_position',
						'type' => 'select',
						'title' => esc_html__( 'Comments Position', 'impeka' ),
						'subtitle'=> esc_html__( 'Select where to display comments area ', 'impeka' ),
						'desc' => esc_html__( 'Automatic: if sidebar exists comments are displayed below content otherwise in a separate section.', 'impeka'),
						'options' => array(
							'auto' => esc_html__( 'Automatic', 'impeka' ),
							'default' => esc_html__( 'Below Content', 'impeka' ),
							'section' => esc_html__( 'Separate Section ', 'impeka' ),
						),
						'default' => 'auto',
						'required' => array( 'post_comments_visibility', 'equals', '1' ),
					),
					array(
						'id'   => 'info_style_post_header',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Post Header Settings', 'impeka' ),
						'subtitle'=> esc_html__( 'Set the style for the default post header.', 'impeka' ),
					),
					array(
						'id' => 'post_header_skin',
						'type' => 'select',
						'title' => esc_html__( 'Post Header Skin', 'impeka' ),
						'subtitle'=> esc_html__( 'Select your post header skin.', 'impeka' ),
						'options' => $header_skin,
						'default' => 'default',
					),
					array(
						'id' => 'post_header_overlapping',
						'type' => 'select',
						'title' => esc_html__( 'Post Header Overlapping', 'impeka' ),
						'subtitle'=> esc_html__( 'Select if you want the Post Header overlaps the content. Combine this option with the Light or Dark Header. You can still override this when you edit each single post.', 'impeka' ),
						'options' => $enable_selection,
						'default' => 'no',
					),
					array(
						'id'   => 'info_style_post_title',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Single Post Title Settings', 'impeka' ),
						'subtitle'=> esc_html__( 'Set the style for the default single post title.', 'impeka' ),
					),
					array(
						'id' => 'post_title_style',
						'type' => 'select',
						'default' => 'simple',
						'title' => esc_html__( 'Title Style', 'impeka' ),
						'subtitle' => esc_html__( 'Select Post Title Style', 'impeka' ),
						'options' => $title_style,
						'validate' => 'not_empty',
					),
					array(
						'id' => 'post_title_height',
						'type' => 'select',
						'default' => 'small',
						'title' => esc_html__( 'Height', 'impeka' ),
						'subtitle' => esc_html__( 'Enter post title height.', 'impeka' ),
						'options' => $area_height,
						'validate' => 'not_empty',
						'required' => array( 'post_title_style', 'equals', 'advanced' ),
					),
					array(
						'id' => 'post_title_min_height',
						'type' => 'text',
						'default' => '200',
						'title' => esc_html__( 'Minimum Height', 'impeka' ),
						'subtitle' => esc_html__( 'Enter post title minimum height in px (Default is 200).', 'impeka' ),
						'validate' => 'numeric',
						'required' => array( 'post_title_style', 'equals', 'advanced' ),
					),
					array(
						'id' => 'post_title_container_size',
						'type' => 'select',
						'title' => esc_html__( 'Container Size', 'impeka' ),
						'subtitle'=> esc_html__( 'Select the size of the container.', 'impeka' ),
						'options' => $container_size_selection,
						'default' => 'default',
						'validate' => 'not_empty',
						'required' => array( 'post_title_style', 'equals', 'advanced' ),
					),
					array(
						'id' => 'post_title_content_size',
						'type' => 'select',
						'title' => esc_html__( 'Content Size', 'impeka' ),
						'subtitle'=> esc_html__( 'Select the size of the content.', 'impeka' ),
						'options' => $content_size_selection,
						'default' => 'large',
						'validate' => 'not_empty',
						'required' => array( 'post_title_style', 'equals', 'advanced' ),
					),
					array(
						'id' => 'post_title_content_alignment',
						'type' => 'image_select',
						'title' => esc_html__( 'Content Alignment', 'impeka' ),
						'subtitle'=> esc_html__( 'Select the alignment of the content.', 'impeka' ),
						'options' => $align_title,
						'default' => 'left',
						'validate' => 'not_empty',
						'required' => array( 'post_title_style', 'equals', 'advanced' ),
					),
					array(
						'id' => 'post_title_content_position',
						'type' => 'image_select',
						'title' => esc_html__( 'Content Position', 'impeka' ),
						'subtitle'=> esc_html__( 'Select your position for the default post title/description.', 'impeka' ),
						'options' => $align_position,
						'class' => 'small-image-selector',
						'default' => 'center-center',
						'validate' => 'not_empty',
						'required' => array( 'post_title_style', 'equals', 'advanced' ),
					),
					array(
						'id' => 'post_title_content_animation',
						'type' => 'select',
						'title' => esc_html__( 'Content Animation', 'impeka' ),
						'subtitle'=> esc_html__( 'Select your animation for the default post title/description.', 'impeka' ),
						'options' => $animation_selection,
						'default' => 'none',
						'validate' => 'not_empty',
						'required' => array( 'post_title_style', 'equals', 'advanced' ),
					),
					array(
						'id'       => 'post_title_bg_mode',
						'type'     => 'select',
						'title' => esc_html__( 'Background Mode', 'impeka' ),
						'subtitle'=> esc_html__( 'Select the Post Title Background, Color or Image.', 'impeka' ),
						'options' => $title_bg_mode,
						'default'  => 'color',
						'required' => array( 'post_title_style', 'equals', 'advanced' ),
					),
					array(
						'id'       => 'post_title_bg_image',
						'type'     => 'media',
						'title' => esc_html__( 'Background Image', 'impeka' ),
						'subtitle' => esc_html__( 'Select a background image for the default post title.', 'impeka' ),
						'required' => array(
							array( 'post_title_style', 'equals', 'advanced' ),
							array( 'post_title_bg_mode', 'equals', 'custom' ),
						),
					),
					array(
						'id' => 'post_title_bg_position',
						'type' => 'select',
						'title' => esc_html__( 'Background Position', 'impeka' ),
						'options' => $align_selection_full,
						'default' => 'center-center',
						'validate' => 'not_empty',
						'required' => array(
							array( 'post_title_style', 'equals', 'advanced' ),
							array( 'post_title_bg_mode', '!=', 'color' ),
						),
					),
					array(
						'id' => 'post_title_pattern_overlay',
						'type' => 'select',
						'title' => esc_html__( 'Pattern Overlay', 'impeka' ),
						'options' => $pattern_selection,
						'default' => 'none',
						'required' => array(
							array( 'post_title_style', 'equals', 'advanced' ),
							array( 'post_title_bg_mode', '!=', 'color' ),
						),
					),
					array(
						'id' => 'post_title_color_overlay',
						'type' => 'select',
						'title' => esc_html__( 'Color Overlay', 'impeka' ),
						'options' => $color_selection,
						'default' => 'black',
						'required' => array(
							array( 'post_title_style', 'equals', 'advanced' ),
							array( 'post_title_bg_mode', '!=', 'color' ),
						),
					),
					array(
						'id' => 'post_title_opacity_overlay',
						'type' => 'select',
						'title' => esc_html__( 'Opacity Overlay', 'impeka' ),
						'options' => $opacity_selection,
						'default' => '0',
						'required' => array(
							array( 'post_title_style', 'equals', 'advanced' ),
							array( 'post_title_bg_mode', '!=', 'color' ),
						),
					),
					array(
						'id'   => 'info_style_post_anchor_menu',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Anchor Menu Bar Settings', 'impeka' ),
						'subtitle'=> esc_html__( 'Define your preferences for the Anchor Menu Bar where you can place a custom sticky menu per post.', 'impeka' ),
					),
					array(
						'id' => 'post_anchor_menu_height',
						'type' => 'text',
						'default' => '60',
						'title' => esc_html__( 'Anchor Menu Height', 'impeka' ),
						'subtitle' => esc_html__( 'Enter Anchor Menu height in px (Default is 60).', 'impeka' ),
						'validate' => 'numeric',
					),
					array(
						'id' => 'post_anchor_menu_alignment',
						'type' => 'select',
						'compiler' => true,
						'title' => esc_html__( 'Anchor Menu Alignment', 'impeka' ),
						'subtitle' => esc_html__( 'Select the alignment of your Anchor Menu in posts.', 'impeka' ),
						'options' => $align_selection_extra,
						'default' => 'left',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'post_anchor_menu_fullwidth',
						'type' => 'switch',
						'title' => esc_html__( 'Fullwidth', 'impeka' ),
						'subtitle'=> esc_html__( 'Select if you want to have full width Anchor Menu.', 'impeka' ),
						'default' => 0,
					),
					array(
						'id'   => 'info_style_post_breadcrumbs',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Breadcrumbs Bar Settings', 'impeka' ),
						'subtitle'=> esc_html__( 'Define your preferences for the Breadcrumbs Bar.', 'impeka' ),
					),
					array(
						'id'=>'post_breadcrumbs_enabled',
						'type' => 'switch',
						'title' => esc_html__( 'Breadcrumbs', 'impeka' ),
						'subtitle'=> esc_html__( 'Enable or Disable the Breadcrumbs for Single Post / Archives / Categories / Tags.', 'impeka' ),
						"default" => '0',
					),
					array(
						'id' => 'post_breadcrumbs_height',
						'type' => 'text',
						'default' => '60',
						'title' => esc_html__( 'Breadcrumbs Height', 'impeka' ),
						'subtitle' => esc_html__( 'Enter Breadcrumbs height in px (Default is 60).', 'impeka' ),
						'validate' => 'numeric',
						'required' => array( 'post_breadcrumbs_enabled', 'equals', '1' ),
					),
					array(
						'id' => 'post_breadcrumbs_alignment',
						'type' => 'select',
						'compiler' => true,
						'title' => esc_html__( 'Breadcrumbs Alignment', 'impeka' ),
						'subtitle' => esc_html__( 'Select the alignment of your breadcrumbs.', 'impeka' ),
						'options' => $align_selection_extra,
						'default' => 'left',
						'validate' => 'not_empty',
						'required' => array( 'post_breadcrumbs_enabled', 'equals', '1' ),
					),
					array(
						'id' => 'post_breadcrumbs_fullwidth',
						'type' => 'switch',
						'title' => esc_html__( 'Fullwidth', 'impeka' ),
						'subtitle'=> esc_html__( 'Select if you want to show your breadcrumbs full width.', 'impeka' ),
						'default' => 0,
						'required' => array( 'post_breadcrumbs_enabled', 'equals', '1' ),
					),
					array(
						'id'   => 'info_style_post_social',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Socials Settings', 'impeka' ),
						'subtitle'=> esc_html__( 'Define your preferences for the social.', 'impeka' ),
					),
					array(
						'id' => 'post_social',
						'type' => 'checkbox',
						'title' => esc_html__( 'Social Share', 'impeka' ),
						'subtitle' => esc_html__( 'Enable or Disable post social shares for the Single Posts.', 'impeka' ),
						'options' => $post_social_options,
						'default' => 0,
					),
					array(
						'id' => 'post_social_layout',
						'type' => 'select',
						'title' => esc_html__( 'Social Share Layout', 'impeka' ),
						'subtitle' => esc_html__( 'Select the Layout for the Social Share Bar', 'impeka' ),
						'options' => array(
							'layout-1' => esc_html__( 'Floating', 'impeka' ),
							'layout-2' => esc_html__( 'Classic', 'impeka' ),
						),
						'default' => 'layout-2',
					),
					array(
						'id' => 'post_social_share_title', //translatable
						'type' => 'text',
						'title' => esc_html__( 'Social Share Title', 'impeka' ),
						'subtitle' => esc_html__( 'Type the text for the social share title.', 'impeka' ),
						"default" => 'Share',
					),
					array(
						'id'   => 'info_style_post_related',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Related Settings', 'impeka' ),
						'subtitle'=> esc_html__( 'Define your preferences for the related posts.', 'impeka' ),
					),
					array(
						'id'=>'post_related_visibility',
						'type' => 'switch',
						'title' => esc_html__( 'Related Posts Visibility', 'impeka' ),
						'subtitle'=> esc_html__( 'Enable or Disable the visibility of the related posts.', 'impeka' ),
						"default" => '1',
					),
					array(
						'id' => 'post_related_mode',
						'type' => 'select',
						'title' => esc_html__( 'Related Posts Mode', 'impeka' ),
						'subtitle' => esc_html__( 'Select posts related mode', 'impeka' ),
						'options' => array(
							'tag' => esc_html__( 'By Tag', 'impeka' ),
							'category' => esc_html__( 'By Category', 'impeka' ),
							'recent' => esc_html__( 'Recent Entries', 'impeka' ),
						),
						'default' => 'tag',
					),
					array(
						'id' => 'post_related_subtitle', //translatable
						'type' => 'text',
						'title' => esc_html__( 'Related Posts Subtitle', 'impeka' ),
						'subtitle' => esc_html__( 'Type the text for the posts related subtitle.', 'impeka' ),
						"default" => '',
						'required' => array( 'post_related_visibility', 'equals', '1' ),
					),
					array(
						'id' => 'post_related_title', //translatable
						'type' => 'text',
						'title' => esc_html__( 'Related Posts Title', 'impeka' ),
						'subtitle' => esc_html__( 'Type the text for the posts related title.', 'impeka' ),
						"default" => 'You might also like',
						'required' => array( 'post_related_visibility', 'equals', '1' ),
					),
					array(
						'id' => 'post_related_backlink_id', //translatable
						'type' => 'select',
						'title' => esc_html__( 'Related Posts Backlink', 'impeka' ),
						'subtitle' => esc_html__( 'Select the overview page for your related post backlink.', 'impeka' ),
						'data' => 'page',
						'default' => '',
						'required' => array( 'post_related_visibility', 'equals', '1' ),
					),
					array(
						'id' => 'post_related_backlink_text', //translatable
						'type' => 'text',
						'title' => esc_html__( 'Related Posts Backlink Text', 'impeka' ),
						'subtitle' => esc_html__( 'Type the text for the posts related backlink.', 'impeka' ),
						"default" => 'Read All Articles',
						'required' => array( 'post_related_visibility', 'equals', '1' ),
					),
					array(
						'id' => 'post_related_indicator',
						'type' => 'select',
						'title' => esc_html__( 'Related Posts Indicator', 'impeka' ),
						'subtitle' => esc_html__( 'Select the posts related indicator.', 'impeka' ),
						'options' => $indicator_selection,
						"default" => 'none',
						'required' => array( 'post_related_visibility', 'equals', '1' ),
					),
					array(
						'id' => 'post_related_indicator_text', //translatable
						'type' => 'text',
						'title' => esc_html__( 'Related Posts Indicator Text', 'impeka' ),
						'subtitle' => esc_html__( 'Type the text for the posts related indicator.', 'impeka' ),
						"default" => 'More',
						'required' => array( 'post_related_indicator', 'equals', 'text' ),
					),
					array(
						'id' => 'post_related_indicator_color',
						'type' => 'select',
						'options' => $color_selection,
						'title' => esc_html__( 'Related Posts Indicator Color', 'impeka' ),
						'subtitle' => esc_html__( 'Select the color for the posts related indicator.', 'impeka' ),
						"default" => 'primary-1',
						'required' => array( 'post_related_visibility', 'equals', '1' ),
					),
					array(
						'id'   => 'info_style_post_nav',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Navigation Settings', 'impeka' ),
						'subtitle'=> esc_html__( 'Define your preferences for the Navigation.', 'impeka' ),
					),
					array(
						'id'=>'post_nav_visibility',
						'type' => 'switch',
						'title' => esc_html__( 'Posts Navigation Visibility', 'impeka' ),
						'subtitle'=> esc_html__( 'Enable or Disable the visibility of the posts navigation.', 'impeka' ),
						"default" => '1',
					),
					array(
						'id' => 'post_nav_same_term',
						'type' => 'switch',
						'title' => esc_html__( 'Post Navigation Same Term', 'impeka' ),
						'subtitle'=> esc_html__( 'If selected, only navigation items from the current taxonomy term will be displayed.', 'impeka' ),
						'default' => 0,
						'required' => array( 'post_nav_visibility', 'equals', '1' ),
					),
					array(
						'id' => 'post_nav_layout',
						'type' => 'select',
						'title' => esc_html__( 'Navigation Layout', 'impeka' ),
						'subtitle' => esc_html__( 'Select the Layout for the Navigation Bar', 'impeka' ),
						'options' => array(
							'layout-1' => esc_html__( 'Simple Layout', 'impeka' ),
							'layout-2' => esc_html__( 'Floating Layout', 'impeka' ),
							'layout-3' => esc_html__( 'Minimal Layout', 'impeka' ),
						),
						'default' => 'layout-1',
						'required' => array( 'post_nav_visibility', 'equals', '1' ),
					),
					array(
						'id' => 'post_nav_prev_text', //translatable
						'type' => 'text',
						'title' => esc_html__( 'Navigation Previous Text', 'impeka' ),
						'subtitle' => esc_html__( 'Type the text for the previous item.', 'impeka' ),
						"default" => 'Previous Post',
						'required' => array( 'post_nav_layout', 'equals', array( 'layout-1', 'layout-3' ) ),
					),
					array(
						'id' => 'post_nav_next_text', //translatable
						'type' => 'text',
						'title' => esc_html__( 'Navigation Next Text', 'impeka' ),
						'subtitle' => esc_html__( 'Type the text for the next item.', 'impeka' ),
						"default" => 'Next Post',
						'required' => array( 'post_nav_layout', 'equals', array( 'layout-1', 'layout-3' ) ),
					),
					array(
						'id' => 'post_backlink_id', //translatable
						'type' => 'select',
						'title' => esc_html__( 'Post Backlink', 'impeka' ),
						'subtitle' => esc_html__( 'Select the overview page for your post backlink.', 'impeka' ),
						'data' => 'page',
						'default' => '',
						'required' => array( 'post_nav_layout', 'equals', array('layout-1', 'layout-2' ) ),
					),
					array(
						'id'             => 'post_nav_spacing',
						'type'           => 'spacing',
						'mode'           => 'padding',
						'units'          => array('em', 'px', '%'),
						'units_extended' => 'false',
						'left'           => 'false',
						'right'          => 'false',
						'title'          => esc_html__( 'Navigation Bar Spacing', 'impeka' ),
						'subtitle'       => esc_html__( 'Set the spacing, Top and Bottom, of the Navigation Area.', 'impeka' ),
						'desc'           => esc_html__( 'Set spacing Top, Bottom in px.', 'impeka'),
						'default'        => array(
							'padding-top'     => '30px',
							'padding-bottom'  => '30px',
							'units'           => 'px',
						),
						'required' => array(
							array( 'post_nav_visibility', 'equals', '1' ),
							array( 'post_nav_layout', '!=', 'layout-2' ),
						),
					),
					array(
						'id' => 'post_nav_skin_assets',
						'type' => 'select',
						'title' => esc_html__( 'Skin Assets', 'impeka' ),
						'subtitle'    => esc_html__( 'Skin for the extra assets.', 'impeka' ),
						'options' => array(
							'dark' => esc_html__( 'Dark', 'impeka' ),
							'light' => esc_html__( 'Light', 'impeka' ),
						),
						'default' => 'dark',
						'required' => array( 'post_nav_layout', 'equals', array('layout-1', 'layout-3' ) ),
					),
					array(
						'id'   => 'info_style_post_quickview',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Quick View', 'impeka' ),
						'subtitle'=> esc_html__( 'Define your preferences for the Quick View.', 'impeka' ),
					),
					array(
						'id' => 'post_quickview_link_text', //translatable
						'type' => 'text',
						'title' => esc_html__( 'Quick View Link Text', 'impeka' ),
						'subtitle' => esc_html__( 'Type the text for the quick view link text.', 'impeka' ),
						"default" => 'Read More',
					),
				)
			);

			$this->sections[] = array(
				'icon' => 'el-icon-pencil',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( 'Page Options', 'impeka'),
				'id' => 'grve_redux_section_page_options',
				'subtitle' => esc_html__( 'You can find the basic settings for the pages here. Almost everything can be overridden when you edit a single page.', 'impeka' ),
				'desc' => esc_html__( 'You can find the basic settings for the pages here. Almost everything can be overridden when you edit a single page.', 'impeka' ),
				'submenu' => true,
				'customizer' => false,
				'fields' => array(
					array(
						'id' => 'page_padding_top_multiplier',
						'type' => 'select',
						'title' => esc_html__( 'Page Top Padding', 'impeka' ),
						'subtitle'=> esc_html__( 'Select the space above the content area.', 'impeka' ),
						'options' => $padding_selection_extra,
						'default' => '3x',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'page_padding_top',
						'type' => 'text',
						'title' => esc_html__( 'Page Custom Top Padding', 'impeka' ),
						'subtitle'=> esc_html__( 'You can use px, em, %, etc. or enter just number and it will use pixels.', 'impeka' ),
						'required' => array( 'page_padding_top_multiplier', 'equals', 'custom' ),
					),
					array(
						'id' => 'page_padding_bottom_multiplier',
						'type' => 'select',
						'title' => esc_html__( 'Page Bottom Padding', 'impeka' ),
						'subtitle'=> esc_html__( 'Select the space below the content area.', 'impeka' ),
						'options' => $padding_selection_extra,
						'default' => '3x',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'page_padding_bottom',
						'type' => 'text',
						'title' => esc_html__( 'Page Custom Bottom Padding', 'impeka' ),
						'subtitle'=> esc_html__( 'You can use px, em, %, etc. or enter just number and it will use pixels.', 'impeka' ),
						'required' => array( 'page_padding_bottom_multiplier', 'equals', 'custom' ),
					),
					array(
						'id' => 'page_layout',
						'type' => 'image_select',
						'compiler' => true,
						'title' => esc_html__( 'Page Layout', 'impeka' ),
						'subtitle' => esc_html__( 'Select the layout for the pages. Choose among Full Width, Left Sidebar or Right Sidebar.', 'impeka' ),
						'options' => $layout_selection,
						'default' => 'none',
					),
					array(
						'id' => 'page_sidebar',
						'type' => 'select',
						'title' => esc_html__( 'Page Sidebar', 'impeka' ),
						'subtitle' => esc_html__( 'Select the default sidebar for the pages in case you do not use full width layout.', 'impeka' ),
						'data' => 'sidebar',
						'default' => 'grve-default-sidebar',
					),
					array(
						'id' => 'page_fixed_sidebar',
						'type' => 'select',
						'title' => esc_html__( 'Page Fixed Sidebar', 'impeka' ),
						'subtitle'=> esc_html__( 'Select if you want a fixed sidebar.', 'impeka' ),
						'options' => $enable_selection,
						'default' => 'no',
					),
					array(
						'id' => 'page_sidearea_visibility',
						'type' => 'select',
						'title' => esc_html__( 'Page Side Area Visibility', 'impeka' ),
						'subtitle' => esc_html__( 'Enable the Side Area for the pages.', 'impeka' ),
						'options' => $enable_selection,
						'default' => 'no',
					),
					array(
						'id' => 'page_sidearea_sidebar',
						'type' => 'select',
						'title' => esc_html__( 'Page Side Area Sidebar', 'impeka' ),
						'subtitle' => esc_html__( 'Select the sidebar for the side area.', 'impeka' ),
						'data' => 'sidebar',
						'default' => 'grve-default-sidebar',
					),
					array(
						'id' => 'page_sidearea_icon_style',
						'type' => 'image_select',
						'compiler' => true,
						'title' => esc_html__( 'Page Side Area Icon', 'impeka' ),
						'subtitle'=> esc_html__( 'Select the icon for your side area.', 'impeka' ),
						'options' => $burger_icon_selection,
						'default' => 'style-5',
						'class' => 'small-image-selector',
						'required' => array(
							array( 'header_icon_library', 'equals', 'theme-icons' ),
							array( 'page_sidearea_visibility', 'equals', 'yes' ),
						),
					),
					array(
						'id'=>'page_comments_visibility',
						'type' => 'switch',
						'title' => esc_html__( 'Comments Visibility', 'impeka' ),
						'subtitle'=> esc_html__( 'Easily disable the comments for all pages.', 'impeka' ),
						"default" => '1',
					),
					array(
						'id'   => 'info_style_page_header',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Page Header Settings', 'impeka' ),
						'subtitle'=> esc_html__( 'Set the style for the default page header.', 'impeka' ),
					),
					array(
						'id' => 'page_header_skin',
						'type' => 'select',
						'title' => esc_html__( 'Page Header Skin', 'impeka' ),
						'subtitle'=> esc_html__( 'Select your page header skin.', 'impeka' ),
						'options' => $header_skin,
						'default' => 'default',
					),
					array(
						'id' => 'page_header_overlapping',
						'type' => 'select',
						'title' => esc_html__( 'Page Header Overlapping', 'impeka' ),
						'subtitle'=> esc_html__( 'Select if you want the Page Header overlaps the content. Combine this option with the Light or Dark Header. You can still override this when you edit each single page.', 'impeka' ),
						'options' => $enable_selection,
						'default' => 'no',
					),
					array(
						'id'   => 'info_style_page_title',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Page Title Settings', 'impeka' ),
						'subtitle'=> esc_html__( 'Set the style for the default page title.', 'impeka' ),
					),
					array(
						'id' => 'page_title_height',
						'type' => 'select',
						'default' => 'small',
						'title' => esc_html__( 'Height', 'impeka' ),
						'subtitle' => esc_html__( 'Enter Page title height.', 'impeka' ),
						'options' => $area_height,
						'validate' => 'not_empty',
					),
					array(
						'id' => 'page_title_min_height',
						'type' => 'text',
						'default' => '200',
						'title' => esc_html__( 'Minimum Height', 'impeka' ),
						'subtitle' => esc_html__( 'Enter page title minimum height in px (Default is 200).', 'impeka' ),
						'validate' => 'numeric',
					),
					array(
						'id' => 'page_title_container_size',
						'type' => 'select',
						'title' => esc_html__( 'Container Size', 'impeka' ),
						'subtitle'=> esc_html__( 'Select the size of the container.', 'impeka' ),
						'options' => $container_size_selection,
						'default' => 'default',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'page_title_content_size',
						'type' => 'select',
						'title' => esc_html__( 'Content Size', 'impeka' ),
						'subtitle'=> esc_html__( 'Select the size of the content.', 'impeka' ),
						'options' => $content_size_selection,
						'default' => 'container',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'page_title_content_alignment',
						'type' => 'image_select',
						'title' => esc_html__( 'Content Alignment', 'impeka' ),
						'subtitle'=> esc_html__( 'Select the alignment of the content.', 'impeka' ),
						'options' => $align_title,
						'default' => 'center',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'page_title_content_position',
						'type' => 'image_select',
						'title' => esc_html__( 'Content Position', 'impeka' ),
						'subtitle'=> esc_html__( 'Select your position for the default page title/description.', 'impeka' ),
						'options' => $align_position,
						'class' => 'small-image-selector',
						'default' => 'center-center',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'page_title_content_animation',
						'type' => 'select',
						'title' => esc_html__( 'Content Animation', 'impeka' ),
						'subtitle'=> esc_html__( 'Select your animation for the default page title/description.', 'impeka' ),
						'options' => $animation_selection,
						'default' => 'none',
						'validate' => 'not_empty',
					),
					array(
						'id'       => 'page_title_bg_mode',
						'type'     => 'select',
						'title' => esc_html__( 'Background Mode', 'impeka' ),
						'subtitle'=> esc_html__( 'Select the Page Title Background, Color or Image.', 'impeka' ),
						'options' => $title_bg_mode,
						'default'  => 'color',
					),
					array(
						'id'       => 'page_title_bg_image',
						'type'     => 'media',
						'title' => esc_html__( 'Background Image', 'impeka' ),
						'subtitle' => esc_html__( 'Select a background image for the default page title.', 'impeka' ),
						'required' => array( 'page_title_bg_mode', 'equals', 'custom' ),
					),
					array(
						'id' => 'page_title_bg_position',
						'type' => 'select',
						'title' => esc_html__( 'Background Position', 'impeka' ),
						'options' => $align_selection_full,
						'default' => 'center-center',
						'validate' => 'not_empty',
						'required' => array( 'page_title_bg_mode', '!=', 'color' ),
					),
					array(
						'id' => 'page_title_pattern_overlay',
						'type' => 'select',
						'title' => esc_html__( 'Pattern Overlay', 'impeka' ),
						'options' => $pattern_selection,
						'default' => 'none',
						'required' => array( 'page_title_bg_mode', '!=', 'color' ),
					),
					array(
						'id' => 'page_title_color_overlay',
						'type' => 'select',
						'title' => esc_html__( 'Color Overlay', 'impeka' ),
						'options' => $color_selection,
						'default' => 'black',
						'required' => array( 'page_title_bg_mode', '!=', 'color' ),
					),
					array(
						'id' => 'page_title_opacity_overlay',
						'type' => 'select',
						'title' => esc_html__( 'Opacity Overlay', 'impeka' ),
						'options' => $opacity_selection,
						'default' => '0',
						'required' => array( 'page_title_bg_mode', '!=', 'color' ),
					),
					array(
						'id'   => 'info_style_page_nav',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Navigation Settings', 'impeka' ),
						'subtitle'=> esc_html__( 'Define your preferences for the Navigation.', 'impeka' ),
					),
					array(
						'id' => 'page_nav_id', //translatable
						'type' => 'select',
						'title' => esc_html__( 'Page Navigation', 'impeka' ),
						'subtitle' => esc_html__( 'Select the navigation page.', 'impeka' ),
						'data' => 'page',
						'default' => '',
					),
					array(
						"id" => "page_nav_hide",
						"type" => "select",
						"title" => esc_html__( "Page Navigation Visibility", "impeka"),
						"subtitle" => esc_html__("Select if you want to hide page navigation in some devices.", "impeka" ),
						"options" => array(
							'never' => esc_html__( "Always Visible", "impeka" ),
							'tablet' => esc_html__( "Hide on Tablet Landscape and below", "impeka" ),
							'tablet-sm' => esc_html__( "Hide on Tablet Portrait and below", "impeka" ),
							'mobile' => esc_html__( "Hide on Mobile Landscape and below", "impeka" ),
						),
						'default' => 'never',
					),
					array(
						'id' => 'page_nav_text', //translatable
						'type' => 'text',
						'title' => esc_html__( 'Navigation Text', 'impeka' ),
						'subtitle' => esc_html__( 'Type the text for the navigation item.', 'impeka' ),
						"default" => 'Next Page',
					),
					array(
						'id'   => 'info_style_page_anchor_menu',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Anchor Menu Bar Settings', 'impeka' ),
						'subtitle'=> esc_html__( 'Define your preferences for the Anchor Menu Bar where you can place a custom sticky menu per page.', 'impeka' ),
					),
					array(
						'id' => 'page_anchor_menu_height',
						'type' => 'text',
						'default' => '60',
						'title' => esc_html__( 'Anchor Menu Height', 'impeka' ),
						'subtitle' => esc_html__( 'Enter Anchor Menu height in px (Default is 60).', 'impeka' ),
						'validate' => 'numeric',
					),
					array(
						'id' => 'page_anchor_menu_alignment',
						'type' => 'select',
						'compiler' => true,
						'title' => esc_html__( 'Anchor Menu Alignment', 'impeka' ),
						'subtitle' => esc_html__( 'Select the alignment of your anchor menu.', 'impeka' ),
						'options' => $align_selection_extra,
						'default' => 'left',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'page_anchor_menu_fullwidth',
						'type' => 'switch',
						'title' => esc_html__( 'Fullwidth', 'impeka' ),
						'subtitle'=> esc_html__( 'Select if you want to show your anchor menu full width.', 'impeka' ),
						'default' => 0,
					),
					array(
						'id'   => 'info_style_page_breadcrumbs',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Breadcrumbs Bar Settings', 'impeka' ),
						'subtitle'=> esc_html__( 'Define your preferences for the Breadcrumbs Bar.', 'impeka' ),
					),
					array(
						'id'=>'page_breadcrumbs_enabled',
						'type' => 'switch',
						'title' => esc_html__( 'Breadcrumbs', 'impeka' ),
						'subtitle'=> esc_html__( 'Enable or Disable the Breadcrumbs for Single Page.', 'impeka' ),
						"default" => '0',
					),
					array(
						'id' => 'page_breadcrumbs_height',
						'type' => 'text',
						'default' => '60',
						'title' => esc_html__( 'Breadcrumbs Height', 'impeka' ),
						'subtitle' => esc_html__( 'Enter Breadcrumbs height in px (Default is 60).', 'impeka' ),
						'validate' => 'numeric',
						'required' => array( 'page_breadcrumbs_enabled', 'equals', '1' ),
					),
					array(
						'id' => 'page_breadcrumbs_alignment',
						'type' => 'select',
						'compiler' => true,
						'title' => esc_html__( 'Breadcrumbs Alignment', 'impeka' ),
						'subtitle' => esc_html__( 'Select the alignment of your breadcrumbs.', 'impeka' ),
						'options' => $align_selection_extra,
						'default' => 'left',
						'validate' => 'not_empty',
						'required' => array( 'page_breadcrumbs_enabled', 'equals', '1' ),
					),
					array(
						'id' => 'page_breadcrumbs_fullwidth',
						'type' => 'switch',
						'title' => esc_html__( 'Fullwidth', 'impeka' ),
						'subtitle'=> esc_html__( 'Select if you want to show your breadcrumbs full width.', 'impeka' ),
						'default' => 0,
						'required' => array( 'page_breadcrumbs_enabled', 'equals', '1' ),
					),
				)
			);

			$this->sections[] = array(
				'icon' => 'el-icon-briefcase',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( 'Portfolio Options', 'impeka' ),
				'id' => 'grve_redux_section_portfolio_options',
				'desc' => esc_html__( 'These settings will  affect on Portfolio Archives / Portfolio Categories / Portfoio Fields overview pages.', 'impeka' ),
				'submenu' => true,
				'customizer' => false,
				'fields' => array(
					array(
						'id'=>'portfolio_slug',
						'type' => 'text',
						'default' => 'portfolio-item',
						'title' => esc_html__( 'Slug', 'impeka' ),
						'subtitle' => esc_html__( "Enter Portfolio Slug (Default is 'portfolio-item'). If you change it, go to Settings - Permalinks and click on Save Changes.", 'impeka' ),
						'desc' => esc_html__( "Slug must not be used anywhere else (e.g: category, page, post).", 'impeka' ),
						'validate' => 'not_empty',
					),
					array(
						'id'=>'portfolio_category_slug',
						'type' => 'text',
						'default' => 'portfolio-category',
						'title' => esc_html__( 'Category Slug', 'impeka' ),
						'subtitle' => esc_html__( "Enter Portfolio Category Slug (Default is 'portfolio-category'). If you change it, go to Settings - Permalinks and click on Save Changes.", 'impeka' ),
						'desc' => esc_html__( "Slug must not be used anywhere else (e.g: category, page, post).", 'impeka' ),
						'validate' => 'not_empty',
					),
					array(
						'id'=>'portfolio_fields_slug',
						'type' => 'text',
						'default' => 'portfolio-fields',
						'title' => esc_html__( 'Fields Slug', 'impeka' ),
						'subtitle' => esc_html__( "Enter Portfolio Fields Slug (Default is 'portfolio-fields'). If you change it, go to Settings - Permalinks and click on Save Changes.", 'impeka' ),
						'desc' => esc_html__( "Slug must not be used anywhere else (e.g: category, page, post).", 'impeka' ),
						'validate' => 'not_empty',
					),
					array(
						'id' => 'portfolio_tax_layout',
						'type' => 'image_select',
						'compiler' => true,
						'title' => esc_html__( 'Portfolio Taxonomy Layout', 'impeka' ),
						'subtitle' => esc_html__( 'Select the default layout for the Portfolio Taxonomy. Choose among Full Width, Left Sidebar or Right Sidebar.', 'impeka' ),
						'options' => $layout_selection,
						'default' => 'none',
					),
					array(
						'id' => 'portfolio_tax_sidebar',
						'type' => 'select',
						'title' => esc_html__( 'Portfolio Taxonomy Sidebar', 'impeka' ),
						'subtitle' => esc_html__( 'Select the default sidebar for the single Portfolio Taxonomy.', 'impeka' ),
						'data' => 'sidebar',
						'default' => 'grve-default-sidebar',
					),
					array(
						'id' => 'portfolio_tax_fixed_sidebar',
						'type' => 'select',
						'title' => esc_html__( 'Portfolio Taxonomy Fixed Sidebar', 'impeka' ),
						'subtitle'=> esc_html__( 'Select if you want a fixed sidebar.', 'impeka' ),
						'options' => $enable_selection,
						'default' => 'no',
					),
					array(
						'id' => 'portfolio_tax_sidearea_visibility',
						'type' => 'select',
						'title' => esc_html__( 'Portfolio Taxonomy Side Area Visibility', 'impeka' ),
						'subtitle' => esc_html__( 'Enable the Side Area for the Portfolio Taxonomy.', 'impeka' ),
						'options' => $enable_selection,
						'default' => 'no',
					),
					array(
						'id' => 'portfolio_tax_sidearea_sidebar',
						'type' => 'select',
						'title' => esc_html__( 'Portfolio Taxonomy Side Area Sidebar', 'impeka' ),
						'subtitle' => esc_html__( 'Select the sidebar widget area for the side area.', 'impeka' ),
						'data' => 'sidebar',
						'default' => 'grve-default-sidebar',
					),
					array(
						'id' => 'portfolio_tax_sidearea_icon_style',
						'type' => 'image_select',
						'compiler' => true,
						'title' => esc_html__( 'Portfolio Taxonomy Side Area Icon', 'impeka' ),
						'subtitle'=> esc_html__( 'Select the icon for your side area.', 'impeka' ),
						'options' => $burger_icon_selection,
						'default' => 'style-5',
						'class' => 'small-image-selector',
						'required' => array(
							array( 'header_icon_library', 'equals', 'theme-icons' ),
							array( 'portfolio_tax_sidearea_visibility', 'equals', 'yes' ),
						),
					),
					array(
						'id'   => 'info_style_portfolio_tax_settings',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Portfolio Taxonomy Style and Portfolio Archive Settings', 'impeka' ),
						'subtitle'=> esc_html__( 'Set the style and basic settings for the portfolio taxonomy.', 'impeka' ),
					),
					array(
						'id' => 'portfolio_tax_mode',
						'type' => 'image_select',
						'title' => esc_html__( 'Portfolio Taxonomy Mode', 'impeka' ),
						'subtitle' => esc_html__( 'Select the portfolio taxonomy mode', 'impeka' ),
						'options' =>$portfolio_tax_mode_selection,
						'default' => 'masonry',
					),
					array(
						'id' => 'portfolio_tax_image_mode',
						'type' => 'select',
						'title' => esc_html__( 'Portfolio Taxonomy Image Size', 'impeka' ),
						'subtitle' => esc_html__( 'Select your Grid Image Size', 'impeka' ),
						'options' => $grid_image_mode_selection,
						'default' => 'landscape',
						'required' => array(
							array( 'portfolio_tax_mode', '!=', 'masonry' ),
						),
					),
					array(
						'id' => 'portfolio_tax_masonry_image_mode',
						'type' => 'select',
						'title' => esc_html__( 'Portfolio Taxonomy Masonry Image Size', 'impeka' ),
						'subtitle' => esc_html__( 'Select your Masonry Image Size', 'impeka' ),
						'options' => array(
							'auto' => esc_html__( 'Autocrop', 'impeka' ),
							'extra-extra-large' => esc_html__( 'Resize ( Extra Extra Large )', 'impeka' ),
							'large' => esc_html__( 'Resize ( Large )', 'impeka' ),
							'medium_large' => esc_html__( 'Resize ( Medium Large )', 'impeka' ),
							'medium' => esc_html__( 'Resize ( Medium )', 'impeka' ),
							'custom' => esc_html__( 'Custom', 'impeka' ),
						),
						'default' => 'auto',
						'required' => array(
							array( 'portfolio_tax_mode','equals', 'masonry' ),
						),
					),
					array(
						'id' => 'portfolio_tax_columns_large_screen',
						'type' => 'select',
						'title' => esc_html__( 'Portfolio Taxonomy Large Screen Columns', 'impeka' ),
						'subtitle' => esc_html__( 'Select the Portfolio Taxonomy Columns on large screen devices', 'impeka' ),
						'options' => $grid_columns_selection,
						'default' => '3',
						'required' => array( 'portfolio_tax_mode', '!=', 'small' ),
					),
					array(
						'id' => 'portfolio_tax_columns',
						'type' => 'select',
						'title' => esc_html__( 'Portfolio Taxonomy Columns', 'impeka' ),
						'subtitle' => esc_html__( 'Select the Portfolio Taxonomy Columns', 'impeka' ),
						'options' => $grid_columns_selection,
						'default' => '3',
						'required' => array( 'portfolio_tax_mode', '!=', 'small' ),
					),
					array(
						'id' => 'portfolio_tax_columns_tablet_landscape',
						'type' => 'select',
						'title' => esc_html__( 'Portfolio Taxonomy Tablet Landscape Columns', 'impeka' ),
						'subtitle' => esc_html__( 'Select responsive column on tablet devices, landscape orientation.', 'impeka' ),
						'options' => $grid_columns_selection_tablet,
						'default' => '2',
						'required' => array( 'portfolio_tax_mode', '!=', 'small' ),
					),
					array(
						'id' => 'portfolio_tax_columns_tablet_portrait',
						'type' => 'select',
						'title' => esc_html__( 'Portfolio Taxonomy Tablet Portrait Columns', 'impeka' ),
						'subtitle' => esc_html__( 'Select responsive column on tablet devices, portrait orientation.', 'impeka' ),
						'options' => $grid_columns_selection_tablet,
						'default' => '2',
						'required' => array( 'portfolio_tax_mode', '!=', 'small' ),
					),
					array(
						'id' => 'portfolio_tax_columns_mobile',
						'type' => 'select',
						'title' => esc_html__( 'Portfolio Taxonomy Mobile Columns', 'impeka' ),
						'subtitle' => esc_html__( 'Select responsive column on mobile devices.', 'impeka' ),
						'options' => $grid_columns_selection_mobile,
						'default' => '1',
						'required' => array( 'portfolio_tax_mode', '!=', 'small' ),
					),
					array(
						'id' => 'portfolio_tax_gutter',
						"type" => "select",
						"title" => esc_html__( "Gutter between items", "impeka" ),
						'subtitle' => esc_html__( 'Add gutter among items.', 'impeka' ),
						"options" => array(
							'yes' => esc_html__( "Yes", "impeka" ),
							'no' => esc_html__( "No", "impeka" ),
						),
						'default' => 'yes',
					),
					array(
						'id'=>'portfolio_tax_gutter_size',
						'type' => 'text',
						'default' => '30',
						'title' => esc_html__( 'Gutter Size', 'impeka' ),
						'subtitle' => esc_html__( 'Define the gutter size.', 'impeka' ),
						'required' => array(
							array( 'portfolio_tax_gutter','equals', 'yes' ),
						),
					),
					array(
						"id" => "portfolio_tax_overview_type",
						"type" => "select",
						"title" => esc_html__( "Overview Type", "impeka"),
						"subtitle" => esc_html__("Select the overview type of your portfolio items.", "impeka" ),
						"options" => array(
							'default' => esc_html__( "Default", "impeka" ),
							"custom-overview" => esc_html__( "Custom Overview", "impeka" ),
						),
						'default' => 'default',
					),
					array(
						"id" => "portfolio_tax_display_style",
						"type" => "select",
						"title" => esc_html__( "Display Style", "impeka"),
						"subtitle" => esc_html__("Define your pagination style.", "impeka" ),
						"options" => array(
							'pagination' => esc_html__( "Pagination", "impeka" ),
							"load-more" => esc_html__( "Load More", "impeka" ),
							"infinite-scroll" => esc_html__( "Infinite Scroll", "impeka" ),
						),
						'default' => 'pagination',
					),
					array(
						'id' => 'portfolio_tax_load_more_title', //translatable
						'type' => 'text',
						'default' => 'Load More',
						'title' => esc_html__( 'Load More Title', 'impeka' ),
						'subtitle' => esc_html__( 'Title for load more.', 'impeka' ),
						'required' => array( 'portfolio_tax_display_style', 'equals', 'load-more' ),
					),
					array(
						"id" => "portfolio_tax_animation",
						"type" => "select",
						"title" => esc_html__( "Portfolio Taxonomy CSS Animation", "impeka"),
						"subtitle" => esc_html__("Select type of animation if you want this element to be animated when it enters into the browsers viewport. Note: Works only in modern browsers.", "impeka" ),
						"options" => array(
							'none' => esc_html__( "No", "impeka" ),
							"fade-in" => esc_html__( "Fade In", "impeka" ),
							"fade-in-up" => esc_html__( "Fade In Up", "impeka" ),
							"fade-in-down" => esc_html__( "Fade In Down", "impeka" ),
							"fade-in-left" => esc_html__( "Fade In Left", "impeka" ),
							"fade-in-right" => esc_html__( "Fade In Right", "impeka" ),
							"zoom-in" => esc_html__( "Zoom In", "impeka" ),
						),
						'default' => 'none',
					),
					array(
						'id'   => 'info_style_portfolio_tax_hovers',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Portfolio Taxonomy Loop Style & Hover Settings', 'impeka' ),
						'subtitle'=> esc_html__( 'Set the hover settings for the Portfolio Taxonomy Loop.', 'impeka' ),
					),
					array(
						'id'=>'portfolio_tax_loop_style',
						'type' => 'select',
						'title' => esc_html__( 'Portfolio Taxonomy Loop Style', 'impeka' ),
						'subtitle' => esc_html__( 'Select the hover style for the portfolio overview.', 'impeka' ),
						'options' => array(
							'style-1' => esc_html__( 'Text below image' , 'impeka' ),
							'style-2' => esc_html__( 'Split text on hover' , 'impeka' ),
							'style-3' => esc_html__( 'Text on media' , 'impeka' ),
							'style-4' => esc_html__( 'Tilt media on hover' , 'impeka' ),
							'style-5' => esc_html__( 'Cursor effect' , 'impeka' ),
							'style-6' => esc_html__( 'Mouse move effect' , 'impeka' ),
							'style-7' => esc_html__( 'Gradient Overlay' , 'impeka' ),
						),
						'default' => 'style-1',
					),
					array(
						'id' => 'portfolio_tax_loop_title_caption',
						'type' => 'select',
						'title' => esc_html__( 'Portfolio Taxonomy Loop Title & Description Visibility', 'impeka' ),
						'subtitle' => esc_html__( 'Define the visibility for your title - description.', 'impeka' ),
						'options' => array(
							'none' => esc_html__( 'None' , 'impeka' ) ,
							'title-caption' => esc_html__( 'Title and Description' , 'impeka' ),
							'title-only' => esc_html__( 'Title Only' , 'impeka' ),
							'caption-only' => esc_html__( 'Description Only' , 'impeka' ),
						),
						'default' => 'title-caption',
					),
					array(
						'id' => 'portfolio_tax_loop_heading_tag',
						'type' => 'select',
						'title' => esc_html__( 'Portfolio Taxonomy Loop Title Tag', 'impeka' ),
						'subtitle' => esc_html__( 'Select tag for your title.', 'impeka' ),
						'options' => $headings_tag_selection,
						'default' => 'h3',
						'required' => array(
							'portfolio_tax_loop_title_caption', 'equals', array(
								'title-caption',
								'title-only',
							)
						),
					),
					array(
						'id' => 'portfolio_tax_loop_heading',
						'type' => 'select',
						'title' => esc_html__( 'Portfolio Taxonomy Loop Title Size', 'impeka' ),
						'subtitle' => esc_html__( 'Select size and typography for your title.', 'impeka' ),
						'options' => $headings_selection,
						'default' => 'h4',
						'required' => array(
							'portfolio_tax_loop_title_caption', 'equals', array(
								'title-caption',
								'title-only',
							)
						),
					),
					array(
						'id'=>'portfolio_tax_loop_title_color',
						'type' => 'select',
						'title' => esc_html__( 'Portfolio Taxonomy Loop Title Color', 'impeka' ),
						'subtitle' => esc_html__( 'Select the color of your title.', 'impeka' ),
						'options' => $text_color_selection,
						'default' => 'default',
						'required' => array(
							'portfolio_tax_loop_title_caption', 'equals', array(
								'title-caption',
								'title-only',
							)
						),
					),
					array(
						'id'=>'portfolio_tax_loop_title_bg_color',
						'type' => 'select',
						'title' => esc_html__( 'Portfolio Taxonomy Loop Title Background Color', 'impeka' ),
						'subtitle' => esc_html__( 'Select the background color of your title.', 'impeka' ),
						'options' => $transparent_text_color_selection,
						'default' => 'transparent',
						'required' => array(
							array( 'portfolio_tax_loop_style', 'equals', array( 'style-5' ) ),
							array( 'portfolio_tax_loop_title_caption', 'equals', array( 'title-caption', 'title-only' ) ),
						),
					),



					array(
						'id'=>'portfolio_tax_loop_text_color',
						'type' => 'select',
						'title' => esc_html__( 'Portfolio Taxonomy Loop Description/Text Color', 'impeka' ),
						'subtitle' => esc_html__( 'Choose the description/text color.', 'impeka' ),
						'options' => $text_color_selection,
						'default' => 'default',
						'required' => array(
							'portfolio_tax_loop_title_caption', 'equals', array(
								'title-caption',
								'caption-only',
							)
						),
					),
					array(
						'id'=>'portfolio_tax_loop_text_bg_color',
						'type' => 'select',
						'title' => esc_html__( 'Portfolio Taxonomy Loop Description/Text Background Color', 'impeka' ),
						'subtitle' => esc_html__( 'Choose the description/text Background color.', 'impeka' ),
						'options' => $transparent_text_color_selection,
						'default' => 'transparent',
						'required' => array(
							array( 'portfolio_tax_loop_style', 'equals', array( 'style-5' ) ),
							array( 'portfolio_tax_loop_title_caption', 'equals', array( 'title-caption', 'title-only' ) ),
						),
					),
					array(
						'id' => 'portfolio_tax_indicator',
						'type' => 'select',
						'title' => esc_html__( 'Portfolio Indicator', 'impeka' ),
						'subtitle' => esc_html__( 'Select the portfolio indicator.', 'impeka' ),
						'options' => $indicator_selection,
						"default" => 'none',
						'required' => array( 'portfolio_tax_loop_style', '!=', 'style-5' ),
					),
					array(
						'id' => 'portfolio_tax_indicator_text', //translatable
						'type' => 'text',
						'title' => esc_html__( 'Portfolio Indicator Text', 'impeka' ),
						'subtitle' => esc_html__( 'Type the text for the portfolio indicator text.', 'impeka' ),
						"default" => 'More',
						'required' => array( 'portfolio_tax_indicator', 'equals', 'text' ),
					),
					array(
						'id' => 'portfolio_tax_indicator_color',
						'type' => 'select',
						'options' => $color_selection,
						'title' => esc_html__( 'Portfolio Indicator Color', 'impeka' ),
						'subtitle' => esc_html__( 'Select the color for the portfolio indicator.', 'impeka' ),
						"default" => 'primary-1',
						'required' => array( 'portfolio_tax_indicator', '!=', 'none' ),
					),
					array(
						'id'=>'portfolio_tax_loop_image_effect',
						'type' => 'select',
						'title' => esc_html__( 'Portfolio Taxonomy Image Effect', 'impeka' ),
						'subtitle' => esc_html__( 'Select the hover style for the portfolio overview.', 'impeka' ),
						'options' => array(
							'none' => esc_html__( 'None' , 'impeka' ),
							'grayscale-image' => esc_html__( 'Grayscale Image' , 'impeka' ),
							'grayscale-image-hover' => esc_html__( 'Colored on Hover' , 'impeka' ),
						),
						'default' => 'none',
					),
					array(
						'id'=>'portfolio_tax_loop_overlay_color',
						'type' => 'select',
						'title' => esc_html__( 'Portfolio Taxonomy Loop Overlay Color', 'impeka' ),
						'subtitle' => esc_html__( 'Choose the image color overlay.', 'impeka' ),
						'options' => $dominant_overlay_color_selection,
						'default' => 'white',
						'required' => array( 'portfolio_tax_loop_style', '!=', 'style-7' ),
					),
					array(
						'id'=>'portfolio_tax_loop_overlay_opacity',
						'type' => 'select',
						'title' => esc_html__( 'Portfolio Taxonomy Loop Overlay Opacity', 'impeka' ),
						'subtitle' => esc_html__( 'Choose the opacity for the overlay.', 'impeka' ),
						'options' => $overlay_opacity_selection,
						'default' => '90',
					),
					array(
						'id'=>'portfolio_tax_loop_radius',
						'type' => 'select',
						'title' => esc_html__( 'Portfolio Taxonomy Border Radius', 'impeka' ),
						'subtitle' => esc_html__( 'Select the border radius of the portfolio item', 'impeka' ),
						'options' => $border_radius_selection,
						'default' => 'none',
					),
					array(
						'id'=>'portfolio_tax_loop_shadow',
						'type' => 'select',
						'title' => esc_html__( 'Portfolio Taxonomy Add Shadow', 'impeka' ),
						'subtitle' => esc_html__( 'Select the border radius of the portfolio item', 'impeka' ),
						'options' => $shadow_selection,
						'default' => 'no',
					),
					array(
						'id'   => 'info_style_portfolio_tax_header',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Portfolio Taxonomy Header Settings', 'impeka' ),
						'subtitle'=> esc_html__( 'Set the style for the default Portfolio Taxonomy header.', 'impeka' ),
					),
					array(
						'id' => 'portfolio_tax_header_skin',
						'type' => 'select',
						'title' => esc_html__( 'Portfolio Taxonomy Header Skin', 'impeka' ),
						'subtitle'=> esc_html__( 'Select your Portfolio Taxonomy header skin.', 'impeka' ),
						'options' => $header_skin,
						'default' => 'default',
					),
					array(
						'id' => 'portfolio_tax_header_overlapping',
						'type' => 'select',
						'title' => esc_html__( 'Portfolio Taxonomy Header Overlapping', 'impeka' ),
						'subtitle'=> esc_html__( 'Select if you want the Portfolio Taxonomy Header overlaps the content. Combine this option with the Light or Dark Header.', 'impeka' ),
						'options' => $enable_selection,
						'default' => 'no',
					),
					array(
						'id'   => 'info_style_portfolio_tax_title',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Portfolio Taxonomy Title Settings', 'impeka' ),
						'subtitle'=> esc_html__( 'Set the style for the default Portfolio Taxonomy title.', 'impeka' ),
					),
					array(
						'id' => 'portfolio_archive_title', //translatable
						'type' => 'text',
						'title' => esc_html__( 'Portfolio Archive Title', 'impeka' ),
						'subtitle' => esc_html__( 'Type the text for the portfolio archive title.', 'impeka' ),
						"default" => 'Projects',
					),
					array(
						'id' => 'portfolio_archive_description', //translatable
						'type' => 'text',
						'title' => esc_html__( 'Portfolio Archive Description', 'impeka' ),
						'subtitle' => esc_html__( 'Type the text for the portfolio archive description.', 'impeka' ),
						"default" => '',
					),
					array(
						'id' => 'portfolio_tax_title_height',
						'type' => 'select',
						'default' => 'small',
						'title' => esc_html__( 'Height', 'impeka' ),
						'subtitle' => esc_html__( 'Enter Portfolio Taxonomy title height (Default is 60%).', 'impeka' ),
						'options' => $area_height,
						'validate' => 'not_empty',
					),
					array(
						'id' => 'portfolio_tax_title_min_height',
						'type' => 'text',
						'default' => '320',
						'title' => esc_html__( 'Min Height', 'impeka' ),
						'subtitle' => esc_html__( 'Enter Portfolio Taxonomy title minimum height in px (Default is 320).', 'impeka' ),
						'validate' => 'numeric',
					),
					array(
						'id' => 'portfolio_tax_title_container_size',
						'type' => 'select',
						'title' => esc_html__( 'Container Size', 'impeka' ),
						'subtitle'=> esc_html__( 'Select the size of the container.', 'impeka' ),
						'options' => $container_size_selection,
						'default' => 'default',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'portfolio_tax_title_content_size',
						'type' => 'select',
						'title' => esc_html__( 'Content Size', 'impeka' ),
						'subtitle'=> esc_html__( 'Select the size of the content.', 'impeka' ),
						'options' => $content_size_selection,
						'default' => 'container',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'portfolio_tax_title_content_alignment',
						'type' => 'image_select',
						'title' => esc_html__( 'Content Alignment', 'impeka' ),
						'subtitle'=> esc_html__( 'Select the alignment of the content.', 'impeka' ),
						'options' => $align_title,
						'default' => 'center',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'portfolio_tax_title_content_position',
						'type' => 'image_select',
						'title' => esc_html__( 'Content Position', 'impeka' ),
						'subtitle'=> esc_html__( 'Select your position for the default Portfolio Taxonomy title/description.', 'impeka' ),
						'options' => $align_position,
						'class' => 'small-image-selector',
						'default' => 'center-center',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'portfolio_tax_title_content_animation',
						'type' => 'select',
						'title' => esc_html__( 'Content Animation', 'impeka' ),
						'subtitle'=> esc_html__( 'Select your animation for the default Portfolio Taxonomy title/description.', 'impeka' ),
						'options' => $animation_selection,
						'default' => 'none',
						'validate' => 'not_empty',
					),
					array(
						'id'       => 'portfolio_tax_title_bg_mode',
						'type'     => 'select',
						'title' => esc_html__( 'Background Mode', 'impeka' ),
						'subtitle'=> esc_html__( 'Select the Portfolio Taxonomy Title Background, Color or Image.', 'impeka' ),
						'options' => $title_bg_mode_limited,
						'default'  => 'color',
					),
					array(
						'id'       => 'portfolio_tax_title_bg_image',
						'type'     => 'media',
						'title' => esc_html__( 'Background Image', 'impeka' ),
						'subtitle' => esc_html__( 'Select a background image for the default Portfolio Taxonomy title.', 'impeka' ),
						'required' => array( 'portfolio_tax_title_bg_mode', 'equals', 'custom' ),
					),
					array(
						'id' => 'portfolio_tax_title_bg_position',
						'type' => 'select',
						'title' => esc_html__( 'Background Position', 'impeka' ),
						'options' => $align_selection_full,
						'default' => 'center-center',
						'validate' => 'not_empty',
						'required' => array( 'portfolio_tax_title_bg_mode', '!=', 'color' ),
					),
					array(
						'id' => 'portfolio_tax_title_pattern_overlay',
						'type' => 'select',
						'title' => esc_html__( 'Pattern Overlay', 'impeka' ),
						'options' => $pattern_selection,
						'default' => 'none',
						'required' => array( 'portfolio_tax_title_bg_mode', '!=', 'color' ),
					),
					array(
						'id' => 'portfolio_tax_title_color_overlay',
						'type' => 'select',
						'title' => esc_html__( 'Color Overlay', 'impeka' ),
						'options' => $color_selection,
						'default' => 'black',
						'required' => array( 'portfolio_tax_title_bg_mode', '!=', 'color' ),
					),
					array(
						'id' => 'portfolio_tax_title_opacity_overlay',
						'type' => 'select',
						'title' => esc_html__( 'Opacity Overlay', 'impeka' ),
						'options' => $opacity_selection,
						'default' => '0',
						'required' => array( 'portfolio_tax_title_bg_mode', '!=', 'color' ),
					),

				)
			);

			$this->sections[] = array(
				'icon' => 'el-icon-briefcase',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( 'Single Portfolio Settings', 'impeka' ),
				'id' => 'grve_redux_section_single_portfolio_settings',
				'submenu' => true,
				'customizer' => false,
				'subsection' => true,
				'fields' => array(
					array(
						'id' => 'portfolio_padding_top_multiplier',
						'type' => 'select',
						'title' => esc_html__( 'Portfolio Top Padding', 'impeka' ),
						'subtitle'=> esc_html__( 'Select the space above the content area.', 'impeka' ),
						'options' => $padding_selection_extra,
						'default' => '3x',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'portfolio_padding_top',
						'type' => 'text',
						'title' => esc_html__( 'Portfolio Custom Top Padding', 'impeka' ),
						'subtitle'=> esc_html__( 'You can use px, em, %, etc. or enter just number and it will use pixels.', 'impeka' ),
						'required' => array( 'portfolio_padding_top_multiplier', 'equals', 'custom' ),
					),
					array(
						'id' => 'portfolio_padding_bottom_multiplier',
						'type' => 'select',
						'title' => esc_html__( 'Portfolio Bottom Padding', 'impeka' ),
						'subtitle'=> esc_html__( 'Select the space below the content area.', 'impeka' ),
						'options' => $padding_selection_extra,
						'default' => '3x',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'portfolio_padding_bottom',
						'type' => 'text',
						'title' => esc_html__( 'Portfolio Custom Bottom Padding', 'impeka' ),
						'subtitle'=> esc_html__( 'You can use px, em, %, etc. or enter just number and it will use pixels.', 'impeka' ),
						'required' => array( 'portfolio_padding_bottom_multiplier', 'equals', 'custom' ),
					),
					array(
						'id' => 'portfolio_layout',
						'type' => 'image_select',
						'compiler' => true,
						'title' => esc_html__( 'Portfolio Layout', 'impeka' ),
						'subtitle' => esc_html__( 'Select the default layout for the Portfolio (single portfolio items). Choose among Full Width, Left Sidebar or Right Sidebar.', 'impeka' ),
						'options' => $layout_selection,
						'default' => 'none',
					),
					array(
						'id' => 'portfolio_sidebar',
						'type' => 'select',
						'title' => esc_html__( 'Portfolio Sidebar', 'impeka' ),
						'subtitle' => esc_html__( 'Select the default sidebar for the single portfolio items.', 'impeka' ),
						'data' => 'sidebar',
						'default' => 'grve-default-sidebar',
					),
					array(
						'id' => 'portfolio_fixed_sidebar',
						'type' => 'select',
						'title' => esc_html__( 'Portfolio Fixed Sidebar', 'impeka' ),
						'subtitle'=> esc_html__( 'Select if you want a fixed sidebar.', 'impeka' ),
						'options' => $enable_selection,
						'default' => 'no',
					),
					array(
						'id' => 'portfolio_sidearea_visibility',
						'type' => 'select',
						'title' => esc_html__( 'Portfolio Side Area Visibility', 'impeka' ),
						'subtitle' => esc_html__( 'Enable the Side Area for the single portfolio items.', 'impeka' ),
						'options' => $enable_selection,
						'default' => 'no',
					),
					array(
						'id' => 'portfolio_sidearea_sidebar',
						'type' => 'select',
						'title' => esc_html__( 'Portfolio Side Area Sidebar', 'impeka' ),
						'subtitle' => esc_html__( 'Select the sidebar widget area for the side area.', 'impeka' ),
						'data' => 'sidebar',
						'default' => 'grve-default-sidebar',
					),
					array(
						'id' => 'portfolio_sidearea_icon_style',
						'type' => 'image_select',
						'compiler' => true,
						'title' => esc_html__( 'Portfolio Side Area Icon', 'impeka' ),
						'subtitle'=> esc_html__( 'Select the icon for your side area.', 'impeka' ),
						'options' => $burger_icon_selection,
						'default' => 'style-5',
						'class' => 'small-image-selector',
						'required' => array(
							array( 'header_icon_library', 'equals', 'theme-icons' ),
							array( 'portfolio_sidearea_visibility', 'equals', 'yes' ),
						),
					),
					array(
						'id' => 'portfolio_details_mode',
						'type' => 'select',
						'title' => esc_html__( 'Portfolio Details Area', 'impeka' ),
						'subtitle' => esc_html__( 'Select if you want to enable Portfolio details area.', 'impeka' ),
						'options' => $enable_selection,
						"default" => 'no',
					),
					array(
						'id' => 'portfolio_details_text', //translatable
						'type' => 'text',
						'title' => esc_html__( 'Portfolio Details Text', 'impeka' ),
						'subtitle' => esc_html__( 'Type the text for the Portfolio Details title.', 'impeka' ),
						"default" => 'Project Details',
					),
					array(
						'id' => 'portfolio_details_heading_tag',
						'type' => 'select',
						'title' => esc_html__( 'Portfolio Details Text Heading Tag', 'impeka' ),
						'subtitle' => esc_html__( 'Select the headings tag for your Portfolio Details Text.', 'impeka' ),
						'options' => $headings_tag_selection,
						'default' => 'div',
					),
					array(
						'id' => 'portfolio_details_link_text', //translatable
						'type' => 'text',
						'title' => esc_html__( 'Portfolio Details Link Text', 'impeka' ),
						'subtitle' => esc_html__( 'Type the text for the Portfolio Details link text.', 'impeka' ),
						"default" => 'View Project',
					),
					array(
						'id'=>'portfolio_category_visibility',
						'type' => 'switch',
						'title' => esc_html__( 'Category Visibility', 'impeka' ),
						'subtitle'=> esc_html__( 'Enable or Disable the portfolio categories.', 'impeka' ),
						"default" => '1',
					),
					array(
						'id'=>'portfolio_comments_visibility',
						'type' => 'switch',
						'title' => esc_html__( 'Comments Visibility', 'impeka' ),
						'subtitle'=> esc_html__( 'Enable or Disable the comments of your portfolio.', 'impeka' ),
						"default" => '1',
					),
					array(
						'id'   => 'info_style_portfolio_header',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Portfolio Header Settings', 'impeka' ),
						'subtitle'=> esc_html__( 'Set the style for the default portfolio header.', 'impeka' ),
					),
					array(
						'id' => 'portfolio_header_skin',
						'type' => 'select',
						'title' => esc_html__( 'Portfolio Header Skin', 'impeka' ),
						'subtitle'=> esc_html__( 'Select your portfolio header skin.', 'impeka' ),
						'options' => $header_skin,
						'default' => 'default',
					),
					array(
						'id' => 'portfolio_header_overlapping',
						'type' => 'select',
						'title' => esc_html__( 'Portfolio Header Overlapping', 'impeka' ),
						'subtitle'=> esc_html__( 'Select if you want the Portfolio Header overlaps the content. Combine this option with the Light or Dark Header. You can still override this when you edit each single portfolio.', 'impeka' ),
						'options' => $enable_selection,
						'default' => 'no',
					),
					array(
						'id'   => 'info_style_portfolio_title',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Portfolio Title Settings', 'impeka' ),
						'subtitle'=> esc_html__( 'Set the style for the single default portfolio title.', 'impeka' ),
					),
					array(
						'id' => 'portfolio_title_height',
						'type' => 'select',
						'default' => 'small',
						'title' => esc_html__( 'Height', 'impeka' ),
						'subtitle' => esc_html__( 'Enter portfolio title height.', 'impeka' ),
						'options' => $area_height,
						'validate' => 'not_empty',
					),
					array(
						'id' => 'portfolio_title_min_height',
						'type' => 'text',
						'default' => '200',
						'title' => esc_html__( 'Min Height', 'impeka' ),
						'subtitle' => esc_html__( 'Enter portfolio title minimum height in px (Default is 200).', 'impeka' ),
						'validate' => 'numeric',
					),
					array(
						'id' => 'portfolio_title_container_size',
						'type' => 'select',
						'title' => esc_html__( 'Container Size', 'impeka' ),
						'subtitle'=> esc_html__( 'Select the size of the container.', 'impeka' ),
						'options' => $container_size_selection,
						'default' => 'default',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'portfolio_title_content_size',
						'type' => 'select',
						'title' => esc_html__( 'Content Size', 'impeka' ),
						'subtitle'=> esc_html__( 'Select the size of the content.', 'impeka' ),
						'options' => $content_size_selection,
						'default' => 'container',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'portfolio_title_content_alignment',
						'type' => 'image_select',
						'title' => esc_html__( 'Content Alignment', 'impeka' ),
						'subtitle'=> esc_html__( 'Select the alignment of the content.', 'impeka' ),
						'options' => $align_title,
						'default' => 'center',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'portfolio_title_content_position',
						'type' => 'image_select',
						'title' => esc_html__( 'Content Position', 'impeka' ),
						'subtitle'=> esc_html__( 'Select your position for the default portfolio title/description.', 'impeka' ),
						'options' => $align_position,
						'class' => 'small-image-selector',
						'default' => 'center-center',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'portfolio_title_content_animation',
						'type' => 'select',
						'title' => esc_html__( 'Content Animation', 'impeka' ),
						'subtitle'=> esc_html__( 'Select your animation for the default portfolio title/description.', 'impeka' ),
						'options' => $animation_selection,
						'default' => 'none',
						'validate' => 'not_empty',
					),
					array(
						'id'       => 'portfolio_title_bg_mode',
						'type'     => 'select',
						'title' => esc_html__( 'Background Mode', 'impeka' ),
						'subtitle'=> esc_html__( 'Select the Portfolio Title Background, Color or Image.', 'impeka' ),
						'options' => $title_bg_mode,
						'default'  => 'color',
					),
					array(
						'id'       => 'portfolio_title_bg_image',
						'type'     => 'media',
						'title' => esc_html__( 'Background Image', 'impeka' ),
						'subtitle' => esc_html__( 'Select a background image for the default portfolio title.', 'impeka' ),
						'required' => array( 'portfolio_title_bg_mode', 'equals', 'custom' ),
					),
					array(
						'id' => 'portfolio_title_bg_position',
						'type' => 'select',
						'title' => esc_html__( 'Background Position', 'impeka' ),
						'options' => $align_selection_full,
						'default' => 'center-center',
						'validate' => 'not_empty',
						'required' => array( 'portfolio_title_bg_mode', '!=', 'color' ),
					),
					array(
						'id' => 'portfolio_title_pattern_overlay',
						'type' => 'select',
						'title' => esc_html__( 'Pattern Overlay', 'impeka' ),
						'options' => $pattern_selection,
						'default' => 'none',
						'required' => array( 'portfolio_title_bg_mode', '!=', 'color' ),
					),
					array(
						'id' => 'portfolio_title_color_overlay',
						'type' => 'select',
						'title' => esc_html__( 'Color Overlay', 'impeka' ),
						'options' => $color_selection,
						'default' => 'black',
						'required' => array( 'portfolio_title_bg_mode', '!=', 'color' ),
					),
					array(
						'id' => 'portfolio_title_opacity_overlay',
						'type' => 'select',
						'title' => esc_html__( 'Opacity Overlay', 'impeka' ),
						'options' => $opacity_selection,
						'default' => '0',
						'required' => array( 'portfolio_title_bg_mode', '!=', 'color' ),
					),
					array(
						'id'   => 'info_style_portfolio_anchor_menu',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Anchor Menu Bar Settings', 'impeka' ),
						'subtitle'=> esc_html__( 'Define your preferences for the Anchor Menu Bar where you can place a custom sticky menu per portfolio item.', 'impeka' ),
					),
					array(
						'id' => 'portfolio_anchor_menu_height',
						'type' => 'text',
						'default' => '60',
						'title' => esc_html__( 'Anchor Menu Height', 'impeka' ),
						'subtitle' => esc_html__( 'Enter Anchor Menu height in px (Default is 60).', 'impeka' ),
						'validate' => 'numeric',
					),
					array(
						'id' => 'portfolio_anchor_menu_alignment',
						'type' => 'select',
						'compiler' => true,
						'title' => esc_html__( 'Anchor Menu Alignment', 'impeka' ),
						'subtitle' => esc_html__( 'Select the alignment of your anchor menu.', 'impeka' ),
						'options' => $align_selection_extra,
						'default' => 'left',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'portfolio_anchor_menu_fullwidth',
						'type' => 'switch',
						'title' => esc_html__( 'Fullwidth', 'impeka' ),
						'subtitle'=> esc_html__( 'Select if you want to show your anchor menu full width.', 'impeka' ),
						'default' => 0,
					),
					array(
						'id'   => 'info_style_portfolio_breadcrumbs',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Breadcrumbs Bar Settings', 'impeka' ),
						'subtitle'=> esc_html__( 'Define your preferences for the Breadcrumbs Bar.', 'impeka' ),
					),
					array(
						'id'=>'portfolio_breadcrumbs_enabled',
						'type' => 'switch',
						'title' => esc_html__( 'Breadcrumbs', 'impeka' ),
						'subtitle'=> esc_html__( 'Enable or Disable the Breadcrumbs for Single Portfolio.', 'impeka' ),
						"default" => '0',
					),
					array(
						'id' => 'portfolio_breadcrumbs_height',
						'type' => 'text',
						'default' => '60',
						'title' => esc_html__( 'Breadcrumbs Height', 'impeka' ),
						'subtitle' => esc_html__( 'Enter Breadcrumbs height in px (Default is 60).', 'impeka' ),
						'validate' => 'numeric',
						'required' => array( 'portfolio_breadcrumbs_enabled', 'equals', '1' ),
					),
					array(
						'id' => 'portfolio_breadcrumbs_alignment',
						'type' => 'select',
						'compiler' => true,
						'title' => esc_html__( 'Breadcrumbs Alignment', 'impeka' ),
						'subtitle' => esc_html__( 'Select the alignment of your breadcrumbs.', 'impeka' ),
						'options' => $align_selection_extra,
						'default' => 'left',
						'validate' => 'not_empty',
						'required' => array( 'portfolio_breadcrumbs_enabled', 'equals', '1' ),
					),
					array(
						'id' => 'portfolio_breadcrumbs_fullwidth',
						'type' => 'switch',
						'title' => esc_html__( 'Fullwidth', 'impeka' ),
						'subtitle'=> esc_html__( 'Select if you want to show your breadcrumbs full width.', 'impeka' ),
						'default' => 0,
						'required' => array( 'portfolio_breadcrumbs_enabled', 'equals', '1' ),
					),
					array(
						'id'   => 'info_style_portfolio_socials',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Socials Settings', 'impeka' ),
						'subtitle'=> esc_html__( 'Define your preferences for the Socials.', 'impeka' ),
					),
					array(
						'id' => 'portfolio_social_bar_layout',
						'type' => 'select',
						'title' => esc_html__( 'Socials Layout', 'impeka' ),
						'subtitle' => esc_html__( 'Select the Layout for Socials', 'impeka' ),
						'options' => array(
							'layout-1' => esc_html__( 'Bottom Layout', 'impeka' ),
							'layout-2' => esc_html__( 'Side Layout', 'impeka' ),
						),
						'default' => 'layout-1',
					),
					array(
						'id' => 'portfolio_social',
						'type' => 'checkbox',
						'title' => esc_html__( 'Social Share', 'impeka' ),
						'subtitle' => esc_html__( 'Enable or Disable the social shares you like in the single portfolio items.', 'impeka' ),
						'options' => $portfolio_social_options,
						'default' => 0,
					),
					array(
						'id' => 'portfolio_social_layout',
						'type' => 'select',
						'title' => esc_html__( 'Social Share Layout', 'impeka' ),
						'subtitle' => esc_html__( 'Select the Layout for the Social Share Bar', 'impeka' ),
						'options' => array(
							'layout-1' => esc_html__( 'Floating', 'impeka' ),
							'layout-2' => esc_html__( 'Classic', 'impeka' ),
						),
						'default' => 'layout-2',
						'required' => array( 'portfolio_social_bar_layout', 'equals', 'layout-1' ),
					),
					array(
						'id' => 'portfolio_social_share_title', //translatable
						'type' => 'text',
						'title' => esc_html__( 'Social Share Title', 'impeka' ),
						'subtitle' => esc_html__( 'Type the text for the social share title.', 'impeka' ),
						"default" => 'Share',
					),
					array(
						'id'   => 'info_style_portfolio_related',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Related Items Settings', 'impeka' ),
						'subtitle'=> esc_html__( 'Define your preferences for the Related Items.', 'impeka' ),
					),
					array(
						'id'=>'portfolio_related_visibility',
						'type' => 'switch',
						'title' => esc_html__( 'Related Items Visibility', 'impeka' ),
						'subtitle'=> esc_html__( 'Enable or Disable the related items.', 'impeka' ),
						"default" => '1',
					),
					array(
						'id' => 'portfolio_related_mode',
						'type' => 'select',
						'title' => esc_html__( 'Related Portfolio Mode', 'impeka' ),
						'subtitle' => esc_html__( 'Select portfolio related mode', 'impeka' ),
						'options' => array(
							'recent' => esc_html__( 'Recent Entries', 'impeka' ),
							'category' => esc_html__( 'By Portfolio Category', 'impeka' ),
							'field' => esc_html__( 'By Portfolio Field', 'impeka' ),
						),
						'default' => 'recent',
					),
					array(
						'id' => 'portfolio_related_subtitle', //translatable
						'type' => 'text',
						'title' => esc_html__( 'Related Portfolio Subtitle', 'impeka' ),
						'subtitle' => esc_html__( 'Type the text for the portfolio related subtitle.', 'impeka' ),
						"default" => '',
						'required' => array( 'portfolio_related_visibility', 'equals', '1' ),
					),
					array(
						'id' => 'portfolio_related_title', //translatable
						'type' => 'text',
						'title' => esc_html__( 'Related Portfolio Title', 'impeka' ),
						'subtitle' => esc_html__( 'Type the text for the portfolio related title.', 'impeka' ),
						"default" => 'More Projects',
						'required' => array( 'portfolio_related_visibility', 'equals', '1' ),
					),
					array(
						'id' => 'portfolio_related_backlink_id', //translatable
						'type' => 'select',
						'title' => esc_html__( 'Related Portfolio Backlink', 'impeka' ),
						'subtitle' => esc_html__( 'Select the overview page for your related portfolio backlink.', 'impeka' ),
						'data' => 'page',
						'default' => '',
						'required' => array( 'portfolio_related_visibility', 'equals', '1' ),
					),
					array(
						'id' => 'portfolio_related_backlink_text', //translatable
						'type' => 'text',
						'title' => esc_html__( 'Related Portfolio Backlink Text', 'impeka' ),
						'subtitle' => esc_html__( 'Type the text for the portfolios related backlink.', 'impeka' ),
						"default" => 'Read All Projects',
						'required' => array( 'portfolio_related_visibility', 'equals', '1' ),
					),
					array(
						'id' => 'portfolio_related_indicator',
						'type' => 'select',
						'title' => esc_html__( 'Portfolio Related Indicator', 'impeka' ),
						'subtitle' => esc_html__( 'Select the portfolio related indicator.', 'impeka' ),
						'options' => $indicator_selection,
						"default" => 'none',
						'required' => array( 'portfolio_related_visibility', 'equals', '1' ),
					),
					array(
						'id' => 'portfolio_related_indicator_text', //translatable
						'type' => 'text',
						'title' => esc_html__( 'Portfolio Related Indicator Text', 'impeka' ),
						'subtitle' => esc_html__( 'Type the text for the portfolio related indicator text.', 'impeka' ),
						"default" => 'More',
						'required' => array( 'portfolio_related_indicator', 'equals', 'text' ),
					),
					array(
						'id' => 'portfolio_related_indicator_color',
						'type' => 'select',
						'options' => $color_selection,
						'title' => esc_html__( 'Portfolio Related Indicator Color', 'impeka' ),
						'subtitle' => esc_html__( 'Select the color for the portfolio related indicator.', 'impeka' ),
						"default" => 'primary-1',
						'required' => array( 'portfolio_related_indicator', '!=', 'none' ),
					),
					array(
						'id'   => 'info_style_portfolio_nav',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Navigation Bar', 'impeka' ),
						'subtitle'=> esc_html__( 'Define your preferences for the Navigation Bar.', 'impeka' ),
					),
					array(
						'id'=>'portfolio_nav_visibility',
						'type' => 'switch',
						'title' => esc_html__( 'Portfolio Navigation Visibility', 'impeka' ),
						'subtitle'=> esc_html__( 'Enable or Disable the visibility of the portfolio navigation.', 'impeka' ),
						"default" => '1',
					),
					array(
						'id' => 'portfolio_nav_layout',
						'type' => 'select',
						'title' => esc_html__( 'Navigation Layout', 'impeka' ),
						'subtitle' => esc_html__( 'Select the Layout for the Navigation Bar', 'impeka' ),
						'options' => array(
							'layout-1' => esc_html__( 'Simple Layout', 'impeka' ),
							'layout-2' => esc_html__( 'Floating Layout', 'impeka' ),
							'layout-3' => esc_html__( 'Minimal Layout', 'impeka' ),
						),
						'default' => 'layout-1',
						'required' => array( 'portfolio_nav_visibility', 'equals', '1' ),
					),
					array(
						'id' => 'portfolio_nav_prev_text', //translatable
						'type' => 'text',
						'title' => esc_html__( 'Navigation Previous Text', 'impeka' ),
						'subtitle' => esc_html__( 'Type the text for the previous item.', 'impeka' ),
						"default" => 'Previous Portfolio Item',
						'required' => array( 'portfolio_nav_layout', 'equals', array( 'layout-1', 'layout-2', 'layout-3' ) ),
					),
					array(
						'id' => 'portfolio_nav_next_text', //translatable
						'type' => 'text',
						'title' => esc_html__( 'Navigation Next Text', 'impeka' ),
						'subtitle' => esc_html__( 'Type the text for the next item.', 'impeka' ),
						"default" => 'Next Portfolio Item',
						'required' => array( 'portfolio_nav_layout', 'equals', array( 'layout-1', 'layout-2', 'layout-3' ) ),
					),
					array(
						'id' => 'portfolio_nav_term',
						'type' => 'select',
						'title' => esc_html__( 'Portfolio Navigation Same Term', 'impeka' ),
						'subtitle' => esc_html__( 'If selected, only navigation items with the same selected taxonomy term will be displayed.', 'impeka' ),
						'options' => $portfolio_term_selection,
						'default' => 'none',
						'required' => array( 'portfolio_nav_visibility', 'equals', '1' ),
					),
					array(
						'id' => 'portfolio_backlink_id', //translatable
						'type' => 'select',
						'title' => esc_html__( 'Portfolio Backlink', 'impeka' ),
						'subtitle' => esc_html__( 'Select the overview page for your portfolio backlink.', 'impeka' ),
						'data' => 'page',
						'default' => '',
						'required' => array( 'portfolio_nav_layout', 'equals', 'layout-1' ),
					),
					array(
						'id'             => 'portfolio_nav_spacing',
						'type'           => 'spacing',
						'mode'           => 'padding',
						'units'          => array('em', 'px', '%'),
						'units_extended' => 'false',
						'left'           => 'false',
						'right'          => 'false',
						'title'          => esc_html__( 'Navigation Bar Spacing', 'impeka' ),
						'subtitle'       => esc_html__( 'Set the spacing, Top and Bottom, of the Navigation Area.', 'impeka' ),
						'desc'           => esc_html__( 'Set spacing Top, Bottom in px.', 'impeka'),
						'default'        => array(
							'padding-top'     => '30px',
							'padding-bottom'  => '30px',
							'units'           => 'px',
						),
						'required' => array(
							array( 'portfolio_nav_visibility', 'equals', '1' ),
							array( 'portfolio_nav_layout', '!=', 'layout-2' ),
						),
					),
					array(
						'id' => 'portfolio_nav_skin_assets',
						'type' => 'select',
						'title' => esc_html__( 'Skin Assets', 'impeka' ),
						'subtitle'    => esc_html__( 'Skin for the extra assets.', 'impeka' ),
						'options' => array(
							'dark' => esc_html__( 'Dark', 'impeka' ),
							'light' => esc_html__( 'Light', 'impeka' ),
						),
						'default' => 'dark',
						'required' => array( 'portfolio_nav_layout', 'equals', array('layout-1', 'layout-3' ) ),
					),
					array(
						'id'   => 'info_style_portfolio_quickview',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Quick View', 'impeka' ),
						'subtitle'=> esc_html__( 'Define your preferences for the Quick View.', 'impeka' ),
					),
					array(
						'id' => 'portfolio_quickview_link_text', //translatable
						'type' => 'text',
						'title' => esc_html__( 'Quick View Link Text', 'impeka' ),
						'subtitle' => esc_html__( 'Type the text for the quick view link text.', 'impeka' ),
						"default" => 'Learn More',
					),
				)
			);

			$this->sections[] = array(
				'icon' => 'el-icon-shopping-cart',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( 'WooCommerce Options', 'impeka'),
				'id' => 'grve_redux_section_woocommerce_options',
				'subtitle' => esc_html__( 'You can find the Theme settings for the WooCommerce here.', 'impeka' ),
				'submenu' => true,
				'customizer' => false,
				'fields' => array(
					array(
						'id' => 'product_tax_layout',
						'type' => 'image_select',
						'compiler' => true,
						'title' => esc_html__( 'Product Taxonomy Layout', 'impeka' ),
						'subtitle' => esc_html__( 'Select the default layout for the Product Taxonomy. Choose among Full Width, Left Sidebar or Right Sidebar.', 'impeka' ),
						'options' => $layout_selection,
						'default' => 'none',
					),
					array(
						'id' => 'product_tax_sidebar',
						'type' => 'select',
						'title' => esc_html__( 'Product Taxonomy Sidebar', 'impeka' ),
						'subtitle' => esc_html__( 'Select the default sidebar for the single Product Taxonomy.', 'impeka' ),
						'data' => 'sidebar',
						'default' => 'grve-default-sidebar',
					),
					array(
						'id' => 'product_tax_fixed_sidebar',
						'type' => 'select',
						'title' => esc_html__( 'Product Taxonomy Fixed Sidebar', 'impeka' ),
						'subtitle'=> esc_html__( 'Select if you want a fixed sidebar.', 'impeka' ),
						'options' => $enable_selection,
						'default' => 'no',
					),
					array(
						'id' => 'product_tax_sidearea_visibility',
						'type' => 'select',
						'title' => esc_html__( 'Product Taxonomy Side Area Visibility', 'impeka' ),
						'subtitle' => esc_html__( 'Enable the Side Area for the Product Taxonomy.', 'impeka' ),
						'options' => $enable_selection,
						'default' => 'no',
					),
					array(
						'id' => 'product_tax_sidearea_sidebar',
						'type' => 'select',
						'title' => esc_html__( 'Product Taxonomy Side Area Sidebar', 'impeka' ),
						'subtitle' => esc_html__( 'Select the sidebar widget area for the side area.', 'impeka' ),
						'data' => 'sidebar',
						'default' => 'grve-default-sidebar',
					),
					array(
						'id' => 'product_tax_sidearea_icon_style',
						'type' => 'image_select',
						'compiler' => true,
						'title' => esc_html__( 'Product Taxonomy Side Area Icon', 'impeka' ),
						'subtitle'=> esc_html__( 'Select the icon for your side area.', 'impeka' ),
						'options' => $burger_icon_selection,
						'default' => 'style-5',
						'class' => 'small-image-selector',
						'required' => array(
							array( 'header_icon_library', 'equals', 'theme-icons' ),
							array( 'product_tax_sidearea_visibility', 'equals', 'yes' ),
						),
					),
					array(
						'id'   => 'info_style_product_tax_header',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Product Taxonomy Header Settings', 'impeka' ),
						'subtitle'=> esc_html__( 'Set the style for the default Product Taxonomy header.', 'impeka' ),
					),
					array(
						'id' => 'product_tax_header_skin',
						'type' => 'select',
						'title' => esc_html__( 'Product Taxonomy Header Skin', 'impeka' ),
						'subtitle'=> esc_html__( 'Select your Product Taxonomy header skin.', 'impeka' ),
						'options' => $header_skin,
						'default' => 'default',
					),
					array(
						'id' => 'product_tax_header_overlapping',
						'type' => 'select',
						'title' => esc_html__( 'Product Taxonomy Header Overlapping', 'impeka' ),
						'subtitle'=> esc_html__( 'Select if you want the Product Taxonomy Header overlaps the content. Combine this option with the Light or Dark Header.', 'impeka' ),
						'options' => $enable_selection,
						'default' => 'no',
					),
					array(
						'id'   => 'info_style_product_tax_title',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Product Taxonomy Title Settings', 'impeka' ),
						'subtitle'=> esc_html__( 'Set the style for the single default Product Taxonomy title.', 'impeka' ),
					),
					array(
						'id' => 'product_tax_title_height',
						'type' => 'select',
						'default' => '60',
						'title' => esc_html__( 'Height', 'impeka' ),
						'subtitle' => esc_html__( 'Enter Product Taxonomy title height (Default is 60%).', 'impeka' ),
						'options' => $area_height,
						'validate' => 'not_empty',
					),
					array(
						'id' => 'product_tax_title_min_height',
						'type' => 'text',
						'default' => '320',
						'title' => esc_html__( 'Min Height', 'impeka' ),
						'subtitle' => esc_html__( 'Enter Product Taxonomy title minimum height in px (Default is 320).', 'impeka' ),
						'validate' => 'numeric',
					),
					array(
						'id' => 'product_tax_title_container_size',
						'type' => 'select',
						'title' => esc_html__( 'Container Size', 'impeka' ),
						'subtitle'=> esc_html__( 'Select the size of the container.', 'impeka' ),
						'options' => $container_size_selection,
						'default' => 'default',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'product_tax_title_content_size',
						'type' => 'select',
						'title' => esc_html__( 'Content Size', 'impeka' ),
						'subtitle'=> esc_html__( 'Select the size of the content.', 'impeka' ),
						'options' => $content_size_selection,
						'default' => 'container',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'product_tax_title_content_alignment',
						'type' => 'image_select',
						'title' => esc_html__( 'Content Alignment', 'impeka' ),
						'subtitle'=> esc_html__( 'Select the alignment of the content.', 'impeka' ),
						'options' => $align_title,
						'default' => 'center',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'product_tax_title_content_position',
						'type' => 'image_select',
						'title' => esc_html__( 'Content Position', 'impeka' ),
						'subtitle'=> esc_html__( 'Select your position for the default Product Taxonomy title/description.', 'impeka' ),
						'options' => $align_position,
						'class' => 'small-image-selector',
						'default' => 'center-center',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'product_tax_title_content_animation',
						'type' => 'select',
						'title' => esc_html__( 'Content Animation', 'impeka' ),
						'subtitle'=> esc_html__( 'Select your animation for the default Product Taxonomy title/description.', 'impeka' ),
						'options' => $animation_selection,
						'default' => 'none',
						'validate' => 'not_empty',
					),
					array(
						'id'       => 'product_tax_title_bg_mode',
						'type'     => 'select',
						'title' => esc_html__( 'Background Mode', 'impeka' ),
						'subtitle'=> esc_html__( 'Select the Product Taxonomy Title Background, Color or Image.', 'impeka' ),
						'options' => $title_bg_mode_limited,
						'default'  => 'color',
					),
					array(
						'id'       => 'product_tax_title_bg_image',
						'type'     => 'media',
						'title' => esc_html__( 'Background Image', 'impeka' ),
						'subtitle' => esc_html__( 'Select a background image for the default Product Taxonomy title.', 'impeka' ),
						'required' => array( 'product_tax_title_bg_mode', 'equals', 'custom' ),
					),
					array(
						'id' => 'product_tax_title_bg_position',
						'type' => 'select',
						'title' => esc_html__( 'Background Position', 'impeka' ),
						'options' => $align_selection_full,
						'default' => 'center-center',
						'validate' => 'not_empty',
						'required' => array( 'product_tax_title_bg_mode', '!=', 'color' ),
					),
					array(
						'id' => 'product_tax_title_pattern_overlay',
						'type' => 'select',
						'title' => esc_html__( 'Pattern Overlay', 'impeka' ),
						'options' => $pattern_selection,
						'default' => 'none',
						'required' => array( 'product_tax_title_bg_mode', '!=', 'color' ),
					),
					array(
						'id' => 'product_tax_title_color_overlay',
						'type' => 'select',
						'title' => esc_html__( 'Color Overlay', 'impeka' ),
						'options' => $color_selection,
						'default' => 'black',
						'required' => array( 'product_tax_title_bg_mode', '!=', 'color' ),
					),
					array(
						'id' => 'product_tax_title_opacity_overlay',
						'type' => 'select',
						'title' => esc_html__( 'Opacity Overlay', 'impeka' ),
						'options' => $opacity_selection,
						'default' => '0',
						'required' => array( 'product_tax_title_bg_mode', '!=', 'color' ),
					),
					array(
						'id'=>'product_tax_breadcrumbs_enabled',
						'type' => 'switch',
						'title' => esc_html__( 'Breadcrumbs', 'impeka' ),
						'subtitle'=> esc_html__( 'Enable or Disable the Breadcrumbs for Product Categories / Product Tags.', 'impeka' ),
						"default" => '0',
					),
					array(
						'id' => 'product_tax_breadcrumbs_height',
						'type' => 'text',
						'default' => '60',
						'title' => esc_html__( 'Breadcrumbs Height', 'impeka' ),
						'subtitle' => esc_html__( 'Enter Breadcrumbs height in px (Default is 60).', 'impeka' ),
						'validate' => 'numeric',
						'required' => array( 'product_tax_breadcrumbs_enabled', 'equals', '1' ),
					),
					array(
						'id' => 'product_tax_breadcrumbs_alignment',
						'type' => 'select',
						'compiler' => true,
						'title' => esc_html__( 'Breadcrumbs Alignment', 'impeka' ),
						'subtitle' => esc_html__( 'Select the alignment of your breadcrumbs.', 'impeka' ),
						'options' => $align_selection_extra,
						'default' => 'left',
						'validate' => 'not_empty',
						'required' => array( 'product_tax_breadcrumbs_enabled', 'equals', '1' ),
					),
					array(
						'id' => 'product_tax_breadcrumbs_fullwidth',
						'type' => 'switch',
						'title' => esc_html__( 'Fullwidth', 'impeka' ),
						'subtitle'=> esc_html__( 'Select if you want to show your breadcrumbs full width.', 'impeka' ),
						'default' => 0,
						'required' => array( 'product_tax_breadcrumbs_enabled', 'equals', '1' ),
					),
					array(
						'id'   => 'info_style_product_overview',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Shop Overview Settings', 'impeka' ),
						'subtitle'=> esc_html__( 'Set the style for the shop overview.', 'impeka' ),
					),
					array(
						'id' => 'product_overview_hover_style',
						'type' => 'select',
						'title' => esc_html__( 'Loop Product Hover Style', 'impeka' ),
						'subtitle'=> esc_html__( 'Select the hover style for the product overview.', 'impeka' ),
						'options' => array(
							'hover-style-1' => esc_html__( 'Content Below Image', 'impeka' ),
							'hover-style-2' => esc_html__( 'Top Down Animated Content', 'impeka' ),
						),
						'default' => 'hover-style-1',
					),
					array(
						'id' => 'product_overview_image_effect',
						'type' => 'select',
						'title' => esc_html__( 'Loop Product Image effect', 'impeka' ),
						'subtitle'=> esc_html__( 'Select the effect for the overview product image', 'impeka' ),
						'options' => array(
							'none' => esc_html__( 'None', 'impeka' ),
							'second' => esc_html__( 'Second Image on Hover', 'impeka' ),
						),
						'default' => 'second',
					),
					array(
						'id' => 'product_overview_image_size',
						'type' => 'select',
						'options' => array(
							'default' => esc_html__( 'Default', 'impeka' ),
							'square' => esc_html__( 'Square Small Crop', 'impeka' ),
							'landscape' => esc_html__( 'Landscape Small Crop', 'impeka' ),
							'portrait' => esc_html__( 'Portrait Small Crop', 'impeka' ),
							'large' => esc_html__( 'Resize ( Large )', 'impeka' ),
							'medium_large' => esc_html__( 'Resize ( Medium Large )', 'impeka' ),
							'medium' => esc_html__( 'Resize ( Medium )', 'impeka' ),
						),
						'title' => esc_html__( 'Loop Image Size', 'impeka' ),
						'subtitle' => esc_html__( 'Choose the overview image size.', 'impeka' ),
						'default' => 'default',
					),
					array(
						'id' => 'product_loop_columns',
						'type' => 'select',
						'options' => array(
							'2' => '2',
							'3' => '3',
							'4' => '4',
							'5' => '5',
						),
						'default' => '4',
						'title' => esc_html__( 'Loop Columns', 'impeka' ),
						'subtitle' => esc_html__( 'Select the number of columns (Default is 4).', 'impeka' ),
					),
					array(
						'id' => 'product_loop_columns_tablet_landscape',
						'type' => 'select',
						'title' => esc_html__( 'Loop Landscape Columns', 'impeka' ),
						'subtitle' => esc_html__( 'Select responsive column on tablet devices, landscape orientation.', 'impeka' ),
						'options' => array(
							'2' => '2',
							'3' => '3',
							'4' => '4',
							'5' => '5',
						),
						'default' => '2',
					),
					array(
						'id' => 'product_loop_columns_tablet_portrait',
						'type' => 'select',
						'title' => esc_html__( 'Loop Tablet Portrait Columns', 'impeka' ),
						'subtitle' => esc_html__( 'Select responsive column on tablet devices, portrait orientation.', 'impeka' ),
						'options' => array(
							'2' => '2',
							'3' => '3',
							'4' => '4',
							'5' => '5',
						),
						'default' => '2',
					),
					array(
						'id' => 'product_loop_columns_mobile',
						'type' => 'select',
						'title' => esc_html__( 'Loop Mobile Columns', 'impeka' ),
						'subtitle' => esc_html__( 'Select responsive column on mobile devices.', 'impeka' ),
						'options' => array(
							'1' => '1',
							'2' => '2',
							'3' => '3',
						),
						'default' => '1',
					),
					array(
						'id' => 'product_loop_shop_per_page',
						'type' => 'text',
						'default' => '12',
						'title' => esc_html__( 'Loop Products per Page', 'impeka' ),
						'subtitle' => esc_html__( 'Select how many products per page you want to show (Default is 12).', 'impeka' ),
						'validate' => 'numeric',
					),
					array(
						'id' => 'product_overview_heading_tag',
						'type' => 'select',
						'title' => esc_html__( 'Loop Product Title Tag', 'impeka' ),
						'subtitle' => esc_html__( 'Select tag for your loop product title.', 'impeka' ),
						'options' => $headings_tag_selection,
						'default' => 'h3',
					),
					array(
						'id' => 'product_overview_heading',
						'type' => 'select',
						'title' => esc_html__( 'Loop Product Title Size', 'impeka' ),
						'subtitle' => esc_html__( 'Select size and typography for your loop product title.', 'impeka' ),
						'options' => $headings_selection,
						'default' => 'h6',
					),
					array(
						'id' => 'product_overview_text_color',
						'type' => 'select',
						'title' => esc_html__( 'Loop Product Text Color', 'impeka' ),
						'subtitle' => esc_html__( 'Select text color for the loop product text.', 'impeka' ),
						'options' => $text_color_selection,
						'default' => 'default',
					),
					array(
						'id' => 'product_overview_overlay_color',
						'type' => 'select',
						'title' => esc_html__( 'Color Overlay', 'impeka' ),
						'options' => $color_selection,
						'default' => 'black',
					),
					array(
						'id' => 'product_overview_overlay_opacity',
						'type' => 'select',
						'options' => $overlay_opacity_selection,
						'title' => esc_html__( 'Overlay Opacity', 'impeka' ),
						'subtitle' => esc_html__( 'Choose the opacity for the overlay.', 'impeka' ),
						'default' => '10',
					),
					array(
						'id'   => 'info_style_product_extras',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Shop Extras', 'impeka' ),
						'subtitle'=> esc_html__( 'Set the style for additional shop settings.', 'impeka' ),
					),
					array(
						'id'=>'product_woo_quantity_buttons',
						'type' => 'switch',
						'title' => esc_html__( 'Product Quantity Buttons', 'impeka' ),
						'subtitle'=> esc_html__( 'Enable or Disable -/+ quantity buttons.', 'impeka' ),
						"default" => '1',
					),
				)
			);

			$this->sections[] = array(
				'title' => esc_html__( 'Single Product Settings', 'impeka' ),
				'id' => 'grve_redux_section_single_product_settings',
				'header' => '',
				'desc' => esc_html__( 'Define your preferences for the Single Products. Notice that most of them can be overridden when you create a single product.', 'impeka' ),
				'submenu' => true,
				'icon' => 'el-icon-shopping-cart',
				'icon_class' => 'el-icon-large',
				'customizer' => false,
				'subsection' => true,
				'fields' => array(
					array(
						'id' => 'product_padding_top_multiplier',
						'type' => 'select',
						'title' => esc_html__( 'Product Top Padding', 'impeka' ),
						'subtitle'=> esc_html__( 'Select the space above the content area.', 'impeka' ),
						'options' => $padding_selection_extra,
						'default' => '3x',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'product_padding_top',
						'type' => 'text',
						'title' => esc_html__( 'Product Custom Top Padding', 'impeka' ),
						'subtitle'=> esc_html__( 'You can use px, em, %, etc. or enter just number and it will use pixels.', 'impeka' ),
						'required' => array( 'product_padding_top_multiplier', 'equals', 'custom' ),
					),
					array(
						'id' => 'product_padding_bottom_multiplier',
						'type' => 'select',
						'title' => esc_html__( 'Product Bottom Padding', 'impeka' ),
						'subtitle'=> esc_html__( 'Select the space below the content area.', 'impeka' ),
						'options' => $padding_selection_extra,
						'default' => '3x',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'product_padding_bottom',
						'type' => 'text',
						'title' => esc_html__( 'Product Custom Bottom Padding', 'impeka' ),
						'subtitle'=> esc_html__( 'You can use px, em, %, etc. or enter just number and it will use pixels.', 'impeka' ),
						'required' => array( 'product_padding_bottom_multiplier', 'equals', 'custom' ),
					),
					array(
						'id' => 'product_layout',
						'type' => 'image_select',
						'compiler' => true,
						'title' => esc_html__( 'Product Layout', 'impeka' ),
						'subtitle' => esc_html__( 'Select the layout for the Single Products. Choose among Full Width, Left Sidebar or Right Sidebar.', 'impeka' ),
						'options' => $layout_selection,
						'default' => 'none',
					),
					array(
						'id' => 'product_sidebar',
						'type' => 'select',
						'title' => esc_html__( 'Product Sidebar', 'impeka' ),
						'subtitle' => esc_html__( 'Select the sidebar for the Single Products.', 'impeka' ),
						'data' => 'sidebar',
						'default' => 'grve-default-sidebar',
					),
					array(
						'id' => 'product_fixed_sidebar',
						'type' => 'select',
						'title' => esc_html__( 'Product Fixed Sidebar', 'impeka' ),
						'subtitle'=> esc_html__( 'Select if you want a fixed sidebar.', 'impeka' ),
						'options' => $enable_selection,
						'default' => 'no',
					),
					array(
						'id' => 'product_content_width',
						'type' => 'select',
						'title' => esc_html__( 'Product Content Width', 'impeka' ),
						'subtitle' => esc_html__( 'Select the Single Product Content width (only for Full Width Product Layout)', 'impeka' ),
						'options' => $container_size_selector,
						'default' => 'medium',
					),
					array(
						'id' => 'product_sidearea_visibility',
						'type' => 'select',
						'title' => esc_html__( 'Product Side Area Visibility', 'impeka' ),
						'subtitle' => esc_html__( 'Enable the Product Side Area if you want.', 'impeka' ),
						'options' => $enable_selection,
						'default' => 'no',
					),
					array(
						'id' => 'product_sidearea_sidebar',
						'type' => 'select',
						'title' => esc_html__( 'Product Side Area Sidebar', 'impeka' ),
						'subtitle' => esc_html__( 'Select the sidebar widget area for the side area.', 'impeka' ),
						'data' => 'sidebar',
						'default' => 'grve-default-sidebar',
					),
					array(
						'id' => 'product_sidearea_icon_style',
						'type' => 'image_select',
						'compiler' => true,
						'title' => esc_html__( 'Product Side Area Icon', 'impeka' ),
						'subtitle'=> esc_html__( 'Select the icon for your side area.', 'impeka' ),
						'options' => $burger_icon_selection,
						'default' => 'style-5',
						'class' => 'small-image-selector',
						'required' => array(
							array( 'header_icon_library', 'equals', 'theme-icons' ),
							array( 'product_sidearea_visibility', 'equals', 'yes' ),
						),
					),
					array(
						'id'   => 'info_style_product_header',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Product Header Settings', 'impeka' ),
						'subtitle'=> esc_html__( 'Set the style for the default post header.', 'impeka' ),
					),
					array(
						'id' => 'product_header_skin',
						'type' => 'select',
						'title' => esc_html__( 'Product Header Skin', 'impeka' ),
						'subtitle'=> esc_html__( 'Select your product header skin.', 'impeka' ),
						'options' => $header_skin,
						'default' => 'default',
					),
					array(
						'id' => 'product_header_overlapping',
						'type' => 'select',
						'title' => esc_html__( 'Product Header Overlapping', 'impeka' ),
						'subtitle'=> esc_html__( 'Select if you want the Product Header overlaps the content. Combine this option with the Light or Dark Header. You can still override this when you edit each single product.', 'impeka' ),
						'options' => $enable_selection,
						'default' => 'no',
					),
					array(
						'id'   => 'info_style_product_title',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Single Product Title Settings', 'impeka' ),
						'subtitle'=> esc_html__( 'Set the style for the default single product title.', 'impeka' ),
					),
					array(
						'id' => 'product_title_style',
						'type' => 'select',
						'default' => 'simple',
						'title' => esc_html__( 'Title Style', 'impeka' ),
						'subtitle' => esc_html__( 'Select Product Title Style', 'impeka' ),
						'options' => $title_style,
						'validate' => 'not_empty',
					),
					array(
						'id' => 'product_title_height',
						'type' => 'select',
						'default' => '60',
						'title' => esc_html__( 'Height', 'impeka' ),
						'subtitle' => esc_html__( 'Enter product title height (Default is 60%).', 'impeka' ),
						'options' => $area_height,
						'validate' => 'not_empty',
						'required' => array( 'product_title_style', 'equals', 'advanced' ),
					),
					array(
						'id' => 'product_title_min_height',
						'type' => 'text',
						'default' => '200',
						'title' => esc_html__( 'Min Height', 'impeka' ),
						'subtitle' => esc_html__( 'Enter product title minimum height in px (Default is 200).', 'impeka' ),
						'validate' => 'numeric',
						'required' => array( 'product_title_style', 'equals', 'advanced' ),
					),
					array(
						'id' => 'product_title_container_size',
						'type' => 'select',
						'title' => esc_html__( 'Container Size', 'impeka' ),
						'subtitle'=> esc_html__( 'Select the size of the container.', 'impeka' ),
						'options' => $container_size_selection,
						'default' => 'default',
						'validate' => 'not_empty',
						'required' => array( 'product_title_style', 'equals', 'advanced' ),
					),
					array(
						'id' => 'product_title_content_size',
						'type' => 'select',
						'title' => esc_html__( 'Content Size', 'impeka' ),
						'subtitle'=> esc_html__( 'Select the size of the content.', 'impeka' ),
						'options' => $content_size_selection,
						'default' => 'container',
						'validate' => 'not_empty',
						'required' => array( 'product_title_style', 'equals', 'advanced' ),
					),
					array(
						'id' => 'product_title_content_alignment',
						'type' => 'image_select',
						'title' => esc_html__( 'Content Alignment', 'impeka' ),
						'subtitle'=> esc_html__( 'Select the alignment of the content.', 'impeka' ),
						'options' => $align_title,
						'default' => 'center',
						'validate' => 'not_empty',
						'required' => array( 'product_title_style', 'equals', 'advanced' ),
					),
					array(
						'id' => 'product_title_content_position',
						'type' => 'image_select',
						'title' => esc_html__( 'Content Position', 'impeka' ),
						'subtitle'=> esc_html__( 'Select your position for the default product title/description.', 'impeka' ),
						'options' => $align_position,
						'class' => 'small-image-selector',
						'default' => 'center-center',
						'validate' => 'not_empty',
						'required' => array( 'product_title_style', 'equals', 'advanced' ),
					),
					array(
						'id' => 'product_title_content_animation',
						'type' => 'select',
						'title' => esc_html__( 'Content Animation', 'impeka' ),
						'subtitle'=> esc_html__( 'Select your animation for the default product title/description.', 'impeka' ),
						'options' => $animation_selection,
						'default' => 'none',
						'validate' => 'not_empty',
						'required' => array( 'product_title_style', 'equals', 'advanced' ),
					),
					array(
						'id'       => 'product_title_bg_mode',
						'type'     => 'select',
						'title' => esc_html__( 'Background Mode', 'impeka' ),
						'subtitle'=> esc_html__( 'Select the Product Title Background, Color or Image.', 'impeka' ),
						'options' => $title_bg_mode,
						'default'  => 'color',
						'required' => array( 'product_title_style', 'equals', 'advanced' ),
					),
					array(
						'id'       => 'product_title_bg_image',
						'type'     => 'media',
						'title' => esc_html__( 'Background Image', 'impeka' ),
						'subtitle' => esc_html__( 'Select a background image for the default product title.', 'impeka' ),
						'required' => array(
							array( 'product_title_style', 'equals', 'advanced' ),
							array( 'product_title_bg_mode', 'equals', 'custom' ),
						),
					),
					array(
						'id' => 'product_title_bg_position',
						'type' => 'select',
						'title' => esc_html__( 'Background Position', 'impeka' ),
						'options' => $align_selection_full,
						'default' => 'center-center',
						'validate' => 'not_empty',
						'required' => array(
							array( 'product_title_style', 'equals', 'advanced' ),
							array( 'product_title_bg_mode', '!=', 'color' ),
						),
					),
					array(
						'id' => 'product_title_pattern_overlay',
						'type' => 'select',
						'title' => esc_html__( 'Pattern Overlay', 'impeka' ),
						'options' => $pattern_selection,
						'default' => 'none',
						'required' => array(
							array( 'product_title_style', 'equals', 'advanced' ),
							array( 'product_title_bg_mode', '!=', 'color' ),
						),
					),
					array(
						'id' => 'product_title_color_overlay',
						'type' => 'select',
						'title' => esc_html__( 'Color Overlay', 'impeka' ),
						'options' => $color_selection,
						'default' => 'black',
						'required' => array(
							array( 'product_title_style', 'equals', 'advanced' ),
							array( 'product_title_bg_mode', '!=', 'color' ),
						),
					),
					array(
						'id' => 'product_title_opacity_overlay',
						'type' => 'select',
						'title' => esc_html__( 'Opacity Overlay', 'impeka' ),
						'options' => $opacity_selection,
						'default' => '0',
						'required' => array(
							array( 'product_title_style', 'equals', 'advanced' ),
							array( 'product_title_bg_mode', '!=', 'color' ),
						),
					),
					array(
						'id'   => 'info_style_product_content_area',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Product Area/Product Content Settings', 'impeka' ),
						'subtitle'=> esc_html__( 'Define your preferences for the product area and product content (Tabs).', 'impeka' ),
					),
					array(
						'id' => 'product_area_padding_top_multiplier',
						'type' => 'select',
						'title' => esc_html__( 'Product Area Top Padding', 'impeka' ),
						'subtitle'=> esc_html__( 'Select the space above the area.', 'impeka' ),
						'options' => $padding_selection,
						'default' => 'none',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'product_area_padding_bottom_multiplier',
						'type' => 'select',
						'title' => esc_html__( 'Product Area bottom Padding', 'impeka' ),
						'subtitle'=> esc_html__( 'Select the space below the product area.', 'impeka' ),
						'options' => $padding_selection,
						'default' => '3x',
						'validate' => 'not_empty',
					),
					array(
						'id'   => 'info_style_product_anchor_menu',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Anchor Menu Bar Settings', 'impeka' ),
						'subtitle'=> esc_html__( 'Define your preferences for the Anchor Menu Bar where you can place a custom sticky menu per product.', 'impeka' ),
					),
					array(
						'id' => 'product_anchor_menu_height',
						'type' => 'text',
						'default' => '60',
						'title' => esc_html__( 'Anchor Menu Height', 'impeka' ),
						'subtitle' => esc_html__( 'Enter Anchor Menu height in px (Default is 60).', 'impeka' ),
						'validate' => 'numeric',
					),
					array(
						'id' => 'product_anchor_menu_alignment',
						'type' => 'select',
						'compiler' => true,
						'title' => esc_html__( 'Anchor Menu Alignment', 'impeka' ),
						'subtitle' => esc_html__( 'Select the alignment of your Anchor Menu in products.', 'impeka' ),
						'options' => $align_selection_extra,
						'default' => 'left',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'product_anchor_menu_fullwidth',
						'type' => 'switch',
						'title' => esc_html__( 'Fullwidth', 'impeka' ),
						'subtitle'=> esc_html__( 'Select if you want to have full width Anchor Menu.', 'impeka' ),
						'default' => 0,
					),
					array(
						'id'   => 'info_style_product_breadcrumbs',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Breadcrumbs Bar Settings', 'impeka' ),
						'subtitle'=> esc_html__( 'Define your preferences for the Breadcrumbs Bar.', 'impeka' ),
					),
					array(
						'id'=>'product_breadcrumbs_enabled',
						'type' => 'switch',
						'title' => esc_html__( 'Breadcrumbs', 'impeka' ),
						'subtitle'=> esc_html__( 'Enable or Disable the Breadcrumbs for Single Product', 'impeka' ),
						"default" => '0',
					),
					array(
						'id' => 'product_breadcrumbs_height',
						'type' => 'text',
						'default' => '60',
						'title' => esc_html__( 'Breadcrumbs Height', 'impeka' ),
						'subtitle' => esc_html__( 'Enter Breadcrumbs height in px (Default is 60).', 'impeka' ),
						'validate' => 'numeric',
						'required' => array( 'product_breadcrumbs_enabled', 'equals', '1' ),
					),
					array(
						'id' => 'product_breadcrumbs_alignment',
						'type' => 'select',
						'compiler' => true,
						'title' => esc_html__( 'Breadcrumbs Alignment', 'impeka' ),
						'subtitle' => esc_html__( 'Select the alignment of your breadcrumbs.', 'impeka' ),
						'options' => $align_selection_extra,
						'default' => 'left',
						'validate' => 'not_empty',
						'required' => array( 'product_breadcrumbs_enabled', 'equals', '1' ),
					),
					array(
						'id' => 'product_breadcrumbs_fullwidth',
						'type' => 'switch',
						'title' => esc_html__( 'Fullwidth', 'impeka' ),
						'subtitle'=> esc_html__( 'Select if you want to show your breadcrumbs full width.', 'impeka' ),
						'default' => 0,
						'required' => array( 'product_breadcrumbs_enabled', 'equals', '1' ),
					),
					array(
						'id'   => 'info_style_woo',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Single Product Template Settings', 'impeka' ),
						'subtitle'=> esc_html__( 'Set the style/layout for the single product.', 'impeka' ),
					),
					array(
						'id' => 'product_woo_style',
						'type' => 'select',
						'title' => esc_html__( 'Product Style', 'impeka' ),
						'subtitle'=> esc_html__( 'Select the style for the single product. Note: some external plugins might not be compatible with Theme style.', 'impeka' ),
						'options' => array(
							'theme' => esc_html__( 'Theme Style', 'impeka' ),
							'woo' => esc_html__( 'Default WooCommerce Style', 'impeka' ),
						),
						'default' => 'theme',
					),
					array(
						'id'   => 'info_style_product_image',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Single Product Image Settings', 'impeka' ),
						'subtitle'=> esc_html__( 'Set the style for the single product image.', 'impeka' ),
					),
					array(
						'id' => 'product_image_thumb_style',
						'type' => 'select',
						'title' => esc_html__( 'Product Image / Thumbnails Style', 'impeka' ),
						'subtitle'=> esc_html__( 'Select the style for the single product image and thumbnails. Note: some external plugins might not be compatible with Theme style.', 'impeka' ),
						'options' => array(
							'theme' => esc_html__( 'Theme Style', 'impeka' ),
							'woo' => esc_html__( 'Default WooCommerce Style', 'impeka' ),
						),
						'default' => 'woo',
					),
					array(
						'id' => 'product_image_size',
						'type' => 'select',
						'options' => array(
							'default' => esc_html__( 'Default', 'impeka' ),
							'square' => esc_html__( 'Square Small Crop', 'impeka' ),
							'landscape' => esc_html__( 'Landscape Small Crop', 'impeka' ),
							'portrait' => esc_html__( 'Portrait Small Crop', 'impeka' ),
							'large' => esc_html__( 'Resize ( Large )', 'impeka' ),
							'medium_large' => esc_html__( 'Resize ( Medium Large )', 'impeka' ),
							'medium' => esc_html__( 'Resize ( Medium )', 'impeka' ),
						),
						'title' => esc_html__( 'Product Image Size', 'impeka' ),
						'subtitle' => esc_html__( 'Choose the product image size.', 'impeka' ),
						'default' => 'default',
					),
					array(
						'id' => 'product_thumbnails_columns',
						'type' => 'select',
						'options' => array(
							'1' => '1',
							'2' => '2',
							'3' => '3',
							'4' => '4',
							'5' => '5',
							'6' => '6',
						),
						'default' => '4',
						'title' => esc_html__( 'Product Thumbnails Columns', 'impeka' ),
						'subtitle' => esc_html__( 'Select the number of columns (Default is 4).', 'impeka' ),
						'required' => array( 'product_image_thumb_style', 'equals', 'woo' ),
					),
					array(
						'id' => 'product_thumb_size',
						'type' => 'select',
						'options' => array(
							'default' => esc_html__( 'Default', 'impeka' ),
							'square' => esc_html__( 'Square Small Crop', 'impeka' ),
							'landscape' => esc_html__( 'Landscape Small Crop', 'impeka' ),
							'portrait' => esc_html__( 'Portrait Small Crop', 'impeka' ),
							'large' => esc_html__( 'Resize ( Large )', 'impeka' ),
							'medium_large' => esc_html__( 'Resize ( Medium Large )', 'impeka' ),
							'medium' => esc_html__( 'Resize ( Medium )', 'impeka' ),
							'thumbnail' => esc_html__( 'Thumbnail', 'impeka' ),
						),
						'title' => esc_html__( 'Thumbnail Image Size', 'impeka' ),
						'subtitle' => esc_html__( 'Choose the thumbnail image size.', 'impeka' ),
						'default' => 'thumbnail',
					),
					array(
						'id'=>'product_gallery_woo_zoom',
						'type' => 'switch',
						'title' => esc_html__( 'Zoom Effect', 'impeka' ),
						'subtitle'=> esc_html__( 'Enable or Disable image zoom effect.', 'impeka' ),
						"default" => '1',
					),
					array(
						'id'=>'product_gallery_woo_lightbox',
						'type' => 'switch',
						'title' => esc_html__( 'Gallery Lightbox', 'impeka' ),
						'subtitle'=> esc_html__( 'Enable or Disable gallery lightbox.', 'impeka' ),
						"default" => '1',
					),
					array(
						'id'=>'product_gallery_woo_slider',
						'type' => 'switch',
						'title' => esc_html__( 'Gallery Slider', 'impeka' ),
						'subtitle'=> esc_html__( 'Enable or Disable gallery slider.', 'impeka' ),
						"default" => '1',
						'required' => array( 'product_image_thumb_style', 'equals', 'woo' ),
					),
					array(
						'id'   => 'info_style_product_social',
						'type' => 'info',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Socials Settings', 'impeka' ),
						'subtitle'=> esc_html__( 'Define your preferences for the Socials.', 'impeka' ),
					),
					array(
						'id' => 'product_social',
						'type' => 'checkbox',
						'title' => esc_html__( 'Social Share', 'impeka' ),
						'subtitle' => esc_html__( 'Enable or Disable post social shares for the Single Product.', 'impeka' ),
						'options' => $product_social_options,
						'default' => 0,
					),
					array(
						'id' => 'product_social_layout',
						'type' => 'select',
						'title' => esc_html__( 'Social Share Layout', 'impeka' ),
						'subtitle' => esc_html__( 'Select the Layout for the Social Share Bar', 'impeka' ),
						'options' => array(
							'layout-1' => esc_html__( 'Floating', 'impeka' ),
							'layout-2' => esc_html__( 'Classic', 'impeka' ),
						),
						'default' => 'layout-2',
					),
					array(
						'id' => 'product_social_share_title', //translatable
						'type' => 'text',
						'title' => esc_html__( 'Social Share Title', 'impeka' ),
						'subtitle' => esc_html__( 'Type the text for the social share title.', 'impeka' ),
						"default" => 'Share',
					),
					array(
						'id'   => 'info_style_product_nav',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Navigation Settings', 'impeka' ),
						'subtitle'=> esc_html__( 'Define your preferences for the Navigation.', 'impeka' ),
					),
					array(
						'id'=>'product_nav_visibility',
						'type' => 'switch',
						'title' => esc_html__( 'Product Navigation Visibility', 'impeka' ),
						'subtitle'=> esc_html__( 'Enable or Disable the visibility of the products navigation.', 'impeka' ),
						"default" => '1',
					),
					array(
						'id' => 'product_nav_layout',
						'type' => 'select',
						'title' => esc_html__( 'Navigation Layout', 'impeka' ),
						'subtitle' => esc_html__( 'Select the Layout for the Navigation Bar', 'impeka' ),
						'options' => array(
							'layout-1' => esc_html__( 'Simple Layout', 'impeka' ),
							'layout-2' => esc_html__( 'Floating Layout', 'impeka' ),
							'layout-3' => esc_html__( 'Minimal Layout', 'impeka' ),
						),
						'default' => 'layout-1',
						'required' => array( 'product_nav_visibility', 'equals', '1' ),
					),
					array(
						'id' => 'product_nav_prev_text',  //translatable
						'type' => 'text',
						'title' => esc_html__( 'Navigation Previous Text', 'impeka' ),
						'subtitle' => esc_html__( 'Type the text for the previous item.', 'impeka' ),
						"default" => 'Previous Product',
						'required' => array( 'product_nav_layout', 'equals', array( 'layout-1', 'layout-2', 'layout-3' ) ),
					),
					array(
						'id' => 'product_nav_next_text',  //translatable
						'type' => 'text',
						'title' => esc_html__( 'Navigation Next Text', 'impeka' ),
						'subtitle' => esc_html__( 'Type the text for the next item.', 'impeka' ),
						"default" => 'Next Product',
						'required' => array( 'product_nav_layout', 'equals', array( 'layout-1', 'layout-2', 'layout-3' ) ),
					),
					array(
						'id' => 'product_nav_same_term',
						'type' => 'switch',
						'title' => esc_html__( 'Product Navigation Same Term', 'impeka' ),
						'subtitle'=> esc_html__( 'If enabled, only navigation items from the current taxonomy term will be displayed.', 'impeka' ),
						'default' => 0,
						'required' => array( 'product_nav_visibility', 'equals', '1' ),
					),
					array(
						'id' => 'product_backlink_id',  //translatable
						'type' => 'select',
						'title' => esc_html__( 'Product Backlink', 'impeka' ),
						'subtitle' => esc_html__( 'Select the overview page for your product backlink.', 'impeka' ),
						'data' => 'page',
						'default' => '',
						'required' => array( 'product_nav_layout', 'equals', 'layout-1' ),
					),
					array(
						'id'             => 'product_nav_spacing',
						'type'           => 'spacing',
						'mode'           => 'padding',
						'units'          => array('em', 'px', '%'),
						'units_extended' => 'false',
						'left'           => 'false',
						'right'          => 'false',
						'title'          => esc_html__( 'Navigation Bar Spacing', 'impeka' ),
						'subtitle'       => esc_html__( 'Set the spacing, Top and Bottom, of the Navigation Area.', 'impeka' ),
						'desc'           => esc_html__( 'Set spacing Top, Bottom in px.', 'impeka'),
						'default'        => array(
							'padding-top'     => '30px',
							'padding-bottom'  => '30px',
							'units'           => 'px',
						),
						'required' => array(
							array( 'product_nav_visibility', 'equals', '1' ),
							array( 'product_nav_layout', '!=', 'layout-2' ),
						),
					),
					array(
						'id' => 'product_nav_skin_assets',
						'type' => 'select',
						'title' => esc_html__( 'Skin Assets', 'impeka' ),
						'subtitle'    => esc_html__( 'Skin for the extra assets.', 'impeka' ),
						'options' => array(
							'dark' => esc_html__( 'Dark', 'impeka' ),
							'light' => esc_html__( 'Light', 'impeka' ),
						),
						'default' => 'dark',
						'required' => array( 'product_nav_layout', 'equals', array('layout-1', 'layout-3' ) ),
					),
					array(
						'id'   => 'info_style_product_quickview',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Quick View', 'impeka' ),
						'subtitle'=> esc_html__( 'Define your preferences for the Quick View.', 'impeka' ),
					),
					array(
						'id' => 'product_quickview_link_text', //translatable
						'type' => 'text',
						'title' => esc_html__( 'Quick View Link Text', 'impeka' ),
						'subtitle' => esc_html__( 'Type the text for the quick view link text.', 'impeka' ),
						"default" => 'More Details',
					),
				)
			);

			$this->sections[] = array(
				'title' => esc_html__( 'Product Search Settings', 'impeka' ),
				'id' => 'grve_redux_section_product_search_settings',
				'header' => '',
				'desc' => esc_html__( 'Define your preferences for the Product Search.', 'impeka' ),
				'submenu' => true,
				'icon' => 'el-icon-shopping-cart',
				'icon_class' => 'el-icon-large',
				'customizer' => false,
				'subsection' => true,
				'fields' => array(
					array(
						'id' => 'product_search_layout',
						'type' => 'image_select',
						'compiler' => true,
						'title' => esc_html__( 'Product Search Layout', 'impeka' ),
						'subtitle' => esc_html__( 'Select the layout for the product search page. Choose among Full Width, Left Sidebar or Right Sidebar.', 'impeka' ),
						'options' => $layout_selection,
						'default' => 'none',
					),
					array(
						'id' => 'product_search_sidebar',
						'type' => 'select',
						'title' => esc_html__( 'Product Search Sidebar', 'impeka' ),
						'subtitle' => esc_html__( 'Select the default sidebar for the product search page in case you do not use full width layout.', 'impeka' ),
						'data' => 'sidebar',
						'default' => 'eut-default-sidebar',
					),
					array(
						'id' => 'product_search_fixed_sidebar',
						'type' => 'select',
						'title' => esc_html__( 'Product Search Fixed Sidebar', 'impeka' ),
						'subtitle'=> esc_html__( 'Select if you want a fixed sidebar.', 'impeka' ),
						'options' => $enable_selection,
						'default' => 'no',
					),
				)
			);

			$this->sections[] = array(
				'icon' => 'el-icon-cloud',
				'icon_class' => 'el-icon-cog',
				'title' => esc_html__( 'External Plugin Support', 'impeka' ),
				'id' => 'grve_redux_section_external plugins',
				'submenu' => true,
				'customizer' => false,
				'fields' => array()
			);

			$this->sections[] = array(
				'icon' => 'el-icon-calendar',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( 'Events Calendar Options', 'impeka'),
				'id' => 'grve_redux_section_event_calendar_options',
				'subtitle' => esc_html__( 'You can find the Theme settings for the Events Calendar here.', 'impeka' ),
				'submenu' => true,
				'subsection' => true,
				'customizer' => false,
				'fields' => array(
					array(
						'id' => 'event_tax_layout',
						'type' => 'image_select',
						'compiler' => true,
						'title' => esc_html__( 'Event Taxonomy Layout', 'impeka' ),
						'subtitle' => esc_html__( 'Select the default layout for the Event Taxonomy. Choose among Full Width, Left Sidebar or Right Sidebar.', 'impeka' ),
						'options' => $layout_selection,
						'default' => 'none',
					),
					array(
						'id' => 'event_tax_sidebar',
						'type' => 'select',
						'title' => esc_html__( 'Event Taxonomy Sidebar', 'impeka' ),
						'subtitle' => esc_html__( 'Select the default sidebar for the single Event Taxonomy.', 'impeka' ),
						'data' => 'sidebar',
						'default' => 'grve-default-sidebar',
					),
					array(
						'id' => 'event_tax_fixed_sidebar',
						'type' => 'select',
						'title' => esc_html__( 'Event Taxonomy Fixed Sidebar', 'impeka' ),
						'subtitle'=> esc_html__( 'Select if you want a fixed sidebar.', 'impeka' ),
						'options' => $enable_selection,
						'default' => 'no',
					),
					array(
						'id' => 'event_tax_sidearea_visibility',
						'type' => 'select',
						'title' => esc_html__( 'Event Taxonomy Side Area Visibility', 'impeka' ),
						'subtitle' => esc_html__( 'Enable the Side Area for the Event Taxonomy.', 'impeka' ),
						'options' => $enable_selection,
						'default' => 'no',
					),
					array(
						'id' => 'event_tax_sidearea_sidebar',
						'type' => 'select',
						'title' => esc_html__( 'Event Taxonomy Side Area Sidebar', 'impeka' ),
						'subtitle' => esc_html__( 'Select the sidebar widget area for the side area.', 'impeka' ),
						'data' => 'sidebar',
						'default' => 'grve-default-sidebar',
					),
					array(
						'id' => 'event_tax_sidearea_icon_style',
						'type' => 'image_select',
						'compiler' => true,
						'title' => esc_html__( 'Event Taxonomy Side Area Icon', 'impeka' ),
						'subtitle'=> esc_html__( 'Select the icon for your side area.', 'impeka' ),
						'options' => $burger_icon_selection,
						'default' => 'style-5',
						'class' => 'small-image-selector',
						'required' => array(
							array( 'header_icon_library', 'equals', 'theme-icons' ),
							array( 'event_tax_sidearea_visibility', 'equals', 'yes' ),
						),
					),
					array(
						'id'   => 'info_style_event_tax_header',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Event Taxonomy Header Settings', 'impeka' ),
						'subtitle'=> esc_html__( 'Set the style for the default Event Taxonomy header.', 'impeka' ),
					),
					array(
						'id' => 'event_tax_header_skin',
						'type' => 'select',
						'title' => esc_html__( 'Event Taxonomy Header Skin', 'impeka' ),
						'subtitle'=> esc_html__( 'Select your Event Taxonomy header skin.', 'impeka' ),
						'options' => $header_skin,
						'default' => 'default',
					),
					array(
						'id' => 'event_tax_header_overlapping',
						'type' => 'select',
						'title' => esc_html__( 'Event Taxonomy Header Overlapping', 'impeka' ),
						'subtitle'=> esc_html__( 'Select if you want the Event Taxonomy Header overlaps the content. Combine this option with the Light or Dark Header.', 'impeka' ),
						'options' => $enable_selection,
						'default' => 'no',
					),
					array(
						'id'   => 'info_style_event_overview',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Event Overview Settings', 'impeka' ),
						'subtitle'=> esc_html__( 'Define your preferences for the event overview.', 'impeka' ),
					),
					array(
						'id' => 'event_overview_image_size',
						'type' => 'select',
						'options' => array(
							'default' => esc_html__( 'Default', 'impeka' ),
							'square' => esc_html__( 'Square Small Crop', 'impeka' ),
							'landscape' => esc_html__( 'Landscape Small Crop', 'impeka' ),
							'portrait' => esc_html__( 'Portrait Small Crop', 'impeka' ),
							'large' => esc_html__( 'Resize ( Large )', 'impeka' ),
							'medium_large' => esc_html__( 'Resize ( Medium Large )', 'impeka' ),
							'medium' => esc_html__( 'Resize ( Medium )', 'impeka' ),
						),
						'title' => esc_html__( 'Event Overview Image Size', 'impeka' ),
						'subtitle' => esc_html__( 'Choose the event overview image size.', 'impeka' ),
						'default' => 'default',
					),
					array(
						'id' => 'event_overview_heading_tag',
						'type' => 'select',
						'title' => esc_html__( 'Event Overview Title Tag', 'impeka' ),
						'subtitle' => esc_html__( 'Select tag for your loop event overview title.', 'impeka' ),
						'options' => $headings_tag_selection,
						'default' => 'h2',
					),
					array(
						'id' => 'event_overview_heading',
						'type' => 'select',
						'title' => esc_html__( 'Event Overview Title Size', 'impeka' ),
						'subtitle' => esc_html__( 'Select size and typography for your event overview title.', 'impeka' ),
						'options' => $headings_selection,
						'default' => 'h2',
					),
				)
			);

			$this->sections[] = array(
				'title' => esc_html__( 'Single Event Settings', 'impeka' ),
				'id' => 'grve_redux_section_single_event_settings',
				'header' => '',
				'desc' => esc_html__( 'Define your preferences for the Single Events. Notice that most of them can be overridden when you create a single event.', 'impeka' ),
				'submenu' => true,
				'icon' => 'el-icon-calendar',
				'icon_class' => 'el-icon-large',
				'customizer' => false,
				'subsection' => true,
				'fields' => array(
					array(
						'id' => 'event_padding_top_multiplier',
						'type' => 'select',
						'title' => esc_html__( 'Event Top Padding', 'impeka' ),
						'subtitle'=> esc_html__( 'Select the space above the content area.', 'impeka' ),
						'options' => $padding_selection_extra,
						'default' => '3x',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'event_padding_top',
						'type' => 'text',
						'title' => esc_html__( 'Event Custom Top Padding', 'impeka' ),
						'subtitle'=> esc_html__( 'You can use px, em, %, etc. or enter just number and it will use pixels.', 'impeka' ),
						'required' => array( 'event_padding_top_multiplier', 'equals', 'custom' ),
					),
					array(
						'id' => 'event_padding_bottom_multiplier',
						'type' => 'select',
						'title' => esc_html__( 'Event Bottom Padding', 'impeka' ),
						'subtitle'=> esc_html__( 'Select the space below the content area.', 'impeka' ),
						'options' => $padding_selection_extra,
						'default' => '3x',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'event_padding_bottom',
						'type' => 'text',
						'title' => esc_html__( 'Event Custom Bottom Padding', 'impeka' ),
						'subtitle'=> esc_html__( 'You can use px, em, %, etc. or enter just number and it will use pixels.', 'impeka' ),
						'required' => array( 'event_padding_bottom_multiplier', 'equals', 'custom' ),
					),
					array(
						'id' => 'event_layout',
						'type' => 'image_select',
						'compiler' => true,
						'title' => esc_html__( 'Event Layout', 'impeka' ),
						'subtitle' => esc_html__( 'Select the layout for the Single Events. Choose among Full Width, Left Sidebar or Right Sidebar.', 'impeka' ),
						'options' => $layout_selection,
						'default' => 'right',
					),
					array(
						'id' => 'event_sidebar',
						'type' => 'select',
						'title' => esc_html__( 'Event Sidebar', 'impeka' ),
						'subtitle' => esc_html__( 'Select the sidebar for the Single Events.', 'impeka' ),
						'data' => 'sidebar',
						'default' => 'grve-default-sidebar',
					),
					array(
						'id' => 'event_fixed_sidebar',
						'type' => 'select',
						'title' => esc_html__( 'Event Fixed Sidebar', 'impeka' ),
						'subtitle'=> esc_html__( 'Select if you want a fixed sidebar.', 'impeka' ),
						'options' => $enable_selection,
						'default' => 'no',
					),
					array(
						'id' => 'event_sidearea_visibility',
						'type' => 'select',
						'title' => esc_html__( 'Event Side Area Visibility', 'impeka' ),
						'subtitle' => esc_html__( 'Enable the Event Side Area if you want.', 'impeka' ),
						'options' => $enable_selection,
						'default' => 'no',
					),
					array(
						'id' => 'event_sidearea_sidebar',
						'type' => 'select',
						'title' => esc_html__( 'Event Side Area Sidebar', 'impeka' ),
						'subtitle' => esc_html__( 'Select the sidebar widget area for the side area.', 'impeka' ),
						'data' => 'sidebar',
						'default' => 'grve-default-sidebar',
					),
					array(
						'id' => 'event_sidearea_icon_style',
						'type' => 'image_select',
						'compiler' => true,
						'title' => esc_html__( 'Event Side Area Icon', 'impeka' ),
						'subtitle'=> esc_html__( 'Select the icon for your side area.', 'impeka' ),
						'options' => $burger_icon_selection,
						'default' => 'style-5',
						'class' => 'small-image-selector',
						'required' => array(
							array( 'header_icon_library', 'equals', 'theme-icons' ),
							array( 'event_sidearea_visibility', 'equals', 'yes' ),
						),
					),
					array(
						'id' => 'event_content_width',
						'type' => 'select',
						'title' => esc_html__( 'Event Content Width', 'impeka' ),
						'subtitle' => esc_html__( 'Select the Event Content width (only for Full Width Post Layout)', 'impeka' ),
						'options' => $container_size_selector,
						'default' => 'large',
					),
					array(
						'id'   => 'info_style_event_header',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Event Header Settings', 'impeka' ),
						'subtitle'=> esc_html__( 'Set the style for the default post header.', 'impeka' ),
					),
					array(
						'id' => 'event_header_skin',
						'type' => 'select',
						'title' => esc_html__( 'Event Header Skin', 'impeka' ),
						'subtitle'=> esc_html__( 'Select your event header skin.', 'impeka' ),
						'options' => $header_skin,
						'default' => 'default',
					),
					array(
						'id' => 'event_header_overlapping',
						'type' => 'select',
						'title' => esc_html__( 'Event Header Overlapping', 'impeka' ),
						'subtitle'=> esc_html__( 'Select if you want the Event Header overlaps the content. Combine this option with the Light or Dark Header. You can still override this when you edit each single event.', 'impeka' ),
						'options' => $enable_selection,
						'default' => 'no',
					),
					array(
						'id'   => 'info_style_event_title',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Single Event Title Settings', 'impeka' ),
						'subtitle'=> esc_html__( 'Set the style for the default single event title.', 'impeka' ),
					),
					array(
						'id' => 'event_title_style',
						'type' => 'select',
						'title' => esc_html__( 'Title Style', 'impeka' ),
						'subtitle' => esc_html__( 'Select Event Title Style', 'impeka' ),
						'options' => $title_style,
						'default' => 'advanced',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'event_title_height',
						'type' => 'select',
						'default' => '60',
						'title' => esc_html__( 'Height', 'impeka' ),
						'subtitle' => esc_html__( 'Enter event title height (Default is 60%).', 'impeka' ),
						'options' => $area_height,
						'validate' => 'not_empty',
						'required' => array( 'event_title_style', 'equals', 'advanced' ),
					),
					array(
						'id' => 'event_title_min_height',
						'type' => 'text',
						'default' => '200',
						'title' => esc_html__( 'Min Height', 'impeka' ),
						'subtitle' => esc_html__( 'Enter event title minimum height in px (Default is 200).', 'impeka' ),
						'validate' => 'numeric',
						'required' => array( 'event_title_style', 'equals', 'advanced' ),
					),
					array(
						'id' => 'event_title_container_size',
						'type' => 'select',
						'title' => esc_html__( 'Container Size', 'impeka' ),
						'subtitle'=> esc_html__( 'Select the size of the container.', 'impeka' ),
						'options' => $container_size_selection,
						'default' => 'default',
						'validate' => 'not_empty',
						'required' => array( 'event_title_style', 'equals', 'advanced' ),
					),
					array(
						'id' => 'event_title_content_size',
						'type' => 'select',
						'title' => esc_html__( 'Content Size', 'impeka' ),
						'subtitle'=> esc_html__( 'Select the size of the content.', 'impeka' ),
						'options' => $content_size_selection,
						'default' => 'container',
						'validate' => 'not_empty',
						'required' => array( 'event_title_style', 'equals', 'advanced' ),
					),
					array(
						'id' => 'event_title_content_alignment',
						'type' => 'image_select',
						'title' => esc_html__( 'Content Alignment', 'impeka' ),
						'subtitle'=> esc_html__( 'Select the alignment of the content.', 'impeka' ),
						'options' => $align_title,
						'default' => 'center',
						'validate' => 'not_empty',
						'required' => array( 'event_title_style', 'equals', 'advanced' ),
					),
					array(
						'id' => 'event_title_content_position',
						'type' => 'image_select',
						'title' => esc_html__( 'Content Position', 'impeka' ),
						'subtitle'=> esc_html__( 'Select your position for the default event title/description.', 'impeka' ),
						'options' => $align_position,
						'class' => 'small-image-selector',
						'default' => 'center-center',
						'validate' => 'not_empty',
						'required' => array( 'event_title_style', 'equals', 'advanced' ),
					),
					array(
						'id' => 'event_title_content_animation',
						'type' => 'select',
						'title' => esc_html__( 'Content Animation', 'impeka' ),
						'subtitle'=> esc_html__( 'Select your animation for the default event title/description.', 'impeka' ),
						'options' => $animation_selection,
						'default' => 'none',
						'validate' => 'not_empty',
						'required' => array( 'event_title_style', 'equals', 'advanced' ),
					),
					array(
						'id'       => 'event_title_bg_mode',
						'type'     => 'select',
						'title' => esc_html__( 'Background Mode', 'impeka' ),
						'subtitle'=> esc_html__( 'Select the Event Title Background, Color or Image.', 'impeka' ),
						'options' => $title_bg_mode,
						'default'  => 'color',
						'required' => array( 'event_title_style', 'equals', 'advanced' ),
					),
					array(
						'id'       => 'event_title_bg_image',
						'type'     => 'media',
						'title' => esc_html__( 'Background Image', 'impeka' ),
						'subtitle' => esc_html__( 'Select a background image for the default event title.', 'impeka' ),
						'required' => array( 'event_title_bg_mode', 'equals', 'custom' ),
					),
					array(
						'id' => 'event_title_bg_position',
						'type' => 'select',
						'title' => esc_html__( 'Background Position', 'impeka' ),
						'options' => $align_selection_full,
						'default' => 'center-center',
						'validate' => 'not_empty',
						'required' => array( 'event_title_bg_mode', '!=', 'color' ),
					),
					array(
						'id' => 'event_title_pattern_overlay',
						'type' => 'select',
						'title' => esc_html__( 'Pattern Overlay', 'impeka' ),
						'options' => $pattern_selection,
						'default' => 'none',
						'required' => array( 'event_title_bg_mode', '!=', 'color' ),
					),
					array(
						'id' => 'event_title_color_overlay',
						'type' => 'select',
						'title' => esc_html__( 'Color Overlay', 'impeka' ),
						'options' => $color_selection,
						'default' => 'black',
						'required' => array( 'event_title_bg_mode', '!=', 'color' ),
					),
					array(
						'id' => 'event_title_opacity_overlay',
						'type' => 'select',
						'title' => esc_html__( 'Opacity Overlay', 'impeka' ),
						'options' => $opacity_selection,
						'default' => '0',
						'required' => array( 'event_title_bg_mode', '!=', 'color' ),
					),
					array(
						'id'   => 'info_style_event_anchor_menu',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Anchor Menu Bar Settings', 'impeka' ),
						'subtitle'=> esc_html__( 'Define your preferences for the Anchor Menu Bar where you can place a custom sticky menu per event.', 'impeka' ),
					),
					array(
						'id' => 'event_anchor_menu_height',
						'type' => 'text',
						'default' => '60',
						'title' => esc_html__( 'Anchor Menu Height', 'impeka' ),
						'subtitle' => esc_html__( 'Enter Anchor Menu height in px (Default is 60).', 'impeka' ),
						'validate' => 'numeric',
					),
					array(
						'id' => 'event_anchor_menu_alignment',
						'type' => 'select',
						'compiler' => true,
						'title' => esc_html__( 'Anchor Menu Alignment', 'impeka' ),
						'subtitle' => esc_html__( 'Select the alignment of your Anchor Menu in events.', 'impeka' ),
						'options' => $align_selection_extra,
						'default' => 'left',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'event_anchor_menu_fullwidth',
						'type' => 'switch',
						'title' => esc_html__( 'Fullwidth', 'impeka' ),
						'subtitle'=> esc_html__( 'Select if you want to have full width Anchor Menu.', 'impeka' ),
						'default' => 0,
					),
					array(
						'id'   => 'info_style_event_breadcrumbs',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Breadcrumbs Bar Settings', 'impeka' ),
						'subtitle'=> esc_html__( 'Define your preferences for the Breadcrumbs Bar.', 'impeka' ),
					),
					array(
						'id'=>'event_breadcrumbs_enabled',
						'type' => 'switch',
						'title' => esc_html__( 'Breadcrumbs', 'impeka' ),
						'subtitle'=> esc_html__( 'Enable or Disable the Breadcrumbs for Single Event / Event Categories / Event Tags.', 'impeka' ),
						"default" => '0',
					),
					array(
						'id' => 'event_breadcrumbs_height',
						'type' => 'text',
						'default' => '60',
						'title' => esc_html__( 'Breadcrumbs Height', 'impeka' ),
						'subtitle' => esc_html__( 'Enter Breadcrumbs height in px (Default is 60).', 'impeka' ),
						'validate' => 'numeric',
						'required' => array( 'event_breadcrumbs_enabled', 'equals', '1' ),
					),
					array(
						'id' => 'event_breadcrumbs_alignment',
						'type' => 'select',
						'compiler' => true,
						'title' => esc_html__( 'Breadcrumbs Alignment', 'impeka' ),
						'subtitle' => esc_html__( 'Select the alignment of your breadcrumbs.', 'impeka' ),
						'options' => $align_selection_extra,
						'default' => 'left',
						'validate' => 'not_empty',
						'required' => array( 'event_breadcrumbs_enabled', 'equals', '1' ),
					),
					array(
						'id' => 'event_breadcrumbs_fullwidth',
						'type' => 'switch',
						'title' => esc_html__( 'Fullwidth', 'impeka' ),
						'subtitle'=> esc_html__( 'Select if you want to show your breadcrumbs full width.', 'impeka' ),
						'default' => 0,
						'required' => array( 'event_breadcrumbs_enabled', 'equals', '1' ),
					),
					array(
						'id' => 'event_image_visibility',
						'type' => 'switch',
						'title' => esc_html__( 'Event Featured Image Visibility', 'impeka' ),
						'subtitle'=> esc_html__( 'Toggle Featured Image on or off.', 'impeka' ),
						"default" => '1',
					),
					array(
						'id' => 'event_image_size',
						'type' => 'select',
						'options' => array(
							'default' => esc_html__( 'Default', 'impeka' ),
							'square' => esc_html__( 'Square Small Crop', 'impeka' ),
							'landscape' => esc_html__( 'Landscape Small Crop', 'impeka' ),
							'landscape-large-wide' => esc_html__( 'Landscape Large Wide Crop', 'impeka' ),
							'portrait' => esc_html__( 'Portrait Small Crop', 'impeka' ),
							'extra-extra-large' => esc_html__( 'Resize ( Extra Extra Large )', 'impeka' ),
							'large' => esc_html__( 'Resize ( Large )', 'impeka' ),
							'medium_large' => esc_html__( 'Resize ( Medium Large )', 'impeka' ),
							'medium' => esc_html__( 'Resize ( Medium )', 'impeka' ),
						),
						'title' => esc_html__( 'Event Image Size', 'impeka' ),
						'subtitle' => esc_html__( 'Choose the event image size.', 'impeka' ),
						'default' => 'default',
					),
					array(
						'id'   => 'info_style_event_nav',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Navigation & Socials Settings', 'impeka' ),
						'subtitle'=> esc_html__( 'Define your preferences for the Navigation.', 'impeka' ),
					),
					array(
						'id'=>'event_nav_visibility',
						'type' => 'switch',
						'title' => esc_html__( 'Event Navigation Visibility', 'impeka' ),
						'subtitle'=> esc_html__( 'Enable or Disable the visibility of the events navigation.', 'impeka' ),
						"default" => '1',
					),
					array(
						'id' => 'event_nav_layout',
						'type' => 'select',
						'title' => esc_html__( 'Navigation Layout', 'impeka' ),
						'subtitle' => esc_html__( 'Select the Layout for the Navigation Bar', 'impeka' ),
						'options' => array(
							'layout-1' => esc_html__( 'Simple Layout', 'impeka' ),
							'layout-2' => esc_html__( 'Floating Layout', 'impeka' ),
							'layout-3' => esc_html__( 'Minimal Layout', 'impeka' ),
						),
						'default' => 'layout-1',
						'required' => array( 'event_nav_visibility', 'equals', '1' ),
					),
					array(
						'id' => 'event_nav_prev_text', //translatable
						'type' => 'text',
						'title' => esc_html__( 'Navigation Previous Text', 'impeka' ),
						'subtitle' => esc_html__( 'Type the text for the previous item.', 'impeka' ),
						"default" => 'Previous Event',
						'required' => array( 'event_nav_layout', 'equals', array( 'layout-1', 'layout-2', 'layout-3' ) ),
					),
					array(
						'id' => 'event_nav_next_text', //translatable
						'type' => 'text',
						'title' => esc_html__( 'Navigation Next Text', 'impeka' ),
						'subtitle' => esc_html__( 'Type the text for the next item.', 'impeka' ),
						"default" => 'Next Event',
						'required' => array( 'event_nav_layout', 'equals', array( 'layout-1', 'layout-2', 'layout-3' ) ),
					),
					array(
						'id' => 'event_nav_same_term',
						'type' => 'switch',
						'title' => esc_html__( 'Event Navigation Same Term', 'impeka' ),
						'subtitle'=> esc_html__( 'If selected, only navigation items from the current taxonomy term will be displayed.', 'impeka' ),
						'default' => 0,
						'required' => array( 'event_nav_visibility', 'equals', '1' ),
					),
					array(
						'id'             => 'event_nav_spacing',
						'type'           => 'spacing',
						'mode'           => 'padding',
						'units'          => array('em', 'px', '%'),
						'units_extended' => 'false',
						'left'           => 'false',
						'right'          => 'false',
						'title'          => esc_html__( 'Navigation Bar Spacing', 'impeka' ),
						'subtitle'       => esc_html__( 'Set the spacing, Top and Bottom, of the Navigation Area.', 'impeka' ),
						'desc'           => esc_html__( 'Set spacing Top, Bottom in px.', 'impeka'),
						'default'        => array(
							'padding-top'     => '30px',
							'padding-bottom'  => '30px',
							'units'           => 'px',
						),
						'required' => array(
							array( 'event_nav_visibility', 'equals', '1' ),
							array( 'event_nav_layout', '!=', 'layout-2' ),
						),
					),
					array(
						'id' => 'event_social',
						'type' => 'checkbox',
						'title' => esc_html__( 'Social Share', 'impeka' ),
						'subtitle' => esc_html__( 'Enable or Disable social shares for the Single Event.', 'impeka' ),
						'options' => $event_social_options,
						'default' => 0,
					),
					array(
						'id' => 'event_social_share_title', //translatable
						'type' => 'text',
						'title' => esc_html__( 'Social Share Title', 'impeka' ),
						'subtitle' => esc_html__( 'Type the text for the social share title.', 'impeka' ),
						"default" => 'Share',
					),
					array(
						'id' => 'event_nav_skin_assets',
						'type' => 'select',
						'title' => esc_html__( 'Skin Assets', 'impeka' ),
						'subtitle'    => esc_html__( 'Skin for the extra assets.', 'impeka' ),
						'options' => array(
							'dark' => esc_html__( 'Dark', 'impeka' ),
							'light' => esc_html__( 'Light', 'impeka' ),
						),
						'default' => 'dark',
						'required' => array( 'event_nav_layout', 'equals', array('layout-1', 'layout-3' ) ),
					),
				)
			);

			$this->sections[] = array(
				'icon' => 'el-icon-comment-alt',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( 'bbPress Forum Options', 'impeka'),
				'id' => 'grve_redux_section_bbpress_options',
				'subtitle' => esc_html__( 'You can find the Theme settings for the bbPress here.', 'impeka' ),
				'submenu' => true,
				'subsection' => true,
				'customizer' => false,
				'fields' => array(
					array(
						'id' => 'forum_layout',
						'type' => 'image_select',
						'compiler' => true,
						'title' => esc_html__( 'Forum Layout', 'impeka' ),
						'subtitle' => esc_html__( 'Select the default layout for the Forum. Choose among Full Width, Left Sidebar or Right Sidebar.', 'impeka' ),
						'options' => $layout_selection,
						'default' => 'none',
					),
					array(
						'id' => 'forum_sidebar',
						'type' => 'select',
						'title' => esc_html__( 'Forum Sidebar', 'impeka' ),
						'subtitle' => esc_html__( 'Select the default sidebar for the single Forum.', 'impeka' ),
						'data' => 'sidebar',
						'default' => 'grve-default-sidebar',
					),
					array(
						'id' => 'forum_fixed_sidebar',
						'type' => 'select',
						'title' => esc_html__( 'Forum Fixed Sidebar', 'impeka' ),
						'subtitle'=> esc_html__( 'Select if you want a fixed sidebar.', 'impeka' ),
						'options' => $enable_selection,
						'default' => 'no',
					),
					array(
						'id' => 'forum_sidearea_visibility',
						'type' => 'select',
						'title' => esc_html__( 'Forum Side Area Visibility', 'impeka' ),
						'subtitle' => esc_html__( 'Enable the Side Area for the Forum.', 'impeka' ),
						'options' => $enable_selection,
						'default' => 'no',
					),
					array(
						'id' => 'forum_sidearea_sidebar',
						'type' => 'select',
						'title' => esc_html__( 'Forum Side Area Sidebar', 'impeka' ),
						'subtitle' => esc_html__( 'Select the sidebar widget area for the side area.', 'impeka' ),
						'data' => 'sidebar',
						'default' => 'grve-default-sidebar',
					),
					array(
						'id' => 'forum_sidearea_icon_style',
						'type' => 'image_select',
						'compiler' => true,
						'title' => esc_html__( 'Forum Side Area Icon', 'impeka' ),
						'subtitle'=> esc_html__( 'Select the icon for your side area.', 'impeka' ),
						'options' => $burger_icon_selection,
						'default' => 'style-5',
						'class' => 'small-image-selector',
						'required' => array(
							array( 'header_icon_library', 'equals', 'theme-icons' ),
							array( 'forum_sidearea_visibility', 'equals', 'yes' ),
						),
					),
					array(
						'id'   => 'info_style_forum_header',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Forum Header Settings', 'impeka' ),
						'subtitle'=> esc_html__( 'Set the style for the default Forum header.', 'impeka' ),
					),
					array(
						'id' => 'forum_header_skin',
						'type' => 'select',
						'title' => esc_html__( 'Forum Header Skin', 'impeka' ),
						'subtitle'=> esc_html__( 'Select your Forum header skin.', 'impeka' ),
						'options' => $header_skin,
						'default' => 'default',
					),
					array(
						'id' => 'forum_header_overlapping',
						'type' => 'select',
						'title' => esc_html__( 'Forum Header Overlapping', 'impeka' ),
						'subtitle'=> esc_html__( 'Select if you want the Forum Header overlaps the content. Combine this option with the Light or Dark Header.', 'impeka' ),
						'options' => $enable_selection,
						'default' => 'no',
					),
					array(
						'id'   => 'info_style_forum_title',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Forum Title Settings', 'impeka' ),
						'subtitle'=> esc_html__( 'Set the style for the single default Forum title.', 'impeka' ),
					),
					array(
						'id' => 'forum_title_height',
						'type' => 'select',
						'default' => '60',
						'title' => esc_html__( 'Height', 'impeka' ),
						'subtitle' => esc_html__( 'Enter Forum title height (Default is 60%).', 'impeka' ),
						'options' => $area_height,
						'validate' => 'not_empty',
					),
					array(
						'id' => 'forum_title_min_height',
						'type' => 'text',
						'default' => '320',
						'title' => esc_html__( 'Min Height', 'impeka' ),
						'subtitle' => esc_html__( 'Enter Forum title minimum height in px (Default is 320).', 'impeka' ),
						'validate' => 'numeric',
					),
					array(
						'id' => 'forum_title_container_size',
						'type' => 'select',
						'title' => esc_html__( 'Container Size', 'impeka' ),
						'subtitle'=> esc_html__( 'Select the size of the container.', 'impeka' ),
						'options' => $container_size_selection,
						'default' => 'default',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'forum_title_content_size',
						'type' => 'select',
						'title' => esc_html__( 'Content Size', 'impeka' ),
						'subtitle'=> esc_html__( 'Select the size of the content.', 'impeka' ),
						'options' => $content_size_selection,
						'default' => 'container',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'forum_title_content_alignment',
						'type' => 'image_select',
						'title' => esc_html__( 'Content Alignment', 'impeka' ),
						'subtitle'=> esc_html__( 'Select the alignment of the content.', 'impeka' ),
						'options' => $align_title,
						'default' => 'center',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'forum_title_content_position',
						'type' => 'image_select',
						'title' => esc_html__( 'Content Position', 'impeka' ),
						'subtitle'=> esc_html__( 'Select your position for the default Forum title/description.', 'impeka' ),
						'options' => $align_position,
						'class' => 'small-image-selector',
						'default' => 'center-center',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'forum_title_content_animation',
						'type' => 'select',
						'title' => esc_html__( 'Content Animation', 'impeka' ),
						'subtitle'=> esc_html__( 'Select your animation for the default Forum title/description.', 'impeka' ),
						'options' => $animation_selection,
						'default' => 'none',
						'validate' => 'not_empty',
					),
					array(
						'id'       => 'forum_title_bg_mode',
						'type'     => 'select',
						'title' => esc_html__( 'Background Mode', 'impeka' ),
						'subtitle'=> esc_html__( 'Select the Forum Title Background, Color or Image.', 'impeka' ),
						'options' => $title_bg_mode_limited,
						'default'  => 'color',
					),
					array(
						'id'       => 'forum_title_bg_image',
						'type'     => 'media',
						'title' => esc_html__( 'Background Image', 'impeka' ),
						'subtitle' => esc_html__( 'Select a background image for the default Forum title.', 'impeka' ),
						'required' => array( 'forum_title_bg_mode', 'equals', 'custom' ),
					),
					array(
						'id' => 'forum_title_bg_position',
						'type' => 'select',
						'title' => esc_html__( 'Background Position', 'impeka' ),
						'options' => $align_selection_full,
						'default' => 'center-center',
						'validate' => 'not_empty',
						'required' => array( 'forum_title_bg_mode', '!=', 'color' ),
					),
					array(
						'id' => 'forum_title_pattern_overlay',
						'type' => 'select',
						'title' => esc_html__( 'Pattern Overlay', 'impeka' ),
						'options' => $pattern_selection,
						'default' => 'none',
						'required' => array( 'forum_title_bg_mode', '!=', 'color' ),
					),
					array(
						'id' => 'forum_title_color_overlay',
						'type' => 'select',
						'title' => esc_html__( 'Color Overlay', 'impeka' ),
						'options' => $color_selection,
						'default' => 'black',
						'required' => array( 'forum_title_bg_mode', '!=', 'color' ),
					),
					array(
						'id' => 'forum_title_opacity_overlay',
						'type' => 'select',
						'title' => esc_html__( 'Opacity Overlay', 'impeka' ),
						'options' => $opacity_selection,
						'default' => '0',
						'required' => array( 'forum_title_bg_mode', '!=', 'color' ),
					),
				)
			);


			$this->sections[] = array(
				'title' => esc_html__( 'Typography Options', 'impeka' ),
				'id' => 'grve_redux_section_typography_options',
				'header' => '',
				'desc' => '',
				'icon_class' => 'el-icon-large',
				'icon' => 'el-icon-font',
				'submenu' => true,
				'customizer' => false,
				'fields' => array(),
			);

			$this->sections[] = array(
				'title' => esc_html__( 'Header/Body', 'impeka' ),
				'id' => 'grve_redux_section_typography_header',
				'header' => '',
				'desc' => esc_html__( 'Define your main typography settings.', 'impeka' ),
				'icon_class' => 'el-icon-large',
				'icon' => 'el-icon-font',
				'submenu' => true,
				'customizer' => false,
				'subsection' => true,
				'fields' => array(
					array(
						'id'   => 'info_body_typography',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Main Body Fonts', 'impeka' ),
					),
					array(
						'id' => 'body_font',
						'type' => 'typography',
						'title' => esc_html__( 'Body Font', 'impeka' ),
						'subtitle' => esc_html__( 'Specify the body font properties.', 'impeka' ),
						'google' => $is_google,
						'line-height'=> true,
						'text-align'=> false,
						'letter-spacing' => true,
						'color'=> false,
						'preview'=> true,
						'default' => array(
							'font-size' => '16px',
							'line-height' => '24px',
							'font-family' => 'Jost',
							'font-weight' => '400',
							'letter-spacing' => '',
						),
						'fonts' => $std_fonts,
						'font-backup' => true,
					),
					array(
						'id' => 'single_post_font',
						'type' => 'typography',
						'title' => esc_html__( 'Single Post & Product Body Font', 'impeka' ),
						'subtitle' => esc_html__( 'Specify the single post & single product body font properties.', 'impeka' ),
						'google' => $is_google,
						'line-height'=> true,
						'text-align'=> false,
						'letter-spacing' => true,
						'color'=> false,
						'preview'=> true,
						'default' => array(
							'font-size' => '18px',
							'line-height' => '36px',
							'font-family' => 'Jost',
							'font-weight' => '400',
							'letter-spacing' => '',
						),
						'fonts' => $std_fonts,
					),
					array(
						'id'   => 'info_logo_typography',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Logo as text Fonts', 'impeka' ),
					),
					array(
						'id' => 'logo_font',
						'type' => 'typography',
						'title' => esc_html__( 'Logo Font', 'impeka' ),
						'subtitle' => esc_html__( 'Specify the logo font properties.', 'impeka' ),
						'google' => $is_google,
						'line-height'=> false,
						'text-align'=> false,
						'letter-spacing' => true,
						'color'=> false,
						'preview'=> true,
						'text-transform' => true,
						'default' => array(
							'font-family' => 'Jost',
							'font-size' => '36px',
							'font-weight' => '600',
							'text-transform' => 'none',
							'letter-spacing' => '',
						),
						'fonts' => $std_fonts,
					),
					array(
						'id'   => 'info_menu_typography',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Main Menu Fonts', 'impeka' ),
					),
					array(
						'id' => 'main_menu_font',
						'type' => 'typography',
						'title' => esc_html__( 'Menu Font', 'impeka' ),
						'subtitle' => esc_html__( 'Specify the menu font properties.', 'impeka' ),
						'google' => $is_google,
						'line-height' => false,
						'text-align' => false,
						'letter-spacing' => true,
						'color'=> false,
						'preview'=> true,
						'text-transform' => true,
						'default' => array(
							'font-family' => 'Jost',
							'font-size' => '16px',
							'font-weight' => '500',
							'text-transform' => 'none',
							'letter-spacing' => '',
						),
						'fonts' => $std_fonts,
					),
					array(
						'id' => 'megamenu_titles_font',
						'type' => 'typography',
						'title' => esc_html__( 'Megamenu Title Font', 'impeka' ),
						'subtitle' => esc_html__( 'Specify the megamenu titles font properties.', 'impeka' ),
						'google' => $is_google,
						'line-height' => false,
						'text-align' => false,
						'letter-spacing' => true,
						'color'=> false,
						'preview'=> true,
						'text-transform' => true,
						'default' => array(
							'font-family' => 'Jost',
							'font-size' => '12px',
							'font-weight' => '600',
							'text-transform' => 'uppercase',
							'letter-spacing' => '0.5px',
						),
						'fonts' => $std_fonts,
					),
					array(
						'id' => 'sub_menu_font',
						'type' => 'typography',
						'title' => esc_html__( 'Submenu Font', 'impeka' ),
						'subtitle' => esc_html__( 'Specify the submenu font properties.', 'impeka' ),
						'google' => $is_google,
						'line-height' => false,
						'text-align' => false,
						'letter-spacing' => true,
						'color'=> false,
						'preview'=> true,
						'text-transform' => true,
						'default' => array(
							'font-family' => 'Jost',
							'font-size' => '14px',
							'font-weight' => '400',
							'text-transform' => 'none',
							'letter-spacing' => '',
						),
						'fonts' => $std_fonts,
					),
					array(
						'id' => 'description_menu_font',
						'type' => 'typography',
						'title' => esc_html__( 'Menu Description Font', 'impeka' ),
						'subtitle' => esc_html__( 'Specify the Menu description font properties.', 'impeka' ),
						'google' => $is_google,
						'line-height' => false,
						'text-align' => false,
						'letter-spacing' => true,
						'color'=> false,
						'preview'=> true,
						'text-transform' => true,
						'default' => array(
							'font-family' => 'Jost',
							'font-size' => '11px',
							'font-weight' => '400',
							'text-transform' => 'none',
							'letter-spacing' => '',
						),
						'fonts' => $std_fonts,
					),
					array(
						'id'   => 'info_responsive_menu_typography',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Responsive Menu Fonts', 'impeka' ),
					),
					array(
						'id' => 'responsive_menu_font',
						'type' => 'typography',
						'title' => esc_html__( 'Responsive Menu Font', 'impeka' ),
						'subtitle' => esc_html__( 'Specify the responsive menu font properties.', 'impeka' ),
						'google' => $is_google,
						'line-height' => false,
						'text-align' => false,
						'letter-spacing' => true,
						'color'=> false,
						'preview'=> true,
						'text-transform' => true,
						'default' => array(
							'font-family' => 'Jost',
							'text-transform' => 'none',
							'font-weight' => '500',
							'font-size' => '36px',
							'letter-spacing' => '',
						),
						'fonts' => $std_fonts,
					),
					array(
						'id' => 'sub_responsive_menu_font',
						'type' => 'typography',
						'title' => esc_html__( 'Responsive Submenu Font', 'impeka' ),
						'subtitle' => esc_html__( 'Specify the responsive submenu font properties.', 'impeka' ),
						'google' => $is_google,
						'line-height' => false,
						'text-align' => false,
						'letter-spacing' => true,
						'color'=> false,
						'preview'=> true,
						'text-transform' => true,
						'default' => array(
							'font-family' => 'Jost',
							'font-size' => '24px',
							'font-weight' => '500',
							'text-transform' => 'none',
							'letter-spacing' => '',
						),
						'fonts' => $std_fonts,
					),
					array(
						'id' => 'description_responsive_menu_font',
						'type' => 'typography',
						'title' => esc_html__( 'Responsive Menu Description Font', 'impeka' ),
						'subtitle' => esc_html__( 'Specify the responsive menu description font properties.', 'impeka' ),
						'google' => $is_google,
						'line-height' => false,
						'text-align' => false,
						'letter-spacing' => true,
						'color'=> false,
						'preview'=> true,
						'text-transform' => true,
						'default' => array(
							'font-family' => 'Jost',
							'font-size' => '11px',
							'font-weight' => '300',
							'text-transform' => 'none',
							'letter-spacing' => '',
						),
						'fonts' => $std_fonts,
					),
					array(
						'id'   => 'info_offcanvas_menu_typography',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Offcanvas Menu Fonts', 'impeka' ),
					),
					array(
						'id' => 'offcanvas_menu_font',
						'type' => 'typography',
						'title' => esc_html__( 'Offcanvas Menu Font', 'impeka' ),
						'subtitle' => esc_html__( 'Specify the offcanvas menu font properties.', 'impeka' ),
						'google' => $is_google,
						'line-height' => false,
						'text-align' => false,
						'letter-spacing' => true,
						'color'=> false,
						'preview'=> true,
						'text-transform' => true,
						'default' => array(
							'font-family' => 'Jost',
							'text-transform' => 'none',
							'font-weight' => '500',
							'font-size' => '36px',
							'letter-spacing' => '',
						),
						'fonts' => $std_fonts,
					),
					array(
						'id' => 'sub_offcanvas_menu_font',
						'type' => 'typography',
						'title' => esc_html__( 'Offcanvas Submenu Font', 'impeka' ),
						'subtitle' => esc_html__( 'Specify the offcanvas submenu font properties.', 'impeka' ),
						'google' => $is_google,
						'line-height' => false,
						'text-align' => false,
						'letter-spacing' => true,
						'color'=> false,
						'preview'=> true,
						'text-transform' => true,
						'default' => array(
							'font-family' => 'Jost',
							'font-size' => '24px',
							'font-weight' => '500',
							'text-transform' => 'none',
							'letter-spacing' => '',
						),
						'fonts' => $std_fonts,
					),
					array(
						'id' => 'description_offcanvas_menu_font',
						'type' => 'typography',
						'title' => esc_html__( 'Offcanvas Menu Description Font', 'impeka' ),
						'subtitle' => esc_html__( 'Specify the offcanvas menu description font properties.', 'impeka' ),
						'google' => $is_google,
						'line-height' => false,
						'text-align' => false,
						'letter-spacing' => true,
						'color'=> false,
						'preview'=> true,
						'text-transform' => true,
						'default' => array(
							'font-family' => 'Jost',
							'font-size' => '11px',
							'font-weight' => '300',
							'text-transform' => 'none',
							'letter-spacing' => '',
						),
						'fonts' => $std_fonts,
					),
				)
			);

			$this->sections[] = array(
				'title' => esc_html__( 'Headings (H1-H6)', 'impeka' ),
				'id' => 'grve_redux_section_typography_headings',
				'header' => '',
				'desc' => esc_html__( 'Define your Typography Headings ( H1-H6 ).', 'impeka' ),
				'icon_class' => 'el-icon-large',
				'icon' => 'el-icon-font',
				'submenu' => true,
				'customizer' => false,
				'subsection' => true,
				'fields' => array(
					array(
						'id'   => 'info_headers_typography',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Headings Fonts', 'impeka' ),
					),
					array(
						'id' => 'h1_font',
						'type' => 'typography',
						'title' => esc_html__( 'H1 Font', 'impeka' ),
						'subtitle' => esc_html__( 'Specify the H1 font.', 'impeka' ),
						'google' => $is_google,
						'line-height' => true,
						'text-align' => false,
						'letter-spacing' => true,
						'color'=> false,
						'preview'=> true,
						'text-transform' => true,
						'default' => array(
							'font-family' => 'Jost',
							'text-transform' => 'none',
							'font-weight' => '600',
							'font-size' => '56px',
							'line-height' => '64px',
							'letter-spacing' => '',
						),
						'fonts' => $std_fonts,
					),
					array(
						'id' => 'h2_font',
						'type' => 'typography',
						'title' => esc_html__( 'H2 Font', 'impeka' ),
						'subtitle' => esc_html__( 'Specify the H2 font.', 'impeka' ),
						'google' => $is_google,
						'line-height' => true,
						'text-align' => false,
						'letter-spacing' => true,
						'color'=> false,
						'preview'=> true,
						'text-transform' => true,
						'default' => array(
							'font-family' => 'Jost',
							'text-transform' => 'none',
							'font-weight' => '600',
							'font-size' => '48px',
							'line-height' => '56px',
							'letter-spacing' => '',
						),
						'fonts' => $std_fonts,
					),
					array(
						'id' => 'h3_font',
						'type' => 'typography',
						'title' => esc_html__( 'H3 Font', 'impeka' ),
						'subtitle' => esc_html__( 'Specify the H3 font.', 'impeka' ),
						'google' => $is_google,
						'line-height' => true,
						'text-align' => false,
						'letter-spacing' => true,
						'color'=> false,
						'preview'=> true,
						'text-transform' => true,
						'default' => array(
							'font-family' => 'Jost',
							'text-transform' => 'none',
							'font-weight' => '600',
							'font-size' => '40px',
							'line-height' => '48px',
							'letter-spacing' => '',
						),
						'fonts' => $std_fonts,
					),
					array(
						'id' => 'h4_font',
						'type' => 'typography',
						'title' => esc_html__( 'H4 Font', 'impeka' ),
						'subtitle' => esc_html__( 'Specify the H4 font.', 'impeka' ),
						'google' => $is_google,
						'line-height' => true,
						'text-align' => false,
						'letter-spacing' => true,
						'color'=> false,
						'preview'=> true,
						'text-transform' => true,
						'default' => array(
							'font-family' => 'Jost',
							'text-transform' => 'none',
							'font-weight' => '600',
							'font-size' => '32px',
							'line-height' => '40px',
							'letter-spacing' => '',
						),
						'fonts' => $std_fonts,
					),
					array(
						'id' => 'h5_font',
						'type' => 'typography',
						'title' => esc_html__( 'H5 Font', 'impeka' ),
						'subtitle' => esc_html__( 'Specify the H5 font.', 'impeka' ),
						'google' => $is_google,
						'line-height' => true,
						'text-align' => false,
						'letter-spacing' => true,
						'color'=> false,
						'preview'=> true,
						'text-transform' => true,
						'default' => array(
							'font-family' => 'Jost',
							'text-transform' => 'none',
							'font-weight' => '600',
							'font-size' => '24px',
							'line-height' => '32px',
							'letter-spacing' => '',
						),
						'fonts' => $std_fonts,
					),
					array(
						'id' => 'h6_font',
						'type' => 'typography',
						'title' => esc_html__( 'H6 Font', 'impeka' ),
						'subtitle' => esc_html__( 'Specify the H6 font.', 'impeka' ),
						'google' => $is_google,
						'line-height' => true,
						'text-align' => false,
						'letter-spacing' => true,
						'color'=> false,
						'preview'=> true,
						'text-transform' => true,
						'default' => array(
							'font-family' => 'Jost',
							'text-transform' => 'none',
							'font-weight' => '600',
							'font-size' => '20px',
							'line-height' => '32px',
							'letter-spacing' => '',
						),
						'fonts' => $std_fonts,
					),
				)
			);

			$this->sections[] = array(
				'title' => esc_html__( 'Titles/Descriptions', 'impeka' ),
				'id' => 'grve_redux_section_typography_titles',
				'header' => '',
				'desc' => esc_html__( 'Define your typography for titles/descriptions.', 'impeka' ),
				'icon_class' => 'el-icon-large',
				'icon' => 'el-icon-font',
				'submenu' => true,
				'customizer' => false,
				'subsection' => true,
				'fields' => array(
					array(
						'id'   => 'info_page_typography',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Page/Blog/Portfolio Typography', 'impeka' ),
					),
					array(
						'id' => 'page_title',
						'type' => 'typography',
						'title' => esc_html__( 'Page Title', 'impeka' ),
						'subtitle' => esc_html__( 'Specify the font for the default page titles and for the assigned blog page in case you have set a Static Page as blog page in Settings > Reading > Front Page Displays. (Archives / Categories / Tags overview pages)', 'impeka' ),
						'google' => $is_google,
						'line-height' => true,
						'text-align' => false,
						'letter-spacing' => true,
						'color'=> false,
						'preview'=> true,
						'text-transform' => true,
						'default' => array(
							'font-family' => 'Jost',
							'text-transform' => 'none',
							'font-weight' => '600',
							'font-size' => '84px',
							'line-height' => '96px',
							'letter-spacing' => '',
						),
						'fonts' => $std_fonts,
					),
					array(
						'id' => 'page_description',
						'type' => 'typography',
						'title' => esc_html__( 'Page Description', 'impeka' ),
						'subtitle' => esc_html__( 'Specify font for the page description and for the description of the assigned blog page in case you have set a Static Page as blog page in Settings > Reading > Front Page Displays. (Archives / Categories / Tags overview pages)', 'impeka' ),
						'google' => $is_google,
						'line-height' => true,
						'text-align' => false,
						'letter-spacing' => true,
						'color'=> false,
						'preview'=> true,
						'text-transform' => true,
						'default' => array(
							'font-family' => 'Jost',
							'font-size' => '24px',
							'line-height' => '40px',
							'font-weight' => '400',
							'text-transform' => 'none',
							'letter-spacing' => '',
						),
						'fonts' => $std_fonts,
					),
					array(
						'id'   => 'info_post_typography',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Single Post Typography', 'impeka' ),
					),
					array(
						'id' => 'post_simple_title',
						'type' => 'typography',
						'title' => esc_html__( 'Post Simple Title', 'impeka' ),
						'subtitle' => esc_html__( 'Specify the font for the single post simple title.', 'impeka' ),
						'google' => $is_google,
						'line-height' => true,
						'text-align' => false,
						'letter-spacing' => true,
						'color'=> false,
						'preview'=> true,
						'text-transform' => true,
						'default' => array(
							'font-family' => 'Jost',
							'font-size' => '48px',
							'line-height' => '56px',
							'font-weight' => '600',
							'text-transform' => 'none',
							'letter-spacing' => '',
						),
						'fonts' => $std_fonts,
					),
					array(
						'id' => 'post_title',
						'type' => 'typography',
						'title' => esc_html__( 'Post Title', 'impeka' ),
						'subtitle' => esc_html__( 'Specify the font for the single post titles.', 'impeka' ),
						'google' => $is_google,
						'line-height' => true,
						'text-align' => false,
						'letter-spacing' => true,
						'color'=> false,
						'preview'=> true,
						'text-transform' => true,
						'default' => array(
							'font-family' => 'Jost',
							'text-transform' => 'none',
							'font-weight' => '600',
							'font-size' => '84px',
							'line-height' => '96px',
							'letter-spacing' => '',
						),
						'fonts' => $std_fonts,
					),
					array(
						'id' => 'post_title_desc',
						'type' => 'typography',
						'title' => esc_html__( 'Post Description', 'impeka' ),
						'subtitle' => esc_html__( 'Specify the font for the single post description.', 'impeka' ),
						'google' => $is_google,
						'line-height' => true,
						'text-align' => false,
						'letter-spacing' => true,
						'color'=> false,
						'preview'=> true,
						'text-transform' => true,
						'default' => array(
							'font-family' => 'Jost',
							'font-size' => '24px',
							'line-height' => '48px',
							'font-weight' => '400',
							'text-transform' => 'none',
							'letter-spacing' => '',
						),
						'fonts' => $std_fonts,
					),
					array(
						'id' => 'post_title_meta',
						'type' => 'typography',
						'title' => esc_html__( 'Post Meta', 'impeka' ),
						'subtitle' => esc_html__( 'Specify the font for meta ( categories ) in the post title section.', 'impeka' ),
						'google' => $is_google,
						'line-height' => true,
						'text-align' => false,
						'letter-spacing' => true,
						'color'=> false,
						'preview'=> true,
						'text-transform' => true,
						'default' => array(
							'font-family' => 'Jost',
							'font-size' => '16px',
							'line-height' => '22px',
							'font-weight' => '600',
							'text-transform' => 'capitalize',
							'letter-spacing' => '',
						),
						'fonts' => $std_fonts,
					),
					array(
						'id' => 'post_title_extra_meta',
						'type' => 'typography',
						'title' => esc_html__( 'Post Extra Meta', 'impeka' ),
						'subtitle' => esc_html__( 'Specify the font for extra meta ( Author/Date/Comments ) in the post title section.', 'impeka' ),
						'google' => $is_google,
						'line-height' => true,
						'text-align' => false,
						'letter-spacing' => true,
						'color'=> false,
						'preview'=> true,
						'text-transform' => true,
						'default' => array(
							'font-family' => 'Jost',
							'font-size' => '16px',
							'line-height' => '24px',
							'font-weight' => '600',
							'text-transform' => 'capitalize',
							'letter-spacing' => '',
						),
						'fonts' => $std_fonts,
					),
					array(
						'id'   => 'info_portfolio_typography',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Single Portfolio Typography', 'impeka' ),
					),
					array(
						'id' => 'portfolio_title',
						'type' => 'typography',
						'title' => esc_html__( 'Portfolio Title', 'impeka' ),
						'subtitle' => esc_html__( 'Specify the font for the default single portfolio titles.', 'impeka' ),
						'google' => $is_google,
						'line-height' => true,
						'text-align' => false,
						'letter-spacing' => true,
						'color'=> false,
						'preview'=>false,
						'text-transform' => true,
						'default' => array(
							'font-family' => 'Jost',
							'text-transform' => 'none',
							'font-weight' => '600',
							'font-size' => '84px',
							'line-height' => '96px',
							'letter-spacing' => '',
						),
						'fonts' => $std_fonts,
					),
					array(
						'id' => 'portfolio_description',
						'type' => 'typography',
						'title' => esc_html__( 'Portfolio Description', 'impeka' ),
						'subtitle' => esc_html__( 'Specify the font for the default single portfolio description.', 'impeka' ),
						'google' => $is_google,
						'line-height' => true,
						'text-align' => false,
						'letter-spacing' => true,
						'color'=> false,
						'preview'=>false,
						'text-transform' => true,
						'default' => array(
							'font-family' => 'Jost',
							'font-size' => '24px',
							'line-height' => '40px',
							'font-weight' => '400',
							'text-transform' => 'none',
							'letter-spacing' => '',
						),
						'fonts' => $std_fonts,
					),
					array(
						'id' => 'portfolio_title_meta',
						'type' => 'typography',
						'title' => esc_html__( 'Portfolio Meta', 'impeka' ),
						'subtitle' => esc_html__( 'Specify the font for meta ( categories ) in the portfolio title section.', 'impeka' ),
						'google' => $is_google,
						'line-height' => true,
						'text-align' => false,
						'letter-spacing' => true,
						'color'=> false,
						'preview'=> true,
						'text-transform' => true,
						'default' => array(
							'font-family' => 'Jost',
							'font-size' => '24px',
							'line-height' => '32px',
							'font-weight' => '600',
							'text-transform' => 'capitalize',
							'letter-spacing' => '',
						),
						'fonts' => $std_fonts,
					),
					array(
						'id'   => 'info_forum_typography',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'bbPress Forum Typography', 'impeka' ),
					),
					array(
						'id' => 'forum_title',
						'type' => 'typography',
						'title' => esc_html__( 'Forum Title', 'impeka' ),
						'subtitle' => esc_html__( 'Specify the font for the forum titles.', 'impeka' ),
						'google' => $is_google,
						'line-height' => true,
						'text-align' => false,
						'letter-spacing' => true,
						'color'=> false,
						'preview'=>false,
						'text-transform' => true,
						'default' => array(
							'font-family' => 'Jost',
							'text-transform' => 'none',
							'font-weight' => '600',
							'font-size' => '84px',
							'line-height' => '96px',
							'letter-spacing' => '',
						),
						'fonts' => $std_fonts,
					),
					array(
						'id'   => 'info_woocommerce_typography',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'WooCommerce Typography', 'impeka' ),
					),
					array(
						'id' => 'product_simple_title',
						'type' => 'typography',
						'title' => esc_html__( 'WooCommerce Product Simple Title', 'impeka' ),
						'subtitle' => esc_html__( 'Specify the font for the product simple title', 'impeka' ),
						'google' => $is_google,
						'line-height' => true,
						'text-align' => false,
						'letter-spacing' => true,
						'color'=> false,
						'preview'=>false,
						'text-transform' => true,
						'default' => array(
							'font-family' => 'Jost',
							'text-transform' => 'none',
							'font-weight' => '600',
							'font-size' => '32px',
							'line-height' => '40px',
							'letter-spacing' => '',
						),
						'fonts' => $std_fonts,
					),
					array(
						'id' => 'product_short_description',
						'type' => 'typography',
						'title' => esc_html__( 'WooCommerce Product Short Description', 'impeka' ),
						'subtitle' => esc_html__( 'Specify the font for the product short description', 'impeka' ),
						'google' => $is_google,
						'line-height' => true,
						'text-align' => false,
						'letter-spacing' => true,
						'color'=> false,
						'preview'=>false,
						'text-transform' => true,
						'default' => array(
							'font-family' => 'Jost',
							'font-size' => '16px',
							'line-height' => '30px',
							'font-weight' => '400',
							'text-transform' => 'none',
							'letter-spacing' => '',
						),
						'fonts' => $std_fonts,
					),
					array(
						'id' => 'product_tax_title',
						'type' => 'typography',
						'title' => esc_html__( 'WooCommerce Title', 'impeka' ),
						'subtitle' => esc_html__( 'Specify the font for the product titles', 'impeka' ),
						'google' => $is_google,
						'line-height' => true,
						'text-align' => false,
						'letter-spacing' => true,
						'color'=> false,
						'preview'=>false,
						'text-transform' => true,
						'default' => array(
							'font-family' => 'Jost',
							'text-transform' => 'none',
							'font-weight' => '600',
							'font-size' => '72px',
							'line-height' => '84px',
							'letter-spacing' => '',
						),
						'fonts' => $std_fonts,
					),
					array(
						'id' => 'product_tax_description',
						'type' => 'typography',
						'title' => esc_html__( 'WooCommerce Title Description', 'impeka' ),
						'subtitle' => esc_html__( 'Specify font for the product title description', 'impeka' ),
						'google' => $is_google,
						'line-height' => true,
						'text-align' => false,
						'letter-spacing' => true,
						'color'=> false,
						'preview'=>false,
						'text-transform' => true,
						'default' => array(
							'font-family' => 'Jost',
							'font-size' => '24px',
							'line-height' => '40px',
							'font-weight' => '400',
							'text-transform' => 'none',
							'letter-spacing' => '',
						),
						'fonts' => $std_fonts,
					),
										array(
						'id'   => 'info_events_typography',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Events Calendar Typography', 'impeka' ),
					),
					array(
						'id' => 'event_tax_title',
						'type' => 'typography',
						'title' => esc_html__( 'Events Title', 'impeka' ),
						'subtitle' => esc_html__( 'Specify the font for the event titles', 'impeka' ),
						'google' => $is_google,
						'line-height' => true,
						'text-align' => false,
						'letter-spacing' => true,
						'color'=> false,
						'preview'=>false,
						'text-transform' => true,
						'default' => array(
							'font-family' => 'Jost',
							'text-transform' => 'none',
							'font-weight' => '600',
							'font-size' => '84px',
							'line-height' => '96px',
							'letter-spacing' => '',
						),
						'fonts' => $std_fonts,
					),
					array(
						'id' => 'event_tax_description',
						'type' => 'typography',
						'title' => esc_html__( 'Events Description', 'impeka' ),
						'subtitle' => esc_html__( 'Specify font for the events description', 'impeka' ),
						'google' => $is_google,
						'line-height' => true,
						'text-align' => false,
						'letter-spacing' => true,
						'color'=> false,
						'preview'=>false,
						'text-transform' => true,
						'default' => array(
							'font-family' => 'Jost',
							'font-size' => '24px',
							'line-height' => '40px',
							'font-weight' => '400',
							'text-transform' => 'none',
							'letter-spacing' => '',
						),
						'fonts' => $std_fonts,
					),
				)
			);

			$this->sections[] = array(
				'title' => esc_html__( 'Feature Section', 'impeka' ),
				'id' => 'grve_redux_section_typography_feature_section',
				'header' => '',
				'desc' => esc_html__( 'Define your typography for feature section.', 'impeka' ),
				'icon_class' => 'el-icon-large',
				'icon' => 'el-icon-font',
				'submenu' => true,
				'customizer' => false,
				'subsection' => true,
				'fields' => array(
					array(
						'id'   => 'info_feature_typography',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Feature Section Typography', 'impeka' ),
					),
					array(
						'id' => 'feature_subheading_font',
						'type' => 'typography',
						'title' => esc_html__( 'Sub Heading', 'impeka' ),
						'subtitle' => esc_html__( 'Specify the font for the sub-heading in the feature section.', 'impeka' ),
						'google' => $is_google,
						'line-height' => true,
						'text-align' => false,
						'letter-spacing' => true,
						'color'=> false,
						'preview'=> true,
						'text-transform' => true,
						'default' => array(
							'font-family' => 'Jost',
							'font-size' => '12px',
							'line-height' => '16px',
							'font-weight' => '600',
							'text-transform' => 'uppercase',
							'letter-spacing' => '1px',
						),
						'fonts' => $std_fonts,
					),
					array(
						'id' => 'feature_title_font',
						'type' => 'typography',
						'title' => esc_html__( 'Title', 'impeka' ),
						'subtitle' => esc_html__( 'Specify the font for the title in the feature section.', 'impeka' ),
						'google' => $is_google,
						'line-height' => true,
						'text-align' => false,
						'letter-spacing' => true,
						'color'=> false,
						'preview'=> true,
						'text-transform' => true,
						'default' => array(
							'font-family' => 'Jost',
							'text-transform' => 'none',
							'font-weight' => '600',
							'font-size' => '84px',
							'line-height' => '96px',
							'letter-spacing' => '',
						),
						'fonts' => $std_fonts,
					),
					array(
						'id' => 'feature_desc_font',
						'type' => 'typography',
						'title' => esc_html__( 'Description', 'impeka' ),
						'subtitle' => esc_html__( 'Specify the font for the  description in the feature section.', 'impeka' ),
						'google' => $is_google,
						'line-height' => true,
						'text-align' => false,
						'letter-spacing' => true,
						'color'=> false,
						'preview'=> true,
						'text-transform' => true,
						'default' => array(
							'font-family' => 'Jost',
							'font-size' => '24px',
							'line-height' => '40px',
							'font-weight' => '400',
							'text-transform' => 'none',
							'letter-spacing' => '',
						),
						'fonts' => $std_fonts,
					),
				)
			);

			$this->sections[] = array(
				'title' => esc_html__( 'Extras', 'impeka' ),
				'id' => 'grve_redux_section_typography_extras',
				'header' => '',
				'desc' => esc_html__( 'Define your typography for extra fields ( widgets, special texts, custom fonts .etc ).', 'impeka' ),
				'icon_class' => 'el-icon-large',
				'icon' => 'el-icon-font',
				'submenu' => true,
				'customizer' => false,
				'subsection' => true,
				'fields' => array(
					array(
						'id'   => 'intro_typography',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Theme Intro Typography', 'impeka' ),
					),
					array(
						'id' => 'intro_first_title',
						'type' => 'typography',
						'title' => esc_html__( 'Intro First Title', 'impeka' ),
						'subtitle' => esc_html__( 'Specify the style for the first title.', 'impeka' ),
						'google' => $is_google,
						'line-height' => true,
						'text-align' => false,
						'letter-spacing' => true,
						'color'=> false,
						'preview'=> true,
						'text-transform' => true,
						'default' => array(
							'font-family' => 'Jost',
							'font-size' => '72px',
							'line-height' => '80px',
							'font-weight' => '600',
							'text-transform' => 'none',
							'letter-spacing' => '',
						),
						'fonts' => $std_fonts,
					),
					array(
						'id' => 'intro_second_title',
						'type' => 'typography',
						'title' => esc_html__( 'Intro Second Title', 'impeka' ),
						'subtitle' => esc_html__( 'Specify the style for the second title.', 'impeka' ),
						'google' => $is_google,
						'line-height' => true,
						'text-align' => false,
						'letter-spacing' => true,
						'color'=> false,
						'preview'=> true,
						'text-transform' => true,
						'default' => array(
							'font-family' => 'Jost',
							'font-size' => '42px',
							'line-height' => '54px',
							'font-weight' => '400',
							'text-transform' => 'none',
							'letter-spacing' => '',
						),
						'fonts' => $std_fonts,
					),
					array(
						'id'   => 'widgets_typography',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Widgets Typography', 'impeka' ),
					),
					array(
						'id' => 'widget_title',
						'type' => 'typography',
						'title' => esc_html__( 'Widgets Title', 'impeka' ),
						'subtitle' => esc_html__( 'Specify the style for the widget titles.', 'impeka' ),
						'google' => $is_google,
						'line-height' => true,
						'text-align' => false,
						'letter-spacing' => true,
						'color'=> false,
						'preview'=> true,
						'text-transform' => true,
						'default' => array(
							'font-family' => 'Jost',
							'font-size' => '24px',
							'line-height' => '32px',
							'font-weight' => '600',
							'text-transform' => 'none',
							'letter-spacing' => '',
						),
						'fonts' => $std_fonts,
					),
					array(
						'id' => 'widget_text',
						'type' => 'typography',
						'title' => esc_html__( 'Widgets Text', 'impeka' ),
						'subtitle' => esc_html__( 'Specify the style for the widget texts.', 'impeka' ),
						'google' => $is_google,
						'line-height' => true,
						'text-align' => false,
						'letter-spacing' => true,
						'color'=> false,
						'preview'=> true,
						'text-transform' => true,
						'default' => array(
							'font-family' => 'Jost',
							'font-size' => '14px',
							'line-height' => '24px',
							'font-weight' => '400',
							'text-transform' => 'none',
							'letter-spacing' => '',
						),
						'fonts' => $std_fonts,
					),
					array(
						'id'   => 'info_special_typography',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Special Text Typography', 'impeka' ),
					),
					array(
						'id' => 'button_text',
						'type' => 'typography',
						'title' => esc_html__( 'Button Text', 'impeka' ),
						'subtitle' => esc_html__( 'Specify the style for the button text.', 'impeka' ),
						'google' => $is_google,
						'line-height' => false,
						'text-align' => false,
						'letter-spacing' => true,
						'color'=> false,
						'preview'=> true,
						'text-transform' => true,
						'default' => array(
							'font-family' => 'Jost',
							'font-size' => '14px',
							'font-weight' => '500',
							'text-transform' => 'none',
							'letter-spacing' => '',
						),
						'fonts' => $std_fonts,
					),
					array(
						'id' => 'quote_text',
						'type' => 'typography',
						'title' => esc_html__( 'Quote Text', 'impeka' ),
						'subtitle' => esc_html__( 'Specify the style for the quote text.', 'impeka' ),
						'google' => $is_google,
						'line-height' => true,
						'text-align' => false,
						'letter-spacing' => true,
						'color'=> false,
						'preview'=> true,
						'text-transform' => true,
						'default' => array(
							'font-family' => 'Jost',
							'font-size' => '24px',
							'line-height' => '36px',
							'font-weight' => '400',
							'text-transform' => 'none',
							'letter-spacing' => '',
						),
						'fonts' => $std_fonts,
					),
					array(
						'id' => 'leader_text',
						'type' => 'typography',
						'title' => esc_html__( 'Leader Text', 'impeka' ),
						'subtitle' => esc_html__( 'Specify the style for the leader text. This is used in various elements (Text block, Testimonial...)', 'impeka' ),
						'google' => $is_google,
						'line-height' => true,
						'text-align' => false,
						'letter-spacing' => true,
						'color'=> false,
						'preview'=> true,
						'text-transform' => true,
						'default' => array(
							'font-family' => 'Jost',
							'font-size' => '24px',
							'line-height' => '40px',
							'font-weight' => '400',
							'text-transform' => 'none',
							'letter-spacing' => '',
						),
						'fonts' => $std_fonts,
					),
					array(
						'id' => 'subtitle_text',
						'type' => 'typography',
						'title' => esc_html__( 'Subtitle Text', 'impeka' ),
						'subtitle' => esc_html__( 'Specify the style for the subtitle text. This is used in various elements (Slogan Subtitle...)', 'impeka' ),
						'google' => $is_google,
						'line-height' => true,
						'text-align' => false,
						'letter-spacing' => true,
						'color'=> false,
						'preview'=> true,
						'text-transform' => true,
						'default' => array(
							'font-family' => 'Jost',
							'font-size' => '12px',
							'line-height' => '24px',
							'font-weight' => '500',
							'text-transform' => 'uppercase',
							'letter-spacing' => '1.5px',
						),
						'fonts' => $std_fonts,
					),
					array(
						'id' => 'small_text',
						'type' => 'typography',
						'title' => esc_html__( 'Small Text', 'impeka' ),
						'subtitle' => esc_html__( 'Specify the style for the small text. This is used in various elements (Tags, Post Meta...)', 'impeka' ),
						'google' => $is_google,
						'line-height' => false,
						'text-align' => false,
						'letter-spacing' => true,
						'color'=> false,
						'preview'=> true,
						'text-transform' => true,
						'default' => array(
							'font-family' => 'Jost',
							'font-size' => '14px',
							'font-weight' => '400',
							'text-transform' => 'none',
							'letter-spacing' => '',
						),
						'fonts' => $std_fonts,
					),
					array(
						'id' => 'link_text',
						'type' => 'typography',
						'title' => esc_html__( 'Link Text', 'impeka' ),
						'subtitle' => esc_html__( 'Specify the style for the link text.', 'impeka' ),
						'google' => $is_google,
						'line-height' => false,
						'text-align' => false,
						'letter-spacing' => true,
						'color'=> false,
						'preview'=> true,
						'text-transform' => true,
						'default' => array(
							'font-family' => 'Jost',
							'font-size' => '14px',
							'font-weight' => '500',
							'text-transform' => 'capitalize',
							'letter-spacing' => '',
						),
						'fonts' => $std_fonts,
					),
					array(
						'id' => 'pagination_text',
						'type' => 'typography',
						'title' => esc_html__( 'Pagination Text', 'impeka' ),
						'subtitle' => esc_html__( 'Specify the pagination font.', 'impeka' ),
						'google' => $is_google,
						'line-height' => true,
						'text-align' => false,
						'letter-spacing' => true,
						'color'=> false,
						'preview'=> true,
						'text-transform' => true,
						'default' => array(
							'font-family' => 'Jost',
							'text-transform' => 'none',
							'font-weight' => '600',
							'font-size' => '16px',
							'line-height' => '24px',
							'letter-spacing' => '',
						),
						'fonts' => $std_fonts,
					),
					array(
						'id'   => 'info_custom_font_family',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Custom Font Family', 'impeka' ),
					),
					array(
						'id' => 'custom_font_family_1',
						'type' => 'typography',
						'title' => esc_html__( 'Custom Font Family 1', 'impeka' ),
						'subtitle' => esc_html__( 'This is used in various elements (Title, Slogan, Callout...)', 'impeka' ),
						'google' => $is_google,
						'line-height' => false,
						'text-align' => false,
						'letter-spacing' => true,
						'font-size' => false,
						'color'=> false,
						'preview'=> true,
						'text-transform' => true,
						'default' => array(
							'text-transform' => 'none',
						),
						'fonts' => $std_fonts,
					),
					array(
						'id' => 'custom_font_family_2',
						'type' => 'typography',
						'title' => esc_html__( 'Custom Font Family 2', 'impeka' ),
						'subtitle' => esc_html__( 'This is used in various elements (Title, Slogan, Callout...)', 'impeka' ),
						'google' => $is_google,
						'line-height' => false,
						'text-align' => false,
						'letter-spacing' => true,
						'font-size' => false,
						'color'=> false,
						'preview'=> true,
						'text-transform' => true,
						'default' => array(
							'text-transform' => 'none',
						),
						'fonts' => $std_fonts,
					),
					array(
						'id' => 'custom_font_family_3',
						'type' => 'typography',
						'title' => esc_html__( 'Custom Font Family 3', 'impeka' ),
						'subtitle' => esc_html__( 'This is used in various elements (Title, Slogan, Callout...)', 'impeka' ),
						'google' => $is_google,
						'line-height' => false,
						'text-align' => false,
						'letter-spacing' => true,
						'font-size' => false,
						'color'=> false,
						'preview'=> true,
						'text-transform' => true,
						'default' => array(
							'text-transform' => 'none',
						),
						'fonts' => $std_fonts,
					),
					array(
						'id' => 'custom_font_family_4',
						'type' => 'typography',
						'title' => esc_html__( 'Custom Font Family 4', 'impeka' ),
						'subtitle' => esc_html__( 'This is used in various elements (Title, Slogan, Callout...)', 'impeka' ),
						'google' => $is_google,
						'line-height' => false,
						'text-align' => false,
						'letter-spacing' => true,
						'font-size' => false,
						'color'=> false,
						'preview'=> true,
						'text-transform' => true,
						'default' => array(
							'text-transform' => 'none',
						),
						'fonts' => $std_fonts,
					),
				)
			);

			$this->sections[] = array(
				'title' => esc_html__( 'Responsive Typography', 'impeka' ),
				'id' => 'grve_redux_section_responsive_typography',
				'header' => '',
				'desc' => '',
				'icon_class' => 'el-icon-large',
				'icon' => 'el-icon-fontsize',
				'submenu' => true,
				'customizer' => false,
				'fields' => array(),
			);

			$this->sections[] = array(
				'title' => esc_html__( 'Responsive Headings', 'impeka' ),
				'id' => 'grve_redux_section_responsive_typography_headings',
				'header' => '',
				'desc' => esc_html__( 'Define your responsiveness for the Typography Headings ( H1-H6 ).', 'impeka' ),
				'submenu' => true,
				'icon_class' => 'el-icon-large',
				'icon' => 'el-icon-fontsize',
				'customizer' => false,
				'subsection' => true,
				'fields' => array(
					array(
						'id'   => 'info_typography_small_desktop_headings',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Small Desktop', 'impeka' ),
						'subtitle'=> esc_html__( 'Screen (min-width: 1201px) and (max-width: 1440px)', 'impeka' ),
					),
					array(
						'id' => 'typography_small_desktop_threshold_headings',
						'type' => 'text',
						'default' => '20',
						'title' => esc_html__( 'Size Threshold', 'impeka' ),
						'subtitle' => esc_html__( 'Size threshold in px (Default is 20).', 'impeka' ),
						'validate' => 'numeric',
					),
					array(
						'id' => 'typography_small_desktop_ratio_headings',
						'type' => 'select',
						'title' => esc_html__( 'Size Ratio', 'impeka' ),
						'subtitle'=> esc_html__( 'Select percentage of the original size.', 'impeka' ),
						'options' => $ratio_selection,
						'default' => '1',
					),
					array(
						'id'   => 'info_typography_tablet_landscape_headings',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Tablet Landscape', 'impeka' ),
						'subtitle'=> esc_html__( 'Screen (min-width: 960px) and (max-width: 1200px)', 'impeka' ),
					),
					array(
						'id' => 'typography_tablet_landscape_threshold_headings',
						'type' => 'text',
						'default' => '20',
						'title' => esc_html__( 'Size Threshold', 'impeka' ),
						'subtitle' => esc_html__( 'Size threshold in px (Default is 20).', 'impeka' ),
						'validate' => 'numeric',
					),
					array(
						'id' => 'typography_tablet_landscape_ratio_headings',
						'type' => 'select',
						'title' => esc_html__( 'Size Ratio', 'impeka' ),
						'subtitle'=> esc_html__( 'Select percentage of the original size.', 'impeka' ),
						'options' => $ratio_selection,
						'default' => '0.9',
					),
					array(
						'id'   => 'info_typography_tablet_portrait_headings',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Tablet Portrait', 'impeka' ),
						'subtitle'=> esc_html__( 'Screen (min-width: 768px) and (max-width: 959px)', 'impeka' ),
					),
					array(
						'id' => 'typography_tablet_portrait_threshold_headings',
						'type' => 'text',
						'default' => '20',
						'title' => esc_html__( 'Size Threshold', 'impeka' ),
						'subtitle' => esc_html__( 'Size threshold in px (Default is 20).', 'impeka' ),
						'validate' => 'numeric',
					),
					array(
						'id' => 'typography_tablet_portrait_ratio_headings',
						'type' => 'select',
						'title' => esc_html__( 'Size Ratio', 'impeka' ),
						'subtitle'=> esc_html__( 'Select percentage of the original size.', 'impeka' ),
						'options' => $ratio_selection,
						'default' => '0.8',
					),
					array(
						'id'   => 'info_typography_mobile_headings',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Mobile', 'impeka' ),
						'subtitle'=> esc_html__( 'Screen (max-width: 767px)', 'impeka' ),
					),
					array(
						'id' => 'typography_mobile_threshold_headings',
						'type' => 'text',
						'default' => '20',
						'title' => esc_html__( 'Size Threshold', 'impeka' ),
						'subtitle' => esc_html__( 'Size threshold in px (Default is 20).', 'impeka' ),
						'validate' => 'numeric',
					),
					array(
						'id' => 'typography_mobile_ratio_headings',
						'type' => 'select',
						'title' => esc_html__( 'Size Ratio', 'impeka' ),
						'subtitle'=> esc_html__( 'Select percentage of the original size.', 'impeka' ),
						'options' => $ratio_selection,
						'default' => '0.7',
					),
				),
			);

			$this->sections[] = array(
				'title' => esc_html__( 'Responsive First Group', 'impeka' ),
				'id' => 'grve_redux_section_responsive_typography_first_group',
				'header' => '',
				'desc' => esc_html__( 'Define your responsiveness Typography for the following elements: Page Title, Post Title, Portfolio Title, Product Title, Feature Section Title, Feature Section Description with Fullscreen mode.', 'impeka' ),
				'submenu' => true,
				'icon_class' => 'el-icon-large',
				'icon' => 'el-icon-fontsize',
				'customizer' => false,
				'subsection' => true,
				'fields' => array(
					array(
						'id'   => 'info_typography_small_desktop',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Small Desktop', 'impeka' ),
						'subtitle'=> esc_html__( 'Screen (min-width: 1201px) and (max-width: 1440px)', 'impeka' ),
					),
					array(
						'id' => 'typography_small_desktop_threshold',
						'type' => 'text',
						'default' => '20',
						'title' => esc_html__( 'Size Threshold', 'impeka' ),
						'subtitle' => esc_html__( 'Size threshold in px (Default is 20).', 'impeka' ),
						'validate' => 'numeric',
					),
					array(
						'id' => 'typography_small_desktop_ratio',
						'type' => 'select',
						'title' => esc_html__( 'Size Ratio', 'impeka' ),
						'subtitle'=> esc_html__( 'Select percentage of the original size.', 'impeka' ),
						'options' => $ratio_selection,
						'default' => '1',
					),
					array(
						'id'   => 'info_typography_tablet_landscape',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Tablet Landscape', 'impeka' ),
						'subtitle'=> esc_html__( 'Screen (min-width: 960px) and (max-width: 1200px)', 'impeka' ),
					),
					array(
						'id' => 'typography_tablet_landscape_threshold',
						'type' => 'text',
						'default' => '20',
						'title' => esc_html__( 'Size Threshold', 'impeka' ),
						'subtitle' => esc_html__( 'Size threshold in px (Default is 20).', 'impeka' ),
						'validate' => 'numeric',
					),
					array(
						'id' => 'typography_tablet_landscape_ratio',
						'type' => 'select',
						'title' => esc_html__( 'Size Ratio', 'impeka' ),
						'subtitle'=> esc_html__( 'Select percentage of the original size.', 'impeka' ),
						'options' => $ratio_selection,
						'default' => '0.9',
					),
					array(
						'id'   => 'info_typography_tablet_portrait',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Tablet Portrait', 'impeka' ),
						'subtitle'=> esc_html__( 'Screen (min-width: 768px) and (max-width: 959px)', 'impeka' ),
					),
					array(
						'id' => 'typography_tablet_portrait_threshold',
						'type' => 'text',
						'default' => '20',
						'title' => esc_html__( 'Size Threshold', 'impeka' ),
						'subtitle' => esc_html__( 'Size threshold in px (Default is 20).', 'impeka' ),
						'validate' => 'numeric',
					),
					array(
						'id' => 'typography_tablet_portrait_ratio',
						'type' => 'select',
						'title' => esc_html__( 'Size Ratio', 'impeka' ),
						'subtitle'=> esc_html__( 'Select percentage of the original size.', 'impeka' ),
						'options' => $ratio_selection,
						'default' => '0.85',
					),
					array(
						'id'   => 'info_typography_mobile',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Mobile', 'impeka' ),
						'subtitle'=> esc_html__( 'Screen (max-width: 767px)', 'impeka' ),
					),
					array(
						'id' => 'typography_mobile_threshold',
						'type' => 'text',
						'default' => '18',
						'title' => esc_html__( 'Size Threshold', 'impeka' ),
						'subtitle' => esc_html__( 'Size threshold in px (Default is 18).', 'impeka' ),
						'validate' => 'numeric',
					),
					array(
						'id' => 'typography_mobile_ratio',
						'type' => 'select',
						'title' => esc_html__( 'Size Ratio', 'impeka' ),
						'subtitle'=> esc_html__( 'Select percentage of the original size.', 'impeka' ),
						'options' => $ratio_selection,
						'default' => '0.6',
					),
				),
			);

			$this->sections[] = array(
				'title' => esc_html__( 'Responsive Second Group', 'impeka' ),
				'id' => 'grve_redux_section_responsive_typography_second_group',
				'header' => '',
				'desc' => esc_html__( 'Define your responsiveness Typography for the following elements: Page Description, Post Description, Portfolio Description, Product Description, Feature Section Description with Custom Height, Leader Text, Subtitle Text, Link Texts, Menus and Buttons.', 'impeka' ),
				'submenu' => true,
				'icon_class' => 'el-icon-large',
				'icon' => 'el-icon-fontsize',
				'customizer' => false,
				'subsection' => true,
				'fields' => array(
					array(
						'id'   => 'info_typography_small_desktop2',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Small Desktop', 'impeka' ),
						'subtitle'=> esc_html__( 'Screen (min-width: 1201px) and (max-width: 1440px)', 'impeka' ),
					),
					array(
						'id' => 'typography_small_desktop_threshold2',
						'type' => 'text',
						'default' => '14',
						'title' => esc_html__( 'Size Threshold', 'impeka' ),
						'subtitle' => esc_html__( 'Size threshold in px (Default is 14).', 'impeka' ),
						'validate' => 'numeric',
					),
					array(
						'id' => 'typography_small_desktop_ratio2',
						'type' => 'select',
						'title' => esc_html__( 'Size Ratio', 'impeka' ),
						'subtitle'=> esc_html__( 'Select percentage of the original size.', 'impeka' ),
						'options' => $ratio_selection,
						'default' => '1',
					),
					array(
						'id'   => 'info_typography_tablet_landscape2',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Tablet Landscape', 'impeka' ),
						'subtitle'=> esc_html__( 'Screen (min-width: 960px) and (max-width: 1200px)', 'impeka' ),
					),
					array(
						'id' => 'typography_tablet_landscape_threshold2',
						'type' => 'text',
						'default' => '14',
						'title' => esc_html__( 'Size Threshold', 'impeka' ),
						'subtitle' => esc_html__( 'Size threshold in px (Default is 14).', 'impeka' ),
						'validate' => 'numeric',
					),
					array(
						'id' => 'typography_tablet_landscape_ratio2',
						'type' => 'select',
						'title' => esc_html__( 'Size Ratio', 'impeka' ),
						'subtitle'=> esc_html__( 'Select percentage of the original size.', 'impeka' ),
						'options' => $ratio_selection,
						'default' => '0.9',
					),
					array(
						'id'   => 'info_typography_tablet_portrait2',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Tablet Portrait', 'impeka' ),
						'subtitle'=> esc_html__( 'Screen (min-width: 768px) and (max-width: 959px)', 'impeka' ),
					),
					array(
						'id' => 'typography_tablet_portrait_threshold2',
						'type' => 'text',
						'default' => '14',
						'title' => esc_html__( 'Size Threshold', 'impeka' ),
						'subtitle' => esc_html__( 'Size threshold in px (Default is 14).', 'impeka' ),
						'validate' => 'numeric',
					),
					array(
						'id' => 'typography_tablet_portrait_ratio2',
						'type' => 'select',
						'title' => esc_html__( 'Size Ratio', 'impeka' ),
						'subtitle'=> esc_html__( 'Select percentage of the original size.', 'impeka' ),
						'options' => $ratio_selection,
						'default' => '0.8',
					),
					array(
						'id'   => 'info_typography_mobile2',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Mobile', 'impeka' ),
						'subtitle'=> esc_html__( 'Screen (max-width: 767px)', 'impeka' ),
					),
					array(
						'id' => 'typography_mobile_threshold2',
						'type' => 'text',
						'default' => '13',
						'title' => esc_html__( 'Size Threshold', 'impeka' ),
						'subtitle' => esc_html__( 'Size threshold in px (Default is 13).', 'impeka' ),
						'validate' => 'numeric',
					),
					array(
						'id' => 'typography_mobile_ratio2',
						'type' => 'select',
						'title' => esc_html__( 'Size Ratio', 'impeka' ),
						'subtitle'=> esc_html__( 'Select percentage of the original size.', 'impeka' ),
						'options' => $ratio_selection,
						'default' => '0.8',
					),
				),
			);

			$this->sections[] = array(
				'icon' => 'el-icon-cloud',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( 'Social Media', 'impeka' ),
				'id' => 'grve_redux_section_social_media',
				'submenu' => true,
				'customizer' => false,
				'fields' => array(
					array(
						'id' => 'social_options',
						'type' => 'sortable',
						'title' => esc_html__( 'Social URLs', 'impeka' ),
						'subtitle' => esc_html__( 'Define and reorder your social URLs. Clear the input field for any social link you do not wish to display.', 'impeka' ),
						'desc' => '',
						'label' => true,
						'options' => $social_options,
					),
				)
			);

			$this->sections[] = array(
				'icon' => 'el-icon-cloud',
				'icon_class' => 'el-icon-cog',
				'title' => esc_html__( 'Utilities', 'impeka' ),
				'id' => 'grve_redux_section_utilities',
				'submenu' => true,
				'customizer' => false,
				'fields' => array()
			);
			$this->sections[] = array(
				'icon' => 'el-icon-cogs',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( 'Theme Performance', 'impeka' ),
				'id' => 'grve_redux_section_advanced',
				'submenu' => true,
				'subsection' => true,
				'customizer' => false,
				'fields' => array(
 					array(
						'id'=>'combine_js',
						'type' => 'select',
						'title' => esc_html__( 'Combine Theme Vendor Scripts', 'impeka' ),
						'subtitle'=> esc_html__( 'Select if you want to combine vendor scripts into one file.', 'impeka' ),
						'options' => array(
							'1' => esc_html__( 'Merge vendor script files into one file', 'impeka' ),
							'0' => esc_html__( 'Use vendor scripts as separate files', 'impeka' ),
						),
						"default" => '1',
					),
					array(
						'id'=>'minify_assets',
						'type' => 'select',
						'title' => esc_html__( 'Minify Theme stylesheet/javascript assets', 'impeka' ),
						'subtitle'=> esc_html__( 'Select if you want to compress/uncompress theme assets (for debuggin purposes).', 'impeka' ),
						'options' => array(
							'1' => esc_html__( 'Compress theme css/js files', 'impeka' ),
							'0' => esc_html__( 'Uncompress theme css/js files', 'impeka' ),
						),
						"default" => '1',
					),
					array(
						'id'=>'print_emoji',
						'type' => 'switch',
						'title' => esc_html__( 'Print emoji stylesheet/javascript assets', 'impeka' ),
						'subtitle'=> esc_html__( 'Switch this option to Off if you don\'t use emojis.', 'impeka' ),
						"default" => '1',
					),
					array(
						'id'=>'css_generation',
						'type' => 'switch',
						'title' => esc_html__( 'Generate Theme Options dynamic css in a file', 'impeka' ),
						'subtitle'=> esc_html__( 'Switch this option to On to save dynamic css in a file.', 'impeka' ),
						"default" => '0',
					),
				)
			);

			$this->sections[] = array(
				'icon' => 'el-icon-search',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( 'Search Options', 'impeka'),
				'id' => 'grve_redux_section_search_page_options',
				'subtitle' => esc_html__( 'You can find the basic settings for the search page here.', 'impeka' ),
				'desc' => esc_html__( 'You can find the basic settings for the search page here.', 'impeka' ),
				'submenu' => true,
				'subsection' => true,
				'customizer' => false,
				'fields' => array(
					array(
						'id' => 'search_page_layout',
						'type' => 'image_select',
						'compiler' => true,
						'title' => esc_html__( 'Search Page Layout', 'impeka' ),
						'subtitle' => esc_html__( 'Select the layout for the search page. Choose among Full Width, Left Sidebar or Right Sidebar.', 'impeka' ),
						'options' => $layout_selection,
						'default' => 'none',
					),
					array(
						'id' => 'search_page_sidebar',
						'type' => 'select',
						'title' => esc_html__( 'Search Page Sidebar', 'impeka' ),
						'subtitle' => esc_html__( 'Select the sidebar for the search page.', 'impeka' ),
						'data' => 'sidebar',
						'default' => 'grve-default-sidebar',
					),
					array(
						'id' => 'search_page_fixed_sidebar',
						'type' => 'select',
						'title' => esc_html__( 'Search Page Fixed Sidebar', 'impeka' ),
						'subtitle'=> esc_html__( 'Select if you want a fixed sidebar.', 'impeka' ),
						'options' => $enable_selection,
						'default' => 'no',
					),
					array(
						'id'   => 'info_style_search_page_header',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Search Page Header Settings', 'impeka' ),
						'subtitle'=> esc_html__( 'Set the style for the search page header.', 'impeka' ),
					),
					array(
						'id' => 'search_page_header_skin',
						'type' => 'select',
						'title' => esc_html__( 'Page Header Skin', 'impeka' ),
						'subtitle'=> esc_html__( 'Select your page header skin.', 'impeka' ),
						'options' => $header_skin,
						'default' => 'default',
					),
					array(
						'id' => 'search_page_header_overlapping',
						'type' => 'select',
						'title' => esc_html__( 'Page Header Overlapping', 'impeka' ),
						'subtitle'=> esc_html__( 'Select if you want the Page Header overlaps the content. Combine this option with the Light or Dark Header.', 'impeka' ),
						'options' => $enable_selection,
						'default' => 'no',
					),
					array(
						'id'   => 'info_style_search_page_title',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Search Page Title Settings', 'impeka' ),
						'subtitle'=> esc_html__( 'Set the style for the search page title.', 'impeka' ),
					),
					array(
						'id' => 'search_page_title_height',
						'type' => 'select',
						'default' => 'small',
						'title' => esc_html__( 'Height', 'impeka' ),
						'subtitle' => esc_html__( 'Enter page title height.', 'impeka' ),
						'options' => $area_height,
						'validate' => 'not_empty',
					),
					array(
						'id' => 'search_page_title_min_height',
						'type' => 'text',
						'default' => '200',
						'title' => esc_html__( 'Minimum Height', 'impeka' ),
						'subtitle' => esc_html__( 'Enter page title minimum height in px (Default is 200).', 'impeka' ),
						'validate' => 'numeric',
					),
					array(
						'id' => 'search_page_title_container_size',
						'type' => 'select',
						'title' => esc_html__( 'Container Size', 'impeka' ),
						'subtitle'=> esc_html__( 'Select the size of the container.', 'impeka' ),
						'options' => $container_size_selection,
						'default' => 'default',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'search_page_title_content_size',
						'type' => 'select',
						'title' => esc_html__( 'Content Size', 'impeka' ),
						'subtitle'=> esc_html__( 'Select the size of the content.', 'impeka' ),
						'options' => $content_size_selection,
						'default' => 'container',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'search_page_title_content_alignment',
						'type' => 'image_select',
						'title' => esc_html__( 'Content Alignment', 'impeka' ),
						'subtitle'=> esc_html__( 'Select the alignment of the content.', 'impeka' ),
						'options' => $align_title,
						'default' => 'center',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'search_page_title_content_position',
						'type' => 'image_select',
						'title' => esc_html__( 'Content Position', 'impeka' ),
						'subtitle'=> esc_html__( 'Select your position for the search page title/description.', 'impeka' ),
						'options' => $align_position,
						'class' => 'small-image-selector',
						'default' => 'center-center',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'search_page_title_content_animation',
						'type' => 'select',
						'title' => esc_html__( 'Content Animation', 'impeka' ),
						'subtitle'=> esc_html__( 'Select your animation for the search page title/description.', 'impeka' ),
						'options' => $animation_selection,
						'default' => 'none',
						'validate' => 'not_empty',
					),
					array(
						'id'       => 'search_page_title_bg_mode',
						'type'     => 'select',
						'title' => esc_html__( 'Background Mode', 'impeka' ),
						'subtitle'=> esc_html__( 'Select the Page Title Background, Color or Image.', 'impeka' ),
						'options' => $title_bg_mode_limited,
						'default'  => 'color',
					),
					array(
						'id'       => 'search_page_title_bg_image',
						'type'     => 'media',
						'title' => esc_html__( 'Background Image', 'impeka' ),
						'subtitle' => esc_html__( 'Select a background image for the search page title.', 'impeka' ),
						'required' => array( 'search_page_title_bg_mode', 'equals', 'custom' ),
					),
					array(
						'id' => 'search_page_title_bg_position',
						'type' => 'select',
						'title' => esc_html__( 'Background Position', 'impeka' ),
						'options' => $align_selection_full,
						'default' => 'center-center',
						'validate' => 'not_empty',
						'required' => array( 'search_page_title_bg_mode', '!=', 'color' ),
					),
					array(
						'id' => 'search_page_title_pattern_overlay',
						'type' => 'select',
						'title' => esc_html__( 'Pattern Overlay', 'impeka' ),
						'options' => $pattern_selection,
						'default' => 'none',
						'required' => array( 'search_page_title_bg_mode', '!=', 'color' ),
					),
					array(
						'id' => 'search_page_title_color_overlay',
						'type' => 'select',
						'title' => esc_html__( 'Color Overlay', 'impeka' ),
						'options' => $color_selection,
						'default' => 'black',
						'required' => array( 'search_page_title_bg_mode', '!=', 'color' ),
					),
					array(
						'id' => 'search_page_title_opacity_overlay',
						'type' => 'select',
						'title' => esc_html__( 'Opacity Overlay', 'impeka' ),
						'options' => $opacity_selection,
						'default' => '0',
						'required' => array( 'search_page_title_bg_mode', '!=', 'color' ),
					),
					array(
						'id'   => 'info_style_search_page_settings',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Search Page Style and Basic Search Page Settings', 'impeka' ),
						'subtitle'=> esc_html__( 'Set the style and basic settings for the search page.', 'impeka' ),
					),
					array(
						'id' => 'search_page_mode',
						'type' => 'image_select',
						'title' => esc_html__( 'Search Page Mode', 'impeka' ),
						'subtitle' => esc_html__( 'Select the search page mode', 'impeka' ),
						'options' =>$search_page_mode_selection,
						'default' => 'masonry',
					),
					array(
						'id' => 'search_page_shadow',
						'type' => 'select',
						'class' => 'grve-redux-group',
						'title' => esc_html__( 'Search Page Shadow', 'impeka' ),
						'options' => $shadow_selection,
						'default' => 'none',
					),
					array(
						'id' => 'search_page_radius',
						'type' => 'select',
						'class' => 'grve-redux-group grve-redux-last',
						'title' => esc_html__( 'Search Page Border Radius', 'impeka' ),
						'options' => $border_radius_selection,
						'default' => 'none',
					),
					array(
						'id' => 'search_page_show_image',
						'type' => 'select',
						'title' => esc_html__( 'Show Search Page Featured Image', 'impeka' ),
						'subtitle' => esc_html__( 'If enabled, Featured image is displayed', 'impeka' ),
						'options' => $enable_selection,
						'default' => 'yes',
					),
					array(
						'id' => 'search_image_mode',
						'type' => 'select',
						'title' => esc_html__( 'Search Grid Image Size', 'impeka' ),
						'subtitle' => esc_html__( 'Select your Search Grid Image Size', 'impeka' ),
						'options' => $grid_image_mode_selection,
						'default' => 'landscape',
						'required' => array(
							array( 'search_page_mode', '!=', 'masonry' ),
							array( 'search_page_show_image', 'equals', 'yes' ),
						),
					),
					array(
						'id' => 'search_masonry_image_mode',
						'type' => 'select',
						'title' => esc_html__( 'Search Masonry Image Size', 'impeka' ),
						'subtitle' => esc_html__( 'Select your Search Masonry Image Size', 'impeka' ),
						'options' => $masonry_image_mode_selection,
						'default' => 'medium',
						'required' => array(
							array( 'search_page_mode','equals', 'masonry' ),
							array( 'search_page_show_image', 'equals', 'yes' ),
						),
					),
					array(
						'id' => 'search_page_columns_large_screen',
						'type' => 'select',
						'title' => esc_html__( 'Search Page Large Screen Columns', 'impeka' ),
						'subtitle' => esc_html__( 'Select the Search Page Columns on large screen devices', 'impeka' ),
						'options' => $grid_columns_selection,
						'default' => '3',
						'required' => array( 'search_page_mode', '!=', 'small' ),
					),
					array(
						'id' => 'search_page_columns',
						'type' => 'select',
						'title' => esc_html__( 'Search Page Columns', 'impeka' ),
						'subtitle' => esc_html__( 'Select the Search Page Columns', 'impeka' ),
						'options' => $grid_columns_selection,
						'default' => '3',
						'required' => array( 'search_page_mode', '!=', 'small' ),
					),
					array(
						'id' => 'search_page_columns_tablet_landscape',
						'type' => 'select',
						'title' => esc_html__( 'Search Page Tablet Landscape Columns', 'impeka' ),
						'subtitle' => esc_html__( 'Select responsive column on tablet devices, landscape orientation.', 'impeka' ),
						'options' => $grid_columns_selection_tablet,
						'default' => '2',
						'required' => array( 'search_page_mode', '!=', 'small' ),
					),
					array(
						'id' => 'search_page_columns_tablet_portrait',
						'type' => 'select',
						'title' => esc_html__( 'Search Page Tablet Portrait Columns', 'impeka' ),
						'subtitle' => esc_html__( 'Select responsive column on tablet devices, portrait orientation.', 'impeka' ),
						'options' => $grid_columns_selection_tablet,
						'default' => '2',
						'required' => array( 'search_page_mode', '!=', 'small' ),
					),
					array(
						'id' => 'search_page_columns_mobile',
						'type' => 'select',
						'title' => esc_html__( 'Search Page Mobile Columns', 'impeka' ),
						'subtitle' => esc_html__( 'Select responsive column on mobile devices.', 'impeka' ),
						'options' => $grid_columns_selection_mobile,
						'default' => '1',
						'required' => array( 'search_page_mode', '!=', 'small' ),
					),
					array(
						"id" => "search_display_style",
						"type" => "select",
						"title" => esc_html__( "Display Style", "impeka"),
						"subtitle" => esc_html__("Define your pagination style.", "impeka" ),
						"options" => array(
							'pagination' => esc_html__( "Pagination", "impeka" ),
							"load-more" => esc_html__( "Load More", "impeka" ),
							"infinite-scroll" => esc_html__( "Infinite Scroll", "impeka" ),
						),
						'default' => 'pagination',
					),
					array(
						'id' => 'search_load_more_title', //translatable
						'type' => 'text',
						'default' => 'Load More',
						'title' => esc_html__( 'Load More Title', 'impeka' ),
						'subtitle' => esc_html__( 'Title for load more.', 'impeka' ),
						'required' => array( 'search_display_style', 'equals', 'load-more' ),
					),
					array(
						'id' => 'search_page_heading_tag',
						'type' => 'select',
						'title' => esc_html__( 'Search Page Result Title Tag', 'impeka' ),
						'subtitle' => esc_html__( 'Select tag for your search result title.', 'impeka' ),
						'options' => $headings_tag_selection,
						'default' => 'h4',
					),
					array(
						'id' => 'search_page_heading',
						'type' => 'select',
						'title' => esc_html__( 'Search Page Result Title Size', 'impeka' ),
						'subtitle' => esc_html__( 'Select size and typography for your search result title.', 'impeka' ),
						'options' => $headings_selection,
						'default' => 'h4',
					),
					array(
						'id'=>'search_page_excerpt_length',
						'type' => 'text',
						'default' => '30',
						'title' => esc_html__( 'Excerpt Length', 'impeka' ),
						'subtitle' => esc_html__( 'Type how many words you want to display in your post excerpts (Default is 30).', 'impeka' ),
						'validate' => 'numeric',
					),
					array(
						'id' => 'search_page_excerpt_more',
						'type' => 'switch',
						'title' => esc_html__( 'Read More', 'impeka' ),
						'subtitle'=> esc_html__( "Adds a read more button after the excerpt or more quicktag.", 'impeka' ),
						"default" => '1',
					),
					array(
						'id' => 'search_page_excerpt_more_text', //translatable
						'type' => 'text',
						'title' => esc_html__( 'Read More Text', 'impeka' ),
						"default" => 'read more',
						'required' => array(
							array( 'search_page_excerpt_more', 'equals', '1' ),

						),
					),
					array(
						'id' => 'search_page_not_found_text', //translatable
						'type' => 'editor',
						'args' => array ( 'wpautop' => false ),
						'title' => esc_html__( 'Search Page Not Found Content', 'impeka' ),
						'subtitle' => esc_html__( 'Type the content of your search page when no results are found.', 'impeka' ),
						'default' => '<h3 class="grve-align-center grve-subtitle-text">Maybe you should check again your spelling.</h3><h3 class="grve-align-center">This is not the page you are looking for...</h3>',
					),
					array(
						'id'=>'search_modal_results_mode',
						'type' => 'select',
						'title' => esc_html__( 'Search Modal Results Mode', 'impeka' ),
						'subtitle'=> esc_html__( 'Select the search modal results mode', 'impeka' ),
						'options' => array(
							'default' => esc_html__( 'WordPress Default', 'impeka' ),
							'product' => esc_html__( 'Product Only', 'impeka' ),
						),
						'default' => 'default',
					),
					array(
						'id'   => 'info_search_modal',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Search Modal Settings', 'impeka' ),
						'subtitle'=> esc_html__( 'Set the modal settings.', 'impeka' ),
					),
					array(
						'id' => 'search_modal_text', //translatable
						'type' => 'text',
						'title' => esc_html__( 'Search Modal Text', 'impeka' ),
						'subtitle' => esc_html__( 'Type the search text of the modal.', 'impeka' ),
						'default' => 'Start Typing',
					),
					array(
						'id'   => 'info_search_widget',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Search Widget Settings', 'impeka' ),
						'subtitle'=> esc_html__( 'Set the search widget settings.', 'impeka' ),
					),
					array(
						'id'=>'search_widget_results_mode',
						'type' => 'select',
						'title' => esc_html__( 'Search Widget Mode', 'impeka' ),
						'subtitle'=> esc_html__( 'Select the search widget results mode', 'impeka' ),
						'options' => array(
							'default' => esc_html__( 'WordPress Default', 'impeka' ),
							'product' => esc_html__( 'Product Only', 'impeka' ),
						),
						'default' => 'default',
					),
					array(
						'id' => 'search_widget_text', //translatable
						'type' => 'text',
						'title' => esc_html__( 'Search Widget Text', 'impeka' ),
						'subtitle' => esc_html__( 'Type the search text of the widget.', 'impeka' ),
						'default' => 'Search for...',
					),
				)
			);

			$this->sections[] = array(
				'icon' => 'el-icon-map-marker',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( 'Map Options', 'impeka' ),
				'id' => 'grve_redux_section_map_options',
				'submenu' => true,
				'subsection' => true,
				'customizer' => false,
				'fields' => array(
					array(
						'id'=>'map_api_mode',
						'type' => 'button_set',
						'title' => esc_html__( 'Map API', 'impeka' ),
						'subtitle'=> esc_html__( 'Select the map API', 'impeka' ),
						'options' => array(
							'google-maps' => esc_html__( 'Google Maps', 'impeka' ),
							'openstreetmap' => esc_html__( 'OpenStreetMap', 'impeka' ),
						),
						'default' => 'google-maps',
					),
					array(
						'id'=>'map_tile_url',
						'type' => 'text',
						'title' => esc_html__( 'Tile Layer URL', 'impeka' ),
						'subtitle' => esc_html__( 'Define the Tile Layer. Used to load and display tile layers on the map.', 'impeka' ),
						'desc' => sprintf( '%1$s: <a href="//wiki.openstreetmap.org/wiki/Tile_servers" target="_blank" rel="noopener noreferrer"> %2$s </a>', esc_html__('See more tile servers', 'impeka'), esc_html__('here', 'impeka') ),
						"default" => 'https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png',
						'required' => array( 'map_api_mode', 'equals', 'openstreetmap' ),
					),
					array(
						'id'=>'map_tile_url_subdomains',
						'type' => 'text',
						'title' => esc_html__( 'Tile Layer Subdomains', 'impeka' ),
						'subtitle'=> esc_html__( 'Define the Tile Layer subdomains.', 'impeka' ),
						"default" => "abc",
						'required' => array( 'map_api_mode', 'equals', 'openstreetmap' ),
					),
					array(
						'id'=>'map_tile_attribution',
						'type' => 'text',
						'title' => esc_html__( 'Tile Layer Attribution', 'impeka' ),
						'subtitle' => esc_html__( 'Enter the Tile Layer attribution', 'impeka' ),
						"default" => '&copy; <a href="//www.openstreetmap.org/copyright">OpenStreetMap</a>',
						'required' => array( 'map_api_mode', 'equals', 'openstreetmap' ),
					),
					array(
						'id'       => 'gmap_api_key',
						'type'     => 'text',
						'title'    => esc_html__( 'Google API Key', 'impeka' ),
						'subtitle' => $gmap_api_key_link,
						'default'  => '',
						'required' => array( 'map_api_mode', 'equals', 'google-maps' ),
					),
					array(
						'id'=>'gmap_custom_enabled',
						'type' => 'button_set',
						'title' => esc_html__( 'Enable Custom Style', 'impeka' ),
						'subtitle'=> esc_html__( 'Select if you want to enable custom style for your map.', 'impeka' ),
						'options' => array(
							'0' => esc_html__( 'No', 'impeka' ),
							'1' => esc_html__( 'Custom', 'impeka' ),
							'2' => esc_html__( 'Custom Code', 'impeka' ),
						),
						'default' => '0',
						'required' => array( 'map_api_mode', 'equals', 'google-maps' ),
					),
					array(
						'id' => 'gmap_custom_code',
						'type' => 'textarea',
						'title' => esc_html__( 'Custom Code', 'impeka' ),
						'subtitle' => esc_html__( 'Copy and paste the JSON here.', 'impeka' ) . $gmap_style_link,
						'default' => '',
						'rows' => '30',
						'required' => array( 'gmap_custom_enabled', 'equals', '2' ),
					),
					array(
						'id'       => 'gmap_water_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Water color', 'impeka' ),
						'subtitle' => esc_html__( 'Pick a color for water', 'impeka' ),
						'default'  => '#424242',
						'transparent' => false,
						'validate' => 'color',
						'required' => array( 'gmap_custom_enabled', 'equals', '1' ),
					),
					array(
						'id'       => 'gmap_landscape_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Landscape color', 'impeka' ),
						'subtitle' => esc_html__( 'Pick a color for landscape', 'impeka' ),
						'default'  => '#232323',
						'transparent' => false,
						'validate' => 'color',
						'required' => array( 'gmap_custom_enabled', 'equals', '1' ),
					),
					array(
						'id'       => 'gmap_poi_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Point of interest color', 'impeka' ),
						'subtitle' => esc_html__( 'Pick a color for point of interest', 'impeka' ),
						'default'  => '#232323',
						'transparent' => false,
						'validate' => 'color',
						'required' => array( 'gmap_custom_enabled', 'equals', '1' ),
					),
					array(
						'id'       => 'gmap_road_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Roads color', 'impeka' ),
						'subtitle' => esc_html__( 'Pick a color for roads', 'impeka' ),
						'default'  => '#1a1a1a',
						'transparent' => false,
						'validate' => 'color',
						'required' => array( 'gmap_custom_enabled', 'equals', '1' ),
					),
					array(
						'id' => 'gmap_label_enabled',
						'type' => 'switch',
						'title' => esc_html__( 'Enable Label', 'impeka' ),
						'subtitle'=> esc_html__( 'Select if you want to enable labels for your map.', 'impeka' ),
						'default' => 1,
						'required' => array( 'gmap_custom_enabled', 'equals', '1' ),
					),
					array(
						'id'       => 'gmap_label_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Label color', 'impeka' ),
						'subtitle' => esc_html__( 'Pick a color for labels', 'impeka' ),
						'default'  => '#777777',
						'transparent' => false,
						'validate' => 'color',
						'required' => array( 'gmap_label_enabled', 'equals', '1' ),
					),
					array(
						'id'       => 'gmap_label_stroke_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Label Stroke color', 'impeka' ),
						'subtitle' => esc_html__( 'Pick a stroke color for labels', 'impeka' ),
						'default'  => '#1a1a1a',
						'transparent' => false,
						'validate' => 'color',
						'required' => array( 'gmap_label_enabled', 'equals', '1' ),
					),
					array(
						'id'       => 'gmap_country_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Country Stroke color', 'impeka' ),
						'subtitle' => esc_html__( 'Pick a color for country stroke.', 'impeka' ),
						'default'  => '#000000',
						'transparent' => false,
						'validate' => 'color',
						'required' => array( 'gmap_custom_enabled', 'equals', '1' ),
					),
					array(
						'id' => 'gmap_zoom_enabled',
						'type' => 'switch',
						'title' => esc_html__( 'Enable Zoom Control', 'impeka' ),
						'subtitle'=> esc_html__( 'Select if you want to enable zoom control for your map.', 'impeka' ),
						'default' => 0,
						'required' => array( 'gmap_custom_enabled', 'equals', array( '1', '2' ) ),
					),
					array(
						'id' => 'gmap_type_control',
						'type' => 'switch',
						'title' => esc_html__( 'Enable Map Type Control', 'impeka' ),
						'subtitle'=> esc_html__( 'Select if you want to enable map type control for your map.', 'impeka' ),
						'default' => 0,
						'required' => array( 'map_api_mode', 'equals', 'google-maps' ),
					),
					array(
						'id' => 'gmap_gesture_handling',
						'type' => 'select',
						'title' => esc_html__( 'Gesture Handling', 'impeka' ),
						'subtitle'=> esc_html__( 'Control how the API handles gestures on the map. For mobile web in particular, users may swipe the touchscreen, intending to scroll the page, but change the scale of the map instead.', 'impeka' ),
						'options' => array(
							'greedy' => esc_html__( 'Greedy', 'impeka' ),
							'cooperative' => esc_html__( 'Cooperative', 'impeka' ),
							'none' => esc_html__( 'None', 'impeka' ),
							'auto' => esc_html__( 'Auto', 'impeka' ),
						),
						'default' => 'auto',
						'required' => array( 'map_api_mode', 'equals', 'google-maps' ),
					),
				)
			);

			$this->sections[] = array(
				'icon' => 'el-icon-error',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( '404 Page', 'impeka'),
				'id' => 'grve_redux_section_404',
				'subtitle' => esc_html__( 'You can find the settings for the 404 page here.', 'impeka' ),
				'submenu' => true,
				'subsection' => true,
				'customizer' => false,
				'fields' => array(
					array(
						'id' => 'page_404_header',
						'type' => 'switch',
						'title' => esc_html__( 'Show Header', 'impeka' ),
						'subtitle'=> esc_html__( 'Select if you want to show header.', 'impeka' ),
						'default' => 0,
					),
					array(
						'id' => 'page_404_header_skin',
						'type' => 'select',
						'title' => esc_html__( 'Page 404 Header Skin', 'impeka' ),
						'subtitle'=> esc_html__( 'Select your page header skin.', 'impeka' ),
						'options' => $header_skin,
						'default' => 'default',
						'required' => array( 'page_404_header', 'equals', 1 ),
					),
					array(
						'id' => 'page_404_header_overlapping',
						'type' => 'select',
						'title' => esc_html__( 'Page 404 Header Overlapping', 'impeka' ),
						'subtitle'=> esc_html__( 'Select if you want the Page Header overlaps the content. Combine this option with the Light or Dark Header.', 'impeka' ),
						'options' => $enable_selection,
						'default' => 'no',
						'required' => array( 'page_404_header', 'equals', 1 ),
					),
					array(
						'id'   => 'info_style_page_404_content',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Page 404 Content Settings', 'impeka' ),
						'subtitle'=> esc_html__( 'Set the content for the 404 page.', 'impeka' ),
					),
					array(
						'id'=>'page_404_mode',
						'type' => 'select',
						'title' => esc_html__( 'Page 404 Mode', 'impeka' ),
						'subtitle' => esc_html__( 'Select custom content or use tan area item.', 'impeka' ),
						'options' => array(
							'custom-content' => esc_html__( 'Custom Content', 'impeka' ),
							'area-item' => esc_html__( 'Area Item', 'impeka' ),
						),
						'default' => 'custom-content',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'page_404_area',  //translatable
						'type' => 'select',
						'title' => esc_html__( 'Page 404 Area Item', 'impeka' ),
						'subtitle' => esc_html__( 'Select an area item for your 404 page.', 'impeka' ),
						'data' => 'posts',
						'args' => array( 'post_type' => 'area-item', 'numberposts' => -1 ),
						'default' => '',
						'required' => array( 'page_404_mode', 'equals', 'area-item' ),
					),
					array(
						'id'       => '404_content_background',
						'type'     => 'background',
						'title'    => esc_html__( 'Page 404 Content Background Image / Color', 'impeka' ),
						'subtitle' => esc_html__( 'Select a background image or color for the 404 page.', 'impeka' ),
						'background-color' => true,
						'transparent' => false,
						'background-repeat' => true,
						'background-attachment' => true,
						'background-clip' => false,
						'background-size' => true,
						'default' => array (
							'background-color' => '#ffffff',
						),
						'required' => array( 'page_404_mode', 'equals', 'custom-content' ),
					),
					array(
						'id' => 'page_404_content', //translatable
						'type' => 'editor',
						'args' => array ( 'wpautop' => false ),
						'title' => esc_html__( 'Page 404 Content', 'impeka' ),
						'subtitle' => esc_html__( 'Type the content of your 404 page, you can also use shortcodes.', 'impeka' ),
						'default' => '<h6 class="grve-text-primary-1">404 ERROR</h6><h1>Hey there mate!</h1><h4>Your lost treasure is not found here...</h4><br>',
						'required' => array( 'page_404_mode', 'equals', 'custom-content' ),
					),
					array(
						'id' => 'page_404_search',
						'type' => 'switch',
						'title' => esc_html__( 'Show Search Box', 'impeka' ),
						'subtitle'=> esc_html__( 'Select if you want to show a search box.', 'impeka' ),
						'default' => 0,
						'required' => array( 'page_404_mode', 'equals', 'custom-content' ),
					),
					array(
						'id' => 'page_404_home_button',
						'type' => 'switch',
						'title' => esc_html__( 'Show Back to home Button', 'impeka' ),
						'subtitle'=> esc_html__( 'Select if you want to show a back to home button.', 'impeka' ),
						'default' => 1,
						'required' => array( 'page_404_mode', 'equals', 'custom-content' ),
					),
					array(
						'id' => 'page_404_footer',
						'type' => 'switch',
						'title' => esc_html__( 'Show Footer', 'impeka' ),
						'subtitle'=> esc_html__( 'Select if you want to show footer.', 'impeka' ),
						'default' => 0,
					),
				)
			);


			$this->sections[] = array(
				'icon' => 'el-icon-wrench',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( 'Coming Soon', 'impeka' ),
				'id' => 'grve_redux_section_coming_soon',
				'submenu' => true,
				'subsection' => true,
				'customizer' => false,
				'fields' => array(
					array(
						'id'=>'coming_soon_enabled',
						'type' => 'switch',
						'title' => esc_html__( 'Enable Coming Soon', 'impeka' ),
						'subtitle'=> esc_html__( 'Toggle Coming Soon Redirect on or off.', 'impeka' ),
						"default" => '0',
					),
					array(
						'id'=>'coming_soon_template',
						'type' => 'select',
						'title' => esc_html__( 'Coming Soon Template', 'impeka' ),
						'subtitle' => esc_html__( 'Select content only or use the defined page template.', 'impeka' ),
						'options' => array(
							'content' => esc_html__( 'Content Only', 'impeka' ),
							'template' => esc_html__( 'Use Page Template', 'impeka' ),
						),
						'default' => 'content',
						'validate' => 'not_empty',
						'required' => array( 'coming_soon_enabled', 'equals', '1' ),
					),
					array(
						'id' => 'coming_soon_page',
						'type' => 'select',
						'title' => esc_html__( 'Coming Soon Page', 'impeka' ),
						'subtitle' => esc_html__( 'Select the page for your redirection.', 'impeka' ),
						'data' => 'page',
						'default' => '',
						'required' => array( 'coming_soon_enabled', 'equals', '1' ),
					),

				)
			);

			$this->sections[] = array(
				'icon' => 'el-icon-file-edit',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( 'CSS / JS Options', 'impeka' ),
				'id' => 'grve_redux_section_css_js_options',
				'submenu' => true,
				'subsection' => true,
				'customizer' => false,
				'fields' => array(
					array(
						'id' => 'css_code',
						'type' => 'ace_editor',
						'title' => esc_html__( 'CSS Code', 'impeka' ),
						'subtitle' => esc_html__( 'Paste your CSS code here.', 'impeka' ),
						'mode' => 'css',
						'theme' => 'monokai',
						'options' => array(
							'minLines'=> 12,
							'maxLines' => 60,
						),
						'desc' => '',
						'default' => ''
					),
					array(
						'id' => 'custom_js',
						'type' => 'ace_editor',
						'mode' => 'javascript',
						'theme' => 'chrome',
						'options' => array(
							'minLines'=> 12,
							'maxLines' => 60,
						),
						'title' => esc_html__( 'JS Code', 'impeka' ),
						'subtitle' => esc_html__( 'Add your custom JavaScript code here. Please do not include any script tags.', 'impeka' ),
						'desc' => '',
						'default' => ''
					),
				)
			);

			$this->sections[] = array(
				'icon' => 'el-icon-cog',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( 'Miscellaneous', 'impeka' ),
				'id' => 'grve_redux_section_miscellaneous',
				'submenu' => true,
				'customizer' => false,
				'fields' => array(
					array(
						'id'=>'theme_indicator',
						'type' => 'switch',
						'title' => esc_html__( 'Theme Indicator', 'impeka' ),
						'subtitle'=> esc_html__( 'Enable/Disable the theme Indicator cursor effect.', 'impeka' ),
						"default" => '0',
						'on' => esc_html__('On', 'impeka' ),
						'off' => esc_html__('Off', 'impeka' ),
					),
					array(
						'id' => 'theme_indicator_style',
						'type' => 'select',
						'title' => esc_html__( 'Theme Indicator Style', 'impeka' ),
						'subtitle'=> esc_html__( 'Select the style for your indicator.', 'impeka' ),
						'options' => array(
							'style-1' => esc_html__( 'Style 1', 'impeka' ),
							'style-2' => esc_html__( 'Style 2', 'impeka' ),
						),
						'default' => 'style-1',
						'required' => array( 'theme_indicator', 'equals', '1' ),
					),
					array(
						'id' => 'header_icon_library',
						'type' => 'select',
						'title' => esc_html__( 'Header Icon Library', 'impeka' ),
						'subtitle'=> esc_html__( 'Select the icon library used in Top Bar and Header.', 'impeka' ),
						'options' => array(
							'theme-icons' => esc_html__( 'Theme Icons', 'impeka' ),
							'awesome-fonts' => esc_html__( 'Awesome Fonts', 'impeka' ),
						),
						'default' => 'theme-icons',
						'validate' => 'not_empty',
					),
					array(
						'id'       => 'feature_section_post_types',
						'type'     => 'select',
						'multi'    => true,
						'title'    => esc_html__( 'Feature Section Post Types', 'impeka' ),
						'subtitle' => esc_html__( 'Select the post types you wish to enable the Feature Section.', 'impeka' ),
						'options' => $feature_section_post_types_selection,
						'default' => array( 'page', 'portfolio' ),
					),
					array(
						'id'=>'wp_gallery_popup',
						'type' => 'switch',
						'title' => esc_html__( 'Lightbox for WordPress Gallery', 'impeka' ),
						'subtitle'=> esc_html__( 'Toggle lightbox for native WordPress Gallery on or off.', 'impeka' ),
						"default" => '0',
						'on' => esc_html__('On', 'impeka' ),
						'off' => esc_html__('Off', 'impeka' ),
					),
					array(
						'id'=>'wp_tagcloud',
						'type' => 'switch',
						'title' => esc_html__( 'Default WordPress Tag Cloud', 'impeka' ),
						'subtitle'=> esc_html__( 'Toggle default tag cloud on or off.', 'impeka' ),
						"default" => '1',
						'on' => esc_html__('On', 'impeka' ),
						'off' => esc_html__('Off', 'impeka' ),
					),
					array(
						'id'=>'sidebar_heading_tag',
						'type' => 'select',
						'title' => esc_html__( 'Sidebar Headings Tag', 'impeka' ),
						'subtitle' => esc_html__( 'Select the headings tag for your Sidebar Titles.', 'impeka' ),
						'options' => $headings_tag_selection,
						'default' => 'div',
						'validate' => 'not_empty',
					),
					array(
						'id'=>'footer_heading_tag',
						'type' => 'select',
						'title' => esc_html__( 'Footer Sidebar Headings Tag', 'impeka' ),
						'subtitle' => esc_html__( 'Select the headings tag for your Footer Sidebar Titles.', 'impeka' ),
						'options' => $headings_tag_selection,
						'default' => 'div',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'scrolling_speed',
						'type' => 'select',
						'title' => esc_html__( 'Smooth Scrolling Speed', 'impeka' ),
						'subtitle'=> esc_html__( 'Select the scroll speed. Applied only when smooth scrolling is enabled.', 'impeka' ),
						'options' => array(
							'slow' => esc_html__( 'Slow', 'impeka' ),
							'normal' => esc_html__( 'Normal', 'impeka' ),
							'fast' => esc_html__( 'Fast', 'impeka' ),
							'disabled' => esc_html__( 'Disabled', 'impeka' ),
						),
						'default' => 'normal',
					),
					array(
						'id'=>'device_animations',
						'type' => 'switch',
						'title' => esc_html__( 'Device Animations', 'impeka' ),
						'subtitle'=> esc_html__( 'Enable/Disable animations for mobile devices.', 'impeka' ),
						"default" => '0',
						'on' => esc_html__('On', 'impeka' ),
						'off' => esc_html__('Off', 'impeka' ),
					),
					array(
						'id'=>'device_hover_single_tap',
						'type' => 'switch',
						'title' => esc_html__( 'Device Single Tap', 'impeka' ),
						'subtitle'=> esc_html__( 'Enable/Disable single tap for links/hovers on devices.', 'impeka' ),
						"default" => '0',
						'on' => esc_html__('On', 'impeka' ),
						'off' => esc_html__('Off', 'impeka' ),
					),
				)
			);

			$this->sections[] = array(
				'icon' => 'el-icon-file-edit',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( 'WPML / Polylang Settings', 'impeka' ),
				'desc' => esc_html__( 'Configure Theme related WPML/ Polylang settings.', 'impeka' ),
				'id' => 'grve_redux_section_wpml_polylang',
				'submenu' => true,
				'subsection' => true,
				'customizer' => false,
				'fields' => array(
					array(
						'id'   => 'info_settings_wpml_polylang',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Theme Language Switcher Settings', 'impeka' ),
						'subtitle'=>esc_html__( 'Configure Theme language switcher settings.', 'impeka' ),
					),
					array(
						'id'=>'language_switcher_skip_missing',
						'type' => 'checkbox',
						'title' => esc_html__( 'Hide languages with no translation', 'impeka' ),
						'subtitle'=> esc_html__( 'Select if you want to skip language in case translation is missing.', 'impeka' ),
						"default" => '0',
					),
					array(
						'id' => 'language_switcher_options',
						'type' => 'checkbox',
						'title' => esc_html__( 'Language Switcher Options', 'impeka' ),
						'subtitle' => esc_html__( 'What to include in the language switcher', 'impeka' ),
						'options' =>  array(
							'flag' => esc_html__( 'Flag', 'impeka' ),
							'name' => esc_html__( 'Language name', 'impeka' ),
							'current-lang' => esc_html__( 'Current language', 'impeka' ),
						),
						'default' => array(
							'flag' => true,
							'native-name' => true,
							'current-lang' => true,
						),
					),
				)
			);
			$this->sections[] = array(
				'icon' => 'el-icon-file-edit',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( 'WPBakery Page Builder Addons', 'impeka' ),
				'desc' => esc_html__( 'Enable/Disable default WPBakery Page Builder functionality.', 'impeka' ),
				'id' => 'grve_redux_section_page_builder_addons',
				'submenu' => true,
				'subsection' => true,
				'customizer' => false,
				'fields' => array(
					array(
						'id'=>'vc_grid_visibility',
						'type' => 'switch',
						'title' => esc_html__( 'Page Builder Grid Elements', 'impeka' ),
						'subtitle'=> esc_html__( 'Toggle Page Builder Grid elements on or off.', 'impeka' ),
						"default" => '0',
						'on' => esc_html__('On', 'impeka' ),
						'off' => esc_html__('Off', 'impeka' ),
					),
					array(
						'id'=>'vc_charts_visibility',
						'type' => 'switch',
						'title' => esc_html__( 'Page Builder Charts Elements', 'impeka' ),
						'subtitle'=> esc_html__( 'Toggle Page Builder Charts elements on or off.', 'impeka' ),
						"default" => '0',
						'on' => esc_html__('On', 'impeka' ),
						'off' => esc_html__('Off', 'impeka' ),
					),
					array(
						'id'=>'vc_woo_visibility',
						'type' => 'switch',
						'title' => esc_html__( 'Page Builder WooCommerce Elements', 'impeka' ),
						'subtitle'=> esc_html__( 'Toggle Page Builder WooCommerce elements on or off.', 'impeka' ),
						"default" => '0',
						'on' => esc_html__('On', 'impeka' ),
						'off' => esc_html__('Off', 'impeka' ),
					),
					array(
						'id'=>'vc_auto_updater',
						'type' => 'switch',
						'title' => esc_html__( 'Page Builder Auto Updater', 'impeka' ),
						'subtitle'=> esc_html__( 'Enable/Disable Page Builder Auto Updater ( Activation Required ).', 'impeka' ),
						"default" => '0',
						'on' => esc_html__('On', 'impeka' ),
						'off' => esc_html__('Off', 'impeka' ),
					),
					array(
						'id'=>'vc_content_manager_visibility',
						'type' => 'switch',
						'title' => esc_html__( 'Page Builder Theme Content Manager', 'impeka' ),
						'subtitle'=> esc_html__( 'Enable/Disable Theme Content Manager.', 'impeka' ),
						"default" => '1',
						'on' => esc_html__('On', 'impeka' ),
						'off' => esc_html__('Off', 'impeka' ),
					),
				)
			);

			$this->sections[] = array(
				'icon' => 'el-icon-file-edit',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( 'Button Settings', 'impeka' ),
				'id' => 'grve_redux_section_button_settings',
				'submenu' => true,
				'subsection' => true,
				'customizer' => false,
				'fields' => array(
					array(
						'id'=>'button_type',
						'type' => 'select',
						'title' => esc_html__( 'Button Type', 'impeka' ),
						'subtitle' => esc_html__( 'Select the type of your Buttons.', 'impeka' ),
						'options' => $button_type_selection,
						'default' => 'simple',
						'validate' => 'not_empty',
					),
					array(
						'id'=>'button_shape',
						'type' => 'select',
						'title' => esc_html__( 'Button Shape', 'impeka' ),
						'subtitle' => esc_html__( 'Select the shape of your Buttons.', 'impeka' ),
						'options' => $button_shape_selection,
						'default' => 'square',
						'validate' => 'not_empty',
					),
					array(
						'id'=>'button_color',
						'type' => 'select',
						'title' => esc_html__( 'Button Color', 'impeka' ),
						'subtitle' => esc_html__( 'Select the color of your Buttons.', 'impeka' ),
						'options' => $button_color_selection,
						'default' => 'black',
						'validate' => 'not_empty',
					),
					array(
						'id'=>'button_hover_color',
						'type' => 'select',
						'title' => esc_html__( 'Button Hover Color', 'impeka' ),
						'subtitle' => esc_html__( 'Select the hover color of your Buttons.', 'impeka' ),
						'options' => $button_color_selection,
						'default' => 'primary-1',
						'validate' => 'not_empty',
					),
					array(
						'id'             => 'button_spacing',
						'type'           => 'spacing',
						'mode'           => 'padding',
						'units'          => array('em', 'px', '%'),
						'units_extended' => 'false',
						'bottom'         => 'false',
						'right'          => 'false',
						'title'          => esc_html__( 'Button Spacing', 'impeka' ),
						'subtitle'       => esc_html__( 'Set the spacings of your Buttons.', 'impeka' ),
						'default'        => array(
							'padding-top'  => '1.000em',
							'padding-left' => '1.500em',
							'units'        => 'em',
						),
					),
				)
			);

			$this->sections[] = array(
				'icon' => 'el-icon-cog',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( 'Back to Top', 'impeka' ),
				'id' => 'grve_redux_section_back_top_top',
				'submenu' => true,
				'subsection' => true,
				'customizer' => false,
				'fields' => array(
					array(
						'id'=>'back_to_top_enabled',
						'type' => 'switch',
						'title' => esc_html__( 'Back to Top', 'impeka' ),
						'subtitle'=> esc_html__( 'Enable or Disable the Back to Top button.', 'impeka' ),
						"default" => '1',
					),
					array(
						'id'=>'back_to_top_shape',
						'type' => 'select',
						'title' => esc_html__( 'Back to Top Icon Shape', 'impeka' ),
						'subtitle' => esc_html__( 'Select the shape of Back to Top button.', 'impeka' ),
						'options' => array(
							'none' => esc_html__( 'No Shape', 'impeka' ),
							'square' => esc_html__( 'Square', 'impeka' ),
							'round' => esc_html__( 'Round', 'impeka' ),
							'circle' => esc_html__( 'Circle', 'impeka' ),
						),
						'default' => 'circle',
						'validate' => 'not_empty',
						'required' => array( 'back_to_top_enabled', 'equals', '1' ),
					),
				)
			);

			$this->sections[] = array(
				'icon' => 'el-icon-cog',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( 'Meta Tags', 'impeka' ),
				'desc' => esc_html__( 'Configure your site meta tags.', 'impeka' ),
				'id' => 'grve_redux_section_meta_tags',
				'submenu' => true,
				'customizer' => false,
				'subsection' => true,
				'fields' => array(
					array(
						'id'=>'meta_viewport_responsive',
						'type' => 'switch',
						'title' => esc_html__( 'Responsive Viewport Meta', 'impeka' ),
						'subtitle'=> esc_html__( 'Enable or Disable Responsive Viewport.', 'impeka' ),
						"default" => '1',
					),
					array(
						'id'=>'meta_opengraph',
						'type' => 'switch',
						'title' => esc_html__( 'Open Graph Meta', 'impeka' ),
						'subtitle'=> esc_html__( 'Generate open graph meta tags for social sharing ( e.g: Facebook, Google+, LinkedIn etc )', 'impeka' ),
						"default" => '0',
					),
					array(
						'id'=>'meta_twitter',
						'type' => 'switch',
						'title' => esc_html__( 'Twitter Card Meta', 'impeka' ),
						'subtitle'=> esc_html__( 'Generate meta tags for Twitter', 'impeka' ),
						"default" => '0',
					),
				)
			);

			$this->sections[] = array(
				'icon' => 'el-icon-resize-small',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( 'Media Options', 'impeka' ),
				'submenu' => true,
				'customizer' => false,
				'fields' => array(
					array(
						'id'=>'image_load_mode',
						'type' => 'select',
						'title' => esc_html__( 'Image Load Mode', 'impeka' ),
						'subtitle' => esc_html__( 'Enable Lazy load.', 'impeka' ),
						'options' => array(
							'off' => esc_html__( 'Off', 'impeka' ),
							'native-lazyload' => esc_html__( 'Native Lazyload', 'impeka' ),
							'lazyload' => esc_html__( 'Theme Lazyload', 'impeka' ),
						),
						'default' => 'off',
					),
					array(
						'id'=>'feature_section_bg_size',
						'type' => 'select',
						'title' => esc_html__( 'Feature Section Background Image Size', 'impeka' ),
						'subtitle' => esc_html__( 'Select what background image to show for Feature Sections.', 'impeka' ),
						'options' => array(
							'responsive' => esc_html__( 'Responsive', 'impeka' ),
							'extra-extra-large' => esc_html__( 'Extra Extra Large', 'impeka' ),
							'full' => esc_html__( 'Full', 'impeka' ),
						),
						'default' => 'responsive',
						'validate' => 'not_empty',
					),
					array(
						'id'=>'row_section_bg_size',
						'type' => 'select',
						'title' => esc_html__( 'Row Section Background Image Size', 'impeka' ),
						'subtitle' => esc_html__( 'Select what background image to show for Row Sections.', 'impeka' ),
						'options' => array(
							'responsive' => esc_html__( 'Responsive', 'impeka' ),
							'extra-extra-large' => esc_html__( 'Extra Extra Large', 'impeka' ),
							'full' => esc_html__( 'Full', 'impeka' ),
						),
						'default' => 'responsive',
						'validate' => 'not_empty',
					),
					array(
						'id'=>'placeholder_mode',
						'type' => 'select',
						'title' => esc_html__( 'Placeholder Mode', 'impeka' ),
						'subtitle' => esc_html__( 'Select what images to display as placeholders.', 'impeka' ),
						'options' => array(
							'dummy' => esc_html__( 'Theme Dummy Image', 'impeka' ),
							'custom' => esc_html__( 'User Defined Image', 'impeka' ),
							'unsplash' => esc_html__( 'unsplash', 'impeka' ),
						),
						'default' => 'dummy',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'placeholder_image',
						'type' => 'media',
						'title' => esc_html__( 'Placeholder Image', 'impeka' ),
						'subtitle'=> esc_html__( 'Select your placeholder image.', 'impeka' ),
						'required' => array( 'placeholder_mode', 'equals', 'custom' ),
					),

					array(
						'id'   => 'info_settings_media_sizes',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Media Sizes', 'impeka' ),
						'subtitle' => esc_html__( 'These settings affect the display and dimensions of images in the Theme. After changing these settings you may need to', 'impeka' ) . " "  . $regenerate_link . ".",
					),

					array(
						'id'       => 'size_large_landscape_wide',
						'type'     => 'dimensions',
						'units'    => false,
						'title'    => esc_html__('Landscape Wide Large', 'impeka'),
						'subtitle'=> esc_html__( 'Default 1390x782 - 16:9 ratio (Cropped)', 'impeka' ),
						'default'  => array(
							'width'   => '1390',
							'height'  => '782'
						),
						'validate_callback' => 'impeka_grve_redux_dimensions_validation',
					),
					array(
						'id'       => 'size_small_landscape',
						'type'     => 'dimensions',
						'units'    => false,
						'title'    => esc_html__('Landscape', 'impeka'),
						'subtitle'=> esc_html__( 'Default 560x420 - 4:3 ratio (Cropped)', 'impeka' ),
						'default'  => array(
							'width'   => '560',
							'height'  => '420'
						),
						'validate_callback' => 'impeka_grve_redux_dimensions_validation',
					),
					array(
						'id'       => 'size_small_portrait',
						'type'     => 'dimensions',
						'units'    => false,
						'title'    => esc_html__('Portrait', 'impeka'),
						'subtitle'=> esc_html__( 'Default 560x747 - 3:4 ratio (Cropped)', 'impeka' ),
						'default'  => array(
							'width'   => '560',
							'height'  => '747'
						),
						'validate_callback' => 'impeka_grve_redux_dimensions_validation',
					),
					array(
						'id'       => 'size_small_square',
						'type'     => 'dimensions',
						'units'    => false,
						'title'    => esc_html__('Square', 'impeka'),
						'subtitle'=> esc_html__( 'Default 560x560 - 1:1 ratio (Cropped)', 'impeka' ),
						'default'  => array(
							'width'   => '560',
							'height'  => '560'
						),
						'validate_callback' => 'impeka_grve_redux_dimensions_validation',
					),
					array(
						'id'       => 'size_medium_landscape',
						'type'     => 'dimensions',
						'units'    => false,
						'title'    => esc_html__('Landscape Large', 'impeka'),
						'subtitle'=> esc_html__( 'Default 900x675 - 4:3 ratio (Cropped)', 'impeka' ),
						'default'  => array(
							'width'   => '900',
							'height'  => '675'
						),
						'validate_callback' => 'impeka_grve_redux_dimensions_validation',
					),
					array(
						'id'       => 'size_medium_portrait',
						'type'     => 'dimensions',
						'units'    => false,
						'title'    => esc_html__('Portrait Large', 'impeka'),
						'subtitle'=> esc_html__( 'Default 840x1120 - 3:4 ratio (Cropped)', 'impeka' ),
						'default'  => array(
							'width'   => '840',
							'height'  => '1120'
						),
						'validate_callback' => 'impeka_grve_redux_dimensions_validation',
					),
					array(
						'id'       => 'size_medium_square',
						'type'     => 'dimensions',
						'units'    => false,
						'title'    => esc_html__('Square Large', 'impeka'),
						'subtitle'=> esc_html__( 'Default 900x900 - 1:1 ratio (Cropped)', 'impeka' ),
						'default'  => array(
							'width'   => '900',
							'height'  => '900'
						),
						'validate_callback' => 'impeka_grve_redux_dimensions_validation',
					),
					array(
						'id'       => 'size_fullscreen',
						'type'     => 'dimensions',
						'units'    => false,
						'title'    => esc_html__('Fullscreen', 'impeka'),
						'subtitle'=> esc_html__( 'Default 1920x1920 (Resize)', 'impeka' ),
						'default'  => array(
							'width'   => '1920',
							'height'  => '1920'
						),
						'validate_callback' => 'impeka_grve_redux_dimensions_validation',
					),
				)
			);

			$this->sections[] = array(
				'icon' => 'el-icon-lock',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( 'Privacy / Cookies', 'impeka' ),
				'desc' => esc_html__( 'The following shortcodes will allow your users to change certain behavior of your website regarding privacy.', 'impeka' ) . '<br>' .
					'<ul class="grve-privacy-list">' .
					'<li><strong>impeka_privacy_required</strong> - ' . esc_html__( 'displays a required content for your site e.g: Cloudlflare, CDN etc.', 'impeka' ) . '</li>' .
					'<li><strong>impeka_privacy_custom</strong> - ' . esc_html__( 'allows a user to enable/disable custom content', 'impeka' ) . '</li>' .
					'<li><strong>impeka_privacy_gtracking</strong> - ' . esc_html__( 'allows a user to enable/disable Google Analytics tracking code in the user\'s browser', 'impeka' ) . '</li>' .
					'<li><strong>impeka_privacy_gfonts</strong> - ' . esc_html__( 'allows a user to enable/disable the use of Google Fonts in the user\'s browser', 'impeka' ) . '</li>' .
					'<li><strong>impeka_privacy_gmaps</strong> - ' . esc_html__( 'allows a user to enable/disable the use of Google Maps in the user\'s browser', 'impeka' ) . '</li>' .
					'<li><strong>impeka_privacy_video_embeds</strong> - ' . esc_html__( 'allows a user to enable/disable video embeds in the user\'s browser', 'impeka' ) . '</li>' .
					'<li><strong>impeka_privacy_policy_page_link</strong> - ' . esc_html__( 'displays a link to the privacy policy page set from the WordPress admin panel', 'impeka' ) . '</li>' .
					'<li><strong>impeka_privacy_preferences_link</strong> - ' . esc_html__( 'displays a link to the privacy preferences as defined in the Privacy Consent Info Bar', 'impeka' ) . '</li>' .
					'</ul>' .
					esc_html__( 'You can use any of them in your privacy policy or in any text area that allows shortcodes.', 'impeka' ) . '<br><br>' .
					'<ul class="grve-privacy-list">' .
					'<li><strong>[impeka_privacy_required value="required"]</strong>For performance and security reasons we use Cloudflare<strong>[/impeka_privacy_required]</strong></li>' .
					'<li><strong>[impeka_privacy_custom id="custom-id"]</strong>Click to enable/disable custom content.<strong>[/impeka_privacy_custom]</strong></li>' .
					'<li><strong>[impeka_privacy_gtracking]</strong>Click to enable/disable Google Analytics tracking code.<strong>[/impeka_privacy_gtracking]</strong></li>' .
					'<li><strong>[impeka_privacy_gfonts]</strong>Click to enable/disable Google Fonts.<strong>[/impeka_privacy_gfonts]</strong></li>' .
					'<li><strong>[impeka_privacy_gmaps]</strong>Click to enable/disable Google Maps.<strong>[/impeka_privacy_gmaps]</strong></li>' .
					'<li><strong>[impeka_privacy_video_embeds]</strong>Click to enable/disable video embeds.<strong>[/impeka_privacy_video_embeds]</strong></li>' .
					'<li><strong>[impeka_privacy_policy_page_link]</strong></li>' .
					'<li><strong>[impeka_privacy_preferences_link]</strong></li>' .
					'</ul>' .
					esc_html__( 'Note: To change the default text add your text inside the shortcode tags [shortcode]Your text[/shortcode]', 'impeka' ),
				'id' => 'grve_redux_section_privacy_cookies',
				'submenu' => true,
				'customizer' => false,
				'class' => 'grve-redux-desc-full',
				'fields' => array(
					array(
						'id'   => 'info_style_blocking_content',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Privacy Content Blocking Settings', 'impeka' ),
						'subtitle'=> esc_html__( 'Configure the privacy content blocking settings.', 'impeka' ) . '<br>' . esc_html__( 'Note: The usage of the Blocking content feature is not recommended if you have added caching plugins or page rules to cache static HTML content (aggressive cache). If you use this feature you might need to disable such type of caching.', 'impeka' ),
					),
					array(
						'id' => 'privacy_content_blocking_enabled',
						'type' => 'switch',
						'title' => esc_html__( 'Privacy Content Blocking', 'impeka' ),
						'subtitle'=> esc_html__( 'Select if you want to enable/disable privacy content blocking.', 'impeka' ) .'<br><br>' . esc_html__( 'Note: if you disable content blocking certain privacy shortcodes will be automatically disabled.', 'impeka' ),
						'default' => 1,
					),
					array(
						'id'      => 'privacy_initial_state',
						'type'    => 'checkbox',
						'title'   => esc_html__( 'Privacy Initial Blocking State', 'impeka' ),
						'subtitle'    => esc_html__( 'Check if you want to block the content when the page loads.', 'impeka' ),
						'options'  => array(
							'gtracking'     => 'Google Tracking',
							'gfonts' => 'Google Fonts',
							'gmaps' => 'Google Maps',
							'video-embeds'   => 'Embed Videos'
						),
						'default' => array(
							'gtracking'     => '0',
							'gfonts' => '0',
							'gmaps' => '0',
							'video-embeds'   => '0'
						),
						'required' => array( 'privacy_content_blocking_enabled', 'equals', '1' ),
					),
  					array(
						'id'=>'privacy_custom_fields',
						'type' => 'multi_text',
						'title' => esc_html__('Privacy Custom Blocking Content Ids', 'impeka'),
						'subtitle' => esc_html__('Enter the ids for your custom blocking content. e.g: custom-id', 'impeka'),
						'required' => array( 'privacy_content_blocking_enabled', 'equals', '1' ),
					),
					array(
						'id'   => 'info_style_fallback_content',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Privacy Fallback Settings', 'impeka' ),
						'subtitle'=> esc_html__( 'Configure the privacy fallback info box.', 'impeka' ),
						'required' => array( 'privacy_content_blocking_enabled', 'equals', '1' ),
					),
					array(
						'id' => 'privacy_fallback_content',  //translatable
						'type' => 'textarea',
						'rows' => '2',
						'title' => esc_html__( 'Privacy Fallback Content', 'impeka' ),
						'subtitle' => esc_html__( 'Type the fallback text when the content is blocked.', 'impeka' ),
						'default' => 'This content is blocked. Please review your Privacy Preferences.',
						'required' => array( 'privacy_content_blocking_enabled', 'equals', '1' ),
					),
					array(
						'id'       => 'privacy_fallback_preferences_link_visibility',
						'type'     => 'switch',
						'title'    => esc_html__('Display Privacy Preferences link', 'impeka'),
						'subtitle' => esc_html__('Select if you want to display the Privacy Preferences link ( if defined in the privacy consent bar ).', 'impeka'),
						'default' => 1,
						'required' => array( 'privacy_content_blocking_enabled', 'equals', '1' ),
					),
					array(
						'id'       => 'privacy_fallback_content_link_visibility',
						'type'     => 'switch',
						'title'    => esc_html__('Display redirect link of the blocked content', 'impeka'),
						'subtitle' => esc_html__('Select if you want to display a redirect link of the blocked content ( blocked content will open in a new tab e.g: YouTube website ).', 'impeka'),
						'default'  => 1,
						'required' => array( 'privacy_content_blocking_enabled', 'equals', '1' ),
					),
					array(
						'id'   => 'info_style_consent_bar',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Privacy Consent Info Bar Settings', 'impeka' ),
						'subtitle'=> esc_html__( 'Configure the consent info bar.', 'impeka' ),
					),
					array(
						'id' => 'privacy_consent_bar_enabled',
						'type' => 'switch',
						'title' => esc_html__( 'Privacy Consent Info Bar', 'impeka' ),
						'subtitle'=> esc_html__( 'Select if you want to show a privacy consent info bar.', 'impeka' ),
						'default' => 0,
					),
					array(
						'id' => 'privacy_consent_bar_position',
						'type' => 'select',
						'compiler' => true,
						'title' => esc_html__( 'Privacy Consent Info Bar Position', 'impeka' ),
						'subtitle' => esc_html__( 'Select the position for Privacy Consent Info Bar', 'impeka' ),
						'options' => array(
							'center' => esc_html__( 'Center', 'impeka' ),
							'left' => esc_html__( 'Left', 'impeka' ),
							'right' => esc_html__( 'Right', 'impeka' ),
						),
						'default' => 'center',
						'validate' => 'not_empty',
						'required' => array( 'privacy_consent_bar_enabled', 'equals', '1' ),
					),
					array(
						'id' => 'privacy_consent_bar_content',  //translatable
						'type' => 'textarea',
						'rows' => '2',
						'title' => esc_html__( 'Privacy Info Bar Content', 'impeka' ),
						'subtitle' => esc_html__( 'Type the content of your consent info bar.', 'impeka' ),
						'default' => 'Our website uses cookies, mainly from 3rd party services. Define your Privacy Preferences and/or agree to our use of cookies.',
						'required' => array( 'privacy_consent_bar_enabled', 'equals', '1' ),
					),
					array(
						'id' => 'privacy_agreement_button_label',  //translatable
						'type' => 'text',
						'title' => esc_html__( 'Privacy Agreement Button Label', 'impeka' ),
						'subtitle'=> esc_html__( 'Define the label for your privacy agreement button. Leave empty to remove.', 'impeka' ),
						'required' => array( 'privacy_consent_bar_enabled', 'equals', '1' ),
						"default" => 'I Agree',
					),
					array(
						'id' => 'privacy_preferences_button_label',  //translatable
						'type' => 'text',
						'title' => esc_html__( 'Privacy Preferences Button Label', 'impeka' ),
						'subtitle'=> esc_html__( 'Define the label for your privacy preferences button. Leave empty to remove.', 'impeka' ),
						'required' => array( 'privacy_consent_bar_enabled', 'equals', '1' ),
						"default" => 'Privacy Preferences',
					),
					array(
						'id' => 'privacy_preferences_button_link',
						'type' => 'select',
						'compiler' => true,
						'title' => esc_html__( 'Privacy Preferences Button Link Mode', 'impeka' ),
						'subtitle' => esc_html__( 'Select the preferences button link mode: modal, privacy policy page or custom url.', 'impeka' ),
						'options' => array(
							'modal' => esc_html__( 'Modal', 'impeka' ),
							'privacy_page' => esc_html__( 'Privacy Policy Page', 'impeka' ),
							'custom_url' => esc_html__( 'Custom URL', 'impeka' ),
						),
						'default' => 'modal',
						'validate' => 'not_empty',
						'required' => array( 'privacy_consent_bar_enabled', 'equals', '1' ),
					),
					array(
						'id' => 'privacy_preferences_link_url',  //translatable
						'type' => 'text',
						'title' => esc_html__( 'Privacy Preferences Custom Link URL', 'impeka' ),
						'subtitle'=> esc_html__( 'Define a custom URL link for your privacy preferences button.', 'impeka' ),
						'required' => array(
							array( 'privacy_consent_bar_enabled', 'equals', '1' ),
							array( 'privacy_preferences_button_link', 'equals', 'custom_url' ),
						),
						"default" => '',
					),
					array(
						'id'=>'privacy_preferences_link_target',
						'type' => 'select',
						'title' => esc_html__( 'Privacy Preferences Custom Link Target', 'impeka' ),
						'subtitle'=> esc_html__( 'Define the target for your custom url, same or new page.', 'impeka' ),
						'options' => array(
							'_self' => esc_html__( 'Same Page', 'impeka' ),
							'_blank' => esc_html__( 'New page', 'impeka' ),
						),
						'required' => array(
							array( 'privacy_consent_bar_enabled', 'equals', '1' ),
							array( 'privacy_preferences_button_link', 'equals', 'custom_url' ),
						),
						"default" => '_self',
					),
					array(
						'id' => 'privacy_consent_modal_content',  //translatable
						'type' => 'editor',
						'args' => array ( 'wpautop' => false ),
						'title' => esc_html__( 'Privacy Modal Content', 'impeka' ),
						'subtitle' => esc_html__( 'Type the content of your modal consent dialog.', 'impeka' ),
						'default' => '<h5>Privacy Preferences</h5><p>When you visit our website, it may store information through your browser from specific services, usually in the form of cookies. Here you can change your Privacy preferences. It is worth noting that blocking some types of cookies may impact your experience on our website and the services we are able to offer.</p><div>[impeka_privacy_gtracking][impeka_privacy_gfonts][impeka_privacy_gmaps][impeka_privacy_video_embeds]</div>',
						'required' => array(
							array( 'privacy_consent_bar_enabled', 'equals', '1' ),
							array( 'privacy_preferences_button_link', 'equals', 'modal' ),
						),
					),
					array(
						'id' => 'privacy_refresh_button_label',  //translatable
						'type' => 'text',
						'title' => esc_html__( 'Privacy Refresh Button Label', 'impeka' ),
						'subtitle'=> esc_html__( 'Define the label for your privacy refresh button. Leave empty to remove.', 'impeka' ),
						'required' => array(
							array( 'privacy_consent_bar_enabled', 'equals', '1' ),
							array( 'privacy_preferences_button_link', 'equals', 'modal' ),
						),
						"default" => 'Save Preferences',
					),
				)
			);

			//Colors Start
			$this->sections[] = array(
				'icon' => 'el-icon-brush',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( 'Colors - Top Bar', 'impeka' ),
				'id' => 'grve_redux_section_colors_top_bar',
				'desc' => esc_html__( 'Set your color preferences for the TopBar (you will see the changes in the live preview only if TopBar is enabled).', 'impeka' ),
				'submenu' => false,
				'panel' => false,
				'grve_colors' => true,
				'subsection' => false,
				'fields' => array(
					//Top Bar Color Settings
					array(
						'id'          => 'top_bar_bg_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Top Bar Background Color', 'impeka' ),
						'subtitle'    => esc_html__( 'Background color for your Top Bar.', 'impeka' ),
						'default'     => '#ffffff',
						'transparent' => false,
					),
					array(
						'id'          => 'top_bar_font_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Top Bar Font Color', 'impeka' ),
						'subtitle'    => esc_html__( 'Font color for your Top Bar.', 'impeka' ),
						'default'     => '#777777',
						'transparent' => false,
					),
					array(
						'id'          => 'top_bar_link_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Top Bar Link Color', 'impeka' ),
						'subtitle'    => esc_html__( 'Link color for your Top Bar.', 'impeka' ),
						'default'     => '#777777',
						'transparent' => false,
					),
					array(
						'id'          => 'top_bar_hover_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Top Bar Hover Color', 'impeka' ),
						'subtitle'    => esc_html__( 'Hover color for your Top Bar.', 'impeka' ),
						'default'     => '#FF4433',
						'transparent' => false,
					),
				)
			);
			$this->sections[] = array(
				'icon' => 'el-icon-brush',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( 'Colors - Header / Menu', 'impeka' ),
				'id' => 'grve_redux_section_colors_header_menu',
				'desc' => esc_html__( 'Set your color preferences for the Header and Menu.', 'impeka' ),
				'submenu' => false,
				'panel' => false,
				'grve_colors' => true,
				'subsection' => false,
				'fields' => array(
				),
			);
			$this->sections[] = array(
				'icon' => 'el-icon-brush',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( 'Colors - Default Header', 'impeka' ),
				'id' => 'grve_redux_section_colors_default_header',
				'desc' => esc_html__( 'Set your color preferences for the Default Header. Keep in mind that the basic settings for the Default Header are in Theme Options > Header Options.', 'impeka' ),
				'submenu' => false,
				'panel' => false,
				'grve_colors' => true,
				'subsection' => true,
				'fields' => array(
					//Default Header Color Settings
					array(
						'id'       => 'default_header_background_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Background Color', 'impeka' ),
						'subtitle' => esc_html__( 'Pick a background color for the header.', 'impeka' ),
						'default'  => '#ffffff',
						'transparent' => false,
					),
					array(
						'id' => 'default_header_background_color_opacity',
						'type' => 'select',
						'title' => esc_html__('Background Opacity', 'impeka' ),
						'subtitle'    => esc_html__( 'Select opacity for the background of the header.', 'impeka' ),
						'options' => $opacity_selection,
						"default" => '1',
					),
					array(
						'id'       => 'default_header_border_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Border Color', 'impeka' ),
						'subtitle' => esc_html__( 'Pick a border color for the header.', 'impeka' ),
						'default'  => '#000000',
						'transparent' => false,
					),
					array(
						'id' => 'default_header_border_color_opacity',
						'type' => 'select',
						'title' => esc_html__('Border Opacity', 'impeka' ),
						'subtitle'    => esc_html__( 'Select opacity for the border of the header.', 'impeka' ),
						'options' => $opacity_selection,
						"default" => '0.15',
					),
					//Menu Color Settings
					array(
						'id'          => 'default_header_menu_text_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Menu Text Color', 'impeka' ),
						'subtitle'    => esc_html__( 'Pick a color for the menu text.', 'impeka' ),
						'default'     => '#000000',
						'transparent' => false,
					),
					array(
						'id'          => 'default_header_menu_text_hover_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Menu Text Hover Color', 'impeka' ),
						'subtitle'    => esc_html__( 'Pick a color for the hover menu text.', 'impeka' ),
						'default'     => '#ff4433',
						'transparent' => false,
					),
					array(
						'id'          => 'default_header_menu_item_style_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Menu Item Style Color', 'impeka' ),
						'subtitle'    => esc_html__( 'Pick a color for the menu item style. This will affect if you select the underline or line-through menu item style.', 'impeka' ),
						'default'     => '#ff4433',
						'transparent' => false,
					),
				)
			);

			$this->sections[] = array(
				'icon' => 'el-icon-brush',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( 'Colors - Logo on Top Header', 'impeka' ),
				'id' => 'grve_redux_section_colors_logotop_header',
				'desc' => esc_html__( 'Set your color preferences for the Logo on top Header. Keep in mind that the basic settings for the Logo on top Header are in Theme Options > Header Options.', 'impeka' ),
				'submenu' => false,
				'panel' => false,
				'grve_colors' => true,
				'subsection' => true,
				'fields' => array(
					//Logo on top Header Color Settings
					array(
						'id'       => 'logo_top_header_logo_area_background_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Logo Area Background Color', 'impeka' ),
						'subtitle' => esc_html__( 'Pick a background color for the logo area.', 'impeka' ),
						'default'  => '#ffffff',
						'transparent' => false,
					),
					array(
						'id' => 'logo_top_header_logo_area_background_color_opacity',
						'type' => 'select',
						'title' => esc_html__('Logo Area Background Opacity', 'impeka' ),
						'subtitle'    => esc_html__( 'Select opacity for the background of the logo area.', 'impeka' ),
						'options' => $opacity_selection,
						"default" => '1',
					),
					array(
						'id'       => 'logo_top_header_menu_area_background_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Menu Area Background Color', 'impeka' ),
						'subtitle' => esc_html__( 'Pick a background color for the menu area.', 'impeka' ),
						'default'  => '#ffffff',
						'transparent' => false,
					),
					array(
						'id' => 'logo_top_header_menu_area_background_color_opacity',
						'type' => 'select',
						'title' => esc_html__('Menu Area Background Opacity', 'impeka' ),
						'subtitle'    => esc_html__( 'Select opacity for the background of the menu area.', 'impeka' ),
						'options' => $opacity_selection,
						"default" => '1',
					),
					array(
						'id'       => 'logo_top_header_text_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Header Text Color', 'impeka' ),
						'subtitle' => esc_html__( 'Pick a color for the text.', 'impeka' ),
						'default'  => '#88959B',
						'transparent' => false,
					),
					array(
						'id'       => 'logo_top_header_headings_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Header Headings Color', 'impeka' ),
						'subtitle' => esc_html__( 'Pick a color for the headings.', 'impeka' ),
						'default'  => '#000000',
						'transparent' => false,
					),
					array(
						'id'       => 'logo_top_header_link_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Header Link Color', 'impeka' ),
						'subtitle' => esc_html__( 'Pick a color for the link.', 'impeka' ),
						'default'  => '#000000',
						'transparent' => false,
					),
					array(
						'id'       => 'logo_top_header_link_hover_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Header Link Hover Color', 'impeka' ),
						'subtitle' => esc_html__( 'Pick a color for the link hover.', 'impeka' ),
						'default'  => '#FF4433',
						'transparent' => false,
					),
				)
			);

			$this->sections[] = array(
				'icon' => 'el-icon-brush',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( 'Colors - Sticky Header', 'impeka' ),
				'id' => 'grve_redux_section_colors_sticky_header',
				'desc' => esc_html__( 'Set your color preferences for the Sticky Header. You can enable/disable, select the type and logo for the sticky header in Theme Options > Header Options > Sticky Header Options.', 'impeka' ),
				'submenu' => false,
				'panel' => false,
				'grve_colors' => true,
				'subsection' => true,
				'fields' => array(
					//Sticky Header Color Settings
					array(
						'id'       => 'header_sticky_background_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Background Color', 'impeka' ),
						'subtitle'    => esc_html__( 'Pick a background color for the header.', 'impeka' ),
						'default'  => '#ffffff',
						'transparent' => false,
					),
					array(
						'id' => 'header_sticky_background_color_opacity',
						'type' => 'select',
						'title' => esc_html__('Background Opacity', 'impeka' ),
						'subtitle'    => esc_html__( 'Select opacity for the background of the header.', 'impeka' ),
						'options' => $opacity_selection,
						"default" => '1',
					),
					array(
						'id'       => 'header_sticky_border_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Border Color', 'impeka' ),
						'subtitle' => esc_html__( 'Pick a border color for the sticky header.', 'impeka' ),
						'default'  => '#eef1f6',
						'transparent' => false,
					),
					array(
						'id' => 'header_sticky_border_color_opacity',
						'type' => 'select',
						'title' => esc_html__('Border Opacity', 'impeka' ),
						'subtitle'    => esc_html__( 'Select opacity for the border of the sticky header.', 'impeka' ),
						'options' => $opacity_selection,
						"default" => '0',
					),
					//Menu Color Settings
					array(
						'id'          => 'sticky_menu_text_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Menu Text Color', 'impeka' ),
						'subtitle'    => esc_html__( 'Pick a color for the menu text.', 'impeka' ),
						'default'     => '#88959B',
						'transparent' => false,
					),
					array(
						'id'          => 'sticky_menu_text_hover_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Menu Text Hover Color', 'impeka' ),
						'subtitle'    => esc_html__( 'Pick a color for the hover menu text.', 'impeka' ),
						'default'     => '#000000',
						'transparent' => false,
					),
					array(
						'id'          => 'header_sticky_menu_item_style_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Menu Item Style Color', 'impeka' ),
						'subtitle'    => esc_html__( 'Pick a color for the menu item style. This will affect if you select the underline or line-through menu item style.', 'impeka' ),
						'default'     => '#88959B',
						'transparent' => false,
					),
				)
			);

			$this->sections[] = array(
				'icon' => 'el-icon-brush',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( 'Colors - Light Header', 'impeka' ),
				'id' => 'grve_redux_section_colors_light_header',
				'desc' => esc_html__( 'Notice that the Light Header is the transparent header with light fonts that theme provides in order to combine with the overlapping option everywhere in your site.', 'impeka' ),
				'submenu' => false,
				'panel' => false,
				'grve_colors' => true,
				'subsection' => true,
				'fields' => array(
					//Menu Color Settings
					array(
						'id'          => 'light_menu_text_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Menu Text Color', 'impeka' ),
						'subtitle'    => esc_html__( 'Pick a color for the menu text.', 'impeka' ),
						'default'     => '#ffffff',
						'transparent' => false,
					),
					array(
						'id'          => 'light_menu_text_hover_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Menu Text Hover/Active Color', 'impeka' ),
						'subtitle'    => esc_html__( 'Pick a color for the hover/active menu text.', 'impeka' ),
						'default'     => '#ffffff',
						'transparent' => false,
					),
					array(
						'id'          => 'light_menu_item_style_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Menu Item Style Color', 'impeka' ),
						'subtitle'    => esc_html__( 'Pick a color for the menu item style. This will affect if you select the underline or line-through menu item style.', 'impeka' ),
						'default'     => '#88959B',
						'transparent' => false,
					),
					array(
						'id'       => 'light_header_border_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Border Color', 'impeka' ),
						'subtitle' => esc_html__( 'Pick a border color for the light header.', 'impeka' ),
						'default'  => '#ffffff',
						'transparent' => false,
					),
					array(
						'id' => 'light_header_border_color_opacity',
						'type' => 'select',
						'title' => esc_html__('Border Opacity', 'impeka' ),
						'subtitle'    => esc_html__( 'Select opacity for the border of the light header.', 'impeka' ),
						'options' => $opacity_selection,
						"default" => '0',
					),
					array(
						'id'       => 'light_header_text_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Header Text Color', 'impeka' ),
						'subtitle' => esc_html__( 'Pick a color for the text.', 'impeka' ),
						'default'  => '#ffffff',
						'transparent' => false,
					),
					array(
						'id'       => 'light_header_headings_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Header Headings Color', 'impeka' ),
						'subtitle' => esc_html__( 'Pick a color for the headings.', 'impeka' ),
						'default'  => '#ffffff',
						'transparent' => false,
					),
					array(
						'id'       => 'light_header_link_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Header Link Color', 'impeka' ),
						'subtitle' => esc_html__( 'Pick a color for the link.', 'impeka' ),
						'default'  => '#ffffff',
						'transparent' => false,
					),
					array(
						'id'       => 'light_header_link_hover_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Header Link Hover Color', 'impeka' ),
						'subtitle' => esc_html__( 'Pick a color for the link hover.', 'impeka' ),
						'default'  => '#FF4433',
						'transparent' => false,
					),
				)
			);
			$this->sections[] = array(
				'icon' => 'el-icon-brush',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( 'Colors - Dark Header', 'impeka' ),
				'id' => 'grve_redux_section_colors_dark_header',
				'desc' => esc_html__( 'Notice that the Dark Header is the transparent header with dark fonts that theme provides in order to combine with the overlapping option everywhere in your site.', 'impeka' ),
				'submenu' => false,
				'grve_colors' => true,
				'panel' => false,
				'subsection' => true,
				'fields' => array(
					//Menu Color Settings
					array(
						'id'          => 'dark_menu_text_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Menu Text Color', 'impeka' ),
						'subtitle'    => esc_html__( 'Pick a color for the menu text.', 'impeka' ),
						'default'     => '#000000',
						'transparent' => false,
					),
					array(
						'id'          => 'dark_menu_text_hover_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Menu Text Hover/Active Color', 'impeka' ),
						'subtitle'    => esc_html__( 'Pick a color for the hover/active menu text.', 'impeka' ),
						'default'     => '#000000',
						'transparent' => false,
					),
					array(
						'id'          => 'dark_menu_item_style_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Menu Item Style Color', 'impeka' ),
						'subtitle'    => esc_html__( 'Pick a color for the menu item style. This will affect if you select the underline or line-through menu item style.', 'impeka' ),
						'default'     => '#ff4433',
						'transparent' => false,
					),
					array(
						'id'       => 'dark_header_border_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Border Color', 'impeka' ),
						'subtitle' => esc_html__( 'Pick a border color for the dark header.', 'impeka' ),
						'default'  => '#000000',
						'transparent' => false,
					),
					array(
						'id' => 'dark_header_border_color_opacity',
						'type' => 'select',
						'title' => esc_html__('Border Opacity', 'impeka' ),
						'subtitle'    => esc_html__( 'Select opacity for the border of the dark header.', 'impeka' ),
						'options' => $opacity_selection,
						"default" => '0',
					),
					array(
						'id'       => 'dark_header_text_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Header Text Color', 'impeka' ),
						'subtitle' => esc_html__( 'Pick a color for the text.', 'impeka' ),
						'default'  => '#000000',
						'transparent' => false,
					),
					array(
						'id'       => 'dark_header_headings_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Header Headings Color', 'impeka' ),
						'subtitle' => esc_html__( 'Pick a color for the headings.', 'impeka' ),
						'default'  => '#000000',
						'transparent' => false,
					),
					array(
						'id'       => 'dark_header_link_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Header Link Color', 'impeka' ),
						'subtitle' => esc_html__( 'Pick a color for the link.', 'impeka' ),
						'default'  => '#000000',
						'transparent' => false,
					),
					array(
						'id'       => 'dark_header_link_hover_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Header Link Hover Color', 'impeka' ),
						'subtitle' => esc_html__( 'Pick a color for the link hover.', 'impeka' ),
						'default'  => '#FF4433',
						'transparent' => false,
					),
				)
			);

			$this->sections[] = array(
				'icon' => 'el-icon-brush',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( 'Colors - Sub Menu Colors', 'impeka' ),
				'id' => 'grve_redux_section_colors_sub_menu',
				'desc' => esc_html__( 'Set your color preferences for the Sub Menu.', 'impeka' ),
				'submenu' => false,
				'panel' => false,
				'grve_colors' => true,
				'subsection' => true,
				'fields' => array(
					//Sub Menu Color Settings
					array(
						'id'          => 'default_header_submenu_bg_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Sub Menu Background Color', 'impeka' ),
						'subtitle'    => esc_html__( 'Pick a background color for the sub menu.', 'impeka' ),
						'default'     => '#ffffff',
						'transparent' => false,
					),
					array(
						'id'          => 'default_header_submenu_text_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Sub Menu Text Color', 'impeka' ),
						'subtitle'    => esc_html__( 'Pick a color for the sub menu text.', 'impeka' ),
						'default'     => '#000000',
						'transparent' => false,
					),
					array(
						'id'          => 'default_header_submenu_text_hover_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Sub Menu Text Hover/Active Color', 'impeka' ),
						'subtitle'    => esc_html__( 'Pick a color for the hover or active sub menu text.', 'impeka' ),
						'default'     => '#000000',
						'transparent' => false,
					),
					array(
						'id'          => 'default_header_submenu_column_text_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Sub Menu Column Title Color', 'impeka' ),
						'subtitle'    => esc_html__( 'Pick a color for the sub menu column titles ( Used in mega menu ).', 'impeka' ),
						'default'     => '#000000',
						'transparent' => false,
					),
					array(
						'id'          => 'default_header_submenu_column_text_hover_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Sub Menu Column Titles Hover/Active Color', 'impeka' ),
						'subtitle'    => esc_html__( 'Pick a color for the hover or active sub menu column titles ( Used in mega menu ).', 'impeka' ),
						'default'     => '#000000',
						'transparent' => false,
					),
					array(
						'id'          => 'default_header_submenu_border_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Sub Menu Border Color', 'impeka' ),
						'subtitle'    => esc_html__( 'Pick a border color for the sub menu.', 'impeka' ),
						'default'     => '#f7f7f7',
						'transparent' => false,
					),
					array(
						'id'          => 'default_header_label_bg_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Label Background Color', 'impeka' ),
						'subtitle'    => esc_html__( 'Pick a background color for the label.', 'impeka' ),
						'default'     => '#FF4433',
						'transparent' => false,
					),
					array(
						'id'          => 'default_header_label_text_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Label Text Color', 'impeka' ),
						'subtitle'    => esc_html__( 'Pick a text color for the label.', 'impeka' ),
						'default'     => '#ffffff',
						'transparent' => false,
					),
				)
			);

			$this->sections[] = array(
				'icon' => 'el-icon-brush',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( 'Colors - Responsive Header', 'impeka' ),
				'id' => 'grve_redux_section_colors_responsive_header',
				'desc' => esc_html__( 'Set your color preferences for the Responsive Header. These settings will affect when the responsive header appears, below 1024px.', 'impeka' ),
				'submenu' => false,
				'panel' => false,
				'grve_colors' => true,
				'subsection' => true,
				'fields' => array(
					array(
						'id'       => 'responsive_header_background_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Background Color', 'impeka' ),
						'subtitle' => esc_html__( 'Pick a background color for the header.', 'impeka' ),
						'default'  => '#ffffff',
						'transparent' => false,
					),
					array(
						'id' => 'responsive_header_background_opacity',
						'type' => 'select',
						'title' => esc_html__('Background Color Opacity', 'impeka' ),
						'subtitle'    => esc_html__( 'Select opacity for the background of the responsive header.', 'impeka' ),
						'options' => $opacity_selection,
						"default" => '1',
					),
					array(
						'id'          => 'responsive_header_elements_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Header Elements Color', 'impeka' ),
						'subtitle'    => esc_html__( 'Pick a color for the header elements.', 'impeka' ),
						'default'     => '#000000',
						'transparent' => false,
					),
					array(
						'id'          => 'responsive_header_elements_hover_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Header Elements Hover Color', 'impeka' ),
						'subtitle'    => esc_html__( 'Pick a color for the header elements hover.', 'impeka' ),
						'default'     => '#ff4433',
						'transparent' => false,
					),
				)
			);

			$this->sections[] = array(
				'icon' => 'el-icon-brush',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( 'Colors - Responsive Menu', 'impeka' ),
				'id' => 'grve_redux_section_colors_responsive_menu',
				'desc' => esc_html__( 'Set your color preferences for the Responsive Menu.', 'impeka' ),
				'submenu' => false,
				'panel' => false,
				'grve_colors' => true,
				'subsection' => true,
				'fields' => array(
					array(
						'id'       => 'responsive_menu_bg_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Background Color', 'impeka' ),
						'subtitle' => esc_html__( 'Pick a color for the backround of the responsive menu ( Available only for Color background mode ).', 'impeka' ),
						'default'  => '#000000',
						'transparent' => false,
					),
					array(
						'id'       => 'responsive_menu_link_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Link Color', 'impeka' ),
						'subtitle' => esc_html__( 'Pick a color for the links of the responsive menu.', 'impeka' ),
						'default'  => '#ffffff',
						'transparent' => false,
					),
					array(
						'id'       => 'responsive_menu_link_hover_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Hover Color', 'impeka' ),
						'subtitle' => esc_html__( 'Pick a color for the hovers of the responsive menu.', 'impeka' ),
						'default'  => '#FF4433',
						'transparent' => false,
					),
					array(
						'id'       => 'responsive_menu_headings_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Headings Color', 'impeka' ),
						'subtitle' => esc_html__( 'Pick a color for the titles - headings (h1-h6) of the responsive menu.', 'impeka' ),
						'default'  => '#ffffff',
						'transparent' => false,
					),
					array(
						'id'       => 'responsive_menu_text_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Text Color', 'impeka' ),
						'subtitle' => esc_html__( 'Pick a color for the text of the responsive menu.', 'impeka' ),
						'default'  => '#ffffff',
						'transparent' => false,
					),
					array(
						'id'       => 'responsive_menu_border_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Border Color', 'impeka' ),
						'subtitle' => esc_html__( 'Pick a color for the borders of the responsive menu.', 'impeka' ),
						'default'  => '#eef1f6',
						'transparent' => false,
					),
					array(
						'id' => 'responsive_menu_close_color',
						'type' => 'select',
						'title' => esc_html__( 'Close Button Color', 'impeka' ),
						'subtitle'=> esc_html__( 'Select a color for close button of the responsive menu.', 'impeka' ),
						'options' => array(
							'black' => esc_html__( 'Black', 'impeka' ),
							'white' => esc_html__( 'White', 'impeka' ),
						),
						'default' => 'white',
						'validate' => 'not_empty',
					),
				)
			);

			$this->sections[] = array(
				'icon' => 'el-icon-brush',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( 'Colors - Offcanvas Menu', 'impeka' ),
				'id' => 'grve_redux_section_colors_offcanvas_menu',
				'desc' => esc_html__( 'Set your color preferences for the Offcanvas Menu.', 'impeka' ),
				'submenu' => false,
				'panel' => false,
				'grve_colors' => true,
				'subsection' => true,
				'fields' => array(
					array(
						'id'       => 'offcanvas_menu_background_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Background Color', 'impeka' ),
						'subtitle' => esc_html__( 'Pick a background color for the offcanvas menu.', 'impeka' ),
						'default'  => '#000000',
						'transparent' => false,
					),
					array(
						'id' => 'offcanvas_menu_background_color_opacity',
						'type' => 'select',
						'title' => esc_html__('Background Opacity', 'impeka' ),
						'subtitle'    => esc_html__( 'Select opacity for the background of the offcanvas menu.', 'impeka' ),
						'options' => $opacity_selection,
						"default" => '1',
					),
					array(
						'id'       => 'offcanvas_menu_link_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Menu Item Color', 'impeka' ),
						'subtitle' => esc_html__( 'Pick a color for the menu item of the offcanvas menu.', 'impeka' ),
						'default'  => '#777777',
						'transparent' => false,
					),
					array(
						'id'       => 'offcanvas_menu_link_hover_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Menu Item Hover Color', 'impeka' ),
						'subtitle' => esc_html__( 'Pick a color for the menu item hovers of the offcanvas menu.', 'impeka' ),
						'default'  => '#FF4433',
						'transparent' => false,
					),
					array(
						'id'          => 'offcanvas_menu_item_style_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Menu Item Style Color', 'impeka' ),
						'subtitle'    => esc_html__( 'Pick a color for the menu item style. This will affect if you select the underline or line-through menu item style.', 'impeka' ),
						'default'     => '#eef1f6',
						'transparent' => false,
					),
					array(
						'id'       => 'offcanvas_text_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Text Color', 'impeka' ),
						'subtitle' => esc_html__( 'Pick a color for the text of the offcanvas menu.', 'impeka' ),
						'default'  => '#A1A1A1',
						'transparent' => false,
					),
					array(
						'id'       => 'offcanvas_menu_border_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Border Color', 'impeka' ),
						'subtitle' => esc_html__( 'Pick a color for the borders of the offcanvas menu.', 'impeka' ),
						'default'  => '#eef1f6',
						'transparent' => false,
					),
					array(
						'id' => 'offcanvas_logo_color',
						'type' => 'select',
						'title' => esc_html__( 'Logo Color', 'impeka' ),
						'subtitle'=> esc_html__( 'Select logo color, when offcanvas menu opens.', 'impeka' ),
						'options' => array(
							'default' => esc_html__( 'Default', 'impeka' ),
							'light' => esc_html__( 'Light', 'impeka' ),
							'dark' => esc_html__( 'Dark', 'impeka' ),
						),
						'default' => 'light',
					),
					array(
						'id' => 'offcanvas_close_color',
						'type' => 'select',
						'title' => esc_html__( 'Close Button Color', 'impeka' ),
						'subtitle'=> esc_html__( 'Select a color for close button of the offcanvas menu.', 'impeka' ),
						'options' => array(
							'black' => esc_html__( 'Black', 'impeka' ),
							'white' => esc_html__( 'White', 'impeka' ),
						),
						'default' => 'white',
						'validate' => 'not_empty',
					),
				)
			);

			$this->sections[] = array(
				'icon' => 'el-icon-brush',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( 'Colors - Sliding Modals', 'impeka' ),
				'id' => 'grve_redux_section_colors_sliding_modals',
				'desc' => esc_html__( 'Set your color preferences for the sliding modals.', 'impeka' ),
				'submenu' => false,
				'panel' => false,
				'grve_colors' => true,
				'subsection' => true,
				'fields' => array(
					array(
						'id'       => 'sliding_modals_title_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Title Color', 'impeka' ),
						'subtitle' => esc_html__( 'Pick a color for the titles - headings (h1-h6) of the modal.', 'impeka' ),
						'default'  => '#ffffff',
						'transparent' => false,
					),
					array(
						'id'       => 'sliding_modals_text_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Text Color', 'impeka' ),
						'subtitle' => esc_html__( 'Pick a color for the text of the modal.', 'impeka' ),
						'default'  => '#ffffff',
						'transparent' => false,
					),
					array(
						'id'       => 'sliding_modals_border_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Border Color', 'impeka' ),
						'subtitle' => esc_html__( 'Pick a color for the borders of the modal.', 'impeka' ),
						'default'  => '#e9e9e9',
						'transparent' => false,
					),
					array(
						'id'       => 'sliding_modals_background_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Background Color', 'impeka' ),
						'subtitle' => esc_html__( 'Pick a background color for the modal.', 'impeka' ),
						'default'  => '#000000',
						'transparent' => false,
					),
					array(
						'id' => 'sliding_modals_close_color',
						'type' => 'select',
						'title' => esc_html__( 'Close Button Color', 'impeka' ),
						'subtitle'=> esc_html__( 'Select a color for close button of the modal.', 'impeka' ),
						'options' => array(
							'black' => esc_html__( 'Black', 'impeka' ),
							'white' => esc_html__( 'White', 'impeka' ),
						),
						'default' => 'white',
						'validate' => 'not_empty',
					),
				)
			);
			$this->sections[] = array(
				'title' => esc_html__( 'Colors - Anchor Menu', 'impeka' ),
				'id' => 'grve_redux_section_colors_anchor_menu',
				'header' => '',
				'desc' => esc_html__( 'Set your color preferences for the Anchor Menu in case you use one in any of your pages, posts items.', 'impeka' ),
				'icon_class' => 'el-icon-large',
				'icon' => 'el-icon-brush',
				'submenu' => false,
				'panel' => false,
				'grve_colors' => true,
				'subsection' => false,
				'fields' => array(
					array(
						'id'       => 'page_anchor_menu_background_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Background Color', 'impeka' ),
						'subtitle' => esc_html__( 'Background color for the Anchor Menu.', 'impeka' ),
						'default'  => '#171a1d',
						'transparent' => false,
					),
					array(
						'id'       => 'page_anchor_menu_text_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Font Color', 'impeka' ),
						'subtitle' => esc_html__( 'Font color for the Anchor Menu.', 'impeka' ),
						'default'  => '#ffffff',
						'transparent' => false,
					),
					array(
						'id'       => 'page_anchor_menu_text_hover_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Hover Text Color', 'impeka' ),
						'subtitle' => esc_html__( 'Hover color for the Anchor Menu.', 'impeka' ),
						'default'  => '#FF4433',
						'transparent' => false,
					),
					array(
						'id'       => 'page_anchor_menu_background_hover_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Hover Background Color', 'impeka' ),
						'subtitle' => esc_html__( 'Hover background color for the Anchor Menu.', 'impeka' ),
						'default'  => '#171a1d',
						'transparent' => false,
					),
					array(
						'id'       => 'page_anchor_menu_border_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Border Color', 'impeka' ),
						'subtitle' => esc_html__( 'Border color for the Anchor Menu.', 'impeka' ),
						'default'  => '#333638',
						'transparent' => false,
					),
				)
			);

			$this->sections[] = array(
				'title' => esc_html__( 'Colors - Main Content', 'impeka' ),
				'id' => 'grve_redux_section_colors_main_content',
				'header' => '',
				'desc' => esc_html__( 'Set your color preferences for the main content area of your site.', 'impeka' ),
				'icon_class' => 'el-icon-large',
				'icon' => 'el-icon-brush',
				'submenu' => false,
				'panel' => false,
				'grve_colors' => true,
				'subsection' => false,
				'fields' => array(
					array(
						'id'       => 'body_heading_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Headings Text Color (h1-h6)', 'impeka' ),
						'subtitle'    => esc_html__( 'Pick a color for headings text.', 'impeka' ),
						'default'  => '#000000',
						'transparent' => false,
					),
					array(
						'id'       => 'body_text_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Text Color', 'impeka' ),
						'subtitle' => esc_html__( 'Pick a color for the text.', 'impeka' ),
						'default'  => '#272727',
						'transparent' => false,
					),
					array(
						'id'       => 'body_text_link_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Link Color', 'impeka' ),
						'subtitle' => esc_html__( 'Pick a color for the links.', 'impeka' ),
						'default'  => '#000000',
						'transparent' => false,
					),
					array(
						'id'       => 'body_text_link_hover_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Hover Color', 'impeka' ),
						'subtitle' => esc_html__( 'Pick a color for hover text.', 'impeka' ),
						'default'  => '#FF4433',
						'transparent' => false,
					),
					array(
						'id'       => 'body_border_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Border Color', 'impeka' ),
						'subtitle' => esc_html__( 'Pick a border color.', 'impeka' ),
						'default'  => '#e9e9e9',
						'transparent' => false,
					),
					array(
						'id'       => 'widget_title_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Widget Title Color', 'impeka' ),
						'subtitle' => esc_html__( 'Pick a color for widget titles.', 'impeka' ),
						'default'  => '#000000',
						'transparent' => false,
					),
					array(
						'id'       => 'body_primary_1_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Primary 1 Color', 'impeka' ),
						'subtitle' => esc_html__( 'Pick a color for primary 1.', 'impeka' ),
						'default'  => '#FF4433',
						'transparent' => false,
					),
					array(
						'id'       => 'body_primary_2_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Primary 2 Color', 'impeka' ),
						'subtitle' => esc_html__( 'Pick a color for primary 2.', 'impeka' ),
						'default'  => '#4D74FB',
						'transparent' => false,
					),
					array(
						'id'       => 'body_primary_3_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Primary 3 Color', 'impeka' ),
						'subtitle' => esc_html__( 'Pick a color for primary 3.', 'impeka' ),
						'default'  => '#F7978F',
						'transparent' => false,
					),
					array(
						'id'       => 'body_primary_4_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Primary 4 Color', 'impeka' ),
						'subtitle' => esc_html__( 'Pick a color for primary 4.', 'impeka' ),
						'default'  => '#00C6FF',
						'transparent' => false,
					),
					array(
						'id'       => 'body_primary_5_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Primary 5 Color', 'impeka' ),
						'subtitle' => esc_html__( 'Pick a color for primary 5.', 'impeka' ),
						'default'  => '#090078',
						'transparent' => false,
					),
					array(
						'id'       => 'body_primary_6_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Primary 6 Color', 'impeka' ),
						'subtitle' => esc_html__( 'Pick a color for primary 6.', 'impeka' ),
						'default'  => '#AFB8BD',
						'transparent' => false,
					),
					array(
						'id'       => 'body_gradient_1_1_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Gradient 1 Color', 'impeka' ),
						'subtitle' => esc_html__( 'First Color.', 'impeka' ),
						'class' => 'grve-color-group',
						'default'  => '#FF4433',
						'transparent' => false,
					),
					array(
						'id'       => 'body_gradient_1_2_color',
						'type'     => 'color',
						'title'    => '',
						'subtitle' => esc_html__( 'Second Color', 'impeka' ),
						'class' => 'grve-color-group',
						'default'  => '#FF8461',
						'transparent' => false,
					),
					array(
						'id'       => 'body_gradient_2_1_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Gradient 2 Color', 'impeka' ),
						'subtitle' => esc_html__( 'First Color.', 'impeka' ),
						'class' => 'grve-color-group',
						'default'  => '#00C6FF',
						'transparent' => false,
					),
					array(
						'id'       => 'body_gradient_2_2_color',
						'type'     => 'color',
						'title'    => '',
						'subtitle' => esc_html__( 'Second Color', 'impeka' ),
						'class' => 'grve-color-group',
						'default'  => '#0072FF',
						'transparent' => false,
					),
					array(
						'id'       => 'body_gradient_3_1_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Gradient 3 Color', 'impeka' ),
						'subtitle' => esc_html__( 'First Color.', 'impeka' ),
						'class' => 'grve-color-group',
						'default'  => '#0021FF',
						'transparent' => false,
					),
					array(
						'id'       => 'body_gradient_3_2_color',
						'type'     => 'color',
						'title'    => '',
						'subtitle' => esc_html__( 'Second Color', 'impeka' ),
						'class' => 'grve-color-group',
						'default'  => '#090078',
						'transparent' => false,
					),
				)
			);

			$this->sections[] = array(
				'icon' => 'el-icon-brush',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( 'Colors - Blog /Post', 'impeka' ),
				'id' => 'grve_redux_section_colors_blog_post',
				'desc' => esc_html__( 'Set your color preferences for your Blog / Post.', 'impeka' ),
				'submenu' => false,
				'panel' => false,
				'grve_colors' => true,
				'subsection' => false,
				'fields' => array(
				),
			);

			$this->sections[] = array(
				'title' => esc_html__( 'Colors - Blog Title', 'impeka' ),
				'id' => 'grve_redux_section_colors_blog_title',
				'header' => '',
				'desc' => esc_html__( 'Set the background color for the blog title area and the color of the blog title. These settings will only affect in case you have set a Static Page as blog page in Settings > Reading > Front Page Displays. Also these settings will also affect on Archives / Categories / Tags overview pages.', 'impeka' ),
				'icon_class' => 'el-icon-large',
				'icon' => 'el-icon-brush',
				'submenu' => false,
				'panel' => false,
				'grve_colors' => true,
				'subsection' => true,
				'fields' => array(
					array(
						'id' => 'blog_title_bg_color',
						'type' => 'select',
						'title' => esc_html__( 'Background Color', 'impeka' ),
						'subtitle'    => esc_html__( 'Background color for your blog title.', 'impeka' ),
						'options' => $bg_color_selection_extra,
						'default' => 'white',
					),
					array(
						'id'       => 'blog_title_bg_color_custom',
						'type'     => 'color',
						'title'    => esc_html__( 'Custom Background Color', 'impeka' ),
						'transparent' => false,
						'default'  => '#f7f7fb',
						'required' => array( 'blog_title_bg_color', 'equals', 'custom' ),
					),
					array(
						'id' => 'blog_title_content_bg_color',
						'type' => 'select',
						'title' => esc_html__( 'Content Background Color', 'impeka' ),
						'subtitle'    => esc_html__( 'Background Color for your title content.', 'impeka' ),
						'options' => $content_bg_color_selection_extra,
						'default' => 'none',
					),
					array(
						'id'       => 'blog_title_content_bg_color_custom',
						'type'     => 'color',
						'title'    => esc_html__( 'Custom Content Background Color', 'impeka' ),
						'transparent' => false,
						'default'  => '#ffffff',
						'required' => array( 'blog_title_content_bg_color', 'equals', 'custom' ),
					),
					array(
						'id' => 'blog_title_color',
						'type' => 'select',
						'title' => esc_html__( 'Title Color', 'impeka' ),
						'subtitle'    => esc_html__( 'Color for your blog title.', 'impeka' ),
						'options' => $color_selection_extra,
						'default' => 'black',
					),
					array(
						'id'       => 'blog_title_color_custom',
						'type'     => 'color',
						'title'    => esc_html__( 'Custom Title Color', 'impeka' ),
						'transparent' => false,
						'default'  => '#000000',
						'required' => array( 'blog_title_color', 'equals', 'custom' ),
					),
					array(
						'id' => 'blog_description_color',
						'type' => 'select',
						'title' => esc_html__( 'Description Color', 'impeka' ),
						'subtitle'    => esc_html__( 'Color for your blog description.', 'impeka' ),
						'options' => $color_selection_extra,
						'default' => 'black',
					),
					array(
						'id'       => 'blog_description_color_custom',
						'type'     => 'color',
						'title'    => esc_html__( 'Custom Description Color', 'impeka' ),
						'transparent' => false,
						'default'  => '#9B9B9B',
						'required' => array( 'blog_description_color', 'equals', 'custom' ),
					),
				)
			);

			$this->sections[] = array(
				'title' => esc_html__( 'Colors - Post Title', 'impeka' ),
				'id' => 'grve_redux_section_colors_post_title',
				'header' => '',
				'desc' => esc_html__( 'Set the background color for the single post title area and the color of the post title. Notice that you can disable it, override it or even use the feature section when you edit your single posts.', 'impeka' ),
				'icon_class' => 'el-icon-large',
				'icon' => 'el-icon-brush',
				'submenu' => false,
				'panel' => false,
				'grve_colors' => true,
				'subsection' => true,
				'fields' => array(
					array(
						'id' => 'post_title_bg_color',
						'type' => 'select',
						'title' => esc_html__( 'Background Color', 'impeka' ),
						'subtitle'    => esc_html__( 'Background color for your post title.', 'impeka' ),
						'options' => $bg_color_selection_extra,
						'default' => 'white',
					),
					array(
						'id'       => 'post_title_bg_color_custom',
						'type'     => 'color',
						'title'    => esc_html__( 'Custom Background Color', 'impeka' ),
						'transparent' => false,
						'default'  => '#f7f7fb',
						'required' => array( 'post_title_bg_color', 'equals', 'custom' ),
					),
					array(
						'id' => 'post_title_content_bg_color',
						'type' => 'select',
						'title' => esc_html__( 'Content Background Color', 'impeka' ),
						'subtitle'    => esc_html__( 'Background Color for your title content.', 'impeka' ),
						'options' => $content_bg_color_selection_extra,
						'default' => 'none',
					),
					array(
						'id'       => 'post_title_content_bg_color_custom',
						'type'     => 'color',
						'title'    => esc_html__( 'Custom Content Background Color', 'impeka' ),
						'transparent' => false,
						'default'  => '#ffffff',
						'required' => array( 'post_title_content_bg_color', 'equals', 'custom' ),
					),
					array(
						'id' => 'post_subheading_color',
						'type' => 'select',
						'title' => esc_html__( 'Categories/Meta Color', 'impeka' ),
						'subtitle'    => esc_html__( 'Color for your post categories/meta.', 'impeka' ),
						'options' => $color_selection_extra,
						'default' => 'black',
					),
					array(
						'id'       => 'post_subheading_color_custom',
						'type'     => 'color',
						'title'    => esc_html__( 'Meta Title Color', 'impeka' ),
						'transparent' => false,
						'default'  => '#ffffff',
						'required' => array( 'post_subheading_color', 'equals', 'custom' ),
					),
					array(
						'id' => 'post_title_color',
						'type' => 'select',
						'title' => esc_html__( 'Title Color', 'impeka' ),
						'subtitle'    => esc_html__( 'Color for your post title.', 'impeka' ),
						'options' => $color_selection_extra,
						'default' => 'black',
					),
					array(
						'id'       => 'post_title_color_custom',
						'type'     => 'color',
						'title'    => esc_html__( 'Custom Title Color', 'impeka' ),
						'transparent' => false,
						'default'  => '#000000',
						'required' => array( 'post_title_color', 'equals', 'custom' ),
					),
					array(
						'id' => 'post_description_color',
						'type' => 'select',
						'title' => esc_html__( 'Description Color', 'impeka' ),
						'subtitle'    => esc_html__( 'Color for your post description.', 'impeka' ),
						'options' => $color_selection_extra,
						'default' => 'white',
					),
					array(
						'id'       => 'post_description_color_custom',
						'type'     => 'color',
						'title'    => esc_html__( 'Custom Description Color', 'impeka' ),
						'transparent' => false,
						'default'  => '#9B9B9B',
						'required' => array( 'post_description_color', 'equals', 'custom' ),
					),
				)
			);

			$this->sections[] = array(
				'title' => esc_html__( 'Colors - Post Navigation', 'impeka' ),
				'id' => 'grve_redux_section_colors_post_bar',
				'header' => '',
				'desc' => esc_html__( 'Set the colors for the navigation area in the single post.', 'impeka' ),
				'icon_class' => 'el-icon-large',
				'icon' => 'el-icon-brush',
				'submenu' => false,
				'panel' => false,
				'grve_colors' => true,
				'subsection' => true,
				'fields' => array(
					array(
						'id'       => 'post_bar_background_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Background Color', 'impeka' ),
						'subtitle' => esc_html__( 'Background color for the post bar.', 'impeka' ),
						'default'  => '#f7f7fb',
						'transparent' => false,
					),
					array(
						'id'       => 'post_bar_nav_text_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Navigation Titles Color', 'impeka' ),
						'subtitle' => esc_html__( 'Color for the Navigation Titles.', 'impeka' ),
						'default'  => '#000000',
						'transparent' => false,
					),
				)
			);

			$this->sections[] = array(
				'icon' => 'el-icon-brush',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( 'Colors - Page', 'impeka' ),
				'id' => 'grve_redux_section_colors_page',
				'desc' => esc_html__( 'Set your color preferences for your page.', 'impeka' ),
				'submenu' => false,
				'panel' => false,
				'grve_colors' => true,
				'subsection' => false,
				'fields' => array(
				),
			);

			$this->sections[] = array(
				'title' => esc_html__( 'Colors - Page Title', 'impeka' ),
				'id' => 'grve_redux_section_colors_page_title',
				'header' => '',
				'desc' => esc_html__( 'Set the background color for the predefined page title area and the color of the page title. Notice that you can disable it, override it or even use the feature section when you edit your single pages.', 'impeka' ),
				'icon_class' => 'el-icon-large',
				'icon' => 'el-icon-brush',
				'submenu' => false,
				'panel' => false,
				'grve_colors' => true,
				'subsection' => true,
				'fields' => array(
					array(
						'id' => 'page_title_bg_color',
						'type' => 'select',
						'title' => esc_html__( 'Background Color', 'impeka' ),
						'subtitle'    => esc_html__( 'Background color for your page title.', 'impeka' ),
						'options' => $bg_color_selection_extra,
						'default' => 'white',
					),
					array(
						'id'       => 'page_title_bg_color_custom',
						'type'     => 'color',
						'title'    => esc_html__( 'Custom Background Color', 'impeka' ),
						'transparent' => false,
						'default'  => '#f7f7fb',
						'required' => array( 'page_title_bg_color', 'equals', 'custom' ),
					),
					array(
						'id' => 'page_title_content_bg_color',
						'type' => 'select',
						'title' => esc_html__( 'Content Background Color', 'impeka' ),
						'subtitle'    => esc_html__( 'Background Color for your title content.', 'impeka' ),
						'options' => $content_bg_color_selection_extra,
						'default' => 'none',
					),
					array(
						'id'       => 'page_title_content_bg_color_custom',
						'type'     => 'color',
						'title'    => esc_html__( 'Custom Content Background Color', 'impeka' ),
						'transparent' => false,
						'default'  => '#ffffff',
						'required' => array( 'page_title_content_bg_color', 'equals', 'custom' ),
					),
					array(
						'id' => 'page_title_color',
						'type' => 'select',
						'title' => esc_html__( 'Title Color', 'impeka' ),
						'subtitle'    => esc_html__( 'Color for your page title.', 'impeka' ),
						'options' => $color_selection_extra,
						'default' => 'black',
					),
					array(
						'id'       => 'page_title_color_custom',
						'type'     => 'color',
						'title'    => esc_html__( 'Custom Title Color', 'impeka' ),
						'transparent' => false,
						'default'  => '#000000',
						'required' => array( 'page_title_color', 'equals', 'custom' ),
					),
					array(
						'id' => 'page_description_color',
						'type' => 'select',
						'title' => esc_html__( 'Description Color', 'impeka' ),
						'subtitle'    => esc_html__( 'Color for your page description.', 'impeka' ),
						'options' => $color_selection_extra,
						'default' => 'black',
					),
					array(
						'id'       => 'page_description_color_custom',
						'type'     => 'color',
						'title'    => esc_html__( 'Custom Description Color', 'impeka' ),
						'transparent' => false,
						'default'  => '#9B9B9B',
						'required' => array( 'page_description_color', 'equals', 'custom' ),
					),
				)
			);

			$this->sections[] = array(
				'icon' => 'el-icon-brush',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( 'Colors - Search Page', 'impeka' ),
				'id' => 'grve_redux_section_colors_search_page',
				'desc' => esc_html__( 'Set your color preferences for your search page.', 'impeka' ),
				'submenu' => false,
				'panel' => false,
				'grve_colors' => true,
				'subsection' => false,
				'fields' => array(
				),
			);
			$this->sections[] = array(
				'title' => esc_html__( 'Colors - Search Page Title', 'impeka' ),
				'id' => 'grve_redux_section_colors_search_page_title',
				'header' => '',
				'desc' => esc_html__( 'Set the background color for the search page title area and the color of the page title.', 'impeka' ),
				'icon_class' => 'el-icon-large',
				'icon' => 'el-icon-brush',
				'submenu' => false,
				'panel' => false,
				'grve_colors' => true,
				'subsection' => true,
				'fields' => array(
					array(
						'id' => 'search_page_title_bg_color',
						'type' => 'select',
						'title' => esc_html__( 'Background Color', 'impeka' ),
						'subtitle'    => esc_html__( 'Background color for your page title.', 'impeka' ),
						'options' => $bg_color_selection_extra,
						'default' => 'white',
					),
					array(
						'id'       => 'search_page_title_bg_color_custom',
						'type'     => 'color',
						'title'    => esc_html__( 'Custom Background Color', 'impeka' ),
						'transparent' => false,
						'default'  => '#f7f7fb',
						'required' => array( 'search_page_title_bg_color', 'equals', 'custom' ),
					),
					array(
						'id' => 'search_page_title_content_bg_color',
						'type' => 'select',
						'title' => esc_html__( 'Content Background Color', 'impeka' ),
						'subtitle'    => esc_html__( 'Background Color for your title content.', 'impeka' ),
						'options' => $content_bg_color_selection_extra,
						'default' => 'none',
					),
					array(
						'id'       => 'search_page_title_content_bg_color_custom',
						'type'     => 'color',
						'title'    => esc_html__( 'Custom Content Background Color', 'impeka' ),
						'transparent' => false,
						'default'  => '#ffffff',
						'required' => array( 'search_page_title_content_bg_color', 'equals', 'custom' ),
					),
					array(
						'id' => 'search_page_title_color',
						'type' => 'select',
						'title' => esc_html__( 'Title Color', 'impeka' ),
						'subtitle'    => esc_html__( 'Color for your page title.', 'impeka' ),
						'options' => $color_selection_extra,
						'default' => 'black',
					),
					array(
						'id'       => 'search_page_title_color_custom',
						'type'     => 'color',
						'title'    => esc_html__( 'Custom Title Color', 'impeka' ),
						'transparent' => false,
						'default'  => '#000000',
						'required' => array( 'search_page_title_color', 'equals', 'custom' ),
					),
					array(
						'id' => 'search_page_description_color',
						'type' => 'select',
						'title' => esc_html__( 'Description Color', 'impeka' ),
						'subtitle'    => esc_html__( 'Color for your page description.', 'impeka' ),
						'options' => $color_selection_extra,
						'default' => 'black',
					),
					array(
						'id'       => 'search_page_description_color_custom',
						'type'     => 'color',
						'title'    => esc_html__( 'Custom Description Color', 'impeka' ),
						'transparent' => false,
						'default'  => '#9B9B9B',
						'required' => array( 'search_page_description_color', 'equals', 'custom' ),
					),
				)
			);

			$this->sections[] = array(
				'icon' => 'el-icon-brush',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( 'Colors - Portfolio', 'impeka' ),
				'id' => 'grve_redux_section_colors_portfolio',
				'desc' => esc_html__( 'Set your color preferences for your portfolio.', 'impeka' ),
				'submenu' => false,
				'panel' => false,
				'grve_colors' => true,
				'subsection' => false,
				'fields' => array(
				),
			);

			$this->sections[] = array(
				'title' => esc_html__( 'Colors - Portfolio Title', 'impeka' ),
				'id' => 'grve_redux_section_colors_portfolio_title',
				'header' => '',
				'desc' => esc_html__( 'Set the background color for the single portfolio title area and the color of the portfolio title and description. Notice that you can disable it, override it or even use the feature section when you edit your single portfolio items.', 'impeka' ),
				'icon_class' => 'el-icon-large',
				'icon' => 'el-icon-brush',
				'submenu' => false,
				'panel' => false,
				'grve_colors' => true,
				'subsection' => true,
				'fields' => array(
					array(
						'id' => 'portfolio_title_bg_color',
						'type' => 'select',
						'title' => esc_html__( 'Background Color', 'impeka' ),
						'subtitle'    => esc_html__( 'Background color for your portfolio title.', 'impeka' ),
						'options' => $bg_color_selection_extra,
						'default' => 'white',
					),
					array(
						'id'       => 'portfolio_title_bg_color_custom',
						'type'     => 'color',
						'title'    => esc_html__( 'Custom Background Color', 'impeka' ),
						'transparent' => false,
						'default'  => '#f7f7fb',
						'required' => array( 'portfolio_title_bg_color', 'equals', 'custom' ),
					),
					array(
						'id' => 'portfolio_title_content_bg_color',
						'type' => 'select',
						'title' => esc_html__( 'Content Background Color', 'impeka' ),
						'subtitle'    => esc_html__( 'Background Color for your title content.', 'impeka' ),
						'options' => $content_bg_color_selection_extra,
						'default' => 'none',
					),
					array(
						'id'       => 'portfolio_title_content_bg_color_custom',
						'type'     => 'color',
						'title'    => esc_html__( 'Custom Content Background Color', 'impeka' ),
						'transparent' => false,
						'default'  => '#ffffff',
						'required' => array( 'portfolio_title_content_bg_color', 'equals', 'custom' ),
					),
					array(
						'id' => 'portfolio_subheading_color',
						'type' => 'select',
						'title' => esc_html__( 'Categories/Meta Color', 'impeka' ),
						'subtitle'    => esc_html__( 'Color for your post categories/meta.', 'impeka' ),
						'options' => $color_selection_extra,
						'default' => 'black',
					),
					array(
						'id'       => 'portfolio_subheading_color_custom',
						'type'     => 'color',
						'title'    => esc_html__( 'Meta Title Color', 'impeka' ),
						'transparent' => false,
						'default'  => '#ffffff',
						'required' => array( 'portfolio_subheading_color', 'equals', 'custom' ),
					),
					array(
						'id' => 'portfolio_title_color',
						'type' => 'select',
						'title' => esc_html__( 'Title Color', 'impeka' ),
						'subtitle'    => esc_html__( 'Color for your portfolio title.', 'impeka' ),
						'options' => $color_selection_extra,
						'default' => 'black',
					),
					array(
						'id'       => 'portfolio_title_color_custom',
						'type'     => 'color',
						'title'    => esc_html__( 'Custom Title Color', 'impeka' ),
						'transparent' => false,
						'default'  => '#000000',
						'required' => array( 'portfolio_title_color', 'equals', 'custom' ),
					),
					array(
						'id' => 'portfolio_description_color',
						'type' => 'select',
						'title' => esc_html__( 'Description Color', 'impeka' ),
						'subtitle'    => esc_html__( 'Color for your portfolio description.', 'impeka' ),
						'options' => $color_selection_extra,
						'default' => 'black',
					),
					array(
						'id'       => 'portfolio_description_color_custom',
						'type'     => 'color',
						'title'    => esc_html__( 'Custom Description Color', 'impeka' ),
						'transparent' => false,
						'default'  => '#9B9B9B',
						'required' => array( 'portfolio_description_color', 'equals', 'custom' ),
					),
				)
			);

			$this->sections[] = array(
				'title' => esc_html__( 'Colors - Portfolio Taxonomy Title', 'impeka' ),
				'id' => 'grve_redux_section_colors_portfolio_tax_title',
				'header' => '',
				'desc' => esc_html__( 'Set the background color for the portfolio archive and the color of the portfolio taxonomies title and description.', 'impeka' ),
				'icon_class' => 'el-icon-large',
				'icon' => 'el-icon-brush',
				'submenu' => false,
				'panel' => false,
				'grve_colors' => true,
				'subsection' => true,
				'fields' => array(
					array(
						'id' => 'portfolio_tax_title_bg_color',
						'type' => 'select',
						'title' => esc_html__( 'Background Color', 'impeka' ),
						'subtitle'    => esc_html__( 'Background color for your title.', 'impeka' ),
						'options' => $bg_color_selection_extra,
						'default' => 'white',
					),
					array(
						'id'       => 'portfolio_tax_title_bg_color_custom',
						'type'     => 'color',
						'title'    => esc_html__( 'Custom Background Color', 'impeka' ),
						'transparent' => false,
						'default'  => '#f7f7fb',
						'required' => array( 'portfolio_tax_title_bg_color', 'equals', 'custom' ),
					),
					array(
						'id' => 'portfolio_tax_title_content_bg_color',
						'type' => 'select',
						'title' => esc_html__( 'Content Background Color', 'impeka' ),
						'subtitle'    => esc_html__( 'Background Color for your title content.', 'impeka' ),
						'options' => $content_bg_color_selection_extra,
						'default' => 'none',
					),
					array(
						'id'       => 'portfolio_tax_title_content_bg_color_custom',
						'type'     => 'color',
						'title'    => esc_html__( 'Custom Content Background Color', 'impeka' ),
						'transparent' => false,
						'default'  => '#ffffff',
						'required' => array( 'portfolio_tax_title_content_bg_color', 'equals', 'custom' ),
					),
					array(
						'id' => 'portfolio_tax_title_color',
						'type' => 'select',
						'title' => esc_html__( 'Title Color', 'impeka' ),
						'subtitle'    => esc_html__( 'Color for your title.', 'impeka' ),
						'options' => $color_selection_extra,
						'default' => 'black',
					),
					array(
						'id'       => 'portfolio_tax_title_color_custom',
						'type'     => 'color',
						'title'    => esc_html__( 'Custom Title Color', 'impeka' ),
						'transparent' => false,
						'default'  => '#ffffff',
						'required' => array( 'portfolio_tax_title_color', 'equals', 'custom' ),
					),
					array(
						'id' => 'portfolio_tax_description_color',
						'type' => 'select',
						'title' => esc_html__( 'Description Color', 'impeka' ),
						'subtitle'    => esc_html__( 'Color for your description.', 'impeka' ),
						'options' => $color_selection_extra,
						'default' => 'black',
					),
					array(
						'id'       => 'portfolio_tax_description_color_custom',
						'type'     => 'color',
						'title'    => esc_html__( 'Custom Description Color', 'impeka' ),
						'transparent' => false,
						'default'  => '#ffffff',
						'required' => array( 'portfolio_tax_description_color', 'equals', 'custom' ),
					),
				)
			);

			$this->sections[] = array(
				'title' => esc_html__( 'Colors - Portfolio Navigation', 'impeka' ),
				'id' => 'grve_redux_section_colors_portfolio_bar',
				'header' => '',
				'desc' => esc_html__( 'Set the colors for the navigation area in the single portfolio.', 'impeka' ),
				'icon_class' => 'el-icon-large',
				'icon' => 'el-icon-brush',
				'submenu' => false,
				'panel' => false,
				'grve_colors' => true,
				'subsection' => true,
				'fields' => array(
					array(
						'id'       => 'portfolio_bar_background_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Background Color', 'impeka' ),
						'subtitle' => esc_html__( 'Background color for the portfolio bar.', 'impeka' ),
						'default'  => '#f7f7fb',
						'transparent' => true,
					),
					array(
						'id'       => 'portfolio_bar_nav_text_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Navigation Titles Color', 'impeka' ),
						'subtitle' => esc_html__( 'Color for the Navigation Titles.', 'impeka' ),
						'default'  => '#000000',
						'transparent' => false,
					),
				)
			);
			$this->sections[] = array(
				'icon' => 'el-icon-brush',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( 'Colors - Shop/Product', 'impeka' ),
				'id' => 'grve_redux_section_colors_shop_product',
				'desc' => esc_html__( 'Set your color preferences for your Shop/Product.', 'impeka' ),
				'submenu' => false,
				'panel' => false,
				'grve_colors' => true,
				'subsection' => false,
				'fields' => array(
				),
			);

			$this->sections[] = array(
				'title' => esc_html__( 'Colors - Product Taxonomy Title', 'impeka' ),
				'id' => 'grve_redux_section_colors_product_tax_title',
				'header' => '',
				'desc' => esc_html__( 'Set the background color for the product taxonomies title area and the color of the product taxonomies title and description.', 'impeka' ),
				'icon_class' => 'el-icon-large',
				'icon' => 'el-icon-brush',
				'submenu' => false,
				'panel' => false,
				'grve_colors' => true,
				'subsection' => true,
				'fields' => array(
					array(
						'id' => 'product_tax_title_bg_color',
						'type' => 'select',
						'title' => esc_html__( 'Background Color', 'impeka' ),
						'subtitle'    => esc_html__( 'Background color for your title.', 'impeka' ),
						'options' => $bg_color_selection_extra,
						'default' => 'white',
					),
					array(
						'id'       => 'product_tax_title_bg_color_custom',
						'type'     => 'color',
						'title'    => esc_html__( 'Custom Background Color', 'impeka' ),
						'transparent' => false,
						'default'  => '#f7f7fb',
						'required' => array( 'product_tax_title_bg_color', 'equals', 'custom' ),
					),
					array(
						'id' => 'product_tax_title_content_bg_color',
						'type' => 'select',
						'title' => esc_html__( 'Content Background Color', 'impeka' ),
						'subtitle'    => esc_html__( 'Background Color for your title content.', 'impeka' ),
						'options' => $content_bg_color_selection_extra,
						'default' => 'none',
					),
					array(
						'id'       => 'product_tax_title_content_bg_color_custom',
						'type'     => 'color',
						'title'    => esc_html__( 'Custom Content Background Color', 'impeka' ),
						'transparent' => false,
						'default'  => '#ffffff',
						'required' => array( 'product_tax_title_content_bg_color', 'equals', 'custom' ),
					),
					array(
						'id' => 'product_tax_title_color',
						'type' => 'select',
						'title' => esc_html__( 'Title Color', 'impeka' ),
						'subtitle'    => esc_html__( 'Color for your title.', 'impeka' ),
						'options' => $color_selection_extra,
						'default' => 'black',
					),
					array(
						'id'       => 'product_tax_title_color_custom',
						'type'     => 'color',
						'title'    => esc_html__( 'Custom Title Color', 'impeka' ),
						'transparent' => false,
						'default'  => '#ffffff',
						'required' => array( 'product_tax_title_color', 'equals', 'custom' ),
					),
					array(
						'id' => 'product_tax_description_color',
						'type' => 'select',
						'title' => esc_html__( 'Description Color', 'impeka' ),
						'subtitle'    => esc_html__( 'Color for your description.', 'impeka' ),
						'options' => $color_selection_extra,
						'default' => 'black',
					),
					array(
						'id'       => 'product_tax_description_color_custom',
						'type'     => 'color',
						'title'    => esc_html__( 'Custom Description Color', 'impeka' ),
						'transparent' => false,
						'default'  => '#ffffff',
						'required' => array( 'product_tax_description_color', 'equals', 'custom' ),
					),
				)
			);

			$this->sections[] = array(
				'title' => esc_html__( 'Colors - Product Title', 'impeka' ),
				'id' => 'grve_redux_section_colors_product_title',
				'header' => '',
				'desc' => esc_html__( 'Set the background color for the single product title area and the color of the product title and description. Notice that you can disable it, override it or even use the feature section when you edit your single product items.', 'impeka' ),
				'icon_class' => 'el-icon-large',
				'icon' => 'el-icon-brush',
				'submenu' => false,
				'panel' => false,
				'grve_colors' => true,
				'subsection' => true,
				'fields' => array(
					array(
						'id' => 'product_title_bg_color',
						'type' => 'select',
						'title' => esc_html__( 'Background Color', 'impeka' ),
						'subtitle'    => esc_html__( 'Background color for your title.', 'impeka' ),
						'options' => $bg_color_selection_extra,
						'default' => 'white',
					),
					array(
						'id'       => 'product_title_bg_color_custom',
						'type'     => 'color',
						'title'    => esc_html__( 'Custom Background Color', 'impeka' ),
						'transparent' => false,
						'default'  => '#f7f7fb',
						'required' => array( 'product_title_bg_color', 'equals', 'custom' ),
					),
					array(
						'id' => 'product_title_content_bg_color',
						'type' => 'select',
						'title' => esc_html__( 'Content Background Color', 'impeka' ),
						'subtitle'    => esc_html__( 'Background Color for your title content.', 'impeka' ),
						'options' => $content_bg_color_selection_extra,
						'default' => 'none',
					),
					array(
						'id'       => 'product_title_content_bg_color_custom',
						'type'     => 'color',
						'title'    => esc_html__( 'Custom Content Background Color', 'impeka' ),
						'transparent' => false,
						'default'  => '#ffffff',
						'required' => array( 'product_title_content_bg_color', 'equals', 'custom' ),
					),
					array(
						'id' => 'product_title_color',
						'type' => 'select',
						'title' => esc_html__( 'Title Color', 'impeka' ),
						'subtitle'    => esc_html__( 'Color for your title.', 'impeka' ),
						'options' => $color_selection_extra,
						'default' => 'black',
					),
					array(
						'id'       => 'product_title_color_custom',
						'type'     => 'color',
						'title'    => esc_html__( 'Custom Title Color', 'impeka' ),
						'transparent' => false,
						'default'  => '#ffffff',
						'required' => array( 'product_title_color', 'equals', 'custom' ),
					),
					array(
						'id' => 'product_description_color',
						'type' => 'select',
						'title' => esc_html__( 'Description Color', 'impeka' ),
						'subtitle'    => esc_html__( 'Color for your description.', 'impeka' ),
						'options' => $color_selection_extra,
						'default' => 'black',
					),
					array(
						'id'       => 'product_description_color_custom',
						'type'     => 'color',
						'title'    => esc_html__( 'Custom Description Color', 'impeka' ),
						'transparent' => false,
						'default'  => '#9B9B9B',
						'required' => array( 'product_description_color', 'equals', 'custom' ),
					),
				)
			);
			$this->sections[] = array(
				'title' => esc_html__( 'Colors - Product Area', 'impeka' ),
				'id' => 'grve_redux_section_colors_product_area',
				'header' => '',
				'desc' => esc_html__( 'Set the colors for the single product content area. Notice that you can override it when you edit your single product items.', 'impeka' ),
				'icon_class' => 'el-icon-large',
				'icon' => 'el-icon-brush',
				'submenu' => false,
				'panel' => false,
				'grve_colors' => true,
				'subsection' => true,
				'fields' => array(
					array(
						'id'          => 'product_area_bg_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Background Color', 'impeka' ),
						'subtitle'    => esc_html__( 'Background color for your Product Area.', 'impeka' ),
						'default'     => '#ffffff',
						'transparent' => false,
					),
					array(
						'id'          => 'product_area_headings_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Headings Color', 'impeka' ),
						'subtitle'    => esc_html__( 'Headings color for your Product Area.', 'impeka' ),
						'default'     => '#000000',
						'transparent' => false,
					),
					array(
						'id'          => 'product_area_font_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Font Color', 'impeka' ),
						'subtitle'    => esc_html__( 'Font color for your Product Area.', 'impeka' ),
						'default'     => '#000000',
						'transparent' => false,
					),
					array(
						'id'          => 'product_area_link_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Link Color', 'impeka' ),
						'subtitle'    => esc_html__( 'Link color for your Product Area.', 'impeka' ),
						'default'     => '#000000',
						'transparent' => false,
					),
					array(
						'id'          => 'product_area_hover_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Hover Color', 'impeka' ),
						'subtitle'    => esc_html__( 'Hover color for your Product Area.', 'impeka' ),
						'default'     => '#FF4433',
						'transparent' => false,
					),
					array(
						'id'          => 'product_area_border_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Border Color', 'impeka' ),
						'subtitle'    => esc_html__( 'Border color for your Product Area.', 'impeka' ),
						'default'     => '#ECEFF4',
						'transparent' => false,
					),
					array(
						'id'=>'product_area_button_color',
						'type' => 'select',
						'title' => esc_html__( 'Button Color', 'impeka' ),
						'subtitle' => esc_html__( 'Select the color of your Product Area Buttons.', 'impeka' ),
						'options' => $button_color_selection,
						'default' => 'black',
						'validate' => 'not_empty',
					),
					array(
						'id'=>'product_area_button_hover_color',
						'type' => 'select',
						'title' => esc_html__( 'Button Hover Color', 'impeka' ),
						'subtitle' => esc_html__( 'Select the hover color of your Product Area Buttons.', 'impeka' ),
						'options' => $button_color_selection,
						'default' => 'dark-grey',
						'validate' => 'not_empty',
					),
				)
			);
			$this->sections[] = array(
				'title' => esc_html__( 'Colors - Product Navigation', 'impeka' ),
				'id' => 'grve_redux_section_colors_product_bar',
				'header' => '',
				'desc' => esc_html__( 'Set the colors for the navigation area in the single product.', 'impeka' ),
				'icon_class' => 'el-icon-large',
				'icon' => 'el-icon-brush',
				'submenu' => false,
				'panel' => false,
				'grve_colors' => true,
				'subsection' => true,
				'fields' => array(
					array(
						'id'       => 'product_bar_background_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Background Color', 'impeka' ),
						'subtitle' => esc_html__( 'Background color for the product bar.', 'impeka' ),
						'default'  => '#f7f7fb',
						'transparent' => false,
					),
					array(
						'id'       => 'product_bar_nav_text_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Navigation Titles Color', 'impeka' ),
						'subtitle' => esc_html__( 'Color for the Navigation Titles.', 'impeka' ),
						'default'  => '#000000',
						'transparent' => false,
					),
				)
			);
			$this->sections[] = array(
				'title' => esc_html__( 'Colors - Mini Cart', 'impeka' ),
				'id' => 'grve_redux_section_colors_mini_cart',
				'header' => '',
				'desc' => esc_html__( 'Set the colors for the mini cart area.', 'impeka' ),
				'icon_class' => 'el-icon-large',
				'icon' => 'el-icon-brush',
				'submenu' => false,
				'panel' => false,
				'grve_colors' => true,
				'subsection' => true,
				'fields' => array(
					array(
						'id'       => 'mini_cart_background_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Background Color', 'impeka' ),
						'subtitle' => esc_html__( 'Background color for the mini cart.', 'impeka' ),
						'default'  => '#ffffff',
						'transparent' => false,
					),
					array(
						'id'       => 'mini_cart_text_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Text Color', 'impeka' ),
						'subtitle' => esc_html__( 'Color for the mini cart.', 'impeka' ),
						'default'  => '#000000',
						'transparent' => false,
					),
					array(
						'id'       => 'mini_cart_border_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Border Color', 'impeka' ),
						'subtitle' => esc_html__( 'Border color for the mini cart.', 'impeka' ),
						'default'  => '#f7f7fb',
						'transparent' => false,
					),
					array(
						'id'=>'mini_cart_view_button_type',
						'type' => 'select',
						'title' => esc_html__( 'View Cart Button Type', 'impeka' ),
						'subtitle' => esc_html__( 'Select the type of your button.', 'impeka' ),
						'options' => $button_type_selection,
						'default' => 'outline',
					),
					array(
						'id'=>'mini_cart_view_button_shape',
						'type' => 'select',
						'title' => esc_html__( 'View Cart Button Shape', 'impeka' ),
						'subtitle' => esc_html__( 'Select the shape of your button.', 'impeka' ),
						'options' => $button_shape_selection,
						'default' => 'square',
					),
					array(
						'id'=>'mini_cart_view_button_color',
						'type' => 'select',
						'title' => esc_html__( 'View Cart Button Color', 'impeka' ),
						'subtitle' => esc_html__( 'Select the color of your button.', 'impeka' ),
						'options' => $button_color_selection,
						'default' => 'black',
					),
					array(
						'id'=>'mini_cart_view_button_hover_color',
						'type' => 'select',
						'title' => esc_html__( 'View Cart Button Hover Color', 'impeka' ),
						'subtitle' => esc_html__( 'Select the hover color of your button.', 'impeka' ),
						'options' => $button_color_selection,
						'default' => 'primary-1',
					),
					array(
						'id'=>'mini_cart_checkout_button_type',
						'type' => 'select',
						'title' => esc_html__( 'Checkout Button Type', 'impeka' ),
						'subtitle' => esc_html__( 'Select the type of your button.', 'impeka' ),
						'options' => $button_type_selection,
						'default' => 'simple',
					),
					array(
						'id'=>'mini_cart_checkout_button_shape',
						'type' => 'select',
						'title' => esc_html__( 'Checkout Button Shape', 'impeka' ),
						'subtitle' => esc_html__( 'Select the shape of your button.', 'impeka' ),
						'options' => $button_shape_selection,
						'default' => 'square',
					),
					array(
						'id'=>'mini_cart_checkout_button_color',
						'type' => 'select',
						'title' => esc_html__( 'Checkout Button Color', 'impeka' ),
						'subtitle' => esc_html__( 'Select the color of your button.', 'impeka' ),
						'options' => $button_color_selection,
						'default' => 'black',
					),
					array(
						'id'=>'mini_cart_checkout_button_hover_color',
						'type' => 'select',
						'title' => esc_html__( 'Checkout Button Hover Color', 'impeka' ),
						'subtitle' => esc_html__( 'Select the hover color of your button.', 'impeka' ),
						'options' => $button_color_selection,
						'default' => 'primary-1',
					),
				)
			);
			$this->sections[] = array(
				'icon' => 'el-icon-brush',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( 'Colors - Events Calendar', 'impeka' ),
				'id' => 'grve_redux_section_colors_events_calendar',
				'desc' => esc_html__( 'Set your color preferences for your Events.', 'impeka' ),
				'submenu' => false,
				'panel' => false,
				'grve_colors' => true,
				'subsection' => false,
				'fields' => array(
				),
			);

			$this->sections[] = array(
				'title' => esc_html__( 'Colors - Event Title', 'impeka' ),
				'id' => 'grve_redux_section_colors_event_title',
				'header' => '',
				'desc' => esc_html__( 'Set the background color for the single event title area and the color of the event title and description. Notice that you can disable it, override it or even use the feature section when you edit your single event items.', 'impeka' ),
				'icon_class' => 'el-icon-large',
				'icon' => 'el-icon-brush',
				'submenu' => false,
				'panel' => false,
				'grve_colors' => true,
				'subsection' => true,
				'fields' => array(
					array(
						'id' => 'event_title_bg_color',
						'type' => 'select',
						'title' => esc_html__( 'Background Color', 'impeka' ),
						'subtitle'    => esc_html__( 'Background color for your title.', 'impeka' ),
						'options' => $bg_color_selection_extra,
						'default' => 'white',
					),
					array(
						'id'       => 'event_title_bg_color_custom',
						'type'     => 'color',
						'title'    => esc_html__( 'Custom Background Color', 'impeka' ),
						'transparent' => false,
						'default'  => '#f7f7fb',
						'required' => array( 'event_title_bg_color', 'equals', 'custom' ),
					),
					array(
						'id' => 'event_title_content_bg_color',
						'type' => 'select',
						'title' => esc_html__( 'Content Background Color', 'impeka' ),
						'subtitle'    => esc_html__( 'Background Color for your title content.', 'impeka' ),
						'options' => $content_bg_color_selection_extra,
						'default' => 'none',
					),
					array(
						'id'       => 'event_title_content_bg_color_custom',
						'type'     => 'color',
						'title'    => esc_html__( 'Custom Content Background Color', 'impeka' ),
						'transparent' => false,
						'default'  => '#ffffff',
						'required' => array( 'event_title_content_bg_color', 'equals', 'custom' ),
					),
					array(
						'id' => 'event_title_color',
						'type' => 'select',
						'title' => esc_html__( 'Title Color', 'impeka' ),
						'subtitle'    => esc_html__( 'Color for your title.', 'impeka' ),
						'options' => $color_selection_extra,
						'default' => 'black',
					),
					array(
						'id'       => 'event_title_color_custom',
						'type'     => 'color',
						'title'    => esc_html__( 'Custom Title Color', 'impeka' ),
						'transparent' => false,
						'default'  => '#000000',
						'required' => array( 'event_title_color', 'equals', 'custom' ),
					),
					array(
						'id' => 'event_description_color',
						'type' => 'select',
						'title' => esc_html__( 'Description Color', 'impeka' ),
						'subtitle'    => esc_html__( 'Color for your description.', 'impeka' ),
						'options' => $color_selection_extra,
						'default' => 'black',
					),
					array(
						'id'       => 'event_description_color_custom',
						'type'     => 'color',
						'title'    => esc_html__( 'Custom Description Color', 'impeka' ),
						'transparent' => false,
						'default'  => '#9B9B9B',
						'required' => array( 'event_description_color', 'equals', 'custom' ),
					),
				)
			);

			$this->sections[] = array(
				'title' => esc_html__( 'Colors - Event Navigation', 'impeka' ),
				'id' => 'grve_redux_section_colors_event_bar',
				'header' => '',
				'desc' => esc_html__( 'Set the colors for the navigation area in the single event.', 'impeka' ),
				'icon_class' => 'el-icon-large',
				'icon' => 'el-icon-brush',
				'submenu' => false,
				'panel' => false,
				'grve_colors' => true,
				'subsection' => true,
				'fields' => array(
					array(
						'id'       => 'event_bar_background_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Background Color', 'impeka' ),
						'subtitle' => esc_html__( 'Background color for the event bar.', 'impeka' ),
						'default'  => '#f7f7fb',
						'transparent' => false,
					),
					array(
						'id'       => 'event_bar_nav_text_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Navigation Titles Color', 'impeka' ),
						'subtitle' => esc_html__( 'Color for the Navigation Titles.', 'impeka' ),
						'default'  => '#000000',
						'transparent' => false,
					),
				)
			);

			$this->sections[] = array(
				'icon' => 'el-icon-brush',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( 'Colors - bbPress Forum', 'impeka' ),
				'id' => 'grve_redux_section_colors_bbpress',
				'desc' => esc_html__( 'Set your color preferences for your Forum.', 'impeka' ),
				'submenu' => false,
				'panel' => false,
				'grve_colors' => true,
				'subsection' => false,
				'fields' => array(
				),
			);

			$this->sections[] = array(
				'title' => esc_html__( 'Colors - Forum Title', 'impeka' ),
				'id' => 'grve_redux_section_colors_forum_title',
				'header' => '',
				'desc' => esc_html__( 'Set the background color for the forum title area.', 'impeka' ),
				'icon_class' => 'el-icon-large',
				'icon' => 'el-icon-brush',
				'submenu' => false,
				'panel' => false,
				'grve_colors' => true,
				'subsection' => true,
				'fields' => array(
					array(
						'id' => 'forum_title_bg_color',
						'type' => 'select',
						'title' => esc_html__( 'Background Color', 'impeka' ),
						'subtitle'    => esc_html__( 'Background color for your title.', 'impeka' ),
						'options' => $bg_color_selection_extra,
						'default' => 'white',
					),
					array(
						'id'       => 'forum_title_bg_color_custom',
						'type'     => 'color',
						'title'    => esc_html__( 'Custom Background Color', 'impeka' ),
						'transparent' => false,
						'default'  => '#000000',
						'required' => array( 'forum_title_bg_color', 'equals', 'custom' ),
					),
					array(
						'id' => 'forum_title_content_bg_color',
						'type' => 'select',
						'title' => esc_html__( 'Content Background Color', 'impeka' ),
						'subtitle'    => esc_html__( 'Background Color for your title content.', 'impeka' ),
						'options' => $content_bg_color_selection_extra,
						'default' => 'none',
					),
					array(
						'id'       => 'forum_title_content_bg_color_custom',
						'type'     => 'color',
						'title'    => esc_html__( 'Custom Content Background Color', 'impeka' ),
						'transparent' => false,
						'default'  => '#ffffff',
						'required' => array( 'forum_title_content_bg_color', 'equals', 'custom' ),
					),
					array(
						'id' => 'forum_title_color',
						'type' => 'select',
						'title' => esc_html__( 'Title Color', 'impeka' ),
						'subtitle'    => esc_html__( 'Color for your title.', 'impeka' ),
						'options' => $color_selection_extra,
						'default' => 'black',
					),
					array(
						'id'       => 'forum_title_color_custom',
						'type'     => 'color',
						'title'    => esc_html__( 'Custom Title Color', 'impeka' ),
						'transparent' => false,
						'default'  => '#ffffff',
						'required' => array( 'forum_title_color', 'equals', 'custom' ),
					),
				)
			);

			$this->sections[] = array(
				'icon' => 'el-icon-brush',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( 'Colors - Footer', 'impeka' ),
				'id' => 'grve_redux_section_colors_footer',
				'desc' => esc_html__( 'Set your color preferences for your Footer.', 'impeka' ),
				'submenu' => false,
				'panel' => false,
				'grve_colors' => true,
				'subsection' => false,
				'fields' => array(
				),
			);
			$this->sections[] = array(
				'title' => esc_html__( 'Colors - Footer Area', 'impeka' ),
				'id' => 'grve_redux_section_colors_footer_area',
				'header' => '',
				'desc' => esc_html__( 'Set your color preferences for the Footer Area. Define the Footer Area in Theme Options > Footer Options.', 'impeka' ),
				'icon_class' => 'el-icon-large',
				'icon' => 'el-icon-brush',
				'submenu' => false,
				'panel' => false,
				'grve_colors' => true,
				'subsection' => true,
				'fields' => array(
					//Footer Area Color Settings
					array(
						'id'          => 'footer_widgets_bg_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Background Color', 'impeka' ),
						'subtitle'    => esc_html__( 'Background color for your Footer Area.', 'impeka' ),
						'default'     => '#000000',
						'transparent' => false,
					),
					array(
						'id'          => 'footer_widgets_headings_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Headings Color', 'impeka' ),
						'subtitle'    => esc_html__( 'Headings color for your Footer Area.', 'impeka' ),
						'default'     => '#ffffff',
						'transparent' => false,
					),
					array(
						'id'          => 'footer_widgets_font_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Font Color', 'impeka' ),
						'subtitle'    => esc_html__( 'Font color for your Footer Area.', 'impeka' ),
						'default'     => '#ffffff',
						'transparent' => false,
					),
					array(
						'id'          => 'footer_widgets_link_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Link Color', 'impeka' ),
						'subtitle'    => esc_html__( 'Link color for your Footer Area.', 'impeka' ),
						'default'     => '#ffffff',
						'transparent' => false,
					),
					array(
						'id'          => 'footer_widgets_hover_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Hover Color', 'impeka' ),
						'subtitle'    => esc_html__( 'Hover color for your Footer Area.', 'impeka' ),
						'default'     => '#ff4433',
						'transparent' => false,
					),
					array(
						'id'          => 'footer_widgets_border_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Border Color', 'impeka' ),
						'subtitle'    => esc_html__( 'Border color for your Footer Area.', 'impeka' ),
						'default'     => '#1E1E1E',
						'transparent' => false,
					),
				)
			);

			$this->sections[] = array(
				'title' => esc_html__( 'Colors - Footer Bar Area', 'impeka' ),
				'id' => 'grve_redux_section_colors_footer_bar_area',
				'header' => '',
				'desc' => esc_html__( 'Set your color preferences for the Footer Bar Area(copyright area). Define the Footer Bar Area in Theme Options > Footer Options.', 'impeka' ),
				'icon_class' => 'el-icon-large',
				'icon' => 'el-icon-brush',
				'submenu' => false,
				'panel' => false,
				'grve_colors' => true,
				'subsection' => true,
				'fields' => array(
					//Footer Bar Color Settings
					array(
						'id'          => 'footer_bar_bg_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Background Color', 'impeka' ),
						'subtitle'    => esc_html__( 'Background color for your Footer Bar Area.', 'impeka' ),
						'default'     => '#000000',
						'transparent' => false,
					),
					array(
						'id'          => 'footer_bar_bg_color_opacity',
						'type'        => 'select',
						'title'       => esc_html__('Background Opacity', 'impeka' ),
						'subtitle'    => esc_html__( 'Select opacity for your Footer Bar Area.', 'impeka' ),
						'options'     => $opacity_selection,
						"default"     => '1',
					),
					array(
						'id'          => 'footer_bar_font_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Font Color', 'impeka' ),
						'subtitle'    => esc_html__( 'Font color for your Footer Bar Area.', 'impeka' ),
						'default'     => '#ffffff',
						'transparent' => false,
					),
					array(
						'id'          => 'footer_bar_link_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Link Color', 'impeka' ),
						'subtitle'    => esc_html__( 'Link color for your Footer Bar Area.', 'impeka' ),
						'default'     => '#ffffff',
						'transparent' => false,
					),
					array(
						'id'          => 'footer_bar_hover_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Hover Color', 'impeka' ),
						'subtitle'    => esc_html__( 'Hover color for your Footer Bar Area.', 'impeka' ),
						'default'     => '#ff4433',
						'transparent' => false,
					),
				)
			);
			$this->sections[] = array(
				'title' => esc_html__( 'Colors - Breadcrumbs', 'impeka' ),
				'id' => 'grve_redux_section_colors_breadcrumbs',
				'header' => '',
				'desc' => esc_html__( 'Set your color preferences for the Breadcrumbs in case you use then in any of your pages, posts or items.', 'impeka' ),
				'icon_class' => 'el-icon-large',
				'icon' => 'el-icon-brush',
				'submenu' => false,
				'panel' => false,
				'grve_colors' => true,
				'subsection' => false,
				'fields' => array(
					array(
						'id'       => 'page_breadcrumbs_background_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Background Color', 'impeka' ),
						'subtitle' => esc_html__( 'Background color for the Breadcrumbs.', 'impeka' ),
						'default'  => '#ffffff',
						'transparent' => false,
					),
					array(
						'id'       => 'page_breadcrumbs_text_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Font Color', 'impeka' ),
						'subtitle' => esc_html__( 'Font color for the Breadcrumbs.', 'impeka' ),
						'default'  => '#6e6e6e',
						'transparent' => false,
					),
					array(
						'id'       => 'page_breadcrumbs_text_hover_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Hover Text Color', 'impeka' ),
						'subtitle' => esc_html__( 'Hover color for the Breadcrumbs.', 'impeka' ),
						'default'  => '#FF4433',
						'transparent' => false,
					),
					array(
						'id'       => 'page_breadcrumbs_divider_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Divider Color', 'impeka' ),
						'subtitle' => esc_html__( 'Divider color for the Breadcrumbs.', 'impeka' ),
						'default'  => '#b2b2b2',
						'transparent' => false,
					),
					array(
						'id'       => 'page_breadcrumbs_border_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Border Color', 'impeka' ),
						'subtitle' => esc_html__( 'Border color for the Breadcrumbs.', 'impeka' ),
						'default'  => '#e0e0e0',
						'transparent' => false,
					),
				)
			);

			$this->sections[] = array(
				'icon' => 'el-icon-brush',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( 'Colors - Safe Button', 'impeka' ),
				'id' => 'grve_redux_section_colors_safe_button_area',
				'desc' => esc_html__( 'Set your color preferences for the Safe Button Area.', 'impeka' ),
				'submenu' => false,
				'panel' => false,
				'grve_colors' => true,
				'subsection' => false,
				'fields' => array(
					array(
						'id'       => 'safebutton_background_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Background Color', 'impeka' ),
						'subtitle' => esc_html__( 'Pick a background color for your Safe Button.', 'impeka' ),
						'default'  => '#ffffff',
						'transparent' => false,
					),
					array(
						'id'       => 'safebutton_overflow_background_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Overflow Background Color', 'impeka' ),
						'subtitle' => esc_html__( 'Pick a background color for the overflow area, when Safe Button opens.', 'impeka' ),
						'default'  => '#FF4433',
						'transparent' => false,
					),
				)
			);

			$this->sections[] = array(
				'icon' => 'el-icon-brush',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( 'Colors - Side Area', 'impeka' ),
				'id' => 'grve_redux_section_colors_side_area',
				'desc' => esc_html__( 'Set your color preferences for the side Area.', 'impeka' ),
				'submenu' => false,
				'panel' => false,
				'grve_colors' => true,
				'subsection' => false,
				'fields' => array(
					array(
						'id'       => 'side_area_background_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Background Color', 'impeka' ),
						'subtitle' => esc_html__( 'Pick a background color for the side area.', 'impeka' ),
						'default'  => '#ffffff',
						'transparent' => false,
					),
					array(
						'id'       => 'side_area_title_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Title Color', 'impeka' ),
						'subtitle' => esc_html__( 'Pick a color for the titles - headings (h1-h6) of the side area.', 'impeka' ),
						'default'  => '#000000',
						'transparent' => false,
					),
					array(
						'id'       => 'side_area_text_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Text Color', 'impeka' ),
						'subtitle' => esc_html__( 'Pick a color for the text of the side area.', 'impeka' ),
						'default'  => '#808080',
						'transparent' => false,
					),
					array(
						'id'       => 'side_area_link_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Link Color', 'impeka' ),
						'subtitle' => esc_html__( 'Pick a color for the links of the side area.', 'impeka' ),
						'default'  => '#808080',
						'transparent' => false,
					),
					array(
						'id'       => 'side_area_link_hover_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Hover Color', 'impeka' ),
						'subtitle' => esc_html__( 'Pick a color for the hovers of the side area.', 'impeka' ),
						'default'  => '#000000',
						'transparent' => false,
					),
					array(
						'id'       => 'side_area_close_btn_color',
						'type' => 'select',
						'title' => esc_html__( 'Close Buttons Color', 'impeka' ),
						'subtitle'=> esc_html__( 'Select a color for the close buttons of the side area.', 'impeka' ),
						'options' => array(
							'black' => esc_html__( 'Black', 'impeka' ),
							'white' => esc_html__( 'White', 'impeka' ),
						),
						'default' => 'white',
						'validate' => 'not_empty',
					),
					array(
						'id'       => 'side_area_border_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Border Color', 'impeka' ),
						'subtitle' => esc_html__( 'Pick a color for the borders of the side area.', 'impeka' ),
						'default'  => '#e9e9e9',
						'transparent' => false,
					),
					array(
						'id'       => 'side_area_overflow_background_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Overflow Background Color', 'impeka' ),
						'subtitle' => esc_html__( 'Pick a background color for the side area, when side area opens.', 'impeka' ),
						'default'  => '#000000',
						'transparent' => false,
					),
					array(
						'id' => 'side_area_overflow_background_color_opacity',
						'type' => 'select',
						'title' => esc_html__('Overflow Background Opacity', 'impeka' ),
						'subtitle'    => esc_html__( 'Select opacity for the side area, when side area opens.', 'impeka' ),
						'options' => $opacity_selection,
						"default" => '0',
					),
				)
			);

			$this->sections[] = array(
				'icon' => 'el-icon-brush',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( 'Colors - Modals', 'impeka' ),
				'id' => 'grve_redux_section_colors_modals',
				'desc' => esc_html__( 'Set your color preferences for the Modals.', 'impeka' ),
				'submenu' => false,
				'panel' => false,
				'grve_colors' => true,
				'subsection' => false,
				'fields' => array(
					array(
						'id'       => 'modal_overflow_background_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Overflow Background Color', 'impeka' ),
						'subtitle' => esc_html__( 'Pick a background color for the overflow area, when modal opens.', 'impeka' ),
						'default'  => '#000000',
						'transparent' => false,
					),
					array(
						'id' => 'modal_overflow_background_color_opacity',
						'type' => 'select',
						'title' => esc_html__('Overflow Background Opacity', 'impeka' ),
						'subtitle'    => esc_html__( 'Select opacity for the overflow area, when modal opens.', 'impeka' ),
						'options' => $opacity_selection,
						"default" => '1',
					),
				)
			);

			$this->sections[] = array(
				'icon' => 'el-icon-brush',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( 'Colors - Quick View', 'impeka' ),
				'id' => 'grve_redux_section_colors_quick_view',
				'desc' => esc_html__( 'Set your color preferences for the Quick View Modal.', 'impeka' ),
				'submenu' => false,
				'panel' => false,
				'grve_colors' => true,
				'subsection' => false,
				'fields' => array(
					array(
						'id'       => 'quick_view_title_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Title Color', 'impeka' ),
						'subtitle' => esc_html__( 'Pick a color for the titles - headings (h1-h6) of the quick view modal.', 'impeka' ),
						'default'  => '#ffffff',
						'transparent' => false,
					),
					array(
						'id'       => 'quick_view_text_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Text Color', 'impeka' ),
						'subtitle' => esc_html__( 'Pick a color for the text of the quick view modal.', 'impeka' ),
						'default'  => '#ffffff',
						'transparent' => false,
					),
					array(
						'id' => 'quick_view_close_color',
						'type' => 'select',
						'title' => esc_html__( 'Close Button Color', 'impeka' ),
						'subtitle'=> esc_html__( 'Select a color for close button of the quick view modal.', 'impeka' ),
						'options' => array(
							'black' => esc_html__( 'Black', 'impeka' ),
							'white' => esc_html__( 'White', 'impeka' ),
						),
						'default' => 'white',
						'validate' => 'not_empty',
					),
					array(
						'id'       => 'quick_view_background_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Background Color', 'impeka' ),
						'subtitle' => esc_html__( 'Pick a background color for the quick view modal.', 'impeka' ),
						'default'  => '#000000',
						'transparent' => false,
					),
				)
			);

			$this->sections[] = array(
				'icon' => 'el-icon-brush',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( 'Colors - Media Popup', 'impeka' ),
				'id' => 'grve_redux_section_colors_media_popup',
				'desc' => esc_html__( 'Set your color preferences for yor Media Popups.', 'impeka' ),
				'submenu' => false,
				'panel' => false,
				'grve_colors' => true,
				'subsection' => false,
				'fields' => array(
					array(
						'id'       => 'media_popup_text_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Text Color', 'impeka' ),
						'subtitle' => esc_html__( 'Pick a color for the text of the popup.', 'impeka' ),
						'default'  => '#777777',
						'transparent' => false,
					),
					array(
						'id' => 'media_popup_navigation_color',
						'type' => 'select',
						'title' => esc_html__( 'Navigation Color', 'impeka' ),
						'subtitle'=> esc_html__( 'Select a color for the navigation of the popup.', 'impeka' ),
						'options' => array(
							'dark' => esc_html__( 'Dark', 'impeka' ),
							'light' => esc_html__( 'Light', 'impeka' ),
						),
						'default' => 'light',
						'validate' => 'not_empty',
					),
					array(
						'id'       => 'media_popup_overflow_background_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Overflow Background Color', 'impeka' ),
						'subtitle' => esc_html__( 'Pick a background color for the overflow area, when popup opens.', 'impeka' ),
						'default'  => '#000000',
						'transparent' => false,
					),
					array(
						'id' => 'media_popup_overflow_background_color_opacity',
						'type' => 'select',
						'title' => esc_html__('Background Opacity', 'impeka' ),
						'subtitle'    => esc_html__( 'Select opacity for the background of the overflow area.', 'impeka' ),
						'options' => $opacity_selection,
						"default" => '0.90',
					),
				)
			);

			$this->sections[] = array(
				'icon' => 'el-icon-brush',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( 'Colors - Theme Intro', 'impeka' ),
				'id' => 'grve_redux_section_colors_intro',
				'desc' => esc_html__( 'Set your color preferences for your Theme Intro.', 'impeka' ),
				'submenu' => false,
				'panel' => false,
				'grve_colors' => true,
				'subsection' => false,
				'fields' => array(
					array(
						'id'       => 'intro_title_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Title Color', 'impeka' ),
						'subtitle' => esc_html__( 'Pick a color for the titles of the theme intro.', 'impeka' ),
						'default'  => '#ffffff',
						'transparent' => false,
					),
					array(
						'id'       => 'intro_background_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Background Color', 'impeka' ),
						'subtitle' => esc_html__( 'Pick a background color for the the theme intro.', 'impeka' ),
						'default'  => '#FF4433',
						'transparent' => false,
					),
				)
			);

			$this->sections[] = array(
				'icon' => 'el-icon-brush',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( 'Colors - Page Transitions', 'impeka' ),
				'id' => 'grve_redux_section_colors_page_transitions',
				'desc' => esc_html__( 'Set your color preferences for Page Transitions.', 'impeka' ),
				'submenu' => false,
				'panel' => false,
				'grve_colors' => true,
				'subsection' => false,
				'fields' => array(
					array(
						'id'=>'page_transitions_bg_color',
						'type' => 'color',
						'title' => esc_html__( 'Page Transition Background Color', 'impeka' ),
						'subtitle' => esc_html__( 'Select the background color of Page Transitions.', 'impeka' ),
						'default'  => '#000000',
						'transparent' => false,
					),
					array(
						'id'=>'page_transitions_spinner_color',
						'type' => 'color',
						'title' => esc_html__( 'Spinner Color', 'impeka' ),
						'subtitle' => esc_html__( 'Select the color of Spinner.', 'impeka' ),
						'default' => '#FF4433',
						'transparent' => false,
					),
				)
			);

			$this->sections[] = array(
				'icon' => 'el-icon-brush',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( 'Colors - Indicator', 'impeka' ),
				'id' => 'grve_redux_section_colors_theme_indicator',
				'desc' => esc_html__( 'Set your color preferences for Theme Indicator ( Style 2 ).', 'impeka' ),
				'submenu' => false,
				'panel' => false,
				'grve_colors' => true,
				'subsection' => false,
				'fields' => array(
					array(
						'id'=>'theme_indicator_color',
						'type' => 'color',
						'title' => esc_html__( 'Theme Indicator Color', 'impeka' ),
						'subtitle' => esc_html__( 'Select the color of Theme Indicator.', 'impeka' ),
						'default'  => '#969696',
						'transparent' => false,
					),
					array(
						'id' => 'theme_indicator_opacity',
						'type' => 'select',
						'class' => 'grve-redux-group grve-redux-last',
						'title' => esc_html__( 'Theme Indicator Opacity', 'impeka' ),
						'options' => $opacity_selection,
						'default' => '1',
					),
				)
			);

			$this->sections[] = array(
				'icon' => 'el-icon-brush',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( 'Colors - Back to Top', 'impeka' ),
				'id' => 'grve_redux_section_colors_back_to_top',
				'desc' => esc_html__( 'Set your color preferences for Back to Top.', 'impeka' ),
				'submenu' => false,
				'panel' => false,
				'grve_colors' => true,
				'subsection' => false,
				'fields' => array(
					array(
						'id'=>'back_to_top_icon_color',
						'type' => 'color',
						'title' => esc_html__( 'Back to Top Icon Color', 'impeka' ),
						'subtitle' => esc_html__( 'Select the color of Back to Top icon.', 'impeka' ),
						'default'  => '#ffffff',
						'transparent' => false,
					),
					array(
						'id'=>'back_to_top_shape_color',
						'type' => 'color',
						'title' => esc_html__( 'Back to Top Icon Shape Color', 'impeka' ),
						'subtitle' => esc_html__( 'Select the color of Back to Top shape.', 'impeka' ),
						'default' => '#262829',
						'transparent' => false,
					),
				)
			);

			$this->sections[] = array(
				'icon' => 'el-icon-brush',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( 'Colors - Privacy / Cookies', 'impeka' ),
				'id' => 'grve_redux_section_colors_privacy_consent_bar',
				'desc' => esc_html__( 'Set your color preferences for Privacy / Cookies feature.', 'impeka' ),
				'submenu' => false,
				'panel' => false,
				'grve_colors' => true,
				'subsection' => false,
				'fields' => array(
					array(
						'id'=>'privacy_bar_bg_color',
						'type' => 'color',
						'class' => 'grve-redux-group grve-redux-first',
						'title' => esc_html__( 'Background Color', 'impeka' ),
						'subtitle' => esc_html__( 'Select the background color of Privacy Consent Info Bar.', 'impeka' ),
						'default'  => '#0D0D0D',
						'transparent' => false,
					),
					array(
						'id' => 'privacy_bar_bg_opacity',
						'type' => 'select',
						'class' => 'grve-redux-group grve-redux-last',
						'title' => esc_html__( 'Background Opacity', 'impeka' ),
						'options' => $opacity_selection,
						'default' => '1',
					),
					array(
						'id'=>'privacy_bar_border_color',
						'type' => 'color',
						'title' => esc_html__( 'Border Color', 'impeka' ),
						'subtitle' => esc_html__( 'Select the background color of Privacy Consent Info Bar.', 'impeka' ),
						'default'  => '#000000',
						'transparent' => false,
					),
					array(
						'id'=>'privacy_bar_text_color',
						'type' => 'color',
						'title' => esc_html__( 'Text Color', 'impeka' ),
						'subtitle' => esc_html__( 'Select the color of Privacy Consent Info Bar Text.', 'impeka' ),
						'default'  => '#D3D3D3',
						'transparent' => false,
					),
					array(
						'id'=>'privacy_bar_button_text_color',
						'type' => 'color',
						'class' => 'grve-redux-group grve-redux-first',
						'title' => esc_html__( 'Button Text Color', 'impeka' ),
						'subtitle' => esc_html__( 'Select the color of Privacy Consent Info Bar Button Text.', 'impeka' ),
						'default'  => '#000000',
						'transparent' => false,
					),
					array(
						'id'=>'privacy_bar_button_bg_color',
						'type' => 'color',
						'class' => 'grve-redux-group',
						'title' => esc_html__( 'Button Background Color', 'impeka' ),
						'subtitle' => esc_html__( 'Select the background color of Privacy Consent Info Bar Button.', 'impeka' ),
						'default'  => '#ffffff',
						'transparent' => false,
					),
					array(
						'id'=>'privacy_bar_button_bg_hover_color',
						'type' => 'color',
						'class' => 'grve-redux-group grve-redux-last',
						'title' => esc_html__( 'Button Background Hover Color', 'impeka' ),
						'subtitle' => esc_html__( 'Select the background hover color of Privacy Consent Info Bar Button.', 'impeka' ),
						'default'  => '#EBEBEB',
						'transparent' => false,
					),
					array(
						'id'=>'privacy_modal_button_text_color',
						'type' => 'color',
						'class' => 'grve-redux-group grve-redux-first',
						'title' => esc_html__( 'Modal Button Text Color', 'impeka' ),
						'subtitle' => esc_html__( 'Select the color of Modal Button Text.', 'impeka' ),
						'default'  => '#ffffff',
						'transparent' => false,
					),
					array(
						'id'=>'privacy_modal_button_bg_color',
						'type' => 'color',
						'class' => 'grve-redux-group',
						'title' => esc_html__( 'Modal Button Background Color', 'impeka' ),
						'subtitle' => esc_html__( 'Select the background color of Modal Button.', 'impeka' ),
						'default'  => '#000000',
						'transparent' => false,
					),
					array(
						'id'=>'privacy_modal_button_bg_hover_color',
						'type' => 'color',
						'class' => 'grve-redux-group grve-redux-last',
						'title' => esc_html__( 'Modal Button Background Hover Color', 'impeka' ),
						'subtitle' => esc_html__( 'Select the background hover color of Modal Button.', 'impeka' ),
						'default'  => '#282828',
						'transparent' => false,
					),
					array(
						'id'=>'privacy_modal_switcher_active_color',
						'type' => 'color',
						'title' => esc_html__( 'Modal Switcher Active Color', 'impeka' ),
						'subtitle' => esc_html__( 'Select the background color of Modal Switchers.', 'impeka' ),
						'default'  => '#00aaff',
						'transparent' => false,
					),
				)
			);
			//Colors End

			//Show Sections available only in customizer
			if ( ( defined( 'IMPEKA_GRVE_THEME_REDUX_CUSTOM_PANEL' ) &&  true === IMPEKA_GRVE_THEME_REDUX_CUSTOM_PANEL ) || $this->impeka_grve_redux_customizer_visibility() ) {
				foreach ( $this->sections as $k => $section ) {
					if ( isset( $section['grve_colors'] ) && isset( $section['panel'] ) ) {
						unset($this->sections[$k]['panel']);
					}
				}
			}

		}


		public function setArguments() {

			$theme = wp_get_theme();
			$theme_version = $theme->get('Version');
			if( is_child_theme() ) {
				$parent_theme = wp_get_theme( get_template() );
				$parent_theme_version = $parent_theme->get('Version');

				$theme_version = $parent_theme_version . ' ( ' . $theme->get('Name') .': ' . $theme->get('Version') . ' )';
			}

			$this->args = array(
				// TYPICAL -> Change these values as you need/desire
				'opt_name' => 'impeka_grve_options', // This is where your data is stored in the database and also becomes your global variable name.
				'display_name' => ' ', // Name that appears at the top of your panel
				'display_version' => $theme_version, // Version that appears at the top of your panel
				'menu_type' => 'submenu', //Specify if the admin menu should appear or not. Options: menu or submenu (Under appearance only)
				'allow_sub_menu' => false, // Show the sections below the admin menu item or not
				'menu_title' => esc_html__( 'Theme Options', 'impeka' ),
				'page_title' => esc_html__( 'Theme Options', 'impeka' ),
				'google_api_key' => '', // Must be defined to add google fonts to the typography module
				'admin_bar' => false, // Show the panel pages on the admin bar
				'global_variable' => 'impeka_grve_options', // Set a different name for your global variable other than the opt_name
				'dev_mode' => false, // Show the time the page took to load, etc
				'customizer' => true, // Enable basic customizer support
				'ajax_save' => true,
				'ajax_max_input' => true,
				'templates_path' => get_template_directory() . '/includes/admin/templates/panel', //Redux Template files

				// OPTIONAL -> Give you extra features
				'page_priority' => null, // Order where the menu appears in the admin area. If there is any conflict, something will not show. Warning.
				'page_parent' => 'themes.php', // For a full list of options, visit: http://codex.wordpress.org/Function_Reference/add_submenu_page#Parameters
				'page_permissions' => 'manage_options', // Permissions needed to access the options panel.
				'menu_icon' => get_template_directory_uri() .'/includes/images/adminmenu/theme.svg', // Specify a custom URL to an icon
				'last_tab' => '', // Force your panel to always open to a specific tab (by id)
				'page_icon' => 'icon-themes', // Icon displayed in the admin panel next to your menu_title
				'page_slug' => 'impeka_grve_options', // Page slug used to denote the panel
				'save_defaults' => true, // On load save the defaults to DB before user clicks save or not
				'default_show' => false, // If true, shows the default value next to each field that is not the default value.
				'default_mark' => '', // What to print by the field's title if the value shown is default. Suggested: *

				// CAREFUL -> These options are for advanced use only
				'output_location' => array( 'frontend', 'admin' ),
				'use_cdn' => false,
				'transient_time' => 60 * MINUTE_IN_SECONDS,
				'output' => true, // Global shut-off for dynamic CSS output by the framework. Will also disable google fonts output
				'output_tag' => true, // Allows dynamic CSS to be generated for customizer and google fonts, but stops the dynamic CSS from going to the head

				// FUTURE -> Not in use yet, but reserved or partially implemented. Use at your own risk.
				'database' => '', // possible: options, theme_mods, theme_mods_expanded, transient. Not fully functional, warning!
				'show_import_export' => true,
				'disable_tracking' => true,
				'allow_tracking' => false,
				'help_tabs' => array(),
				'help_sidebar' => '',
			);

			// Panel Intro text -> before the form
			$this->args['intro_text'] ='';

			// Add content after the form.
			$this->args['footer_text'] = '';
			$this->args['footer_credit'] = ' ';

		}

	}

	global $impeka_grve_redux_framework;
	$impeka_grve_redux_framework = new Impeka_Grve_Redux_Framework_config();
}

//Omit closing PHP tag to avoid accidental whitespace output errors.
