<?php
/*
*	Admin Page Import
*
* 	@author		Greatives Team
* 	@URI		https://greatives.eu
*/

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
if ( class_exists( 'Impeka_Importer' ) ) {
	$import_url = admin_url( 'admin.php?import=impeka-demo-importer' );
} else {
	$import_url = admin_url( 'admin.php?page=impeka-tgmpa-install-plugins' );
}
$support_link = 'https://greatives.ticksy.com';
$link_full_import = 'https://docs.greatives.eu/tutorials/full-demo-import-in-impeka/';
$link_on_demand_import = 'https://docs.greatives.eu/tutorials/import-on-demand-in-impeka/';
$link_elementor_library = 'https://docs.greatives.eu/tutorials/how-to-use-impeka-elementor-library/';
$link_content_manager = 'https://docs.greatives.eu/tutorials/content-manager-in-impeka/';

$status_url = admin_url( 'admin.php?page=impeka-status' );
?>
	<div id="grve-admin-pannel-wrapper" class="grve-import-wrap">
		<div id="grve-admin-nav-wrapper">
			<?php impeka_grve_print_admin_links('import'); ?>
		</div>
		<div class="grve-admin-title-wrapper">
			<div class="grve-admin-title">
				<h2 class="grve-title"><?php esc_html_e( "The Easiest Ways to Import Impeka Demo Content", 'impeka' ); ?></h2>
				<p class="grve-description">
					<?php
					echo sprintf(
						esc_html__( "Impeka offers you various options to import the demo content. With the %s (available only for demos created with Impeka's enhanced WPBakery page builder) you can import specific pages, posts, portfolios. With the %s (available for all demos), you can import any of the available demos. Over the above, for Elementor demos you can use the %s to import specific pages and/or sections.", 'impeka' ),
						'<a href="' . esc_url( $link_on_demand_import ) . '" target="_blank" rel="noopener noreferrer">' . esc_html__( 'Import on Demand', 'impeka' ) . '</a>',
						'<a href="' . esc_url( $link_full_import ) . '" target="_blank" rel="noopener noreferrer">' . esc_html__( 'Full Import Demo', 'impeka' ) . '</a>',
						'<a href="' . esc_url( $link_elementor_library ) . '" target="_blank" rel="noopener noreferrer">' . esc_html__( 'Impeka Elementor Library', 'impeka' ) . '</a>'
					);
					?>
				</p>
				<?php if ( !class_exists( 'Impeka_Importer' ) ) { ?>
				<a href="<?php echo esc_url( $import_url ); ?>" class="grve-btn"><?php esc_html_e( "Install/Activate Demo Importer", 'impeka' ); ?></a>
				<?php } else { ?>
				<?php
					$server_status = impeka_grve_admin_check_server_status();
					if ( !$server_status ) {
				?>
				<a href="<?php echo esc_url( $status_url ); ?>" class="grve-btn grve-btn-error"><?php esc_html_e( "Server Status", 'impeka' ); ?> <i class="dashicons dashicons-no"></i></a>
				<?php
					} else {
				?>
				<a href="<?php echo esc_url( $status_url ); ?>" class="grve-btn grve-btn-success"><?php esc_html_e( "Server Status", 'impeka' ); ?> <i class="dashicons dashicons-yes-alt"></i></a>
				<?php
					}
				?>
				<?php } ?>
			</div>
			<div class="grve-import-notes">
				<h3 class="grve-notes-title"><?php esc_html_e( "Please note the following points", 'impeka' ); ?>:</h3>
				<ul class="grve-notes-list">
					<li><?php esc_html_e( "The import process will work best on a clean installation. You can use a plugin such as WordPress Reset to clear your data first.", 'impeka' ); ?></li>
					<li><?php esc_html_e( "Ensure all needed plugins are already installed and activated, e.g.Impeka Core Extension, WPBakery Page Builder, WooCommerce, Contact Form 7 etc.", 'impeka' ); ?></li>
					<li><?php esc_html_e( "To import one of our Demos, select all or some of the options of any demo and press the import button.", 'impeka' ); ?></li>
					<li><?php echo sprintf(
						esc_html__( "To import content on demand while editing your pages, check the %s for the WPBakery Page Builder creations and the %s for the Elementor creations.", 'impeka' ),
						'<a href="' . esc_url( $link_content_manager ) . '" target="_blank" rel="noopener noreferrer">' . esc_html__( 'Impeka Content Manager', 'impeka' ) . '</a>',
						'<a href="' . esc_url( $link_elementor_library ) . '" target="_blank" rel="noopener noreferrer">' . esc_html__( 'Impeka Elementor Library', 'impeka' ) . '</a>'
					);
					?></li>
				</ul>
				<p>
					<strong>
					<?php
					echo sprintf(
						esc_html__( "If you need any assistance, use our %s. We are always happy to help!", 'impeka' ),
						'<a href="' . esc_url( $support_link ) . '" target="_blank" rel="noopener noreferrer">' . esc_html__( 'Support Desk', 'impeka' ) . '</a>'
					);
					?>
					</strong>
				</p>
			</div>
		</div>
		<?php do_action( 'impeka_grve_demo_selection' ); ?>
	</div>
<?php

//Omit closing PHP tag to avoid accidental whitespace output errors.
