<?php
/*
*	Admin Custom Sidebars
*
* 	@author		Greatives Team
* 	@URI		https://greatives.eu
*/

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

$custom_sidebars = get_option( '_impeka_grve_custom_sidebars' );
?>
	<div id="grve-admin-pannel-wrapper" class="grve-sidebar-wrap">
		<div id="grve-admin-nav-wrapper">
			<?php impeka_grve_print_admin_links('sidebars'); ?>
		</div>
		<div class="grve-admin-title">
			<h2 class="grve-title"><?php esc_html_e( "Sidebars", 'impeka' ); ?></h2>
			<p class="grve-description"><?php esc_html_e( "You’re able to create as many custom sidebars as you like. Give a name in the text field below, and then click the round button with the plus icon. Of course, you can also delete any of the existing sidebars.", 'impeka' ); ?></p>
		</div>
		<?php if( isset( $_GET['sidebar-settings'] ) ) { ?>
		<div class="grve-sidebar-saved updated inline grve-notice-green">
			<p><strong><?php esc_html_e('Settings Saved!', 'impeka' ); ?></strong></p>
		</div>
		<?php } ?>
		<form id="grve-custom-sidebars-form" method="post" action="admin.php?page=impeka-sidebars">
			<table class="grve-table grve-sidebar-table" cellspacing="0">
				<thead>
					<tr>
						<th style="padding-bottom: 60px;">
							<h3 class="grve-table-title"><?php esc_html_e('Add Sidebar', 'impeka' ); ?></h3>
							<input type="text" class="grve-sidebar-text" id="grve-custom-sidebar-item-name-new" value="" placeholder="<?php esc_attr_e('Sidebar Name', 'impeka' ); ?>" style="max-width: 300px;"/>
							<div class="grve-hidden-notice grve-sidebar-notice grve-notice-red">
								<?php esc_html_e('Field must not be empty!', 'impeka' ); ?>
							</div>
							<div class="grve-hidden-notice grve-sidebar-notice-exists grve-notice-red">
								<?php esc_html_e('Sidebar with this name already exists!', 'impeka' ); ?>
							</div>
							<a href="#" id="grve-add-custom-sidebar-item" class="grve-add-button">
								<svg width="12px" height="12px" viewBox="0 0 12 12">
									<path d="M7,0 L7,5 L12,5 L12,7 L7,7 L7,12 L5,12 L5,7 L0,7 L0,5 L5,5 L5,0 L7,0 Z"></path>
								</svg>
							</a>
						</th>
						<th>
							<span class="grve-sidebar-spinner"></span>
						</th>
					</tr>
				</thead>
				<tbody id="grve-custom-sidebar-container">
					<?php impeka_grve_print_admin_custom_sidebars( $custom_sidebars ); ?>
				</tbody>
				<tfoot id="grve-custom-sidebar-footer">
					<tr>
						<td>&nbsp;</td>
						<td>&nbsp;</td>
					</tr>
				</tfoot>
			</table>
			<?php wp_nonce_field( 'impeka_grve_nonce_sidebar_save', '_impeka_grve_nonce_sidebar_save' ); ?>
		</form>
	</div>
<?php


//Omit closing PHP tag to avoid accidental whitespace output errors.
