<?php
/**
 *  Dynamic typography css style
 * 	@author		Greatives Team
 * 	@URI		https://greatives.eu
 */

$typo_css = "";

/**
 * Typography
 * ----------------------------------------------------------------------------
 */

$typo_css .= "

body,
.grve-body-text,
.grve-header-text-element .grve-item {
	font-size: " . impeka_grve_option( 'body_font', '14px', 'font-size'  ) . ";
	font-family: " . impeka_grve_option( 'body_font', 'inherit', 'font-family'  ) . ";
	font-weight: " . impeka_grve_option( 'body_font', 'normal', 'font-weight'  ) . ";
	line-height: " . impeka_grve_option( 'body_font', '36px', 'line-height'  ) . ";
	" . impeka_grve_css_option( 'body_font', '0px', 'letter-spacing'  ) . "
}

";

/* Logo as text */
$typo_css .= "

#grve-header .grve-logo.grve-logo-text a,
#grve-offcanvas-area .grve-offcanvas-logo.grve-logo-text a {
	font-family: " . impeka_grve_option( 'logo_font', 'inherit', 'font-family'  ) . ";
	font-weight: " . impeka_grve_option( 'logo_font', 'normal', 'font-weight'  ) . ";
	font-style: " . impeka_grve_option( 'logo_font', 'normal', 'font-style'  ) . ";
	font-size: " . impeka_grve_option( 'logo_font', '11px', 'font-size'  ) . ";
	text-transform: " . impeka_grve_option( 'logo_font', 'uppercase', 'text-transform'  ) . ";
	" . impeka_grve_css_option( 'logo_font', '0px', 'letter-spacing'  ) . "
}

";


/* Main Menu  */
$typo_css .= "
.grve-menu-text,
.grve-header-menu li .grve-link-wrapper:not(.grve-menu-element-link-wrapper),
.grve-header-menu li.grve-first-level:not(.grve-menu-element-first-level) > .grve-link-wrapper:not(.grve-menu-element-link-wrapper) > a,
#grve-main-header .grve-header-button,
#grve-main-header .megamenu .sub-menu > li.menu-item-has-children > .grve-link-wrapper:not(.grve-menu-element-link-wrapper) > a,
#grve-main-header .grve-language.grve-list,
#grve-main-header .grve-language.grve-dropdown,
#grve-offcanvas-area.grve-layout-2 #grve-second-menu li.grve-first-level:not(.grve-menu-element-first-level) > .grve-link-wrapper:not(.grve-menu-element-link-wrapper) > a,
.grve-burger-label {
	font-family: " . impeka_grve_option( 'main_menu_font', 'inherit', 'font-family'  ) . ";
	font-weight: " . impeka_grve_option( 'main_menu_font', 'normal', 'font-weight'  ) . ";
	font-style: " . impeka_grve_option( 'main_menu_font', 'normal', 'font-style'  ) . ";
	font-size: " . impeka_grve_option( 'main_menu_font', '11px', 'font-size'  ) . ";
	text-transform: " . impeka_grve_option( 'main_menu_font', 'uppercase', 'text-transform'  ) . ";
	" . impeka_grve_css_option( 'main_menu_font', '0px', 'letter-spacing'  ) . "
}

.grve-menu-text ul.sub-menu,
.grve-header-menu ul.sub-menu a,
#grve-offcanvas-area.grve-layout-2 #grve-second-menu ul.sub-menu a {
	font-family: " . impeka_grve_option( 'sub_menu_font', 'inherit', 'font-family'  ) . ";
	font-weight: " . impeka_grve_option( 'sub_menu_font', 'normal', 'font-weight'  ) . ";
	font-style: " . impeka_grve_option( 'sub_menu_font', 'normal', 'font-style'  ) . ";
	font-size: " . impeka_grve_option( 'sub_menu_font', '11px', 'font-size'  ) . ";
	text-transform: " . impeka_grve_option( 'sub_menu_font', 'uppercase', 'text-transform'  ) . ";
	" . impeka_grve_css_option( 'sub_menu_font', '0px', 'letter-spacing'  ) . "
}

#grve-main-header .megamenu .sub-menu > li.menu-item-has-children > .grve-link-wrapper:not(.grve-menu-element-link-wrapper) > a {
	font-family: " . impeka_grve_option( 'megamenu_titles_font', 'inherit', 'font-family'  ) . ";
	font-weight: " . impeka_grve_option( 'megamenu_titles_font', 'normal', 'font-weight'  ) . ";
	font-style: " . impeka_grve_option( 'megamenu_titles_font', 'normal', 'font-style'  ) . ";
	font-size: " . impeka_grve_option( 'megamenu_titles_font', '11px', 'font-size'  ) . ";
	text-transform: " . impeka_grve_option( 'megamenu_titles_font', 'uppercase', 'text-transform'  ) . ";
	" . impeka_grve_css_option( 'megamenu_titles_font', '0px', 'letter-spacing'  ) . "
}

#grve-main-header .grve-menu-description {
	font-family: " . impeka_grve_option( 'description_menu_font', 'inherit', 'font-family'  ) . ";
	font-weight: " . impeka_grve_option( 'description_menu_font', 'normal', 'font-weight'  ) . ";
	font-style: " . impeka_grve_option( 'description_menu_font', 'normal', 'font-style'  ) . ";
	font-size: " . impeka_grve_option( 'description_menu_font', '11px', 'font-size'  ) . ";
	text-transform: " . impeka_grve_option( 'description_menu_font', 'uppercase', 'text-transform'  ) . ";
	" . impeka_grve_css_option( 'description_menu_font', '0px', 'letter-spacing'  ) . "
}

";

/* Responsive Menu  */
$typo_css .= "
.grve-responsive-menu-text,
#grve-responsive-main-menu .grve-menu .grve-first-level:not(.grve-menu-element-first-level) > .grve-link-wrapper:not(.grve-menu-element-link-wrapper) a {
	font-family: " . impeka_grve_option( 'responsive_menu_font', 'inherit', 'font-family'  ) . ";
	font-weight: " . impeka_grve_option( 'responsive_menu_font', 'normal', 'font-weight'  ) . ";
	font-style: " . impeka_grve_option( 'responsive_menu_font', 'normal', 'font-style'  ) . ";
	font-size: " . impeka_grve_option( 'responsive_menu_font', '11px', 'font-size'  ) . ";
	text-transform: " . impeka_grve_option( 'responsive_menu_font', 'uppercase', 'text-transform'  ) . ";
	" . impeka_grve_css_option( 'responsive_menu_font', '0px', 'letter-spacing'  ) . "
}

.grve-responsive-menu-text .sub-menu,
#grve-responsive-main-menu .grve-menu .sub-menu .grve-link-wrapper:not(.grve-menu-element-link-wrapper) a {
	font-family: " . impeka_grve_option( 'sub_responsive_menu_font', 'inherit', 'font-family'  ) . ";
	font-weight: " . impeka_grve_option( 'sub_responsive_menu_font', 'normal', 'font-weight'  ) . ";
	font-style: " . impeka_grve_option( 'sub_responsive_menu_font', 'normal', 'font-style'  ) . ";
	font-size: " . impeka_grve_option( 'sub_responsive_menu_font', '11px', 'font-size'  ) . ";
	text-transform: " . impeka_grve_option( 'sub_responsive_menu_font', 'uppercase', 'text-transform'  ) . ";
	" . impeka_grve_css_option( 'sub_responsive_menu_font', '0px', 'letter-spacing'  ) . "
}

#grve-responsive-main-menu .grve-menu-description {
	font-family: " . impeka_grve_option( 'description_responsive_menu_font', 'inherit', 'font-family'  ) . ";
	font-weight: " . impeka_grve_option( 'description_responsive_menu_font', 'normal', 'font-weight'  ) . ";
	font-style: " . impeka_grve_option( 'description_responsive_menu_font', 'normal', 'font-style'  ) . ";
	font-size: " . impeka_grve_option( 'description_responsive_menu_font', '11px', 'font-size'  ) . ";
	text-transform: " . impeka_grve_option( 'description_responsive_menu_font', 'uppercase', 'text-transform'  ) . ";
	" . impeka_grve_css_option( 'description_responsive_menu_font', '0px', 'letter-spacing'  ) . "
}

";

/* Offcanvas Menu  */
$typo_css .= "

.grve-offcanvas-menu-text .sub-menu,
#grve-offcanvas-area ul.sub-menu a {
	font-family: " . impeka_grve_option( 'sub_offcanvas_menu_font', 'inherit', 'font-family'  ) . ";
	font-weight: " . impeka_grve_option( 'sub_offcanvas_menu_font', 'normal', 'font-weight'  ) . ";
	font-style: " . impeka_grve_option( 'sub_offcanvas_menu_font', 'normal', 'font-style'  ) . ";
	font-size: " . impeka_grve_option( 'sub_offcanvas_menu_font', '11px', 'font-size'  ) . ";
	text-transform: " . impeka_grve_option( 'sub_offcanvas_menu_font', 'uppercase', 'text-transform'  ) . ";
	" . impeka_grve_css_option( 'sub_offcanvas_menu_font', '0px', 'letter-spacing'  ) . "
}
.grve-offcanvas-menu-text,
#grve-offcanvas-area .grve-vertical-menu:not(.grve-menu-element) > .grve-menu > li > .grve-link-wrapper:not(.grve-menu-element-link-wrapper),
#grve-offcanvas-area .grve-vertical-menu:not(.grve-menu-element) > .grve-menu > li > .grve-link-wrapper:not(.grve-menu-element-link-wrapper) a {
	font-family: " . impeka_grve_option( 'offcanvas_menu_font', 'inherit', 'font-family'  ) . ";
	font-weight: " . impeka_grve_option( 'offcanvas_menu_font', 'normal', 'font-weight'  ) . ";
	font-style: " . impeka_grve_option( 'offcanvas_menu_font', 'normal', 'font-style'  ) . ";
	font-size: " . impeka_grve_option( 'offcanvas_menu_font', '11px', 'font-size'  ) . ";
	text-transform: " . impeka_grve_option( 'offcanvas_menu_font', 'uppercase', 'text-transform'  ) . ";
	" . impeka_grve_css_option( 'offcanvas_menu_font', '0px', 'letter-spacing'  ) . "
}

#grve-offcanvas-area .grve-menu-description {
	font-family: " . impeka_grve_option( 'description_offcanvas_menu_font', 'inherit', 'font-family'  ) . ";
	font-weight: " . impeka_grve_option( 'description_offcanvas_menu_font', 'normal', 'font-weight'  ) . ";
	font-style: " . impeka_grve_option( 'description_offcanvas_menu_font', 'normal', 'font-style'  ) . ";
	font-size: " . impeka_grve_option( 'description_offcanvas_menu_font', '11px', 'font-size'  ) . ";
	text-transform: " . impeka_grve_option( 'description_offcanvas_menu_font', 'uppercase', 'text-transform'  ) . ";
	" . impeka_grve_css_option( 'description_offcanvas_menu_font', '0px', 'letter-spacing'  ) . "
}

";

/* Intro Text  */
$typo_css .= "
#grve-intro .grve-first-title-text {
	font-family: " . impeka_grve_option( 'intro_first_title', 'inherit', 'font-family'  ) . ";
	font-weight: " . impeka_grve_option( 'intro_first_title', 'normal', 'font-weight'  ) . ";
	font-style: " . impeka_grve_option( 'intro_first_title', 'normal', 'font-style'  ) . ";
	text-transform: " . impeka_grve_option( 'intro_first_title', ' none', 'text-transform'  ) . ";
	font-size: " . impeka_grve_option( 'intro_first_title', '56px', 'font-size'  ) . ";
	line-height: " . impeka_grve_option( 'intro_first_title', '60px', 'line-height'  ) . ";
	" . impeka_grve_css_option( 'intro_first_title', '0px', 'letter-spacing'  ) . "
}

#grve-intro .grve-second-title-text {
	font-family: " . impeka_grve_option( 'intro_second_title', 'inherit', 'font-family'  ) . ";
	font-weight: " . impeka_grve_option( 'intro_second_title', 'normal', 'font-weight'  ) . ";
	font-style: " . impeka_grve_option( 'intro_second_title', 'normal', 'font-style'  ) . ";
	text-transform: " . impeka_grve_option( 'intro_second_title', ' none', 'text-transform'  ) . ";
	font-size: " . impeka_grve_option( 'intro_second_title', '56px', 'font-size'  ) . ";
	line-height: " . impeka_grve_option( 'intro_second_title', '60px', 'line-height'  ) . ";
	" . impeka_grve_css_option( 'intro_second_title', '0px', 'letter-spacing'  ) . "
}

";

/* Headings */
$typo_css .= "

h1,
.grve-h1,
#grve-sliding-area .grve-search input[type='text'],
.grve-dropcap span,
p.grve-dropcap:first-letter {
	font-family: " . impeka_grve_option( 'h1_font', 'inherit', 'font-family'  ) . ";
	font-weight: " . impeka_grve_option( 'h1_font', 'normal', 'font-weight'  ) . ";
	font-style: " . impeka_grve_option( 'h1_font', 'normal', 'font-style'  ) . ";
	text-transform: " . impeka_grve_option( 'h1_font', ' none', 'text-transform'  ) . ";
	font-size: " . impeka_grve_option( 'h1_font', '56px', 'font-size'  ) . ";
	line-height: " . impeka_grve_option( 'h1_font', '60px', 'line-height'  ) . ";
	" . impeka_grve_css_option( 'h1_font', '0px', 'letter-spacing'  ) . "
}

h2,
.grve-h2 {
	font-family: " . impeka_grve_option( 'h2_font', 'inherit', 'font-family'  ) . ";
	font-weight: " . impeka_grve_option( 'h2_font', 'normal', 'font-weight'  ) . ";
	font-style: " . impeka_grve_option( 'h2_font', 'normal', 'font-style'  ) . ";
	text-transform: " . impeka_grve_option( 'h2_font', ' none', 'text-transform'  ) . ";
	font-size: " . impeka_grve_option( 'h2_font', '36px', 'font-size'  ) . ";
	line-height: " . impeka_grve_option( 'h2_font', '40px', 'line-height'  ) . ";
	" . impeka_grve_css_option( 'h2_font', '0px', 'letter-spacing'  ) . "
}

h3,
.grve-h3 {
	font-family: " . impeka_grve_option( 'h3_font', 'inherit', 'font-family'  ) . ";
	font-weight: " . impeka_grve_option( 'h3_font', 'normal', 'font-weight'  ) . ";
	font-style: " . impeka_grve_option( 'h3_font', 'normal', 'font-style'  ) . ";
	text-transform: " . impeka_grve_option( 'h3_font', ' none', 'text-transform'  ) . ";
	font-size: " . impeka_grve_option( 'h3_font', '30px', 'font-size'  ) . ";
	line-height: " . impeka_grve_option( 'h3_font', '33px', 'line-height'  ) . ";
	" . impeka_grve_css_option( 'h3_font', '0px', 'letter-spacing'  ) . "
}

h4,
.grve-h4 {
	font-family: " . impeka_grve_option( 'h4_font', 'inherit', 'font-family'  ) . ";
	font-weight: " . impeka_grve_option( 'h4_font', 'normal', 'font-weight'  ) . ";
	font-style: " . impeka_grve_option( 'h4_font', 'normal', 'font-style'  ) . ";
	text-transform: " . impeka_grve_option( 'h4_font', ' none', 'text-transform'  ) . ";
	font-size: " . impeka_grve_option( 'h4_font', '23px', 'font-size'  ) . ";
	line-height: " . impeka_grve_option( 'h4_font', '26px', 'line-height'  ) . ";
	" . impeka_grve_css_option( 'h4_font', '0px', 'letter-spacing'  ) . "
}

h5,
.grve-h5,
h3#reply-title {
	font-family: " . impeka_grve_option( 'h5_font', 'inherit', 'font-family'  ) . ";
	font-weight: " . impeka_grve_option( 'h5_font', 'normal', 'font-weight'  ) . ";
	font-style: " . impeka_grve_option( 'h5_font', 'normal', 'font-style'  ) . ";
	text-transform: " . impeka_grve_option( 'h5_font', ' none', 'text-transform'  ) . ";
	font-size: " . impeka_grve_option( 'h5_font', '18px', 'font-size'  ) . ";
	line-height: " . impeka_grve_option( 'h5_font', '20px', 'line-height'  ) . ";
	" . impeka_grve_css_option( 'h5_font', '0px', 'letter-spacing'  ) . "
}

h6,
.grve-h6,
.vc_tta.vc_general .vc_tta-panel-title,
#grve-main-content .vc_tta.vc_general .vc_tta-tab > a {
	font-family: " . impeka_grve_option( 'h6_font', 'inherit', 'font-family'  ) . ";
	font-weight: " . impeka_grve_option( 'h6_font', 'normal', 'font-weight'  ) . ";
	font-style: " . impeka_grve_option( 'h6_font', 'normal', 'font-style'  ) . ";
	text-transform: " . impeka_grve_option( 'h6_font', ' none', 'text-transform'  ) . ";
	font-size: " . impeka_grve_option( 'h6_font', '16px', 'font-size'  ) . ";
	line-height: " . impeka_grve_option( 'h6_font', '18px', 'line-height'  ) . ";
	" . impeka_grve_css_option( 'h6_font', '0px', 'letter-spacing'  ) . "
}

";

/* Page Title */
$typo_css .= "

.grve-page-title,
#grve-blog-title .grve-title,
#grve-search-page-title .grve-title,
#grve-portfolio-tax-title .grve-title {
	font-family: " . impeka_grve_option( 'page_title', 'inherit', 'font-family'  ) . ";
	font-weight: " . impeka_grve_option( 'page_title', 'normal', 'font-weight'  ) . ";
	font-style: " . impeka_grve_option( 'page_title', 'normal', 'font-style'  ) . ";
	font-size: " . impeka_grve_option( 'page_title', '60px', 'font-size'  ) . ";
	text-transform: " . impeka_grve_option( 'page_title', 'uppercase', 'text-transform'  ) . ";
	line-height: " . impeka_grve_option( 'page_title', '60px', 'line-height'  ) . ";
	" . impeka_grve_css_option( 'page_title', '0px', 'letter-spacing'  ) . "
}

.grve-page-description,
#grve-blog-title .grve-description,
#grve-blog-title .grve-description p,
#grve-search-page-title .grve-description,
#grve-portfolio-tax-title .grve-description {
	font-family: " . impeka_grve_option( 'page_description', 'inherit', 'font-family'  ) . ";
	font-weight: " . impeka_grve_option( 'page_description', 'normal', 'font-weight'  ) . ";
	font-style: " . impeka_grve_option( 'page_description', 'normal', 'font-style'  ) . ";
	font-size: " . impeka_grve_option( 'page_description', '24px', 'font-size'  ) . ";
	text-transform: " . impeka_grve_option( 'page_description', 'none', 'text-transform'  ) . ";
	line-height: " . impeka_grve_option( 'page_description', '60px', 'line-height'  ) . ";
	" . impeka_grve_css_option( 'page_description', '0px', 'letter-spacing'  ) . "
}

";


/* Post Title */
$typo_css .= "

#grve-post-title .grve-title-categories {
	font-family: " . impeka_grve_option( 'post_title_meta', 'inherit', 'font-family'  ) . ";
	font-weight: " . impeka_grve_option( 'post_title_meta', 'normal', 'font-weight'  ) . ";
	font-style: " . impeka_grve_option( 'post_title_meta', 'normal', 'font-style'  ) . ";
	font-size: " . impeka_grve_option( 'post_title_meta', '12px', 'font-size'  ) . ";
	text-transform: " . impeka_grve_option( 'post_title_meta', 'none', 'text-transform'  ) . ";
	line-height: " . impeka_grve_option( 'post_title_meta', '24px', 'line-height'  ) . ";
	" . impeka_grve_css_option( 'post_title_meta', '0px', 'letter-spacing'  ) . "
}

#grve-post-title .grve-post-meta {
	font-family: " . impeka_grve_option( 'post_title_extra_meta', 'inherit', 'font-family'  ) . ";
	font-weight: " . impeka_grve_option( 'post_title_extra_meta', 'normal', 'font-weight'  ) . ";
	font-style: " . impeka_grve_option( 'post_title_extra_meta', 'normal', 'font-style'  ) . ";
	font-size: " . impeka_grve_option( 'post_title_extra_meta', '12px', 'font-size'  ) . ";
	text-transform: " . impeka_grve_option( 'post_title_extra_meta', 'none', 'text-transform'  ) . ";
	line-height: " . impeka_grve_option( 'post_title_extra_meta', '24px', 'line-height'  ) . ";
	" . impeka_grve_css_option( 'post_title_extra_meta', '0px', 'letter-spacing'  ) . "
}

.grve-single-simple-title {
	font-family: " . impeka_grve_option( 'post_simple_title', 'inherit', 'font-family'  ) . ";
	font-weight: " . impeka_grve_option( 'post_simple_title', 'normal', 'font-weight'  ) . ";
	font-style: " . impeka_grve_option( 'post_simple_title', 'normal', 'font-style'  ) . ";
	font-size: " . impeka_grve_option( 'post_simple_title', '60px', 'font-size'  ) . ";
	text-transform: " . impeka_grve_option( 'post_simple_title', 'uppercase', 'text-transform'  ) . ";
	line-height: " . impeka_grve_option( 'post_simple_title', '112px', 'line-height'  ) . ";
	" . impeka_grve_css_option( 'post_simple_title', '0px', 'letter-spacing'  ) . "
}

#grve-post-title .grve-title {
	font-family: " . impeka_grve_option( 'post_title', 'inherit', 'font-family'  ) . ";
	font-weight: " . impeka_grve_option( 'post_title', 'normal', 'font-weight'  ) . ";
	font-style: " . impeka_grve_option( 'post_title', 'normal', 'font-style'  ) . ";
	font-size: " . impeka_grve_option( 'post_title', '60px', 'font-size'  ) . ";
	text-transform: " . impeka_grve_option( 'post_title', 'uppercase', 'text-transform'  ) . ";
	line-height: " . impeka_grve_option( 'post_title', '112px', 'line-height'  ) . ";
	" . impeka_grve_css_option( 'post_title', '0px', 'letter-spacing'  ) . "
}

#grve-post-title .grve-description {
	font-family: " . impeka_grve_option( 'post_title_desc', 'inherit', 'font-family'  ) . ";
	font-weight: " . impeka_grve_option( 'post_title_desc', 'normal', 'font-weight'  ) . ";
	font-style: " . impeka_grve_option( 'post_title_desc', 'normal', 'font-style'  ) . ";
	font-size: " . impeka_grve_option( 'post_title_desc', '26px', 'font-size'  ) . ";
	text-transform: " . impeka_grve_option( 'post_title_desc', 'uppercase', 'text-transform'  ) . ";
	line-height: " . impeka_grve_option( 'post_title_desc', '32px', 'line-height'  ) . ";
	" . impeka_grve_css_option( 'post_title_desc', '0px', 'letter-spacing'  ) . "
}

";

/* Portfolio Title */
$typo_css .= "

#grve-portfolio-title .grve-title-categories {
	font-family: " . impeka_grve_option( 'portfolio_title_meta', 'inherit', 'font-family'  ) . ";
	font-weight: " . impeka_grve_option( 'portfolio_title_meta', 'normal', 'font-weight'  ) . ";
	font-style: " . impeka_grve_option( 'portfolio_title_meta', 'normal', 'font-style'  ) . ";
	font-size: " . impeka_grve_option( 'portfolio_title_meta', '12px', 'font-size'  ) . ";
	text-transform: " . impeka_grve_option( 'portfolio_title_meta', 'none', 'text-transform'  ) . ";
	line-height: " . impeka_grve_option( 'portfolio_title_meta', '24px', 'line-height'  ) . ";
	" . impeka_grve_css_option( 'portfolio_title_meta', '0px', 'letter-spacing'  ) . "
}

#grve-portfolio-title .grve-title {
	font-family: " . impeka_grve_option( 'portfolio_title', 'inherit', 'font-family'  ) . ";
	font-weight: " . impeka_grve_option( 'portfolio_title', 'normal', 'font-weight'  ) . ";
	font-style: " . impeka_grve_option( 'portfolio_title', 'normal', 'font-style'  ) . ";
	font-size: " . impeka_grve_option( 'portfolio_title', '60px', 'font-size'  ) . ";
	text-transform: " . impeka_grve_option( 'portfolio_title', 'normal', 'text-transform'  ) . ";
	line-height: " . impeka_grve_option( 'portfolio_title', '72px', 'line-height'  ) . ";
	" . impeka_grve_css_option( 'portfolio_title', '0px', 'letter-spacing'  ) . "
}

#grve-portfolio-title .grve-description {
	font-family: " . impeka_grve_option( 'portfolio_description', 'inherit', 'font-family'  ) . ";
	font-weight: " . impeka_grve_option( 'portfolio_description', 'normal', 'font-weight'  ) . ";
	font-style: " . impeka_grve_option( 'portfolio_description', 'normal', 'font-style'  ) . ";
	font-size: " . impeka_grve_option( 'portfolio_description', '18px', 'font-size'  ) . ";
	text-transform: " . impeka_grve_option( 'portfolio_description', 'normal', 'text-transform'  ) . ";
	line-height: " . impeka_grve_option( 'portfolio_description', '30px', 'line-height'  ) . ";
	" . impeka_grve_css_option( 'portfolio_description', '0px', 'letter-spacing'  ) . "
}


";

/* Forum Title */
$typo_css .= "

#grve-forum-title .grve-title {
	font-family: " . impeka_grve_option( 'forum_title', 'inherit', 'font-family'  ) . ";
	font-weight: " . impeka_grve_option( 'forum_title', 'normal', 'font-weight'  ) . ";
	font-style: " . impeka_grve_option( 'forum_title', 'normal', 'font-style'  ) . ";
	font-size: " . impeka_grve_option( 'forum_title', '60px', 'font-size'  ) . ";
	text-transform: " . impeka_grve_option( 'forum_title', 'normal', 'text-transform'  ) . ";
	line-height: " . impeka_grve_option( 'forum_title', '72px', 'line-height'  ) . ";
	" . impeka_grve_css_option( 'forum_title', '0px', 'letter-spacing'  ) . "
}


";

/* Product Title
============================================================================= */
$typo_css .= "

#grve-product-area .product_title {
	font-family: " . impeka_grve_option( 'product_simple_title', 'inherit', 'font-family'  ) . ";
	font-weight: " . impeka_grve_option( 'product_simple_title', 'normal', 'font-weight'  ) . ";
	font-style: " . impeka_grve_option( 'product_simple_title', 'normal', 'font-style'  ) . ";
	font-size: " . impeka_grve_option( 'product_simple_title', '36px', 'font-size'  ) . ";
	text-transform: " . impeka_grve_option( 'product_simple_title', 'normal', 'text-transform'  ) . ";
	line-height: " . impeka_grve_option( 'product_simple_title', '48px', 'line-height'  ) . ";
	" . impeka_grve_css_option( 'product_simple_title', '0px', 'letter-spacing'  ) . "
}

.woocommerce .summary .woocommerce-product-details__short-description p {
	font-family: " . impeka_grve_option( 'product_short_description', 'inherit', 'font-family'  ) . ";
	font-weight: " . impeka_grve_option( 'product_short_description', 'normal', 'font-weight'  ) . ";
	font-style: " . impeka_grve_option( 'product_short_description', 'normal', 'font-style'  ) . ";
	font-size: " . impeka_grve_option( 'product_short_description', '24px', 'font-size'  ) . ";
	text-transform: " . impeka_grve_option( 'product_short_description', 'normal', 'text-transform'  ) . ";
	line-height: " . impeka_grve_option( 'product_short_description', '30px', 'line-height'  ) . ";
	" . impeka_grve_css_option( 'product_short_description', '0px', 'letter-spacing'  ) . "
}

#grve-product-title .grve-title,
#grve-product-tax-title .grve-title,
.woocommerce-page #grve-page-title .grve-title {
	font-family: " . impeka_grve_option( 'product_tax_title', 'inherit', 'font-family'  ) . ";
	font-weight: " . impeka_grve_option( 'product_tax_title', 'normal', 'font-weight'  ) . ";
	font-style: " . impeka_grve_option( 'product_tax_title', 'normal', 'font-style'  ) . ";
	font-size: " . impeka_grve_option( 'product_tax_title', '60px', 'font-size'  ) . ";
	text-transform: " . impeka_grve_option( 'product_tax_title', 'normal', 'text-transform'  ) . ";
	line-height: " . impeka_grve_option( 'product_tax_title', '72px', 'line-height'  ) . ";
	" . impeka_grve_css_option( 'product_tax_title', '0px', 'letter-spacing'  ) . "
}

#grve-product-title .grve-description,
#grve-product-tax-title .grve-description,
#grve-product-tax-title .grve-description p,
.woocommerce-page #grve-page-title .grve-description {
	font-family: " . impeka_grve_option( 'product_tax_description', 'inherit', 'font-family'  ) . ";
	font-weight: " . impeka_grve_option( 'product_tax_description', 'normal', 'font-weight'  ) . ";
	font-style: " . impeka_grve_option( 'product_tax_description', 'normal', 'font-style'  ) . ";
	font-size: " . impeka_grve_option( 'product_tax_description', '24px', 'font-size'  ) . ";
	text-transform: " . impeka_grve_option( 'product_tax_description', 'normal', 'text-transform'  ) . ";
	line-height: " . impeka_grve_option( 'product_tax_description', '30px', 'line-height'  ) . ";
	" . impeka_grve_css_option( 'product_tax_description', '0px', 'letter-spacing'  ) . "
}

";

/* Events Title
============================================================================= */
$typo_css .= "

#grve-event-title .grve-title,
#grve-event-tax-title .grve-title {
	font-family: " . impeka_grve_option( 'event_tax_title', 'inherit', 'font-family'  ) . ";
	font-weight: " . impeka_grve_option( 'event_tax_title', 'normal', 'font-weight'  ) . ";
	font-style: " . impeka_grve_option( 'event_tax_title', 'normal', 'font-style'  ) . ";
	font-size: " . impeka_grve_option( 'event_tax_title', '60px', 'font-size'  ) . ";
	text-transform: " . impeka_grve_option( 'event_tax_title', 'normal', 'text-transform'  ) . ";
	line-height: " . impeka_grve_option( 'event_tax_title', '72px', 'line-height'  ) . ";
	" . impeka_grve_css_option( 'event_tax_title', '0px', 'letter-spacing'  ) . "
}

#grve-event-title .grve-description,
#grve-event-tax-title .grve-description,
#grve-event-tax-title .grve-description p {
	font-family: " . impeka_grve_option( 'event_tax_description', 'inherit', 'font-family'  ) . ";
	font-weight: " . impeka_grve_option( 'event_tax_description', 'normal', 'font-weight'  ) . ";
	font-style: " . impeka_grve_option( 'event_tax_description', 'normal', 'font-style'  ) . ";
	font-size: " . impeka_grve_option( 'event_tax_description', '24px', 'font-size'  ) . ";
	text-transform: " . impeka_grve_option( 'event_tax_description', 'normal', 'text-transform'  ) . ";
	line-height: " . impeka_grve_option( 'event_tax_description', '30px', 'line-height'  ) . ";
	" . impeka_grve_css_option( 'event_tax_description', '0px', 'letter-spacing'  ) . "
}

";

/* Feature Section Custom */
$typo_css .= "

.grve-feature-subheading {
	font-family: " . impeka_grve_option( 'feature_subheading_font', 'inherit', 'font-family'  ) . ";
	font-weight: " . impeka_grve_option( 'feature_subheading_font', 'normal', 'font-weight'  ) . ";
	font-style: " . impeka_grve_option( 'feature_subheading_font', 'normal', 'font-style'  ) . ";
	font-size: " . impeka_grve_option( 'feature_subheading_font', '60px', 'font-size'  ) . ";
	text-transform: " . impeka_grve_option( 'feature_subheading_font', 'uppercase', 'text-transform'  ) . ";
	line-height: " . impeka_grve_option( 'feature_subheading_font', '112px', 'line-height'  ) . ";
	" . impeka_grve_css_option( 'feature_subheading_font', '0px', 'letter-spacing'  ) . "
}

.grve-feature-title {
	font-family: " . impeka_grve_option( 'feature_title_font', 'inherit', 'font-family'  ) . ";
	font-weight: " . impeka_grve_option( 'feature_title_font', 'normal', 'font-weight'  ) . ";
	font-style: " . impeka_grve_option( 'feature_title_font', 'normal', 'font-style'  ) . ";
	font-size: " . impeka_grve_option( 'feature_title_font', '60px', 'font-size'  ) . ";
	text-transform: " . impeka_grve_option( 'feature_title_font', 'uppercase', 'text-transform'  ) . ";
	line-height: " . impeka_grve_option( 'feature_title_font', '112px', 'line-height'  ) . ";
	" . impeka_grve_css_option( 'feature_title_font', '0px', 'letter-spacing'  ) . "
}

.grve-feature-text {
	font-family: " . impeka_grve_option( 'feature_desc_font', 'inherit', 'font-family'  ) . ";
	font-weight: " . impeka_grve_option( 'feature_desc_font', 'normal', 'font-weight'  ) . ";
	font-style: " . impeka_grve_option( 'feature_desc_font', 'normal', 'font-style'  ) . ";
	font-size: " . impeka_grve_option( 'feature_desc_font', '60px', 'font-size'  ) . ";
	text-transform: " . impeka_grve_option( 'feature_desc_font', 'uppercase', 'text-transform'  ) . ";
	line-height: " . impeka_grve_option( 'feature_desc_font', '112px', 'line-height'  ) . ";
	" . impeka_grve_css_option( 'feature_desc_font', '0px', 'letter-spacing'  ) . "
}

";


/* Special Text */
$typo_css .= "

.grve-quote-text,
blockquote p,
blockquote {
	font-family: " . impeka_grve_option( 'quote_text', 'inherit', 'font-family'  ) . ";
	font-weight: " . impeka_grve_option( 'quote_text', 'normal', 'font-weight'  ) . ";
	font-style: " . impeka_grve_option( 'quote_text', 'normal', 'font-style'  ) . ";
	font-size: " . impeka_grve_option( 'quote_text', '34px', 'font-size'  ) . ";
	text-transform: " . impeka_grve_option( 'quote_text', 'none', 'text-transform'  ) . ";
	line-height: " . impeka_grve_option( 'quote_text', '36px', 'line-height'  ) . ";
	" . impeka_grve_css_option( 'quote_text', '0px', 'letter-spacing'  ) . "
}

.grve-leader-text,
#grve-theme-wrapper .grve-leader-text,
.grve-leader-text p,
p.grve-leader-text {
	font-family: " . impeka_grve_option( 'leader_text', 'inherit', 'font-family'  ) . ";
	font-weight: " . impeka_grve_option( 'leader_text', 'normal', 'font-weight'  ) . ";
	font-style: " . impeka_grve_option( 'leader_text', 'normal', 'font-style'  ) . ";
	font-size: " . impeka_grve_option( 'leader_text', '34px', 'font-size'  ) . ";
	text-transform: " . impeka_grve_option( 'leader_text', 'none', 'text-transform'  ) . ";
	line-height: " . impeka_grve_option( 'leader_text', '36px', 'line-height'  ) . ";
	" . impeka_grve_css_option( 'leader_text', '0px', 'letter-spacing'  ) . "
}

.grve-subtitle,
.grve-subtitle p,
.grve-subtitle-text {
	font-family: " . impeka_grve_option( 'subtitle_text', 'inherit', 'font-family'  ) . ";
	font-weight: " . impeka_grve_option( 'subtitle_text', 'normal', 'font-weight'  ) . ";
	font-style: " . impeka_grve_option( 'subtitle_text', 'normal', 'font-style'  ) . ";
	font-size: " . impeka_grve_option( 'subtitle_text', '34px', 'font-size'  ) . ";
	text-transform: " . impeka_grve_option( 'subtitle_text', 'none', 'text-transform'  ) . ";
	line-height: " . impeka_grve_option( 'subtitle_text', '36px', 'line-height'  ) . ";
	" . impeka_grve_css_option( 'subtitle_text', '0px', 'letter-spacing'  ) . "
}

.grve-small-text,
span.wpcf7-not-valid-tip,
div.wpcf7-mail-sent-ok,
div.wpcf7-validation-errors,
#grve-top-bar .grve-language.grve-list,
#grve-top-bar .grve-language.grve-dropdown {
	font-family: " . impeka_grve_option( 'small_text', 'inherit', 'font-family'  ) . ";
	font-weight: " . impeka_grve_option( 'small_text', 'normal', 'font-weight'  ) . ";
	font-style: " . impeka_grve_option( 'small_text', 'normal', 'font-style'  ) . ";
	font-size: " . impeka_grve_option( 'small_text', '34px', 'font-size'  ) . ";
	text-transform: " . impeka_grve_option( 'small_text', 'none', 'text-transform'  ) . ";
	line-height: 1.4em;
	" . impeka_grve_css_option( 'small_text', '0px', 'letter-spacing'  ) . "
}

";

/* Link Text */
$typo_css .= "
.grve-link-text,
#cancel-comment-reply-link,
.grve-anchor-menu .grve-anchor-wrapper .grve-container > ul > li > a,
.grve-anchor-menu .grve-anchor-wrapper .grve-container ul.sub-menu li a {
	font-family: " . impeka_grve_option( 'link_text', 'inherit', 'font-family'  ) . ";
	font-weight: " . impeka_grve_option( 'link_text', 'normal', 'font-weight'  ) . ";
	font-style: " . impeka_grve_option( 'link_text', 'normal', 'font-style'  ) . ";
	font-size: " . impeka_grve_option( 'link_text', '13px', 'font-size'  ) . ";
	text-transform: " . impeka_grve_option( 'link_text', 'uppercase', 'text-transform'  ) . ";
	line-height: 1.4em;
	" . impeka_grve_css_option( 'link_text', '0px', 'letter-spacing'  ) . "
}
";

if ( '1' != impeka_grve_option( 'wp_tagcloud', '0' ) ) {
	$typo_css .= "
	.widget .tagcloud a {
		font-family: " . impeka_grve_option( 'link_text', 'inherit', 'font-family'  ) . " !important;
		font-weight: " . impeka_grve_option( 'link_text', 'normal', 'font-weight'  ) . " !important;
		font-style: " . impeka_grve_option( 'link_text', 'normal', 'font-style'  ) . " !important;
		font-size: " . impeka_grve_option( 'link_text', '13px', 'font-size'  ) . " !important;
		text-transform: " . impeka_grve_option( 'link_text', 'uppercase', 'text-transform'  ) . " !important;
		line-height: 1.4em !important;
		" . impeka_grve_css_option( 'link_text', '0px', 'letter-spacing', 'important' ) . "
	}
";
} else {
	$typo_css .= "
	.widget .tagcloud a {
		font-family: " . impeka_grve_option( 'link_text', 'inherit', 'font-family'  ) . " !important;
		font-weight: " . impeka_grve_option( 'link_text', 'normal', 'font-weight'  ) . " !important;
		font-style: " . impeka_grve_option( 'link_text', 'normal', 'font-style'  ) . " !important;
		text-transform: " . impeka_grve_option( 'link_text', 'uppercase', 'text-transform'  ) . " !important;
		line-height: 1.4em !important;
		" . impeka_grve_css_option( 'link_text', '0px', 'letter-spacing', 'important' ) . "
	}
";
}


/* Button Text */
$impeka_grve_btn_size = impeka_grve_option( 'button_text', '13px', 'font-size'  );
$impeka_grve_btn_size = filter_var( $impeka_grve_btn_size, FILTER_SANITIZE_NUMBER_INT );

$impeka_grve_btn_size_xsm = $impeka_grve_btn_size * 0.7;
$impeka_grve_btn_size_sm = $impeka_grve_btn_size * 0.85;
$impeka_grve_btn_size_lg = $impeka_grve_btn_size * 1.2;
$impeka_grve_btn_size_xlg = $impeka_grve_btn_size * 1.35;

$typo_css .= "
.grve-btn-text,
.grve-btn,
.grve-btn-video,
" . implode( ',', impeka_grve_get_button_classes() ) . " {
	font-family: " . impeka_grve_option( 'button_text', 'inherit', 'font-family'  ) . ";
	font-weight: " . impeka_grve_option( 'button_text', 'normal', 'font-weight'  ) . ";
	font-style: " . impeka_grve_option( 'button_text', 'normal', 'font-style'  ) . ";
	font-size: " . impeka_grve_option( 'button_text', '13px', 'font-size'  ) . ";
	text-transform: " . impeka_grve_option( 'button_text', 'uppercase', 'text-transform'  ) . ";
	line-height: 1.4em;
	" . impeka_grve_css_option( 'button_text', '0px', 'letter-spacing'  ) . "
}

.grve-button-text.grve-btn-extrasmall,
.grve-btn.grve-btn-extrasmall,
.grve-btn-text.grve-btn-extrasmall,
.grve-btn-video.grve-btn-extrasmall,
#grve-theme-wrapper .grve-contact-form.grve-form-btn-extrasmall input[type='submit']:not(.grve-custom-btn) {
	font-size: " . round( $impeka_grve_btn_size_xsm, 0 ) . "px !important;
}

.grve-button-text.grve-btn-small,
.grve-btn.grve-btn-small,
.grve-btn-text.grve-btn-small,
.grve-btn-video.grve-btn-small,
#grve-theme-wrapper .grve-contact-form.grve-form-btn-small input[type='submit']:not(.grve-custom-btn) {
	font-size: " . round( $impeka_grve_btn_size_sm, 0 ) . "px !important;
}

.grve-button-text.grve-btn-large,
.grve-btn.grve-btn-large,
.grve-btn-text.grve-btn-large,
.grve-btn-video.grve-btn-large,
#grve-theme-wrapper .grve-contact-form.grve-form-btn-large input[type='submit']:not(.grve-custom-btn) {
	font-size: " . round( $impeka_grve_btn_size_lg, 0 ) . "px !important;
}

.grve-button-text.grve-btn-extralarge,
.grve-btn.grve-btn-extralarge,
.grve-btn-text.grve-btn-extralarge,
.grve-btn-video.grve-btn-extralarge,
#grve-theme-wrapper .grve-contact-form.grve-form-btn-extralarge input[type='submit']:not(.grve-custom-btn) {
	font-size: " . round( $impeka_grve_btn_size_xlg, 0 ) . "px !important;
}


";

/* Widget Text */
$typo_css .= "

.grve-widget-title {
	font-family: " . impeka_grve_option( 'widget_title', 'inherit', 'font-family'  ) . ";
	font-weight: " . impeka_grve_option( 'widget_title', 'normal', 'font-weight'  ) . ";
	font-style: " . impeka_grve_option( 'widget_title', 'normal', 'font-style'  ) . ";
	font-size: " . impeka_grve_option( 'widget_title', '34px', 'font-size'  ) . ";
	text-transform: " . impeka_grve_option( 'widget_title', 'none', 'text-transform'  ) . ";
	line-height: " . impeka_grve_option( 'widget_title', '36px', 'line-height'  ) . ";
	" . impeka_grve_css_option( 'widget_title', '0px', 'letter-spacing'  ) . "
}

.widget,
.widgets,
.widget p {
	font-family: " . impeka_grve_option( 'widget_text', 'inherit', 'font-family'  ) . ";
	font-weight: " . impeka_grve_option( 'widget_text', 'normal', 'font-weight'  ) . ";
	font-style: " . impeka_grve_option( 'widget_text', 'normal', 'font-style'  ) . ";
	font-size: " . impeka_grve_option( 'widget_text', '34px', 'font-size'  ) . ";
	text-transform: " . impeka_grve_option( 'widget_text', 'none', 'text-transform'  ) . ";
	line-height: " . impeka_grve_option( 'widget_text', '36px', 'line-height'  ) . ";
	" . impeka_grve_css_option( 'widget_text', '0px', 'letter-spacing'  ) . "
}

";

/* Pagination Text */
$typo_css .= "

.grve-pagination-text {
	font-family: " . impeka_grve_option( 'pagination_text', 'inherit', 'font-family'  ) . ";
	font-weight: " . impeka_grve_option( 'pagination_text', 'normal', 'font-weight'  ) . ";
	font-style: " . impeka_grve_option( 'pagination_text', 'normal', 'font-style'  ) . ";
	font-size: " . impeka_grve_option( 'pagination_text', '34px', 'font-size'  ) . ";
	text-transform: " . impeka_grve_option( 'pagination_text', 'none', 'text-transform'  ) . ";
	line-height: " . impeka_grve_option( 'pagination_text', '36px', 'line-height'  ) . ";
	" . impeka_grve_css_option( 'pagination_text', '0px', 'letter-spacing'  ) . "
}

";

/* Single Post */
$typo_css .= "

.single-post #grve-single-content,
.single-product #tab-description,
#grve-about-author p,
.single-tribe_events #grve-single-content {
	font-size: " . impeka_grve_option( 'single_post_font', '18px', 'font-size'  ) . ";
	font-family: " . impeka_grve_option( 'single_post_font', 'inherit', 'font-family'  ) . ";
	font-weight: " . impeka_grve_option( 'single_post_font', 'normal', 'font-weight'  ) . ";
	line-height: " . impeka_grve_option( 'single_post_font', '36px', 'line-height'  ) . ";
	" . impeka_grve_css_option( 'single_post_font', '0px', 'letter-spacing'  ) . "
}

";


/* Custom Font Family */
$typo_css .= "
#grve-theme-wrapper .grve-custom-font-1 {
	font-family: " . impeka_grve_option( 'custom_font_family_1', 'inherit', 'font-family'  ) . ";
	font-weight: " . impeka_grve_option( 'custom_font_family_1', 'normal', 'font-weight'  ) . ";
	font-style: " . impeka_grve_option( 'custom_font_family_1', 'normal', 'font-style'  ) . ";
	text-transform: " . impeka_grve_option( 'custom_font_family_1', 'none', 'text-transform'  ) . ";
	" . impeka_grve_css_option( 'custom_font_family_1', '0px', 'letter-spacing'  ) . "
}
#grve-theme-wrapper .grve-custom-font-2 {
	font-family: " . impeka_grve_option( 'custom_font_family_2', 'inherit', 'font-family'  ) . ";
	font-weight: " . impeka_grve_option( 'custom_font_family_2', 'normal', 'font-weight'  ) . ";
	font-style: " . impeka_grve_option( 'custom_font_family_2', 'normal', 'font-style'  ) . ";
	text-transform: " . impeka_grve_option( 'custom_font_family_2', 'none', 'text-transform'  ) . ";
	" . impeka_grve_css_option( 'custom_font_family_2', '0px', 'letter-spacing'  ) . "
}
#grve-theme-wrapper .grve-custom-font-3 {
	font-family: " . impeka_grve_option( 'custom_font_family_3', 'inherit', 'font-family'  ) . ";
	font-weight: " . impeka_grve_option( 'custom_font_family_3', 'normal', 'font-weight'  ) . ";
	font-style: " . impeka_grve_option( 'custom_font_family_3', 'normal', 'font-style'  ) . ";
	text-transform: " . impeka_grve_option( 'custom_font_family_3', 'none', 'text-transform'  ) . ";
	" . impeka_grve_css_option( 'custom_font_family_3', '0px', 'letter-spacing'  ) . "
}
#grve-theme-wrapper .grve-custom-font-4 {
	font-family: " . impeka_grve_option( 'custom_font_family_4', 'inherit', 'font-family'  ) . ";
	font-weight: " . impeka_grve_option( 'custom_font_family_4', 'normal', 'font-weight'  ) . ";
	font-style: " . impeka_grve_option( 'custom_font_family_4', 'normal', 'font-style'  ) . ";
	text-transform: " . impeka_grve_option( 'custom_font_family_4', 'none', 'text-transform'  ) . ";
	" . impeka_grve_css_option( 'custom_font_family_4', '0px', 'letter-spacing'  ) . "
}

";

/* Blog Leader
============================================================================= */
$body_lineheight = impeka_grve_option( 'body_font', '36px', 'line-height'  );
$body_lineheight = filter_var( $body_lineheight, FILTER_SANITIZE_NUMBER_INT );
$typo_css .= "
.grve-blog-leader .grve-post-list .grve-post-content p {
	max-height: " . ( esc_attr( $body_lineheight ) * 2 ) . "px;
}
";

//Responsive Typography

$impeka_grve_responsive_fonts_group_headings =  array (
	'h1_font' => array(
		'selector'  => 'h1,.grve-h1,#grve-sliding-area .grve-search input[type="text"],.grve-dropcap span,p.grve-dropcap:first-letter',
		'custom_selector'  => '.grve-h1',
	),
	'h2_font' => array(
		'selector'  => 'h2,.grve-h2',
		'custom_selector'  => '.grve-h2',
	),
	'h3_font' => array(
		'selector'  => 'h3,.grve-h3',
		'custom_selector'  => '.grve-h3',
	),
	'h4_font' => array(
		'selector'  => 'h4,.grve-h4',
		'custom_selector'  => '.grve-h4',
	),
	'h5_font' => array(
		'selector'  => 'h5,.grve-h5,h3#reply-title',
		'custom_selector'  => '.grve-h5',
	),
	'h6_font' => array(
		'selector'  => 'h6,.grve-h6',
		'custom_selector'  => '.grve-h6',
	),
	'offcanvas_menu' => array(
		'selector' => '#grve-offcanvas-area ul.sub-menu li a,#grve-offcanvas-area li .grve-link-wrapper:not(.grve-menu-element-link-wrapper),#grve-offcanvas-area li.grve-first-level:not(.grve-menu-element-first-level) > .grve-link-wrapper:not(.grve-menu-element-link-wrapper) > a'
	)
);


$impeka_grve_responsive_fonts_group_1 =  array (
	'page_title' => array(
		'selector'  => '.grve-page-title,#grve-blog-title .grve-title,#grve-search-page-title .grve-title,#grve-portfolio-tax-title .grve-title',
	),
	'post_title' => array(
		'selector'  => '#grve-post-title .grve-title',
	),
	'post_simple_title' => array(
		'selector'  => '.grve-single-simple-title',
	),
	'portfolio_title' => array(
		'selector'  => '#grve-portfolio-title .grve-title',
	),
	'forum_title' => array(
		'selector'  => '#grve-forum-title .grve-title',
	),
	'product_simple_title' => array(
		'selector'  => '.grve-product-area .product_title',
	),
	'product_tax_title' => array(
		'selector'  => '#grve-product-title .grve-title,#grve-product-tax-title .grve-title,.woocommerce-page #grve-page-title .grve-title',
	),
	'event_tax_title' => array(
		'selector'  => '#grve-event-title .grve-title,#grve-event-tax-title .grve-title',
	),
	'feature_title_font' => array(
		'selector'  => '.grve-feature-title, #grve-intro .grve-first-title-text, #grve-intro .grve-second-title-text',
	),
	'feature_desc_font' => array(
		'selector'  => '.grve-feature-text',
	),
);

$impeka_grve_responsive_fonts_group_2 =  array (
	'page_description' => array(
		'selector'  => '#grve-page-title .grve-description,#grve-blog-title .grve-description,#grve-blog-title .grve-description p,#grve-search-page-title .grve-description,#grve-portfolio-tax-title .grve-description',
	),
	'post_title_meta' => array(
		'selector'  => '#grve-post-title .grve-title-categories',
	),
	'post_title_extra_meta' => array(
		'selector'  => '#grve-post-title .grve-post-meta, #grve-post-title .grve-post-meta li',
	),
	'post_title_desc' => array(
		'selector'  => '#grve-post-title .grve-description',
	),
	'portfolio_title_meta' => array(
		'selector'  => '#grve-portfolio-title .grve-title-categories',
	),
	'product_short_description' => array(
		'selector'  => '#grve-entry-summary .grve-short-description p',
	),
	'product_tax_description' => array(
		'selector'  => '#grve-product-title .grve-description,#grve-product-tax-title .grve-description,#grve-product-tax-title .grve-description p,.woocommerce-page #grve-page-title .grve-description',
	),
	'event_tax_description' => array(
		'selector'  => '#grve-event-title .grve-description,#grve-event-tax-title .grve-description,#grve-event-tax-title .grve-description p',
	),
	'feature_subheading_font' => array(
		'selector'  => '.grve-feature-subheading',
	),
	'quote_text' => array(
		'selector'  => '.grve-quote-text,blockquote p,blockquote',
	),
	'leader_text' => array(
		'selector'  => '.grve-leader-text,#grve-theme-wrapper .grve-leader-text,.grve-leader-text p,p.grve-leader-text',
	),
	'subtitle_text' => array(
		'selector'  => '.grve-subtitle,.grve-subtitle-text',
	),
	'link_text' => array(
		'selector'  => '#grve-theme-wrapper .grve-link-text',
	),
	'button_text' => array(
		'selector'  => '#grve-theme-wrapper .grve-btn-text,#grve-theme-wrapper .grve-btn-video,#grve-theme-wrapper .grve-btn' . implode( ',', impeka_grve_get_button_classes() ),
	),
	'main_menu_font' => array(
		'selector'  => '.grve-main-menu .grve-wrapper > ul > li > a,.grve-main-menu .grve-wrapper > ul > li.megamenu > ul > li > a,.grve-toggle-hiddenarea .grve-label',
	),
);

$typo_css .= impeka_grve_get_typography_responsive_css( $impeka_grve_responsive_fonts_group_headings, $impeka_grve_responsive_fonts_group_1 , $impeka_grve_responsive_fonts_group_2 );

// output dynamic css
echo impeka_grve_compress_css( $typo_css );

//Omit closing PHP tag to avoid accidental whitespace output errors.
