<?php
/**
 *  Dynamic css style for WooCommerce
 * 	@author		Greatives Team
 * 	@URI		https://greatives.eu
 */

$css = "";


/* Container Size
============================================================================= */
$css .= "

.grve-woo-error,
.grve-woo-info,
.grve-woo-message {
	max-width: " . impeka_grve_option( 'container_size', 1390 ) . "px;
}

";

/* Border Color
============================================================================= */
$css .= "
.woocommerce .cart-collaterals,
.woocommerce-checkout #payment,
.woocommerce-checkout #payment .payment_box,
.woocommerce-checkout .woocommerce-input-wrapper,
.woocommerce-checkout .woocommerce-input-wrapper .select2-selection,
.woocommerce-MyAccount-navigation li {
	border-color: " . impeka_grve_option( 'body_border_color' ) . ";
}
";

/* Primary Text
============================================================================= */
$css .= "

.woocommerce-pagination .page-numbers .page-numbers.current,
.woocommerce-pagination .page-numbers a.page-numbers:hover {
	color: " . impeka_grve_option( 'body_primary_1_color' ) . ";
}

";

/* Mini Cart Color
============================================================================= */
$css .= "
#grve-cart-area {
	background-color: " . impeka_grve_option( 'mini_cart_background_color' ) . ";
	color: " . impeka_grve_option( 'mini_cart_text_color' ) . ";
}
#grve-cart-area,
#grve-cart-area .grve-buttons-wrapper {
	border-color: " . impeka_grve_option( 'mini_cart_border_color' ) . ";
}
";

/* Product Navigation Bar
============================================================================= */
$css .= "
#grve-product-bar.grve-layout-1 {
	color: " . impeka_grve_option( 'product_bar_nav_text_color' ) . ";
	background-color: " . impeka_grve_option( 'product_bar_background_color' ) . ";
	padding-top: " . impeka_grve_option( 'product_nav_spacing', '', 'padding-top' ) . ";
	padding-bottom: " . impeka_grve_option( 'product_nav_spacing', '', 'padding-bottom'  ) . ";
}

#grve-product-bar.grve-layout-3 {
	color: " . impeka_grve_option( 'product_bar_nav_text_color' ) . ";
	padding-top: " . impeka_grve_option( 'product_nav_spacing', '', 'padding-top' ) . ";
	padding-bottom: " . impeka_grve_option( 'product_nav_spacing', '', 'padding-bottom'  ) . ";
	background-color: " . impeka_grve_option( 'product_bar_background_color' ) . ";
}

";

/* Header 5
============================================================================= */
$css .= "
.woocommerce-tabs .woocommerce-Reviews-title,
.woocommerce .cart-collaterals h2,
.woocommerce .woocommerce-checkout h3,
.grve-related-area .related > h2,
.grve-related-area .upsells > h2,
#grve-my-account-wrapper h2 {
	font-family: " . impeka_grve_option( 'h5_font', 'inherit', 'font-family'  ) . ";
	font-weight: " . impeka_grve_option( 'h5_font', 'normal', 'font-weight'  ) . ";
	font-style: " . impeka_grve_option( 'h5_font', 'normal', 'font-style'  ) . ";
	text-transform: " . impeka_grve_option( 'h5_font', ' none', 'text-transform'  ) . ";
	font-size: " . impeka_grve_option( 'h5_font', '18px', 'font-size'  ) . ";
	line-height: " . impeka_grve_option( 'h5_font', '20px', 'line-height'  ) . ";
	" . impeka_grve_css_option( 'h5_font', '0px', 'letter-spacing'  ) . "
}
";

/* Link Text
============================================================================= */
$css .= "
.woocommerce a.button:not(.add_to_cart_button):not(.product_type_simple):not(.product_type_grouped),
.woocommerce button.button,
.woocommerce input.button,
.woocommerce #respond input#submit,
.woocommerce-tabs ul.tabs {
	font-family: " . impeka_grve_option( 'link_text', 'inherit', 'font-family'  ) . ";
	font-weight: " . impeka_grve_option( 'link_text', 'normal', 'font-weight'  ) . ";
	font-style: " . impeka_grve_option( 'link_text', 'normal', 'font-style'  ) . ";
	font-size: " . impeka_grve_option( 'link_text', '13px', 'font-size'  ) . ";
	text-transform: " . impeka_grve_option( 'link_text', 'uppercase', 'text-transform'  ) . ";
	line-height: 1.4em;
	" . impeka_grve_css_option( 'link_text', '0px', 'letter-spacing'  ) . "
}
";

/* Leader Text
============================================================================= */
$css .= "
#grve-product-area p.price {
	font-family: " . impeka_grve_option( 'leader_text', 'inherit', 'font-family'  ) . ";
	font-weight: " . impeka_grve_option( 'leader_text', 'normal', 'font-weight'  ) . ";
	font-style: " . impeka_grve_option( 'leader_text', 'normal', 'font-style'  ) . ";
	font-size: " . impeka_grve_option( 'leader_text', '34px', 'font-size'  ) . ";
	text-transform: " . impeka_grve_option( 'leader_text', 'none', 'text-transform'  ) . ";
	line-height: " . impeka_grve_option( 'leader_text', '36px', 'line-height'  ) . ";
	" . impeka_grve_css_option( 'leader_text', '0px', 'letter-spacing'  ) . "
}
";

/* Small Text
============================================================================= */
$css .= "
#grve-product-area .product_meta,
#grve-product-area .product_meta span span,
#grve-product-area .product_meta span a,
.woocommerce span.onsale,
.woocommerce .woocommerce-review-link,
.woocommerce div.product form.cart .woocommerce-grouped-product-list-item__price,
.woocommerce-message,
.woocommerce-error,
.woocommerce-info {
	font-family: " . impeka_grve_option( 'small_text', 'inherit', 'font-family'  ) . ";
	font-weight: " . impeka_grve_option( 'small_text', 'normal', 'font-weight'  ) . ";
	font-style: " . impeka_grve_option( 'small_text', 'normal', 'font-style'  ) . ";
	font-size: " . impeka_grve_option( 'small_text', '34px', 'font-size'  ) . ";
	text-transform: " . impeka_grve_option( 'small_text', 'none', 'text-transform'  ) . ";
	line-height: 1.4em;
	" . impeka_grve_css_option( 'small_text', '0px', 'letter-spacing'  ) . "
}
";


/* Pagination Text
============================================================================= */
$css .= "

.woocommerce-pagination {
	font-family: " . impeka_grve_option( 'pagination_text', 'inherit', 'font-family'  ) . ";
	font-weight: " . impeka_grve_option( 'pagination_text', 'normal', 'font-weight'  ) . ";
	font-style: " . impeka_grve_option( 'pagination_text', 'normal', 'font-style'  ) . ";
	font-size: " . impeka_grve_option( 'pagination_text', '34px', 'font-size'  ) . ";
	text-transform: " . impeka_grve_option( 'pagination_text', 'none', 'text-transform'  ) . ";
	line-height: " . impeka_grve_option( 'pagination_text', '36px', 'line-height'  ) . ";
	" . impeka_grve_css_option( 'pagination_text', '0px', 'letter-spacing'  ) . "
}

";


$impeka_grve_woo_responsive_fonts_group_headings =  array (
	'h5_font' => array(
		'selector'  => '.woocommerce-tabs .woocommerce-Reviews-title, .woocommerce .cart-collaterals h2, .woocommerce .woocommerce-checkout h3, .grve-related-area .related > h2',
	),
);

$impeka_grve_woo_responsive_fonts_group_1 = array();

$impeka_grve_woo_responsive_fonts_group_2 =  array (
	'link_text' => array(
		'selector' => '.woocommerce a.button:not(.add_to_cart_button):not(.product_type_simple):not(.product_type_grouped),.woocommerce button.button,.woocommerce input.button,.woocommerce #respond input#submit,.woocommerce-tabs ul.tabs',
	),
	'leader_text' => array(
		'selector'  => '#grve-product-area p.price',
	),
	'small_text' => array(
		'selector' => '#grve-product-area .product_meta,#grve-product-area .product_meta span span,#grve-product-area .product_meta span a,.woocommerce span.onsale,.woocommerce .woocommerce-review-link,.woocommerce div.product form.cart .woocommerce-grouped-product-list-item__price,.woocommerce-message,.woocommerce-error,.woocommerce-info',
	),
);

$css .= impeka_grve_get_typography_responsive_css( $impeka_grve_woo_responsive_fonts_group_headings, $impeka_grve_woo_responsive_fonts_group_1 , $impeka_grve_woo_responsive_fonts_group_2 );

// output dynamic css
echo impeka_grve_compress_css( $css );

//Omit closing PHP tag to avoid accidental whitespace output errors.
