<?php

/*
*	Nav Menu Edit
*
* 	@version	1.0
* 	@author		Greatives Team
* 	@URI		https://greatives.eu
*/

function impeka_grve_wp_nav_menu_item_custom_fields( $item_id, $item, $depth, $args, $id ) {

	$color_options = impeka_grve_global_admin_param( 'button_color_selection' );
	$area_item_options = impeka_grve_global_admin_param( 'area_item_selection' );
?>
	<p class="grve-field-custom description description-wide">
		<label for="edit-grve-menu-item-megamenu-<?php echo esc_attr( $item_id ); ?>">
			<?php esc_html_e( 'Mega Menu', 'impeka' ); ?><br />
			<select class="widefat grve-menu-item-megamenu" id="edit-grve-menu-item-megamenu-<?php echo esc_attr($item_id); ?>" data-grve-menu-item data-grve-menu-name="<?php echo esc_attr( '_impeka_grve_menu_item_megamenu_' . $item_id ); ?>">
				<option value="" <?php selected( "", $item->grve_megamenu ); ?>><?php esc_html_e( 'None', 'impeka' ); ?></option>
				<option value="area-item" <?php selected( "area-item", $item->grve_megamenu ); ?>><?php esc_html_e( 'Area Item', 'impeka' ); ?></option>
				<option value="2" <?php selected( "2", $item->grve_megamenu ); ?>><?php esc_html_e( '2 Columns', 'impeka' ); ?></option>
				<option value="3" <?php selected( "3", $item->grve_megamenu ); ?>><?php esc_html_e( '3 Columns', 'impeka' ); ?></option>
				<option value="4" <?php selected( "4", $item->grve_megamenu ); ?>><?php esc_html_e( '4 Columns', 'impeka' ); ?></option>
				<option value="5" <?php selected( "5", $item->grve_megamenu ); ?>><?php esc_html_e( '5 Columns', 'impeka' ); ?></option>
				<option value="6" <?php selected( "6", $item->grve_megamenu ); ?>><?php esc_html_e( '6 Columns', 'impeka' ); ?></option>
			</select>
			<span class="description"><?php esc_html_e( 'Mega Menu should be used only on first level menu items.', 'impeka' ); ?></span>
		</label>
	</p>
	<p class="grve-field-custom description description-wide grve-menu-item-area-item-container grve-menu-dependency">
		<label for="edit-grve-menu-item-area-item-<?php echo esc_attr( $item_id ); ?>">
			<?php esc_html_e( 'Area Item', 'impeka' ); ?><br />
			<select class="widefat grve-menu-item-area-item" id="edit-grve-menu-item-area-item-<?php echo esc_attr($item_id); ?>" data-grve-menu-item data-grve-menu-name="<?php echo esc_attr( '_impeka_grve_menu_item_area_item_' . $item_id ); ?>">
				<option value="" <?php selected( "", $item->grve_area_item ); ?>><?php esc_html_e( 'None', 'impeka' ); ?></option>
				<?php impeka_grve_print_select_options( $area_item_options, $item->grve_area_item ); ?>
			</select>
		</label>
	</p>

	<p class="grve-field-custom description description-wide grve-menu-megamenu-container-size grve-menu-dependency">
		<label for="edit-grve-menu-megamenu-size-<?php echo esc_attr( $item_id ); ?>">
			<?php esc_html_e( 'Mega Menu Size', 'impeka' ); ?><br />
			<select class="widefat grve-menu-megamenu-size" id="edit-grve-menu-megamenu-size-<?php echo esc_attr($item_id); ?>" data-grve-menu-item data-grve-menu-name="<?php echo esc_attr( '_impeka_grve_menu_item_megamenu_size_' . $item_id ); ?>">
				<option value="fullwidth" <?php selected( "fullwidth", $item->grve_megamenu_size ); ?>><?php esc_html_e( 'Fullwidth', 'impeka' ); ?></option>
				<option value="large" <?php selected( "large", $item->grve_megamenu_size ); ?>><?php esc_html_e( 'Large', 'impeka' ); ?></option>
				<option value="medium" <?php selected( "medium", $item->grve_megamenu_size ); ?>><?php esc_html_e( 'Medium', 'impeka' ); ?></option>
				<option value="small" <?php selected( "small", $item->grve_megamenu_size ); ?>><?php esc_html_e( 'Small', 'impeka' ); ?></option>
			</select>
		</label>
	</p>

	<p class="grve-field-custom description description-wide">
		<label for="edit-grve-menu-item-link-mode-<?php echo esc_attr( $item_id ); ?>">
			<?php esc_html_e( 'Link Mode', 'impeka' ); ?><br />
			<select class="widefat" id="edit-grve-menu-item-link-mode-<?php echo esc_attr($item_id); ?>" data-grve-menu-item data-grve-menu-name="<?php echo esc_attr( '_impeka_grve_menu_item_link_mode_' . $item_id ); ?>">
				<option value="" <?php selected( "", $item->grve_link_mode ); ?>><?php esc_html_e( 'Default', 'impeka' ); ?></option>
				<option value="no-link" <?php selected( "no-link", $item->grve_link_mode ); ?>><?php esc_html_e( 'No Link', 'impeka' ); ?></option>
				<option value="hidden" <?php selected( "hidden", $item->grve_link_mode ); ?>><?php esc_html_e( 'Hidden', 'impeka' ); ?></option>
			</select>
		</label>
	</p>
	<p class="grve-field-custom description description-wide">
		<label for="edit-grve-menu-item-link-classes-<?php echo esc_attr( $item_id ); ?>">
			<?php esc_html_e( 'Link CSS Classes', 'impeka' ); ?><br />
			<input type="text" id="edit-grve-menu-item-link-classes-<?php echo esc_attr( $item_id ); ?>" class="widefat code" value="<?php echo esc_attr( $item->grve_link_classes ); ?>" data-grve-menu-item data-grve-menu-name="<?php echo esc_attr( '_impeka_grve_menu_item_link_classes_' . $item_id ); ?>"/>
		</label>
	</p>
	<p class="grve-field-custom description description-wide">
		<label for="edit-grve-menu-item-label-text-<?php echo esc_attr( $item_id ); ?>">
			<?php esc_html_e( 'Label Text', 'impeka' ); ?><br />
			<input id="edit-grve-menu-item-label-text-<?php echo esc_attr( $item_id ); ?>" type="text" class="widefat"  value="<?php echo esc_attr( $item->grve_label_text ); ?>" data-grve-menu-item data-grve-menu-name="<?php echo esc_attr( '_impeka_grve_menu_item_label_text_' . $item_id ); ?>"/>
		</label>
	</p>
	<p class="grve-field-custom description description-wide">
		<label for="edit-grve-item-label-color-<?php echo esc_attr( $item_id ); ?>">
			<?php esc_html_e( 'Label Color', 'impeka' ); ?><br />
			<select class="widefat" id="edit-grve-item-label-color-<?php echo esc_attr($item_id); ?>" data-grve-menu-item data-grve-menu-name="<?php echo esc_attr( '_impeka_grve_menu_item_label_color_' . $item_id ); ?>">
				<option value="" <?php selected( "", $item->grve_label_color ); ?>><?php esc_html_e( 'Default', 'impeka' ); ?></option>
				<?php impeka_grve_print_select_options( $color_options, $item->grve_label_color ); ?>
			</select>
		</label>
	</p>
	<p class="grve-field-custom description description-wide">
		<label for="edit-grve-menu-item-style-<?php echo esc_attr( $item_id ); ?>">
			<?php esc_html_e( 'Menu item Style', 'impeka' ); ?><br />
			<select class="widefat grve-menu-item-style" id="edit-grve-menu-item-style-<?php echo esc_attr($item_id); ?>" data-grve-menu-item data-grve-menu-name="<?php echo esc_attr( '_impeka_grve_menu_item_style_' . $item_id ); ?>">
				<option value="" <?php selected( "", $item->grve_style ); ?>><?php esc_html_e( 'Default', 'impeka' ); ?></option>
				<option value="button" <?php selected( "button", $item->grve_style ); ?>><?php esc_html_e( 'Button', 'impeka' ); ?></option>
				<option value="outline" <?php selected( "outline", $item->grve_style ); ?>><?php esc_html_e( 'Outline', 'impeka' ); ?></option>
			</select>
		</label>
	</p>
	<p class="grve-field-custom description description-wide grve-menu-item-color-container grve-menu-dependency">
		<label for="edit-grve-menu-item-color-<?php echo esc_attr( $item_id ); ?>">
			<?php esc_html_e( 'Menu Item Color', 'impeka' ); ?><br />
			<select class="widefat" id="edit-grve-menu-item-color-<?php echo esc_attr($item_id); ?>" data-grve-menu-item data-grve-menu-name="<?php echo esc_attr( '_impeka_grve_menu_item_color_' . $item_id ); ?>">
				<option value="" <?php selected( "", $item->grve_color ); ?>><?php esc_html_e( 'Default', 'impeka' ); ?></option>
				<?php impeka_grve_print_select_options( $color_options, $item->grve_color ); ?>
			</select>
		</label>
	</p>
	<p class="grve-field-custom description description-wide grve-menu-item-hover-color-container grve-menu-dependency">
		<label for="edit-grve-menu-item-hover-color-<?php echo esc_attr( $item_id ); ?>">
			<?php esc_html_e( 'Menu Item Hover color', 'impeka' ); ?><br />
			<select class="widefat" id="edit-grve-menu-item-hover-color-<?php echo esc_attr($item_id); ?>" data-grve-menu-item data-grve-menu-name="<?php echo esc_attr( '_impeka_grve_menu_item_hover_color_' . $item_id ); ?>">
				<option value="" <?php selected( "", $item->grve_hover_color ); ?>><?php esc_html_e( 'Default', 'impeka' ); ?></option>
				<?php impeka_grve_print_select_options( $color_options, $item->grve_hover_color ); ?>
			</select>
		</label>
	</p>
	<p class="grve-field-custom description description-wide grve-menu-item-shape-container grve-menu-dependency">
		<label for="edit-grve-menu-item-shape-<?php echo esc_attr( $item_id ); ?>">
			<?php esc_html_e( 'Menu item Shape', 'impeka' ); ?><br />
			<select class="widefat grve-menu-item-shape" id="edit-grve-menu-item-shape-<?php echo esc_attr($item_id); ?>" data-grve-menu-item data-grve-menu-name="<?php echo esc_attr( '_impeka_grve_menu_item_shape_' . $item_id ); ?>">
				<option value="round" <?php selected( "round", $item->grve_shape ); ?>><?php esc_html_e( 'Round', 'impeka' ); ?></option>
				<option value="extra-round" <?php selected( "extra-round", $item->grve_shape ); ?>><?php esc_html_e( 'Extra Round', 'impeka' ); ?></option>
				<option value="square" <?php selected( "square", $item->grve_shape ); ?>><?php esc_html_e( 'Square', 'impeka' ); ?></option>
			</select>
		</label>
	</p>
	<?php
		global $impeka_grve_awsome_fonts_list;
		$icons_array = $impeka_grve_awsome_fonts_list;
	?>
	<p class="grve-field-custom description description-wide">
		<label for="edit-grve-menu-item-icon-fontawesome-<?php echo esc_attr( $item_id ); ?>">
			<?php esc_html_e( 'Icon', 'impeka' ); ?><br />
			<select class="widefat" id="edit-grve-menu-item-icon-fontawesome-<?php echo esc_attr($item_id); ?>" data-grve-menu-item data-grve-menu-name="<?php echo esc_attr( '_impeka_grve_menu_item_icon_fontawesome_' . $item_id ); ?>">
				<option value="" <?php selected( "", $item->grve_icon_fontawesome ); ?>><?php esc_html_e( 'None', 'impeka' ); ?></option>
			<?php
				foreach ($icons_array as $icon) {
			?>
					<option value="fa fa-<?php echo esc_attr( $icon ); ?>" <?php selected( $item->grve_icon_fontawesome, 'fa fa-' . $icon ); ?>><?php echo esc_html( $icon ); ?></option>
			<?php
				}
			?>
			</select>
		</label>
	</p>
	<?php echo apply_filters( 'impeka_grve_edit_nav_menu_field', '', $item ); ?>
<?php
};

// add the action
add_action( 'wp_nav_menu_item_custom_fields', 'impeka_grve_wp_nav_menu_item_custom_fields', 10, 5 );

//Omit closing PHP tag to avoid accidental whitespace output errors.
