<?php

/*
*	Events Calendar helper functions and configuration
*
* 	@version	1.0
 * 	@author		Greatives Team
 * 	@URI		https://greatives.eu
*/

/**
 * Helper function to check if Events Calendar is enabled
 */
function impeka_grve_events_calendar_enabled() {

	if ( class_exists( 'Tribe__Events__Main' ) || class_exists( 'TribeEvents' ) ) {
		return true;
	}
	return false;
}

function impeka_grve_events_calendar_pro_enabled() {
	if ( class_exists( 'Tribe__Events__Pro__Main' ) || class_exists( 'TribeEventsPro' ) ) {
		return true;
	}
	return false;
}

/**
 * Helper function to check if is Events Calendar Overview Page
 */
function impeka_grve_events_calendar_is_overview() {
	if ( impeka_grve_events_calendar_enabled() ) {
		if ( tribe_is_list_view() || tribe_is_day() || tribe_is_month() ) {
			return true;
		}
	}
	if ( impeka_grve_events_calendar_pro_enabled() ) {
		if ( tribe_is_week() || tribe_is_map() || tribe_is_photo() ) {
			return true;
		}
	}
	return false;
}

//If Events Calendar plugin is not enabled return
if ( !impeka_grve_events_calendar_enabled() ) {
	return false;
}

/**
 * Prints title organizer meta
 */
function impeka_grve_event_organizer_title_meta() {
	$phone = tribe_get_organizer_phone();
	$email = tribe_get_organizer_email();
	$website = tribe_get_organizer_website_link();

	$details = array();
	if ( $tel = tribe_get_organizer_phone() ) {
		$details[] = '<span class="tel">' . esc_html( $tel ) . '</span>';
	}
	if ( $email = tribe_get_organizer_email() ) {
		$details[] = '<span class="email"> <a href="mailto:' . esc_attr( $email ) . '">' . esc_html( antispambot( $email ) ) . '</a> </span>';
	}
	if ( $link = tribe_get_organizer_website_link() ) {
		$details[] = '<span class="link"> <a href="' . esc_attr( $link ) . '">' . $link . '</a> </span>';
	}

	$html = join( '<span class="grve-tribe-events-divider">|</span>', $details );

	if ( ! empty( $html ) ) {
		return $html;
	} else {
		return "";
	}
}


function impeka_grve_print_event_bar() {
	if( impeka_grve_social_bar( 'event', 'check' ) ) {
		impeka_grve_social_bar ( 'event', 'layout-1' );
	}
	//Navigation Bar
	$nav_layout = impeka_grve_option( 'event_nav_layout', 'layout-1' );
	impeka_grve_nav_bar( 'event', $nav_layout );
}

//Omit closing PHP tag to avoid accidental whitespace output errors.