<?php

/*
*	Feature Helper functions
*
* 	@version	1.0
* 	@author		Greatives Team
* 	@URI		https://greatives.eu
*/


/**
 * Get Validate Header Skin
 */

function impeka_grve_validate_header_skin( $header_skin ) {

	$header_skins = array( 'default', 'dark', 'light' );
	if ( !in_array( $header_skin, $header_skins ) ) {
		$header_skin = 'default';
	}
	return $header_skin;

}

/**
 * Prints Header Feature Below
 */
function impeka_grve_print_header_feature_below() {
	$header_position = impeka_grve_global_param( 'header_position' );
	if( 'below' == $header_position ) {
		impeka_grve_print_header_feature();
	}
}
add_action( 'impeka_grve_theme_wrapper_top', 'impeka_grve_print_header_feature_below', 20 );

/**
 * Prints Header Feature Above
 */
function impeka_grve_print_header_feature_above() {
	$header_position = impeka_grve_global_param( 'header_position' );
	if( 'above' == $header_position ) {
		impeka_grve_print_header_feature();
	}
}
add_action( 'impeka_grve_theme_content_top', 'impeka_grve_print_header_feature_above', 10 );

/**
 * Prints Header Feature Section Page/Post/Portfolio
 */
function impeka_grve_print_header_feature() {

	//Skip for  Scrolling Full Width Sections Template
	if ( is_page_template( 'page-templates/template-full-page.php' ) ) {
		return false;
	}

	global $post;

	$is_woo_shop = impeka_grve_is_woo_shop();

	if ( is_singular() || $is_woo_shop ) {

		if ( $is_woo_shop ) {
			$post_id = wc_get_page_id( 'shop' );
		} else {
			$post_id = $post->ID;
		}
		$post_type = get_post_type( $post_id );
		$feature_section_post_types = impeka_grve_option( 'feature_section_post_types');
		$feature_section_post_types = apply_filters( 'impeka_grve_feature_section_post_types', $feature_section_post_types );
		if ( !empty( $feature_section_post_types ) && in_array( $post_type, $feature_section_post_types ) ) {

			$feature_section = get_post_meta( $post_id, '_impeka_grve_feature_section', true );
			$feature_settings = impeka_grve_array_value( $feature_section, 'feature_settings' );
			$feature_element = impeka_grve_array_value( $feature_settings, 'element' );

			if ( !empty( $feature_element ) ) {

				$feature_single_item = impeka_grve_array_value( $feature_section, 'single_item' );

				switch( $feature_element ) {
					case 'title':
						if ( !empty( $feature_single_item ) ) {
							impeka_grve_print_header_feature_single( $feature_settings, $feature_single_item, 'title' );
						}
						break;
					case 'image':
						if ( !empty( $feature_single_item ) ) {
							impeka_grve_print_header_feature_single( $feature_settings, $feature_single_item, 'image' );
						}
						break;
					case 'video':
						if ( !empty( $feature_single_item ) ) {
							impeka_grve_print_header_feature_single( $feature_settings, $feature_single_item, 'video' );
						}
						break;
					case 'youtube':
						if ( !empty( $feature_single_item ) ) {
							impeka_grve_print_header_feature_single( $feature_settings, $feature_single_item, 'youtube' );
						}
						break;
					case 'slider':
						$slider_items = impeka_grve_array_value( $feature_section, 'slider_items' );
						$slider_settings = impeka_grve_array_value( $feature_section, 'slider_settings' );
						if ( !empty( $slider_items ) ) {
							impeka_grve_print_header_feature_slider( $feature_settings, $slider_items, $slider_settings );
						}
						break;
					case 'map':
						$map_items = impeka_grve_array_value( $feature_section, 'map_items' );
						$map_settings = impeka_grve_array_value( $feature_section, 'map_settings' );
						if ( !empty( $map_items ) ) {
							impeka_grve_print_header_feature_map( $feature_settings, $map_items, $map_settings );
						}
						break;
					case 'revslider':
						$revslider_alias = impeka_grve_array_value( $feature_section, 'revslider_alias' );
						if ( !empty( $revslider_alias ) ) {
							impeka_grve_print_header_feature_revslider( $feature_settings, $revslider_alias, $feature_single_item );
						}
						break;
					case 'posts-slider-style-1':
					case 'posts-slider-style-2':
					case 'posts-slider-style-3':
					case 'posts-slider-style-4':
						$post_type_slider_settings = impeka_grve_array_value( $feature_section, 'post_type_slider_settings' );
						if ( !empty( $post_type_slider_settings ) ) {
							impeka_grve_print_header_feature_posts_slider( $post_type_slider_settings, $feature_element );
						}
						break;
					default:
						break;

				}
			}
		}
	}
}


/**
 * Prints Overlay Container
 */
function impeka_grve_print_overlay_container( $item ) {

	$pattern_overlay = impeka_grve_array_value( $item, 'pattern_overlay' );
	$color_overlay = impeka_grve_array_value( $item, 'color_overlay', 'black' );
	$opacity_overlay = impeka_grve_array_value( $item, 'opacity_overlay', '0' );

	if ( 'gradient' == $color_overlay ) {
		$gradient_overlay_custom_1 = impeka_grve_array_value( $item, 'gradient_overlay_custom_1', '#034e90' );
		$gradient_overlay_custom_1_opacity = impeka_grve_array_value( $item, 'gradient_overlay_custom_1_opacity', '0.90' );
		$gradient_overlay_custom_1_rgba = impeka_grve_get_hex2rgba( $gradient_overlay_custom_1 , $gradient_overlay_custom_1_opacity );
		$gradient_overlay_custom_2 = impeka_grve_array_value( $item, 'gradient_overlay_custom_2', '#19b4d7' );
		$gradient_overlay_custom_2_opacity = impeka_grve_array_value( $item, 'gradient_overlay_custom_2_opacity', '0.90' );
		$gradient_overlay_custom_2_rgba = impeka_grve_get_hex2rgba( $gradient_overlay_custom_2 , $gradient_overlay_custom_2_opacity );
		$gradient_overlay_direction  = impeka_grve_array_value( $item, 'gradient_overlay_direction', '90' );
	} else {
		$color_overlay_custom = impeka_grve_array_value( $item, 'color_overlay_custom', '#000000' );
		$color_overlay_custom = impeka_grve_get_color( $color_overlay, $color_overlay_custom );
		$overlay_rgba = impeka_grve_get_hex2rgba( $color_overlay_custom , $opacity_overlay );
	}

	if ( 'default' == $pattern_overlay ) {
		echo '<div class="grve-pattern"></div>';
	}

	$overlay_classes = array('grve-bg-overlay');
	$overlay_string = implode( ' ', $overlay_classes );
	if ( 'gradient' == $color_overlay ) {
		echo '<div class="' . esc_attr( $overlay_string ) . '" style="background:' . esc_attr( $gradient_overlay_custom_1_rgba ) . '; background: linear-gradient(' . esc_attr( $gradient_overlay_direction ) . 'deg,' . esc_attr( $gradient_overlay_custom_1_rgba ) . ' 0%,' . esc_attr( $gradient_overlay_custom_2_rgba ) . ' 100%);"></div>';
	} else {
		if ( '0' != $opacity_overlay && 'transparent' != $opacity_overlay && !empty( $opacity_overlay ) ) {
			echo '<div class="' . esc_attr( $overlay_string ) . '" style="background-color:' . esc_attr( $overlay_rgba ) . ';"></div>';
		}
	}

}

/**
 * Prints Background Image Container
 */
function impeka_grve_print_bg_image_container( $item ) {

	$bg_position = impeka_grve_array_value( $item, 'bg_position', 'center-center' );
	$bg_tablet_sm_position = impeka_grve_array_value( $item, 'bg_tablet_sm_position' );

	$bg_image_id = impeka_grve_array_value( $item, 'bg_image_id' );
	$bg_image_size = impeka_grve_array_value( $item, 'bg_image_size' );


	$full_src = wp_get_attachment_image_src( $bg_image_id, 'impeka-grve-fullscreen' );
	$image_url = '';
	if( $full_src ){
		$image_url = $full_src[0];
	}
	if( !empty( $image_url ) ) {

		//Adaptive Background URL

		if ( empty ( $bg_image_size ) ) {
			$bg_image_size = impeka_grve_option( 'feature_section_bg_size' );
		}

		$image_url = impeka_grve_get_adaptive_url( $bg_image_id, $bg_image_size );

		$bg_image_classes = array( 'grve-bg-image' );
		$bg_image_classes[] = 'grve-bg-' . $bg_position;
		if ( !empty( $bg_tablet_sm_position ) ) {
			$bg_image_classes[] = 'grve-bg-tablet-sm-' . $bg_tablet_sm_position;
		}
		$bg_image_classes[] = 'grve-bg-image-id-' . $bg_image_id;

		$bg_image_classes_string = implode( ' ', $bg_image_classes );

		echo '<div class="' . esc_attr( $bg_image_classes_string ) . '" style="background-image: url(' . esc_url( $image_url ) . ');"></div>';
	}

}

/**
 * Prints Flickity Background Image Container
 */
function impeka_grve_print_flickity_bg_image_container( $item ) {
	$bg_image_id = impeka_grve_array_value( $item, 'bg_image_id' );
	$bg_image_size = impeka_grve_array_value( $item, 'bg_image_size' );

	$full_src = wp_get_attachment_image_src( $bg_image_id, 'impeka-grve-fullscreen' );
	$image_url = '';
	if( $full_src ){
		$image_url = $full_src[0];
	}
	if( !empty( $image_url ) ) {

		//Adaptive Background URL

		if ( empty ( $bg_image_size ) ) {
			$bg_image_size = impeka_grve_option( 'feature_section_bg_size' );
		}

		$image_url = impeka_grve_get_adaptive_url( $bg_image_id, $bg_image_size );

		$bg_image_classes = array( 'grve-bg-image' );
		$bg_image_classes[] = 'grve-bg-center-center';
		$bg_image_classes[] = 'grve-bg-image-id-' . $bg_image_id;

		$bg_image_classes_string = implode( ' ', $bg_image_classes );

		echo '<div class="' . esc_attr( $bg_image_classes_string ) . '" data-flickity-bg-lazyload="' . esc_url( $image_url ) . '"></div>';
	}

}

/**
 * Prints Background Video Container
 */
function impeka_grve_print_bg_video_container( $item ) {

	$bg_video_webm = impeka_grve_array_value( $item, 'video_webm' );
	$bg_video_mp4 = impeka_grve_array_value( $item, 'video_mp4' );
	$bg_video_ogv = impeka_grve_array_value( $item, 'video_ogv' );
	$bg_video_poster = impeka_grve_array_value( $item, 'video_poster', 'no' );
	$bg_video_device = impeka_grve_array_value( $item, 'video_device', 'no' );
	$bg_image_id = impeka_grve_array_value( $item, 'bg_image_id' );

	$loop = impeka_grve_array_value( $item, 'video_loop', 'yes' );
	$muted = impeka_grve_array_value( $item, 'video_muted', 'yes' );

	$full_src = wp_get_attachment_image_src( $bg_image_id, 'impeka-grve-fullscreen' );
	$image_url = '';
	if ( $full_src ) {
		$image_url = esc_url( $full_src[0] );
	}

	$video_poster = $playsinline = '';

	if ( !empty( $image_url ) && 'yes' == $bg_video_poster ) {
		$video_poster = $image_url;
	}
	if ( wp_is_mobile() ) {
		if ( 'yes' == $bg_video_device ) {
			if( !empty( $image_url ) ) {
				$video_poster = $image_url;
			}
			$muted = 'yes';
			$playsinline = 'yes';
		} else {
			return;
		}
	}

	$video_settings = array(
		'preload' => 'auto',
		'autoplay' => 'yes',
		'loop' => $loop,
		'muted' => $muted,
		'poster' => $video_poster,
		'playsinline' => $playsinline,
	);
	$video_settings = apply_filters( 'impeka_grve_feature_video_settings', $video_settings );


	if ( !empty ( $bg_video_webm ) || !empty ( $bg_video_mp4 ) || !empty ( $bg_video_ogv ) ) {
?>
		<div class="grve-bg-video grve-html5-bg-video" data-video-device="<?php echo esc_attr( $bg_video_device ); ?>">
			<video <?php echo impeka_grve_print_media_video_settings( $video_settings );?>>
			<?php if ( !empty ( $bg_video_webm ) ) { ?>
				<source src="<?php echo esc_url( $bg_video_webm ); ?>" type="video/webm">
			<?php } ?>
			<?php if ( !empty ( $bg_video_mp4 ) ) { ?>
				<source src="<?php echo esc_url( $bg_video_mp4 ); ?>" type="video/mp4">
			<?php } ?>
			<?php if ( !empty ( $bg_video_ogv ) ) { ?>
				<source src="<?php echo esc_url( $bg_video_ogv ); ?>" type="video/ogg">
			<?php } ?>
			</video>
		</div>
<?php
	}
}

/**
 * Prints Background YouTube/Vimeo Container
 */
function impeka_grve_print_bg_youtube_container( $item ) {
	$video_url = impeka_grve_array_value( $item, 'video_url' );
	$video_start = impeka_grve_array_value( $item, 'video_start' );
	$video_end = impeka_grve_array_value( $item, 'video_end' );
	if( empty( $video_url ) ) {
		return;
	}
	if ( impeka_grve_extract_youtube_id( $video_url ) ) {
		wp_enqueue_script( 'youtube-iframe-api' );
		$wrapper_attributes = array();
		$wrapper_attributes[] = 'data-video-bg-url="' . esc_attr( $video_url ) . '"';
		if ( !empty( $video_start ) ) {
			$wrapper_attributes[] = 'data-video-start="' . esc_attr( $video_start ) . '"';
		}
		if ( !empty( $video_end ) ) {
			$wrapper_attributes[] = 'data-video-end="' . esc_attr( $video_end ) . '"';
		}
		$wrapper_attributes[] = 'class="grve-bg-video grve-yt-bg-video"';
?>		<div <?php echo implode( ' ', $wrapper_attributes ); ?>></div>
<?php
	} elseif ( false !== strpos( $video_url, 'vimeo.com' ) ) {
		wp_enqueue_script( 'vimeo-api' );
		$wrapper_attributes = array();
		$wrapper_attributes[] = 'id="' . esc_attr( uniqid('vimeo-') ) . '"';
		$wrapper_attributes[] = 'data-vimeo-url="' . esc_attr( $video_url ) . '"';
		$wrapper_attributes[] = 'data-vimeo-autoplay="true"';
		$wrapper_attributes[] = 'data-vimeo-autopause="false"';
		$wrapper_attributes[] = 'data-vimeo-loop="true"';
		$wrapper_attributes[] = 'data-vimeo-background="true"';
		$wrapper_attributes[] = 'data-vimeo-muted="true"';

		$wrapper_attributes[] = 'class="grve-bg-video grve-vimeo-bg-video"';
?>
		<div <?php echo implode( ' ', $wrapper_attributes ); ?>></div>
<?php
	}
}

/**
 * Prints Bottom Separator Container
 */
function impeka_grve_print_bottom_seperator_container( $feature_settings ) {
	$separator_bottom = impeka_grve_array_value( $feature_settings, 'separator_bottom' );
	$separator_bottom_color = impeka_grve_array_value( $feature_settings, 'separator_bottom_color' );
	$separator_bottom_size = impeka_grve_array_value( $feature_settings, 'separator_bottom_size' );

	if( !empty ( $separator_bottom ) ) {
		echo '<div class="grve-separator-bottom" style="height:' . esc_attr( $separator_bottom_size ) . '">';
		echo impeka_grve_build_separator( $separator_bottom, $separator_bottom_color );
		echo '</div>';
	}
}

/**
 * Get Feature Section data
 */
function impeka_grve_get_feature_data( $feature_settings, $item_type, $item_effect = '', $el_class = '' ) {

	$wrapper_attributes = array();
	$style = "";

	//Background Color
	$bg_color = impeka_grve_array_value( $feature_settings, 'bg_color', 'black' );
	if ( 'gradient' == $bg_color ) {
		$bg_gradient_color_1  = impeka_grve_array_value( $feature_settings, 'bg_gradient_color_1', '#034e90' );
		$bg_gradient_color_1_rgba = impeka_grve_get_hex2rgba( $bg_gradient_color_1 , 1 );
		$bg_gradient_color_2  = impeka_grve_array_value( $feature_settings, 'bg_gradient_color_2', '#19b4d7' );
		$bg_gradient_color_2_rgba = impeka_grve_get_hex2rgba( $bg_gradient_color_2 , 1 );
		$bg_gradient_direction  = impeka_grve_array_value( $feature_settings, 'bg_gradient_direction', '90' );
	} else {
		$bg_color_custom = impeka_grve_array_value( $feature_settings, 'bg_color_custom', '#000000' );
		$bg_color_custom = impeka_grve_get_color( $bg_color, $bg_color_custom );
	}

	//Data and Style
	if( 'revslider' != $item_type ) {
		$feature_size = impeka_grve_array_value( $feature_settings, 'size' );
		$feature_height = impeka_grve_array_value( $feature_settings, 'height', '60' );
		$feature_min_height = impeka_grve_array_value( $feature_settings, 'min_height', '200' );
		if ( 'gradient' == $bg_color ) {
			$style .= impeka_grve_get_css_color( 'background', $bg_gradient_color_1_rgba );
			$style .= 'background: linear-gradient(' . $bg_gradient_direction . 'deg,' . $bg_gradient_color_1_rgba . ' 0%,' . $bg_gradient_color_2_rgba .' 100%);';
		} else {
			$style .= 'background-color: ' . esc_attr( $bg_color_custom ) . ';';
		}
		if ( !empty($feature_size) ) {
			if ( empty( $feature_height ) ) {
				$feature_height = "60";
			}
			$style .= 'min-height:' . esc_attr( $feature_min_height ) . 'px;';
			$wrapper_attributes[] = 'data-height="' . esc_attr( $feature_height ) . '"';
		}
		$wrapper_attributes[] = 'style="'. esc_attr( $style ) . '"';
	}

	//Classes
	$feature_item_classes = array( 'grve-with-' . $item_type  );

	if( 'revslider' != $item_type ) {
		if ( empty( $feature_size ) ) {
			$feature_item_classes[] = 'grve-fullscreen';
		} else {
			if ( is_numeric( $feature_height ) ) { //Custom Size
				$feature_item_classes[] = 'grve-custom-size';
			} else {
				$feature_item_classes[] = 'grve-' . $feature_height . '-height';
			}
		}

		if ( !empty( $item_effect ) ) {
			$feature_item_classes[] = 'grve-bg-' . $item_effect;
		}
	}

	$separator_bottom = impeka_grve_array_value( $feature_settings, 'separator_bottom' );
	$separator_bottom_size = impeka_grve_array_value( $feature_settings, 'separator_bottom_size' );

	if ( !empty( $separator_bottom ) && '100%' ==  $separator_bottom_size ) {
		$feature_item_classes[] = 'grve-separator-fullheight';
	}

	if ( !empty ( $el_class ) ) {
		$feature_item_classes[] = $el_class;
	}
	$feature_item_class_string = implode( ' ', $feature_item_classes );

	//Add Classes
	$wrapper_attributes[] = 'class="' . esc_attr( $feature_item_class_string ) . '"';

	return $wrapper_attributes;
}


/**
 * Get Feature Section data
 */
function impeka_grve_get_posts_slider_data( $feature_settings, $mode = ''  ) {

	$wrapper_attributes = array();
	$style = "";

	//Background Color
	$bg_color = impeka_grve_array_value( $feature_settings, 'bg_color', 'black' );
	if ( 'gradient' == $bg_color ) {
		$bg_gradient_color_1  = impeka_grve_array_value( $feature_settings, 'bg_gradient_color_1', '#034e90' );
		$bg_gradient_color_1_rgba = impeka_grve_get_hex2rgba( $bg_gradient_color_1 , 1 );
		$bg_gradient_color_2  = impeka_grve_array_value( $feature_settings, 'bg_gradient_color_2', '#19b4d7' );
		$bg_gradient_color_2_rgba = impeka_grve_get_hex2rgba( $bg_gradient_color_2 , 1 );
		$bg_gradient_direction  = impeka_grve_array_value( $feature_settings, 'bg_gradient_direction', '90' );
	} else {
		$bg_color_custom = impeka_grve_array_value( $feature_settings, 'bg_color_custom', '#000000' );
		$bg_color_custom = impeka_grve_get_color( $bg_color, $bg_color_custom );
	}

	//Data and Style

	if ( 'gradient' == $bg_color ) {
		$style .= impeka_grve_get_css_color( 'background', $bg_gradient_color_1_rgba );
		$style .= 'background: linear-gradient(' . $bg_gradient_direction . 'deg,' . $bg_gradient_color_1_rgba . ' 0%,' . $bg_gradient_color_2_rgba .' 100%);';
	} else {
		$style .= 'background-color: ' . esc_attr( $bg_color_custom ) . ';';
	}
	if ( 'all' == $mode ) {
		$style .= ' height: 100vh;';
	}

	$wrapper_attributes[] = 'style="'. esc_attr( $style ) . '"';

	if ( 'all' == $mode ) {
		$el_class  = impeka_grve_array_value( $feature_settings, 'el_class' );

		$feature_item_classes = array( 'grve-with-posts-slider' );
		$feature_item_classes[] = 'grve-fullscreen';
		if ( !empty( $el_class ) ) {
			$feature_item_classes[] = $el_class;
		}
		$feature_item_class_string = implode( ' ', $feature_item_classes );
		$wrapper_attributes[] = 'class="' . esc_attr( $feature_item_class_string ) . '"';
	}

	return $wrapper_attributes;
}

/**
 * Get Feature Height
 */
function impeka_grve_get_feature_height( $feature_settings ) {

	//Data and Style
	$feature_style_height = '';

	$feature_size = impeka_grve_array_value( $feature_settings, 'size' );
	$feature_height = impeka_grve_array_value( $feature_settings, 'height', '60' );
	$feature_min_height = impeka_grve_array_value( $feature_settings, 'min_height', '200' );
	if ( !empty($feature_size) ) {
		if ( is_numeric( $feature_height ) ) { //Custom Size
			$feature_style_height = 'style="height:' . esc_attr( $feature_height ) . 'vh; min-height:' . esc_attr( $feature_min_height ) . 'px;"';
		} else {
			$feature_style_height = 'style="min-height:' . esc_attr( $feature_min_height ) . 'px;"';
		}
	}
	return $feature_style_height;
}

/**
 * Get Posts Slider Category Slugs
 */
function impeka_grve_get_feature_posts_slider_tax_query( $categories = array(), $term_slug = '' ) {

	$cat_slugs = $tax_query = array();
	if( ! empty( $categories ) ) {
		$cat_ids = explode( ",", $categories );
		foreach ( $cat_ids as $cat_id ) {
			$category_term = get_term( $cat_id, $term_slug );
			if ( isset( $category_term ) ) {
				$cat_slugs[] = $category_term->slug;
			}
		}
	}
	if( ! empty( $cat_slugs ) ) {
		$tax_query = array (
			array(
			  'taxonomy' => $term_slug,
			  'field' => 'slug',
			  'terms' => $cat_slugs,
			  'operator' => 'IN'
			)
		);
	}
	return $tax_query;
}

/**
 * Prints Header Section Predefined Slider
 */
if ( !function_exists('impeka_grve_print_header_feature_posts_slider') ) {
	function impeka_grve_print_header_feature_posts_slider( $item, $item_type ) {

		$post_method = impeka_grve_array_value( $item, 'post_method', 'latest' );
		$post_type = impeka_grve_array_value( $item, 'post_type', 'post' );
		$post_categories = impeka_grve_array_value( $item, 'post_categories' );
		$portfolio_categories = impeka_grve_array_value( $item, 'portfolio_categories' );
		$product_categories = impeka_grve_array_value( $item, 'product_categories' );
		$posts_per_page = impeka_grve_array_value( $item, 'posts_per_page', '5' );
		$include_posts = impeka_grve_array_value( $item, 'include_posts', '' );

		$include_ids = array();
		if( !empty( $include_posts ) && 'specific_posts' == $post_method ){
			$include_ids = explode( ',', $include_posts );
			$args = array(
				'post_type' => 'any',
				'post_status'=>'publish',
				'posts_per_page' => -1,
				'post__in' => $include_ids,
				'paged' => 1,
				'orderby' => 'post__in',
			);
		} else {
			$args = array(
				'post_type' => $post_type,
				'post_status'=>'publish',
				'posts_per_page' => $posts_per_page,
				'paged' => 1,
				'ignore_sticky_posts' => 1,
				'orderby' => 'date',
				'order' => 'DESC',
			);
			if( 'latest' == $post_method ){
				switch( $post_type ) {
					case 'portfolio':
						$tax_query = impeka_grve_get_feature_posts_slider_tax_query( $portfolio_categories, 'portfolio_category' );
						if( ! empty( $tax_query ) ) {
							$args['tax_query'] = $tax_query;
						}
					break;
					case 'product':
						$tax_query = impeka_grve_get_feature_posts_slider_tax_query( $product_categories, 'product_cat' );
						if( ! empty( $tax_query ) ) {
							$args['tax_query'] = $tax_query;
						}
					break;
					case 'post':
					default:
						$args['cat'] = $post_categories;
					break;
				}
			}
		}

		$query = new WP_Query( $args );
		if ( $query->have_posts() ) {
			get_template_part( 'templates/feature-section/posts-slider/' . $item_type . '/posts-slider', 'start', $item  );

			while ( $query->have_posts() ) {
				$query->the_post();
				get_template_part( 'templates/feature-section/posts-slider/' . $item_type . '/posts-slider', 'slide', $item );
			}
			wp_reset_postdata();

			get_template_part( 'templates/feature-section/posts-slider/' . $item_type . '/posts-slider', 'end', $item );

		}
	}
}

/**
 * Prints Header Section Feature Single Item
 */
if ( !function_exists('impeka_grve_print_header_feature_single') ) {
	function impeka_grve_print_header_feature_single( $feature_settings, $item, $item_type  ) {

		if( 'image' == $item_type ) {
			$item_effect = impeka_grve_array_value( $item, 'image_effect' );
		} elseif( 'video' == $item_type ) {
			$item_effect = impeka_grve_array_value( $item, 'video_effect' );
		} else {
			$item_effect = '';
		}

		$el_class = impeka_grve_array_value( $item, 'el_class' );

		$feature_data = impeka_grve_get_feature_data( $feature_settings, $item_type, $item_effect, $el_class );

	?>
		<div id="grve-feature-section" <?php echo implode( ' ', $feature_data ); ?>>
			<?php do_action( 'impeka_grve_header_feature_single_content_before' ); ?>
			<div class="grve-wrapper clearfix" <?php echo impeka_grve_get_feature_height( $feature_settings ); ?>>
				<?php impeka_grve_print_header_feature_content( $feature_settings, $item, $item_type ); ?>
			</div>
			<?php do_action( 'impeka_grve_header_feature_single_content_after' ); ?>
			<div class="grve-background-wrapper">
			<?php
				if( 'image' == $item_type || 'video' == $item_type || 'youtube' == $item_type ) {
					impeka_grve_print_bg_image_container( $item );
				}
				if( 'video' == $item_type ) {
					impeka_grve_print_bg_video_container( $item );
				}
				if( 'youtube' == $item_type ) {
					impeka_grve_print_bg_youtube_container( $item );
				}
				impeka_grve_print_overlay_container( $item  );
			?>
			</div>
			<?php impeka_grve_print_bottom_seperator_container( $feature_settings ); ?>
		</div>
	<?php
	}
}

/**
 * Prints Feature Slider
 */
if ( !function_exists('impeka_grve_print_header_feature_slider') ) {
	function impeka_grve_print_header_feature_slider( $feature_settings, $slider_items, $slider_settings ) {

		$slider_speed = impeka_grve_array_value( $slider_settings, 'slideshow_speed', '3500' );
		$slider_pause = impeka_grve_array_value( $slider_settings, 'slider_pause', 'no' );
		$slider_transition = impeka_grve_array_value( $slider_settings, 'transition', 'slide' );
		$slider_nav_style = impeka_grve_array_value( $slider_settings, 'nav_style', '1' );
		$slider_arrows = impeka_grve_array_value( $slider_settings, 'arrows', 'yes' );
		$slider_effect = impeka_grve_array_value( $slider_settings, 'slider_effect', '' );
		$slider_pagination = impeka_grve_array_value( $slider_settings, 'pagination', 'yes' );

		$feature_data = impeka_grve_get_feature_data( $feature_settings, 'slider', $slider_effect  );

		$header_skin = isset( $slider_items[0]['header_skin'] ) ? $slider_items[0]['header_skin'] : 'default';

	?>
		<div id="grve-feature-section" <?php echo implode( ' ', $feature_data ); ?>>

			<div class="grve-carousel-navigation grve-skin-<?php echo esc_attr( $header_skin ); ?> grve-navigation-style-<?php echo esc_attr( $slider_nav_style ); ?>">
				<?php echo impeka_grve_element_navigation( $slider_nav_style, $slider_arrows, $slider_pagination ); ?>
			</div>

			<?php do_action( 'impeka_grve_header_feature_slider_before' ); ?>
			<div id="grve-feature-slider" class="flickity" data-slider-speed="<?php echo esc_attr( $slider_speed ); ?>" data-slider-pause="<?php echo esc_attr( $slider_pause ); ?>" data-slider-transition="<?php echo esc_attr( $slider_transition ); ?>">

	<?php

				foreach ( $slider_items as $item ) {

					$header_skin = impeka_grve_array_value( $item, 'header_skin', 'default' );
					$header_skin = impeka_grve_validate_header_skin( $header_skin );

					$slide_type = impeka_grve_array_value( $item, 'type' );
					$slide_post_id = impeka_grve_array_value( $item, 'post_id' );
					if( 'post' == $slide_type &&  !empty( $slide_post_id ) ) {
						if( has_post_thumbnail( $slide_post_id ) && empty( $item['bg_image_id'] ) ) {
							$item['bg_image_id'] = get_post_thumbnail_id( $slide_post_id );
						}
					}

					$el_class = impeka_grve_array_value( $item, 'el_class' );
					$el_id = impeka_grve_array_value( $item, 'id', uniqid() );

	?>
					<div class="grve-slider-item grve-slider-item-id-<?php echo esc_attr( $el_id ); ?> <?php echo esc_attr( $el_class ); ?>" data-header-color="<?php echo esc_attr( $header_skin ); ?>">
						<?php do_action( 'impeka_grve_header_feature_slide_content_before' ); ?>
						<div class="grve-wrapper clearfix" <?php echo impeka_grve_get_feature_height( $feature_settings ); ?>>
							<?php impeka_grve_print_header_feature_content( $feature_settings, $item ); ?>
						</div>
						<?php do_action( 'impeka_grve_header_feature_slide_content_after' ); ?>
						<div class="grve-background-wrapper">
						<?php
							impeka_grve_print_bg_image_container( $item );
							impeka_grve_print_overlay_container( $item  );
						?>
						</div>
					</div>
	<?php
				}
	?>
			</div>
			<?php do_action( 'impeka_grve_header_feature_slider_after' ); ?>
			<?php impeka_grve_print_bottom_seperator_container( $feature_settings ); ?>
		</div>
	<?php
	}
}

/**
 * Prints Header Feature Map
 */
if ( !function_exists('impeka_grve_print_header_feature_map') ) {
	function impeka_grve_print_header_feature_map( $feature_settings, $map_items, $map_settings ) {

		wp_enqueue_script( 'impeka-google-maps');
		wp_enqueue_script( 'impeka-openstreetmap-maps');

		$feature_data = impeka_grve_get_feature_data( $feature_settings, 'map' );

		$map_marker_type = impeka_grve_array_value( $map_settings, 'marker_type' );
		$map_marker_bg_color = impeka_grve_array_value( $map_settings, 'marker_bg_color', 'primary-1' );
		if ( empty( $map_marker_type ) ) {
			$map_marker = impeka_grve_array_value( $map_settings, 'marker', get_template_directory_uri() . '/images/markers/markers.png' );
			$point_type = 'image';
			$point_bg_color = '';
		} else {
			$map_marker = get_template_directory_uri() . '/images/markers/transparent.png';
			$point_type = $map_marker_type;
			$point_bg_color = $map_marker_bg_color;
		}
		$map_zoom = impeka_grve_array_value( $map_settings, 'zoom', 14 );
		$map_disable_style = impeka_grve_array_value( $map_settings, 'disable_style', 'no' );

		$map_lat = impeka_grve_array_value( $map_items[0], 'lat', '51.516221' );
		$map_lng = impeka_grve_array_value( $map_items[0], 'lng', '-0.136986' );

		$map_attributes = array();
		$map_attributes[] = 'data-lat="' . esc_attr( $map_lat ) . '"';
		$map_attributes[] = 'data-lng="' . esc_attr( $map_lng ) . '"';
		$map_attributes[] = 'data-zoom="' . esc_attr( $map_zoom ) . '"';
		$map_attributes[] = 'data-disable-style="' . esc_attr( $map_disable_style ) . '"';

	?>
		<div id="grve-feature-section" <?php echo implode( ' ', $feature_data ); ?>>
		<div class="grve-map grve-wrapper clearfix" <?php echo impeka_grve_get_feature_height( $feature_settings ); ?> <?php echo implode( ' ', $map_attributes ); ?>><?php echo apply_filters( 'impeka_grve_privacy_gmap_fallback', '', $map_lat, $map_lng ); ?></div>
		<?php
			foreach ( $map_items as $map_item ) {
				impeka_grve_print_feature_map_point( $map_item, $map_marker, $point_type, $point_bg_color );
			}
		?>
		</div>
	<?php
	}
}

function impeka_grve_print_feature_map_point( $map_item, $default_marker, $point_type = 'image', $point_bg_color = ''  ) {

	$map_lat = impeka_grve_array_value( $map_item, 'lat', '51.516221' );
	$map_lng = impeka_grve_array_value( $map_item, 'lng', '-0.136986' );
	$map_marker = impeka_grve_array_value( $map_item, 'marker' );
	if ( !empty( $map_marker ) ) {
		$point_type = 'image';
	} else {
		$map_marker = $default_marker;
	}
	$map_marker = str_replace( array( 'http:', 'https:' ), '', $map_marker );

	$map_title = impeka_grve_array_value( $map_item, 'title' );
	$map_infotext = impeka_grve_array_value( $map_item, 'info_text','' );
	$map_infotext_open = impeka_grve_array_value( $map_item, 'info_text_open', 'no' );

	$button_text = impeka_grve_array_value( $map_item, 'button_text' );
	$button_url = impeka_grve_array_value( $map_item, 'button_url' );
	$button_target = impeka_grve_array_value( $map_item, 'button_target', '_self' );
	$button_class = impeka_grve_array_value( $map_item, 'button_class' );

	$map_point_attributes = array();
	$map_point_attributes[] = 'data-point-lat="' . esc_attr( $map_lat ) . '"';
	$map_point_attributes[] = 'data-point-lng="' . esc_attr( $map_lng ) . '"';
	$map_point_attributes[] = 'data-point-title="' . esc_attr( $map_title ) . '"';
	$map_point_attributes[] = 'data-point-open="' . esc_attr( $map_infotext_open ) . '"';
	$map_point_attributes[] = 'data-point-type="' . esc_attr( $point_type ) . '"';
	if( 'image' != $point_type ) {
		$map_point_attributes[] = 'data-point-bg-color="' . esc_attr( $point_bg_color ) . '"';
	}

?>
	<div style="display:none" class="grve-map-point" data-point-marker="<?php echo esc_url( $map_marker ); ?>" <?php echo implode( ' ', $map_point_attributes ); ?>>
		<?php if ( !empty( $map_title ) || !empty( $map_infotext ) || !empty( $button_text ) ) { ?>
		<div class="grve-map-infotext">
			<?php if ( !empty( $map_title ) ) { ?>
			<h6 class="grve-infotext-title"><?php echo esc_html( $map_title ); ?></h6>
			<?php } ?>
			<?php if ( !empty( $map_infotext ) ) { ?>
			<p class="grve-infotext-description"><?php echo wp_kses_post( $map_infotext ); ?></p>
			<?php } ?>
			<?php if ( !empty( $button_text ) ) { ?>
			<a class="grve-infotext-link <?php echo esc_attr( $button_class ); ?>" href="<?php echo esc_url( $button_url ); ?>" target="<?php echo esc_attr( $button_target ); ?>"><?php echo esc_html( $button_text ); ?></a>
			<?php } ?>
		</div>
		<?php } ?>
	</div>
<?php

}

/**
 * Prints Header Feature Revolution Slider
 */
if ( !function_exists('impeka_grve_print_header_feature_revslider') ) {
	function impeka_grve_print_header_feature_revslider( $feature_settings, $revslider_alias, $item  ) {

		$el_class = impeka_grve_array_value( $item, 'el_class' );
		$feature_data = impeka_grve_get_feature_data( $feature_settings, 'revslider', '', $el_class );

	?>
		<div id="grve-feature-section" <?php echo implode( ' ', $feature_data ); ?>>
			<?php echo do_shortcode( '[rev_slider ' . $revslider_alias . ']' ); ?>
		</div>

	<?php
	}
}


/**
 * Prints Header Feature Go to Section ( Bottom Arrow )
 */
if ( !function_exists('impeka_grve_print_feature_go_to_section') ) {
	function impeka_grve_print_feature_go_to_section( $item ) {

		$arrow_enabled = impeka_grve_array_value( $item, 'arrow_enabled', 'no' );
		$arrow_text = impeka_grve_array_value( $item, 'arrow_text' );
		$arrow_color = impeka_grve_array_value( $item, 'arrow_color', 'white' );
		$arrow_color_custom = impeka_grve_array_value( $item, 'arrow_color_custom', '#ffffff' );
		$arrow_color_custom = impeka_grve_get_color( $arrow_color, $arrow_color_custom );
		$arrow_align = impeka_grve_array_value( $item, 'content_align', 'center' );

		if( 'yes' == $arrow_enabled ) {
?>
		<div class="grve-goto-section-wrapper grve-arrow-<?php echo esc_attr( $arrow_align ); ?>">
			<div class="grve-container">
				<div class="grve-goto-section grve-goto-first-section" style=" color: <?php echo esc_attr( $arrow_color_custom ); ?>;"><?php echo impeka_grve_get_svg_icon('arrow-small-down'); ?></div>
			</div>
		</div>
<?php
		} else if( 'text' == $arrow_enabled ) {
?>
		<div class="grve-goto-section-wrapper grve-arrow-<?php echo esc_attr( $arrow_align ); ?>">
			<div class="grve-container">
				<div id="grve-goto-section" class="grve-goto-section grve-goto-first-section grve-small-text grve-goto-section-text" style=" color: <?php echo esc_attr( $arrow_color_custom ); ?>;">
					<?php echo esc_html( $arrow_text ); ?>
				</div>
			</div>
		</div>
<?php
		}

	}
}

/**
 * Prints Header Feature Content Image
 */
function impeka_grve_print_feature_content_image( $item ) {

	$media_id = impeka_grve_array_value( $item, 'content_image_id', '0' );
	$media_size = impeka_grve_array_value( $item, 'content_image_size', 'medium' );

	if( !empty( $media_id ) ) {
?>
		<div class="grve-graphic">
			<?php echo wp_get_attachment_image( $media_id, $media_size ); ?>
		</div>
<?php
	}

}


/**
 * Prints Header Section Feature Content
 */
if ( !function_exists('impeka_grve_print_header_feature_content') ) {
	function impeka_grve_print_header_feature_content( $feature_settings, $item, $mode = ''  ) {

		$feature_size = impeka_grve_array_value( $feature_settings, 'size' );

		$title = impeka_grve_array_value( $item, 'title' );
		$caption = impeka_grve_array_value( $item, 'caption' );
		$subheading = impeka_grve_array_value( $item, 'subheading' );

		$subheading_tag = impeka_grve_array_value( $item, 'subheading_tag', 'div' );
		$title_tag = impeka_grve_array_value( $item, 'title_tag', 'div' );
		$caption_tag = impeka_grve_array_value( $item, 'caption_tag', 'div' );

		$subheading_heading = impeka_grve_array_value( $item, 'subheading_heading', 'feature-subtitle' );
		$title_heading = impeka_grve_array_value( $item, 'title_heading', 'feature-title' );
		$caption_heading = impeka_grve_array_value( $item, 'caption_heading', 'feature-text' );

		$content_container_classes = array( 'grve-content' );
		$subheading_classes = array( 'grve-subheading', 'grve-title-categories', 'grve-' . $subheading_heading );
		$title_classes = array( 'grve-title', 'grve-' . $title_heading );
		$caption_classes = array( 'grve-description', 'grve-' . $caption_heading );
		$title_meta_classes = array( 'grve-title-meta-content', 'grve-link-text' );
		$content_classes = array( 'grve-title-content-wrapper' );


		//Content Container Classes
		$content_position = impeka_grve_array_value( $item, 'content_position', 'center-center' );
		$container_size = impeka_grve_array_value( $item, 'container_size' );
		$content_container_classes[] = 'grve-align-' . $content_position;
		if ( 'large' == $container_size ) {
			$content_container_classes[] = 'grve-fullwidth';
		}

		$content_bg_color = impeka_grve_array_value( $item, 'content_bg_color', 'none' );
		$content_align = impeka_grve_array_value( $item, 'content_align', 'center' );
		$content_size = impeka_grve_array_value( $item, 'content_size', 'container' );
		if ( 'custom' != $content_bg_color ) {
			$content_classes[] = 'grve-bg-' . $content_bg_color;
		}
		$content_classes[] = 'grve-align-' . $content_align;
		$content_classes[] = 'grve-content-' . $content_size;


		$subheading_color = impeka_grve_array_value( $item, 'subheading_color', 'white' );
		$title_color = impeka_grve_array_value( $item, 'title_color', 'white' );
		$caption_color = impeka_grve_array_value( $item, 'caption_color', 'white' );

		$subheading_family = impeka_grve_array_value( $item, 'subheading_family' );
		$title_family = impeka_grve_array_value( $item, 'title_family' );
		$caption_family = impeka_grve_array_value( $item, 'caption_family' );

		if ( !empty( $subheading_family ) ) {
			$subheading_classes[] = 'grve-' . $subheading_family;
		}
		if ( !empty( $title_family ) ) {
			$title_classes[] = 'grve-' . $title_family;
		}
		if ( !empty( $caption_family ) ) {
			$caption_classes[] = 'grve-' . $caption_family;
		}

		if ( 'custom' != $subheading_color ) {
			$subheading_classes[] = 'grve-text-' . $subheading_color;
			$title_meta_classes[] = 'grve-text-' . $subheading_color;
		}
		if ( 'custom' != $title_color ) {
			$title_classes[] = 'grve-text-' . $title_color;
		}
		if ( 'custom' != $caption_color ) {
			$caption_classes[] = 'grve-text-' . $caption_color;
		}

		$content_container_classes = implode( ' ', $content_container_classes );
		$subheading_classes = implode( ' ', $subheading_classes );
		$title_classes = implode( ' ', $title_classes );
		$caption_classes = implode( ' ', $caption_classes );
		$title_meta_classes = implode( ' ', $title_meta_classes );
		$content_classes = implode( ' ', $content_classes );

		$content_animation = impeka_grve_array_value( $item, 'content_animation', 'none' );

		$button = impeka_grve_array_value( $item, 'button' );
		$button2 = impeka_grve_array_value( $item, 'button2' );

		$button_text = impeka_grve_array_value( $button, 'text' );
		$button_text2 = impeka_grve_array_value( $button2, 'text' );

		$slide_type = impeka_grve_array_value( $item, 'type' );
		$slide_post_id = impeka_grve_array_value( $item, 'post_id' );
		if( 'post' == $slide_type &&  !empty( $slide_post_id ) ) {
			$title = get_the_title ( $slide_post_id  );
			$caption = get_post_meta( $slide_post_id, '_impeka_grve_description', true );
			$link_url = get_permalink( $slide_post_id ) ;
		}

	?>
		<div class="<?php echo esc_attr( $content_container_classes ); ?>" data-animation="<?php echo esc_attr( $content_animation ); ?>">
			<div class="grve-container">
				<div class="<?php echo esc_attr( $content_classes ); ?>">
				<?php if( 'post' == $slide_type &&  !empty( $slide_post_id ) ) { ?>
					<?php if ( 'post' == get_post_type( $slide_post_id ) ) { ?>
					<div class="<?php echo esc_attr( $subheading_classes ); ?>">
						<?php impeka_grve_print_post_title_categories( $slide_post_id ); ?>
					</div>
					<?php } ?>
					<a href="<?php echo esc_url( $link_url ); ?>">
						<<?php echo tag_escape( $title_tag ); ?> class="<?php echo esc_attr( $title_classes ); ?>"><span><?php echo wp_kses_post( $title ); ?></span></<?php echo tag_escape( $title_tag ); ?>>
					</a>
					<?php if ( !empty( $caption ) ) { ?>
					<<?php echo tag_escape( $caption_tag ); ?> class="<?php echo esc_attr( $caption_classes ); ?>"><span><?php echo wp_kses_post( $caption ); ?></span></<?php echo tag_escape( $caption_tag ); ?>>
					<?php } ?>
					<?php if ( 'post' == get_post_type( $slide_post_id ) ) { ?>
					<div class="<?php echo esc_attr( $title_meta_classes ); ?>">
					<?php impeka_grve_print_feature_post_title_meta( $slide_post_id ); ?>
					</div>
					<?php } ?>
				<?php } else { ?>
					<?php impeka_grve_print_feature_content_image( $item ); ?>
					<?php if ( !empty( $subheading ) ) { ?>
					<<?php echo tag_escape( $subheading_tag ); ?> class="<?php echo esc_attr( $subheading_classes ); ?>"><span><?php echo wp_kses_post( $subheading ); ?></span></<?php echo tag_escape( $subheading_tag ); ?>>
					<?php } ?>
					<?php if ( !empty( $title ) ) { ?>
					<<?php echo tag_escape( $title_tag ); ?> class="<?php echo esc_attr( $title_classes ); ?>"><span><?php echo wp_kses_post( $title ); ?></span></<?php echo tag_escape( $title_tag ); ?>>
					<?php } ?>
					<?php if ( !empty( $caption ) ) { ?>
					<<?php echo tag_escape( $caption_tag ); ?> class="<?php echo esc_attr( $caption_classes ); ?>"><span><?php echo wp_kses_post( $caption ); ?></span></<?php echo tag_escape( $caption_tag ); ?>>
					<?php } ?>

					<?php
						if ( !empty( $button_text ) || !empty( $button_text2 ) ) {
							$btn1_class = $btn2_class = 'grve-btn-1';
							if ( !empty( $button_text ) && !empty( $button_text2 ) ) {
								$btn2_class = 'grve-btn-2';
							}
					?>
						<div class="grve-button-wrapper">
							<?php impeka_grve_print_feature_button( $button, $btn1_class ); ?>
							<?php impeka_grve_print_feature_button( $button2, $btn2_class ); ?>
						</div>
					<?php
						}
					?>
				<?php } ?>
				</div>
			</div>
			<?php impeka_grve_print_feature_go_to_section( $item ); ?>
		</div>
	<?php
	}
}

/**
 * Prints Header Feature Button
 */
function impeka_grve_print_feature_button( $item, $extra_class = 'grve-btn-1' ) {

	$url = impeka_grve_array_value( $item, 'url', '#' );
	$target = impeka_grve_array_value( $item, 'target', '_self' );
    $link_atts = array();
	$link_atts[] = 'href="' . esc_url( $url ) . '"';
	if ( '_blank' == $target ) {
		$link_atts[] = 'target="_blank"';
		$link_atts[] = 'rel="noopener noreferrer"';
	}
	$item['link_atts'] = $link_atts;
	$item['extra_class'] = $extra_class;

	get_template_part( 'templates/general/button', '', $item );

}

//Omit closing PHP tag to avoid accidental whitespace output errors.
