<?php

/**
 *	Gutenberg/Editor functions
 *
 * 	@version	1.0
 * 	@author		Greatives Team
 * 	@URI		https://greatives.eu
 */

/**
 * Enqueue WordPress theme styles within Gutenberg.
 */
function impeka_grve_enqueue_block_editor_assets() {
	$impeka_version = trim ( IMPEKA_GRVE_THEME_VERSION );
	if ( impeka_grve_woocommerce_enabled() ) {
		wp_enqueue_style( 'impeka-woocommerce-custom', get_template_directory_uri() . '/css/woocommerce-custom.css', array(), esc_attr( $impeka_version ), 'all' );
	}
	if ( class_exists( 'Impeka_Gutenberg_Extension_Plugin') ) {
		wp_enqueue_script( 'owl-carousel', get_template_directory_uri() . '/js/plugins/owl.carousel.min.js', array( 'jquery' ), '2.3.4', true );
		wp_enqueue_script( 'flickity', get_template_directory_uri() . '/js/plugins/flickity.min.js', array( 'jquery' ), '2.2.1', true );
		wp_enqueue_script( 'imagesloaded' );
		wp_enqueue_script( 'isotope', get_template_directory_uri() . '/js/plugins/isotope.min.js', array( 'jquery' ), '3.0.6', true );
		wp_enqueue_script( 'impeka-main-editor', get_template_directory_uri() . '/js/main-editor.js', array( 'jquery' ), esc_attr( $impeka_version ), true );
	}
	wp_enqueue_style( 'impeka-grve-editor-dynamic', get_template_directory_uri() .  '/includes/css/grve-editor-dynamic.css' , array(), esc_attr( $impeka_version ), 'all' );
	wp_add_inline_style( 'impeka-grve-editor-dynamic', impeka_grve_editor_dynamic_css() );
}
add_action( 'enqueue_block_editor_assets', 'impeka_grve_enqueue_block_editor_assets' );

function impeka_grve_editor_custom_title_colors_css( $post ) {

	$post_id = $post->ID;
	$mode = $post->post_type;

	$image_url = '';
	$css = '';

	$impeka_grve_page_title = array(
		'title_color' => impeka_grve_option( $mode . '_title_color' ),
		'title_color_custom' => impeka_grve_option( $mode . '_title_color_custom' ),
		'content_bg_color' => impeka_grve_option( $mode . '_title_content_bg_color' ),
		'content_bg_color_custom' => impeka_grve_option( $mode . '_title_content_bg_color_custom' ),
		'content_position' => impeka_grve_option( $mode . '_title_content_position' ),
		'container_size' => impeka_grve_option( $mode . '_title_container_size' ),
		'content_size' => impeka_grve_option( $mode . '_title_content_size' ),
		'content_alignment' => impeka_grve_option( $mode . '_title_content_alignment' ),
		'bg_mode' => impeka_grve_option( $mode . '_title_bg_mode' ),
		'bg_image_id' => impeka_grve_option( $mode . '_title_bg_image', '', 'id' ),
		'bg_position' => impeka_grve_option( $mode . '_title_bg_position' ),
		'bg_color' => impeka_grve_option( $mode . '_title_bg_color', 'dark' ),
		'bg_color_custom' => impeka_grve_option( $mode . '_title_bg_color_custom' ),
	);

	$impeka_grve_custom_title_options = get_post_meta( $post_id, '_impeka_grve_custom_title_options', true );
	$impeka_grve_title_style = impeka_grve_option( $mode . '_title_style' );
	$impeka_grve_page_title_custom = impeka_grve_array_value( $impeka_grve_custom_title_options, 'custom', $impeka_grve_title_style );

	if ( 'simple' !== $impeka_grve_page_title_custom ) {
		if ( 'custom' == $impeka_grve_page_title_custom ) {
			$impeka_grve_page_title = $impeka_grve_custom_title_options;
		}

		$content_size = impeka_grve_array_value( $impeka_grve_page_title, 'content_size', 'large' );
		$title_width = impeka_grve_array_value( impeka_grve_get_post_title_width_array(), $content_size , '1170' );
		$title_align = impeka_grve_array_value( $impeka_grve_page_title, 'content_alignment', 'center' );

		$content_bg_color = impeka_grve_array_value( $impeka_grve_page_title, 'content_bg_color', 'custom' );
		if ( 'custom' == $content_bg_color ) {
			$content_bg_color = impeka_grve_array_value( $impeka_grve_page_title, 'content_bg_color_custom', '#ffffff' );
		} elseif ( 'none' == $content_bg_color   ) {
			$content_bg_color = 'none';
		} else {
			$content_bg_color = impeka_grve_array_value( impeka_grve_get_color_array(), $content_bg_color , '#ffffff' );
		}

		$title_bg_color = impeka_grve_array_value( $impeka_grve_page_title, 'bg_color', 'custom' );
		if ( 'custom' == $title_bg_color ) {
			$title_bg_color = impeka_grve_array_value( $impeka_grve_page_title, 'bg_color_custom', '#ffffff' );
		} elseif ( 'transparent' == $title_bg_color ) {
			$title_bg_color = 'transparent';
		} else {
			$title_bg_color = impeka_grve_array_value( impeka_grve_get_color_array(), $title_bg_color , '#ffffff' );
		}

		$title_color = impeka_grve_array_value( $impeka_grve_page_title, 'title_color', 'dark' );
		if ( 'custom' == $title_color ) {
			$title_color = impeka_grve_array_value( $impeka_grve_page_title, 'title_color_custom', '#000000' );
		} else {
			$title_color = impeka_grve_array_value( impeka_grve_get_color_array(), $title_color , '#000000' );
		}


		$bg_mode = impeka_grve_array_value( $impeka_grve_page_title, 'bg_mode', 'color' );
		if ( 'color' != $bg_mode ) {

			$bg_position = impeka_grve_array_value( $impeka_grve_page_title, 'bg_position', 'center-center' );

			$media_id = '0';

			if ( 'featured' == $bg_mode ) {
				if( has_post_thumbnail( $post_id ) ) {
					$media_id = get_post_thumbnail_id( $post_id );
				}
			} else if ( 'custom' ) {
				$media_id = impeka_grve_array_value( $impeka_grve_page_title, 'bg_image_id' );
			}
			$full_src = wp_get_attachment_image_src( $media_id, 'crocal-eutf-fullscreen' );
			if ( $full_src ) {
				$image_url = $full_src[0];
			}
		}


		$css .= "
			.editor-styles-wrapper .edit-post-visual-editor__post-title-wrapper {
				background-color: " . esc_attr( $title_bg_color ) . ";
			}
			.editor-styles-wrapper .wp-block.editor-post-title {
				max-width: " . esc_attr( $title_width ) . "px;
				padding-top: 60px;
				padding-bottom: 60px;
			}
			.editor-styles-wrapper .editor-post-title__block .editor-post-title__input,
			.editor-styles-wrapper .editor-post-title {
				text-align: " . esc_attr( $title_align ) .";
				color: " . esc_attr( $title_color ) . ";
			}
		";

		if ( 'none' != $content_bg_color ) {
		$css .= "
			.editor-styles-wrapper .editor-post-title {
				background-color: " . esc_attr( $content_bg_color ) . ";
				vertical-align: middle;
				padding: 4% 5%;
				-webkit-box-shadow: 0 1px 2px rgba(0, 0, 0, 0.2);
				-moz-box-shadow: 0 1px 2px rgba(0,0,0,0.2);
				box-shadow: 0 1px 2px rgba(0, 0, 0, 0.2);
			}
		";
		}
		if( !empty( $image_url ) ) {
		$css .= "
			.editor-styles-wrapper .edit-post-visual-editor__post-title-wrapper {
				background-image: url(" . esc_url( $image_url ) . ");
				background-position: center center;
				background-size: cover;
				background-repeat: no-repeat;
			}
		";
		}

		if ( 'post' == $post->post_type	) {
			$css .= "
				.editor-styles-wrapper .editor-post-title__block .editor-post-title__input,
				.editor-styles-wrapper .editor-post-title {
					font-family: " . impeka_grve_option( 'post_title', 'inherit', 'font-family'  ) . ";
					font-weight: " . impeka_grve_option( 'post_title', 'normal', 'font-weight'  ) . ";
					font-style: " . impeka_grve_option( 'post_title', 'normal', 'font-style'  ) . ";
					font-size: " . impeka_grve_option( 'post_title', '60px', 'font-size'  ) . ";
					text-transform: " . impeka_grve_option( 'post_title', 'uppercase', 'text-transform'  ) . ";
					line-height: " . impeka_grve_option( 'post_title', '112px', 'line-height'  ) . ";
					" . impeka_grve_css_option( 'post_title', '0px', 'letter-spacing'  ) . "
				}
			";
		} elseif ( 'portfolio' == $post->post_type	) {
			$css .= "
				.editor-styles-wrapper .editor-post-title__block .editor-post-title__input,
				.editor-styles-wrapper .editor-post-title {
					font-family: " . impeka_grve_option( 'portfolio_title', 'inherit', 'font-family'  ) . ";
					font-weight: " . impeka_grve_option( 'portfolio_title', 'normal', 'font-weight'  ) . ";
					font-style: " . impeka_grve_option( 'portfolio_title', 'normal', 'font-style'  ) . ";
					font-size: " . impeka_grve_option( 'portfolio_title', '60px', 'font-size'  ) . ";
					text-transform: " . impeka_grve_option( 'portfolio_title', 'normal', 'text-transform'  ) . ";
					line-height: " . impeka_grve_option( 'portfolio_title', '72px', 'line-height'  ) . ";
					" . impeka_grve_css_option( 'portfolio_title', '0px', 'letter-spacing'  ) . "
				}
			";
		} else {
			$css .= "
				.editor-styles-wrapper .editor-post-title__block .editor-post-title__input,
				.editor-styles-wrapper .editor-post-title {
					font-family: " . impeka_grve_option( 'page_title', 'inherit', 'font-family'  ) . ";
					font-weight: " . impeka_grve_option( 'page_title', 'normal', 'font-weight'  ) . ";
					font-style: " . impeka_grve_option( 'page_title', 'normal', 'font-style'  ) . ";
					font-size: " . impeka_grve_option( 'page_title', '60px', 'font-size'  ) . ";
					text-transform: " . impeka_grve_option( 'page_title', 'uppercase', 'text-transform'  ) . ";
					line-height: " . impeka_grve_option( 'page_title', '60px', 'line-height'  ) . ";
					" . impeka_grve_css_option( 'page_title', '0px', 'letter-spacing'  ) . "
				}
			";
		}
	} else {
		if ( 'post' == $post->post_type	) {
			$css .= "
				.editor-styles-wrapper .editor-post-title__block .editor-post-title__input,
				.editor-styles-wrapper .editor-post-title {
					font-family: " . impeka_grve_option( 'post_simple_title', 'inherit', 'font-family'  ) . ";
					font-weight: " . impeka_grve_option( 'post_simple_title', 'normal', 'font-weight'  ) . ";
					font-style: " . impeka_grve_option( 'post_simple_title', 'normal', 'font-style'  ) . ";
					font-size: " . impeka_grve_option( 'post_simple_title', '60px', 'font-size'  ) . ";
					text-transform: " . impeka_grve_option( 'post_simple_title', 'uppercase', 'text-transform'  ) . ";
					line-height: " . impeka_grve_option( 'post_simple_title', '112px', 'line-height'  ) . ";
					" . impeka_grve_css_option( 'post_simple_title', '0px', 'letter-spacing'  ) . "
				}
			";
		}
	}

	return $css;

}

function impeka_grve_editor_dynamic_css() {

	global $post, $pagenow;
	$css = "";

	$content_skin_options = array();
	$content_skin_options = impeka_grve_post_meta( '_impeka_grve_content_skin_options' );
	$content_skin = impeka_grve_array_value( $content_skin_options, 'skin' );

	switch( $content_skin ) {
		case 'custom':
			$content_background = $content_skin_options;
			$widget_title_color = $content_heading_color = impeka_grve_array_value( $content_skin_options, 'heading_color', '#000000' );
			$content_text_color = impeka_grve_array_value( $content_skin_options, 'text_color', '#888888' );
			$content_heading_color = impeka_grve_array_value( $content_skin_options, 'heading_color', '#000000' );
			$content_link_color = impeka_grve_array_value( $content_skin_options, 'link_color', '#000000' );
			$content_link_hover_color = impeka_grve_array_value( $content_skin_options, 'link_hover_color', '#01B5ED' );
		break;
		case 'light':
			$content_background = array( 'background-color' => '#ffffff' );
			$content_heading_color = "#000000";
			$widget_title_color = "#000000";
			$content_text_color = "#000000";
			$content_heading_color = "#000000";
			$content_link_color = "#000000";
			$content_link_hover_color = "#01B5ED";
		break;
		case 'dark':
			$content_background = array( 'background-color' => '#000000' );
			$content_heading_color = "#ffffff";
			$widget_title_color = "#ffffff";
			$content_text_color = "#ffffff";
			$content_heading_color = "#ffffff";
			$content_link_color = "#ffffff";
			$content_link_hover_color = "#01B5ED";
		break;
		default:
			$content_background = impeka_grve_option( 'content_background', array( 'background-color' => '#ffffff' ) );
			$content_heading_color = impeka_grve_option( 'body_heading_color' );
			$content_text_color = impeka_grve_option( 'body_text_color' );
			$widget_title_color = impeka_grve_option( 'widget_title_color' );
			$content_heading_color = impeka_grve_option( 'body_heading_color' );
			$content_link_color = impeka_grve_option( 'body_text_link_color' );
			$content_link_hover_color = impeka_grve_option( 'body_text_link_hover_color' );
		break;
	}

	$body_background = impeka_grve_option( 'body_background', array( 'background-color' => '#171A1D' ) );
	if ( 'transparent' == $content_background['background-color'] && empty( $content_background['background-image'] ) ) {
		$content_background = $body_background;
	}

	$css .= "
		.editor-styles-wrapper .block-editor-block-list__layout.is-root-container {
			" . impeka_grve_get_background_css( $content_background ) . "
			color: " . esc_attr( $content_text_color ) . ";
			padding-top: 40px;
			padding-bottom: 40px;
		}
	";

	/* Link Colors */

	$css .= "
	.editor-styles-wrapper .block-editor-block-list__layout  a {
		color: " . esc_attr( $content_link_color ) . ";

	}
	.editor-styles-wrapper .block-editor-block-list__layout a:hover {
		color: " . esc_attr( $content_link_hover_color ) . ";
	}
	";

	/* Header Colors */
	$css .= "
	.editor-styles-wrapper .block-editor-block-list__layout h1,
	.editor-styles-wrapper .block-editor-block-list__layout h2,
	.editor-styles-wrapper .block-editor-block-list__layout h3,
	.editor-styles-wrapper .block-editor-block-list__layout h4,
	.editor-styles-wrapper .block-editor-block-list__layout h5,
	.editor-styles-wrapper .block-editor-block-list__layout h6 {
		color: " . esc_attr( $content_heading_color ) . ";
	}
	";

	if ( ( $pagenow == 'post-new.php' || $pagenow == 'post.php' ) ) {

		$css .= impeka_grve_editor_custom_title_colors_css( $post );

		if ( 'post' === $post->post_type ) {

			$content_width = impeka_grve_post_meta( '_impeka_grve_post_content_width', impeka_grve_option( 'post_content_width', 'small' ) );
			$content_width = impeka_grve_array_value( impeka_grve_get_post_width_array(), $content_width, impeka_grve_option( 'container_size', 1170 ) );
			$css .= "
				.editor-styles-wrapper .wp-block {
					max-width: " . esc_attr( $content_width ) . "px;
				}
				.editor-styles-wrapper .block-editor-block-list__layout {
					font-size: " . impeka_grve_option( 'single_post_font', '18px', 'font-size'  ) . ";
					font-family: " . impeka_grve_option( 'single_post_font', 'inherit', 'font-family'  ) . ";
					font-weight: " . impeka_grve_option( 'single_post_font', 'normal', 'font-weight'  ) . ";
					line-height: " . impeka_grve_option( 'single_post_font', '36px', 'line-height'  ) . ";
					" . impeka_grve_css_option( 'single_post_font', '0px', 'letter-spacing'  ) . "
				}
			";
		} else {
			$css .= "
			.editor-styles-wrapper .wp-block {
				max-width: " . impeka_grve_option( 'container_size', 1170 ) . "px;
			}
			.editor-styles-wrapper .block-editor-block-list__layout {
				font-size: " . impeka_grve_option( 'body_font', '14px', 'font-size'  ) . ";
				font-family: " . impeka_grve_option( 'body_font', 'inherit', 'font-family'  ) . ";
				font-weight: " . impeka_grve_option( 'body_font', 'normal', 'font-weight'  ) . ";
				line-height: " . impeka_grve_option( 'body_font', '36px', 'line-height'  ) . ";
				" . impeka_grve_css_option( 'body_font', '0px', 'letter-spacing'  ) . "
			}
			";
		}
	}
	$css .= "
	.editor-styles-wrapper .block-editor-block-list__layout .mce-content-body h1,
	.editor-styles-wrapper .block-editor-block-list__layout h1,
	.editor-styles-wrapper .block-editor-block-list__layout .grve-h1,
	.editor-styles-wrapper .block-editor-block-list__layout .wp-block-freeform.block-library-rich-text__tinymce h1,
	.editor-styles-wrapper .block-editor-block-list__layout .wp-block-heading h1.editor-rich-text__tinymce {
		font-family: " . impeka_grve_option( 'h1_font', 'inherit', 'font-family'  ) . ";
		font-weight: " . impeka_grve_option( 'h1_font', 'normal', 'font-weight'  ) . ";
		font-style: " . impeka_grve_option( 'h1_font', 'normal', 'font-style'  ) . ";
		text-transform: " . impeka_grve_option( 'h1_font', ' none', 'text-transform'  ) . ";
		font-size: " . impeka_grve_option( 'h1_font', '56px', 'font-size'  ) . ";
		line-height: " . impeka_grve_option( 'h1_font', '60px', 'line-height'  ) . ";
		" . impeka_grve_css_option( 'h1_font', '0px', 'letter-spacing'  ) . "
	}
	.editor-styles-wrapper .block-editor-block-list__layout h2,
	.editor-styles-wrapper .block-editor-block-list__layout .grve-h2,
	.editor-styles-wrapper .block-editor-block-list__layout .wp-block-freeform.block-library-rich-text__tinymce h2,
	.editor-styles-wrapper .block-editor-block-list__layout .wp-block-heading h2.editor-rich-text__tinymce {
		font-family: " . impeka_grve_option( 'h2_font', 'inherit', 'font-family'  ) . ";
		font-weight: " . impeka_grve_option( 'h2_font', 'normal', 'font-weight'  ) . ";
		font-style: " . impeka_grve_option( 'h2_font', 'normal', 'font-style'  ) . ";
		text-transform: " . impeka_grve_option( 'h2_font', ' none', 'text-transform'  ) . ";
		font-size: " . impeka_grve_option( 'h2_font', '36px', 'font-size'  ) . ";
		line-height: " . impeka_grve_option( 'h2_font', '40px', 'line-height'  ) . ";
		" . impeka_grve_css_option( 'h2_font', '0px', 'letter-spacing'  ) . "
	}
	.editor-styles-wrapper .block-editor-block-list__layout h3,
	.editor-styles-wrapper .block-editor-block-list__layout .grve-h3,
	.editor-styles-wrapper .block-editor-block-list__layout .wp-block-freeform.block-library-rich-text__tinymce h3,
	.editor-styles-wrapper .block-editor-block-list__layout .wp-block-heading h3.editor-rich-text__tinymce {
		font-family: " . impeka_grve_option( 'h3_font', 'inherit', 'font-family'  ) . ";
		font-weight: " . impeka_grve_option( 'h3_font', 'normal', 'font-weight'  ) . ";
		font-style: " . impeka_grve_option( 'h3_font', 'normal', 'font-style'  ) . ";
		text-transform: " . impeka_grve_option( 'h3_font', ' none', 'text-transform'  ) . ";
		font-size: " . impeka_grve_option( 'h3_font', '30px', 'font-size'  ) . ";
		line-height: " . impeka_grve_option( 'h3_font', '33px', 'line-height'  ) . ";
		" . impeka_grve_css_option( 'h3_font', '0px', 'letter-spacing'  ) . "
	}
	.editor-styles-wrapper .block-editor-block-list__layout h4,
	.editor-styles-wrapper .block-editor-block-list__layout .grve-h4,
	.editor-styles-wrapper .block-editor-block-list__layout .wp-block-freeform.block-library-rich-text__tinymce h4,
	.editor-styles-wrapper .block-editor-block-list__layout .wp-block-heading h4.editor-rich-text__tinymce {
		font-family: " . impeka_grve_option( 'h4_font', 'inherit', 'font-family'  ) . ";
		font-weight: " . impeka_grve_option( 'h4_font', 'normal', 'font-weight'  ) . ";
		font-style: " . impeka_grve_option( 'h4_font', 'normal', 'font-style'  ) . ";
		text-transform: " . impeka_grve_option( 'h4_font', ' none', 'text-transform'  ) . ";
		font-size: " . impeka_grve_option( 'h4_font', '23px', 'font-size'  ) . ";
		line-height: " . impeka_grve_option( 'h4_font', '26px', 'line-height'  ) . ";
		" . impeka_grve_css_option( 'h4_font', '0px', 'letter-spacing'  ) . "
	}
	.editor-styles-wrapper .block-editor-block-list__layout h5,
	.editor-styles-wrapper .block-editor-block-list__layout .grve-h5,
	.editor-styles-wrapper .block-editor-block-list__layout .wp-block-freeform.block-library-rich-text__tinymce h5,
	.editor-styles-wrapper .block-editor-block-list__layout .wp-block-heading h5.editor-rich-text__tinymce {
		font-family: " . impeka_grve_option( 'h5_font', 'inherit', 'font-family'  ) . ";
		font-weight: " . impeka_grve_option( 'h5_font', 'normal', 'font-weight'  ) . ";
		font-style: " . impeka_grve_option( 'h5_font', 'normal', 'font-style'  ) . ";
		text-transform: " . impeka_grve_option( 'h5_font', ' none', 'text-transform'  ) . ";
		font-size: " . impeka_grve_option( 'h5_font', '18px', 'font-size'  ) . ";
		line-height: " . impeka_grve_option( 'h5_font', '20px', 'line-height'  ) . ";
		" . impeka_grve_css_option( 'h5_font', '0px', 'letter-spacing'  ) . "
	}
	.editor-styles-wrapper .block-editor-block-list__layout h6,
	.editor-styles-wrapper .block-editor-block-list__layout .grve-h6,
	.editor-styles-wrapper .block-editor-block-list__layout .wp-block-freeform.block-library-rich-text__tinymce h6,
	.editor-styles-wrapper .block-editor-block-list__layout .wp-block-heading h6.editor-rich-text__tinymce {
		font-family: " . impeka_grve_option( 'h6_font', 'inherit', 'font-family'  ) . ";
		font-weight: " . impeka_grve_option( 'h6_font', 'normal', 'font-weight'  ) . ";
		font-style: " . impeka_grve_option( 'h6_font', 'normal', 'font-style'  ) . ";
		text-transform: " . impeka_grve_option( 'h6_font', ' none', 'text-transform'  ) . ";
		font-size: " . impeka_grve_option( 'h6_font', '16px', 'font-size'  ) . ";
		line-height: " . impeka_grve_option( 'h6_font', '18px', 'line-height'  ) . ";
		" . impeka_grve_css_option( 'h6_font', '0px', 'letter-spacing'  ) . "
	}
	.editor-styles-wrapper .block-editor-block-list__layout .grve-quote-text,
	.editor-styles-wrapper .block-editor-block-list__layout blockquote p,
	.editor-styles-wrapper .block-editor-block-list__layout blockquote,
	.editor-styles-wrapper .block-editor-block-list__layout .wp-block-quote__citation,
	.editor-styles-wrapper .block-editor-block-list__layout .wp-block-pullquote__citation,
	.editor-styles-wrapper .block-editor-block-list__layout .wp-block-freeform.block-library-rich-text__tinymce blockquote,
	.editor-styles-wrapper .block-editor-block-list__layout .wp-block-freeform.block-library-rich-text__tinymce blockquote p {
		font-family: " . impeka_grve_option( 'quote_text', 'inherit', 'font-family'  ) . ";
		font-weight: " . impeka_grve_option( 'quote_text', 'normal', 'font-weight'  ) . ";
		font-style: " . impeka_grve_option( 'quote_text', 'normal', 'font-style'  ) . ";
		font-size: " . impeka_grve_option( 'quote_text', '34px', 'font-size'  ) . ";
		text-transform: " . impeka_grve_option( 'quote_text', 'none', 'text-transform'  ) . ";
		line-height: " . impeka_grve_option( 'quote_text', '36px', 'line-height'  ) . ";
		" . impeka_grve_css_option( 'quote_text', '0px', 'letter-spacing'  ) . "
	}


	.editor-styles-wrapper .block-editor-block-list__layout .wp-block-quote.is-large p,
	.editor-styles-wrapper .block-editor-block-list__layout .wp-block-quote.is-style-large p {
		font-size: 1.5em;
		font-style: italic;
		line-height: 1.6;
	}
	.editor-styles-wrapper .block-editor-block-list__layout .wp-block-pullquote p {
		font-size: 1.75em;
		line-height: 1.6;
	}
	.editor-styles-wrapper .block-editor-block-list__layout .grve-leader-text,
	.editor-styles-wrapper .block-editor-block-list__layout .grve-leader-text p,
	.editor-styles-wrapper .block-editor-block-list__layout p.grve-leader-text {
		font-family: " . impeka_grve_option( 'leader_text', 'inherit', 'font-family'  ) . ";
		font-weight: " . impeka_grve_option( 'leader_text', 'normal', 'font-weight'  ) . ";
		font-style: " . impeka_grve_option( 'leader_text', 'normal', 'font-style'  ) . ";
		font-size: " . impeka_grve_option( 'leader_text', '34px', 'font-size'  ) . ";
		text-transform: " . impeka_grve_option( 'leader_text', 'none', 'text-transform'  ) . ";
		line-height: " . impeka_grve_option( 'leader_text', '36px', 'line-height'  ) . ";
		" . impeka_grve_css_option( 'leader_text', '0px', 'letter-spacing'  ) . "
	}
	.editor-styles-wrapper .block-editor-block-list__layout .grve-subtitle,
	.editor-styles-wrapper .block-editor-block-list__layout .grve-subtitle p,
	.editor-styles-wrapper .block-editor-block-list__layout .grve-subtitle-text {
		font-family: " . impeka_grve_option( 'subtitle_text', 'inherit', 'font-family'  ) . ";
		font-weight: " . impeka_grve_option( 'subtitle_text', 'normal', 'font-weight'  ) . ";
		font-style: " . impeka_grve_option( 'subtitle_text', 'normal', 'font-style'  ) . ";
		font-size: " . impeka_grve_option( 'subtitle_text', '34px', 'font-size'  ) . ";
		text-transform: " . impeka_grve_option( 'subtitle_text', 'none', 'text-transform'  ) . ";
		line-height: " . impeka_grve_option( 'subtitle_text', '36px', 'line-height'  ) . ";
		" . impeka_grve_css_option( 'subtitle_text', '0px', 'letter-spacing'  ) . "
	}
	.editor-styles-wrapper .block-editor-block-list__layout .grve-small-text {
		font-family: " . impeka_grve_option( 'small_text', 'inherit', 'font-family'  ) . ";
		font-weight: " . impeka_grve_option( 'small_text', 'normal', 'font-weight'  ) . ";
		font-style: " . impeka_grve_option( 'small_text', 'normal', 'font-style'  ) . ";
		font-size: " . impeka_grve_option( 'small_text', '34px', 'font-size'  ) . ";
		text-transform: " . impeka_grve_option( 'small_text', 'none', 'text-transform'  ) . ";
		line-height: 1.4em;
		" . impeka_grve_css_option( 'small_text', '0px', 'letter-spacing'  ) . "
	}
	.editor-styles-wrapper .block-editor-block-list__layout blockquote {
		border-color: " . impeka_grve_option( 'body_primary_1_color' ) . " !important;
	}
	.editor-styles-wrapper .block-editor-block-list__layout blockquote:before,
	.editor-styles-wrapper .block-editor-block-list__layout blockquote > p:before	{
		color: " . impeka_grve_option( 'body_primary_1_color' ) . ";
	}
	.editor-styles-wrapper .block-editor-block-list__layout blockquote > p:before {
		color: " . impeka_grve_option( 'body_primary_1_color' ) . ";
	}
	";

	$css .= "
	.editor-styles-wrapper .block-editor-block-list__layout table,
	.editor-styles-wrapper .block-editor-block-list__layout tr,
	.editor-styles-wrapper .block-editor-block-list__layout td,
	.editor-styles-wrapper .block-editor-block-list__layout th,
	.editor-styles-wrapper .block-editor-block-list__layout form,
	.editor-styles-wrapper .block-editor-block-list__layout form p,
	.editor-styles-wrapper .block-editor-block-list__layout label,
	.editor-styles-wrapper .block-editor-block-list__layout div {
		border-color: " . impeka_grve_option( 'body_border_color' ) . " !important;
	}
	";

	$impeka_grve_colors = impeka_grve_get_color_array();
	foreach ( $impeka_grve_colors as $key => $value ) {

		$font_color = '#ffffff';
		if( 'white' == $key || 'light' == $key ) {
			$font_color = '#000000';
		}

		if( 'grey' == $key || 'light-grey' == $key ) {
			$font_color = '#7b7b7b';
		}

		// Background Color
		$css .= "
			.editor-styles-wrapper .block-editor-block-list__layout .grve-bg-" . esc_attr( $key ) . ",
			.editor-styles-wrapper .block-editor-block-list__layout .grve-bg-hover-" . esc_attr( $key ) . ":hover,
			.editor-styles-wrapper .block-editor-block-list__layout a.grve-bg-hover-" . esc_attr( $key ) . ":hover,
			.editor-styles-wrapper .block-editor-block-list__layout a .grve-bg-hover-" . esc_attr( $key ) . ":hover,
			.editor-styles-wrapper .block-editor-block-list__layout a:hover .grve-bg-hover-" . esc_attr( $key ) . " {
				background-color: " . esc_attr( $value ) . ";
			}

			.editor-styles-wrapper .block-editor-block-list__layout .grve-filter.grve-filter-style-button.grve-filter-color-" . esc_attr( $key ) . " ul li.selected {
				background-color: " . esc_attr( $value ) . ";
				border-color: " . esc_attr( $value ) . ";
				color: " . esc_attr( $font_color ) . ";
			}
		";

		// Text Color
		$css .= "
			.editor-styles-wrapper .block-editor-block-list__layout .grve-text-" . esc_attr( $key ) . ",
			.editor-styles-wrapper .block-editor-block-list__layout .grve-text-hover-" . esc_attr( $key ) . ":hover,
			.editor-styles-wrapper .block-editor-block-list__layout a.grve-text-hover-" . esc_attr( $key ) . ":hover,
			.editor-styles-wrapper .block-editor-block-list__layout a .grve-text-hover-" . esc_attr( $key ) . ":hover {
				color: " . esc_attr( $value ) . ";
			}
		";
		$css .= "
			.editor-styles-wrapper .block-editor-block-list__layout .has-" . esc_attr( $key ) . "-color {
				color: " . esc_attr( $value ) . ";
			}
			.editor-styles-wrapper .block-editor-block-list__layout .has-" . esc_attr( $key ) . "-background-color {
				background-color: " . esc_attr( $value ) . ";
			}
		";


	}
	return $css;
}

//Omit closing PHP tag to avoid accidental whitespace output errors.
