<?php

/*
*	Header Layout functions
*
* 	@version	1.0
* 	@author		Greatives Team
* 	@URI		https://greatives.eu
*/



/**
 * Get Top Bar Global Params
 */
function impeka_grve_get_top_bar_global_params( $params = array() ) {
	$top_bar_search_modal = $top_bar_language_modal = 'no';

	if ( !impeka_grve_visibility( 'top_bar_enabled' ) ) {
			return;
	}
	if ( ( is_singular() && 'yes' == impeka_grve_post_meta( '_impeka_grve_disable_top_bar' ) )
		|| ( impeka_grve_is_woo_shop() && 'yes' == impeka_grve_post_meta_shop( '_impeka_grve_disable_top_bar' ) ) ) {
		return;
	}

	if ( impeka_grve_visibility( 'top_bar_left_enabled' ) ) {
		$top_bar_left_options = impeka_grve_option('top_bar_left_options');
		if ( !empty( $top_bar_left_options ) ) {
			foreach ( $top_bar_left_options as $key => $value ) {
				if( !empty( $value ) && '0' != $value ) {
					switch( $key ) {
						case 'search':
							$search_mode = impeka_grve_option( 'top_bar_left_search_mode', 'modal' );
							if( 'modal' == $search_mode ) {
								$params['top_bar_left_search_modal'] = 'yes';
								$top_bar_search_modal = 'yes';
							}
						break;
						case 'form':
							$params['top_bar_left_form_modal'] = 'yes';
						break;
						case 'language':
							$language_style = impeka_grve_option( 'top_bar_left_language_style', 'dropdown' );
							if( 'modal' == $language_style ) {
								$params['top_bar_left_language_modal'] = 'yes';
								$top_bar_language_modal = 'yes';
							}
						break;
						default:
						break;
					}
				}
			}
		}
	}

	if ( impeka_grve_visibility( 'top_bar_right_enabled' ) ) {
		$top_bar_right_options = impeka_grve_option('top_bar_right_options');
		if ( !empty( $top_bar_right_options ) ) {
			foreach ( $top_bar_right_options as $key => $value ) {
				if( !empty( $value ) && '0' != $value ) {
					switch( $key ) {
						case 'search':
							$search_mode = impeka_grve_option( 'top_bar_right_search_mode', 'modal' );
							if( 'modal' == $search_mode ) {
								$params['top_bar_right_search_modal'] = 'yes';
								$top_bar_search_modal = 'yes';
							}
						break;
						case 'form':
							$params['top_bar_right_form_modal'] = 'yes';
						break;
						case 'language':
							$language_style = impeka_grve_option( 'top_bar_right_language_style', 'dropdown' );
							if( 'modal' == $language_style ) {
								$params['top_bar_right_language_modal'] = 'yes';
								$top_bar_language_modal = 'yes';
							}
						break;
						default:
						break;
					}
				}
			}
		}
	}

	$params['top_bar_search_modal'] = $top_bar_search_modal;
	$params['top_bar_language_modal'] = $top_bar_language_modal;

	return $params;

}


/**
 * Get Header Global Params
 */
function impeka_grve_get_header_global_params( $params = array() ) {
	global $post;

	$header_position = 'above';
	if( impeka_grve_is_woo_tax() ) {
		$header_skin = impeka_grve_option( 'product_tax_header_skin', 'default' );
		$header_overlapping = impeka_grve_option( 'product_tax_header_overlapping', 'no' );

	} elseif ( impeka_grve_events_calendar_is_overview() || is_post_type_archive( 'tribe_events' ) ) {
		$header_skin = impeka_grve_option( 'event_tax_header_skin', 'default' );
		$header_overlapping = impeka_grve_option( 'event_tax_header_overlapping', 'no' );
	} elseif ( is_post_type_archive( 'portfolio' ) || is_tax( 'portfolio_category' ) || is_tax( 'portfolio_field' ) ) {
		$header_skin = impeka_grve_option( 'portfolio_tax_header_skin', 'default' );
		$header_overlapping = impeka_grve_option( 'portfolio_tax_header_overlapping', 'no' );
	} else {
		$header_skin = impeka_grve_option( 'blog_header_skin', 'default' );
		$header_overlapping = impeka_grve_option( 'blog_header_overlapping', 'no' );
	}

	$is_woo_shop = impeka_grve_is_woo_shop();


	//Title Visibility
	$title_visibility = 'yes';
	$blog_title = impeka_grve_option( 'blog_title', 'sitetitle' );
	if ( is_front_page() && is_home() ) {
		// Default homepage
		if ( 'none' == $blog_title ) {
			$title_visibility = 'no';
		}
	} elseif ( is_front_page() ) {
		// static homepage
		if ( 'yes' == impeka_grve_post_meta( '_impeka_grve_disable_title' ) || ( $is_woo_shop && 'yes' == impeka_grve_post_meta_shop( '_impeka_grve_disable_title' ) ) ) {
			$title_visibility = 'no';
		}
	} elseif ( is_home() ) {
		// blog page
		if ( 'none' == $blog_title ) {
			$title_visibility = 'no';
		}
	} else {
		if ( ( is_singular() && 'yes' == impeka_grve_post_meta( '_impeka_grve_disable_title' ) ) || ( $is_woo_shop && 'yes' == impeka_grve_post_meta_shop( '_impeka_grve_disable_title' ) ) ) {
			$title_visibility = 'no';
		}
	}
	$params['header_title_visibility'] = $title_visibility;

	if ( is_search() ) {
		$header_skin =  impeka_grve_option( 'search_page_header_skin' );
		$header_overlapping =  impeka_grve_option( 'search_page_header_overlapping' );
	}

	if ( is_singular() || $is_woo_shop ) {

		if ( $is_woo_shop ) {
			$post_id = wc_get_page_id( 'shop' );
		} else {
			$post_id = $post->ID;
		}
		$post_type = get_post_type( $post_id );

		switch( $post_type ) {
			case 'product':
				$header_skin =  impeka_grve_post_meta( '_impeka_grve_header_skin', impeka_grve_option( 'product_header_skin' ) );
				$header_overlapping =  impeka_grve_post_meta( '_impeka_grve_header_overlapping', impeka_grve_option( 'product_header_overlapping' ) );
			break;
			case 'portfolio':
				$header_skin =  impeka_grve_post_meta( '_impeka_grve_header_skin', impeka_grve_option( 'portfolio_header_skin' ) );
				$header_overlapping =  impeka_grve_post_meta( '_impeka_grve_header_overlapping', impeka_grve_option( 'portfolio_header_overlapping' ) );
			break;
			case 'post':
				$header_skin =  impeka_grve_post_meta( '_impeka_grve_header_skin', impeka_grve_option( 'post_header_skin' ) );
				$header_overlapping =  impeka_grve_post_meta( '_impeka_grve_header_overlapping', impeka_grve_option( 'post_header_overlapping' ) );
			break;
			case 'tribe_events':
				$header_skin =  impeka_grve_post_meta( '_impeka_grve_header_skin', impeka_grve_option( 'event_header_skin' ) );
				$header_overlapping =  impeka_grve_post_meta( '_impeka_grve_header_overlapping', impeka_grve_option( 'event_header_overlapping' ) );
			break;
			case 'tribe_organizer':
			case 'tribe_venue':
				$header_skin = 'default';
				$header_overlapping = 'no';
			break;
			case 'page':
			default:
				if ( $is_woo_shop ) {
					$header_skin =  impeka_grve_post_meta_shop( '_impeka_grve_header_skin', impeka_grve_option( 'page_header_skin' ) );
					$header_overlapping =  impeka_grve_post_meta_shop( '_impeka_grve_header_overlapping', impeka_grve_option( 'page_header_overlapping' ) );
				} else {
					$header_skin =  impeka_grve_post_meta( '_impeka_grve_header_skin', impeka_grve_option( 'page_header_skin' ) );
					$header_overlapping =  impeka_grve_post_meta( '_impeka_grve_header_overlapping', impeka_grve_option( 'page_header_overlapping' ) );
				}
			break;
		}

		//Force Overlapping for Scrolling Full Width Sections Template
		if ( is_page_template( 'page-templates/template-full-page.php' ) ) {
			$header_overlapping = 'yes';
		} else {

			$feature_section_post_types = impeka_grve_option( 'feature_section_post_types');
			$feature_section_post_types = apply_filters( 'impeka_grve_feature_section_post_types', $feature_section_post_types );

			if ( !empty( $feature_section_post_types ) && in_array( $post_type, $feature_section_post_types ) ) {

				$feature_section = get_post_meta( $post_id, '_impeka_grve_feature_section', true );
				$feature_settings = impeka_grve_array_value( $feature_section, 'feature_settings' );
				$feature_element = impeka_grve_array_value( $feature_settings, 'element' );

				if ( !empty( $feature_element ) ) {

					$feature_single_item = impeka_grve_array_value( $feature_section, 'single_item' );
					$header_position = impeka_grve_array_value( $feature_settings, 'header_position' );
					if ( 'slider' ==  $feature_element ) {

						$slider_items = impeka_grve_array_value( $feature_section, 'slider_items' );
						if ( !empty( $slider_items ) ) {
							$header_skin = isset( $slider_items[0]['header_skin'] ) ? $slider_items[0]['header_skin'] : 'default';
						}

					}
				}
			}
		}

		if ( $is_woo_shop ) {
			$anchor_nav_menu = impeka_grve_post_meta_shop( '_impeka_grve_anchor_navigation_menu' );
			$anchor_device_layout = impeka_grve_post_meta_shop( '_impeka_grve_anchor_device_layout' );
		} else {
			$anchor_nav_menu = impeka_grve_post_meta( '_impeka_grve_anchor_navigation_menu' );
			$anchor_device_layout = impeka_grve_post_meta( '_impeka_grve_anchor_device_layout' );
		}

		if ( !empty( $anchor_nav_menu ) ) {
			$params['anchor_visibility'] = 'yes';
			$params['anchor_id'] = $anchor_nav_menu;
			$params['anchor_device_layout'] = $anchor_device_layout;
		}

	}
	if( impeka_grve_is_bbpress() ) {
		$header_skin =  impeka_grve_option( 'forum_header_skin' );
		$header_overlapping =  impeka_grve_option( 'forum_header_overlapping' );
	}

	if( is_404() ) {
		$header_skin =  impeka_grve_option( 'page_404_header_skin' );
		$header_overlapping =  impeka_grve_option( 'page_404_header_overlapping' );
	}

	//Responsive Header Overlapping
	$responsive_header_overlapping = impeka_grve_option( 'responsive_header_overlapping', 'no' );
	if ( is_singular() ) {
		$responsive_header_overlapping = impeka_grve_post_meta( '_impeka_grve_responsive_header_overlapping', $responsive_header_overlapping );
	} else if ( impeka_grve_is_woo_shop() ) {
		$responsive_header_overlapping = impeka_grve_post_meta_shop( '_impeka_grve_responsive_header_overlapping', $responsive_header_overlapping );
	}

	$header_layout = impeka_grve_option( 'header_layout', 'layout-default-style-1' );
	//Header Group
	switch( $header_layout ) {
		case 'layout-top-bottom-style-1':
		case 'layout-top-bottom-style-2':
			$header_group = 'top-bottom';
		break;
		case 'layout-side-style-1':
			$header_group = 'side';
		break;
		case 'layout-offcanvas-style-1':
		case 'layout-offcanvas-style-2':
			$header_group = 'offcanvas';
		break;
		default:
			$header_group = 'default';
		break;
	}
	//Header Style
	switch( $header_layout ) {
		case 'layout-default-style-2':
		case 'layout-offcanvas-style-2':
		case 'layout-top-bottom-style-2':
			$header_style = 'style-2';
		break;
		case 'layout-default-style-3':
			$header_style = 'style-3';
		break;
		default:
			$header_style = 'style-1';
		break;
	}
	//Header Orientation
	switch( $header_layout ) {
		case 'layout-side-style-1':
		case 'layout-offcanvas-style-2':
			$header_orientation = 'vertical';
		break;
		default:
			$header_orientation = 'horizontal';
		break;
	}
	if ( !impeka_grve_has_header() ) {
		$header_orientation = 'none';
		$params['header_visibility'] = 'no';
	} else {
		$params['header_visibility'] = 'yes';
	}

	if ( impeka_grve_check_header_elements_visibility( 'form' ) ) {
		$params['header_form_modal'] = 'yes';
	}
	if ( impeka_grve_check_header_elements_visibility( 'search' ) ) {
		$header_menu_search_mode = impeka_grve_option('header_menu_search_mode', 'modal');
		if( 'modal' == $header_menu_search_mode ) {
			$params['header_search_modal'] = 'yes';
		}
	}
	if ( impeka_grve_check_header_elements_visibility( 'language' ) ) {
		$language_style = impeka_grve_option( 'header_menu_language_style', 'modal' );
		if( 'modal' == $language_style ) {
			$params['header_language_modal'] = 'yes';
		}
	}
	if ( impeka_grve_check_header_elements_visibility( 'social' ) ) {
		$header_menu_social_mode = impeka_grve_option('header_menu_social_mode', 'modal');
		if( 'modal' == $header_menu_social_mode ) {
			$params['header_social_modal'] = 'yes';
		}
	}

	$params['header_overlapping'] = $header_overlapping;
	$params['header_position'] = $header_position;
	$params['header_skin'] = impeka_grve_validate_header_skin( $header_skin );
	$params['responsive_header_overlapping'] = $responsive_header_overlapping;
	$params['header_group'] = $header_group;
	$params['header_style'] = $header_style;
	$params['header_orientation'] = $header_orientation;

	//Header Menu Visibility
	$header_menu_visibility = 'yes';
	if ( impeka_grve_visibility( 'header_menu_enabled', '1' ) ) {
		if ( is_singular() ) {
			if ( 'yes' == impeka_grve_post_meta( '_impeka_grve_disable_menu' ) ) {
				$header_menu_visibility = 'no';
			}
		} else if ( impeka_grve_is_woo_shop() ) {
			if ( 'yes' == impeka_grve_post_meta_shop( '_impeka_grve_disable_menu' ) ) {
				$header_menu_visibility = 'no';
			}
		}
	} else {
		$header_menu_visibility = 'no';
	}
	$params['header_menu_visibility'] = $header_menu_visibility;
	
	//Header Second Menu Visibility
	$header_second_visibility = 'yes';
	if ( impeka_grve_visibility( 'header_menu_enabled', '1' ) ) {
		if ( is_singular() ) {
			if ( 'yes' == impeka_grve_post_meta( '_impeka_grve_disable_second_menu' ) ) {
				$header_second_visibility = 'no';
			}
		} else if ( impeka_grve_is_woo_shop() ) {
			if ( 'yes' == impeka_grve_post_meta_shop( '_impeka_grve_disable_second_menu' ) ) {
				$header_second_visibility = 'no';
			}
		}
	} else {
		$header_second_visibility = 'no';
	}
	$params['header_second_menu_visibility'] = $header_second_visibility;
	
	//Header Responsive Menu Visibility
	$header_responsive_menu_visibility = 'yes';
	if ( impeka_grve_visibility( 'header_menu_enabled', '1' ) ) {
		if ( is_singular() ) {
			if ( 'yes' == impeka_grve_post_meta( '_impeka_grve_disable_responsive_menu' ) ) {
				$header_responsive_menu_visibility = 'no';
			}
		} else if ( impeka_grve_is_woo_shop() ) {
			if ( 'yes' == impeka_grve_post_meta_shop( '_impeka_grve_disable_responsive_menu' ) ) {
				$header_responsive_menu_visibility = 'no';
			}
		}
	} else {
		$header_responsive_menu_visibility = 'no';
	}
	$params['header_responsive_menu_visibility'] = $header_responsive_menu_visibility;
	
	if ( is_singular() || $is_woo_shop ) {
		if ( $is_woo_shop ) {
			$main_navigation_menu = impeka_grve_post_meta_shop( '_impeka_grve_main_navigation_menu' );
			$second_navigation_menu = impeka_grve_post_meta_shop( '_impeka_grve_second_navigation_menu' );
			$responsive_navigation_menu = impeka_grve_post_meta_shop( '_impeka_grve_responsive_navigation_menu' );
			
		} else {
			$main_navigation_menu = impeka_grve_post_meta( '_impeka_grve_main_navigation_menu' );
			$second_navigation_menu = impeka_grve_post_meta( '_impeka_grve_second_navigation_menu' );
			$responsive_navigation_menu = impeka_grve_post_meta( '_impeka_grve_responsive_navigation_menu' );
		}
		$params['header_main_navigation_menu'] = $main_navigation_menu;
		$params['header_second_navigation_menu'] = $second_navigation_menu;
		$params['header_responsive_navigation_menu'] = $responsive_navigation_menu;	
	}
	return $params;

}


/**
 * Get Side Area global params
 */
function impeka_grve_get_sidearea_global_params( $params = array() ) {

	$sidearea_visibility = 'no';
	$sidearea_id = $sidearea_icon_style = '';

	if ( ! is_singular() ) {
		//Overview Pages
		if( impeka_grve_woocommerce_enabled() && is_woocommerce() ) {
			if ( is_shop() && !is_search() ) {
				$sidearea_visibility =  impeka_grve_post_meta_shop( '_impeka_grve_sidearea_visibility', impeka_grve_option( 'page_sidearea_visibility' ) );
				$sidearea_id = impeka_grve_post_meta_shop( '_impeka_grve_sidearea_sidebar', impeka_grve_option( 'page_sidearea_sidebar' ) );
				$sidearea_icon_style = impeka_grve_option( 'page_sidearea_icon_style' );
			} else {
				$sidearea_visibility = impeka_grve_option( 'product_tax_sidearea_visibility' );
				$sidearea_id = impeka_grve_option( 'product_tax_sidearea_sidebar' );
				$sidearea_icon_style = impeka_grve_option( 'product_tax_sidearea_icon_style' );
			}
		} elseif ( impeka_grve_events_calendar_is_overview() ) {
				$sidearea_visibility = impeka_grve_option( 'event_tax_sidearea_visibility' );
				$sidearea_id = impeka_grve_option( 'event_tax_sidearea_sidebar' );
				$sidearea_icon_style = impeka_grve_option( 'event_tax_sidearea_icon_style' );
		} elseif ( is_post_type_archive( 'portfolio' ) || is_tax( 'portfolio_category' ) || is_tax( 'portfolio_field' ) ) {
				$sidearea_visibility = impeka_grve_option( 'portfolio_tax_sidearea_visibility' );
				$sidearea_id = impeka_grve_option( 'portfolio_tax_sidearea_sidebar' );
				$sidearea_icon_style = impeka_grve_option( 'portfolio_tax_sidearea_icon_style' );
		} else {
			$sidearea_visibility = impeka_grve_option( 'blog_sidearea_visibility' );
			$sidearea_id = impeka_grve_option( 'blog_sidearea_sidebar' );
			$sidearea_icon_style = impeka_grve_option( 'blog_sidearea_icon_style' );
		}
	} else {

		global $post;
		$post_id = $post->ID;
		$post_type = get_post_type( $post_id );

		switch( $post_type ) {
			case 'product':
				$sidearea_visibility =  impeka_grve_post_meta( '_impeka_grve_sidearea_visibility', impeka_grve_option( 'product_sidearea_visibility' ) );
				$sidearea_id = impeka_grve_post_meta( '_impeka_grve_sidearea_sidebar', impeka_grve_option( 'product_sidearea_sidebar' ) );
				$sidearea_icon_style = impeka_grve_option( 'product_sidearea_icon_style' );
			break;
			case 'portfolio':
				$sidearea_visibility =  impeka_grve_post_meta( '_impeka_grve_sidearea_visibility', impeka_grve_option( 'portfolio_sidearea_visibility' ) );
				$sidearea_id = impeka_grve_post_meta( '_impeka_grve_sidearea_sidebar', impeka_grve_option( 'portfolio_sidearea_sidebar' ) );
				$sidearea_icon_style = impeka_grve_option( 'portfolio_sidearea_icon_style' );
			break;
			case 'post':
				$sidearea_visibility =  impeka_grve_post_meta( '_impeka_grve_sidearea_visibility', impeka_grve_option( 'post_sidearea_visibility' ) );
				$sidearea_id = impeka_grve_post_meta( '_impeka_grve_sidearea_sidebar', impeka_grve_option( 'post_sidearea_sidebar' ) );
				$sidearea_icon_style = impeka_grve_option( 'post_sidearea_icon_style' );
			break;
			case 'tribe_events':
				$sidearea_visibility =  impeka_grve_post_meta( '_impeka_grve_sidearea_visibility', impeka_grve_option( 'event_sidearea_visibility' ) );
				$sidearea_id = impeka_grve_post_meta( '_impeka_grve_sidearea_sidebar', impeka_grve_option( 'event_sidearea_sidebar' ) );
				$sidearea_icon_style = impeka_grve_option( 'event_sidearea_icon_style' );
			break;
			case 'page':
			default:
				$sidearea_visibility =  impeka_grve_post_meta( '_impeka_grve_sidearea_visibility', impeka_grve_option( 'page_sidearea_visibility' ) );
				$sidearea_id = impeka_grve_post_meta( '_impeka_grve_sidearea_sidebar', impeka_grve_option( 'page_sidearea_sidebar' ) );
				$sidearea_icon_style = impeka_grve_option( 'page_sidearea_icon_style' );
			break;
		}
	}

	if( impeka_grve_is_bbpress() ) {
		$sidearea_visibility = impeka_grve_option( 'forum_sidearea_visibility' );
		$sidearea_id = impeka_grve_option( 'forum_sidearea_sidebar' );
		$sidearea_icon_style = impeka_grve_option( 'forum_sidearea_icon_style' );
	}

	$params['sidearea_visibility'] = $sidearea_visibility;
	$params['sidearea_id'] = $sidearea_id;
	$params['sidearea_icon_style'] = $sidearea_icon_style;

	return $params;
}


/**
 * Get Sidebar global params
 */
function impeka_grve_get_sidebar_global_params( $params = array() ) {

	$sidebar_visibility = 'no';
	$sidebar_extra_content = 'no';
	$sidebar_details = 'no';
	$sidebar_id = '';
	$sidebar_layout = 'none';
	$fixed_sidebar = "no";

	$is_woo_shop = impeka_grve_is_woo_shop();

	if ( $is_woo_shop ) {
		if ( is_search() ) {
			$sidebar_id = impeka_grve_option( 'product_search_sidebar' );
			$sidebar_layout = impeka_grve_option( 'product_search_layout', 'none' );
			$fixed_sidebar = impeka_grve_option( 'product_search_fixed_sidebar', 'no' );
		} else {
			$sidebar_id = impeka_grve_post_meta_shop( '_impeka_grve_sidebar', impeka_grve_option( 'page_sidebar' ) );
			$sidebar_layout = impeka_grve_post_meta_shop( '_impeka_grve_layout', impeka_grve_option( 'page_layout', 'none' ) );
			$fixed_sidebar =  impeka_grve_post_meta_shop( '_impeka_grve_fixed_sidebar' , impeka_grve_option( 'page_fixed_sidebar', 'no' ) );
		}
	} else if ( is_search() ) {
		$sidebar_id = impeka_grve_option( 'search_page_sidebar' );
		$sidebar_layout = impeka_grve_option( 'search_page_layout', 'none' );
		$fixed_sidebar = impeka_grve_option( 'search_page_fixed_sidebar', 'no' );
	} else if ( impeka_grve_is_bbpress() ) {
		$sidebar_id = impeka_grve_option( 'forum_sidebar' );
		$sidebar_layout = impeka_grve_option( 'forum_layout', 'none' );
		$fixed_sidebar = impeka_grve_option( 'forum_fixed_sidebar', 'no' );
	} else if ( is_singular() ) {
		if ( is_singular( 'post' ) ) {
			$sidebar_id = impeka_grve_post_meta( '_impeka_grve_sidebar', impeka_grve_option( 'post_sidebar' ) );
			$sidebar_layout = impeka_grve_post_meta( '_impeka_grve_layout', impeka_grve_option( 'post_layout', 'none' ) );
			$fixed_sidebar =  impeka_grve_post_meta( '_impeka_grve_fixed_sidebar' , impeka_grve_option( 'post_fixed_sidebar', 'no' ) );
		} else if ( is_singular( 'portfolio' ) ) {
			$sidebar_id = impeka_grve_post_meta( '_impeka_grve_sidebar', impeka_grve_option( 'portfolio_sidebar' ) );
			$sidebar_layout = impeka_grve_post_meta( '_impeka_grve_layout', impeka_grve_option( 'portfolio_layout', 'none' ) );
			$fixed_sidebar =  impeka_grve_post_meta( '_impeka_grve_fixed_sidebar' , impeka_grve_option( 'portfolio_fixed_sidebar', 'no' ) );
			$portfolio_details = impeka_grve_check_portfolio_details();
			if( $portfolio_details ) {
				$sidebar_extra_content = 'yes';
				if ( 'none' == $sidebar_layout ) {
					$sidebar_details = 'yes';
					$sidebar_layout = 'right';
				}
			}
		} else if ( is_singular( 'product' ) ) {
			$sidebar_id = impeka_grve_post_meta( '_impeka_grve_sidebar', impeka_grve_option( 'product_sidebar' ) );
			$sidebar_layout = impeka_grve_post_meta( '_impeka_grve_layout', impeka_grve_option( 'product_layout', 'none' ) );
			$fixed_sidebar =  impeka_grve_post_meta( '_impeka_grve_fixed_sidebar' , impeka_grve_option( 'product_fixed_sidebar', 'no' ) );
		} else if ( is_singular( 'tribe_events' ) ) {
			$sidebar_id = impeka_grve_post_meta( '_impeka_grve_sidebar', impeka_grve_option( 'event_sidebar' ) );
			$sidebar_layout = impeka_grve_post_meta( '_impeka_grve_layout', impeka_grve_option( 'event_layout', 'none' ) );
			$fixed_sidebar =  impeka_grve_post_meta( '_impeka_grve_fixed_sidebar' , impeka_grve_option( 'event_fixed_sidebar', 'no' ) );
		} else if ( is_singular( 'tribe_organizer' ) || is_singular( 'tribe_venue' ) ) {
			//No Sidebar
		} else {
			$sidebar_id = impeka_grve_post_meta( '_impeka_grve_sidebar', impeka_grve_option( 'page_sidebar' ) );
			$sidebar_layout = impeka_grve_post_meta( '_impeka_grve_layout', impeka_grve_option( 'page_layout', 'none' ) );
			$fixed_sidebar =  impeka_grve_post_meta( '_impeka_grve_fixed_sidebar' , impeka_grve_option( 'page_fixed_sidebar', 'no' ) );
		}
	} else if ( is_archive() ) {
		if( impeka_grve_is_woo_tax() ) {
			$sidebar_id = impeka_grve_option( 'product_tax_sidebar' );
			$sidebar_layout = impeka_grve_option( 'product_tax_layout', 'none' );
			$fixed_sidebar = impeka_grve_option( 'product_tax_fixed_sidebar', 'no' );
		} else if ( impeka_grve_events_calendar_is_overview() || is_post_type_archive( 'tribe_events' ) ) {
			$sidebar_id = impeka_grve_option( 'event_tax_sidebar' );
			$sidebar_layout = impeka_grve_option( 'event_tax_layout', 'none' );
			$fixed_sidebar = impeka_grve_option( 'event_tax_fixed_sidebar', 'no' );
		} else if ( is_post_type_archive( 'portfolio' ) || is_tax( 'portfolio_category' ) || is_tax( 'portfolio_field' ) ) {
			$sidebar_id = impeka_grve_option( 'portfolio_tax_sidebar' );
			$sidebar_layout = impeka_grve_option( 'portfolio_tax_layout', 'none' );
			$fixed_sidebar = impeka_grve_option( 'portfolio_tax_fixed_sidebar', 'no' );
		} else {
			$sidebar_id = impeka_grve_option( 'blog_sidebar' );
			$sidebar_layout = impeka_grve_option( 'blog_layout', 'none' );
			$fixed_sidebar = impeka_grve_option( 'blog_fixed_sidebar', 'no' );
		}
	} else if ( is_home() ) {
			$sidebar_id = impeka_grve_option( 'blog_sidebar' );
			$sidebar_layout = impeka_grve_option( 'blog_layout', 'none' );
			$fixed_sidebar = impeka_grve_option( 'blog_fixed_sidebar', 'no' );
	} else {
		//No Sidebar
	}

	if ( 'none' != $sidebar_layout && ( is_active_sidebar( $sidebar_id ) || 'yes' == $sidebar_extra_content ) ) {
		$sidebar_visibility = 'yes';
	}

	$params['sidebar_visibility'] = $sidebar_visibility;
	$params['sidebar_details'] = $sidebar_details;
	$params['sidebar_extra_content'] = $sidebar_extra_content;
	$params['sidebar_fixed'] = $fixed_sidebar;
	$params['sidebar_layout'] = $sidebar_layout;
	$params['sidebar_id'] = $sidebar_id;

	return $params;
}


/**
 * Get Safe Button global params
 */
function impeka_grve_get_safebutton_global_params( $params = array() ) {

	$visibility = 'no';
	$area_id = '';

	if ( is_page_template( 'page-templates/template-full-page.php' ) ) {
		$visibility = 'no';
	} else {
		$area_id = impeka_grve_option('header_safebutton_area');
		if ( is_singular() ) {
			$area_id = impeka_grve_post_meta( '_impeka_grve_safe_button_area', $area_id );
		}
		if( impeka_grve_is_woo_shop() ) {
			$area_id = impeka_grve_post_meta_shop( '_impeka_grve_safe_button_area', $area_id );
		}

		if ( !empty( $area_id ) && 'none' != $area_id ) {
			$area_id = apply_filters( 'wpml_object_id', $area_id, 'area-item', TRUE  );
			$visibility = 'yes';
		}
	}

	$params['safebutton_visibility'] = $visibility;
	$params['safebutton_id'] = $area_id;

	return $params;
}

/**
 * Get Bottom Bar global params
 */
function impeka_grve_get_bottom_bar_global_params( $params = array() ) {

	$visibility = 'no';

	$area_id = impeka_grve_option('bottom_bar_area');
	if ( is_singular() ) {
		$area_id = impeka_grve_post_meta( '_impeka_grve_bottom_bar_area', $area_id );
	}
	if( impeka_grve_is_woo_shop() ) {
		$area_id = impeka_grve_post_meta_shop( '_impeka_grve_bottom_bar_area', $area_id );
	}

	if ( !empty( $area_id ) && 'none' != $area_id ) {
		$area_id = apply_filters( 'wpml_object_id', $area_id, 'area-item', TRUE  );
		$visibility = 'yes';
	}

	$params['bottom_bar_area_visibility'] = $visibility;
	$params['bottom_bar_area_id'] = $area_id;

	return $params;
}


/**
 * Print Main Menu
 */

function impeka_grve_print_main_menu ( $orientation = 'horizontal', $position = '' ) {
	$menu = impeka_grve_get_header_nav();
	$menu_open_type = impeka_grve_option( 'header_menu_open_type', 'toggle' );
	$sub_menu_animation = impeka_grve_option( 'submenu_animation', 0 );
	$walker = '';

	if ( $menu != 'disabled' ) {

		$menu_classes = array('grve-header-menu');

		$menu_classes[] = 'grve-' . $orientation . '-menu';
		if ( !empty( $position ) ) {
			$menu_classes[] = 'grve-position-' . $position;
		}

		if( $sub_menu_animation ) {
			$menu_classes[] = 'grve-sub-menu-animation';
		}

		if ( 'horizontal' == $orientation ) {
			$menu_arrows = impeka_grve_option( 'submenu_pointer', 'none' );
			if( 'none' != $menu_arrows ) {
				$menu_classes[] = 'grve-' . $menu_arrows;
			}
		} elseif( 'vertical' == $orientation ) {
			$menu_classes[] = 'grve-' . $menu_open_type . '-animation';
			$walker = 'responsive';
		}
		$menu_class_string = implode( ' ', $menu_classes );

		// Menu Attributes
		$main_menu_attributes = array();
		$main_menu_attributes[] = 'class="' . esc_attr( $menu_class_string ) . '"';
		if( 'vertical' == $orientation ) {
			$main_menu_attributes[] = 'data-menu-type="' . esc_attr( $menu_open_type ) . '"';
		}
		$main_menu_attributes[] = 'aria-label="' . esc_attr( 'Main', 'impeka' ) . '"';
?>
		<nav id="grve-main-menu" <?php echo implode( ' ', $main_menu_attributes ); ?>>
			<?php impeka_grve_header_nav( $menu, $walker ); ?>
		</nav>
<?php
	}
}


/**
 * Print Secondary Menu
 */
function impeka_grve_print_second_menu ( $orientation = 'horizontal', $position = '' ) {
	$second_menu = impeka_grve_get_header_second_nav();
	$menu_open_type = impeka_grve_option( 'header_menu_open_type', 'toggle' );
	$sub_menu_animation = impeka_grve_option( 'submenu_animation', 0 );
	$walker = '';

	if ( $second_menu != 'disabled' ) {

		if ( !empty( $second_menu ) || has_nav_menu( 'impeka_header_second_nav' ) ) {
			$second_menu_classes = array('grve-header-menu');

			$second_menu_classes[] = 'grve-' . $orientation . '-menu';
			if ( !empty( $position ) ) {
				$second_menu_classes[] = 'grve-position-' . $position;
			}

			if( $sub_menu_animation ) {
				$second_menu_classes[] = 'grve-sub-menu-animation';
			}

			if ( 'horizontal' == $orientation ) {
				$menu_arrows = impeka_grve_option( 'submenu_pointer', 'none' );
				if( 'none' != $menu_arrows ) {
					$second_menu_classes[] = 'grve-' . $menu_arrows;
				}
			} elseif( 'vertical' == $orientation ) {
				$second_menu_classes[] = 'grve-' . $menu_open_type . '-animation';
				$walker = 'responsive';
			}
			$second_menu_class_string = implode( ' ', $second_menu_classes );

			// Menu Attributes
			$main_menu_attributes = array();
			$main_menu_attributes[] = 'class="' . esc_attr( $second_menu_class_string ) . '"';
			if( 'vertical' == $orientation ) {
				$main_menu_attributes[] = 'data-menu-type="' . esc_attr( $menu_open_type ) . '"';
			}
			$main_menu_attributes[] = 'aria-label="' . esc_attr( 'Secondary', 'impeka' ) . '"';
?>
			<nav id="grve-second-menu" <?php echo implode( ' ', $main_menu_attributes ); ?>>
				<?php impeka_grve_header_second_nav( $second_menu, $walker ); ?>
			</nav>
<?php
		}
	}
}

/**
 * Print Responsive Header
 */
function impeka_grve_print_responsive_header( $layout = 'layout-1' ) {
	get_template_part( 'templates/header/responsive/' . $layout );
}

/**
 * Print Responsive Menu
 */
function impeka_grve_print_responsive_menu () {
	$responsive_menu = impeka_grve_get_responsive_nav();
	$responsive_menu_animation = impeka_grve_option( 'menu_responsive_open_type', 'toggle' );
	if ( $responsive_menu != 'disabled' ) {

		$menu_classes = array();
		$menu_classes[] = 'grve-vertical-menu';
		$menu_classes[] = 'grve-' . $responsive_menu_animation . '-animation';
		$menu_class_string = implode( ' ', $menu_classes );

		// Menu Attributes
		$main_menu_attributes = array();
		$main_menu_attributes[] = 'class="' . esc_attr( $menu_class_string ) . '"';
		$main_menu_attributes[] = 'data-menu-type="' . esc_attr( $responsive_menu_animation ) . '"';
		$main_menu_attributes[] = 'aria-label="' . esc_attr( 'Responsive', 'impeka' ) . '"';
?>
		<nav id="grve-responsive-main-menu" <?php echo implode( ' ', $main_menu_attributes ); ?>>
		<?php
			if ( !empty( $responsive_menu ) || has_nav_menu( 'impeka_responsive_nav' ) ) {
				impeka_grve_responsive_nav( $responsive_menu, 'default' );
			} else {
				$main_menu = impeka_grve_get_header_nav();
				$second_menu = impeka_grve_get_header_second_nav();
				$header_layout = impeka_grve_option( 'header_layout', 'layout-default-style-1' );
				switch( $header_layout ) {
					case 'layout-default-style-2':
					case 'layout-default-style-4':
					case 'layout-offcanvas-style-3':
						if ( !empty( $second_menu ) || has_nav_menu( 'impeka_header_second_nav' ) ) {
							impeka_grve_header_combine_nav( $main_menu, $second_menu );
						} else {
							impeka_grve_header_nav( $main_menu, 'responsive' );
						}
					break;
					default:
						impeka_grve_header_nav( $main_menu, 'responsive' );
					break;
				}
			}
		?>
		</nav>
<?php
	}
}

/**
 * Prints Responsive Menu Area
 */
function impeka_grve_print_responsive_menu_area() {

	$header_group = impeka_grve_global_param( 'header_group' );
	$header_style = impeka_grve_global_param( 'header_style' );

	$menu_text = impeka_grve_option( 'menu_responsive_text' );
	$header_text_1 = impeka_grve_option( 'header_text_1' );
	$header_text_2 = impeka_grve_option( 'header_text_2' );
	$menu_open_type = impeka_grve_option( 'menu_responsive_open_type', 'toggle' );
	$menu_close_color = impeka_grve_option( 'responsive_menu_close_color' );
	$menu_width = impeka_grve_option( 'menu_responsive_width', 'small' );
	$menu_align = impeka_grve_option( 'menu_responsive_align', 'left' );
	$menu_animation = impeka_grve_option( 'responsive_menu_animation', 'left-to-right' );
	$menu_items_animation = impeka_grve_option( 'responsive_menu_items_animation', 'fade-in' );
	$header_visibility = impeka_grve_option( 'responsive_header_visibility', 'true' );

	$menu_classes = array( 'grve-hidden-area', 'grve-animated-items', 'grve-offcanvas-full-width', 'grve-fade-in', 'grve-offcanvas-position-center' );
	$menu_classes[] = 'grve-' . $menu_width . '-width';
	if ( 'slide' == $menu_open_type ) {
		$menu_classes[] = 'grve-align-' . $menu_align;
	}
	$menu_class_string = implode( ' ', $menu_classes );

	//Responsive Menu Attributes
	$menu_attributes = array();
	$menu_attributes[] = 'class="' . esc_attr( $menu_class_string ) . '"';
	$menu_attributes[] = 'data-animation="' . esc_attr( $menu_animation ) . '"';
	$menu_attributes[] = 'data-items-animation="' . esc_attr( $menu_items_animation ) . '"';
	$menu_attributes[] = 'data-header-visibility="' . esc_attr( $header_visibility ) . '"';

?>
	<div id="grve-responsive-menu-area" <?php echo implode( ' ', $menu_attributes ); ?>>
		<div class="grve-area-inner">
			<?php if( 'false' == $header_visibility ){ ?>
			<?php impeka_grve_print_close_icon( $menu_close_color ); ?>
			<?php } ?>
			<div class="grve-area-scroller">
				<div class="grve-area-container">
					<div class="grve-area-content grve-content">
						<div class="grve-area-top">
							<?php do_action( 'impeka_grve_responsive_menu_before' ); ?>
							<div class="grve-vertical-menu-wrapper">
								<?php impeka_grve_print_responsive_menu(); ?>
							</div>
							<?php do_action( 'impeka_grve_responsive_menu_after' ); ?>
						</div>
						<div class="grve-area-bottom">
							<?php if ( 'top-bottom' == $header_group && 'style-2' == $header_style && ( !empty( $header_text_1 ) || !empty( $header_text_2 ) ) ) { ?>
								<?php if ( !empty( $header_text_1 ) ) { ?>
								<div class="grve-header-text">
									<?php echo do_shortcode( $header_text_1 ); ?>
								</div>
								<?php } ?>
								<?php if ( !empty( $header_text_2 ) ) { ?>
								<div class="grve-header-text">
									<?php echo do_shortcode( $header_text_2 ); ?>
								</div>
								<?php } ?>
							<?php } ?>

							<?php if ( !empty( $menu_text ) ) { ?>
							<div class="grve-hidden-menu-text">
								<?php echo do_shortcode( $menu_text ); ?>
							</div>
							<?php } ?>

							<?php impeka_grve_print_header_elements_responsive(); ?>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
<?php

}

 /**
 * Print Offcanvas Menu
 */
if( !function_exists( 'impeka_grve_print_offcanvas_menu' ) ) {
	function impeka_grve_print_offcanvas_menu( $header_overlapping = true ) {
		$offcanvas_header_skin = impeka_grve_option( 'offcanvas_logo_color', '' );
		$offcanvas_text = impeka_grve_option( 'offcanvas_text' );
		$offcanvas_width = impeka_grve_option( 'offcanvas_width' );
		$offcanvas_position = impeka_grve_option( 'offcanvas_position' );
		$offcanvas_open_menu_type = impeka_grve_option( 'header_menu_open_type' );
		$offcanvas_content_position = impeka_grve_option( 'offcanvas_content_position' );
		$offcanvas_content_alignment = impeka_grve_option( 'offcanvas_content_alignment' );
		$offcanvas_close_color = impeka_grve_option( 'offcanvas_close_color' );
		$offcanvas_animation = impeka_grve_option( 'offcanvas_animation' );
		$offcanvas_menu_items_animation = impeka_grve_option( 'offcanvas_menu_items_animation' );
		$offcanvas_menu_item_style = impeka_grve_option( 'offcanvas_menu_item_style', 'classic' );
		$header_orientation = impeka_grve_global_param( 'header_orientation' );

		//Offcanvas Classes
		$offcanvas_classes = array('grve-offcanvas-area', 'grve-hidden-area');
		$offcanvas_classes[] = 'grve-' . $offcanvas_width;
		$offcanvas_classes[] = 'grve-offcanvas-position-' . $offcanvas_position;
		$offcanvas_classes[] = 'grve-offcanvas-content-position-' . $offcanvas_content_position;
		$offcanvas_classes[] = 'grve-align-' . $offcanvas_content_alignment;

		if( 'classic' != $offcanvas_menu_item_style ) {
			$offcanvas_classes[] = 'grve-menu-type-' . $offcanvas_menu_item_style;
		}
		if( 'none' != $offcanvas_menu_items_animation ) {
			$offcanvas_classes[] = 'grve-animated-items';
		}
		$offcanvas_class_string = implode( ' ', $offcanvas_classes );

		//Offcanvas Attributes
		$offcanvas_attributes = array();
		$offcanvas_attributes[] = 'class="' . esc_attr( $offcanvas_class_string ) . '"';
		$offcanvas_attributes[] = 'data-animation="' . esc_attr( $offcanvas_animation ) . '"';
		$offcanvas_attributes[] = 'data-items-animation="' . esc_attr( $offcanvas_menu_items_animation ) . '"';
		if ( 'offcanvas-full-width' == $offcanvas_width  && 'vertical' != $header_orientation ) {
			$offcanvas_attributes[] = 'data-header-skin="' . esc_attr( $offcanvas_header_skin ) . '"';
			$offcanvas_attributes[] = 'data-header-visibility="true"';
		}
?>

	<div id="grve-offcanvas-area" <?php echo implode( ' ', $offcanvas_attributes ); ?>>
		<div class="grve-area-inner">
		<?php if ( 'offcanvas-full-width' != $offcanvas_width || 'vertical' == $header_orientation ) { ?>
			<?php impeka_grve_print_close_icon( $offcanvas_close_color ); ?>
		<?php } ?>
			<div class="grve-area-scroller">
				<div class="grve-area-container">
					<div class="grve-area-content grve-content">
						<div class="grve-area-top">
							<?php do_action( 'impeka_grve_offcanvas_menu_before' ); ?>
							<div class="grve-vertical-menu-wrapper">
								<?php impeka_grve_print_main_menu( 'vertical' ); ?>
							</div>
							<?php do_action( 'impeka_grve_offcanvas_menu_after' ); ?>
						</div>
						<div class="grve-area-bottom">
							<?php echo do_shortcode( $offcanvas_text ); ?>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>

<?php
	}
}

 /**
 * Print Offcanvas Menu Alt
 */
if( !function_exists( 'impeka_grve_print_offcanvas_menu_alt' ) ) {
	function impeka_grve_print_offcanvas_menu_alt( $header_overlapping = true ) {
		$offcanvas_header_skin = impeka_grve_option( 'offcanvas_logo_color', '' );
		$offcanvas_text = impeka_grve_option( 'offcanvas_text' );


		$offcanvas_open_menu_type = impeka_grve_option( 'header_menu_open_type' );
		$offcanvas_content_position = impeka_grve_option( 'offcanvas_content_position' );
		$offcanvas_content_alignment = impeka_grve_option( 'offcanvas_content_alignment' );
		$offcanvas_close_color = impeka_grve_option( 'offcanvas_close_color' );

		$offcanvas_menu_items_animation = impeka_grve_option( 'offcanvas_menu_items_animation' );
		$offcanvas_menu_item_style = impeka_grve_option( 'offcanvas_menu_item_style', 'classic' );
		$header_orientation = impeka_grve_global_param( 'header_orientation' );

		//Offcanvas Classes
		$offcanvas_classes = array('grve-offcanvas-area', 'grve-hidden-area');
		$offcanvas_classes[] = 'grve-offcanvas-full-width';
		$offcanvas_classes[] = 'grve-offcanvas-position-left';
		$offcanvas_classes[] = 'grve-offcanvas-content-position-' . $offcanvas_content_position;
		$offcanvas_classes[] = 'grve-align-' . $offcanvas_content_alignment;
		$offcanvas_classes[] = 'grve-layout-2';

		if( 'classic' != $offcanvas_menu_item_style ) {
			$offcanvas_classes[] = 'grve-menu-type-' . $offcanvas_menu_item_style;
		}
		if( 'none' != $offcanvas_menu_items_animation ) {
			$offcanvas_classes[] = 'grve-animated-items';
		}
		$offcanvas_class_string = implode( ' ', $offcanvas_classes );

		//Offcanvas Attributes
		$offcanvas_attributes = array();
		$offcanvas_attributes[] = 'class="' . esc_attr( $offcanvas_class_string ) . '"';
		$offcanvas_attributes[] = 'data-animation="fade-in"';
		$offcanvas_attributes[] = 'data-items-animation="' . esc_attr( $offcanvas_menu_items_animation ) . '"';

?>

	<div id="grve-offcanvas-area" <?php echo implode( ' ', $offcanvas_attributes ); ?>>
		<div class="grve-area-inner">
			<div class="grve-area-scroller">
				<div class="grve-area-container">
					<div class="grve-area-content grve-content">
						<div class="grve-area-left">
							<?php do_action( 'impeka_grve_offcanvas_menu_before' ); ?>
							<div class="grve-vertical-menu-wrapper">
								<?php impeka_grve_print_main_menu( 'vertical' ); ?>
							</div>
							<?php do_action( 'impeka_grve_offcanvas_menu_after' ); ?>
						</div>
						<div class="grve-area-right">
							<div class="grve-vertical-menu-wrapper">
								<?php impeka_grve_print_second_menu( 'vertical' ); ?>
							</div>
							<?php echo do_shortcode( $offcanvas_text ); ?>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>

<?php
	}
}

/**
 * Check if page has header
 */
function impeka_grve_has_header() {

	if ( is_page_template( 'page-templates/template-content-only.php' ) ) {
		return false;
	} elseif ( is_page_template( 'page-templates/template-feature-only.php' ) ) {
		return false;
	} else if( is_404() && !impeka_grve_visibility( 'page_404_header' ) ) {
		return false;
	}
	return true;
}


/**
 * Add Body Class
 */
function impeka_grve_body_class( $classes ){
	
	global $pagenow;
	if ( 'widgets.php' == $pagenow ) {
		return $classes;
	}
	if ( defined( 'IFRAME_REQUEST' ) ) {
		return $classes;
	}

	$theme_layout = impeka_grve_option( 'theme_layout', 'stretched' );
	$image_load_mode = impeka_grve_option( 'image_load_mode' );
	$footer_shadow = impeka_grve_visibility( 'footer_shadow' );
	$header_visibility = impeka_grve_global_param( 'header_visibility' );
	$header_orientation = impeka_grve_global_param( 'header_orientation' );
	$anchor_visibility = impeka_grve_global_param( 'anchor_visibility' );
	$theme_indicator = impeka_grve_option( 'theme_indicator', '0' );

	$body_classes =  array( 'grve-body' );
	$body_classes[] = 'grve-' . $theme_layout;
	$body_classes[] = 'grve-header-' . $header_orientation;

	if ( 'yes' == $header_visibility ) {
		$header_overlapping = impeka_grve_global_param( 'header_overlapping' );
		$responsive_header_overlapping = impeka_grve_global_param( 'responsive_header_overlapping' );
		$header_group = impeka_grve_global_param( 'header_group' );
		$header_sticky_type = impeka_grve_get_sticky_type();
		if ( 'yes' == $header_overlapping && 'side' != $header_group ) {
			$body_classes[] = 'grve-header-overlapping';
		}
		if ( 'yes' == $responsive_header_overlapping ) {
			$body_classes[] = 'grve-responsive-header-overlapping';
		}
		if ( 'offcanvas' == $header_group ) {
			$body_classes[] = 'grve-offcanvas-menu';
		}
		if ( 'none' != $header_sticky_type && 'side' != $header_group && !impeka_grve_visibility( 'top_bar_enabled' ) ) {
			$body_classes[] = 'grve-header-is-sticky';
		}
	}
	if( '1' == $theme_indicator ) {
		$body_classes[] = 'grve-theme-indicator';
	}

	if( 'yes' == $anchor_visibility ) {
		$body_classes[] = 'grve-has-anchor';
	}

	if( 'lazyload' == $image_load_mode ){
		$body_classes[] = 'grve-lazy-load';
	}
	if ( $footer_shadow ){
		$body_classes[] = 'grve-footer-with-shadow';
	}
	if ( wp_is_mobile() ) {
		$body_classes[] = 'grve-is-device';
	}

	return array_merge( $classes, $body_classes );
}
add_filter( 'body_class', 'impeka_grve_body_class' );

function impeka_grve_get_sticky_type() {

	$header_sticky_type = impeka_grve_option( 'header_sticky_type', 'simple' );
	if ( is_singular() ) {
		$header_sticky_type = impeka_grve_post_meta( '_impeka_grve_sticky_header_type', $header_sticky_type );
	} else if ( impeka_grve_is_woo_shop() ) {
		$header_sticky_type = impeka_grve_post_meta_shop( '_impeka_grve_sticky_header_type', $header_sticky_type );
	}

	return $header_sticky_type;
}


function impeka_grve_get_main_header_attributes ( $header_group = 'default', $header_style = 'style-1', $header_orientation = 'horizontal', $extra_class = '' ) {

	$header_fullwidth = impeka_grve_option( 'header_fullwidth', '1' );
	$header_borders = impeka_grve_option( 'header_borders', '1' );
	$header_side_alignment = impeka_grve_option( 'header_side_align', 'left' );
	$menu_item_style = impeka_grve_option( 'menu_item_style', 'classic' );
	$impeka_megamenu_change_header_skin = impeka_grve_option( 'megamenu_change_header_skin', 0 );

	$header_position = impeka_grve_global_param( 'header_position' );
	$header_skin = impeka_grve_global_param( 'header_skin' );
	$header_sticky_mode = impeka_grve_option( 'header_sticky_mode', 'custom' );

	if ( 'vertical' == $header_orientation ) {
		$header_skin = 'default';
	}

	//Sticky Header
	$header_sticky_type = impeka_grve_get_sticky_type();
	$header_sticky_top_space = 0;
	$header_sticky_bottom_space = 0;
	if( 'scrollup' == $header_sticky_type || 'shrink' == $header_sticky_type ) {
		$header_sticky_top_space = intval( impeka_grve_option( 'header_sticky_shrink_spacing', '', 'padding-top' ) );
		$header_sticky_bottom_space = intval( impeka_grve_option( 'header_sticky_shrink_spacing', '', 'padding-bottom' ) );
		$header_sticky_logo_height = intval( impeka_grve_option( 'header_sticky_shrink_logo_height' ) );
		$header_sticky_height = $header_sticky_top_space + $header_sticky_bottom_space + $header_sticky_logo_height;
	}

	//Main Header Classes
	$main_header_classes = array();
	$main_header_classes[] = 'grve-layout-' . $header_group;
	$main_header_classes[] = 'grve-' . $header_style;

	if ( !empty($extra_class) ) {
		$main_header_classes[] = $extra_class;
	}
	if ( 1 == $header_fullwidth && 'side' != $header_group && 'vertical-animation' != $header_sticky_type ) {
		$main_header_classes[] = 'grve-fullwidth';
	}

	if( 'none' != $impeka_megamenu_change_header_skin  && 'side' != $header_group && 'offcanvas' != $header_group && 'top-bottom' != $header_group ) {
		$main_header_classes[] = 'grve-megamenu-change-header-skin';
	}

	$main_header_classes[] = 'grve-skin-' . $header_skin;

	if( 'below' == $header_position ) {
		$main_header_classes[] = 'grve-header-below';
	}
	if ( 'none' != $header_sticky_type && 'side' != $header_group ) {
		$main_header_classes[] = 'grve-' . $header_sticky_type . '-sticky';
	}
	if ( 'side' == $header_group ) {
		$main_header_classes[] = 'grve-align-' . $header_side_alignment;
		$main_header_classes[] = 'grve-animated-items';
	}

	// Add Borders
	if ( 1 == $header_borders ) {
		$main_header_classes[] = 'grve-border';
		if ( ( 'offcanvas' == $header_group && 'style-2' == $header_style ) || ( 'side' == $header_group && 'style-1' == $header_style ) ) {
			$main_header_classes[] = 'grve-border-right';
		} else {
			$main_header_classes[] = 'grve-border-bottom';
		}
	}

	if( $menu_item_style != 'classic' && 'offcanvas' != $header_group ) {
		$main_header_classes[] = 'grve-menu-type-' . $menu_item_style;
	}

	$main_header_class_string = implode( ' ', $main_header_classes );

	//Header Attributes
	$header_wrapper_attributes = array();
	$header_wrapper_attributes[] = 'class="' . esc_attr( $main_header_class_string ) . '"';
	if( 'vertical' != $header_orientation ) {
		$header_wrapper_attributes[] = 'data-sticky="' . esc_attr( $header_sticky_type ) . '"';
	}
	if( 'vertical' != $header_orientation && ('scrollup' == $header_sticky_type || 'shrink' == $header_sticky_type ) ) {
		$header_wrapper_attributes[] = 'data-sticky-height="' . esc_attr( $header_sticky_height ) . '"';
	}
	$header_wrapper_attributes[] = 'data-header-skin="' . esc_attr( $header_skin ) . '"';

	if( 'none' != $impeka_megamenu_change_header_skin  && 'side' != $header_group && 'offcanvas' != $header_group && 'top-bottom' != $header_group ) {
		$header_wrapper_attributes[] = 'data-megamenu-header-skin="' . esc_attr( $impeka_megamenu_change_header_skin ) . '"';
	}

	if( 'none' != $header_sticky_type && 'custom' != $header_sticky_mode ) {
		$header_wrapper_attributes[] = 'data-sticky-mode="' . esc_attr( $header_sticky_mode ) . '"';
	}

	return $header_wrapper_attributes;

}

function impeka_grve_print_header() {
	$header_layout = impeka_grve_option( 'header_layout', 'layout-default-style-1' );
	get_template_part( 'templates/header/' . $header_layout );
}
add_action( 'impeka_grve_theme_wrapper_top', 'impeka_grve_print_header', 30 );

//Omit closing PHP tag to avoid accidental whitespace output errors.
