<?php

/*
*	Navigation Helper functions
*
* 	@version	1.0
* 	@author		Greatives Team
* 	@URI		https://greatives.eu
*/

/**
 * Pagination functions
 */
function impeka_grve_paginate_links( $type = 'blog',  $atts = array()  ) {

	if ( !empty( $atts ) && is_array( $atts ) ) {
		$total = impeka_grve_array_value( $atts, 'total', 1 );
		$paged = impeka_grve_array_value( $atts, 'paged', 1 );
		$display_style = impeka_grve_array_value( $atts, 'display_style' );
		$load_more_title = impeka_grve_array_value( $atts, 'load_more_title' );
	} else {
		global $wp_query;
		$total = $wp_query->max_num_pages;
		$paged = 1;
		$display_style = 'pagination';

		if ( get_query_var( 'paged' ) ) {
			$paged = get_query_var( 'paged' );
		} elseif ( get_query_var( 'page' ) ) {
			$paged = get_query_var( 'page' );
		}

		if( 'blog' == $type ) {
			$blog_mode = impeka_grve_option( 'blog_mode', 'large' );
			$display_style = impeka_grve_option( 'blog_display_style', 'pagination' );
			$load_more_title = impeka_grve_option( 'blog_load_more_title', 'Load More' );
			if ( 'large' == $blog_mode ) {
				$display_style = 'pagination';
			}
		} if( 'portfolio_tax' == $type ) {
			$display_style = impeka_grve_option( 'portfolio_tax_display_style', 'pagination' );
			$load_more_title = impeka_grve_option( 'portfolio_tax_load_more_title', 'Load More' );
		} else if( 'search' == $type ) {
			$display_style = impeka_grve_option( 'search_display_style', 'pagination' );
			$load_more_title = impeka_grve_option( 'search_load_more_title', 'Load More' );
		}
	}

	$big = 999999999; // need an unlikely integer
	if( $total > 1 )  {
		if( 'infinite-scroll' == $display_style || 'load-more' == $display_style ) {
			echo '<div class="grve-infinite-pagination">';
		} else {
			echo '<div class="grve-pagination grve-pagination-text">';
		}

		if( get_option('permalink_structure') ) {
			$format = 'page/%#%/';
		} else {
		 $format = '&paged=%#%';
		}
		echo paginate_links(array(
			'base'			=> str_replace( $big, '%#%', esc_url( get_pagenum_link( $big ) ) ),
			'format'		=> $format,
			'current'		=> max( 1, $paged ),
			'total'			=> $total,
			'mid_size'		=> 2,
			'type'			=> 'list',
			'prev_text'    => '<svg width="40px" height="16px" viewBox="0 0 40 16"><polygon class="grve-arrow-line" points="0 7 38 7 38 9 0 9"></polygon><polygon class="grve-arrow-point" points="31.3481912 0 40 8 31.3481912 16 30 14.5816219 37.1 8 30 1.41837809"></polygon></svg>',
			'next_text'    => '<svg width="40px" height="16px" viewBox="0 0 40 16"><polygon class="grve-arrow-line" points="0 7 38 7 38 9 0 9"></polygon><polygon class="grve-arrow-point" points="31.3481912 0 40 8 31.3481912 16 30 14.5816219 37.1 8 30 1.41837809"></polygon></svg>',
			'add_args' => false,
		));
		echo '</div>';
		if( 'infinite-scroll' == $display_style ){
			echo '<div class="grve-infinite-page-load">
					<div class="grve-loader-ellips">
						<span class="grve-loader-ellips-dot"></span>
						<span class="grve-loader-ellips-dot"></span>
						<span class="grve-loader-ellips-dot"></span>
						<span class="grve-loader-ellips-dot"></span>
					</div>
				</div>';
		}
		if ( 'load-more' == $display_style ) {
			echo '<div class="grve-infinite-button-wrapper">
					<div class="grve-infinite-button grve-link-text">' . esc_html( $load_more_title ) . '</div>
				</div>';
		}
	}
}

function impeka_grve_wp_link_pages_args( $args ) {

	$args = array(
		'before'           => '<div class="grve-pagination grve-pagination-text"><ul><li>',
		'after'            => '</li></ul></div>',
		'link_before'      => '<span>',
		'link_after'       => '</span>',
		'aria_current'     => 'page',
		'next_or_number'   => 'number',
		'separator'        => '</li><li>',
		'previouspagelink'    => '<svg width="40px" height="16px" viewBox="0 0 40 16"><polygon class="grve-arrow-line" points="0 7 38 7 38 9 0 9"></polygon><polygon class="grve-arrow-point" points="31.3481912 0 40 8 31.3481912 16 30 14.5816219 37.1 8 30 1.41837809"></polygon></svg>',
		'nextpagelink'    => '<svg width="40px" height="16px" viewBox="0 0 40 16"><polygon class="grve-arrow-line" points="0 7 38 7 38 9 0 9"></polygon><polygon class="grve-arrow-point" points="31.3481912 0 40 8 31.3481912 16 30 14.5816219 37.1 8 30 1.41837809"></polygon></svg>',
		'pagelink'         => '%',
		'echo'             => 1
	);

	return $args;
}
add_filter( 'wp_link_pages_args', 'impeka_grve_wp_link_pages_args' );


/**
 * Filter functions
 */
if ( !function_exists( 'impeka_grve_print_filters' ) ) {
	function impeka_grve_print_filters( $atts = array() ) {

		$query = impeka_grve_array_value( $atts, 'query' );
		$category_name = impeka_grve_array_value( $atts, 'category_name', 'category' );
		$category_prefix_class = impeka_grve_array_value( $atts, 'category_prefix_class', $category_name );
		$category_ids = impeka_grve_array_value( $atts, 'category_ids', array() );

		$filter_all_text = impeka_grve_array_value( $atts, 'filter_all_text', esc_html__( "All", "impeka" ) );
		$filter_style = impeka_grve_array_value( $atts, 'filter_style', 'simple' );
		$filter_shape = impeka_grve_array_value( $atts, 'filter_shape', 'square' );
		$filter_color = impeka_grve_array_value( $atts, 'filter_color', 'primary-1' );
		$filter_align = impeka_grve_array_value( $atts, 'filter_align', 'left' );
		$filter_order_by = impeka_grve_array_value( $atts, 'filter_order_by', '' );
		$filter_order = impeka_grve_array_value( $atts, 'filter_order', 'ASC' );
		$filter_gototop = impeka_grve_array_value( $atts, 'filter_gototop', 'yes' );

		$category_prefix = '.' . $category_prefix_class . '-' ;

		$filter_classes = array( 'grve-filter' );
		$filter_classes[] = 'grve-filter-style-' . esc_attr( $filter_style );
		$filter_classes[] = 'grve-align-' .esc_attr( $filter_align );
		$filter_classes[] = 'grve-link-text';
		if ( 'button' == $filter_style ) {
			$filter_classes[] = 'grve-filter-shape-' . esc_attr(  $filter_shape );
			$filter_classes[] = 'grve-filter-color-' . esc_attr(  $filter_color );
		}
		$filter_class_string = implode( ' ', $filter_classes );

		$category_filter_list = array();
		$category_filter_array = array();

		$category_filter_add = false;
		while ( $query->have_posts() ) : $query->the_post();

			if ( $categories = get_the_terms( get_the_ID(), $category_name ) ) {

				foreach( $categories as $category_term ) {
					$category_filter_add = false;
					if ( !in_array($category_term->term_id, $category_filter_list ) ) {
						if( ! empty( $category_ids ) ) {
							if ( in_array( $category_term->term_id, $category_ids ) ) {
								$category_filter_add = true;
							}
						} else {
							$category_filter_add = true;
						}
						if ( $category_filter_add ) {
							$category_filter_list[] = $category_term->term_id;
							if ( 'title' == $filter_order_by ) {
								$category_filter_array[$category_term->name] = $category_term;
							} elseif ( 'slug' == $filter_order_by )  {
								$category_filter_array[$category_term->slug] = $category_term;
							} else {
								$category_filter_array[$category_term->term_id] = $category_term;
							}
						}
					}
				}
			}

		endwhile;


		if ( count( $category_filter_array ) > 1 ) {
			if ( '' != $filter_order_by ) {
				if ( 'ASC' == $filter_order ) {
					ksort( $category_filter_array );
				} else {
					krsort( $category_filter_array );
				}
			}
?>
			<div class="<?php echo esc_attr( $filter_class_string ); ?>" data-gototop="<?php echo esc_attr( $filter_gototop ); ?>">
				<ul>
					<li data-filter="*" class="selected"><span><?php echo esc_html( $filter_all_text ); ?></span></li>
<?php
			foreach( $category_filter_array as $category_filter ) {
				$term_class = sanitize_html_class( $category_filter->slug, $category_filter->term_id );
				if ( is_numeric( $term_class ) || ! trim( $term_class, '-' ) ) {
					$term_class = $category_filter->term_id;
				}
?>
					<li data-filter="<?php echo esc_attr( $category_prefix . $term_class ); ?>"><span><?php echo esc_html( $category_filter->name ); ?></span></li>
<?php
			}
?>
				</ul>
			</div>
			<select class="grve-filters-select">
				<option value="*"><?php echo esc_html( $filter_all_text ); ?></option>
<?php
			foreach( $category_filter_array as $category_filter ) {
				$term_class = sanitize_html_class( $category_filter->slug, $category_filter->term_id );
				if ( is_numeric( $term_class ) || ! trim( $term_class, '-' ) ) {
					$term_class = $category_filter->term_id;
				}
?>
					<option value="<?php echo esc_attr( $category_prefix . $term_class ); ?>"><?php echo esc_html( $category_filter->name ); ?></option>
<?php
			}
?>
			</select>
	<?php
		}
	}
}

if ( !function_exists( 'impeka_grve_print_image_filters' ) ) {
	function impeka_grve_print_image_filters( $atts = array()) {

		$category_prefix_class = impeka_grve_array_value( $atts, 'category_prefix_class', 'gallery-category');
		$filter_values = impeka_grve_array_value( $atts, 'filter_values', array() );
		if( empty( $filter_values ) ) {
			return;
		}

		$filter_all_text = impeka_grve_array_value( $atts, 'filter_all_text', esc_html__( "All", "impeka" ) );
		$filter_style = impeka_grve_array_value( $atts, 'filter_style', 'simple' );
		$filter_shape = impeka_grve_array_value( $atts, 'filter_shape', 'square' );
		$filter_color = impeka_grve_array_value( $atts, 'filter_color', 'primary-1' );
		$filter_align = impeka_grve_array_value( $atts, 'filter_align', 'left' );
		$filter_order_by = impeka_grve_array_value( $atts, 'filter_order_by', '' );
		$filter_order = impeka_grve_array_value( $atts, 'filter_order', 'ASC' );
		$filter_gototop = impeka_grve_array_value( $atts, 'filter_gototop', 'yes' );

		$category_prefix = '.' . $category_prefix_class . '-' ;

		$category_filter_list = array();
		$gallery_categories = array();
		$filter_index = 0;
		foreach( $filter_values as $filter_value){
			if ( empty( $filter_value ) ) {
				continue;
			}
			$image_categories = explode( '|', $filter_value );
			foreach( $image_categories as $image_category ){
				if ( !in_array( $image_category, $category_filter_list ) ) {
					$category_filter_list[] = $image_category;
					$gallery_categories[] = array(
						'term_id' => $filter_index,
						'slug' => sanitize_title_with_dashes( $image_category ),
						'name' => $image_category,
					);
					$filter_index++;
				}

			}

		}

		$filter_classes = array( 'grve-filter' );
		$filter_classes[] = 'grve-filter-style-' . esc_attr( $filter_style );
		$filter_classes[] = 'grve-align-' .esc_attr( $filter_align );
		$filter_classes[] = 'grve-link-text';
		if ( 'button' == $filter_style ) {
			$filter_classes[] = 'grve-filter-shape-' . esc_attr(  $filter_shape );
			$filter_classes[] = 'grve-filter-color-' . esc_attr(  $filter_color );
		}
		$filter_class_string = implode( ' ', $filter_classes );

		$category_filter_array = array();

		foreach( $gallery_categories as $category_term ) {
			if ( 'title' == $filter_order_by ) {
				$filter_by = $category_term['name'];
			} else {
				$filter_by = $category_term['term_id'];
			}
			$category_filter_array[$filter_by] = $category_term;
		}


		if ( count( $category_filter_array ) > 1 ) {
			if ( '' != $filter_order_by ) {
				if ( 'ASC' == $filter_order ) {
					ksort( $category_filter_array );
				} else {
					krsort( $category_filter_array );
				}
			}

	?>
				<div class="<?php echo esc_attr( $filter_class_string ); ?>" data-gototop="<?php echo esc_attr( $filter_gototop ); ?>">
					<ul>
						<li data-filter="*" class="selected"><span><?php echo esc_html( $filter_all_text ); ?></span></li>
	<?php
				foreach( $category_filter_array as $category_filter ) {

					$term_class = sanitize_html_class( $category_filter['slug'], $category_filter['term_id'] );
					if ( is_numeric( $term_class ) || ! trim( $term_class, '-' ) ) {
						$term_class = $category_filter->term_id;
					}
	?>
						<li data-filter="<?php echo esc_attr( $category_prefix . $term_class ); ?>"><span><?php echo esc_html( $category_filter['name'] ); ?></span></li>
	<?php
				}
	?>
					</ul>
				</div>
			<select class="grve-filters-select">
				<option value="*"><?php echo esc_html( $filter_all_text ); ?></option>
	<?php
				foreach( $category_filter_array as $category_filter ) {

					$term_class = sanitize_html_class( $category_filter['slug'], $category_filter['term_id'] );
					if ( is_numeric( $term_class ) || ! trim( $term_class, '-' ) ) {
						$term_class = $category_filter->term_id;
					}
	?>
						<option value="<?php echo esc_attr( $category_prefix . $term_class ); ?>"><?php echo esc_html( $category_filter['name'] ); ?></option>
	<?php
				}
	?>
			</select>
		<?php
		}
	}
}

//Omit closing PHP tag to avoid accidental whitespace output errors.
