<?php

/*
*	Portfolio Helper functions
*
* 	@version	1.0
* 	@author		Greatives Team
* 	@URI		https://greatives.eu
*/



 /**
 * Prints Portfolio Title Categories
 */
function impeka_grve_print_portfolio_title_categories( $post_id = null) {
	if ( ! $post_id ) {
		$post_id = get_the_ID();
	}
	$cat_links = array();
	$terms = get_the_terms( $post_id , 'portfolio_category' );
	if ( !empty( $terms ) && !is_wp_error( $terms ) ) {
		foreach ( $terms as $term ) {
			$term_link = get_term_link( $term, 'portfolio_category' );
			if( !is_wp_error( $term_link ) ) {
				$cat_links[] = '<a href="' . esc_url( $term_link ) . '">' . esc_html( $term->name ) . '</a>';
			}
		}
		echo '<div class="grve-categories">' . implode( ', ', $cat_links ) . '</div>';
	}
}


/**
 * Prints Portfolio Feature Image
 */
function impeka_grve_print_portfolio_feature_image( $image_size = 'large', $second_image_id = "" ) {

	if( empty( $second_image_id ) ) {
		if ( has_post_thumbnail() ) {
?>
		<div class="grve-media clearfix">
			<?php impeka_grve_the_post_thumbnail( $image_size ); ?>
		</div>
<?php

		}
	} else {
?>
		<div class="grve-media clearfix">
			<?php echo impeka_grve_get_attachment_image( $second_image_id, $image_size ); ?>
		</div>
<?php

	}
}

if ( !function_exists('impeka_grve_get_portfolio_link_atts') ) {
	function impeka_grve_get_portfolio_link_atts( $link_type = '', $image_popup_size_mode = '' ) {

		$link_atts = array();
		if ( 'popup' == $link_type ) {
			if ( has_post_thumbnail() ) {
				$id = get_post_thumbnail_id( get_the_ID() );
				$full_src = wp_get_attachment_image_src( $id, $image_popup_size_mode );
				$image_url = $full_src[0];
			} else {
				$image_url = impeka_grve_get_fallback_image( $image_popup_size_mode, 'url' );
			}
			$link_atts[] = 'class="grve-item-url"';
			$link_atts[] = 'href="' . esc_url( $image_url ) . '"';
		}  else if ( 'custom-link' == $link_type ) {
			$link_mode = get_post_meta( get_the_ID(), '_impeka_grve_portfolio_link_mode', true );
			$link_url = get_post_meta( get_the_ID(), '_impeka_grve_portfolio_link_url', true );
			$new_window = get_post_meta( get_the_ID(), '_impeka_grve_portfolio_link_new_window', true );
			$link_class = get_post_meta( get_the_ID(), '_impeka_grve_portfolio_link_extra_class', true );
			$grve_target = !empty( $new_window ) ? '_self' : '_blank' ;
			if ( '' == $link_mode )	{
				$link_atts[] = 'class="grve-item-url"';
				$link_atts[] = 'href="' . esc_url( get_permalink() ) . '"';
			} else if ( 'link' == $link_mode && !empty( $link_url ) ) {
				$link_atts[] = 'class="grve-item-url ' . esc_attr( $link_class ) . '"';
				$link_atts[] = 'href="' . esc_url( $link_url ) . '"';
				$link_atts[] = 'target="' . esc_attr( $grve_target ) . '"';
			}
		} else if ( 'quick-view' == $link_type ) {
				$link_atts[] = 'class="grve-item-url grve-quick-view-link"';
				$link_atts[] = 'href="#"';
				$link_atts[] = 'data-post-id="' . esc_attr( get_the_ID() ) . '"';
		} else {
			$link_atts[] = 'class="grve-item-url"';
			$link_atts[] = 'href="' . esc_url( get_permalink() ) . '"';
		}
		return $link_atts;
	}
}

/**
 * Prints Portfolio socials if used
 */
function impeka_grve_print_portfolio_media() {
	$post_id = get_the_ID();

	$sidebar_visibility = impeka_grve_global_param( 'sidebar_visibility' );
	$sidebar_details = impeka_grve_global_param( 'sidebar_details' );
	$portfolio_media = impeka_grve_post_meta( '_impeka_grve_portfolio_media_selection' );
	$portfolio_image_mode = impeka_grve_post_meta( '_impeka_grve_portfolio_media_image_mode' );
	$portfolio_media_fullwidth = impeka_grve_post_meta( '_impeka_grve_portfolio_media_fullwidth' );
	$image_size_slider = 'impeka-grve-large-rect-horizontal';
	if ( 'resize' == $portfolio_image_mode || 'yes' == $portfolio_media_fullwidth ) {
		if ( 'yes' == $sidebar_visibility && 'no' == $sidebar_details  ) {
			$image_size_slider = "large";
		} else {
			$image_size_slider = "impeka-grve-fullscreen";
		}
	}

	switch( $portfolio_media ) {

		case 'slider':
			$slider_items = impeka_grve_post_meta( '_impeka_grve_portfolio_slider_items' );
			impeka_grve_print_gallery_slider( 'slider', $slider_items, $image_size_slider );
			break;
		case 'gallery':
			$slider_items = impeka_grve_post_meta( '_impeka_grve_portfolio_slider_items' );
			impeka_grve_print_gallery_slider( 'gallery', $slider_items );
			break;
		case 'gallery-vertical':
			$slider_items = impeka_grve_post_meta( '_impeka_grve_portfolio_slider_items' );
			impeka_grve_print_gallery_slider( 'gallery-vertical', $slider_items, $image_size_slider );
			break;
		case 'video':
			impeka_grve_print_portfolio_video();
			break;
		case 'video-html5':
			impeka_grve_print_portfolio_video( 'html5' );
			break;
		case 'video-code':
			impeka_grve_print_portfolio_video( 'code' );
			break;
		case 'none':
			break;
		default:
			if ( 'yes' == $sidebar_visibility && 'no' == $sidebar_details  ) {
				$image_size = "large";
			} else {
				$image_size = "impeka-grve-fullscreen";
			}

			$second_image = impeka_grve_post_meta( '_impeka_grve_second_featured_image' );
			if ( 'second-image' == $portfolio_media ) {
				if( !empty( $second_image ) ) {
					impeka_grve_print_portfolio_feature_image( $image_size, $second_image );
				}
			} else {
				impeka_grve_print_portfolio_feature_image( $image_size );
			}

			break;

	}
}


/**
 * Prints video of the portfolio media
 */
function impeka_grve_print_portfolio_video( $video_mode = '' ) {

	$video_webm = impeka_grve_post_meta( '_impeka_grve_portfolio_video_webm' );
	$video_mp4 = impeka_grve_post_meta( '_impeka_grve_portfolio_video_mp4' );
	$video_ogv = impeka_grve_post_meta( '_impeka_grve_portfolio_video_ogv' );
	$video_poster = impeka_grve_post_meta( '_impeka_grve_portfolio_video_poster' );
	$video_embed = impeka_grve_post_meta( '_impeka_grve_portfolio_video_embed' );

	if( 'code' == $video_mode ) {
		$video_embed = impeka_grve_post_meta( '_impeka_grve_portfolio_video_code' );
	}

	impeka_grve_print_media_video( $video_mode, $video_webm, $video_mp4, $video_ogv, $video_embed, $video_poster );
}

 /**
 * Prints portfolio like counter
 */
function impeka_grve_print_portfolio_like_counter( $counter_color = 'content' ) {

	$post_likes = impeka_grve_option( 'portfolio_social', '', 'grve-likes' );
	if ( !empty( $post_likes  ) ) {
		global $post;
		$post_id = $post->ID;
		$active = impeka_grve_likes( $post_id, 'status' );
		$icon = 'fas fa-heart-o';
		if( 'active' == $active ) {
			$icon = 'fas fa-heart';
		}
?>
		<div class="grve-like-counter grve-link-text grve-text-<?php echo esc_attr( $counter_color ); ?>"><i class="<?php echo esc_attr( $icon ); ?>"></i><span><?php echo impeka_grve_likes( $post_id ); ?></span></div>
<?php
	}

}

/**
 * Check Portfolio details if used
 */
if ( !function_exists('impeka_grve_check_portfolio_details') ) {
	function impeka_grve_check_portfolio_details() {
		$portfolio_details_mode = impeka_grve_option( 'portfolio_details_mode', 'no' );
		$portfolio_details_mode = impeka_grve_post_meta( '_impeka_grve_details_mode', $portfolio_details_mode );
		if( 'yes' == $portfolio_details_mode ) {
			return true;
		}
		return false;
	}
}

/**
 * Prints Portfolio details
 */
if ( !function_exists('impeka_grve_print_portfolio_details') ) {
	function impeka_grve_print_portfolio_details() {
	?>
		<div class="grve-portfolio-info">
			<?php
			/**
			 * impeka_grve_portfolio_details
			 *
			 * @hooked impeka_grve_print_portfolio_details_description - 10
			 * @hooked impeka_grve_print_portfolio_details_fields - 20
			 * @hooked impeka_grve_print_portfolio_details_social - 30
			 */
				do_action( 'impeka_grve_portfolio_details' );
			?>
		</div>
	<?php
	}
}

/**
 * Prints Portfolio details description
 */
if ( !function_exists('impeka_grve_print_portfolio_details_description') ) {
	function impeka_grve_print_portfolio_details_description() {
		if ( is_singular() ) {
			$heading_tag = impeka_grve_option( 'portfolio_details_heading_tag', 'div' );
			$grve_portfolio_details_title = impeka_grve_post_meta( '_impeka_grve_details_title', impeka_grve_option( 'portfolio_details_text' ) );
			$grve_portfolio_details = impeka_grve_post_meta( '_impeka_grve_details', '' );

			$link_text = impeka_grve_post_meta( '_impeka_grve_details_link_text', impeka_grve_option( 'portfolio_details_link_text' ) );
			$link_url = impeka_grve_post_meta( '_impeka_grve_details_link_url' );
			$link_new_window = impeka_grve_post_meta( '_impeka_grve_details_link_new_window' );
			$link_extra_class = impeka_grve_post_meta( '_impeka_grve_details_link_extra_class' );

			$link_classes = array( 'grve-portfolio-details-btn', 'grve-btn' );
			if( !empty( $link_extra_class ) ){
				array_push( $link_classes,  $link_extra_class );
			}
			$link_class_string = implode( ' ', $link_classes );
			if ( !empty( $grve_portfolio_details ) || !empty( $grve_portfolio_details_title )  ) {
			?>
			<div class="grve-portfolio-description grve-border">
				<?php if ( !empty( $grve_portfolio_details_title )  ) { ?>
				<<?php echo tag_escape( $heading_tag ); ?> class="grve-h5 grve-widget-title"><?php echo wp_kses_post( $grve_portfolio_details_title ); ?></<?php echo tag_escape( $heading_tag ); ?>>
				<?php } ?>
				<?php if ( !empty( $grve_portfolio_details )  ) { ?>
				<div class="grve-portfolio-details"><?php echo do_shortcode( wp_kses_post( $grve_portfolio_details ) ) ?></div>
				<?php } ?>
				<?php
					// Portfolio Link
					if( !empty( $link_url )  ) {
						$link_target = "_self";
						if( !empty( $link_new_window )  ) {
							$link_target = "_blank";
						}
					?>
					<a href="<?php echo esc_url( $link_url ); ?>" class="<?php echo esc_attr( $link_class_string ); ?>" target="<?php echo esc_attr( $link_target ); ?>"><?php echo esc_html( $link_text ); ?></a>
					<?php
					}
					?>
			</div>
			<?php
			}
		}
	}
}
add_action( 'impeka_grve_portfolio_details', 'impeka_grve_print_portfolio_details_description', 10 );

/**
 * Prints Portfolio detials fields
 */
if ( !function_exists('impeka_grve_print_portfolio_details_fields') ) {
	function impeka_grve_print_portfolio_details_fields() {
		if ( is_singular() ) {
			$post_id = get_the_ID();
			$portfolio_fields = get_the_terms( $post_id, 'portfolio_field' );
			if ( ! empty( $portfolio_fields ) ) {
?>
			<div class="grve-portfolio-field grve-small-text grve-border">
				<?php
					foreach( $portfolio_fields as $term ) {
						$term_link = get_term_link( $term, 'portfolio_field' );
						if( !is_wp_error( $term_link ) ) {
							echo '<a href="' . esc_url( $term_link ) . '" class="grve-bg-hover-primary-1 grve-text-hover-white">' . esc_html( $term->name ) . '</a>';
						}
					}
				?>
			</div>
<?php
			}
		}
	}
}
add_action( 'impeka_grve_portfolio_details', 'impeka_grve_print_portfolio_details_fields', 20 );

/**
 * Prints Portfolio details socials
 */
if ( !function_exists('impeka_grve_print_portfolio_details_social') ) {
	function impeka_grve_print_portfolio_details_social() {
		if ( is_singular() ) {
			$social_bar_layout = impeka_grve_post_meta( '_impeka_grve_social_bar_layout', impeka_grve_option( 'portfolio_social_bar_layout', 'layout-1' ) );
			if( 'layout-2' == $social_bar_layout ) {
				impeka_grve_social_bar ( 'portfolio', 'layout-2' );
			}
		}
	}
}
add_action( 'impeka_grve_portfolio_details', 'impeka_grve_print_portfolio_details_social', 30 );


/**
 * Prints Portfolio Social Bar.
 */
if ( !function_exists('impeka_grve_print_portfolio_social_bar') ) {
	function impeka_grve_print_portfolio_social_bar() {
		$social_bar_layout = impeka_grve_post_meta( '_impeka_grve_social_bar_layout', impeka_grve_option( 'portfolio_social_bar_layout', 'layout-1' ) );
		if ( 'layout-1' == $social_bar_layout ) {
			$social_layout = impeka_grve_option( 'portfolio_social_layout', 'layout-1' );
			impeka_grve_social_bar ( 'portfolio', $social_layout );
		}
	}
}
add_action( 'impeka_grve_portfolio_section', 'impeka_grve_print_portfolio_social_bar', 10 );

/**
 * Get Portfolio Term Slugs
 */
if ( !function_exists('impeka_grve_get_portfolio_term_slugs') ) {
	function impeka_grve_get_portfolio_term_slugs( $post_id, $term_name ) {
		$term_slugs = array();
		$terms = get_the_terms( $post_id , $term_name );
		if ( !empty( $terms ) && !is_wp_error( $terms ) ) {
			foreach ( $terms as $term ) {
				$term_slugs[] = $term->slug;
			}
		}
		return $term_slugs;
	}
}

/**
 * Prints Portfolio Comments Section
 */
if ( !function_exists('impeka_grve_print_portfolio_comments_section') ) {
	function impeka_grve_print_portfolio_comments_section() {
		if ( impeka_grve_visibility( 'portfolio_comments_visibility' ) && ( comments_open() || get_comments_number() ) ) {
?>
			<div id="grve-comments-section" data-header-color="default" class="grve-border grve-padding-top-3x grve-padding-bottom-3x">
				<div class="grve-container">
					<?php comments_template(); ?>
				</div>
			</div>
<?php
		}
	}
}
add_action( 'impeka_grve_single_portfolio_after_content', 'impeka_grve_print_portfolio_comments_section', 10 );

/**
 * Prints Portfolio Related items.
 */
if ( !function_exists('impeka_grve_print_related_portfolio_items') ) {
	function impeka_grve_print_related_portfolio_items() {
		$disable_portfolio_related = impeka_grve_post_meta( '_impeka_grve_disable_related_entries' );
		if ( impeka_grve_visibility( 'portfolio_related_visibility' ) && 'yes' != $disable_portfolio_related ) {
			$post_id = get_the_ID();

			$exclude_ids = array( $post_id );

			$portfolio_related_mode = impeka_grve_option( 'portfolio_related_mode', 'recent' );

			if ( 'category' == $portfolio_related_mode ) {
				$term_slugs = impeka_grve_get_portfolio_term_slugs( $post_id, 'portfolio_category' );

				$args = array(
					'post_type' => 'portfolio',
					'post_status'=>'publish',
					'post__not_in' => $exclude_ids ,
					'tax_query' => array(
					  array(
						  'taxonomy' => 'portfolio_category',
						  'field' => 'slug',
						  'terms' => $term_slugs,
						  'operator' => 'IN'
					  ),
					),
					'posts_per_page' => 3,
					'paged' => 1,
				);
			} elseif ( 'field' == $portfolio_related_mode ) {
				$term_slugs = impeka_grve_get_portfolio_term_slugs( $post_id,'portfolio_field' );
				$args = array(
					'post_type' => 'portfolio',
					'post_status'=>'publish',
					'post__not_in' => $exclude_ids ,
					'tax_query' => array(
					  array(
						  'taxonomy' => 'portfolio_field',
						  'field' => 'slug',
						  'terms' => $term_slugs,
						  'operator' => 'IN'
					  ),
					),
					'posts_per_page' => 3,
					'paged' => 1,
				);
			} else {
				$args = array(
					'post_type' => 'portfolio',
					'post_status'=>'publish',
					'post__not_in' => $exclude_ids ,
					'posts_per_page' => 3,
					'paged' => 1,
				);
			}

			$query = new WP_Query( $args );
			if ( $query->have_posts() ) {

				get_template_part( 'templates/portfolio/related/loop-portfolio-related', 'start' );
				while ( $query->have_posts() ) {
					$query->the_post();
					get_template_part( 'templates/portfolio/related/loop-portfolio-related', 'content' );
				}
				wp_reset_postdata();
				get_template_part( 'templates/portfolio/related/loop-portfolio-related', 'end' );

			}
		}
	}
}
add_action( 'impeka_grve_single_portfolio_after_content', 'impeka_grve_print_related_portfolio_items', 20 );


/**
 * Prints Portfolio Nav Bar
 */
if ( !function_exists('impeka_grve_print_portfolio_nav_bar') ) {
	function impeka_grve_print_portfolio_nav_bar() {
		$grve_portfolio_nav_layout = impeka_grve_option( 'portfolio_nav_layout', 'layout-1' );
		impeka_grve_nav_bar( 'portfolio', $grve_portfolio_nav_layout );
	}
}
add_action( 'impeka_grve_single_portfolio_after_content', 'impeka_grve_print_portfolio_nav_bar', 30 );

/**
 * Prints Portfolio Feature Image
 */
function impeka_grve_print_portfolio_image( $image_size = 'impeka-grve-small-square', $atts = array() ) {
	if ( has_post_thumbnail() ) {
		$post_thumbnail_id = get_post_thumbnail_id( get_the_ID() );
		echo impeka_grve_get_attachment_image( $post_thumbnail_id, $image_size, '', $atts );
	} else {
		echo impeka_grve_get_fallback_image( $image_size );
	}
}

//Omit closing PHP tag to avoid accidental whitespace output errors.
