<?php

/*
*	Woocommerce hooks
*
* 	@version	1.0
* 	@author		Greatives Team
* 	@URI		https://greatives.eu
*/


//If woocomerce plugin is not enabled return
if ( !impeka_grve_woocommerce_enabled() ) {
	return false;
}




add_action( 'after_setup_theme', 'impeka_grve_woo_theme_setup' );



/**
 * Overwrite the WooCommerce actions and filters
 */

add_action('impeka_grve_woocommerce_after_single_product_sections', 'impeka_grve_print_product_bar', 40 );

add_filter('loop_shop_columns', 'impeka_grve_woo_loop_columns');
add_filter( 'loop_shop_per_page', 'impeka_grve_woo_loop_shop_per_page', 20 );

add_filter( 'woocommerce_output_related_products_args', 'impeka_grve_woo_related_args' );

add_filter( 'single_product_archive_thumbnail_size', 'impeka_grve_woo_archive_thumbnail_size' );
add_filter( 'subcategory_archive_thumbnail_size', 'impeka_grve_woo_archive_thumbnail_size' );
add_filter( 'woocommerce_gallery_thumbnail_size', 'impeka_grve_woo_gallery_thumbnail_size' );
add_filter( 'woocommerce_gallery_image_size', 'impeka_grve_woo_large_thumbnail_size' );

add_filter( 'product_cat_class', 'impeka_grve_woo_product_cat_class', 10, 3 );
add_filter( 'woocommerce_post_class', 'impeka_grve_woo_product_class', 10, 2 );


//Product Thumbnails
add_action('woocommerce_product_thumbnails', 'impeka_grve_woo_thumbnails_before', 5 );
add_action( 'woocommerce_product_thumbnails', 'impeka_grve_woo_thumbnails_after', 50 );
add_filter( 'woocommerce_single_product_image_gallery_classes', 'impeka_grve_woo_add_gallery_popup_class' );


//Move Single Product Notices
remove_action( 'woocommerce_before_single_product', 'woocommerce_output_all_notices', 10 );
add_action('woocommerce_single_product_summary', 'impeka_grve_print_product_social', 90 );
add_action( 'woocommerce_single_product_summary', 'woocommerce_output_all_notices', 100 );

// Move Sale Flash
remove_action( 'woocommerce_before_single_product_summary', 'woocommerce_show_product_sale_flash', 10 );
add_action( 'woocommerce_single_product_summary', 'woocommerce_show_product_sale_flash', 0 );

// Move Single Product Pricing
remove_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_price', 10 );
add_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_price', 2 );

//Remove Content Wrappers
remove_action( 'woocommerce_before_main_content', 'woocommerce_output_content_wrapper', 10 );
remove_action( 'woocommerce_before_main_content','woocommerce_breadcrumb', 20, 0);
remove_action( 'woocommerce_after_main_content', 'woocommerce_output_content_wrapper_end', 10 );

//Remove Archive/Shop/Product Title Description
add_filter( 'woocommerce_show_page_title', '__return_false' );
add_filter( 'woocommerce_product_description_heading', '__return_empty_string' );
add_filter( 'woocommerce_product_additional_information_heading', '__return_empty_string' );
remove_action( 'woocommerce_archive_description', 'woocommerce_taxonomy_archive_description', 10 );
remove_action( 'woocommerce_archive_description', 'woocommerce_product_archive_description', 10 );


add_filter('woocommerce_checkout_fields','impeka_grve_woo_checkout_fields_no_label');

// -------------   SHOP LOOP -------------------
add_action( 'woocommerce_before_shop_loop', 'impeka_grve_woo_start_shop_result_wrapper', 19 );
add_action( 'woocommerce_before_shop_loop', 'impeka_grve_woo_end_shop_result_wrapper', 31 );


// Product Loop
remove_action( 'woocommerce_after_shop_loop_item', 'woocommerce_template_loop_add_to_cart', 10 );
remove_action( 'woocommerce_shop_loop_item_title', 'woocommerce_template_loop_product_title' , 10 );
remove_action( 'woocommerce_after_shop_loop_item_title', 'woocommerce_template_loop_price', 10 );
remove_action( 'woocommerce_after_shop_loop_item_title', 'woocommerce_template_loop_rating', 5 );
remove_action( 'woocommerce_before_shop_loop_item', 'woocommerce_template_loop_product_link_open', 10 );
remove_action( 'woocommerce_after_shop_loop_item', 'woocommerce_template_loop_product_link_close', 5 );
remove_action( 'woocommerce_before_shop_loop_item_title', 'woocommerce_template_loop_product_thumbnail', 10 );

add_action( 'woocommerce_before_shop_loop_item', 'impeka_grve_woo_shop_loop_wrapper_start', 0 );

add_action( 'woocommerce_before_shop_loop_item_title', 'impeka_grve_woo_loop_product_thumbnail_wrapper', 10 );
add_action( 'impeka_grve_woo_loop_product_media', 'woocommerce_template_loop_product_thumbnail', 10 );
add_action( 'impeka_grve_woo_loop_product_media', 'impeka_grve_woo_loop_product_second_thumbnail', 15 );
add_action( 'woocommerce_before_shop_loop_item_title', 'impeka_grve_woo_loop_product_title_wrapper', 10 );
add_action( 'impeka_grve_woo_loop_product_content', 'impeka_grve_woo_loop_product_title', 10 );
add_action( 'impeka_grve_woo_loop_product_content', 'impeka_grve_woo_loop_add_to_cart_wrapper', 15 );
add_action( 'impeka_grve_woo_loop_price', 'woocommerce_template_loop_price', 10 );
add_action( 'impeka_grve_woo_loop_add_to_cart', 'woocommerce_template_loop_add_to_cart', 10 );
add_action( 'woocommerce_after_shop_loop_item', 'impeka_grve_woo_shop_loop_wrapper_end', 100 );


// Category Loop
remove_action( 'woocommerce_before_subcategory', 'woocommerce_template_loop_category_link_open', 10 );
remove_action( 'woocommerce_shop_loop_subcategory_title', 'woocommerce_template_loop_category_title', 10 );
remove_action( 'woocommerce_before_subcategory_title', 'woocommerce_subcategory_thumbnail', 10 );
remove_action( 'woocommerce_after_subcategory', 'woocommerce_template_loop_category_link_close', 10 );

add_action( 'woocommerce_before_subcategory', 'impeka_grve_woo_shop_loop_wrapper_start', 0 );
add_action( 'woocommerce_shop_loop_subcategory_title', 'impeka_grve_woo_loop_subcategory_title_wrapper', 10 );
add_action( 'impeka_grve_woo_loop_subcategory_title', 'impeka_grve_woo_loop_subcategory_title', 10 );
add_action( 'woocommerce_before_subcategory_title', 'impeka_grve_woo_loop_subcategory_thumbnail_wrapper', 10 );
add_action( 'impeka_grve_woo_loop_subcategory_thumbnail', 'woocommerce_subcategory_thumbnail', 10 );
add_action( 'woocommerce_after_subcategory', 'impeka_grve_woo_shop_loop_wrapper_end', 100 );


// My Account
add_action( 'woocommerce_before_customer_login_form', 'impeka_grve_woo_customer_login_form_wrapper_start', 0 );
add_action( 'woocommerce_after_customer_login_form', 'impeka_grve_woo_customer_login_form_wrapper_end', 100 );

//Omit closing PHP tag to avoid accidental whitespace output errors.
