jQuery(document).ready(function($) {

	"use strict";

	if( 0 === $('.grve-custom-sidebar-normal').length ) {
		$('.grve-custom-sidebar-empty').show();
	}

	$(document).on("click",".grve-custom-sidebar-item-delete-button",function() {
		$(this).parents('.grve-custom-sidebar-item').remove();
		$('.grve-sidebar-changed').show();
		if( 0 === $('.grve-custom-sidebar-normal').length ) {
			$('.grve-custom-sidebar-empty').show();
		}
		$('#grve-custom-sidebars-form').submit();
	});

	$(document).on("click","#grve-add-custom-sidebar-item",function(event) {
		event.preventDefault();
		$('.grve-sidebar-wrap .button').prop("disabled", true).addClass('disabled');
		$('.grve-sidebar-notice').hide();
		$('.grve-sidebar-notice-exists').hide();
		$('.grve-sidebar-spinner').show();

		var sidebarName = $('#grve-custom-sidebar-item-name-new').val();

		if ( '' == sidebarName.trim() ) {
			$('.grve-sidebar-notice').show();
			$('.grve-sidebar-spinner').hide();
			$('.grve-sidebar-wrap .button').prop("disabled", false).removeClass('disabled');
		} else {

			var alreadyExists = false;
			$('.grve-sidebar-wrap .grve-custom-sidebar-item-name').each(function () {
				if( $(this).val() == sidebarName ) {
					alreadyExists = true;
					return false;
				}
			});
			if ( alreadyExists ) {
				$('.grve-sidebar-notice-exists').show();
				$('.grve-sidebar-spinner').hide();
				$('.grve-sidebar-wrap .button').prop("disabled", false).removeClass('disabled');
			} else {
				var dataParams = {
					action:'impeka_grve_get_custom_sidebar',
					sidebar_name: sidebarName,
					_grve_nonce: impeka_grve_custom_sidebar_texts.nonce_custom_sidebar
				};
				$.post( impeka_grve_custom_sidebar_texts.ajaxurl, dataParams, function( sidebarHtml ) {
					$('#grve-custom-sidebar-container').append(sidebarHtml);
					$('#grve-custom-sidebar-item-name-new').val('');
					$('.grve-sidebar-spinner').hide();
					$('.grve-sidebar-changed').show();
					$('.grve-sidebar-wrap .button').prop("disabled", false).removeClass('disabled');
					if( 0 !== $('.grve-custom-sidebar-normal').length ) {
						$('.grve-custom-sidebar-empty').hide();
					}
					$('#grve-custom-sidebars-form').submit();
				}).fail(function(xhr, status, error) {
					$('.grve-sidebar-spinner').hide();
					$('.grve-sidebar-wrap .button').prop("disabled", false).removeClass('disabled');
				});
			}
		}
	});

	$( "#grve-custom-sidebar-container" ).sortable();
	$('.grve-sidebar-saved').delay(4000).slideUp();


});