
var GRVE = GRVE || {};

(function($){
	'use strict';

	GRVE = {
		init: function() {
			this.headerSettings.init();
			this.feature.init();
			this.pageSettings.init();
		},
		onLoad: function(){
			GRVE.pageSettings.sectionColor.onResize();
			GRVE.pageSettings.skinScrollEffect.onResize();
			GRVE.pageSettings.skinScrollEffectElementor.onResize();
			GRVE.pageSettings.sectionNav.onResize();
			GRVE.pageSettings.parallaxBg.onResize();
			GRVE.pageSettings.parallaxCol.onResize();

			// Location Hash
			if (window.location.hash) {
				setTimeout(function() {
					var target = window.location.hash;
					if( $(target).length ){
						if ( $(target).hasClass('grve-tab-content') || $(target).hasClass('grve-accordion-content')  ) {
							var tabLink =  $('.grve-tab-link[data-rel="' + target + '"]:visible');
							if ( tabLink.length ) {
								tabLink.click();
							}
						} else {
							$('html, body').scrollTop( $(target).offset().top );
						}
					}
				}, 0);
			}
		},
		onResize: function() {
			this.headerSettings.onResize();
			this.pageSettings.onResize();
			this.feature.onResize();
		},
		onScroll: function() {
			this.headerSettings.onScroll();
			this.pageSettings.onScroll();
			this.feature.onScroll();
		},
		afterTransition: function(){
			this.pageSettings.basics.svgAnimation();
		}
	};

	GRVE.headerSettings = {
		init: function(){
			this.mainHeader.init();
			this.verticalMenu.init();
			this.horizontalMenu.init();
			this.offcanvasMenu.init();
			this.slidingArea.init();
			this.responsiveMenu.init();
			this.safeButton.init();
			this.anchorMenu.init();
			this.anchorMenu.sticky( false );
			this.languageDropdown();
			this.miniCart();

			this.mainHeader.getHeaderHeight();
		},
		onScroll: function(){
			this.mainHeader.updateSticky();
		},
		onResize: function(){
			this.mainHeader.checkSticky();
		},
		mainHeader: {
			selectors: '#grve-main-header, #grve-main-responsive-header',
			init: function(){
				var base = this;
				$activeHeader = base.getHeader();
				if( !$activeHeader.length ) {
					return;
				}
				stickyType = $activeHeader.data('sticky');

				base.checkSticky();
				// Disable or Enable Sticky Event
				$window.on('grve_safebutton_before_close' ,function(){
					var $header = base.getHeader();
					if ( 'none' !== stickyType ) {
						base.disableSticky( $header );
					}
				});
				$window.on('grve_safebutton_close' ,function(){
					var $header = base.getHeader();
					if ( 'none' !== stickyType ) {
						base.enableSticky( $header, frameSize );
					}
				});
				var offset = $('#grve-header').offset().top != undefined ? $('#grve-header').offset().top : 0,
					headerHeight = $activeHeader.outerHeight();
				base.headerOffset = headerHeight + offset;
			},
			getHeader: function(){
				var base = this;
				return $(base.selectors).filter(':visible');
			},
			getHeaderHeight: function(){
				var base = this,
					$activeHeader = base.getHeader(),
					stickyType = $activeHeader.data('sticky'),
					headerH = 0;

				if( $activeHeader && 'none' !== stickyType && undefined !== stickyType ) {
					if ( 'scrollup' === stickyType || 'shrink' === stickyType ) {
						var paddingT = parseInt(impeka_grve_main_data.header_sticky_shrink_spacing['padding-top']),
							paddingB = parseInt(impeka_grve_main_data.header_sticky_shrink_spacing['padding-bottom']),
							logoH = parseInt(impeka_grve_main_data.header_sticky_shrink_logo_height),
							mainHeaderH = $('#grve-main-header .grve-header-row').height(),
							mainHeaderH = mainHeaderH > logoH ? mainHeaderH : logoH;
						headerH = mainHeaderH + paddingT + paddingB;
					} else {
						headerH = $activeHeader.outerHeight();
					}
				}
				return headerH;
			},
			checkSticky: function(){
				var base = this;
				$activeHeader = base.getHeader();
				stickyType = $activeHeader.data('sticky');
				if( $activeHeader ) {
					if ( 'none' !== stickyType && undefined !== stickyType ) {
						base.enableSticky( $activeHeader, frameSize );
						setTimeout(function(){
							$activeHeader.addClass('grve-sticky-ready');
						},200);
					} else {
						base.disableSticky( $activeHeader );
					}
				}
			},
			enableSticky: function( $header, offset ){
				if ( typeof stick_in_parent == 'undefined' && !$().stick_in_parent ) {
					console.log('Sticky Kit not Defined.');
					return true;
				}
				if( offset === undefined ) {
					offset = 0;
				}

				$header.stick_in_parent({
					parent: 'body',
					sticky_class: 'grve-fixed',
					offset_top: offset
				}).on("sticky_kit:stick", function(e) {
					headerIsSticky = true;
					GRVE.headerSettings.mainHeader.updateSticky();
				});
				$header.trigger('sticky_kit:recalc');
				disableStickyHeader = false;
			},
			disableSticky: function( $header ){
				if ( typeof stick_in_parent == 'undefined' && !$().stick_in_parent ) {
					console.log('Sticky Kit not Defined.');
					return true;
				}
				$header.trigger('sticky_kit:detach');
				disableStickyHeader = true;
				$header.removeClass('grve-sticky-header grve-scroll-down grve-scroll-up');
			},
			updateSticky: function(){
				var base = this;
				if( 'none' === stickyType || undefined === stickyType || !$activeHeader.length || $activeHeader.is('#grve-main-responsive-header') || disableStickyHeader ) return;

				var scroll = $window.scrollTop(),
					direction = GRVE.helpers.getScrollDirection(),
					tolerance = getTolerance( scroll, direction );

				if( scroll > base.headerOffset && headerIsSticky && !$mainHeader.hasClass('grve-sticky-header') ) {
					GRVE.headerSettings.anchorMenu.sticky( true );
				}

				if( scroll > base.headerOffset && direction === 'down' && headerIsSticky && !$mainHeader.hasClass('grve-sticky-header') ) {
					$mainHeader.addClass('grve-sticky-header');
					anchorMove( 'up' );
					if( 'main-header' != $activeHeader.data('sticky-mode') ) {
						base.changeSkin( 'sticky' );
					}
				} else if( scroll <= base.headerOffset && direction === 'up' && headerIsSticky && $mainHeader.hasClass('grve-sticky-header') ) {
					$mainHeader.removeClass('grve-sticky-header');
					anchorMove( 'down' );
					if( 'main-header' != $activeHeader.data('sticky-mode') ) {
						base.changeSkin();
					}
				}

				if( 'scrollup' === stickyType ){
					if( 'down' === direction && scroll > 500 + base.headerOffset && !hideStickyHeader && tolerance ) {
						hideStickyHeader = true;
						$activeHeader.addClass('grve-hide-header');
						anchorMove( 'top' );
					} else if( 'up' === direction && hideStickyHeader && tolerance ) {
						hideStickyHeader = false;
						$activeHeader.removeClass('grve-hide-header');
						anchorMove( 'bottom' );
					}
				}

				function getTolerance( scroll, direction ) {
					var tolerance = { up : 0, down : 0 };
					if( GRVE.helpers.isMobile.any() ) {
						tolerance = { up : 20, down : 20 };
					}
					return Math.abs(scroll - scrolPosition) >= tolerance[direction];
				}

				function anchorMove( position ) {
					if( $anchorMenu.length ) {
						var top = parseInt( $anchorMenu.css('top') );
						if( 'up' === position ) {
							$anchorMenu.css({
								'transform': 'translateY(-' + (top - base.getHeaderHeight()) + 'px)'
							});
						} else if( 'top' === position ) {
							$anchorMenu.css({
								'transform': 'translateY(-' + top + 'px)'
							});

						} else if( 'bottom' === position ) {
							$anchorMenu.css({
								'transform': 'translateY(-' + (top - base.getHeaderHeight()) + 'px)'
							});
						} else {
							$anchorMenu.css({
								'transform': 'translateY(0)'
							});
						}
					}
				}

				if( 'main-header' == $activeHeader.data('sticky-mode') && !$content.hasClass('grve-skin-effect') ) {
					var $section = $body.hasClass('elementor-page') ? $('.elementor-section') : $('.grve-section'),
						sectionLength = $section.length;
					$section.each(function(){
						var $that = $(this),
							sectionTop = $that.offset().top,
							sectionBottom = sectionTop + $that.outerHeight(),
							scroll = $window.scrollTop(),
							offset = GRVE.helpers.getTopBarHeight();

						if( ((0 === $that.index() && sectionTop - offset > scroll) || (sectionLength - 1 === $that.index() && sectionBottom - offset < scroll)) && $that.hasClass('current-section') ) {
							$that.removeClass('current-section');
							base.changeSkin( $activeHeader.data('header-color') );
						} else if( sectionTop - offset <= scroll && sectionBottom - offset > scroll && !$that.hasClass('current-section') ){
							$that.addClass('current-section').siblings().removeClass('current-section');
							base.changeSkin( $that.data('header-color') );
						}
					});
				}
			},
			changeSkin: function( skin ){
				var currentSkin = $mainHeader.data('header-skin'),
					newSkin = skin !== undefined ? skin : currentSkin;
				$mainHeader
				.removeClass('grve-skin-dark grve-skin-light grve-skin-default grve-skin-sticky')
				.addClass('grve-skin-' + newSkin);
			}
		},
		horizontalMenu: {
			init: function(){
				this.mainMenu();
			},
			mainMenu: function(){
				var base = this,
					$mainMenu = $('#grve-header .grve-horizontal-menu > ul.grve-menu');
				$('.grve-main-menu').find( 'a[href="#"]').on('click',function(e){
					e.preventDefault();
				});
				$mainMenu.superfish({
					popUpSelector: '.grve-sub-menu, .grve-megamenu-sub-menu-column',
					delay: 800,
					speed: 300,
					cssArrows: false,
					hoverClass: 'grve-menu-hover',
					speedOut: 100,
					animation: false,
					animationOut: false,
					disableHI: true,
					onBeforeShow: function(){
						var $subMenu = $(this);
						if( !$subMenu.length ) return;
						var $li = $subMenu.parent(),
							windowW = $window.width(),
							subMenuW = $subMenu.width(),
							liOffsetL = $li.offset().left;

						$li.removeClass('grve-invert');

						if( $li.hasClass('grve-menu-size-custom') ){
							if(subMenuW + liOffsetL > windowW) {
								var left = windowW - (subMenuW + liOffsetL);
								$subMenu.css({'left' : left - 30});
							}
						}

						if( !$li.hasClass('megamenu') && $li.hasClass('menu-item-has-children') ){
							var $nextSubmenu = $li.children('.grve-classic-sub-menu');
							if( $nextSubmenu.length ) {
								var subMenuOffsetL = $nextSubmenu.offset().left;
								if( subMenuW + subMenuOffsetL > windowW) {
									$li.addClass('grve-invert');
								}
							}
						}

						if( $body.hasClass('grve-boxed') && $li.hasClass('grve-menu-size-custom') ){
							var containerW = $('#grve-theme-wrapper').width(),
								containerL = $('#grve-theme-wrapper').offset().left,
								positionL = 0;
							if( subMenuW + liOffsetL > containerW + containerL ){
								positionL = (containerW + containerL) - (subMenuW + liOffsetL);
							}
							$subMenu.css({
								'left' : positionL
							});
						}

						var $areaVerticalMenu = $subMenu.find('.grve-vertical-menu');
						$areaVerticalMenu.each(function(){
							GRVE.headerSettings.verticalMenu.reset( $(this) );
						});
					},
					onShow: function(){
						var $subMenu = $(this),
							$li = $subMenu.parent();
						if( $mainHeader.hasClass('grve-megamenu-change-header-skin') && $li.hasClass('megamenu') && !$li.hasClass('grve-menu-size-custom') ){
							base.removeTransparentHeader(true);
						}
					},
					onBeforeHide: function(){
						var $subMenu = $(this),
							$li = $subMenu.parent();
						if( $mainHeader.hasClass('grve-megamenu-change-header-skin') && $li.hasClass('grve-first-level') ){
							base.removeTransparentHeader(false);
						}
					}
				});
			},
			removeTransparentHeader: function(bool){
				var skin = $mainHeader.data('header-skin'),
					megamenuSkin = $mainHeader.data('megamenu-header-skin');
				if( bool && !$mainHeader.hasClass('grve-skin-changed') ) {
					$mainHeader.removeClass('grve-skin-' + skin);
					$mainHeader.addClass('grve-skin-changed grve-skin-' + megamenuSkin );
				} else if( !bool && $mainHeader.hasClass('grve-skin-changed') ) {
					$mainHeader.removeClass('grve-skin-changed grve-skin-' + megamenuSkin );
					$mainHeader.addClass('grve-skin-' + skin);
				}
			}
		},
		verticalMenu: {
			init: function(){
				var base = this,
					isMoving = false;

				base.setVerticalMenu();

				$verticalMenu.each(function(){
					var $menu = $(this),
						menuType = $menu.data('menu-type'),
						$menuItem = $menu.find('li.menu-item-has-children'),
						$subMenu = $menuItem.children().not( $('.grve-link-wrapper') );
						$menu.data( 'current', 0 );

					if( 'slide' == menuType ) {
						addBackButton( $subMenu );
					}
				});

				$document.on('click', '.grve-vertical-menu .grve-link-wrapper a', function(e){
					var link = $(this).attr('href');
					if( link === '#' ) {
						e.preventDefault();
						getAnimationType( $(this) );
					}
				});

				$document.on('click', '.grve-vertical-menu .grve-arrow', function(){
					getAnimationType( $(this) );
				});

				// Go Back
				$document.on('click', '.grve-vertical-menu .grve-go-back-wrapper a', function(e){
					e.preventDefault();
					var $menu = $(this).closest('.grve-vertical-menu'),
						itemsAnim = $menu.parents('.grve-hidden-area').data('items-animation') !== undefined ? $menu.parents('.grve-hidden-area').data('items-animation') : 'bottom-to-top',
						$currentMenu = $(this).parent().parent(),
						current = $menu.data( 'current' ),
						$prevSubMenu = current === 1 ? $currentMenu.parent().parent() : $currentMenu.parent().parent().parent();
					if( !isMoving ) {
						isMoving = true;
						moveBack( $menu, --current, $currentMenu, $prevSubMenu, itemsAnim );
					}
				});

				function getAnimationType( $item ){
					var $menu = $item.closest('.grve-vertical-menu'),
						menuType = $menu.data('menu-type'),
						itemsAnim = $menu.parents('.grve-hidden-area').data('items-animation') !== undefined ? $menu.parents('.grve-hidden-area').data('items-animation') : 'bottom-to-top',
						$nextMenu = $item.parent().parent().children().not( $('.grve-link-wrapper') ),
						title = $item.parent().find('.grve-item').html(),
						current = $menu.data( 'current' );

					if( !isMoving ) {
						isMoving = true;
						if( 'slide' == menuType ) {
							addBackTitle( $nextMenu, title );
							moveNext( $menu, ++current, $nextMenu, itemsAnim );
						} else if( 'toggle' == menuType ) {
							toggle( $nextMenu, itemsAnim );
						} else if( 'accordion' == menuType ) {
							accordion( $nextMenu, itemsAnim );
						}
					}
				}

				function moveNext( $menu, level, $nextMenu, itemsAnim ){
					var position = -(level * 100) + '%',
						items = base.getItems( $nextMenu ),
						timeline = gsap.timeline();
					$nextMenu.addClass('grve-current');
					$menu.css({'min-height' : $nextMenu.height() });
					if( itemsAnim != 'none' ) {
						timeline.to($menu, {x:position, duration:0.4, ease:'power1.out'});
						timeline.fromTo(items, { opacity: 0, y:20 }, { opacity: 1, y:0, duration:0.4, ease:'power1.out', stagger: 0.1, onComplete: onComplete }, '<0.4');
					} else {
						timeline.to($menu, {x:position, duration:0.4, ease:'power1.out', onComplete: onComplete });
					}
					function onComplete(){
						isMoving = false;
						$menu.data( 'current', level );
					}
				}
				function moveBack( $menu, level, $currentMenu, $prevSubMenu, itemsAnim ){
					var position = -(level * 100) + '%',
						items = base.getItems( $currentMenu ),
						timeline = gsap.timeline({clear: true});
					if( itemsAnim != 'none' ) {
						timeline.fromTo(items, { opacity: 1, y:0 }, { opacity: 0, y:20, duration:0.4, ease:'power1.out', stagger: 0.1 });
						timeline.to($menu, {x:position, duration:0.4, ease:'power1.out', onComplete: onComplete }, '<0.4');
					} else {
						timeline.to($menu, {x:position, duration:0.4, ease:'power1.out', onComplete: onComplete });
					}
					function onComplete(){
						isMoving = false;
						$currentMenu.removeClass('grve-current');
						$menu.css({'min-height' : $prevSubMenu.height() });
						$menu.data( 'current', level );
					}
				}
				function toggle( $nextMenu, itemsAnim ){
					var items = base.getItems( $nextMenu ),
						timeline = gsap.timeline();

					if( $nextMenu.is(':visible') ) {
						$nextMenu.parent().find('.grve-arrow').removeClass('grve-open');
						$nextMenu.slideUp(200,function(){
							isMoving = false;
							$(this).removeClass('grve-current').find( '.grve-current' ).removeClass('grve-current').hide();
						});
					} else {
						$nextMenu.parent().find('.grve-arrow').first().addClass('grve-open');
						$nextMenu.slideDown(200,function(){
							isMoving = false;
							$(this).addClass('grve-current');
							if( itemsAnim != 'none' ) {
								timeline.from(items, { opacity: 0, y:10, duration:0.4, ease:'power1.out', stagger: 0.1 });
							}
						});
					}
				}
				function accordion( $nextMenu, itemsAnim ){
					var items = base.getItems( $nextMenu ),
						timeline = gsap.timeline({clear: true});
					if( $nextMenu.is(':visible') ) {
						$nextMenu.parent().find('.grve-arrow').removeClass('grve-open');
						$nextMenu.slideUp(200,function(){
							isMoving = false;
							$(this).removeClass('grve-current').find( '.grve-current' ).removeClass('grve-current').hide();
						});
					} else {
						$nextMenu.parent().find('.grve-arrow').first().addClass('grve-open');
						$nextMenu.slideDown(200,function(){
							isMoving = false;
							$(this).addClass('grve-current');
							if( itemsAnim != 'none' ) {
								timeline.from(items, { opacity: 0, y:10, duration:0.4, ease:'power1.out', stagger: 0.1 });
							}
						}).parent().siblings().find( '.grve-current' ).slideUp(200, function(){
							$(this).parent().find('.grve-arrow').removeClass('grve-open');
							$(this).removeClass('grve-current').find( '.grve-current' ).removeClass('grve-current').hide();
						});
					}
				}
				// Add Back Button
				function addBackButton( $subMenu ){
					$subMenu.each(function(){
						var $that = $(this);

						var $backBtn = $('<li class="grve-go-back-wrapper"><a href="#" class="grve-go-back"><div class="grve-back-arrow"></div></a></li>');
						if( $that.hasClass('grve-sub-menu') ) {
							$backBtn = $('<div class="grve-go-back-wrapper"><a href="#" class="grve-go-back"><div class="grve-back-arrow"></div></a></div>');
						}
						if( !$that.find('.grve-go-back-wrapper').length ){
							$backBtn.prependTo( $that );
						}
					});
				}
				// Add Back Button Title
				function addBackTitle( $subMenu, title ){
					var $backBtn = $subMenu.children('.grve-go-back-wrapper'),
						$label = $backBtn.find('.grve-label');
					$label.html( title );
					$backBtn.removeClass('grve-active');
				}
			},
			getItems: function( $subMenu ){
				var items = [],
					$back = $subMenu.find('.grve-go-back-wrapper');
				if( $back.length ) {
					items.push( $back[0] );
				}
				if( $subMenu.hasClass('grve-area-item-sub-menu') ) {
					var $item = $subMenu.children().not('.grve-go-back-wrapper');
					items.push( $item );
				} else if( $subMenu.hasClass('grve-sub-menu') ){
					var $item = $subMenu.find('.sub-menu').first().children();
					$item.each(function(){
						items.push( $(this).find('.grve-link-wrapper').first() );
					});
				} else {
					var $item = $subMenu.children('li').not('.grve-go-back-wrapper');
					$item.each(function(){
						items.push( $(this).find('.grve-link-wrapper').first() );
					});
				}

				return items;
			},
			reset: function( $menu ){
				var base = this,
					menuType = $menu.data('menu-type');
				if('slide' == menuType ) {
					var timeline = gsap.timeline({clear: true});
					timeline.to($menu, {x:0, duration:0, ease:'power1.out' });
					$menu.data( 'current', 0 );
					$menu.removeAttr('style');
					$menu.find('.grve-current').removeClass('grve-current');

				} else {
					$menu.children().find('.grve-current').removeClass('grve-current').hide();
					$menu.find('.grve-arrow').removeClass('grve-open');
				}
			},
			setVerticalMenu: function(){
				// Simplify Area item menu
				var $areaSubMenu = $('.grve-area-item-sub-menu');
				$areaSubMenu.each(function(){
					var $menu = $(this).find('.grve-vertical-menu .grve-menu'),
						$menuItem = $menu.find('.grve-first-level'),
						$arrow = $menuItem.find('.grve-arrow'),
						$subMenu = $menuItem.children().not('.grve-link-wrapper');
					$menuItem.removeClass('menu-item-has-children');
					$arrow.remove();
					$subMenu.remove();
				});

				// Remove Hidden menu item
				var $hidenItem = $verticalMenu.find('.grve-hidden-menu-item');
				$hidenItem.each(function(){
					var $that = $(this),
						$subMenu = $that.find('.sub-menu').first();
					if( $subMenu.length ) {
						$subMenu.children().insertAfter( $that );
						$that.remove();
					}
				});
			}
		},
		toggleHiddenArea: {
			init: function( area, btn, name ){
				var base = this,
					$area = $( area ),
					areaName = name != undefined ? name : 'hiddenarea';
				if( $area.length ) {
					var areaOpen = false,
						$areaInner = $area.find('.grve-area-inner'),
						$content = $area.find('.grve-content'),
						$overlay = $area.find('.grve-hidden-area-overlay'),
						$closeBtn = $area.find('.grve-close-btn'),
						animType = $area.data('animation'),
						animParams = $.extend( base.getAnimationType( animType ), {duration:0.4, ease:'power1.out'} ),
						timeline = gsap.timeline({
							paused:true,
							onStart: function(){
								$area.css('display','block');
								base.open( $area, areaName );
							},
							onComplete: itemsAnim,
							onReverseComplete: function(){
								base.close( $area, areaName );
								$area.css('display','none');
							}
						});
					if( $overlay.length ) {
						timeline.fromTo($overlay,{opacity: 0}, {opacity: 1, duration:0.4, ease:'power1.out'});
					}
					timeline.from($areaInner, animParams);

					$document.on('click', btn, function( event ){
						event.preventDefault();
						if( !areaOpen ){
							areaOpen = true;
							timeline.play();
							$window.trigger('grve_' + areaName + '_before_open'); // Trigger event
						} else if( areaOpen ){
							areaOpen = false;
							timeline.reverse();
							$window.trigger('grve_' + areaName + '_before_close'); // Trigger event
						}
						if( $area.hasClass('grve-offcanvas-full-width') ) {
							$(btn).toggleClass('grve-close');
						}
					});

					$closeBtn.on('click', function( event ){
						event.preventDefault();
						if( areaOpen ){
							areaOpen = false;
							timeline.reverse();
							$window.trigger('grve_' + areaName + '_before_close'); // Trigger event
						}
						if( $area.hasClass('grve-offcanvas-full-width') ) {
							$(btn).toggleClass('grve-close');
						}
					});

					function itemsAnim(){
						var items = base.getItems( area );
						if( items.length ) {
							var animType = $area.data('items-animation'),
								animParams = $.extend( base.getAnimationType( animType ), {duration:0.4, ease:'power1.out', stagger: 0.1 }),
								timeline = gsap.timeline({ onComplete: complete });

							timeline.set($content, {visibility: 'visible'});
							timeline.from(items, animParams);
						} else {
							complete();
						}

						function complete(){
							$window.trigger('grve_' + areaName + '_open'); // Trigger event
						}
					}

				}
			},
			getItems: function( area ){
				var items = [];
				if( '#grve-offcanvas-area' === area ) {
					var $logo = $(area).find('.grve-offcanvas-logo'),
						$menu = $(area).find('#grve-main-menu.grve-vertical-menu > .grve-menu'),
						$menuItem = $menu.children();
						if( $logo.length ) {
							items.push( $logo );
						}
						$menuItem.each(function(){
							items.push( $(this).find('> .grve-link-wrapper') );
						});
				} else if( '#grve-responsive-menu-area' === area ){
					var $menu = $(area).find('.grve-vertical-menu'),
						$menuItem = $menu.find('.grve-first-level:not(.grve-menu-element-first-level) > .grve-link-wrapper'),
						items = $.makeArray( $menuItem );
				}
				var $bottomArea = $(area).find('.grve-area-bottom'),
					$bottomItems = $bottomArea.children(),
					$rightArea = $(area).find('.grve-area-right'),
					$secondMenu = $(area).find('#grve-second-menu.grve-vertical-menu > .grve-menu'),
					$secondMenuItem = $secondMenu.children(),
					$rightItems = $rightArea.children();
				if( $bottomArea.length ) {
					if( $bottomItems.length ) {
						items.push( $bottomItems );
					} else {
						items.push( $bottomArea );
					}
				}

				if( $rightArea.length ) {
					if( $rightItems.length ) {
						$rightItems.each(function(){
							if( $(this).hasClass('grve-vertical-menu-wrapper') ) {
								$secondMenuItem.each(function(){
									items.push( $(this).find('> .grve-link-wrapper') );
								});
							} else {
								items.push( $(this) );
							}
						});
					} else {
						items.push( $rightArea );
					}
				}

				return items;
			},
			open: function( $area, areaName ){
				if( $area.data('header-visibility') == true ) {
					var $activeHeader = GRVE.headerSettings.mainHeader.getHeader();
					$activeHeader.addClass('grve-header-visible');
					var top = ($activeHeader.offset().top + $activeHeader.outerHeight()) - $window.scrollTop(),
						$scroller = $area.find('.grve-area-scroller');

					$scroller.css({
						'margin-top' : top,
						'height' : 'calc(100% - ' + top + 'px)'
					});
					GRVE.headerSettings.mainHeader.changeSkin( $area.data('header-skin') );
					GRVE.headerSettings.toggleHiddenArea.setHeaderSpace();
				}
				$body.addClass('grve-'+ areaName +'-open');
				$('html').addClass('grve-stop-scrolling');
			},
			close: function( $area, areaName ){
				if( $area.data('header-visibility') == true ) {
					var $activeHeader = GRVE.headerSettings.mainHeader.getHeader();
					$activeHeader.removeClass('grve-header-visible');
					GRVE.headerSettings.mainHeader.changeSkin( $activeHeader.data('header-skin') );
					GRVE.headerSettings.toggleHiddenArea.resetHeaderSpace();
				}
				var $menu = $area.find('.grve-vertical-menu'),
					$content = $area.find('.grve-content');

				$content.css('visibility','');
				GRVE.headerSettings.verticalMenu.reset( $menu );
				$body.removeClass('grve-'+ areaName +'-open');
				$('html').removeClass('grve-stop-scrolling');
				$window.trigger('grve_'+ areaName +'_close'); // Trigger event
			},
			getAnimationType: function( animation ){
				var param = {
					opacity: 1,
					x: 0,
					y: 0
				};
				if( $body.hasClass('rtl') ) {
					switch (animation) {
						case 'fade-in':
							param.opacity = 0;
							break;
						case 'left-to-right':
							param.x = '100%';
							param.opacity = 0;
							break;
						case 'right-to-left':
							param.x = '-100%';
							param.opacity = 0;
							break;
						case 'top-to-bottom':
							param.y = '-100%';
							param.opacity = 0;
							break;
						case 'bottom-to-top':
							param.y = '100%';
							param.opacity = 0;
							break;
					}
				} else {
					switch (animation) {
						case 'fade-in':
							param.opacity = 0;
							break;
						case 'left-to-right':
							param.x = '-100%';
							param.opacity = 0;
							break;
						case 'right-to-left':
							param.x = '100%';
							param.opacity = 0;
							break;
						case 'top-to-bottom':
							param.y = '-100%';
							param.opacity = 0;
							break;
						case 'bottom-to-top':
							param.y = '100%';
							param.opacity = 0;
							break;
					}
				}

				return param;
			},
			setHeaderSpace: function(){
				var $activeHeader = GRVE.headerSettings.mainHeader.getHeader(),
					overlappingClass = $activeHeader.is('#grve-main-responsive-header') ? 'grve-responsive-header-overlapping' : 'grve-header-overlapping';
				if ( !$activeHeader.hasClass('grve-fixed') && !$body.hasClass(overlappingClass) ) {
					var headerH = $activeHeader.outerHeight();
					$('#grve-header').css({ 'padding-bottom' : headerH });
				}
			},
			resetHeaderSpace: function(){
				$('#grve-header').css({ 'padding-bottom' : '' });
			}
		},
		responsiveMenu: {
			init: function(){
				GRVE.headerSettings.toggleHiddenArea.init('#grve-responsive-menu-area', '.grve-toggle-responsive-menu', 'responsivemenu');
			}
		},
		offcanvasMenu: {
			init: function(){
				GRVE.headerSettings.toggleHiddenArea.init('#grve-offcanvas-area', '.grve-toggle-offcanvas', 'offcanvas');
			}
		},
		slidingArea: {
			init: function(){
				GRVE.headerSettings.toggleHiddenArea.init('#grve-side-area', '.grve-toggle-side-area', 'side-area');
			}
		},
		safeButton: {
			init: function(){
				var base = this,
					$btn = $('.grve-toggle-safebutton-area'),
					$area = $('#grve-safebutton-area'),
					$closeBtn = $area.find('.grve-close-btn'),
					$areaWrapper = $area.find('.grve-safebutton-wrapper'),
					areaOpen = false;
				base.scrollTarget = null;
				base.scrollPosition = 0;

				if( $area.length ) {
					var $overlay = $('#grve-safebutton-overlay'),
						timeline = gsap.timeline({
							paused:true,
							onStart: function(){
								$btn.parent().addClass('grve-close');
							},
							onComplete: function(){
								base.open( $area );
							},
							onReverseComplete: function(){
								base.close( $area );
							}
						});

					timeline.set($overlay, { display: 'block' });
					timeline.from($overlay, { duration:0.6, x:'-100%', ease:'power1.out', onComplete:base.toggleMainContent });
					timeline.set($area, { display: 'block', onComplete:base.setAreaScrollPosition, onReverseComplete:base.setPageScrollPosition });
					timeline.to($overlay, { duration:0.6, x:'100%', ease:'power1.out', onReverseComplete:base.toggleMainContent });
					timeline.from($areaWrapper, { duration:0.6, opacity:0, ease:'power1.out', },'-=0.3');
				}

				$btn.on('click',function( event ){
					event.preventDefault();
					var $that = $(this);
					if( $area.length && !areaOpen ) {
						areaOpen = true;
						timeline.play();
						base.scrollPosition = $window.scrollTop();;
					} else if( $area.length && areaOpen ) {
						areaOpen = false;
						timeline.reverse();
						$that.parent().removeClass('grve-close');
					}
				});

				$closeBtn.on('click',function( event ) {
					event.preventDefault();
					areaOpen = false;
					timeline.reverse();
				});

				$document.on('keyup',function(evt) {
					if ($area.length && evt.keyCode == 27 && areaOpen ) {
						areaOpen = false;
						timeline.reverse();
					}
				});

				$area.on('click', '.grve-menu-element a', function( event ){
					var target = $(this).attr('href').split('#').pop();
					if( $('#' + target).length ) {
						event.preventDefault();
						base.scrollTarget = $('#' + target);
						$btn.trigger('click');
					}
				});

			},
			open: function( $area ){
				var base = this;
				$window.trigger('grve_safebutton_open'); // Trigger event
				$body.addClass('grve-safebutton-open');
			},
			close: function( $area ){
				var base = this;
				$window.trigger('grve_safebutton_close'); // Trigger event
				$body.removeClass('grve-safebutton-open');
				if( null !== base.scrollTarget ) {
					GRVE.helpers.smoothScrollTo( base.scrollTarget );
					base.scrollTarget = null;
				}
				// Yoututbe Video
				var $youtubeFrame = $area.find($('iframe[src*="youtube"]') );
				$youtubeFrame.each(function(){
					base.stopYoutubeVideo( this );
				});
			},
			setAreaScrollPosition: function(){
				$('html, body').scrollTop(0);
			},
			setPageScrollPosition: function(){
				var base = GRVE.headerSettings.safeButton;
				$('html, body').scrollTop( base.scrollPosition );
			},
			toggleMainContent: function(){
				var elements = {
						topBar: '#grve-top-bar',
						header: '#grve-header',
						feature: '#grve-feature-section',
						content: '#grve-theme-content',
						footer: '#grve-footer'
					};
				$body.toggleClass('grve-safebutton-ready');
				$('html').toggleClass('grve-safebutton-ready');
				$.each(elements, function(){
					$(this).toggle();
				});
				if( $body.hasClass('grve-safebutton-open') ) {
					$window.trigger('grve_safebutton_before_close'); // Trigger event
				}
			},
			stopYoutubeVideo: function( video ){
				$(video).attr('src', $(video).attr('src'));
				return false;
			}
		},
		anchorMenu: {
			init: function( headerSticky ){
				var $anchorDropdown = $('.grve-anchor-dropdown');
				$anchorDropdown.on( 'change', function() {
					var value = $(this).find( "option:selected" ).val();
					$('.grve-anchor-menu .menu-item-' + value + ' a')[0].click();
				});
			},
			sticky: function( headerSticky ){
				if( $anchorMenu.length ) {
					var $activeHeader = GRVE.headerSettings.mainHeader.getHeader();
					if( !headerSticky && $anchorMenu.offset().top > $activeHeader.outerHeight() && ('scrollup' === stickyType || 'shrink' === stickyType) ) {
						return;
					}
					$anchorMenu.stick_in_parent({
						parent: '#grve-theme-content',
						bottoming: false,
						inner_scrolling: false,
						offset_top: GRVE.headerSettings.mainHeader.getHeaderHeight()
					});
				}
			}
		},
		languageDropdown: function(){
			var $language = $('.grve-language.grve-dropdown');
			$language.superfish({
				popUpSelector: 'ul',
				delay: 800,
				speed: 300,
				cssArrows: false,
				hoverClass: 'grve-hover',
				speedOut: 100,
				animation: false,
				animationOut: false
			});
		},
		miniCart: function(){
			var $btn = $('.grve-toggle-minicart'),
				$cart = $('#grve-cart-area'),
				open = false;
			if( $cart.length ) {
				var timeline = gsap.timeline({
					paused: true,
					onComplete: function(){
						open = true;
					},
					onReverseComplete: function(){
						open = false;
					}
				});
				timeline.set($cart, {display: 'block'});
				timeline.to($cart, {opacity: 1, duration:0.5, ease: 'power3.inOut'});

				$btn.on('click',function( event ){
					event.preventDefault();
					if( timeline.progress() == 0 ){
						timeline.play();
					} else {
						timeline.reverse();
					}
				});
			}
			$document.on('click', function(event) {
				if ( !$(event.target).closest('#grve-cart-area').length && open ) {
					timeline.reverse();
				}
			});
		}
	};

	GRVE.feature = {
		init: function(){
			this.settings.init();
			this.classicSlider.init();
			this.advancedSlider1.init();
			this.advancedSlider2.init();
			this.advancedSlider3.init();
			this.advancedSlider4.init();
			this.parallax.init();
		},
		onScroll: function(){
			this.parallax.onScroll();
		},
		onResize: function(){},
		settings: {
			selectors: '#grve-feature-section, .grve-title-section',
			init: function(){
				this.checkAnimation();
				this.gotoFirstSection();
			},
			checkAnimation: function(){
				var base = this;
				$(base.selectors).each(function(){
					var $that = $(this),
						$content = $that.find('.grve-content');
					$content.each(function(){
						var $that = $(this),
							animation = $that.data('animation'),
							$wrapper = $that.find('.grve-title-content-wrapper'),
							$items = $wrapper.children();
						if( animation === 'appear-up' || animation === 'appear-down' || animation === 'appear-left' || animation === 'appear-right' ) {
							setAppearWrappers( $that );
						} else {
							if( $wrapper.hasClass('grve-bg-none') ) {
								$items.each(function(){
									var $item = $(this);
									$item.addClass('grve-title-animation-item');
								});
							} else {
								$wrapper.addClass('grve-title-animation-item');
							}
						}
					});

					$window.on('grve_after_page_transition',function(){
						base.animation( $that );
					});
				});

				function setAppearWrappers( $section ){
					var $wrapper = $section.find('.grve-title-content-wrapper'),
						wrapper = '<div class="grve-appear-wrapper grve-animation-wrapper"><div class="grve-appear-content grve-title-animation-item"></div></div>',
						$items = $wrapper.children();

					if( $wrapper.hasClass('grve-bg-none') ) {
						$items.each(function(){
							var $that = $(this);
							if( $that.hasClass('grve-button-wrapper') ) {
								var $button = $that.find('.grve-btn');
								$button.each(function(){
									$(this).wrap( wrapper );
								});
							} else {
								$that.wrapInner( wrapper );
							}
						});
					} else {
						$wrapper.wrap( wrapper );
					}
				}
			},
			animation: function( $section ){
				if( $section.hasClass('grve-with-slider') ) return;
				var $content = $section.find('.grve-content'),
					animation = $content.data('animation'),
					$items = $content.find('.grve-title-animation-item'),
					elements = $.makeArray( $items );

				if( elements.length ) {
					$section.find('.grve-content').addClass('show'); // Show Content
					var params = $.extend(GRVE.pageSettings.basicAnimations.getAnimParams( animation, 'normal' ), {force3D: true, ease:'easeOutCubic', stagger: 0.3}),
						anim = gsap.timeline({delay:0.3, onComplete: callback});
					if( animation === 'appear-up' || animation === 'appear-down' || animation === 'appear-left' || animation === 'appear-right' ) {
						anim
						.set(elements,{visibility:'visible'})
						.fromTo(elements, params, {x:'0%', y:'0%', stagger: 0.3});
					} else {
						anim
						.set(elements,{visibility:'visible'})
						.fromTo(elements, params, {opacity:1, x:0, y:0, scale:1, stagger: 0.3});
					}
					function callback(){
						$.each(elements,function(){
							$(this).parent().css('overflow','visible');
						});
					};
				}
			},
			gotoFirstSection: function(){
				var $selector    = $('#grve-feature-section .grve-goto-first-section'),
					$nextSection = $('#grve-content');

				$selector.on('click',function(){
					$('html,body').animate({
						scrollTop: $nextSection.offset().top
					}, 1000);
					return false;
				});
			}
		},
		classicSlider: {
			init: function(){
				if( $featureSlider.length ) {

					var $navigation    = $featureSlider.parent().find('.grve-carousel-navigation'),
						slidersLength  = $featureSlider.find('.grve-slider-item').length,
						$nextBtn       = $navigation.find('.grve-carousel-next'),
						$prevBtn       = $navigation.find('.grve-carousel-prev'),
						$progressBar   = $navigation.find('.grve-slider-bar'),
						$currentNum    = $navigation.find('.grve-current-slide .grve-counter'),
						itemsArr       = ['.grve-page-nav', '.grve-safebutton-icon-wrapper'],
						pauseHover     = $featureSlider.attr('data-slider-pause') == 'yes' ? true : '',
						sliderSpeed    = parseInt( $featureSlider.attr('data-slider-speed') ) ? parseInt( $featureSlider.attr('data-slider-speed') ) : 6000,
						fadeTransition = $featureSlider.data('slider-transition') == 'fade' ? true : false;


					$featureSlider.flickity({
						cellAlign: 'left',
						contain: true,
						wrapAround: true,
						fade: fadeTransition,
						prevNextButtons: false,
						pageDots: false,
						autoPlay: sliderSpeed,
						pauseAutoPlayOnHover: pauseHover,
						on: {
							ready: function() {
								setProgress();
								setTimeout(function(){
									onChangeSlider( 0 );
								},600);

								createBullets();
							},
							change: function( index ) {
								onChangeSlider( index );
							},
						}
					});

					function onChangeSlider( index ){
						var $currentSlide = $featureSlider.find('.grve-slider-item').eq(index),
							sliderColor = $currentSlide.attr('data-header-color'),
							scroll = $window.scrollTop(),
							sliderHeight = parseInt( $featureSlider.outerHeight() ),
							sliderTop =  parseInt( $featureSlider.offset().top ),
							sliderBottom = sliderTop + sliderHeight;

							// Slider Animation
							GRVE.feature.settings.animation( $currentSlide );

							activeDot( index );
							updateCnt( index );

							// Set Header Color
							if( $body.hasClass('grve-header-overlapping') && !$('#grve-main-header').hasClass('grve-skin-sticky') && !$('#grve-main-header').hasClass('grve-skin-changed') ) {
								$mainHeader.data('header-skin', sliderColor);
								GRVE.headerSettings.mainHeader.changeSkin( sliderColor );
							}

							// Change Page Scroll - Safe Button
							$.each( itemsArr, function(){
								var $item = $(this);
								if( $item.length ) {
									var itemHeight = parseInt( $item.outerHeight() ),
										itemTop = parseInt( $item[0].getBoundingClientRect().top ),
										itemMiddle = itemTop + itemHeight / 2;

									if( scroll >= sliderTop - itemMiddle && scroll <= sliderBottom - itemMiddle ) {
										GRVE.pageSettings.sectionColor.changeSkin( $item, sliderColor );
									}
								}
							});

							// Set Navigation Color
							$navigation.removeClass('grve-skin-light grve-skin-dark grve-skin-default').addClass( 'grve-skin-' + sliderColor );
					}

					// Create Bullets
					function createBullets(){
						var $bullets = $featureSlider.parent().find('.flickity-page-dots');
						if( $bullets.length ) {
							for (var i = 0; i < slidersLength; ++i) {
								$('<li class="dot"></li>').appendTo( $bullets );
							}
							$bullets.on( 'click', '.dot', function() {
								var $that = $(this),
									index = $that.index();
								$featureSlider.flickity( 'selectCell', index );
								activeDot( index );
							});
						}
					}

					function activeDot( index ){
						var $bullets = $featureSlider.parent().find('.flickity-page-dots');
						if( $bullets.length ) {
							var $activeDot = $bullets.children().eq(index);
							$activeDot.addClass('is-selected').siblings().removeClass('is-selected');
						}
					}

					function setProgress(){
						var totalNumber = slidersLength < 9 ? '0' + slidersLength : slidersLength,
							$totalNum = $navigation.find('.grve-total-slide');
						for (var i = 0; i < slidersLength; ++i) {
							var cnt = i + 1,
								num = cnt <= 9 ? '0' + cnt : cnt,
								$number = '<span>' + num + '</span>';
							$currentNum.append( $number );
						}
						$totalNum.text( totalNumber );
						updateCnt(0);
					}

					function updateCnt(index){
						var posY = -((index % 10) * 30) + "px",
							size = ((index + 1) * 100) / (slidersLength);
						$currentNum.css({
							'transform': 'translateY(' + posY + ')'
						});
						$progressBar.css('width', size + '%');
					}

					// next
					$nextBtn.on( 'click', function() {
						$featureSlider.flickity('stopPlayer');
						$featureSlider.flickity('next');
					});
					// pren
					$prevBtn.on( 'click', function() {
						$featureSlider.flickity('stopPlayer');
						$featureSlider.flickity('previous');
					});
				}
			}
		},
		advancedSlider1: {
			init: function(){
				var $wrapper = $('#grve-feature-section.grve-advanced-slider.grve-style-1'),
					$slider = $wrapper.find('.grve-slider');
				if( $slider.length ) {
					$slider.flickity({
						cellAlign: 'left',
						contain: true,
						wrapAround: true,
						prevNextButtons: false,
						pageDots: true,
						bgLazyLoad: true,
						on: {
							ready: function() {
								$wrapper.css('visibility','visible');
							}
						}
					});
				}
			}
		},
		advancedSlider2: {
			init: function(){
				var $wrapper = $('#grve-feature-section.grve-advanced-slider.grve-style-2'),
					$slider = $wrapper.find('.grve-slider'),
					$nextBtn = $wrapper.find('.grve-next-btn'),
					$image = $slider.find('.grve-feature-image');
				if( $slider.length ) {

					$slider.flickity({
						cellAlign: 'left',
						contain: true,
						wrapAround: true,
						prevNextButtons: false,
						pageDots: false,
						bgLazyLoad: 1,
						on: {
							ready: function() {
								cloneContent();
								setTimeout(function(){
									setActive(0);
								},600);
								$wrapper.css('visibility','visible');
							},
							change: function( index ) {
								setActive( index );
							},
						}
					});

				}

				// next
				$nextBtn.on( 'click', function() {
					$slider.flickity('next');
				});

				function cloneContent() {
					var $slideContent = $slider.find('.grve-content');
					$slideContent.each(function(){
						var $that = $(this),
							$elements = $that.children().clone(),
							$content = $('<div class="grve-item-content"></div>');
						$content.appendTo( $slider.parent().find('.grve-slider-contents') );
						$elements.appendTo( $content );
					});
				}

				function setActive( index ) {
					var $content = $slider.parent().find('.grve-item-content').eq( index );
					$content.addClass('grve-current').siblings().removeClass('grve-current');
				}
			}
		},
		advancedSlider3: {
			init: function(){
				var $wrapper = $('#grve-feature-section.grve-advanced-slider.grve-style-3'),
					$slider = $wrapper.find('.grve-slider'),
					$nextBtn = $wrapper.find('.grve-next-btn'),
					$prevBtn = $wrapper.find('.grve-prev-btn');
				if( $slider.length ) {

					$slider.flickity({
						cellAlign: 'center',
						contain: true,
						wrapAround: true,
						prevNextButtons: false,
						pageDots: true,
						bgLazyLoad: 1,
						on: {
							ready: function() {
								cloneContent();
								setTimeout(function(){
									setActive(0);
									$wrapper.css('visibility','visible');
								},600);
							},
							change: function( index ) {
								setActive( index );
							},
							dragStart: function() {
								if( !$(this.element).parent().hasClass('grve-is-scroll') ) {
									$(this.element).parent().addClass('grve-is-scroll');
								}
							},
							settle: function(){
								$(this.element).parent().removeClass('grve-is-scroll');
							}
						}
					});

				}

				// next
				$nextBtn.on( 'click', function() {
					$slider.flickity('next');
					$(this).parent().addClass('grve-is-scroll');
				});
				// next
				$prevBtn.on( 'click', function() {
					$slider.flickity('previous');
					$(this).parent().addClass('grve-is-scroll');
				});

				function cloneContent() {
					var $slideContent = $slider.find('.grve-content');
					$slideContent.each(function(){
						var $that = $(this),
							$elements = $that.children().clone(),
							$content = $('<div class="grve-item-content"></div>');
						$content.appendTo( $slider.parent().find('.grve-slider-contents') );
						$elements.appendTo( $content );
					});
				}

				function setActive( index ) {
					var $content = $slider.parent().find('.grve-item-content').eq( index );
					$content.addClass('grve-current').siblings().removeClass('grve-current');
				}
			}
		},
		advancedSlider4: {
			init: function(){
				var $wrapper = $('#grve-feature-section.grve-advanced-slider.grve-style-4'),
					$slider = $wrapper.find('.grve-slider'),
					$progressBar = $wrapper.find('.grve-slider-bar'),
					totalL = $wrapper.find('.grve-slider-item').length,
					totalNumber = totalL < 9 ? '0' + totalL : totalL,
					$currentNum = $wrapper.find('.grve-current-slide .grve-counter'),
					$totalNum = $wrapper.find('.grve-total-slide'),
					$nextBtn = $wrapper.find('.grve-next-btn');
				if( $slider.length ) {

					$slider.flickity({
						cellAlign: 'left',
						contain: true,
						wrapAround: true,
						prevNextButtons: false,
						pageDots: true,
						bgLazyLoad: 1,
						on: {
							ready: function() {
								cloneContent();
								setTimeout(function(){
									setProgress(0);
									setActive(0);
									$wrapper.css('visibility','visible');
								},600);
							},
							change: function( index ) {
								setActive( index );
								setProgress( index );
								updateCnt( index );
							}
						}
					});
				}

				$totalNum.text( totalNumber );

				// next
				$nextBtn.on( 'click', function() {
					$slider.flickity('next');
				});

				function setProgress( index ) {
					var size = ((index + 1) * 100) / (totalL);
					$progressBar.css('width', size + '%');
				}

				function updateCnt(index){
					var posY = -((index % 10) * 30) + "px";
					$currentNum.css({
						'transform': 'translateY(' + posY + ')'
					});
				}

				function cloneContent() {
					var $slideContent = $slider.find('.grve-content');
					$slideContent.each(function(){
						var $that = $(this),
							$elements = $that.children().clone(),
							$content = $('<div class="grve-item-content"></div>');
						$content.appendTo( $slider.parent().find('.grve-slider-contents') );
						$elements.appendTo( $content );
					});
				}

				function setActive( index ) {
					var $content = $slider.parent().find('.grve-item-content').eq( index );
					$content.addClass('grve-current').siblings().removeClass('grve-current');
				}

				for (var i = 0; i < totalNumber; ++i) {
					var cnt = i + 1,
						num = cnt <= 9 ? '0' + cnt : cnt,
						$number = '<span>' + num + '</span>';
					$currentNum.append( $number );
				}
			}
		},
		parallax: {
			init: function(){
				var base = this;
				if( $featureSection.length && (
					$featureSection.hasClass('grve-bg-parallax') ||
					$featureSection.hasClass('grve-bg-advanced-parallax') ||
					$featureSection.hasClass('grve-bg-fixed-section') )
				) {
					var parallaxType;

					if( $featureSection.hasClass('grve-bg-advanced-parallax') ){
						parallaxType = 'advanced';
					} else if( $featureSection.hasClass('grve-bg-fixed-section') ){
						parallaxType = 'fixed';
					} else {
						parallaxType = 'classic';
					}

					$featureSection.data('paralax-type', parallaxType);

					// Create Parallax Wrapper
					$featureSection.children().wrapAll('<div class="grve-feature-inner"><div class="grve-parallax-wrapper"></div></div>');

					base.updateParallax( $featureSection );
				}
			},
			updateParallax: function( $section ){
				var parallaxType = $section.data('paralax-type'),
					$wrapper     = $section.find('.grve-parallax-wrapper'),
					scrollTop    = $( window ).scrollTop(),
					sectionTop   = $section.offset().top,
					sectionW     = $section.outerWidth(),
					sectionH     = $section.outerHeight(),
					position     = scrollTop * 0.2,
					elementH     = sectionH + sectionTop,
					scale        = ( ( ( sectionH + sectionTop ) + scrollTop ) / sectionH );

				if( parallaxType == 'advanced' && !GRVE.helpers.isMobile.any() ) {
					$wrapper.css({
						'position' : 'fixed',
						'top' : sectionTop,
						'height' : elementH,
						'width' : sectionW,
						transform: 'translate3d( 0px' + ', ' + -position + 'px' + ', 0px)',
						visibility: 'visible'
					});
				} else if( parallaxType == 'fixed' ) {
					$wrapper.css({
						'position' : 'fixed',
						'top' : sectionTop,
						'height' : elementH,
						'width' : sectionW,
						visibility: 'visible'
					});
				} else {
					$wrapper.css({
						'position' : 'relative',
						'height' : elementH,
						'width' : sectionW,
						transform: 'translate3d( 0px' + ', ' + position + 'px' + ', 0px)',
						visibility: 'visible'
					});
				}

				featureParallax = false;

			},
			onScroll: function(){
				var base = this;
				if( $featureSection.length &&
					GRVE.helpers.inViewport( $featureSection ) && (
					$featureSection.hasClass('grve-bg-parallax') ||
					$featureSection.hasClass('grve-bg-advanced-parallax') ||
					$featureSection.hasClass('grve-bg-fixed-section') )
				) {
					if( window.requestAnimationFrame ) {
						if(!featureParallax){
							featureParallax = true;
							window.requestAnimationFrame(function(){
								base.updateParallax( $featureSection );
							});
						}
					} else {
						if(!featureParallax){
							featureParallax = true;
							base.updateParallax( $featureSection );
						}
					}
				}
			}
		}
	};

	GRVE.pageSettings = {
		init: function(){
			this.parallaxBg.init();
			this.skinScrollEffect.init();
			this.skinScrollEffectElementor.init();
			this.basicAnimations.init();
			this.basics.init();
			this.sectionNav.init();
			this.sectionColor.init();
			this.socialBar.init();
			this.floatingNavBar.init();
			this.minimalNavBar.init();
			this.smallBlog.init();
			this.videos.init();
			this.listTitleGrid.init();
			this.isotope.init();
			this.hoverEffects.init();
			this.carouselElements.init();
			this.basics.lightGallery();
			this.scrollingPage.init();
			this.stickyElements.init();
			this.onePage.init();
			this.wooCommerce.init();
			this.parallaxCol.init();
			this.mouseMoveCol.init();
			this.offcanvasMorphBtn.init();
		},
		onScroll: function(){
			this.parallaxBg.onScroll();
			this.skinScrollEffect.onScroll();
			this.skinScrollEffectElementor.onScroll();
			this.sectionNav.onScroll();
			this.sectionColor.onScroll();
			this.socialBar.onScroll();
			this.floatingNavBar.onScroll();
			this.basics.backToTop();
			this.onePage.onePageMenu();
			this.parallaxCol.onScroll();
			this.offcanvasMorphBtn.onScroll();
		},
		onResize: function(){
			this.parallaxBg.onResize();
			this.skinScrollEffect.onResize();
			this.skinScrollEffectElementor.onResize();
			this.sectionNav.onResize();
			this.sectionColor.onResize();
			this.videos.resizeVideoBg();
			this.isotope.relayout();
			this.stickyElements.checkDevice();
			this.floatingNavBar.onResize();
			this.minimalNavBar.onResize();
			this.smallBlog.onResize();
			this.wooCommerce.onResize();
			this.basics.alignFull();
			this.parallaxCol.onResize();
		},
		parallaxCol: {
			init: function(){
				var base = this;
				base.sections = $.makeArray( $('[data-parallax-effect="vertical-parallax"]') );
				base.onResize();
			},
			onScroll: function(){
				var base = this,
					scroll = $window.scrollTop(),
					windowH = $window.height();

				$.each( base.sections, function(index,item){
					var $parallaxItem = $(item).children(),
						itemT = base.properties[index].top,
						sectionT = base.properties[index].sectionT,
						sectionH = base.properties[index].sectionH,
						itemDist = base.properties[index].scrolldis,
						distance = itemT - sectionT,
						speed = ( windowH + sectionH ) / itemDist,
						position = parseInt( ((scroll + windowH - sectionT) / speed) - distance );

					if( base.checkDevice(item) ) {
						gsap.to($parallaxItem, { duration: 0, y: position, force3D: false });
					}
				});

			},
			onResize: function(){
				var base = this;
				base.properties = [];
				$.each( base.sections, function(index,item){
					var $item = $(item),
						$parallaxItem = $item.children();
					$parallaxItem.css('transform','');
					var $section = $item.parents('.grve-section'),
						sectionH = $section.outerHeight(),
						sectionT = parseInt( $section.offset().top ),
						itemH = $parallaxItem.outerHeight(),
						top = parseInt( $parallaxItem.offset().top ),
						bottom = parseInt( sectionH + top ),
						scrolldis = sectionH - itemH,
						prop = {
							sectionH: sectionH,
							sectionT: sectionT,
							sectionH: sectionH,
							top: top,
							scrolldis: scrolldis,
						};
					base.properties.push( prop );
				});
				base.onScroll();
			},
			checkDevice: function(item){
				var parallax = true,
					windowW = $window.width(),
					$item = $(item);
				if ( windowW > tabletPortrait && windowW <= tabletLandscape && $item.data('tablet-landscape-parallax-effect') === 'none' ) {
					parallax = false;
				} else if ( windowW > mobileScreen && windowW <= tabletPortrait && $item.data('tablet-portrait-parallax-effect') === 'none' ) {
					parallax = false;
				} else if ( windowW <= mobileScreen  && $item.data('mobile-parallax-effect') === 'none' ) {
					parallax = false;
				}
				return parallax;
			}
		},
		mouseMoveCol: {
			init: function(){
				var base = this;
				base.updateParams();
			},
			updateParams: function( $nav ){
				var base = this,
					$parallaxItem = $('[data-parallax-effect="mouse-move"]');
				if( $parallaxItem.length ) {
					$window.on('mousemove', function( event ){
						var clientX = event.clientX,
							clientY = event.clientY,
							windowW = $window.width();

						if( windowW <= tabletLandscape ){
							$parallaxItem.removeAttr('style');
							return false;
						}
						$parallaxItem.each(function(){
							var $element = $(this),
								elementBounds = this.getBoundingClientRect(),
								elementX = elementBounds.left,
								elementY = elementBounds.top,
								elementH = $element.outerHeight(),
								elementW = $element.outerWidth(),
								elementCenterX = elementW * 0.5,
								elementCenterY = elementH * 0.5,
								elementRangeX = Math.max(elementCenterX, elementW - elementCenterX),
								elementRangeY = Math.max(elementCenterY, elementH - elementCenterY),
								inputX = (clientX - elementX - elementCenterX) / elementRangeX,
								inputY = (clientY - elementY - elementCenterY) / elementRangeY,
								mouseMove = $element.data('mouse-move'),
								motionX = mouseMove == 'y' ? 0 : inputX,
								motionY = mouseMove == 'x' ? 0 : inputY,
								sensitive = $element.data('sensitive'),
								invert = $element.data('invert');

							motionX *= elementW * (sensitive / 100) * (invert ? -1 : 1);
							motionY *= elementH * (sensitive / 100) * (invert ? -1 : 1);

							gsap.to(this, {
								x: motionX,
								y: motionY,
								duration: 1,
								ease: 'power3.out'
							});
						});
					});
				}
			}
		},
		parallaxBg: {
			init: function(){
				var base = this;
				base.sections = $.makeArray( $('.grve-bg-parallax') );
				base.onResize();
				base.onScroll();
			},
			onScroll: function(){
				var base = this,
					scroll = $window.scrollTop(),
					windowH = $window.height();
				$.each( base.sections, function(index,item){
					var $item = $(item),
						$parallaxItem = $item.find('.grve-background-wrapper').children(),
						distance = base.properties[index].top - scroll - windowH,
						speed = ( windowH + base.properties[index].itemH ) / base.properties[index].scrolldis,
						position = parseInt(distance / speed);
					if( scroll + windowH > base.properties[index].top - 200 && scroll < base.properties[index].bottom + 200 ) {
						if( 'normal' === base.properties[index].type ) {
							gsap.to($parallaxItem, { duration: 0.1, y: position, force3D: false });
						} else if( 'left-right' === base.properties[index].type ){
							gsap.to($parallaxItem, { duration: 0.1, x: -(base.properties[index].scrolldis + position), force3D: false });
						} else {
							gsap.to($parallaxItem, { duration: 0.1, x: position, force3D: false });
						}
					}
				});
			},
			onResize: function(){
				var base = this;
				base.properties = [];
				$.each( base.sections, function(index,item){
					var $item = $(item),
						$wrapper = $item.find('.grve-background-wrapper'),
						$parallaxItem = $wrapper.children(),
						thres = $item.data('parallax-threshold'),
						itemW = $wrapper.outerWidth(),
						itemH = $wrapper.outerHeight(),
						top = parseInt( $item.offset().top ),
						bottom = parseInt( itemH + top ),
						scrolldis = parseInt( itemH * thres ),
						type = $item.hasClass('grve-horizontal-parallax-lr') ? 'left-right' : $item.hasClass('grve-horizontal-parallax-rl') ? 'right-left' : 'normal',
						prop = {
							itemH: itemH,
							top: top,
							bottom: bottom,
							scrolldis: scrolldis,
							type: type
						};
					base.properties.push( prop );
					if( 'normal' === type ) {
						$parallaxItem.css({ 'height': itemH + scrolldis });
					} else {
						$parallaxItem.css({ 'width': itemW + scrolldis });
					}

				});
				base.onScroll();
			}
		},
		offcanvasMorphBtn: {
			btn: '.grve-offcanvas-icon-wrapper.grve-fixed',
			smallBtn: false,
			hasScroll: false,
			init: function(){
				var base = this;
				if( $(base.btn).length ) {
					$window.on('mousemove', function(e){
   						var lSide = $(this).width() - ($(this).width()/3);
   						if( $body.hasClass('grve-offcanvas-open') ) {
   							return;
   						}
   						if( e.pageX > lSide && base.smallBtn && base.hasScroll) {
	   						$(base.btn).removeClass('grve-small');
	   						base.smallBtn = false;
   						} else if( e.pageX <= lSide && !base.smallBtn && base.hasScroll) {
   							$(base.btn).addClass('grve-small');
	   						base.smallBtn = true;
   						}
   					});
				}
			},
			onScroll: function(){
				if( $(this.btn).length ) {
					var scroll = $window.scrollTop();
					if( scroll > 100 && !this.hasScroll ) {
						this.smallBtn = true;
						this.hasScroll = true;
						$(this.btn).addClass('grve-small');
					} else if( scroll <= 100 && this.hasScroll ) {
						this.smallBtn = false;
						this.hasScroll = false;
						$(this.btn).removeClass('grve-small');
					}
				}
			}
		},
		basics: {
			init: function(){
				var base = this;
				base.pageIntro();
				base.sectionSidebar();
				base.alignFull();
				base.changeOrder();
				base.grveModal();
				base.lightBox();
				base.quickView();
				base.socialShareLinks();
				base.stickySidebar();
				base.textInputEffect();
				base.goToTop();
				base.animatedBg();
				base.fixedFooter();
				base.splitTitle();
				base.svgCustom();
			},
			pageIntro: function(){
				var $intro = $('#grve-intro');
				if( !$intro.length ){
					GRVE.pageSettings.basics.bodyLoader();
					return;
				} else {
					var cookieExpiration = impeka_grve_main_data.intro_reset_duration ? impeka_grve_main_data.intro_reset_duration : '',
						introAppearance = impeka_grve_main_data.intro_appearance ? impeka_grve_main_data.intro_appearance : 'always';
					if ( 'once' == introAppearance && ( '0' != cookieExpiration || '' != cookieExpiration ) ) {
						var	theDate = new Date(),
							later = new Date( theDate.getTime() + cookieExpiration*24*60*60*1000 ),
							cookieName = 'grve-intro';
						if ( document.cookie.indexOf( cookieName ) < 0 ) {
							document.cookie = cookieName +  '=true; SameSite=Lax; Path=/; Expires='+later.toGMTString()+';';
						}
					}
				}
				if( $('#grve-loader-overflow').length ) {
					$('#grve-loader-overflow').addClass('grve-hide');
				}
				var $graphic = $intro.find('.grve-intro-graphic'),
					$firstTitle = $intro.find('.grve-first-title'),
					$secondTitle = $intro.find('.grve-second-title'),
					$content = $intro.find('.grve-intro-content'),
					timeline = gsap.timeline({onComplete: completeIntro});

				$('html').addClass('grve-stop-scrolling');

				if( $graphic.length ) {
					timeline.to($graphic, { duration:0.8, force3D: true, y:0, opacity: 1, ease:'power1.out' });
				}

				if( $firstTitle.length ) {
					var textArr = $firstTitle.text();
					$firstTitle.data('text',textArr);
					var textArr = textArr.trim(),
						textArr = textArr.split(' ');
					$firstTitle[0].innerHTML = '';
					for (var i = 0; i < textArr.length; i++) {
						$firstTitle[0].innerHTML += '<span class="grve-word"><span>' + textArr[i] + '</span></span> ';
					}
					var elements = $.makeArray( $firstTitle.find('.grve-word > span') );
					timeline.set($firstTitle, { visibility: 'visible' });
					timeline.to(elements, { duration:0.6, force3D: true, y:0, ease:'power1.out', stagger: 0.1 });
				}
				if( $secondTitle.length ) {
					timeline.set({}, {}, '+=1');
					if( $graphic.length ) {
						timeline.to($graphic, { duration:0.8, force3D: true, opacity: 0, ease:'power1.out' });
					}
					if( $firstTitle.length ) {
						timeline.to($firstTitle, { duration:0.8, force3D: true, opacity: 0, ease:'power1.out' },'<0.1');
					}
					timeline.to($secondTitle, { duration:1, force3D: true, opacity: 1, ease:'power1.out' });
				}
				timeline.to($content, { duration:0.5, force3D: true, y:'-220%', opacity: 0, delay: 1.5, ease:'power1.out' });
				timeline.to($intro, { duration:0.7, force3D: true, y:'-100%', ease:'power1.out' },'<0.3');

				function completeIntro(){
					$('html').removeClass('grve-stop-scrolling');
					$window.trigger('grve_after_page_transition');
					$intro.remove();
				}
			},
			bodyLoader: function(){
				var $overflow = $('#grve-loader-overflow'),
					$loader   = $('.grve-spinner'),
					$link = $('a');

				if( !$overflow.length ){
					$window.trigger('grve_after_page_transition');
					return;
				}

				if(navigator.userAgent.indexOf('Safari') != -1 && navigator.userAgent.indexOf('Chrome') == -1 || navigator.userAgent.match(/(iPod|iPhone|iPad)/)){
					window.onpageshow = function(event) {
						if (event.persisted) {
							$overflow.removeClass('grve-visible grve-hide');
							window.location.reload();
						}
					};
				} else if(navigator.userAgent.indexOf('Firefox') != -1) {
					window.onunload = function(){};
				}

				if( $overflow.hasClass('grve-page-transition') ) {
					var exclude = ['.grve-no-transition', '.grve-toggle-modal'],
						comp = new RegExp(location.host);

					$('a:not(' + exclude + ')').on('click',function(e){
						var link = this;
						if( comp.test(link.href) && link.href.split(/\?|#/)[0] != location.href.split(/\?|#/)[0] && link.target != '_blank' && link.href[0] != '#') {
							if(link.href.indexOf('#') == -1 && link.href.indexOf( 'jpg' ) == -1 && link.href.indexOf( 'jpeg' ) == -1 && link.href.indexOf( 'png' ) == -1 && link.href.indexOf( 'gif' ) == -1 && link.href.indexOf( 'bmp' ) == -1 && link.href.indexOf( 'pdf' ) == -1 && link.href.indexOf( 'zip' ) == -1 && link.href.indexOf('add-to-cart=') == -1 ) {
								e.preventDefault();
								var newLocation = this.href;
								$overflow.addClass('grve-visible').removeClass('grve-hide');
								$body.addClass('grve-page-loading');
								setTimeout(function(){
									window.location = newLocation;
								}, 600);
							}
						}
					});
				}
				setTimeout(function () {
					if( $overflow.hasClass('grve-page-transition') ) {
						$overflow.removeClass('grve-visible').addClass('grve-hide');
						setTimeout(function(){
							$window.trigger('grve_after_page_transition');
						}, 1200);
					} else {
						$loader.fadeOut(500);
						$overflow.delay(500).fadeOut(700,function(){
							$window.trigger('grve_after_page_transition');
						});
					}
				}, 600);

			},
			sectionSidebar: function(){

				if( !$('#grve-sidebar').length ) return;

				var section      = '#grve-content .grve-section',
					windowWidth  = $window.width(),
					themeWidth   = $('#grve-theme-wrapper').width(),
					wrapperWidth = $('.grve-content-wrapper').width(),
					contentWidth = $('#grve-main-content').width(),
					sidebarWidth = $('#grve-sidebar').outerWidth(),
					space        = (themeWidth - wrapperWidth)/2,
					sidebarSpace = space + wrapperWidth - contentWidth;

				$(section).each(function(){
					var $section = $(this);
					if( $section.hasClass('grve-fullwidth-background') ){
						fullBg($section);
					}
					if( $section.hasClass('grve-fullwidth') ){
						fullElement($section);
					}

				});

				function fullBg( section ) {
					if( windowWidth + scrollBarWidth >= tabletPortrait ) {
						if( $('.grve-right-sidebar').length ) {
							section.css({ 'visibility': 'visible', 'padding-left':space, 'padding-right': sidebarSpace, 'margin-left': -space, 'margin-right': -sidebarSpace});
						}
						else {
							section.css({ 'visibility': 'visible', 'padding-left':sidebarSpace, 'padding-right': space, 'margin-left': -sidebarSpace, 'margin-right': -space});
						}
					} else {
						section.css({ 'visibility': 'visible', 'padding-left':'', 'padding-right': '', 'margin-left': '', 'margin-right': ''});
					}

				}

				function fullElement( section ) {
					if( $body.hasClass('rtl') ) {
						if( windowWidth + scrollBarWidth >= tabletPortrait ) {
							if( $('.grve-right-sidebar').length ) {
								section.css({ 'visibility': 'visible', 'padding-right':0, 'padding-left': sidebarSpace, 'margin-right': -space, 'margin-left': -sidebarSpace});
							}
							else {
								section.css({ 'visibility': 'visible', 'padding-right':sidebarSpace, 'padding-left': 0, 'margin-right': -sidebarSpace, 'margin-left': -space});
							}
						} else {
							section.css({ 'visibility': 'visible', 'padding-right':'', 'padding-left': '', 'margin-right': -space, 'margin-left': -space});
						}
					} else {
						if( windowWidth + scrollBarWidth >= tabletPortrait ) {
							if( $('.grve-right-sidebar').length ) {
								section.css({ 'visibility': 'visible', 'padding-left':0, 'padding-right': sidebarSpace, 'margin-left': -space, 'margin-right': -sidebarSpace});
							}
							else {
								section.css({ 'visibility': 'visible', 'padding-left':sidebarSpace, 'padding-right': 0, 'margin-left': -sidebarSpace, 'margin-right': -space});
							}
						} else {
							section.css({ 'visibility': 'visible', 'padding-left':'', 'padding-right': '', 'margin-left': -space, 'margin-right': -space});
						}
					}
				}
			},
			alignFull: function(){
				var $element = $('.alignfull'),
					windowWidth  = $window.width(),
					$content = $('#grve-content'),
					$contentWrapper = $content.find('.grve-content-wrapper'),
					contentWidth = $contentWrapper.width(),
					space = ((windowWidth - contentWidth) / 2).toFixed();
				if( $content.hasClass('grve-with-sidebar') ) {
					$element.each(function(){
						var $that = $(this);
						if( windowWidth + scrollBarWidth >= tabletPortrait ) {
							if( $content.hasClass('grve-left-sidebar') ) {
								$that.css({
									'margin-left': 0,
									'margin-right': -space,
									'max-width': 'none'
								});
							} else {
								$that.css({
									'margin-left': -space,
									'margin-right': 0,
									'max-width': 'none'
								});
							}
						} else {
							$that.css({
								'margin-left': -space,
								'margin-right': -space,
								'max-width': 'none'
							});
						}
					});
				}
			},
			changeOrder: function(){
				var $element = $('.grve-change-order'),
					$parent = $element.parent();
				$parent.each(function(){
					var $that = $(this),
						$column = $that.children(),
						colLength = $column.length,
						tabletArr = $.makeArray( $column.not('.grve-change-order') ),
						tabletSmArr = $.makeArray( $column.not('.grve-change-order') ),
						mobileArr = $.makeArray( $column.not('.grve-change-order') );

					$column.each(function(num,value){
						var $that = $(value);
						if( $that.hasClass('grve-change-order') ){
							var tabletOrder = $that.data('tablet-order') !== undefined && $that.data('tablet-order') <= colLength ? $that.data('tablet-order') - 1 : $that.index(),
								tabletSmOrder = $that.data('tablet-sm-order') !== undefined && $that.data('tablet-sm-order') <= colLength ? $that.data('tablet-sm-order') - 1 : $that.index(),
								mobileOrder = $that.data('mobile-order') !== undefined && $that.data('mobile-order') <= colLength ? $that.data('mobile-order') - 1 : $that.index();

							tabletArr.splice( tabletOrder, 0, value);
							tabletSmArr.splice( tabletSmOrder, 0, value);
							mobileArr.splice( mobileOrder, 0, value);
						}
					});

					$.each( tabletArr, function(i,n){
						if( i <= 6 ) {
							$( this ).addClass('grve-tablet-order-' + (i + 1));
						} else {
							$( this ).addClass('grve-tablet-order-7');
						}
					});

					$.each( tabletSmArr, function(i,n){
						if( i <= 6 ) {
							$( this ).addClass('grve-tablet-sm-order-' + (i + 1));
						} else {
							$( this ).addClass('grve-tablet-sm-order-7');
						}
					});

					$.each( mobileArr, function(i,n){
						if( i <= 6 ) {
							$( this ).addClass('grve-mobile-order-' + (i + 1));
						} else {
							$( this ).addClass('grve-mobile-order-7');
						}
					});
				});
			},
			grveModal: function(){
				var $modal = $('#grve-sliding-area'),
					$button = $('.grve-toggle-modal'),
					$closeBtn = $modal.find('.grve-close-btn'),
					timeline = gsap.timeline({ paused:true }),
					headerSkin = $modal.data('modal-header-skin'),
					defaultSkin = $mainHeader.data('header-skin'),
					modalOpen = false;

				if( $modal.length ) {
					timeline.set($modal, { display: 'flex' });
					timeline.to($modal, { duration:0.3, opacity:1, x:0, y:0, ease:'power1.out', onComplete: openModal, onReverseComplete: closeModal });
				}

				$button.on('click',function(e){
					e.preventDefault();
					if( !modalOpen ) {
						modalOpen = true;
						var item = $(this).attr('href');
						$(item).addClass('grve-active');
						$('html').addClass('grve-stop-scrolling');
						$body.addClass('grve-modal-open');
						timeline.play();
					}
				});

				$document.on('keyup',function(evt) {
					if ( modalOpen && evt.keyCode == 27 ) {
						timeline.reverse();
						$('html').removeClass('grve-stop-scrolling');
					}
				});

				$closeBtn.on('click',function(e){
					e.preventDefault();
					if ( modalOpen ) {
						timeline.reverse();
						$('html').removeClass('grve-stop-scrolling');
					}
				});

				function openModal(){
					$window.off('scroll.grve_window_scroll');
					// Search Modal
					if( $('.grve-sliding-item.grve-active').is('#grve-search-modal') ){
						var $searchContent = $('#grve-search-modal'),
							$searchInput = $searchContent.find('.grve-search-textfield');
						$searchInput.on('focus', function() {
							$(this).parent().addClass('grve-input-filled');
						});
						$searchInput.on('blur', function() {
							if( this.value.trim() === '' ) {
								$(this).parent().removeClass('grve-input-filled');
							}
						});
					}
				}
				function closeModal(){
					$window.on('scroll.grve_window_scroll', function(){
						GRVE.onScroll();
					});
					if( $('.grve-sliding-item.grve-active').is('#grve-search-modal') ){
						var $searchContent = $('#grve-search-modal'),
							$searchInput = $searchContent.find('.grve-search-textfield');
						$searchInput.val('');
						$searchInput.parent().removeClass('grve-input-filled');
					}
					$('.grve-sliding-item').removeClass('grve-active');
					$body.removeClass('grve-modal-open');
					modalOpen = false;
				}
			},
			lightBox: function(){
				//Inline Modal Popup
				var $links = $document.find('a[href^="#"]:not( [href="#"] )'),
					modalItems = [],
					triggerModalItems = [];

				$links.each(function(){
					var $modal = $( $(this).attr('href') ),
						$link = $(this);
					if( $modal.length && $modal.hasClass('grve-modal-element') ) {
						modalItems.push(this);
						if( $link.hasClass('grve-modal-trigger') ) {
							triggerModalItems.push(this);
						}
					}

				});

				$.each( modalItems, function(){
					var $link = $(this);
					$link.on('click',function(e){
						e.preventDefault();
						var $modal = $( $(this).attr('href') ),
							$area = $('#grve-modal-area'),
							$overlay = $area.find('.grve-modal-overlay'),
							$close = $area.find('.grve-close-button-wrapper'),
							timeline = gsap.timeline();

						beforeOpen( $area, $modal );
						timeline.fromTo($overlay, {opacity: 0}, {opacity: 1, duration: 0.6, ease: 'power3.out' },'<');
						timeline.fromTo($modal, {opacity:0, y: 60}, {opacity:1, y: 0, duration: 0.6, ease: 'power3.out', onComplete: afterOpen },'<0.3');
						timeline.fromTo($close,  {opacity:0, scale:0}, {opacity:1, scale:1, duration: 0.6, ease: 'power3.out' });
					});
				});

				$.each( triggerModalItems, function(){
					var $triggerlink = $(this),
						$modal = $( $(this).attr('href') ),
						time = $modal.attr('data-trigger-delay') ? $modal.attr('data-trigger-delay') : '',
						days = $modal.attr('data-reset') ? parseInt( $modal.attr('data-reset') ) : 1,
						id = $modal.attr('id'),
						theDate = new Date(),
						later = new Date( theDate.getTime() + days*24*60*60*1000 ),
						modalCookie = 'grve-modal-' + id.trim();
					if ( 0 != days ) {
						if ( document.cookie.indexOf( modalCookie ) < 0 ) {
							window.setTimeout(function () {
								document.cookie = modalCookie +  '=true; SameSite=Lax; Path=/; Expires='+later.toGMTString()+';';
								$triggerlink.trigger('click');
							}, time);
						}
					} else {
						window.setTimeout(function () {
							$triggerlink.trigger('click');
						}, time);
					}
				});

				$document.on('click', '#grve-modal-area .grve-close-btn', function(e){
					e.preventDefault();
					var $area = $('#grve-modal-area'),
						timeline = gsap.timeline();

					timeline.to('#grve-modal-area .grve-modal-element.grve-active', { duration:0.5, opacity:0, ease:'power1.out' });
					timeline.to('#grve-modal-area .grve-close-button-wrapper', { duration:0.5, opacity:0, ease:'power1.out'},'<.3');
					timeline.to('#grve-modal-area .grve-modal-overlay', { duration:0.5, opacity: 0, ease:'power1.out', onComplete: afterClose });
				});

				$document.on('keyup',function(evt) {
					var $area = $('#grve-modal-area');
					if ($area.length && evt.keyCode == 27 && $body.hasClass('grve-modal-open')) {
						$('#grve-modal-area .grve-close-btn').trigger('click');
					}
				});

				function beforeOpen( $area, $modal ){
					$('html').addClass('grve-stop-scrolling');
					$body.addClass('grve-modal-open');
					$area.css('display','block');
					$modal.css('display','block').addClass('grve-active');
					$window.trigger('resize');
				}

				function afterOpen(){
					$window.trigger('grve_modal_open');
				}

				function afterClose(){
					$('html').removeClass('grve-stop-scrolling');
					$body.removeClass('grve-modal-open');
					$('#grve-modal-area').css('display','none');
					$('#grve-modal-area .grve-modal-element.grve-active').css('display','none').removeClass('grve-active');
					$window.trigger('grve_modal_close');
				}
			},
			lightGallery: function(){
				$('.grve-woo-light-gallery-popup').lightGallery({
					selector: 'a',
					getCaptionFromTitleOrAlt: false,
					thumbnail: false,
					hash: false,
				});
				$('.grve-gallery-popup').lightGallery({
					selector: '.grve-item-url',
					getCaptionFromTitleOrAlt: false,
					thumbnail: false,
					hash: false,
				});
				$('.grve-multi-popup').lightGallery({
					selector: '.grve-multi-url',
					getCaptionFromTitleOrAlt: false,
					thumbnail: false,
					hash: false,
				});
				$('.grve-light-gallery').lightGallery({
					selector: '.grve-item-url',
					getCaptionFromTitleOrAlt: false,
					thumbnail: false,
					hash: false,
				});

				$('.grve-image-popup').lightGallery({ selector: 'this' });

				if ( $('.grve-body').hasClass( 'grve-privacy-video-embeds-disabled' ) ) {
					$('.grve-video-popup').each(function() {
						$(this).attr({"target" : "_blank"});
					});
				} else {
					$('.grve-video-popup').lightGallery({ selector: 'this' });
				}

				if( 1 == impeka_grve_main_data.wp_gallery_popup ) {
					$('.gallery').lightGallery({
						selector: '.gallery-item a',
						getCaptionFromTitleOrAlt: false,
						thumbnail: false,
						hash: false,
					});
					$('.blocks-gallery-grid').lightGallery({
						selector: '.blocks-gallery-item a',
						getCaptionFromTitleOrAlt: false,
						thumbnail: false,
						hash: false,
					});
				}

				$('.grve-post-gallery-popup').lightGallery({
					selector: 'a',
					getCaptionFromTitleOrAlt: false,
					thumbnail: false,
					hash: false,
				});
			},
			quickView: function(){
				$('.grve-quick-view-link').on('click', function(e) {
					e.preventDefault();
					var link = $(this),
						id = link.data('post-id'),
						wrapper = '<div id="grve-quick-view-wrapper"></div>',
						dataParams = {
						action:'impeka_grve_quick_view_callback',
						grve_view_id: id,
						_grve_nonce: impeka_grve_main_data.nonce_quick_view
					};
					$('body').append(wrapper);
					gsap.to( $('#grve-quick-view-wrapper'), { x: 0, duration: 0.6, ease: 'power3.out' });
					gsap.to( $('#grve-theme-content'), { x: -300, duration: 0.6, ease: 'power3.out' });

					$.post( impeka_grve_main_data.ajaxurl, dataParams , function( response ) {
						if ( '-1' != response ) {
							$('#grve-quick-view-wrapper').append(response);
							var $modal = $('.grve-quick-view-modal'),
								$description = $modal.find('.grve-quick-view-description'),
								$mask = $modal.find('.grve-mask'),
								$close = $modal.find('.grve-close-btn'),
								timeline = gsap.timeline();

							timeline.fromTo($mask, {opacity: 1}, {opacity: 0, duration: 0.9, ease: 'power3.out' });
							timeline.from($description.children(), { y: 60, opacity: 0, duration: 0.6, ease: 'power3.out', stagger: 0.3 });

							$close.on('click',function(e){
								e.preventDefault();
								gsap.set( $('#grve-theme-content'), {x: 0});
								gsap.to( $('#grve-quick-view-wrapper'), { opacity: 0, duration: 0.6, ease: 'power3.out', onComplete:removeWrapper });
								// gsap.fromTo( $('#grve-theme-content'), {x: 300}, { x: 0, duration: 1, ease: 'power3.out' });
							});

							function removeWrapper(){
								$('#grve-quick-view-wrapper').remove();
							}
						}
					}).fail(function(xhr, status, error) {

					});
					return false;
				});
			},
			socialShareLinks: function(){
				$('.grve-social-share-facebook').on('click', function(e) {
					e.preventDefault();
					window.open( 'https://www.facebook.com/sharer/sharer.php?u=' + $(this).attr('href'), "facebookWindow", "height=380,width=660,resizable=0,toolbar=0,menubar=0,status=0,location=0,scrollbars=0" );
					return false;
				});
				$('.grve-social-share-twitter').on('click', function(e) {
					e.preventDefault();
					window.open( 'http://twitter.com/intent/tweet?text=' + encodeURIComponent( $(this).attr('title') ) + ' ' + $(this).attr('href'), "twitterWindow", "height=450,width=660,resizable=0,toolbar=0,menubar=0,status=0,location=0,scrollbars=0" );
					return false;
				});
				$('.grve-social-share-linkedin').on('click', function(e) {
					e.preventDefault();
					window.open( 'http://www.linkedin.com/shareArticle?mini=true&url=' + $(this).attr('href') + '&title=' + encodeURIComponent( $(this).attr('title') ), "linkedinWindow", "height=500,width=820,resizable=0,toolbar=0,menubar=0,status=0,location=0,scrollbars=0" );
					return false;
				});
				$('.grve-social-share-googleplus').on('click', function(e) {
					e.preventDefault();
					window.open( 'https://plus.google.com/share?url=' + $(this).attr('href'), "googleplusWindow", "height=600,width=600,resizable=0,toolbar=0,menubar=0,status=0,location=0,scrollbars=0" );
					return false;
				});
				$('.grve-social-share-pinterest').on('click', function(e) {
					e.preventDefault();
					window.open( 'http://pinterest.com/pin/create/button/?url=' + $(this).attr('href') + '&media=' + $(this).data('pin-img') + '&description=' + encodeURIComponent( $(this).attr('title') ), "pinterestWindow", "height=600,width=600,resizable=0,toolbar=0,menubar=0,status=0,location=0,scrollbars=0" );
					return false;
				});
				$('.grve-social-share-reddit').on('click', function(e) {
					e.preventDefault();
					window.open( '//www.reddit.com/submit?url=' + $(this).attr('href'), "redditWindow", "height=600,width=820,resizable=0,toolbar=0,menubar=0,status=0,location=0,scrollbars=1" );
					return false;
				});
				$('.grve-social-share-tumblr').on('click', function(e) {
					e.preventDefault();
					window.open( '//www.tumblr.com/share/link?url=' + $(this).attr('href') + '&name=' + encodeURIComponent( $(this).attr('title') ) , "tumblrWindow", "height=600,width=600,resizable=0,toolbar=0,menubar=0,status=0,location=0,scrollbars=0" );
					return false;
				});
				$('.grve-like-counter-link').on('click', function(e) {
					e.preventDefault();
					var link = $(this);
					var id = link.data('post-id'),
						counter = link.parent().find('.grve-like-counter'),
						icon = link.find('i');

					var dataParams = {
						action:'impeka_grve_likes_callback',
						grve_likes_id: id,
						_grve_nonce: impeka_grve_main_data.nonce_likes
					};
					$.post( impeka_grve_main_data.ajaxurl, dataParams , function( response ) {
						if ( '-1' != response ) {
							if( 'active' == response.status ){
								link.addClass('active');
								icon.addClass('grve-heading-color');
							} else {
								link.removeClass('active');
								icon.removeClass('grve-heading-color');
							}
							counter.html(response.likes);
						}
					}).fail(function(xhr, status, error) {
					});
					return false;
				});
			},
			animatedBg: function(){
				$section.each(function(){
					var $this = $(this);
					if( $this.hasClass('grve-bg-animated') ) {
						zoomBg( $this );
					} else if( $this.hasClass('grve-bg-horizontal') ) {
						horizontalBg( $this );
					}
				});

				function zoomBg( $this ){
					$this.mouseenter(function() {
						$this.addClass('zoom');
					});
					$this.mouseleave(function() {
						$this.removeClass('zoom');
					});
				}

				function horizontalBg( $this ){
					var bgPosition = 0;
					setInterval(function(){
						bgPosition++;
						$this.find('.grve-bg-image').css({ 'background-position' : bgPosition+'px center', 'background-repeat' : 'repeat' });
					},75);
				}
			},
			stickySidebar: function(){
				if( $sidebar.length && $sidebar.hasClass('grve-fixed-sidebar') ) {
					sticky( $sidebar, 0 );
				} else if( $sidebar.length && $stickyWidget.length ) {
					$stickyWidget.nextAll().addBack().wrapAll('<div class="grve-sticky-widget-wrapper"></div>');
					var $wrapper = $stickyWidget.parent(),
						space = 60;
					sticky( $wrapper, space );
				}

				function sticky( $item, offset ){
					$item.stick_in_parent({
						parent: '#grve-content',
						sticky_class: 'grve-sidebar-fixed',
						offset_top: offset
					});
				}
			},
			textInputEffect: function(){
				var $wrapper = $('#grve-comment-form'),
					$input = $wrapper.find('.grve-form-input-item');
				$input.on('focus', function() {
					$(this).parent().addClass('grve-input-filled');
				});
				$input.on('blur', function() {
					if( this.value.trim() === '' ) {
						$(this).parent().removeClass('grve-input-filled');
					}
				});
			},
			goToTop: function() {
				var selectors  = {
					topBtn     : '.grve-back-top',
					dividerBtn : '.grve-divider-backtotop',
					topLink    : 'a[href="#grve-goto-header"]'
					};

				$.each(selectors, function(key, value){
					$(value).on('click', function(e){
						e.preventDefault();
						var scrollTop = Math.abs($window.scrollTop()) / 2,
							speed = scrollTop < 1000 ? 1000 : scrollTop;
						$('html, body').animate({scrollTop: 0}, speed, 'easeInOutCubic');
						$("html, body").on("scroll mousedown DOMMouseScroll mousewheel keyup", function(){
							$('html, body').stop();
						});
					});
				});
			},
			backToTop: function(){
				if( !$backToTop.length ) return;
				var scroll = $window.scrollTop();

				if (scroll > 600) {
					$backToTop.addClass('show');
				} else {
					$backToTop.removeClass('show');
				}
			},
			fixedFooter: function(){
				var $footer      = $('#grve-footer'),
					sticky       = $footer.data('sticky-footer'),
					prevSection  = $footer.prev(),
					prevMargin = parseInt( prevSection.css('margin-bottom') );

				if( !$footer.length || sticky != 'yes' || GRVE.helpers.isMobile.any() ) return;

				// On window events
				$( window ).on( 'scroll', function(){
					update();
				});
				$( window ).on( 'resize', function(){
					update();
				});

				update();

				function update(){
					var windowWidth = $window.width(),
						windowHeight = $window.height(),
						footerHeight = $footer.outerHeight(),
						margin       = footerHeight + prevMargin;

					if( ( windowWidth + scrollBarWidth <= tabletLandscape ) || ( footerHeight > windowHeight ) ) {
						$footer.removeClass('grve-fixed-footer').prev().css( 'margin-bottom','' );
					} else {
						$footer.addClass('grve-fixed-footer').prev().css( 'margin-bottom',margin );
					}
				}
			},
			splitTitle: function(){
				var $title = $('.grve-split-title');
				$title.each(function(){
					var $that = $(this);
					GRVE.helpers.splitText( $that, 'text', 0 );
				});
			},
			svgAnimation: function(){
				var $svg = $('.grve-animated-svg-icon');
				$svg.each(function(){
					var $icon = $(this),
						duration = $icon.data('duration'),
						id = $icon.attr('id'),
						file = $icon.data('file'),
						myVivus,
						parentDelay = 0;

					if( $icon.parents('.grve-element').hasClass('grve-animated-item') ){
						parentDelay = $icon.parents('.grve-element').data('delay');
					}

					$icon.appear(function() {
						setTimeout(function () {
							myVivus = new Vivus( id, {
								duration : duration,
								file : file,
								type: 'async',
								start : 'inViewport'
							});
						}, parentDelay);
					},{accX: 0, accY: 0});
				});
			},
			svgCustom: function(){
				var $svg = $('.grve-custom-svg-icon');
				$svg.each(function(){
					var $icon = $(this),
						id = $icon.attr('id'),
						file = $icon.data('file'),
						myVivus;
					myVivus = new Vivus( id, {
						duration : 1,
						file : file,
						type: 'async',
						start : 'autostart'
					});
				});
			}
		},
		sectionColor: {
			init: function(){
				var base = this;
				if( !$('#grve-content').hasClass('grve-skin-effect') ) {
					base.sections = base.getSections();
					base.items = base.getItems();
					base.onResize();
					base.onScroll();
				}
			},
			onResize: function(){
				var base = this;
				if( !$('#grve-content').hasClass('grve-skin-effect') ) {
					base.prop = base.getSectionProp();
					base.itemsProp = base.getItemsProp();
				}
			},
			onScroll: function(){
				var base = this;
				if( !$('#grve-content').hasClass('grve-skin-effect') ) {
					var scroll = $window.scrollTop();
					if( sectionColorMove ) { return; }
					$.each( base.items,function(i,n){
						var $item = $(base.items[i].item),
							itemBottom = base.itemsProp[i].bottom,
							itemMiddle = base.itemsProp[i].middle,
							initColor = base.items[i].initColor;

						$.each( base.sections,function(i,n){
							var $section = $(base.sections[i].section),
								sectionTop = base.prop[i].top,
								sectionBottom = base.prop[i].bottom,
								color = base.sections[i].color;

							if( scroll < base.prop[0].top - itemMiddle ) {
								if( !$item.hasClass( 'grve-skin-' + initColor ) ) {
									base.changeSkin( $item, initColor );
								}
							} else if( scroll >= sectionTop - itemMiddle && scroll <= sectionBottom - itemMiddle ) {
								if( !$item.hasClass( 'grve-skin-' + color ) ) {
									base.changeSkin( $item, color );
								}
							} else if( scroll > base.prop[base.lastIndex].bottom - itemMiddle ) {
								if( !$item.hasClass( 'grve-skin-' + base.footerColor ) ) {
									base.changeSkin( $item,  base.footerColor );
								}
							}
						});
					});
				}
			},
			changeSkin: function( $item, color ){
				var base = this;
				$item.removeClass('grve-skin-default grve-skin-dark grve-skin-light').addClass('grve-skin-' + color );
			},
			getSections: function(){
				var base = this,
					$contentSection = $('#grve-content [data-header-color]:visible'),
					otherSections = ['.grve-navigation-bar', '#grve-about-author-section', '#grve-comments-section', '#grve-related-section'],
					$footerSections = $('#grve-footer:not(.grve-fixed-footer) [data-header-color]:visible'),
					sections = [];

				if( $contentSection.length ) {
					$contentSection.each(function(){
						var $that = $(this),
							color = $that.data('header-color') !== undefined ? $that.data('header-color') : 'default';
						sections.push({
							'section': $that[0],
							'color': color
						});
					});
				} else if( $('#grve-content').length ) {
					var $section = $('#grve-content');
					sections.push({
						'section': '#grve-content',
						'color': 'default'
					});
				}
				$.each(otherSections, function(){
					var $that = $(this);
					if( $that.length ) {
						var color = $that.data('header-color') !== undefined ? $that.data('header-color') : 'default';
						sections.push({
							'section': $that[0],
							'color': color
						});
					}
				});
				$footerSections.each(function(){
					var $that = $(this),
						color = $that.data('header-color') !== undefined ? $that.data('header-color') : 'default';
					sections.push({
						'section': $that[0],
						'color': color
					});
				});

				base.lastIndex = sections.length - 1;
				var $stickyFooter = $('#grve-footer.grve-fixed-footer');
				if( $stickyFooter.length ) {
					var footerSection = $stickyFooter.find('[data-header-color]:visible')[0];
					base.footerColor = $(footerSection).length ? $(footerSection).data('header-color') : 'default';
				}

				return sections;
			},
			getItems: function(){
				var base = this,
					$item = $('.grve-skin-scroll'),
					items = [];
				$item.each(function(){
					var $that = $(this),
						initColor = $that.data('skin');

					items.push({
						'item': $that[0],
						'initColor': initColor,
					});
				});

				return items;
			},
			getSectionProp: function(){
				var base = this,
					prop = [];

				$.each( base.sections,function( index, value ){
					var $that = $(value.section),
						height =  parseInt( $that.outerHeight() ),
						top =  parseInt( $that.offset().top ),
						bottom = top + height;

					prop.push({
						'height': height,
						'top': top,
						'bottom': bottom
					});
				});
				return prop;
			},
			getItemsProp: function(){
				var base = this,
					prop = [];

				$.each( base.items,function( index, value ){
					var $that = $(value.item),
						height = parseInt( $that.outerHeight() ),
						top = parseInt( value.item.getBoundingClientRect().top ),
						middle = top + height / 2,
						bottom = top + height;
					prop.push({
						'height': height,
						'top': top,
						'bottom': bottom,
						'middle': middle
					});
				});
				return prop;
			},
		},
		skinScrollEffect: {
			init: function(){
				var base = this;
				if( !$body.hasClass('elementor-page') && $('#grve-content').hasClass('grve-skin-effect') ) {
					var $wrapper = $('<div id="grve-helper-bg-wrapper"></div>');
					$wrapper.appendTo( $('#grve-theme-content') );
					base.current = 0;
					base.sections = base.getSections();
					if ( !base.sections.length ) {
						return;
					}
					base.addHelpers();
					base.changeSkin(0);
					base.onResize();
					base.onScroll();
					base.timeout;
				}
			},
			onResize: function(){
				var base = this;
				if( !$body.hasClass('elementor-page') && $('#grve-content').hasClass('grve-skin-effect') ) {
					base.prop = base.getSectionProp();
				}
			},
			onScroll: function(){
				var base = this;
				if( !$body.hasClass('elementor-page') && $('#grve-content').hasClass('grve-skin-effect') ) {
					var scroll = $window.scrollTop(),
						tresh = $window.height() - ($window.height() / 3);

					$.each( base.sections,function(i,n){
						var $section = $(base.sections[i].section),
							sectionTop = base.prop[i].top,
							sectionBottom = base.prop[i].bottom;
						if( scroll >= sectionTop - tresh && scroll <= sectionBottom - tresh ) {
							if( i != base.current ) {
								base.current = i;
								base.setActiveHelper(i);
								base.changeSkin(i);
							}
						}
					});
				}
			},
			setActiveHelper: function( index ){
				var base = this;
				$('#grve-helper-bg-wrapper').find('.active').removeClass('active').addClass('previous').siblings().removeClass('previous');
				$('.grve-helper-bg').eq(index).addClass('active');
				window.clearTimeout(base.timeout);
				base.timeout = window.setTimeout(function () {
					$('#grve-helper-bg-wrapper').find('.previous, .show').removeClass('previous, show');
				}, 1000);
			},
			changeSkin: function( index ){
				var base = this,
					headerSkin = base.sections[index].headerSkin,
					textColor = base.sections[index].textColor,
					headingColor = base.sections[index].headingColor,
					linkColor = base.sections[index].linkColor,
					linkHoverColor = base.sections[index].linkHoverColor;

				$('.grve-skin-scroll').removeClass('grve-skin-default grve-skin-dark grve-skin-light').addClass('grve-skin-' + headerSkin );
				$.each( base.sections,function( index, value ){
					var section = value.section,
						$section = $(section);
					section.style.cssText = textColor;
					section.classList.remove( base.getElClass( section, 'grve-headings' ), base.getElClass( section, 'grve-link' ), base.getElClass( section, 'grve-link-hover' ) );
					section.classList.add( headingColor, linkColor, linkHoverColor );
				});

				if( 'main-header' == $('#grve-main-header').data('sticky-mode') ) {
					GRVE.headerSettings.mainHeader.changeSkin( headerSkin );
				}

			},
			getSections: function(){
				var base = this,
					$section = $('#grve-theme-content .grve-section:visible'),
					sections = [];

				$section.each(function(){
					var $that = $(this),
						headerSkin = $that.data('header-color') !== undefined ? $that.data('header-color') : 'default',
						headingColor = base.getElClass( this, 'grve-headings' ),
						linkColor = base.getElClass( this, 'grve-link' ),
						linkHoverColor = base.getElClass( this, 'grve-link-hover' ),
						bgColor = base.getBgColors( this),
						textColor = base.getTextColor( this),
						height =  parseInt( $that.outerHeight() ),
						top =  parseInt( $that.offset().top ),
						bottom = top + height;

					sections.push({
						'section': $that[0],
						'headerSkin': headerSkin,
						'headingColor': headingColor,
						'linkColor': linkColor,
						'linkHoverColor': linkHoverColor,
						'bgColor': bgColor,
						'textColor': textColor,
						'height': height,
						'top': top,
						'bottom': bottom
					});
				});
				return sections;
			},
			getSectionProp: function(){
				var base = this,
					prop = [];

				$.each( base.sections,function( index, value ){
					var $that = $(value.section),
						height =  parseInt( $that.outerHeight() ),
						top =  parseInt( $that.offset().top ),
						bottom = top + height;

					prop.push({
						'height': height,
						'top': top,
						'bottom': bottom
					});
				});
				return prop;
			},
			getElClass: function(section, prefix){
				var classReg = new RegExp(prefix + '-[^\\s]+\\b', "g"),
					specificClass = section.className.match(classReg) != null ? section.className.match(classReg)[0] : prefix + '-default';
				return specificClass;
			},
			getBgColors: function(section){
				var bgColor = section.style.backgroundImage != '' ? 'background-image:' + section.style.backgroundImage : section.style.backgroundColor != '' ? 'background-color:' + section.style.backgroundColor : 'background-color: inherit';
				return bgColor;
			},
			getTextColor: function(section){
				var textColor = section.style.color != '' ? 'color:' + section.style.color : 'color: inherit';
				return textColor;
			},
			addHelpers: function(){
				var base = this,
					$wrapper = $('#grve-helper-bg-wrapper');
				$.each( base.sections,function( index, value ){
					var section = value.section,
						$section = $(section),
						$helper = $('<div class="grve-helper-bg" style="' + value.bgColor + ';"></div>');
					$wrapper.append($helper);

					section.style.backgroundColor = '';
					section.style.backgroundImage = '';
					section.style.color = '';
					section.classList.remove( [value.headingColor], [value.linkColor], [value.linkHoverColor] );
					if( 0 === index ) {
						$helper.addClass('show');
					}
					if( $section.children('.grve-background-wrapper').length ){
						var $bgWrapper = $section.children('.grve-background-wrapper');
						$section.addClass('grve-remove-bg-image');
						$bgWrapper.clone().appendTo( $helper );
					}
				});
			}
		},
		skinScrollEffectElementor: {
			init: function(){
				var base = this;
				if( $body.hasClass('elementor-page') && !$('body').hasClass('elementor-editor-active') && $('#grve-content').hasClass('grve-skin-effect') ) {
					var $wrapper = $('<div id="grve-helper-bg-wrapper"></div>');
					$wrapper.appendTo( $('#grve-theme-content') );
					base.current = 0;
					base.sections = base.getSections();
					if ( !base.sections.length ) {
						return;
					}
					base.addHelpers();
					base.changeSkin(0);
					base.onResize();
					base.onScroll();
					base.timeout;
				}
			},
			onResize: function(){
				var base = this;
				if( $body.hasClass('elementor-page') && !$('body').hasClass('elementor-editor-active') && $('#grve-content').hasClass('grve-skin-effect') ) {
					base.prop = base.getSectionProp();
				}
			},
			onScroll: function(){
				var base = this;
				if( $body.hasClass('elementor-page') && !$('body').hasClass('elementor-editor-active') && $('#grve-content').hasClass('grve-skin-effect') ) {
					var scroll = $window.scrollTop(),
						tresh = $window.height() - ($window.height() / 3);

					$.each( base.sections,function(i,n){
						var $section = $(base.sections[i].section),
							sectionTop = base.prop[i].top,
							sectionBottom = base.prop[i].bottom;
						if( scroll >= sectionTop - tresh && scroll <= sectionBottom - tresh ) {
							if( i != base.current ) {
								base.current = i;
								base.setActiveHelper(i);
								base.changeSkin(i);
							}
						}
					});
				}
			},
			setActiveHelper: function( index ){
				var base = this;
				$('#grve-helper-bg-wrapper').find('.active').removeClass('active').addClass('previous').siblings().removeClass('previous');
				$('.grve-helper-bg').eq(index).addClass('active');
				window.clearTimeout(base.timeout);
				base.timeout = window.setTimeout(function () {
					$('#grve-helper-bg-wrapper').find('.previous, .show').removeClass('previous, show');
				}, 1000);
			},
			changeSkin: function( index ){
				var base = this,
					headerSkin = base.sections[index].headerSkin,
					textColor = base.sections[index].textColor,
					headingColor = base.sections[index].headingColor,
					linkColor = base.sections[index].linkColor,
					linkHoverColor = base.sections[index].linkHoverColor;

				$('.grve-skin-scroll').removeClass('grve-skin-default grve-skin-dark grve-skin-light').addClass('grve-skin-' + headerSkin );

				$.each( base.sections,function( index, value ){
					var section = value.section,
						$section = $(section),
						$text = $section.find('.elementor-widget-text-editor'),
						headings = $section.find('h1,h2,h2,h3,h4,h5,h6');

					$section.css('color',textColor);

					$.each( headings,function(){
						var $that = $(this);
						if( $that.hasClass('grve-disable-color-change') || $that.parents('.grve-disable-color-change').length ) {
							return;
						} else {
							$that.css('color',headingColor);
						}
					});

					$.each( $text,function(){
						var $that = $(this);
						if( $that.hasClass('grve-disable-color-change') || $that.parents('.grve-disable-color-change').length ) {
							return;
						} else {
							$that.css('color',textColor);
						}
					});

				});

				if( 'main-header' == $('#grve-main-header').data('sticky-mode') ) {
					GRVE.headerSettings.mainHeader.changeSkin( headerSkin );
				}
			},
			getSections: function(){
				var base = this,
					$section = $('#grve-theme-content .elementor-section-wrap > .elementor-section:visible').length ?  $('#grve-theme-content .elementor-section-wrap > .elementor-section:visible') :  $('#grve-theme-content .elementor > .elementor-section:visible'),
					sections = [];

				$section.each(function(){
					var $that = $(this),
						headerSkin = $that.data('header-color') !== undefined ? $that.data('header-color') : 'default',
						headingColor = base.getHeadingColor( this ),
						// linkColor = base.getElClass( this, 'grve-link' ),
						// linkHoverColor = base.getElClass( this, 'grve-link-hover' ),
						settings = $that.data('settings'),
						bgType = settings !== undefined ? settings.background_background : '',
						textColor = base.getTextColor( this ),
						linkColor = '',
						linkHoverColor = '',
						height = parseInt( $that.outerHeight() ),
						top = parseInt( $that.offset().top ),
						bottom = top + height;

					sections.push({
						'section': $that[0],
						'headerSkin': headerSkin,
						'headingColor': headingColor,
						'linkColor': linkColor,
						'linkHoverColor': linkHoverColor,
						'textColor': textColor,
						'height': height,
						'top': top,
						'bottom': bottom,
						'bgType' : bgType
					});
				});
				return sections;
			},
			getSectionProp: function(){
				var base = this,
					prop = [];

				$.each( base.sections,function( index, value ){
					var $that = $(value.section),
						height =  parseInt( $that.outerHeight() ),
						top =  parseInt( $that.offset().top ),
						bottom = top + height;

					prop.push({
						'height': height,
						'top': top,
						'bottom': bottom
					});
				});
				return prop;
			},
			getHeadingColor: function(section){
				var $section = $(section),
					headingColor = $section.data('heading-color') !== undefined ? $section.data('heading-color') : '#000000';
				return headingColor;
			},
			getTextColor: function(section){
				var $section = $(section),
					textColor = $section.data('text-color') !== undefined ? $section.data('text-color') : 'inherit';
				return textColor;
			},
			addHelpers: function(){
				var base = this,
					$wrapper = $('#grve-helper-bg-wrapper');
				$.each( base.sections,function( index, value ){
					var section = value.section,
						$section = $(section),
						bgType = value.bgType,
						$overlay = $section.children('.elementor-background-overlay'),
						$helper = '',
						bgColor = '',
						bgUrl = '';

					if( 'classic' == bgType ) {
						bgUrl = $section.css('background-image').replace(/^url\(['"]?/,'').replace(/['"]?\)$/,'');
						bgColor = $section.css('background-color') != '' ? $section.css('background-color') : 'transparent';
						$helper = $('<div class="grve-helper-bg" style="background-color: ' + bgColor + ';"></div>');
						$wrapper.append($helper);
						if( bgUrl !== 'none' ) {
							var $bgWrapper = $('<div class="grve-background-wrapper"><div class="grve-bg-image grve-bg-center-center" style="background-image: url(' + bgUrl + ');"></div></div>');
							$bgWrapper.appendTo( $helper );
						}
					} else if( 'gradient' == bgType ) {
						bgColor = $section.css('background-image') != '' ? $section.css('background-image') : 'none';
						$helper = $('<div class="grve-helper-bg" style="background-image: ' + bgColor + ';"></div>');
						$wrapper.append($helper);
					} else {
						bgColor = '#ffffff';
						$helper = $('<div class="grve-helper-bg" style="background-color: ' + bgColor + ';"></div>');
						$wrapper.append($helper);
					}

					if( $overlay.length ) {
						var overlayBg = $overlay.css('background'),
							overlayOpacity = $overlay.css('opacity');
						$overlay.clone().css({
							'background': overlayBg,
							'opacity': overlayOpacity
						}).appendTo( $helper );
						$overlay.remove();
					}

					$section.css({
						'background': 'none'
					});
					if( 0 === index ) {
						$helper.addClass('show');
					}
				});
			}
		},
		onePage: {
			init: function(){
				$('a[href*="#"]:not( [href="#"] )').on('click', function(e) {
					var target          = $(this.hash),
						targetHash      = this.hash;

					if ( target.length && ( target.hasClass('grve-section') || target.hasClass('grve-inner-section') || target.hasClass('grve-bookmark') ) ) {
						GRVE.helpers.smoothScrollTo( target );

						setTimeout(function(){
							// Close Responsive Menu
							if( $('body').hasClass('grve-responsivemenu-open') ) {
								$('.grve-toggle-responsive-menu').trigger('click');
							}
							// Close Offcanvas
							if( $('body').hasClass('grve-offcanvas-open') ) {
								$('.grve-toggle-offcanvas').trigger('click');
							}
						},1000);
					}

					if ( target.length && ( target.hasClass('grve-tab-content') || target.hasClass('grve-accordion-content') ) ) {
						var tabLink =  $('.grve-tab-link[data-rel="' + targetHash + '"]:visible');
						if ( tabLink.length ) {
							tabLink.click();
							setTimeout(function() {
								GRVE.helpers.linkGoToTop( tabLink );
							}, 500);
						}
						return false;
					}

					// Elementor Close Hidden Areas
					if ( $body.hasClass('elementor-page') && target.length && target.hasClass('elementor-section') ) {
						setTimeout(function(){
							// Close Responsive Menu
							if( $('body').hasClass('grve-responsivemenu-open') ) {
								$('.grve-toggle-responsive-menu').trigger('click');
							}
							// Close Offcanvas
							if( $('body').hasClass('grve-offcanvas-open') ) {
								$('.grve-toggle-offcanvas').trigger('click');
							}
						},1000);
					}

				});
			},
			onePageMenu: function(){
				var $section       = $('#grve-main-content .grve-section[id]');
				if (!$section.length ) return;

				var sideHeader     = $mainHeader.hasClass('grve-header-side') ? true : false,
					headerHeight   = $header.attr('data-sticky-header') != 'none' && !sideHeader ? $mainHeader.outerHeight() : 0,
					anchorBarHeight = $('.grve-anchor-menu').length ? $('.grve-anchor-menu').outerHeight() : 0,
					offsetTop      = headerHeight + anchorBarHeight + wpBarHeight,
					scroll         = $window.scrollTop();

				$section.each(function(){
					var $that         = $(this),
						currentId     = $that.attr('id'),
						sectionOffset = $that.offset().top - offsetTop;

					if (sectionOffset <= scroll && sectionOffset + $that.outerHeight() > scroll ) {
						$('a[href*="#' + currentId + '"]').parent().addClass('active');
					}
					else{
						$('a[href*="#' + currentId + '"]').parent().removeClass("active");
					}

				});
			}
		},
		sectionNav: {
			init: function(){
				if( $('#grve-content').hasClass('grve-section-nav') && $('[data-anchor-tooltip]').length > 0 ){
					var base = this;
					base.activeIndex = 0;
					base.currentIndex = 1;
					base.sections = base.getSections();
					base.onResize();

					$('<div id="grve-section-nav" class="grve-link-text"><div class="grve-section-nav-inner"><div class="grve-section-slider"></div></div><div class="grve-line grve-skin-scroll"><div class="grve-line-inner"></div></div></div>').appendTo($themeWrapper);

					$.each( base.sections,function(i,n){
						var title = base.sections[i].title,
							target = base.sections[i].target,
							$item = $('<a href="' + target + '"><span class="grve-skin-scroll" data-skin="default">' + title + '</span></a>');
						$item.appendTo( $('#grve-section-nav .grve-section-slider') );
					});

					$document.on('click', '#grve-section-nav a', function(event){
						event.preventDefault();
						var $that = $(this),
							link = $that.attr('href'),
							$target = $body.hasClass('elementor-page') ? $('[data-id=' + link + ']') : $('[data-anchor=' + link + ']');

						if( $target.length ) {
							GRVE.helpers.smoothScrollTo( $target );
						}
						$that.addClass('active').siblings().removeClass('active');
					});

					$document.on('click', '#grve-section-nav .grve-line', function(){
						var nextSection = base.activeIndex + 1 < base.sections.length ? base.activeIndex + 1 : 0,
						$target = $(base.sections[nextSection].section);

						if( $target.length ) {
							GRVE.helpers.smoothScrollTo( $target, function(){
								if( nextSection === 0 ) {
									$('#grve-section-nav a').removeClass('grve-hide');
								}
							});
						}
					});

					base.itemProp = base.getNavItemsProp();
					if( $('#grve-section-nav .grve-section-slider').children().length > 1 ) {
						base.moveTo( 1 );
						base.setActiveItem( 0 );
					}
					base.onScroll();

					// Reset when safe button close
					$window.on('grve_safebutton_open',function(){
						$('#grve-section-nav a').removeClass('grve-hide');
						base.moveTo( 1 );
						base.setActiveItem( 0 );
					});
				}
			},
			moveTo: function( index ){
				var base = this,
					$nav = $('#grve-section-nav'),
					$slide = $nav.find('.grve-section-slider'),
					yPosition = base.itemProp[index].bottom;
				sectionColorMove = true;
				if( index >= 1 ) {
					if( index > base.currentIndex ) {
						for (var i = index - 3; i >= 0; i--) {
							$($slide.children()[i]).addClass('grve-hide');
						}
					} else {
						$($slide.children()[index - 2]).removeClass('grve-hide');
					}
					$($slide.children()[index - 3]).addClass('grve-hide');
					gsap.to($slide, {y:-yPosition, duration:0.6, ease:'expo.out', onComplete: onComplete });
				}

				function onComplete(){
					sectionColorMove = false;
					base.currentIndex = index;
					GRVE.pageSettings.sectionColor.onResize();
					GRVE.pageSettings.sectionColor.onScroll();
				}
			},
			onResize: function(){
				if( $('#grve-content').hasClass('grve-section-nav') && $('[data-anchor-tooltip]').length > 0 ){
					var base = this;
					base.prop = base.getSectionProp();
					base.itemProp = base.getNavItemsProp();
				}
			},
			onScroll: function(){
				if( $('#grve-content').hasClass('grve-section-nav') && $('[data-anchor-tooltip]').length > 0 ){
					var base = this,
						scroll = $window.scrollTop();
					$.each( base.sections,function(i,n){
						var $section = $(base.sections[i].section),
							sectionTop = base.prop[i].top,
							sectionBottom = base.prop[i].bottom;

						if( scroll >= sectionTop - $window.height() + 60 && scroll <= sectionBottom - $window.height() + 60 && base.activeIndex !== i ) {
							base.activeIndex = i;
							base.moveTo( i );
							base.setActiveItem( i );
							base.updateLine( i );
						}
					});
				}
			},
			updateLine: function(index){
				var base = this,
					$line = $('#grve-section-nav .grve-line');
				if( index >= base.sections.length - 1 ) {
					$line.addClass('grve-go-to-first');
				} else {
					$line.removeClass('grve-go-to-first');
				}
			},
			setActiveItem: function(index){
				var activeItem = $('#grve-section-nav .grve-section-slider').children()[index];
				$(activeItem).addClass('active').siblings().removeClass('active');
			},
			getSections: function(){
				var base = this,
					$section = $('[data-anchor-tooltip]'),
					sections = [];

				$section.each(function(){
					var $that = $(this),
						color = $that.data('header-color') !== undefined ? $that.data('header-color') : 'default',
						title = $that.data('anchor-tooltip'),
						target = $body.hasClass('elementor-page') ? $that.data('id') : $that.data('anchor');
					sections.push({
						'section': $that[0],
						'title': title,
						'target': target,
						'color': color
					});
				});

				return sections;
			},
			getSectionProp: function(){
				var base = this,
					prop = [];

				$.each( base.sections,function( index, value ){
					var $that = $(value.section),
						height =  parseInt( $that.outerHeight() ),
						top =  parseInt( $that.offset().top ),
						bottom = top + height;

					prop.push({
						'height': height,
						'top': top,
						'bottom': bottom
					});
				});
				return prop;
			},
			getNavItemsProp: function(){
				var base = this,
					$nav = $('#grve-section-nav .grve-section-slider'),
					$item = $nav.children(),
					// prop = [{'bottom':0}];
					prop = [];
				$.each( $item,function(){
					var $that = $(this),
						height =  $that.outerHeight(),
						top =  $that.position().top,
						bottom = top + height;

					prop.push({
						'bottom': bottom
					});
				});
				return prop;
			}
		},
		floatingNavBar: {
			selector: '.grve-navigation-bar.grve-layout-2',
			init: function(){
				var base = this,
					$nav = $(base.selector);
				base.show = false;
				if( $nav.length ) {
					var items = base.getItems( $nav );
					base.timeline = gsap.timeline({ paused:true });
					base.timeline.set( $nav, { visibility:'visible' });
					base.timeline.from( items, { duration:0.3, opacity:0, y:30, stagger:0.1 });
					base.updateParams( $nav );
				}
			},
			updateParams: function( $nav ){
				var base = this,
					top = $('#grve-theme-content .grve-single-wrapper').offset().top,
					wrapperH = $('#grve-theme-content .grve-single-wrapper').outerHeight(),
					windowH = $window.height(),
					bottom = (top + wrapperH) - windowH,
					$navItem = $nav.find('.grve-nav-item');
				base.params = {
					'start' : top,
					'end' : bottom
				};

				if( $window.width() + scrollBarWidth > tabletPortrait ) {
					// Hover Effect
					$navItem.on('mousemove.grve_navbar_mousemove', function( event ){
						var $image = $(this).find('.grve-media .grve-inner');
						if( $image.length ) {
							var positionL = this.getBoundingClientRect().left,
								positionT = this.getBoundingClientRect().top,
								pageX = event.clientX,
								pageY = event.clientY,
								xPosOfMouse = pageX - positionL,
								yPosOfMouse = pageY - positionT,
								xPosOfMouseInsideButton = xPosOfMouse - this.offsetWidth / 2,
								yPosOfMouseInsideButton = yPosOfMouse - this.offsetHeight / 2;
							gsap.to($image, {
								x: xPosOfMouseInsideButton,
								y: yPosOfMouseInsideButton,
								scale: 1,
								opacity: 1,
								duration: 0.6,
								ease: 'power3.out'
							});
						}
					});

					$navItem.on('mouseleave.grve_navbar_mouseleave', function( event ){
						var $image = $(this).find('.grve-media .grve-inner');
						if( $image.length ) {
							gsap.to($image, {
								x: 0,
								y: 0,
								scale: 0.9,
								opacity: 0,
								duration: 0.6,
								ease: 'power3.out'
							});
						}
					});
					base.canScroll = true;
					base.toggleNav(false);
				} else {
					$navItem.off('mousemove.grve_navbar_mousemove mouseleave.grve_navbar_mouseleave');
					base.canScroll = false;
					base.toggleNav(true);
				}
				base.resizing = false;
			},
			toggleNav: function(show){
				var base = this;
				if( show ) {
					base.scrolling = true;
					base.timeline.play();
				} else {
					base.scrolling = false;
					base.timeline.reverse();
				}
			},
			getItems: function( $nav ){
				var base = this,
					items = $.makeArray( $nav.find('.grve-nav-item') ),
					$backlink = $nav.find('.grve-backlink');
				if( $backlink.length ) {
					items.push( $backlink[0] );
				}
				return items;
			},
			onScroll: function(){
				var base = this,
					$nav = $(base.selector),
					scroll = $window.scrollTop();
				if( $nav.length && base.canScroll ) {
					if( scroll >= base.params.start && scroll <= base.params.end && !base.scrolling) {
						base.toggleNav(true);
					} else if( (scroll < base.params.start || scroll > base.params.end) && base.scrolling ) {
						base.toggleNav(false);
					}
				}
			},
			onResize: function(){
				var base = this,
					$nav = $(base.selector);
				if( $nav.length && !base.resizing ) {
					base.resizing = true;
					base.updateParams( $nav );
				}
			}
		},
		minimalNavBar: {
			selector: '.grve-navigation-bar.grve-layout-3',
			init: function(){
				var base = this,
					$nav = $(base.selector);
				if( $nav.length ) {
					base.updateParams( $nav );
				}
			},
			updateParams: function( $nav ){
				var base = this,
					$navItem = $nav.find('.grve-nav-item');

				if( $window.width() + scrollBarWidth > tabletPortrait ) {
					// Hover Effect
					$navItem.on('mousemove.grve_navbar_mousemove', function(){
						var direction = $(this).data('item');
						$(this).parent().removeClass('grve-hover-item-next grve-hover-item-prev');
						$(this).parent().addClass('grve-hover grve-hover-item-' + direction);
					});
					$navItem.on('mousemove.grve_navbar_mousemove', function( event ){
						var $image = $(this).find('.grve-media .grve-inner');
						if( $image.length ) {
							var positionL = this.getBoundingClientRect().left,
								positionT = this.getBoundingClientRect().top,
								pageX = event.clientX,
								pageY = event.clientY,
								xPosOfMouse = pageX - positionL,
								yPosOfMouse = pageY - positionT,
								xPosOfMouseInsideButton = xPosOfMouse - this.offsetWidth / 2,
								yPosOfMouseInsideButton = yPosOfMouse - this.offsetHeight / 2;
							gsap.to($image, {
								x: xPosOfMouseInsideButton,
								y: yPosOfMouseInsideButton,
								scale: 1,
								opacity: 1,
								duration: 0.6,
								ease: 'power3.out'
							});
						}
					});

					$navItem.on('mouseleave.grve_navbar_mouseleave', function( event ){
						var $image = $(this).find('.grve-media .grve-inner');
						if( $image.length ) {
							gsap.to($image, {
								x: 0,
								y: 0,
								scale: 0.9,
								opacity: 0,
								duration: 0.6,
								ease: 'power3.out'
							});
						}
						$(this).parent().removeClass('grve-hover');
					});
				} else {
					$navItem.off('mousemove.grve_navbar_mousemove mouseleave.grve_navbar_mouseleave');
				}
				base.resizing = false;
			},
			onResize: function(){
				var base = this,
					$nav = $(base.selector);
				if( $nav.length && !base.resizing ) {
					base.resizing = true;
					base.updateParams( $nav );
				}
			}
		},
		smallBlog: {
			init: function(){
				var base = this,
					$post = $('.grve-post-item.grve-small-style-2');
				if( $post.length ) {
					base.updateParams();
				}
			},
			updateParams: function(){
				var base = this,
					$post = $('.grve-post-item.grve-small-style-2');

				if( $window.width() + scrollBarWidth > tabletPortrait ) {
					// Hover Effect
					$document.on('mousemove.grve_navbar_mousemove', '.grve-post-item.grve-small-style-2', function( event ){
						var $image = $(this).find('.grve-media-inner');
						if( $image.length ) {
							var positionL = this.getBoundingClientRect().left,
								positionT = this.getBoundingClientRect().top,
								pageX = event.clientX,
								pageY = event.clientY,
								xPosOfMouse = pageX - positionL,
								yPosOfMouse = pageY - positionT,
								xPosOfMouseInsideButton = xPosOfMouse - this.offsetWidth / 2,
								yPosOfMouseInsideButton = yPosOfMouse - this.offsetHeight / 2;
							gsap.to($image, {
								x: xPosOfMouseInsideButton * 0.3,
								y: yPosOfMouseInsideButton * 0.3,
								scale: 1,
								opacity: 1,
								duration: 0.6,
								ease: 'power3.out'
							});
						}
					});

					$document.on('mouseleave.grve_navbar_mouseleave', '.grve-post-item.grve-small-style-2', function( event ){
						var $image = $(this).find('.grve-media-inner');
						if( $image.length ) {
							gsap.to($image, {
								x: 0,
								y: 0,
								scale: 0.9,
								opacity: 0,
								duration: 0.6,
								ease: 'power3.out'
							});
						}
					});
				} else {
					$post.off('mousemove.grve_navbar_mousemove mouseleave.grve_navbar_mouseleave');
				}
				base.resizing = false;
			},
			onResize: function(){
				var base = this,
					$post = $('.grve-post-item.grve-small-style-2');
				if( $post.length && !base.resizing ) {
					base.resizing = true;
					base.updateParams();
				}
			}
		},
		socialBar: {
			selector: '.grve-social-bar.grve-layout-1',
			init: function(){
				var base = this;
				base.show = true;
				base.onScroll();
			},
			onScroll: function(){
				var base = this,
					$socials = $(base.selector);
				if( $socials.length ){
					var scroll = $window.scrollTop(),
						$content = $('#grve-theme-content'),
						contentH = $content.outerHeight(),
						contentT = $content.offset().top,
						contetnB = contentH + contentT,
						windowH = $window.height();

					if( scroll > contetnB - windowH && base.show ) {
						base.show = false;
						$socials.addClass('grve-hide');
					} else if( scroll <= contetnB - windowH && !base.show ) {
						base.show = true;
						$socials.removeClass('grve-hide');
					}
				}
			}
		},
		videos: {
			init: function(){
				this.fitVid();
				this.removeVideoBg();
				this.addVideoBg();
			},
			fitVid: function(){
				$('.grve-video, .grve-media').fitVids();
				var $youtubeFrame = $('iframe[src*="youtube"]'),
					$vimeoFrame = $('iframe[src*="vimeo"]');
				$youtubeFrame.each(function(){
					if( !$(this).parents().is('.wp-block-embed') ) {
						$(this).parent().fitVids();
					}
				});
				$vimeoFrame.each(function(){
					if( !$(this).parents().is('.wp-block-embed') ) {
						$(this).parent().fitVids();
					}
				});
			},
			addVideoBg: function(){
				var base = this;
				$('.grve-yt-bg-video').each(function() {
					var $videoBgWrapper = $(this);
					var youtubeUrl = $videoBgWrapper.data("video-bg-url");
					var youtubeID = youtubeUrl.match( /[\\?&]v=([^&#]*)/ )[ 1 ];
					if( '' !== youtubeID ) {
						insertYouTubeVideo($videoBgWrapper, youtubeID );
					}
				});
				$('.grve-vimeo-bg-video').each(function() {
					var $element = $(this);
					if ("undefined" != typeof Vimeo ) {
						var videoPlayer = new Vimeo.Player( $element.attr('id') );
						videoPlayer.on('loaded', function() {
							GRVE.pageSettings.videos.resizeVideoBgElement( $element );
						});
					}
				});
				function insertYouTubeVideo($element, youtubeId, counter) {
					if ("undefined" == typeof YT || "undefined" === typeof YT.Player) {
						counter = "undefined" === typeof counter ? 0 : counter;
						if (100 < counter) {
							console.warn("Too many attempts to load YouTube api");
							return;
						}
						setTimeout(function() {
							insertYouTubeVideo($element, youtubeId, counter++);
						}, 100);
						return;
					}
					var startSeconds = $element.data('video-start') !== undefined ? parseInt( $element.data('video-start') ) : 0;
					var endSeconds = $element.data('video-end') !== undefined ? parseInt( $element.data('video-end') ) : 0;
					var $container = $element.prepend('<div class="grve-bg-youtube-video"><div class="inner"></div></div>').find(".inner");
					var ytPlayer = new YT.Player($container[0], {
						width: "100%",
						height: "100%",
						videoId: youtubeId,
						playerVars: {
							playlist: youtubeId,
							modestbranding: 1,
							iv_load_policy: 3,
							enablejsapi: 1,
							disablekb: 1,
							autoplay: 1,
							controls: 0,
							showinfo: 0,
							rel: 0,
							loop: 1,
							wmode: "transparent",
							playsinline: 1,
							start: startSeconds,
							end: endSeconds,
						},
						events: {
							'onReady': onPlayerReady,
							'onStateChange': onPlayerStateChange
						}
					});
					function onPlayerReady(event) {
						event.target.mute().setLoop(true);
					}
					function onPlayerStateChange(event) {
						if ( 0 !== startSeconds || 0 !== endSeconds ) {
							if (event.data === YT.PlayerState.ENDED) {
								ytPlayer.loadVideoById({
									videoId: youtubeId,
									startSeconds: startSeconds,
									endSeconds: endSeconds
								});
							}
						}
					}
					// Resize Video
					base.resizeVideoBgElement( $element );
				}
			},
			resizeVideoBg: function(){
				var base = this;
				$videoBg.each(function(){
					base.resizeVideoBgElement( $(this) );
				});
			},
			resizeVideoBgElement: function( $element ){
				var videoEl,
					videoW,
					videoH,
					marginLeft,
					marginTop,
					containerW = $element.innerWidth(),
					containerH = $element.innerHeight(),
					ratio1 = 16,
					ratio2 = 9;

				if (containerW / containerH < ratio1 / ratio2) {
					videoW = containerH * (ratio1 / ratio2);
					videoH = containerH;
					marginLeft = -Math.round((videoW - containerW) / 2) + 'px';
					marginTop = -Math.round((videoH - containerH) / 2) + 'px';
					videoW += 'px';
					videoH += 'px';
				} else {
					videoW = containerW;
					videoH = containerW * (ratio2 / ratio1);
					marginTop = -Math.round((videoH - containerH) / 2) + 'px';
					marginLeft = -Math.round((videoW - containerW) / 2) + 'px';
					videoW += 'px';
					videoH += 'px';
				}
				if( $element.hasClass('grve-yt-bg-video') || $element.hasClass('grve-vimeo-bg-video') ) {
					videoEl = 'iframe';
				}

				$element.find( videoEl ).css({
					maxWidth: '1000%',
					marginLeft: marginLeft,
					marginTop: marginTop,
					width: videoEl == 'iframe' ? videoW : '',
					height: videoH
				});
			},
			removeVideoBg: function(){
				$('.grve-background-wrapper').each(function () {
					var $wrapper = $(this),
						$bgImage = $wrapper.find('.grve-bg-image'),
						$bgVideo = $wrapper.find('.grve-bg-video'),
						$bgHtml5Video = $wrapper.find('.grve-html5-bg-video'),
						$bgVimeoVideo = $wrapper.find('.grve-vimeo-bg-video'),
						$bgYtVideo = $wrapper.find('.grve-yt-bg-video'),
						$bgVideoButton = $wrapper.find('.grve-bg-video-button-device');

					var bgVideoDevice = $bgVideo.data('video-device') !== undefined ? $bgVideo.data('video-device') : 'no';
					if( GRVE.helpers.isMobile.any() && 'no' === bgVideoDevice) {
						$bgVideo.remove();
					} else {
						if ( $bgHtml5Video.length ) {
							var $videoElement = $wrapper.find('.grve-bg-video video');
							var canPlayVideo = false;
							$wrapper.find('.grve-bg-video source').each(function(){
								if ( $videoElement.get(0).canPlayType( $(this).attr('type') ) ) {
									canPlayVideo = true;
								}
							});
							if(canPlayVideo) {
								$bgImage.remove();
							} else {
								$bgVideo.remove();
							}
						}
						if ( $bgYtVideo.length || $bgVimeoVideo.length ) {
							$bgImage.remove();
						}
						if ( $bgVideoButton.length ) {
							$bgVideoButton.remove();
						}
					}
				});
			},
		},
		basicAnimations: {
			init: function(){
				var base = this;
				base.setAnimatedText();
				base.setClippingWrappers();
				base.setAppearWrappers();
				$window.on('grve_after_page_transition grve_safebutton_open grve_modal_open',function(){
					base.animAppear();
				});
			},
			setAnimatedText: function(){
				var $element = $('.grve-animated-text');
				if( GRVE.helpers.isMobile.any() && !deviceAnimAppear ) {

				} else {
					$element.each(function(){
						var $that = $(this),
							$line = $that.find('.grve-line'),
							style = $that.data('style');

							$line.each(function(){
								var $that = $(this),
									textArr = $that.text();
								$that.data('text',textArr);
								if( style === 'style-2' || style === 'style-3' ) {
									var textArr = textArr.trim(),
										textArr = textArr.split(' ');
									$that[0].innerHTML = '';
									for (var i = 0; i < textArr.length; i++) {
										if( style === 'style-2') {
											$that[0].innerHTML += '<span class="grve-word"><span>' + textArr[i] + '</span></span> ';
										} else {
											$that[0].innerHTML += '<span class="grve-word">' + textArr[i] + '</span> ';
										}
									}
								} else {
									$that.wrapInner( '<span></span>');
								}
							});
							if( style === 'style-3') {
								var $word = $that.find('.grve-word');
								$word.each(function(){
									var $that = $(this),
										textArr = $that.text(),
										textArr = textArr.trim(),
										textArr = textArr.split('');
									$that[0].innerHTML = '';
									for (var i = 0; i < textArr.length; i++) {
										$that[0].innerHTML += '<span class="grve-character">' + textArr[i] + '</span>';
									}
								});
							}
					});
				}
			},
			setClippingWrappers: function(){
				var $element = $('.grve-clipping-animation'),
					wrapper = '<div class="grve-clipping-wrapper grve-animation-wrapper"><div class="grve-clipping-content"></div></div>',
					clippingItems = [];
				if( GRVE.helpers.isMobile.any() && !deviceAnimAppear ) {
					$element.removeClass('grve-clipping-animation');
				} else {
					// Remove animation from Menu Area Item
					$element.each(function(){
						var $that = $(this);
						if( $that.parents('#grve-header').length === 0 ){
							clippingItems.push( $that );
						} else {
							$that.removeClass('grve-clipping-animation');
						}
					});

					$.each(clippingItems, function(){
						var $that = $(this);
						$that.wrapInner( wrapper );
						var $wrapper = $that.find('.grve-clipping-wrapper');
						if( $that.hasClass('grve-colored-clipping') ) {
							var color = $that.data('clipping-color'),
								overlay = '<div class="grve-clipping-overlay grve-bg-' + color + '"></div>';
							$(overlay).appendTo( $wrapper );
						}
					});
				}
			},
			setAppearWrappers: function(){
				var $element = $('.grve-appear-animation'),
					wrapper = '<div class="grve-appear-wrapper grve-animation-wrapper"><div class="grve-appear-content"></div></div>',
					appearItems = [];

				if( GRVE.helpers.isMobile.any() && !deviceAnimAppear ) {
					$element.removeClass('grve-appear-animation');
				} else {
					// Remove animation from Menu Area Item
					$element.each(function(){
						var $that = $(this);
						if( $that.parents('#grve-header').length === 0 ){
							appearItems.push( $that );
						} else {
							$that.removeClass('grve-appear-animation');
						}
					});
					$.each(appearItems, function(){
						var $that = $(this);
						$that.wrapInner( wrapper );
					});
				}
			},
			animAppear: function(){
				var base = this,
					$animationItem = $('.grve-animated-item'),
					animItems = [];
				if( $body.hasClass('page-template-template-full-page') ){
					return;
				}

				if( GRVE.helpers.isMobile.any() && !deviceAnimAppear ) {
					$animationItem.removeClass('grve-animated-item');
				} else {
					// Remove animation from Menu Area Item
					$animationItem.each(function(){
						var $that = $(this);
						if( $that.parents('#grve-header').length === 0 ){
							animItems.push( $that );
						} else {
							$that.removeClass('grve-animated-item');
						}
					});

					$.each(animItems, function(){
						var $that = $(this);
						if( $that.is(':visible') && !$that.hasClass('grve-animating') ) {
							$that.appear(function() {
								base.elementAnimation( $that );
							},{accX: 0, accY: -150});
						}
					});
				}
				$('.grve-underline').each(function(){
					var $that = $(this),
						$parent = $that.parents('.grve-element');
					if( $that.is(':visible') && !$parent.hasClass('grve-animated-item') ) {
						$that.appear(function() {
							$that.addClass('grve-active');
						},{accX: 0, accY: -150});
					}
				});
			},
			elementAnimation: function( $element ){
				var base = this,
					animation = $element.data('animation'),
					timeDelay = parseInt($element.data('delay'))/1000,
					duration = $element.data('duration');

				if( $element.parents('.grve-animated-item').length ){
					return;
				}

				// Clipping Animation
				if( $element.hasClass('grve-clipping-animation') ){
					if( $element.hasClass('grve-colored-clipping') ){
						base.clippingColoredAnimation( $element, animation, timeDelay, duration );
					} else {
						base.clippingAnimation( $element, animation, timeDelay, duration );
					}
				} else if( $element.hasClass('grve-appear-animation') ) {
					base.appearAnimation( $element, animation, timeDelay, duration );
				} else if( $element.hasClass('grve-animated-text') ) {
					base.animatedText( $element, timeDelay, duration );
				} else {
					base.classicAnimation( $element, animation, timeDelay, duration );
				}
			},
			classicAnimation: function( elements, animation, delay, duration ){
				var base = this,
					params = $.extend(base.getAnimParams( animation, duration ), {force3D: true, ease:'easeOutCubic', stagger: 0.3}),
					animation = gsap.timeline({delay:delay, onComplete: callback });
					animation
					.set(elements,{visibility:'visible'})
					.fromTo(elements, params, {x:'0%', y:'0%', opacity: 1, scale: 1});
				function callback(){
					$.each(elements,function(){
						$(this).addClass('grve-animating').parent().css('overflow','visible');
						var $underline = $(this).find('.grve-underline');
						if( $underline.length ) {
							$underline.addClass('grve-active');
						}
					});
				}
			},
			animatedText: function( $element, delay, duration ){
				var base = this,
					elements = [],
					stagger = 0.1;
				if( $element.data('style') === 'style-1' ) {
					elements = $.makeArray( $element.find('.grve-line > span') );
					stagger = 0.5;
				} else if( $element.data('style') === 'style-2' ){
					elements = $.makeArray( $element.find('.grve-word > span') );
					stagger = 0.2;
				} else {
					elements = $.makeArray( $element.find('.grve-character') );
					stagger = 0.2;
				}
				var params = base.getAnimParams( '', duration ),
					animation = gsap.timeline({delay:delay, onComplete: callback });
					animation
					.set(elements,{visibility:'visible'})
					.from(elements, {y:'100%', force3D: true, duration: params.duration, ease:'easeOutCubic', stagger: params.duration * stagger});

				function callback(){
					$element.removeClass('grve-animated-item');
					var $line = $element.find('.grve-line');
					$line.each(function(){
						var $that = $(this),
							text = $that.data('text');
						$that.parent().html( text ).css('overflow','visible');
					});
				}
			},
			clippingAnimation: function( $element, animation, delay, duration ){
				var base = this,
					$wrapper = $element.find('.grve-clipping-wrapper'),
					$content = $element.find('.grve-clipping-content'),
					contentAnim;

					switch (animation) {
						case 'clipping-left':
							contentAnim = 'clipping-right';
							break;
						case 'clipping-right':
							contentAnim = 'clipping-left';
							break;
						case 'clipping-up':
							contentAnim = 'clipping-down';
							break;
						case 'clipping-down':
							contentAnim = 'clipping-up';
							break;
						default:
							contentAnim = 'clipping-right';
					}

					var wrapperParams = $.extend( base.getAnimParams( animation, duration ), {force3D: true, ease:'easeOutCubic'}),
						contentParam = $.extend( base.getAnimParams( contentAnim, duration ), {force3D: true, ease:'easeOutCubic'});
						animation = gsap.timeline({delay:delay, onComplete: callback });

					animation
					.set($element,{visibility:'visible'})
					.from($wrapper, wrapperParams)
					.from($content, contentParam, '<');

				function callback(){
					$element.addClass('grve-animating');
				}
			},
			clippingColoredAnimation: function( $element, animation, delay, duration ) {
				var base = this,
					$overlay = $element.find('.grve-clipping-overlay'),
					$content = $element.find('.grve-clipping-content'),
					animationIn = animation + '-in',
					animationOut = animation + '-out',
					animationInParams = $.extend( base.getAnimParams( animationIn, duration ), {force3D: true, ease:'easeOutCubic'}),
					animationOutParams = $.extend( base.getAnimParams( animationOut, duration ), {force3D: true, ease:'easeOutCubic'}),
					animation = gsap.timeline({delay:delay, onComplete: callback });

					animation
					.set($element,{visibility:'visible'})
					.from($overlay, animationInParams)
					.set($content,{visibility:'visible'})
					.to($overlay, animationOutParams);

				function callback(){
					$element.addClass('grve-animating');
				}
			},
			appearAnimation: function( $element, animation, delay, duration ){
				var base = this,
					$content = $element.find('.grve-appear-content'),
					contentParam = $.extend( base.getAnimParams( animation, duration ), {force3D: true, ease:'easeOutCubic'}),
					animation = gsap.timeline({delay:delay, onComplete: callback });

					animation
					.set($element,{visibility:'visible'})
					.fromTo($content, contentParam, {x:'0%', y:'0%'});

				function callback(){
					$element.addClass('grve-animating');
				}
			},
			getAnimParams: function( animation, duration ){
				var param = {};

				var translate = 100,
					translateBig = 300;

				switch (duration) {
					case 'very-fast':
						param.duration = 0.2;
						break;
					case 'fast':
						param.duration = 0.4;
						break;
					case 'normal':
						param.duration = 0.6;
						break;
					case 'slow':
						param.duration = 1.2;
						break;
					case 'very-slow':
						param.duration = 1.5;
						break;
					default:
						param.duration = 0.6;
				}

				switch (animation) {
					case 'fade-in':
						param.opacity = 0;
						break;
					case 'fade-in-up':
						param.y = translate;
						param.opacity = 0;
						break;
					case 'fade-in-up-big':
						param.y = translateBig;
						param.opacity = 0;
						break;
					case 'fade-in-down':
						param.y = '-' + translate;
						param.opacity = 0;
						break;
					case 'fade-in-down-big':
						param.y = '-' + translateBig;
						param.opacity = 0;
						break;
					case 'fade-in-left':
						param.x = '-' + translate;
						param.opacity = 0;
						break;
					case 'fade-in-left-big':
						param.x = '-' + translateBig;
						param.opacity = 0;
						break;
					case 'fade-in-right':
						param.x = translate + 'px';
						param.opacity = 0;
						break;
					case 'fade-in-right-big':
						param.x = translateBig + 'px';
						param.opacity = 0;
						break;
					case 'zoom-in':
						param.scale = 0;
						break;
					case 'zoom-out':
						param.scale = 2;
						break;
					case 'clipping-left':
					case 'appear-left':
						param.x = '-101%';
						break;
					case 'clipping-right':
					case 'appear-right':
						param.x = '101%';
						break;
					case 'clipping-up':
					case 'appear-up':
						param.y = '-101%';
						break;
					case 'clipping-down':
					case 'appear-down':
						param.y = '101%';
						break;
					case 'colored-clipping-left-in':
						param.x = '-101%';
						break;
					case 'colored-clipping-left-out':
						param.x = '101%';
						break;
					case 'colored-clipping-right-in':
						param.x = '101%';
						break;
					case 'colored-clipping-right-out':
						param.x = '-101%';
						break;
					case 'colored-clipping-up-in':
						param.y = '-101%';
						break;
					case 'colored-clipping-up-out':
						param.y = '101%';
						break;
					case 'colored-clipping-down-in':
						param.y = '101%';
						break;
					case 'colored-clipping-down-out':
						param.y = '-101%';
						break;
					}

				return param;
			}
		},
		hoverEffects: {
			init: function(){
				this.deviceHover();
				this.tiltEffect();
				this.thumbMouseMove();
				this.bgImageMouseMove();
				this.indicator();
				this.hoverSplitText();
				this.imageDominant();
				this.magnetism();
			},
			deviceHover: function(){
				var $hoverItem = $('.grve-hover-item');
				if( GRVE.helpers.isMobile.any() && 0 == impeka_grve_main_data.device_hover_single_tap ) {
					var touchevent = 'touchend mouseenter';
					if( $hoverItem.parent().parent().hasClass('grve-carousel-item') ) {
						touchevent = 'touchstart';
					}
					$document.on(touchevent, '.grve-hover-item', function(e) {
						var $item = $(this);
						if ( !$item.hasClass('hover') ) {
							$item.addClass('hover');
							$hoverItem.not(this).removeClass('hover');
							e.preventDefault();
						}
					});
					$document.on('touchstart touchend', function(e) {
						if ( !$hoverItem.is(e.target) && $hoverItem.has(e.target).length === 0 ) {
							$hoverItem.removeClass('hover');
						}
					});
				} else {
					$document.on('mouseenter mouseleave', '.grve-hover-item', function() {
						$(this).toggleClass('hover');
					});
				}
			},
			tiltEffect: function(){
				$document.on('mousemove.grve_tilt_mousemove', '.grve-tilt-effect', function( event ){
					var $element = $(this),
						$inner = $element.find('.grve-tilt-inner'),
						mouseX = event.pageX,
						mouseY = event.pageY,
						xPos = ($element.width() / 2) - (mouseX - $element.offset().left),
						yPos = ($element.height() / 2) - (mouseY - $element.offset().top),
						rotationYValue = yPos / $element.height() * 10,
						rotationXValue = xPos / $element.width() * 10;

					gsap.to( $inner, {
						duration: 0.6,
						rotationY: rotationXValue,
						rotationX: rotationYValue,
						scale: 1.1,
						ease:Power1.easeOut,
						transformPerspective: 900,
						transformOrigin: 'center',
						force3D: true
					});
				});

				$document.on('mouseleave.grve_tilt_mousemove', '.grve-tilt-effect', function( event ){
					var $element = $(this),
						$inner = $element.find('.grve-tilt-inner');
					gsap.to( $inner, {
						duration: 0.6,
						rotationY: 0,
						rotationX: 0,
						scale: 1,
						ease:Power1.easeOut,
						transformPerspective: 900,
						transformOrigin: 'center',
						force3D: true
					});
				});
			},
			thumbMouseMove: function(){
				$document.on('mousemove.grve_thumb_mousemove', '.grve-thumb-mouse-move', function( event ){
					var $element = $(this),
						limit = 60,
						$thumb = $element.find('img'),
						mouseX = event.pageX,
						mouseY = event.pageY,
						elemenW = $element.width(),
						elemenH = $element.height(),
						xPos = (elemenW / 2) - (mouseX - $element.offset().left),
						yPos = (elemenH / 2) - (mouseY - $element.offset().top),
						rotationYValue = yPos / elemenH * limit,
						rotationXValue = xPos / elemenW * limit,
						scaleX = ((elemenW + limit + 5) / elemenW).toFixed(2),
						scaleY = ((elemenH + limit + 5) / elemenH).toFixed(2),
						scale = Math.max(scaleX, scaleY);

					if( $thumb.length ) {
						gsap.to( $thumb, {
							duration: 0.6,
							y: rotationYValue,
							x: rotationXValue,
							scale: scale,
							ease:Power1.easeOut,
							transformPerspective: 900,
							transformOrigin: 'center',
							force3D: true
						});
					}
				});

				$document.on('mouseleave.grve_thumb_mousemove', '.grve-thumb-mouse-move', function( event ){
					var $element = $(this),
						$thumb = $element.find('img');
						if( $thumb.length ) {
							gsap.to( $thumb, {
								duration: 0.6,
								y: 0,
								x: 0,
								scale: 1,
								ease:Power1.easeOut,
								transformPerspective: 900,
								transformOrigin: 'center',
								force3D: true
							});
						}
				});

			},
			bgImageMouseMove: function(){
				$document.on('mousemove.grve_thumb_mousemove', '.grve-bg-mouse-move', function( event ){
					var $element = $(this),
						limit = 60,
						$thumb = $element.find('.grve-bg-image'),
						mouseX = event.pageX,
						mouseY = event.pageY,
						elemenW = $element.width(),
						elemenH = $element.outerHeight(),
						xPos = (elemenW / 2) - (mouseX - $element.offset().left),
						yPos = (elemenH / 2) - (mouseY - $element.offset().top),
						rotationYValue = yPos / elemenH * limit,
						rotationXValue = xPos / elemenW * limit,
						scaleX = ((elemenW + limit + 5) / elemenW).toFixed(2),
						scaleY = ((elemenH + limit + 5) / elemenH).toFixed(2),
						scale = Math.max(scaleX, scaleY);

						if( $thumb.length ) {
							gsap.to( $thumb, {
								duration: 0.6,
								y: rotationYValue,
								x: rotationXValue,
								scale: scale,
								ease:Power1.easeOut,
								transformPerspective: 900,
								transformOrigin: 'center',
								force3D: true
							});
						}
				});

				$document.on('mouseleave.grve_thumb_mousemove', '.grve-bg-mouse-move', function( event ){
					var $element = $(this),
						$thumb = $element.find('.grve-bg-image');
						if( $thumb.length ) {
							gsap.to( $thumb, {
								duration: 0.6,
								y: 0,
								x: 0,
								scale: 1,
								ease:Power1.easeOut,
								transformPerspective: 900,
								transformOrigin: 'center',
								force3D: true
							});
						}
				});

			},
			indicator: function(){
				var $indicator = $('#grve-indicator'),
					$inner = $indicator.find('.grve-inner'),
					$defaultCursor = $indicator.find('.grve-default');
				if( GRVE.helpers.isMobile.any() ) {
					return;
				}
				if( $indicator.length && $body.hasClass('grve-theme-indicator') ) {
					$document.on('mousemove.grve_indicator_mousemove', function( event ){
						var contentL = $body.offset().left != undefined ? $body.offset().left : 0,
							posX = event.clientX - contentL + frameSize,
							posY = event.clientY;
						gsap.to( $indicator, { duration:0.3, x:posX, y:posY, display: 'block', force3D:true });
					});
					$document.on('mouseenter.grve_indicator_mouseenter','[data-indicator]', function( event ){
						var type = $(this).data('indicator'),
							color = $(this).data('indicator-color'),
							$item = $indicator.find('.grve-ind-' + type );

							$indicator.removeClass('grve-blend');
							$indicator.addClass('grve-item-hover');
							$item.addClass('grve-active');
							if( 'content' === type ) {
								var content = $(this).find('.grve-indicator-content').html();
								$item.html( content );
								$defaultCursor.addClass('grve-indicator-hide');
							} else {
								$defaultCursor.addClass('grve-indicator-expand');
							}
							if( 'text' === type ) {
								var text = $(this).data('indicator-text');
								$item.children().html( text );
							}
							if( 'none' !== type ) {
								if( undefined !== color && 'content' !== type ) {
									$defaultCursor.addClass('grve-bg-' + color);
									if( 'white' === color ) {
										$item.addClass('grve-text-black grve-svg-black');
									} else {
										$item.addClass('grve-text-white grve-svg-white');
									}
								} else if( undefined === color && 'content' !== type ) {
									$item.addClass('grve-text-white grve-svg-white');
									$defaultCursor.addClass('grve-bg-primary-1');
								}
							}
					});
					$document.on('mouseleave.grve_indicator_mouseleave','[data-indicator]', function( event ){
						var type = $(this).data('indicator'),
							$item = $indicator.find('.grve-ind-' + type ),
							color = $(this).data('indicator-color');

						if( undefined !== color && 'content' !== type ) {
							$defaultCursor.removeClass('grve-bg-' + color);
							if( 'white' === color ) {
								$item.removeClass('grve-text-black grve-svg-black');
							} else {
								$item.removeClass('grve-text-white grve-svg-white');
							}
						} else if( undefined === color && 'content' !== type ) {
							$item.removeClass('grve-text-white grve-svg-white');
							$defaultCursor.removeClass('grve-bg-primary-1');
						}
						$defaultCursor.removeClass('grve-indicator-expand grve-indicator-hide');
						$item.removeClass('grve-active');
						$indicator.addClass('grve-blend');
						$indicator.removeClass('grve-item-hover');
					});

					$document.on('mouseenter.grve_indicator_mouseenter','a', function( event ){
						if( $(this).parents('.grve-hide-indicator').length || $(this).hasClass('grve-hide-indicator') ) {
							$defaultCursor.addClass('grve-indicator-hide');
						} else if( $(this).parents('.grve-header-menu').length || $(this).parents('.grve-menu-element').length || $(this).parents('.grve-widget').length ) {
							$defaultCursor.addClass('grve-indicator-small');
						} else if( $(this).parents('div[data-indicator]').length ) {
							return;
						} else {
							$defaultCursor.addClass('grve-indicator-expand');
						}
					});
					$document.on('mouseleave.grve_indicator_mouseleave','a', function( event ){
						$defaultCursor.removeClass('grve-indicator-expand grve-indicator-small grve-indicator-hide');
					});
				} else if( $indicator.length && !$body.hasClass('grve-theme-indicator') ) {

					$document.on('mousemove.grve_indicator_mousemove','[data-indicator]', function( event ){
						var type = $(this).data('indicator'),
							color = $(this).data('indicator-color'),
							$item = $indicator.find('.grve-ind-' + type ),
							contentL = $body.offset().left != undefined ? $body.offset().left : 0,
							posX = event.clientX - contentL,
							posY = event.clientY;

						gsap.to( $indicator, { duration:0.3, opacity: 1, scale: 1, x:posX, y:posY, display: 'block', force3D:true });
						$indicator.removeClass('grve-blend');
						$item.addClass('grve-active');
						$indicator.addClass('grve-item-hover');
						if( 'content' === type ) {
							var content = $(this).find('.grve-indicator-content').html();
							$item.html( content );
							$defaultCursor.addClass('grve-indicator-hide');
						} else {
							$defaultCursor.addClass('grve-indicator-expand').removeClass('grve-indicator-hide');;
						}
						if( 'text' === type ) {
							var text = $(this).data('indicator-text');
							$item.children().html( text );
						}
						if( 'none' !== type ) {
							if( undefined !== color && 'content' !== type ) {
								$defaultCursor.addClass('grve-bg-' + color);
								if( 'white' === color ) {
									$item.addClass('grve-text-black grve-svg-black');
								} else {
									$item.addClass('grve-text-white grve-svg-white');
								}
							} else if( undefined === color && 'content' !== type ) {
								$item.addClass('grve-text-white grve-svg-white');
								$defaultCursor.addClass('grve-bg-primary-1');
							}
						}
					});
					$document.on('mouseleave.grve_indicator_mouseleave','[data-indicator]', function( event ){
						var type = $(this).data('indicator'),
							color = $(this).data('indicator-color'),
							$item = $indicator.find('.grve-ind-' + type );
						$item.removeClass('grve-active grve-text-black grve-svg-black');
						$indicator.removeClass('grve-item-hover');
						$defaultCursor.removeClass('grve-bg-' + color);
						gsap.to( $indicator, { duration:0.3, opacity: 0, scale: 0, display: 'none' });
					});
				}
			},
			hoverSplitText: function(){
				var $hoverItem = $('.grve-with-split-text');
				$hoverItem.each(function(){
					var $that = $(this),
						$title = $that.find('.grve-title'),
						$description = $that.find('.grve-description');
					if( $title.length ) {
						GRVE.helpers.splitText( $title, 'text', 20 );
					}
				});
			},
			imageDominant: function(){
				var $overlay = $('.grve-bg-dominant');
				$overlay.each(function(){
					var $that = $(this),
						$element = $that.parent(),
						$image = $element.find('img');
					if( !$image.length ) { return; }
					var colorThief = new ColorThief(),
						img = new Image();

					function imageUrl(input) {
						return input.replace(/"/g,"").replace(/url\(|\)$/ig, "");
					}
					img.src = imageUrl( $image.attr('src') );
					img.onload = function () {
						var result = colorThief.getColor(img),
							r = result[0],
							g = result[1],
							b = result[1];

						$that.css({
							'background-color' : 'rgb(' + r + ',' + g + ',' + b + ')'
						});
					};
				});
			},
			magnetismElements: function(){
				var elements = [
					{ el: '.grve-team.grve-layout-3.grve-mouse-move', item: '.grve-team-person' },
					{ el: '.grve-team.grve-layout-4.grve-mouse-move', item: '.grve-team-person' },
					{ el: '.grve-btn-text.grve-with-svg-icon-arrow-1', item: '.grve-btn-svg-icon', movement: 10 },
					{ el: '.grve-safebutton-icon-wrapper', item: '.grve-safe-button', movement: 20 },
					{ el: '.grve-close-button-wrapper', item: '.grve-close-btn', movement: 20 },
					{ el: '.grve-column.grve-magnetism', item: '.grve-column-wrapper', movement: 20 },
					{ el: '.grve-column-inner.grve-magnetism', item: '.grve-column-wrapper-inner', movement: 20 },
					{ el: '.grve-backlink', item: 'a', movement: 20 },
				];
				return elements;
			},
			magnetism: function(){
				var elements = this.magnetismElements();

				$.each(elements,function(index,value){
					var movement = value.movement != undefined ? value.movement : 20;
					$document.on('mouseenter', value.el, function(){
						var $item = $(this).find( value.item );
						gsap.to($item, { duration:0.3, scale:1.1 });
					});
					$document.on('mouseleave click', value.el, function(){
						var $item = $(this).find( value.item );
						gsap.to($item, { duration:0.3, scale:1, x:0, y:0 });
					});
					$document.on('mousemove', value.el, function(e){
						var $item = $(this).find( value.item );
						parallaxIt(e, this, $item, movement);
					});
				});

				function parallaxIt(e, parent, target, movement) {
					var boundingRect = parent.getBoundingClientRect(),
						relX = e.pageX - $(parent).offset().left,
						relY = e.pageY - $(parent).offset().top,
						parentW = boundingRect.width,
						parentH = boundingRect.height;

					gsap.to(target, {
						duration: 0.3,
						x: (relX - parentW / 2) / parentW * movement,
						y: (relY - parentH / 2) / parentH * movement,
						ease: Power2.easeOut
					});
				}
			}
		},
		listTitleGrid: {
			init: function(){
				var base = this;
				$('.grve-list-title-grid').each(function(){
					var $wrapper = $(this),
						displayStyle = $wrapper.data('display-style'),
						$container = $wrapper.find('.grve-list-grid'),
						originLeft = true;
					if( $body.hasClass('rtl')) {
						originLeft = false;
					}
					base.filtersCounter( $wrapper );

					// Filters
					var filterArr = [],
						$filters = $wrapper.find('.grve-filter'),
						$filter = $filters.find('li'),
						$filterSelect = $wrapper.find('.grve-filters-select');

					$filter.each(function(){
						var selector = $(this).data('filter');
						if( filterArr.indexOf(selector) === -1 ) {
							filterArr.push(selector);
						}
					});

					$filters.on('click', 'li', function(){
						var selector     = $(this).data('filter'),
							title        = $(this).html(),
							$curCategory = $(this).parent().find('.grve-current-category'),
							gototop      = $(this).parents('.grve-filter').attr('data-gototop') == 'yes' ? true : false;

						if( $curCategory.length > 0 ){
							$curCategory.find('span').html( title );
						}

						$container.isotope({
							filter: selector
						});

						// Go to top
						if( gototop && 'infinite-scroll' !== displayStyle && 'load-more' !== displayStyle ) {
							GRVE.helpers.linkGoToTop( $(this).parent(), 300, 30 );
						}
						$(this).addClass('selected').siblings().removeClass('selected');
					});

					// Drop Down Filters
					$filterSelect.on( 'change', function() {
						var selector = this.value;
						$container.isotope({
							filter: selector
						});
					});

					$container.isotope({
						itemSelector: '.grve-list-item',
						layoutMode: 'fitRows',
						originLeft: originLeft,
					}).isotope( 'layout' );
					base.toggleImage( $wrapper );
					$wrapper.css('visibility','visible');
				});
			},
			toggleImage: function( $element ){
				var images = $.makeArray( $element.find('.grve-list-image') ),
					$item = $element.find('.grve-list-item');
				$element.on('mouseenter', '.grve-list-item',function(){
					var $that = $(this),
						index = $that.index(),
						$image = $(images[index]);
					$that.addClass('grve-active').siblings().addClass('grve-hide');
					$image.addClass('grve-active').siblings().removeClass('grve-active');
				});
				$element.on('mouseleave','.grve-list-item',function(){
					var $that = $(this),
						index = $that.index(),
						$image = $(images[index]);
					$that.removeClass('grve-active').siblings().removeClass('grve-hide');
					$image.removeClass('grve-active');
				});
			},
			filtersCounter: function( $wrapper ){
				var base = this,
					$filters = $wrapper.find('.grve-filter.grve-filter-style-count'),
					counter = '<div class="grve-count"><span></span></div>',
					filterClasses = [];
				if( $filters.length ) {
					var $filter = $filters.find('li');
					$filter.each(function(){
						var $that = $(this),
						filterClass = $that.data('filter');
						if( -1 === filterClasses.indexOf( filterClass ) ) {
							filterClasses.push( filterClass );
						}
						if( !$that.find('.grve-count').length ) {
							$(counter).appendTo($that);
						}
					});
					// All Counter
					$($filter[0]).find('.grve-count span').text( $wrapper.find('.grve-list-item').length );

					$.each( filterClasses,function( index, itemClass ){
						if( itemClass !== '*' ) {
							var count = $wrapper.find(itemClass).length;
							$($filter[index]).find('.grve-count span').text( count );
						}
					});
				}
			},
		},
		isotope: {
			init: function(){
				var base = this;
				$('.grve-isotope').each(function(){
					var $wrapper     = $(this),
						$container   = $wrapper.find('.grve-isotope-container'),
						itemsArr     = $.makeArray( $container.find('.grve-entry-item') ),
						layoutMode   = $wrapper.data('layout'),
						$pagination  = $wrapper.find('.grve-infinite-pagination'),
						displayStyle = $wrapper.data('display-style'),
						originLeft = true;
					if( $body.hasClass('rtl')) {
						originLeft = false;
					}

					base.updateSettings( $wrapper );
					base.filtersCounter( $wrapper );

					$container.isotope({
						itemSelector: '.grve-entry-item',
						layoutMode: layoutMode,
						originLeft: originLeft,
						// transitionDuration: 0,
						masonry: {
							columnWidth: '.grve-grid-sizer'
						}
					}).css('visibility','visible');

					// Isotope Items Animation
					base.itemsAnimation( $wrapper, itemsArr );

					// Set Skin on scroll
					GRVE.pageSettings.skinScrollEffect.onResize();
					GRVE.pageSettings.skinScrollEffectElementor.onResize();


					// Filters
					var filterArr = [],
						$filters = $wrapper.find('.grve-filter'),
						$filter = $filters.find('li'),
						$filterSelect = $wrapper.find('.grve-filters-select');

					$filter.each(function(){
						var selector = $(this).data('filter');
						if( filterArr.indexOf(selector) === -1 ) {
							filterArr.push(selector);
						}
					});

					$filters.on('click', 'li', function(){
						var selector     = $(this).data('filter'),
							title        = $(this).html(),
							$curCategory = $(this).parent().find('.grve-current-category'),
							gototop      = $(this).parents('.grve-filter').attr('data-gototop') == 'yes' ? true : false;

						if( $curCategory.length > 0 ){
							$curCategory.find('span').html( title );
						}

						$container.isotope({
							filter: selector
						});

						// Go to top
						if( gototop && 'infinite-scroll' !== displayStyle && 'load-more' !== displayStyle ) {
							GRVE.helpers.linkGoToTop( $(this).parent(), 300, 30 );
						}
						$(this).addClass('selected').siblings().removeClass('selected');
					});

					// Drop Down Filters
					$filterSelect.on( 'change', function() {
						var selector = this.value;
						$container.isotope({
							filter: selector
						});
					});

					// Infinite Scroll
					if( $pagination.length ){
						var scrollThresh = true;
						if ('load-more' == displayStyle ) {
							scrollThresh = false;
						}

						var isotopeId = '#' + $wrapper.attr('id'),
							path   = isotopeId + ' .grve-infinite-pagination .next',
							status = isotopeId + ' .grve-infinite-page-load',
							btn    = isotopeId + ' .grve-infinite-button';

						$container.infiniteScroll({
							path: path,
							history: false,
							button: btn,
							status: status,
							scrollThreshold: scrollThresh,
						});

						$(btn).on('click',function(event){
							event.preventDefault();
							$(this).addClass('grve-is-loading');
						});

						// append items on load
						$container.on( 'load.infiniteScroll', function( event, response, path ) {
							var items = $( response ).find( isotopeId +' .grve-entry-item'),
								$filter = $( response ).find( isotopeId + ' .grve-filter ul li'),
								$filterList = $wrapper.find('.grve-filter ul'),
								activeCategory = $wrapper.find('.grve-filter .selected').data('filter');

							if( '*' !== activeCategory ) {
								var $filterAll = $wrapper.find('.grve-filter ul li[data-filter="*"]');
								$filterAll.trigger('click');
							}

							$container.append( items );
							base.relayout();
							$container.isotope( 'insert', items );
							$(btn).removeClass('grve-is-loading');

							// Reload Hover Effects
							GRVE.pageSettings.hoverEffects.hoverSplitText();
							GRVE.pageSettings.hoverEffects.imageDominant();

							// New Items Animation
							base.itemsAnimation( $wrapper, items, true );

							$filter.each(function(){
								var $that = $(this),
									filterClass = $that.data('filter');
								if( -1 === filterArr.indexOf( filterClass ) ) {
									filterArr.push( filterClass );
									$that.appendTo($filterList);
									$filterSelect.append($('<option>', {
										value: filterClass,
										text: $that.text()
									}));
								}
							});

							base.filtersCounter( $wrapper );
						});
					}

				});
			},
			updateSettings: function( $wrapper ){
				var base = this,
					$container  = $wrapper.find('.grve-isotope-container'),
					itemsArr    = $.makeArray( $container.find('.grve-entry-item') );

				base.isotopeColumns = base.getColumns( $wrapper );

				base.containerSize( $wrapper );
				base.itemSize( $wrapper, itemsArr );
			},
			relayout: function(){
				var base = this;
				$('.grve-isotope').each(function(){
					var $wrapper   = $(this),
						$container = $wrapper.find('.grve-isotope-container');
					base.updateSettings( $wrapper );
					$container.isotope({
						//transitionDuration: 0
					}).isotope( 'layout' );
				});
				GRVE.pageSettings.sectionColor.onResize();
			},
			filtersCounter: function( $wrapper ){
				var base = this,
					$filters = $wrapper.find('.grve-filter.grve-filter-style-count'),
					counter = '<div class="grve-count"><span></span></div>',
					filterClasses = [];
				if( $filters.length ) {
					var $filter = $filters.find('li');
					$filter.each(function(){
						var $that = $(this),
						filterClass = $that.data('filter');
						if( -1 === filterClasses.indexOf( filterClass ) ) {
							filterClasses.push( filterClass );
						}
						if( !$that.find('.grve-count').length ) {
							$(counter).appendTo($that);
						}
					});
					// All Counter
					$($filter[0]).find('.grve-count span').text( $wrapper.find('.grve-entry-item').length );

					$.each( filterClasses,function( index, itemClass ){
						if( itemClass !== '*' ) {
							var count = $wrapper.find(itemClass).length;
							$($filter[index]).find('.grve-count span').text( count );
						}
					});
				}
			},
			itemSize: function( $wrapper, items ){
				var base       = this,
					gutter     = !isNaN( $wrapper.data('gutter-size') ) ? Math.abs( $wrapper.data('gutter-size') ) : 0,
					columns    = base.isotopeColumns,
					$gridSizer = $wrapper.find('.grve-grid-sizer'),
					wrapperW   = $wrapper.innerWidth(),
					offset     = $wrapper.parents('.grve-section').hasClass('grve-fullwidth') ? - gutter : gutter,
					columnW    = (wrapperW + offset) / columns,
					columnW    = (columnW % 1 !== 0) ? Math.ceil(columnW) : columnW;

				$gridSizer.css({'width' : columnW });

				$.each( items, function(index, item){
					var $item = $(item),
						$itemInner = $item.children(),
						$thumb = $item.find('.grve-thumbnail');
					if( $itemInner.hasClass('grve-image-landscape') ) {
						if ( columns != 1 ) {
							$item.css({'width' : columnW * 2});
						} else {
							$item.css({'width' : columnW });
						}
						$thumb.removeAttr('style');
						$thumb.css('height',columnW - gutter);
					} else if( $itemInner.hasClass('grve-image-portrait') ) {
						$item.css({'width' : columnW });
						$thumb.removeAttr('style');
						$thumb.css('height',columnW*2  - gutter);
					} else if( $itemInner.hasClass('grve-double-size') || $itemInner.hasClass('grve-image-large-square') ) {
						if ( columns != 1 ) {
							$item.css({'width' : columnW * 2});
						} else {
							$item.css({'width' : columnW });
						}
					} else {
						$item.css({'width' : columnW });
					}
					$item.css({ 'padding' : gutter/2 });
				});

				// Equal Columns
				base.equalColumns( $wrapper, items );
			},
			containerSize: function( $wrapper ){
				var base       = this,
					$container = $wrapper.find('.grve-isotope-container'),
					wrapperW   = $wrapper.innerWidth(),
					gutter     = !isNaN( $wrapper.data('gutter-size') ) ? Math.abs( $wrapper.data('gutter-size') ) : 0,
					columns    = base.isotopeColumns,
					offset     = $wrapper.parents('.grve-section').hasClass('grve-fullwidth') ? - gutter : gutter,
					columnW    = (wrapperW + offset) / columns,
					columnW    = (columnW % 1 !== 0) ? Math.ceil(columnW) : columnW,
					containerW = columnW * columns;

				if ( $container.parents('.grve-section').hasClass('grve-fullwidth') ) {
					$container.css({ 'padding-left' : gutter/2, 'padding-right' : gutter/2, 'width' : containerW + gutter });
				} else {
					$container.css({ 'margin' : - (gutter/2), 'width' : containerW });
				}
			},
			getColumns: function( $wrapper ){
				var windowWidth = $(window).width(),
					columns = {
						largeS  : $wrapper.data('columns-large-screen'),
						desktop : $wrapper.data('columns'),
						tabletL : $wrapper.data('columns-tablet-landscape'),
						tabletP : $wrapper.data('columns-tablet-portrait'),
						mobile : $wrapper.data('columns-mobile')
					};

				if ( windowWidth > largeScreen ) {
					columns = columns.largeS;
				} else if ( windowWidth > tabletLandscape && windowWidth <= largeScreen ) {
					columns = columns.desktop;
				} else if ( windowWidth > tabletPortrait && windowWidth <= tabletLandscape ) {
					columns = columns.tabletL;
				} else if ( windowWidth > mobileScreen && windowWidth <= tabletPortrait ) {
					columns = columns.tabletP;
				} else {
					columns = columns.mobile;
				}

				return columns;
			},
			getRows: function( $wrapper, items ){
				var base = this;
				if( items.length ) {
					var columns = base.isotopeColumns,
						itemsArr = [],
						rows = [];

					$.each( items, function(i,item){
						if( $(items[i]).children().hasClass('grve-double-size') ) {
							itemsArr.push('');
						}
						itemsArr.push(item);
					});
					for (var index = 0; index < itemsArr.length; index += columns) {
						var rowItems = itemsArr.slice( index, index + columns );
						rowItems = $.grep(rowItems,function(n){
							return(n);
						});
						rows.push( rowItems );
					}
					return rows;
				}
			},
			itemsAnimation: function( $wrapper, items, animFirstRow ){
				var base = this,
					animation = $wrapper.data('animation');
				if( items.length && 'none' !== animation ) {
					var rows = base.getRows( $wrapper, items ),
						animParams = GRVE.pageSettings.basicAnimations.getAnimParams( animation );

					if( animFirstRow ) {
						// Remove first row from rows Array
						// And play animation for this
						var items = rows.shift();
						gsap.timeline().from($(items).children(), $.extend(animParams, {force3D: true, ease:'power1.out', stagger: 0.3}));
					}

					$.each( rows, function( index, items ){
						$(items[0]).appear(function() {
							gsap.timeline().from($(items).children(), $.extend(animParams, {force3D: true, ease:'power1.out', stagger: 0.3}));
						});
					});
				}
			},
			equalColumns: function( $wrapper, items ){
				var base = this;
				if( $wrapper.hasClass('grve-blog-grid')) {
					var rows = base.getRows( $wrapper, items );
					$.each( rows, function( index, col ){
						$(this).imagesLoaded( function() {
							var maxHeight = GRVE.helpers.getMaxHeights( col, '.grve-post-item-inner' );
							$.each(col, function( index, value ) {
								var $that = $(this),
								$post = $that.find('.grve-post-item-inner');
								$post.css( 'height', maxHeight );
							});
						});
					});
				}
				if( $wrapper.hasClass('grve-testimonial-grid')) {
					var rows = base.getRows( $wrapper, items );
					$.each( rows, function( index, col ){
						$(this).imagesLoaded( function() {
							var maxHeight = GRVE.helpers.getMaxHeights( col, '.grve-testimonial-inner' );
							$.each(col, function( index, value ) {
								var $that = $(this),
								$post = $that.find('.grve-testimonial-inner');
								$post.css( 'height', maxHeight );
							});
						});
					});
				}
			}
		},
		carouselElements: {
			init: function(){
				var base = this;
				base.carousel();
				base.carouselFlickity();
				base.flexibleCarouselAdvanced();
				base.slider();
			},
			carousel: function(){
				var $element = $('.grve-classic-carousel');
				$element.each(function(){
					var $carousel = $(this),
						$nextNav = $carousel.parent().find('.grve-carousel-next'),
						$prevNav = $carousel.parent().find('.grve-carousel-prev'),
						sliderSpeed = ( parseInt( $carousel.attr('data-slider-speed') ) ) ? parseInt( $carousel.attr('data-slider-speed') ) : 3000,
						pagination = $carousel.attr('data-pagination') != 'no' ? true : false,
						paginColor = $carousel.attr('data-pagination-color') !== undefined ? 'grve-carousel-pagination grve-dots-' + $carousel.attr('data-pagination-color') : 'grve-carousel-pagination',
						paginationSpeed = ( parseInt( $carousel.attr('data-pagination-speed') ) ) ? parseInt( $carousel.attr('data-pagination-speed') ) : 400,
						autoHeight = $carousel.attr('data-slider-autoheight') == 'yes' ? true : false,
						autoPlay = $carousel.attr('data-slider-autoplay') != 'no' ? true : false,
						sliderPause = $carousel.attr('data-slider-pause') == 'yes' ? true : false,
						loop = $carousel.attr('data-slider-loop') != 'no' ? true : false,
						itemNum = parseInt( $carousel.attr('data-items')),
						tabletLandscapeNum = $carousel.attr('data-items-tablet-landscape') ? parseInt( $carousel.attr('data-items-tablet-landscape')) : 3,
						tabletPortraitNum = $carousel.attr('data-items-tablet-portrait') ? parseInt( $carousel.attr('data-items-tablet-portrait')) : 3,
						mobileNum = $carousel.attr('data-items-mobile') ? parseInt( $carousel.attr('data-items-mobile')) : 1,
						gap = $carousel.hasClass('grve-with-gap') && !isNaN( $carousel.data('gutter-size') ) ? Math.abs( $carousel.data('gutter-size') ) : 0,
						stagePadding = parseInt( $carousel.attr('data-stage-padding') ) > 0 ? parseInt( $carousel.attr('data-stage-padding') ) : 0,
						dotsContainer =  $carousel.parent().find('.grve-thumb-pagination').length ?  $carousel.parent().find('.grve-thumb-pagination')[0] : false,
						rtl = false;
					if ( $carousel.find('.grve-carousel-item').length == 1 ) {
						loop = false;
					}
					if( $body.hasClass('rtl')) {
						rtl = true;
					}
					// Carousel Init
					$carousel.owlCarousel({
						loop : loop,
						autoplay : autoPlay,
						autoplayTimeout : sliderSpeed,
						autoplayHoverPause : sliderPause,
						smartSpeed : 500,
						dots : pagination,
						dotsClass : paginColor,
						autoHeight : autoHeight,
						navContainer : 'grve-carousel-navigation',
						stageOuterClass : 'grve-carousel-stage-outer',
						stageClass : 'grve-carousel-stage',
						autoHeightClass : 'grve-auto-height',
						grabClass : 'grve-grab',
						dotClass : 'grve-dot',
						dotsContainer : dotsContainer,
						navSpeed: paginationSpeed,
						dotsSpeed: paginationSpeed,
						rtl: rtl,
						responsive : {
							0 : {
								items : mobileNum
							},
							768 : {
								items : tabletPortraitNum
							},
							1024 : {
								items : tabletLandscapeNum
							},
							1200 : {
								items : itemNum
							}
						},
						margin : gap,
						stagePadding : stagePadding,
						itemClass : 'grve-carousel-item-wrapper'
					});

					$carousel.css('visibility','visible');

					// Custom Svg
					if( $carousel.find('.grve-custom-svg-icon').length ) {
						setTimeout(function(){
							$carousel.trigger('refresh.owl.carousel');
						},300);
					}

					// Go to the next item
					$nextNav.on( 'click', function() {
						$carousel.trigger('next.owl.carousel');
					});
					// Go to the previous item
					$prevNav.on( 'click', function() {
						$carousel.trigger('prev.owl.carousel');
					});

					$carousel.on( 'drag.owl.carousel', function(){
						$(this).addClass('grve-disable-link');
					});

					$carousel.on( 'dragged.owl.carousel', function(){
						$(this).removeClass('grve-disable-link');
					});
				});
			},
			carouselFlickity: function(){
				var $element = $('.grve-flickity-carousel');
				$element.each(function(){
					var $carousel = $(this),
						$nextNav = $carousel.parents('.grve-carousel').find('.grve-carousel-next'),
						$prevNav = $carousel.parents('.grve-carousel').find('.grve-carousel-prev'),
						pagination = $carousel.attr('data-pagination') != 'no' ? true : false,
						autoPlay = $carousel.attr('data-slider-autoplay') != 'no' ? true : false,
						loop = $carousel.attr('data-slider-loop') != 'no' ? true : false,
						align = $carousel.attr('data-slider-loop') != 'no' ? 'center' : 'left',
						rtl = false;

					if( $body.hasClass('rtl')) {
						rtl = true;
						align = $carousel.attr('data-slider-loop') != 'no' ? 'center' : 'right';
					}

					// $carousel.on( 'ready.flickity change.flickity', function() {
					$carousel.on( 'ready.flickity', function() {
						var $that = $(this);
						if( $that.hasClass('grve-blog-carousel') ) {
							var $item = $that.find('.grve-post-item'),
								items = $.makeArray( $item ),
								maxHeight = GRVE.helpers.getMaxHeights( items, '.grve-post-item-inner' );
							$that.find('.grve-post-item-inner').css('height',maxHeight);
						}
						if( $that.hasClass('grve-testimonial') ) {
							var $item = $that.find('.grve-testimonial-item'),
								items = $.makeArray( $item ),
								maxHeight = GRVE.helpers.getMaxHeights( items, '.grve-testimonial-inner' );
							$that.find('.grve-testimonial-inner').css('height',maxHeight);
						}
					});
					$carousel.flickity({
						cellAlign: align,
						contain: loop,
						wrapAround: loop,
						groupCells: true,
						pageDots: pagination,
						autoPlay: autoPlay,
						prevNextButtons: false,
						adaptiveHeight: false,
						cellSelector: '.grve-carousel-item',
						rightToLeft: rtl
					});
					$carousel.css('visibility','visible');

					// Go to the next item
					$nextNav.on( 'click', function() {
						$carousel.flickity('next');
					});
					// Go to the previous item
					$prevNav.on( 'click', function() {
						$carousel.flickity('previous');
					});

					$carousel.on( 'dragStart.flickity', function(){
						$(this).addClass('grve-disable-link');
					});

					$carousel.on( 'dragEnd.flickity', function(){
						$(this).removeClass('grve-disable-link');
					});
				});
			},
			flexibleCarouselAdvanced: function(){
				var $element = $('.grve-flexible-advanced-carousel');
				$element.each(function(){
					var $carousel = $(this),
						$nextNav = $carousel.parents('.grve-carousel-wrapper').find('.grve-carousel-next'),
						$prevNav = $carousel.parents('.grve-carousel-wrapper').find('.grve-carousel-prev'),
						pagination = $carousel.attr('data-pagination') != 'no' ? true : false,
						autoPlay = $carousel.attr('data-slider-autoplay') != 'no' ? true : false,
						loop = $carousel.attr('data-slider-loop') != 'no' ? true : false,
						align = $carousel.attr('data-slider-loop') != 'no' ? 'center' : 'left',
						rtl = false;
					if( $body.hasClass('rtl')) {
						rtl = true;
						align = $carousel.attr('data-slider-loop') != 'no' ? 'center' : 'right';
					}

					$carousel.flickity({
						cellAlign: align,
						contain: loop,
						wrapAround: loop,
						groupCells: true,
						pageDots: pagination,
						autoPlay: autoPlay,
						prevNextButtons: false,
						adaptiveHeight: false,
						rightToLeft: rtl
					});
					$carousel.css('visibility','visible');

					// Go to the next item
					$nextNav.on( 'click', function() {
						$carousel.flickity('next');
					});
					// Go to the previous item
					$prevNav.on( 'click', function() {
						$carousel.flickity('previous');
					});

					$carousel.on( 'dragStart.flickity', function(){
						$(this).addClass('grve-disable-link');
					});

					$carousel.on( 'dragEnd.flickity', function(){
						$(this).removeClass('grve-disable-link');
					});
				});
			},
			slider: function(){
				var $element = $('#grve-main-content .grve-slider-element, #grve-single-media .grve-slider-element');
				$element.each(function(){
					var $slider = $(this),
						$nextNav = $slider.parents('.grve-slider').find('.grve-carousel-next'),
						$prevNav = $slider.parents('.grve-slider').find('.grve-carousel-prev'),
						sliderSpeed = ( parseInt( $slider.attr('data-slider-speed') ) ) ? parseInt( $slider.attr('data-slider-speed') ) : 3000,
						sliderPause = $slider.attr('data-slider-pause') == 'yes' ? true : false,
						transition = $slider.attr('data-slider-transition'),
						loop = $slider.attr('data-slider-loop') != 'no' ? true : false,
						autoPlay = $slider.attr('data-slider-autoplay') != 'no' ? true : false,
						paginColor = $slider.attr('data-pagination-color') !== undefined ? 'grve-carousel-pagination grve-dots-' + $slider.attr('data-pagination-color') : 'grve-carousel-pagination',
						pagination = $slider.attr('data-pagination') != 'no' ? true : false,
						animateOut = false,
						animateIn = false;

					// Slider Trantition
					if( $slider.parents('.grve-slider').hasClass('grve-layout-2') || 'fade' == transition ){
						animateOut = 'carousel-fade-out';
						animateIn = 'carousel-fade-in';
					}

					if ( $slider.find('.grve-slider-item').length == 1 ) {
						loop = false;
					}

					// Slider Init
					$slider.owlCarousel({
						items : 1,
						loop : loop,
						autoplay : autoPlay,
						autoplayTimeout : sliderSpeed,
						autoplayHoverPause : sliderPause,
						smartSpeed : 500,
						dots : pagination,
						animateOut : animateOut,
						animateIn : animateIn,
						dotsClass : paginColor,
						itemClass : 'grve-slider-item-wrapper',
						navContainer : 'grve-carousel-navigation',
						stageOuterClass : 'grve-carousel-stage-outer',
						stageClass : 'grve-carousel-stage',
						grabClass : 'grve-grab',
						dotClass : 'grve-dot',
					});

					$slider.css('visibility','visible');

					// Go to the next item
					$nextNav.on( 'click', function() {
						$slider.trigger('next.owl.carousel');
					});
					// Go to the previous item
					$prevNav.on( 'click', function() {
						$slider.trigger('prev.owl.carousel');
					});

				});

			}
		},
		scrollingPage: {
			init: function(){
				this.fullPage();
			},
			fullPage: function(){
				var base = this,
					$fPage = $('#grve-fullpage');
				if( !$fPage.length ) return;
					var $section = $fPage.find('.grve-row-section');
					var deviceNavigation = true;
					var deviceAutoScrolling = true;
					var scrollOverflow = true;
					var fitToSection = true;
					var speed = $fPage.data('scroll-speed');
					var deviceFullPageEnable = $fPage.data('device-scrolling') == 'yes' ? true : false;
					var lockAnchors = $fPage.data('lock-anchors') == 'yes' ? true : false;
					var loop = $fPage.data('scroll-loop');
					var loopTop = false;
					var loopBottom = false;
					var itemChangeSkin = GRVE.pageSettings.sectionColor.items;

					if ( 'both' == loop || 'top' == loop ) {
						loopTop = true;
					}
					if ( 'both' == loop || 'bottom' == loop ) {
						loopBottom = true;
					}

					if( GRVE.helpers.isMobile.any() && !deviceFullPageEnable ) {
						deviceNavigation = false;
						deviceAutoScrolling = false;
						scrollOverflow = false;
						fitToSection = false;
					}

				$fPage.fullpage({
					navigation: deviceNavigation,
					navigationPosition: 'right',
					sectionSelector: $section,
					css3: true,
					scrollingSpeed: speed,
					autoScrolling : deviceAutoScrolling,
					fitToSection : fitToSection,
					lockAnchors : lockAnchors,
					loopTop : loopTop,
					loopBottom : loopBottom,
					scrollOverflow: scrollOverflow,
					afterLoad: function(anchorLink, index){
						var sectionHeaderColor = $($section[index-1]).attr('data-header-color');
						$section.find('.fp-tableCell').css('visibility','visible');
						// Set Header Color
						GRVE.headerSettings.mainHeader.changeSkin( sectionHeaderColor );
						itemChangeSkin.push( {'item' : $('#fp-nav')[0], 'initColor': sectionHeaderColor});

						// Change Skin
						$.each( itemChangeSkin, function(i,n){
							var $item = $(itemChangeSkin[i].item);
							GRVE.pageSettings.sectionColor.changeSkin( $item, sectionHeaderColor );
						});
						base.addAnim( $section, index );

						// Close Responsive Menu
						if( $('body').hasClass('grve-responsivemenu-open') ) {
							$('.grve-toggle-responsive-menu').trigger('click');
						}
						// Close Offcanvas
						if( $('body').hasClass('grve-offcanvas-open') ) {
							$('.grve-toggle-offcanvas').trigger('click');
						}
						// Close Safe Button
						if( $('body').hasClass('grve-safebutton-open') ) {
							$('.grve-toggle-safebutton-area').trigger('click');
						}
					},
					afterRender: function(){
						// $videoBg.each(function(){
						// 	var $that = $(this),
						// 		$video = $that.find('video');
						// 	$video[0].play();
						// 	GRVE.pageSettings.videos.resizeVideoBgElement( $that );
						// });
					}
				});
			},
			addAnim: function( section, index ){
				var $section = $(section[index-1]),
					$animElem = $section.find('.grve-animated-item:not(.grve-animating)');

				$animElem.each(function(){
					GRVE.pageSettings.basicAnimations.elementAnimation( $(this) );
				});
			}
		},
		stickyElements: {
			init: function(){
				this.checkDevice();
			},
			checkDevice: function(){
				var base = this;
				if( $window.width() + scrollBarWidth > tabletPortrait ) {
					base.initStickyElement();
				} else {
					$stickyEl.trigger("sticky_kit:detach");
				}
			},
			initStickyElement: function(){
				$stickyEl.each(function(){
					var $that = $(this),
						paddingT = $that.css('padding-top'),
						paddingL = $that.css('padding-left'),
						paddingB = $that.css('padding-bottom'),
						paddingR = $that.css('padding-right'),
						elPadding = paddingT + ' ' + paddingR + ' ' + paddingB + ' ' + paddingL,
						topOffset = $that.data('sticky-offset') !== undefined ? $that.data('sticky-offset') : 0;

					$that.stick_in_parent({
						bottoming: true,
						inner_scrolling: false,
						offset_top: topOffset
					}).on("sticky_kit:stick", function(e) {
						$(this).css({
							'padding-top' : paddingT,
							'z-index' : 9999
						});
						this.style.setProperty('padding', elPadding, 'important');
					}).on("sticky_kit:unstick", function(e) {
						this.style.setProperty('padding', '');
					});
					$window.on('grve_safebutton_before_close' ,function(){
						$that.trigger('sticky_kit:recalc');
					});
				});
			}
		},
		wooCommerce: {
			init: function(){
			},
			onResize: function(){
				this.checkCarousel();
			},
			wooThumbCarousel: function(){
				var base = this,
					$gallery = $('.grve-woo-theme-gallery'),
					$images = $( '.woocommerce-product-gallery__image' ),
					$galleryZoomPopup = $('.grve-woo-gallery-zoom.grve-woo-light-gallery-popup'),
					slideIndex = 0;

				if( $galleryZoomPopup.length ) {
					$galleryZoomPopup.prepend( '<a href="#" class="woocommerce-product-gallery__trigger">đ</a>' );
					$galleryZoomPopup.on( 'click', '.woocommerce-product-gallery__trigger', function(){
						if( $images.length > 1 ) {
							$galleryZoomPopup.find( '.flex-active-slide a' ).trigger('click');
						} else {
							$galleryZoomPopup.find( '.woocommerce-product-gallery__image a' ).trigger('click');
						}
					});
				}
				
				if( $gallery.length ) {
					var $nav = $gallery.find('.flex-control-nav'),
						$thumbs = $nav.children(),
						$prevBtn = $('<div class="grve-woo-thumbs-nav-btn grve-woo-thumbs-nav-prev grve-hide-nav"><span></span></div>'),
						$nextBtn = $('<div class="grve-woo-thumbs-nav-btn grve-woo-thumbs-nav-next"><span></span></div>');

					for(var i = 0; i < $thumbs.length; i += 4) {
						$thumbs.slice(i, i + 4).wrapAll('<div class="grve-woo-carousel-item"></div>');
					}

					$nav.children().wrapAll('<div class="grve-woo-carousel-inner"></div>');
					$nav.wrap('<div class="grve-woo-carousel"></div>');
					$gallery.addClass('grve-woo-thumbs-carousel');
					base.checkCarousel();
					var totalItems = $('.grve-woo-carousel-item').length;
					if( totalItems > 1 ) {
						$prevBtn.insertBefore( $nav );
						$nextBtn.insertAfter( $nav );
					}

					$nextBtn.on('click',function(){
						if( slideIndex < totalItems - 1 ) {
							base.moveCarousel( ++slideIndex, totalItems );
						}
					});

					$prevBtn.on('click',function(){
						if( slideIndex > 0 ) {
							base.moveCarousel( --slideIndex, totalItems );
						}
					});
				}
			},
			checkCarousel: function(){
				var base = this,
					$carousel = $('.grve-woo-carousel'),
					$nav = $carousel.find('.flex-control-nav'),
					$items = $carousel.find('.grve-woo-carousel-item'),
					maxHeight = 0;
				if( $carousel.length ) {
					$items.css('height','');
					$nav.css('height','');
					if( $(window).width() + scrollBarWidth > tabletLandscape ) {
						$items.each(function () {
							if ($(this).height() > maxHeight) {
								maxHeight = $(this).height();
							}
						});
						$items.css('height',maxHeight);
						$nav.css('height',maxHeight);
					}
				}

			},
			moveCarousel: function(index, totalItems){
				var base = this,
					$carousel = $('.grve-woo-carousel'),
					$inner = $carousel.find('.grve-woo-carousel-inner'),
					$nav = $carousel.find('.flex-control-nav'),
					position = -(index * 100)/totalItems + '%';
					gsap.to( $inner, {y: position });
				if( index > 0 ) {
					$('.grve-woo-thumbs-nav-prev').removeClass( 'grve-hide-nav' );
				} else {
					$('.grve-woo-thumbs-nav-prev').addClass( 'grve-hide-nav' );
				}
				if( index == totalItems - 1 ) {
					$('.grve-woo-thumbs-nav-next').addClass( 'grve-hide-nav' );
				} else {
					$('.grve-woo-thumbs-nav-next').removeClass( 'grve-hide-nav' );
				}
			}
		}
	};

	GRVE.helpers = {
		getTopBarHeight : function(){
			var height = 0;
			if( $topBar.length ) {
				height = $topBar.outerHeight();
			}
			return height;
		},
		getMaxHeights: function( itemsArr, selector ){
			var maxHeight = 0,
				heightArr = [];
			$.each( itemsArr, function( index, item ){
				var $item = $(item).find( selector ),
					itemH = $item.css('height','auto').outerHeight();
				heightArr.push(itemH);
			});

			maxHeight = Math.max.apply( Math, heightArr ) + 2;

			return maxHeight;
		},
		inViewport: function( $element ){
			var winTop    = $window.scrollTop(),
				winBottom = winTop + $window.height(),
				elTop     = $element.offset().top,
				elBottom  = elTop + $element.outerHeight();
			return ( winBottom >= elTop && winTop <= elBottom );
		},
		getScrollDirection: function(){
			var scroll = $window.scrollTop(),
				currentPos = scroll,
				direction = 'down';

			if( currentPos > scrolPosition && direction === 'up' ) {
				direction = 'down';
			} else if( currentPos < scrolPosition && direction === 'down' ) {
				direction = 'up';
			}
			scrolPosition = currentPos;

			return direction;
		},
		smoothScrollTo: function( target, callback ){
			var anchorBarH = $anchorMenu.length ? $anchorMenu.outerHeight() : 0;
			windowScrollTo = true;
			$('html,body').animate({
				scrollTop: target.offset().top - GRVE.headerSettings.mainHeader.getHeaderHeight() - anchorBarH + 1
			}, {
				complete: function( animation, progress, msRemaining ) {
					if (callback && typeof(callback) == 'function') {
						callback();
					}
				}
			}, 1000,function(){
				windowScrollTo = false;
			});
		},
		linkGoToTop: function( element, delay, space ){
			var $this = element,
				elementTop       = $this.offset().top,
				header           = $header.length && $mainHeader.is(":visible") ? true : false,
				responsiveHeader = $('#grve-responsive-header').length && $('#grve-responsive-header').is(":visible") ? true : false,
				headerHeight     = header && $header.data('sticky') != 'none' ? $mainHeader.outerHeight() : 0,
				respHeaderH      = responsiveHeader && $header.data('devices-sticky') == 'yes' ? $('#grve-responsive-header').outerHeight() : 0,
				topBarHeight     = GRVE.helpers.getTopBarHeight(),
				anchorBarHeight  = $('.grve-anchor-menu').length ? $('.grve-anchor-menu').outerHeight() : 0,
				delayAnim        = delay !== undefined ? delay : 300,
				topSpace         = space !== undefined ? space : 0,
				offset           = topBarHeight + wpBarHeight + headerHeight + respHeaderH + anchorBarHeight + topSpace;
			if( elementTop > 0 ){
				$('html, body').delay(delayAnim).animate({
					scrollTop: elementTop - offset
				}, 900, 'easeInOutCubic');
				$("html, body").on("scroll mousedown DOMMouseScroll mousewheel keyup", function(){
					$('html, body').stop();
				});
				return false;
			}
		},
		getScrollBarWidth : function(){
			var parent,
				child,
				scrollBarWidth;

			if( scrollBarWidth === undefined ) {
				parent          = $('<div style="width:50px;height:50px;overflow:auto"><div/></div>').appendTo('body');
				child           = parent.children();
				scrollBarWidth  = child.innerWidth() - child.height(99).innerWidth();
				parent.remove();
			}

			return scrollBarWidth;
		},
		splitText: function( element, type, speed ){
			var $element = $(element),
				delay = undefined != speed ? speed : 20;
			if( $element.length ) {
				var str = 'word' == type ? $element.text().split(' ') : $element.text().split('');

				$element.empty();
				for (var i in str) {
					var $char = $('<span class="grve-char"><span>' + str[i] + '</span></span>');
					$element.append($char);
					if( 'word' == type ) {
						$element.append('<span class="grve-char grve-break-space"><span> </span></span>');
					} else if( str[i] == ' ' ){
						$char.addClass('grve-break-space');
					}
					if( delay !== 0 ) {
						$char.children().css('transition-delay', i * delay +'ms' );
					}
				}

				$element.addClass('grve-split-text');
			}
		},
		isMobile: {
			Android: function() {
				return navigator.userAgent.match(/Android/i);
			},
			BlackBerry: function() {
				return navigator.userAgent.match(/BlackBerry/i);
			},
			iOS: function() {
				return navigator.userAgent.match(/iPhone|iPad|iPod/i);
			},
			Opera: function() {
				return navigator.userAgent.match(/Opera Mini/i);
			},
			Windows: function() {
				return navigator.userAgent.match(/IEMobile/i);
			},
			any: function() {
				return (this.Android() || this.BlackBerry() || this.iOS() || this.Opera() || this.Windows());
			}
		}
	};

	var $document = $(document),
		$window = $(window),
		$body = $('body'),
		$themeWrapper = $('#grve-theme-content'),
		$content = $('#grve-content'),
		$singleWrapper = $('.grve-single-wrapper'),
		$header = $('#grve-header'),
		$mainHeader = $('#grve-main-header'),
		$activeHeader = $('#grve-main-header'),
		stickyType = 'none',
		headerSkin = $mainHeader.data('header-skin'),
		$verticalMenu = $('.grve-vertical-menu'),
		$offcanvasArea = $('#grve-offcanvas-area'),
		$responsiveHeader = $('#grve-main-responsive-header'),
		$responsiveArea = $('#grve-responsive-menu-area'),
		$anchorMenu = $('.grve-anchor-menu'),
		$topBar = $('#grve-top-bar'),
		$featureSection = $('#grve-feature-section'),
		$featureSlider = $('#grve-feature-slider'),
		$featureAdvancedSlider = $('#grve-feature-advanced-slider'),
		$pageTitle = $('.grve-title-section'),
		$sidebar = $('#grve-sidebar'),
		$section = $('.grve-section'),
		$stickyWidget = $('.grve-sticky-widget'),
		$videoBg = $('.grve-bg-video'),
		$stickyEl = $('.grve-sticky-element'),
		scrollBarWidth = GRVE.helpers.getScrollBarWidth(),
		scrolPosition = 0,
		windowScrollTo = false,
		headerIsSticky = false,
		hideStickyHeader = false,
		disableStickyHeader = false,
		featureParallax = false,
		openAnchorMenu = false,
		sectionColorMove = false,
		frameSize = $('#grve-frames').find('.grve-frame.grve-top').length ? $('#grve-frames').find('.grve-frame.grve-top').height() : 0,
		$backToTop = $('.grve-back-top'),
		deviceAnimAppear = ( 1 == impeka_grve_main_data.device_animations ) ? true : false,
		resizeTimeout;

	var spinner = '<div class="grve-spinner"><div></div><div></div><div></div><div></div></div>';
	var largeScreen = 2048;
	var tabletLandscape = 1200;
	var tabletPortrait = 1023;
	var mobileScreen = 767;
	var lastScrollTop = 0;
	var wpBarHeight = $('.grve-body').hasClass('admin-bar') ? 32 : 0;

	$(function() {
		GRVE.init();
		// On Window Scroll
		$window.on('scroll.grve_window_scroll', function(){
			GRVE.onScroll();
		});
	});

	$window.on('load', function() {
		GRVE.onLoad();
	});

	$window.on('grve_after_page_transition', function() {
		GRVE.afterTransition();
	});

	// On Window Resize
	$window.on('resize.grve_window_resize', function(){
		window.clearTimeout( resizeTimeout );
		resizeTimeout = window.setTimeout(function () {
			GRVE.onResize();
		}, 300);
	});

	// WooCommerce Gallery
	$( '.grve-woo-theme-gallery' ).on('wc-product-gallery-after-init',function( event, elem, params ){
		window.setTimeout(function () {
			GRVE.pageSettings.wooCommerce.wooThumbCarousel();
		}, 300);
	});

})(jQuery);