<?php
/*
*	Template Go To Section
*
* 	@version	1.0
* 	@author		Greatives Team
* 	@URI		https://greatives.eu
*/

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

$item = isset( $args ) ? $args : array();
$arrow_enabled = impeka_grve_array_value( $item, 'arrow_enabled', 'no' );

if( 'no' != $arrow_enabled ) {
	$arrow_text = impeka_grve_array_value( $item, 'arrow_text' );
	$arrow_color = impeka_grve_array_value( $item, 'arrow_color', 'white' );
	$arrow_color_custom = impeka_grve_array_value( $item, 'arrow_color_custom', '#ffffff' );
	$arrow_color_custom = impeka_grve_get_color( $arrow_color, $arrow_color_custom );
?>
	<div class="grve-scroll-down grve-goto-first-section grve-text-<?php echo esc_attr( $arrow_color ); ?> grve-svg-<?php echo esc_attr( $arrow_color ); ?>">
		<?php echo impeka_grve_get_svg_icon( 'arrow-2'); ?>
		<?php if( 'text' == $arrow_enabled  ) { ?>
		<span><?php echo esc_html( $arrow_text ); ?></span>
		<?php } ?>
	</div>
<?php
}

//Omit closing PHP tag to avoid accidental whitespace output errors.
