<?php
/*
*	Template Advanced Slider Style 2 Slide
*
* 	@version	1.0
* 	@author		Greatives Team
* 	@URI		https://greatives.eu
*/

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

$item = isset( $args ) ? $args : array();

$post_id = get_the_ID();
$excerpt_length = impeka_grve_array_value( $item, 'excerpt_length' );
$caption = impeka_grve_post_slider_excerpt( $post_id, $excerpt_length );
if( has_post_thumbnail( $post_id ) ) {
	$media_id = get_post_thumbnail_id( $post_id );
	$item['bg_image_id'] = $media_id;
}

$title = get_post_meta( $post_id, '_impeka_grve_title', true );
if ( empty( $title ) ) {
	$title = get_the_title( $post_id );
}
$title_color = impeka_grve_array_value( $item, 'title_color', 'white' );
$title_tag = impeka_grve_array_value( $item, 'title_tag', 'div' );
$title_heading = impeka_grve_array_value( $item, 'title_heading', 'feature-title' );
$title_family = impeka_grve_array_value( $item, 'title_family' );
$title_classes = array( 'grve-title', 'grve-text-' . $title_color, 'grve-' . $title_heading );
if ( !empty( $title_family ) ) {
	$title_classes[] = 'grve-' . $title_family;
}
$title_classes = implode( ' ', $title_classes );

$caption_color = impeka_grve_array_value( $item, 'caption_color', 'white' );
$caption_tag = impeka_grve_array_value( $item, 'caption_tag', 'div' );
$caption_heading = impeka_grve_array_value( $item, 'caption_heading', 'feature-text' );
$caption_family = impeka_grve_array_value( $item, 'caption_family' );
$caption_classes = array( 'grve-description', 'grve-text-' . $caption_color, 'grve-' . $caption_heading );
if ( !empty( $caption_family ) ) {
	$caption_classes[] = 'grve-' . $caption_family;
}
$caption_classes = implode( ' ', $caption_classes );

$button = impeka_grve_array_value( $item, 'button', array() );
$button['url'] = get_permalink();

$feature_data_color = impeka_grve_get_posts_slider_data( $item, 'color' );

?>
<div class="grve-slider-item">
	<div class="grve-slider-inner">
		<div class="grve-content">
			<<?php echo tag_escape( $title_tag ); ?> class="<?php echo esc_attr( $title_classes ); ?>"><span><?php echo wp_kses_post( $title ); ?></span></<?php echo tag_escape( $title_tag ); ?>>
			<div class="grve-text-wrapper">
				<?php if( !empty( $caption ) ) { ?>
				<<?php echo tag_escape( $caption_tag ); ?> class="<?php echo esc_attr( $caption_classes ); ?>"><?php echo wp_kses_post( $caption ); ?></<?php echo tag_escape( $caption_tag ); ?>>
				<?php } ?>
				<div class="grve-btn-wrapper">
				<?php impeka_grve_print_feature_button( $button ); ?>
				</div>
			</div>
		</div>
		<div class="grve-feature-image">
			<div class="grve-mask" <?php echo implode( ' ', $feature_data_color ); ?>></div>
			<div class="grve-background-wrapper">
				<?php impeka_grve_print_flickity_bg_image_container( $item ); ?>
				<?php impeka_grve_print_overlay_container( $item ); ?>
			</div>
		</div>
	</div>
</div>