<?php
/*
*	Button
*
* 	@version	1.0
* 	@author		Greatives Team
* 	@URI		https://greatives.eu
*/

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

$params = isset( $args ) ? $args : array();

$link_atts = impeka_grve_array_value( $params, 'link_atts', array() );
$btn_text = impeka_grve_array_value( $params, 'text' );
$btn_sr_text = impeka_grve_array_value( $params, 'sr_text' );
$btn_type = impeka_grve_array_value( $params, 'type' );
$btn_size = impeka_grve_array_value( $params, 'size', 'medium' );
$btn_color = impeka_grve_array_value( $params, 'color', 'primary-1' );
$btn_line_color = impeka_grve_array_value( $params, 'line_color', 'primary-1' );
$btn_line_position = impeka_grve_array_value( $params, 'line_position', 'left' );
$btn_hover_color = impeka_grve_array_value( $params, 'hover_color', 'black' );
$btn_color_gradient = impeka_grve_array_value( $params, 'color_gradient', 'primary-1' );
$btn_hover_color_gradient = impeka_grve_array_value( $params, 'hover_color_gradient', 'black' );
$btn_shape = impeka_grve_array_value( $params, 'shape', 'square' );
$btn_shadow = impeka_grve_array_value( $params, 'shadow' );
$btn_hover_action = impeka_grve_array_value( $params, 'hover_action' );
$btn_class = impeka_grve_array_value( $params, 'class' );
$extra_class = impeka_grve_array_value( $params, 'extra_class' );

$icon_type = impeka_grve_array_value( $params, 'icon_type', 'none' );
$icon_class = impeka_grve_array_value( $params, 'icon_class' );

$svg_icon =  impeka_grve_array_value( $params, 'svg_icon' );
$svg_icon_shape =  impeka_grve_array_value( $params, 'svg_icon_shape' );
$svg_icon_shape_type =  impeka_grve_array_value( $params, 'svg_icon_shape_type' );
$svg_icon_color =  impeka_grve_array_value( $params, 'svg_icon_color' );
$svg_icon_shape_color =  impeka_grve_array_value( $params, 'svg_icon_shape_color' );
$video_icon_shape =  impeka_grve_array_value( $params, 'video_icon_shape' );
$video_icon_shape_type =  impeka_grve_array_value( $params, 'video_icon_shape_type' );
$video_icon_shape_color =  impeka_grve_array_value( $params, 'video_icon_shape_color' );
$video_icon_shape_hover_color =  impeka_grve_array_value( $params, 'video_icon_shape_hover_color' );

if ( empty( $btn_text ) && 'none' == $icon_type ) {
	return;
}

$is_gradient_button_color = $is_gradient_button_hover_color = false;
if (strpos($btn_color_gradient, 'gradient') === 0) {
	$is_gradient_button_color = true;
}
if (strpos($btn_hover_color_gradient, 'gradient') === 0) {
	$is_gradient_button_hover_color = true;
}

//Button Classes
$btn_classes = array();
if ( 'outline' == $btn_type ) {
	$btn_classes[] = 'grve-btn';
	$btn_classes[] = 'grve-btn-outline';
	$btn_classes[] = 'grve-' . $btn_shape;
	$btn_classes[] = 'grve-border-' . $btn_color;
	$btn_classes[] = 'grve-bg-hover-' . $btn_hover_color_gradient;
	if( !empty($btn_hover_action) ) {
		$btn_classes[] = 'grve-' . $btn_hover_action;
	}
	if( ! $is_gradient_button_hover_color ) {
		$btn_classes[] = 'grve-border-hover-' . $btn_hover_color_gradient;
	}
	if( 'grey' == $btn_color || 'light-grey' == $btn_color ) {
		$btn_classes[] = 'grve-text-dark-grey';
	} else {
		$btn_classes[] = 'grve-text-' . $btn_color;
	}
	if( 'white' == $btn_hover_color_gradient || 'grey' == $btn_hover_color_gradient || 'light-grey' == $btn_hover_color_gradient ) {
		$btn_classes[] = 'grve-text-hover-dark-grey';
	} else {
		$btn_classes[] = 'grve-text-hover-white';
	}
} else if ( 'line' == $btn_type ) {
	$btn_classes[] = 'grve-btn-text';
	$btn_classes[] = 'grve-btn-line';
	$btn_classes[] = 'grve-line-' . $btn_line_position;
	$btn_classes[] = 'grve-text-' . $btn_color;
	$btn_classes[] = 'grve-text-hover-' . $btn_color;
} else if ( 'only-text' == $btn_type ) {
	$btn_classes[] = 'grve-btn-text';
	$btn_classes[] = 'grve-btn-only-text';
	$btn_classes[] = 'grve-text-' . $btn_color;
	$btn_classes[] = 'grve-text-hover-' . $btn_hover_color;
} else if ( 'video' == $btn_type ) {
	$btn_classes[] = 'grve-btn-video';
	$btn_classes[] = 'grve-text-' . $btn_color;
} else {
	$btn_classes[] = 'grve-btn';
	$btn_classes[] = 'grve-' . $btn_shape;
	$btn_classes[] = 'grve-bg-' . $btn_color_gradient;
	if( ! $is_gradient_button_color ) {
		$btn_classes[] = 'grve-border-' . $btn_color_gradient;
	}
	$btn_classes[] = 'grve-bg-hover-' . $btn_hover_color_gradient;
	if( ! $is_gradient_button_hover_color ) {
		$btn_classes[] = 'grve-border-hover-' . $btn_hover_color_gradient;
	}
	if( !empty($btn_hover_action) ) {
		$btn_classes[] = 'grve-' . $btn_hover_action;
	}
	if( 'white' == $btn_color_gradient || 'grey' == $btn_color_gradient || 'light-grey' == $btn_color_gradient ) {
		$btn_classes[] = 'grve-text-dark-grey';
	} else {
		$btn_classes[] = 'grve-text-white';
	}
	if( 'white' == $btn_hover_color_gradient || 'grey' == $btn_hover_color_gradient || 'light-grey' == $btn_hover_color_gradient ) {
		$btn_classes[] = 'grve-text-hover-dark-grey';
	} else {
		$btn_classes[] = 'grve-text-hover-white';
	}
}

if ( 'video' == $btn_type ) {
	$video_icon_shape_class = array( 'grve-shape-icon' );
	$video_icon_shape_class[] = 'grve-' . $video_icon_shape;
	$video_icon_shape_class[] = 'grve-' . $video_icon_shape_type;
	if( 'outline' == $video_icon_shape_type ) {
		$video_icon_class = array( 'grve-btn-video-icon' );
		if( 'grey' == $video_icon_shape_color || 'light-grey' == $video_icon_shape_color ) {
			$video_icon_class[] = 'grve-svg-dark-grey';
		} else {
			$video_icon_class[] = 'grve-svg-' . $video_icon_shape_color;
		}
		if( 'white' == $video_icon_shape_color || 'grey' == $video_icon_shape_color || 'light-grey' == $video_icon_shape_color ) {
			$video_icon_class[] = 'grve-svg-hover-dark-grey';
		} else {
			$video_icon_class[] = 'grve-svg-hover-white';
		}
		$video_icon_class_string = implode( ' ', $video_icon_class );

		$video_icon_shape_class[] = 'grve-border-' . $video_icon_shape_color;
		$video_icon_shape_class[] = 'grve-bg-hover-' . $video_icon_shape_color;
	} else {
		$video_icon_class = array( 'grve-btn-video-icon' );
		if( 'white' == $video_icon_shape_color || 'grey' == $video_icon_shape_color || 'light-grey' == $video_icon_shape_color ) {
			$video_icon_class[] = 'grve-svg-dark-grey';
		} else {
			$video_icon_class[] = 'grve-svg-white';
		}
		if( 'white' == $video_icon_shape_hover_color || 'grey' == $video_icon_shape_hover_color || 'light-grey' == $video_icon_shape_hover_color ) {
			$video_icon_class[] = 'grve-svg-hover-dark-grey';
		} else {
			$video_icon_class[] = 'grve-svg-hover-white';
		}
		$video_icon_class_string = implode( ' ', $video_icon_class );

		$video_icon_shape_class[] = 'grve-bg-' . $video_icon_shape_color;
		$video_icon_shape_class[] = 'grve-bg-hover-' . $video_icon_shape_hover_color;
	}
	$video_icon_shape_class_string = implode( ' ', $video_icon_shape_class );
}

if ( $is_gradient_button_color || $is_gradient_button_hover_color ) {
	$btn_classes[] = 'grve-btn-gradient';
}

if ( !empty( $btn_shadow ) ) {
	$btn_classes[] = 'grve-shadow-' . $btn_shadow;
}

$btn_classes[] = 'grve-btn-' . $btn_size;

if ( !empty( $btn_class ) ) {
	$btn_classes[] = $btn_class;
}
if ( !empty( $extra_class ) ) {
	$btn_classes[] = $extra_class;
}

if( 'icon-library' == $icon_type ) {
	$btn_classes[] = 'grve-with-icon';
} elseif ( 'icon-svg' == $icon_type ) {
	$btn_classes[] = 'grve-with-svg-icon-' . $svg_icon;
}

$btn_class_string = implode( ' ', $btn_classes );

$link_atts[] = 'class="' . esc_attr( $btn_class_string ) . '"';


if ( 'icon-svg' == $icon_type ) {
	$svg_icon_class = array( 'grve-btn-svg-icon' );
	if( !empty( $svg_icon_shape ) ) {
		$svg_icon_class[] = 'grve-with-shape';
		$svg_icon_class[] = 'grve-svg-' . $svg_icon_color;
		$svg_icon_shape_class = array( 'grve-shape-icon' );
		$svg_icon_shape_class[] = 'grve-' . $svg_icon_shape;
		$svg_icon_shape_class[] = 'grve-' . $svg_icon_shape_type;
		if( 'outline' == $svg_icon_shape_type ) {
			$svg_icon_shape_class[] = 'grve-border-' . $svg_icon_shape_color;
		} else {
			$svg_icon_shape_class[] = 'grve-bg-' . $svg_icon_shape_color;
		}
		$svg_icon_shape_class_string = implode( ' ', $svg_icon_shape_class );
	}
	$svg_icon_class_string = implode( ' ', $svg_icon_class );
}


?>
<a <?php echo implode( ' ', $link_atts ); ?>>
	<?php if( 'none' != $icon_type || 'line' == $btn_type || 'video' == $btn_type ) { ?>
	<div class="grve-btn-inner">
	<?php } ?>
	<span><?php echo esc_html( $btn_text ); ?></span>
	<?php if ( !empty( $btn_sr_text ) ) { ?>
	<span class="screen-reader-text"><?php echo esc_html( $btn_sr_text ); ?></span>
	<?php } ?>
	<?php if ( 'line' == $btn_type ) { ?>
	<span class="grve-line grve-bg-<?php echo esc_attr( $btn_line_color ); ?>"></span>
	<?php } ?>
	<?php if( 'video' == $btn_type ) { ?>
	<div class="<?php echo esc_attr( $video_icon_class_string ); ?>">
		<?php echo impeka_grve_get_svg_icon( 'video-1' ); ?>
		<div class="<?php echo esc_attr( $video_icon_shape_class_string ); ?>"></div>
	</div>
	<?php } else { ?>
		<?php if( 'icon-library' == $icon_type ) { ?>
		<div class="grve-btn-icon">
			<span class="grve-icon <?php echo esc_attr( $icon_class ); ?>"></span>
		</div>
		<?php } else if( 'icon-svg' == $icon_type ) { ?>
		<div class="<?php echo esc_attr( $svg_icon_class_string ); ?>">
			<?php echo impeka_grve_get_svg_icon( $svg_icon ); ?>
			<?php if( !empty( $svg_icon_shape ) ) { ?>
			<div class="<?php echo esc_attr( $svg_icon_shape_class_string ); ?>"></div>
			<?php } ?>
		</div>
		<?php } ?>
	<?php } ?>
	<?php if( 'none' != $icon_type || 'line' == $btn_type || 'video' == $btn_type ) { ?>
	</div>
	<?php } ?>
</a>