<?php
/*
*	Header: Layout Top Bottom Style 1
*
* 	@version	1.0
* 	@author		Greatives Team
* 	@URI		https://greatives.eu
*/

	$header_main_attributes = impeka_grve_get_main_header_attributes( 'top-bottom', 'style-1', 'horizontal' );
	$header_borders = impeka_grve_option( 'header_borders', '1' );
	$responsive_header_layout = impeka_grve_option( 'responsive_header_layout', 'layout-1' );
	$header_top_bottom_align = impeka_grve_option( 'header_top_bottom_align', 'center' );

	$bottom_header_classes = array( 'grve-bottom-header-area' );
	// Add Borders
	if ( 1 == $header_borders ) {
		$bottom_header_classes[] = 'grve-border';
		$bottom_header_classes[] = 'grve-border-top';
	}
	$bottom_header_class_string = implode( ' ', $bottom_header_classes );

	// Text Areas
	$header_text_1 = impeka_grve_option( 'header_text_1' );
	$header_text_2 = impeka_grve_option( 'header_text_2' );
	$header_text_wrapper_classes = array( 'grve-header-text-wrapper' );
	if ( 1 == $header_borders ) {
		array_push( $header_text_wrapper_classes, 'grve-with-borders' );
	}
	$header_text_wrapper_string = implode( ' ', $header_text_wrapper_classes );

?>
	<!-- Header
	============================================= -->
	<header id="grve-header">
		<!-- Main Header -->
		<div id="grve-main-header" <?php echo implode( ' ', $header_main_attributes ); ?>>
			<div class="grve-top-header-area">
				<div class="grve-container">
					<div class="grve-header-row grve-header-align-<?php echo esc_attr( $header_top_bottom_align ) ?>">

						<?php if( 'left' == $header_top_bottom_align ) { ?>
							<div class="grve-left-area">
								<?php impeka_grve_print_logo(); ?>
							</div>
						<?php } else if( 'center' == $header_top_bottom_align ) { ?>
							<?php impeka_grve_print_logo(); ?>
						<?php } ?>
						<?php if ( 'left' == $header_top_bottom_align && ( !empty( $header_text_1 ) || !empty( $header_text_2 )  ) ) { ?>
							<div class="grve-right-area">
								<div class="<?php echo esc_attr( $header_text_wrapper_string ) ?>">
									<div class="grve-header-text-row">
										<?php if ( !empty( $header_text_1 ) ) { ?>
										<div class="grve-header-text grve-border">
											<?php echo do_shortcode( $header_text_1 ); ?>
										</div>
										<?php } ?>
										<?php if ( !empty( $header_text_2 ) ) { ?>
										<div class="grve-header-text grve-border">
											<?php echo do_shortcode( $header_text_2 ); ?>
										</div>
										<?php } ?>
									</div>
								</div>
							</div>
						<?php } ?>

					</div>
				</div>
			</div>
			<div class="<?php echo esc_attr( $bottom_header_class_string ); ?>">
				<div class="grve-container">
					<div class="grve-header-row grve-header-align-<?php echo esc_attr( $header_top_bottom_align ) ?>">
						<?php if( 'left' == $header_top_bottom_align ) { ?>
							<div class="grve-left-area">
								<?php impeka_grve_print_main_menu( 'horizontal', $header_top_bottom_align ); ?>
							</div>
							<div class="grve-right-area">
								<?php impeka_grve_print_header_elements( 'top-bottom', 'style-1', array( 'sidearea_icon', 'safebutton_icon' ), 'right' ); ?>
							</div>
						<?php } else if( 'center' == $header_top_bottom_align ) { ?>
							<div class="grve-left-area"></div>
							<?php impeka_grve_print_main_menu( 'horizontal', $header_top_bottom_align ); ?>
							<div class="grve-right-area">
								<?php impeka_grve_print_header_elements( 'top-bottom', 'style-1', array( 'sidearea_icon', 'safebutton_icon' ), 'right' ); ?>
							</div>
						<?php } ?>
					</div>
				</div>
			</div>
		</div>
		<!-- End Main Header -->

		<?php impeka_grve_print_responsive_header( $responsive_header_layout ); ?>

		<!-- Responsive Menu -->
		<?php impeka_grve_print_responsive_menu_area(); ?>
		<!-- End Responsive Menu -->

	</header>