<?php
/*
*	Page Navigation
*
* 	@version	1.0
* 	@author		Greatives Team
* 	@URI		https://greatives.eu
*/

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

$header_skin = impeka_grve_global_param( 'header_skin' );

$nav_hide = impeka_grve_option( 'page_nav_hide', 'never' );
$nav_id = impeka_grve_post_meta( '_impeka_grve_nav_id', impeka_grve_option( 'page_nav_id' ) );
if( !empty( $nav_id ) && 'none' !=  $nav_id ) {
	$nav_id = apply_filters( 'wpml_object_id', $nav_id, 'page', TRUE  );
	$nav_url = get_permalink( $nav_id );
}

if ( !empty( $nav_url ) ) {
	$nav_text = impeka_grve_post_meta( '_impeka_grve_nav_text', impeka_grve_option( 'page_nav_text' ) );
?>
<div class="grve-page-nav grve-link-text grve-skin-scroll grve-skin-<?php echo esc_attr( $header_skin ); ?> grve-page-nav-hide-<?php echo esc_attr( $nav_hide ); ?>" data-skin="<?php echo esc_attr( $header_skin ); ?>">
	<a href="<?php echo esc_url( $nav_url ); ?>"><span><?php echo wp_kses_post( $nav_text ); ?></span></a>
</div>
<?php
}

//Omit closing PHP tag to avoid accidental whitespace output errors.
