<?php
/*
*	Template Main Portfolio Archice
*
* 	@version	1.0
* 	@author		Greatives Team
* 	@URI		https://greatives.eu
*/

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

impeka_grve_print_header_title( 'portfolio_tax' );
impeka_grve_print_header_breadcrumbs( 'portfolio_tax' );

$mode = impeka_grve_option( 'portfolio_tax_mode', 'masonry' );
$item_gutter = impeka_grve_option( 'portfolio_tax_gutter', 'yes' );
$gutter_size = impeka_grve_option( 'portfolio_tax_gutter_size', '30' );
$overview_type = impeka_grve_option( 'portfolio_tax_overview_type' );

$wrapper_params = array(
	'mode' => $mode,
	'columns_large_screen' => impeka_grve_option( 'portfolio_tax_columns_large_screen', '3' ),
	'columns' => impeka_grve_option( 'portfolio_tax_columns', '3' ),
	'columns_tablet_landscape' => impeka_grve_option( 'portfolio_tax_columns_tablet_landscape', '2' ),
	'columns_tablet_portrait' => impeka_grve_option( 'portfolio_tax_columns_tablet_portrait', '2' ),
	'columns_mobile' => impeka_grve_option( 'portfolio_tax_columns_mobile', '1' ),
	'gutter' => $item_gutter,
	'gutter_size' => $gutter_size,
	'display_style' => impeka_grve_option( 'portfolio_tax_display_style', 'pagination' ),
	'animation' => impeka_grve_option( 'portfolio_tax_animation' ),
);
$wrapper_attributes = impeka_grve_get_grid_layout_atts( $wrapper_params );

$portfolio_classes = array( 'grve-portfolio', 'grve-isotope' );
if ( 'yes' == $item_gutter && '0' != $gutter_size ) {
	$portfolio_classes[] = 'grve-with-gap';
}
$portfolio_class_string = implode( ' ', $portfolio_classes );
$wrapper_attributes[] = 'class="' . esc_attr( $portfolio_class_string ) . '"';
$wrapper_attributes[] = 'id="grve-main-portfolio-tax-loop"';

$grid_image_mode = impeka_grve_option( 'portfolio_tax_image_mode' );
$masonry_image_mode = impeka_grve_option( 'portfolio_tax_masonry_image_mode', 'auto' );

$style = impeka_grve_option( 'portfolio_tax_loop_style' );
$title_caption = impeka_grve_option( 'portfolio_tax_loop_title_caption' );
$overlay_color = impeka_grve_option( 'portfolio_tax_loop_overlay_color' );
$overlay_opacity = impeka_grve_option( 'portfolio_tax_loop_overlay_opacity' );

$title_heading_tag = impeka_grve_option( 'portfolio_tax_loop_heading_tag' );
$title_heading = impeka_grve_option( 'portfolio_tax_loop_heading' );
$title_color = impeka_grve_option( 'portfolio_tax_loop_title_color' );
$title_bg_color = impeka_grve_option( 'portfolio_tax_loop_title_bg_color' );
$text_color = impeka_grve_option( 'portfolio_tax_loop_text_color' );
$text_bg_color = impeka_grve_option( 'portfolio_tax_loop_text_bg_color' );
$radius = impeka_grve_option( 'portfolio_tax_loop_radius' );
$shadow = impeka_grve_option( 'portfolio_tax_loop_shadow' );
$image_effect = impeka_grve_option( 'portfolio_tax_loop_image_effect' );

$indicator = impeka_grve_option( 'portfolio_tax_indicator' );
$indicator_text = impeka_grve_option( 'portfolio_tax_indicator_text' );
$indicator_color = impeka_grve_option( 'portfolio_tax_indicator_color' );

$overlay_opacity = ( '0' == $overlay_opacity ) ? 'none' : $overlay_opacity;
?>
<!-- CONTENT -->
<div id="grve-content" <?php impeka_grve_content_class(); ?>>
	<div class="grve-content-wrapper">
		<!-- MAIN CONTENT -->
		<div id="grve-main-content">
			<div class="grve-main-content-wrapper clearfix">
				<div class="grve-section" style="margin-bottom: 0px;">
					<div class="grve-container">
						<div <?php echo implode( ' ', $wrapper_attributes ); ?>>
						<?php
							if ( have_posts() ) :
						?>
							<div class="grve-isotope-container">
								<div class="grve-grid-sizer"></div>
						<?php
									// Start the Loop.
									$portfolio_index = 0;
									while ( have_posts() ) : the_post();

										$portfolio_index++;

										$portfolio_classes = array( 'grve-isotope-item-inner' );

										//Image Size
										if ( 'masonry' == $mode ) {
											if ( 'auto' == $masonry_image_mode ) {
												$columns = impeka_grve_option( 'portfolio_tax_columns', '3' );
												$grve_masonry_data = impeka_grve_get_masonry_data( $portfolio_index, $columns );
												$portfolio_classes[] = $grve_masonry_data['class'];
												$image_size = $grve_masonry_data['image_size'];
											} elseif( 'custom' == $masonry_image_mode ) {
												$masonry_size = get_post_meta( get_the_ID(), '_impeka_grve_portfolio_media_masonry_size', true );
												$grve_masonry_data = impeka_grve_get_custom_masonry_data( $masonry_size );
												$portfolio_classes[] = $grve_masonry_data['class'];
												$image_size = $grve_masonry_data['image_size'];
											} else {
												$image_size = impeka_grve_get_image_size( $masonry_image_mode );
												$portfolio_classes[] = 'grve-image-square';
											}
										} else {
											$image_size = impeka_grve_get_image_size( $grid_image_mode );
										}
										$portfolio_class = implode( ' ', $portfolio_classes );

										//Title and Caption
										$caption = $title = '';
										if ( 'none' != $title_caption && 'caption-only' != $title_caption ) {
											$title = get_the_title();
										}
										if ( 'none' != $title_caption && 'title-only' != $title_caption ) {
											$caption = get_post_meta( get_the_ID(), '_impeka_grve_description', true );
										}

										$link_atts = array();
										$link_atts[] = 'class="grve-item-url"';
										$link_atts[] = 'href="' . esc_url( get_permalink() ) . '"';

										//Portfolio Custom Overview
										$current_title_color = $title_color;
										$current_title_bg_color = $title_bg_color;
										$current_overlay_color = $overlay_color;
										$current_overlay_opacity = $overlay_opacity;
										$current_title_heading = $title_heading;
										if ( 'custom-overview' == $overview_type ) {
											$overview_mode = get_post_meta( get_the_ID(), '_impeka_grve_portfolio_overview_mode', true );
											if ( 'color' == $overview_mode ) {
												$overview_text = get_post_meta( get_the_ID(), '_impeka_grve_portfolio_overview_text', true );
												$overview_text_heading = get_post_meta( get_the_ID(), '_impeka_grve_portfolio_overview_text_heading', true );

												$overview_color = get_post_meta( get_the_ID(), '_impeka_grve_portfolio_overview_color', true );
												$overview_overlay_color = get_post_meta( get_the_ID(), '_impeka_grve_portfolio_overview_overlay_color', true );
												$overview_overlay_opacity = get_post_meta( get_the_ID(), '_impeka_grve_portfolio_overview_overlay_opacity', true );

												$current_title_color = !empty( $overview_color ) ? $overview_color : 'black';
												$current_title_bg_color = "transparent";
												$current_overlay_color = !empty( $overview_overlay_color ) ? $overview_overlay_color : 'primary-1';
												$current_overlay_opacity = !empty( $overview_overlay_opacity ) ? $overview_overlay_opacity : '90';
												$current_title_heading = !empty( $overview_text_heading ) ? $overview_text_heading  : $title_heading;

												$title = !empty( $overview_text ) ? $overview_text : $title;
												if ( !empty( $overview_text ) ) {
													$caption = '';
												}
											}
										}
										$current_overlay_opacity = ( '0' == $current_overlay_opacity ) ? 'none' : $current_overlay_opacity;

										$portfolio_params = array(
											'element' => 'portfolio',
											'link_atts' => $link_atts,
											'style' => $style,
											'overlay_color' => $current_overlay_color,
											'overlay_opacity' => $current_overlay_opacity,
											'title' => $title,
											'title_heading_tag' => $title_heading_tag,
											'title_heading' => $current_title_heading,
											'title_color' => $current_title_color,
											'title_bg_color' => $current_title_bg_color,
											'caption' => $caption,
											'text_color' => $text_color,
											'text_bg_color' => $text_bg_color,
											'radius' => $radius,
											'shadow' => $shadow,
											'image_effect' => $image_effect,
											'image_size' => $image_size,
											'image_atts' => array( 'data-column-space' => '100' ),
											'indicator' => $indicator,
											'indicator_text' => $indicator_text,
											'indicator_color' => $indicator_color,
										);
						?>
										<div <?php post_class(); ?>>
											<div class="<?php echo esc_attr( $portfolio_class ); ?>">
												<?php get_template_part( 'templates/hover-item/hover-' . $style, '', $portfolio_params ); ?>
											</div>
										</div>
						<?php

									endwhile;
						?>
									</div>
						<?php
								// Previous/next post navigation.
								impeka_grve_paginate_links( 'portfolio_tax' );
							else :
								// If no content, include the "No posts found" template.
								get_template_part( 'content', 'none' );
							endif;
						?>
						</div>
					</div>
				</div>
			</div>
		</div>
		<!-- End Content -->
		<?php get_sidebar(); ?>
	</div>
</div>
