<?php
/*
*	Loop Post Leader Template
*
* 	@version	1.0
* 	@author		Greatives Team
* 	@URI		https://greatives.eu
*/

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

$blog_params = isset( $args ) ? $args : array();

$show_date = impeka_grve_is_enabled( impeka_grve_array_value( $blog_params, 'date_visibility'  ) );
$overlay_color = impeka_grve_array_value( $blog_params, 'overlay_color' );
$overlay_opacity = impeka_grve_array_value( $blog_params, 'overlay_opacity' );
$heading_tag = impeka_grve_array_value( $blog_params, 'heading_tag', 'h2' );
$heading = impeka_grve_array_value( $blog_params, 'heading', 'h2' );
$animation = impeka_grve_array_value( $blog_params, 'animation' );
$animation_delay = impeka_grve_array_value( $blog_params, 'animation_delay' );
$animation_duration = impeka_grve_array_value( $blog_params, 'animation_duration' );

//Inner Wrapper
$inner_attributes = array();
$inner_classes = array( 'grve-blog-item-inner' );
if ( !empty( $animation ) ) {
	$inner_classes[] = 'grve-animated-item';
	$inner_attributes[] = 'data-animation="' . esc_attr( $animation ) . '"';
	$inner_attributes[] = 'data-delay="' . esc_attr( $animation_delay ) . '"';
	$inner_attributes[] = 'data-duration="' . esc_attr( $animation_duration ) . '"';
}
$inner_class_string = implode( ' ', $inner_classes );
$inner_attributes[] = 'class="' . esc_attr( $inner_class_string ) . '"';

?>
<article <?php post_class(); ?> itemscope itemType="http://schema.org/BlogPosting">
	<div <?php echo implode( ' ', $inner_attributes ); ?>>
		<?php
			$bg_options = array(
				'bg_color' => $overlay_color,
				'overlay_opacity' => $overlay_opacity,
			);
			impeka_grve_print_post_bg_image_container( $bg_options );
		?>
		<a class="grve-item-url" href="<?php echo esc_url( get_permalink() ); ?>" rel="bookmark"></a>
		<div class="grve-post-content">
			<div class="grve-post-content-inner">
				<?php impeka_grve_print_post_icon_format( get_post_format() ); ?>
				<?php if ( 'yes' == $show_date ) { ?>
					<div class="grve-post-date grve-small-text"><span><?php impeka_grve_print_post_loop_meta( 'date' ); ?></span></div>
				<?php } ?>
				<?php the_title( '<' . tag_escape( $heading_tag ) . ' class="grve-post-title grve-' . esc_attr( $heading ) . '" itemprop="headline">', '</' . tag_escape( $heading_tag ) . '>' ); ?>

				<?php impeka_grve_print_post_excerpt( $blog_params ); ?>
			</div>
		</div>
		<?php get_template_part( 'templates/post/meta/loop-post-meta-style-3', get_post_format(), $blog_params ); ?>
	</div>
	<?php impeka_grve_print_post_structured_data(); ?>
</article>
